# rules to make a distribution tarball from a svn repo
# Copyright (c) 2008-2009 Roy Marples <roy@marples.name>

GITREF?=	HEAD
DISTPREFIX?=	${PROG}-${VERSION}
DISTFILE?=	${DISTPREFIX}.tar.bz2

CLEANFILES+=	*.tar.bz2

_VERSION_SH=	sed -n 's/\#define VERSION[[:space:]]*"\(.*\)".*/\1/p' config.h
_VERSION!=	${_VERSION_SH}
VERSION=	${_VERSION}$(shell ${_VERSION_SH})

_SNAP_SH=	date -u +%Y%m%d%H%M
_SNAP!=		${_SNAP_SH}
SNAP=		${_SNAP}$(shell ${_SNAP_SH})
SNAPDIR=	${DISTPREFIX}-${SNAP}
SNAPFILE=	${SNAPDIR}.tar.bz2

dist:
	git archive --prefix=${DISTPREFIX}/ ${GITREF} | bzip2 > ${DISTFILE}

snapshot:
	mkdir /tmp/${SNAPDIR}
	cp -RPp * /tmp/${SNAPDIR}
	(cd /tmp/${SNAPDIR}; make clean)
	find /tmp/${SNAPDIR} -name .svn -exec rm -rf -- {} \; 2>/dev/null || true
	tar -cvjpf ${SNAPFILE} -C /tmp ${SNAPDIR}
	rm -rf /tmp/${SNAPDIR}
	ls -l ${SNAPFILE}

snap: snapshot

import-bsd:
	rm -rf /tmp/${DISTPREFIX}/
	git checkout-index -a --prefix=/tmp/${DISTPREFIX}/
	cd /tmp/${DISTPREFIX}; rm -rf .gitignore Makefile mk \
		if-linux.c if-linux-wireless.c lpf.c \
		dhcpcd-hooks/Makefile dhcpcd-hooks/50-dhcpcd-compat \
		dhcpcd-hooks/50-yp.conf

import: import-bsd
