/*
 * include/asm-sh/machvec.h
 *
 * Copyright 2000 Stuart Menefy (stuart.menefy@st.com)
 *
 * May be copied or modified under the terms of the GNU General Public
 * License.  See linux/COPYING for more information.
 */

#ifndef _ASM_SH_MACHVEC_H
#define _ASM_SH_MACHVEC_H 1

#include <linux/types.h>
#include <linux/time.h>

struct device;

struct sh_machine_vector {
	int mv_nr_irqs;

	__u8 (*mv_inb)(unsigned long);
	__u16 (*mv_inw)(unsigned long);
	__u32 (*mv_inl)(unsigned long);
	void (*mv_outb)(__u8, unsigned long);
	void (*mv_outw)(__u16, unsigned long);
	void (*mv_outl)(__u32, unsigned long);

	__u8 (*mv_inb_p)(unsigned long);
	__u16 (*mv_inw_p)(unsigned long);
	__u32 (*mv_inl_p)(unsigned long);
	void (*mv_outb_p)(__u8, unsigned long);
	void (*mv_outw_p)(__u16, unsigned long);
	void (*mv_outl_p)(__u32, unsigned long);

	void (*mv_insb)(unsigned long, void *dst, unsigned long count);
	void (*mv_insw)(unsigned long, void *dst, unsigned long count);
	void (*mv_insl)(unsigned long, void *dst, unsigned long count);
	void (*mv_outsb)(unsigned long, const void *src, unsigned long count);
	void (*mv_outsw)(unsigned long, const void *src, unsigned long count);
	void (*mv_outsl)(unsigned long, const void *src, unsigned long count);

	__u8 (*mv_readb)(void  *);
	__u16 (*mv_readw)(void  *);
	__u32 (*mv_readl)(void  *);
	void (*mv_writeb)(__u8, void  *);
	void (*mv_writew)(__u16, void  *);
	void (*mv_writel)(__u32, void  *);

	int (*mv_irq_demux)(int irq);

	void (*mv_init_irq)(void);
	void (*mv_init_pci)(void);

	void (*mv_heartbeat)(void);

	void *(*mv_consistent_alloc)(struct device *, size_t, dma_addr_t *, gfp_t);
	int (*mv_consistent_free)(struct device *, size_t, void *, dma_addr_t);

	void  *(*mv_ioport_map)(unsigned long port, unsigned int size);
	void (*mv_ioport_unmap)(void  *);
};

extern struct sh_machine_vector sh_mv;

#endif /* _ASM_SH_MACHVEC_H */
