#ifndef _LINUX_SECCOMP_H
#define _LINUX_SECCOMP_H

#ifdef CONFIG_SECCOMP

#define NR_SECCOMP_MODES 1

#include <asm/seccomp.h>

typedef struct { int mode; } seccomp_t;

extern void __secure_computing(int);
static __inline__ void secure_computing(int this_syscall)
{
	if (unlikely(test_thread_flag(TIF_SECCOMP)))
		__secure_computing(this_syscall);
}

static __inline__ int has_secure_computing(struct thread_info *ti)
{
	return unlikely(test_ti_thread_flag(ti, TIF_SECCOMP));
}

#else /* CONFIG_SECCOMP */

typedef struct { } seccomp_t;

#define secure_computing(x) do { } while (0)
/* static __inline__ to preserve typechecking */
static __inline__ int has_secure_computing(struct thread_info *ti)
{
	return 0;
}

#endif /* CONFIG_SECCOMP */

#endif /* _LINUX_SECCOMP_H */
