/*
 * Trivial I/O routine definitions, intentionally meant to be included
 * multiple times. Ugly I/O routine concatenation helpers taken from
 * alpha. Must be included _before_ io.h to avoid preprocessor-induced
 * routine mismatch.
 */
#define IO_CONCAT(a,b)	_IO_CONCAT(a,b)
#define _IO_CONCAT(a,b)	a ## _ ## b

#ifndef __IO_PREFIX
#error "Don't include this header without a valid system prefix"
#endif

__u8 IO_CONCAT(__IO_PREFIX,inb)(unsigned long);
__u16 IO_CONCAT(__IO_PREFIX,inw)(unsigned long);
__u32 IO_CONCAT(__IO_PREFIX,inl)(unsigned long);

void IO_CONCAT(__IO_PREFIX,outb)(__u8, unsigned long);
void IO_CONCAT(__IO_PREFIX,outw)(__u16, unsigned long);
void IO_CONCAT(__IO_PREFIX,outl)(__u32, unsigned long);

__u8 IO_CONCAT(__IO_PREFIX,inb_p)(unsigned long);
__u16 IO_CONCAT(__IO_PREFIX,inw_p)(unsigned long);
__u32 IO_CONCAT(__IO_PREFIX,inl_p)(unsigned long);
void IO_CONCAT(__IO_PREFIX,outb_p)(__u8, unsigned long);
void IO_CONCAT(__IO_PREFIX,outw_p)(__u16, unsigned long);
void IO_CONCAT(__IO_PREFIX,outl_p)(__u32, unsigned long);

void IO_CONCAT(__IO_PREFIX,insb)(unsigned long, void *dst, unsigned long count);
void IO_CONCAT(__IO_PREFIX,insw)(unsigned long, void *dst, unsigned long count);
void IO_CONCAT(__IO_PREFIX,insl)(unsigned long, void *dst, unsigned long count);
void IO_CONCAT(__IO_PREFIX,outsb)(unsigned long, const void *src, unsigned long count);
void IO_CONCAT(__IO_PREFIX,outsw)(unsigned long, const void *src, unsigned long count);
void IO_CONCAT(__IO_PREFIX,outsl)(unsigned long, const void *src, unsigned long count);

__u8 IO_CONCAT(__IO_PREFIX,readb)(void  *);
__u16 IO_CONCAT(__IO_PREFIX,readw)(void  *);
__u32 IO_CONCAT(__IO_PREFIX,readl)(void  *);
void IO_CONCAT(__IO_PREFIX,writeb)(__u8, void  *);
void IO_CONCAT(__IO_PREFIX,writew)(__u16, void  *);
void IO_CONCAT(__IO_PREFIX,writel)(__u32, void  *);

void *IO_CONCAT(__IO_PREFIX,ioremap)(unsigned long offset, unsigned long size);
void IO_CONCAT(__IO_PREFIX,iounmap)(void *addr);

void  *IO_CONCAT(__IO_PREFIX,ioport_map)(unsigned long addr, unsigned int size);
void IO_CONCAT(__IO_PREFIX,ioport_unmap)(void  *addr);

#undef __IO_PREFIX
