SIEVE SUPPORT

Last updated: 27 October 1998 rcg




There are 4 main components for Sieve support:
    o  Platform-independent Sieve engine
    o  Unix Delivery agent
    o  Unix Sieve ACAP Daemon
    o  Sieve GUI


Sieve Engine
----- ------

The Sieve engine is platform independent, and conforms to 
draft-showalter-sieve-03.txt, except for (a) REJECT action not 
implemented, and (b) wildcard searching not implemented (I plan on 
adding Henry Spencer's regexp code).  In addition, I've added support 
for envelope matching, and adding extra headers.  The envelope 
extension adds 'envelope.rcpt' and 'envelope.from' tests.  The MARK 
extension adds an extra header to the message.  The text can optionally 
contain ^f, which is replaced with the envelope return path, and/or ^r, 
which is replaced with the envelope recipient.

The Sieve engine consists of three primary modules: a Sieve parser, the 
actual Sieve execution, and a module which allocates and deallocates 
structures used by both.  The Sieve parser uses a platform-independent 
scanner/parser (called skanx), which also includes some string-handling 
functions (for portability).  Extensive tracing is available; the code 
expects have available a callback function to write trace entries.

The Sieve engine has hooks to allow for parsed Sieve scripts to be 
cached in memory (or on disk), but this is not yet implemented; 
currently each mail message causes the script to be parsed into 
structures, executed, and the structures released.

Sieve parsing and execution are separated for two main reasons: to 
allow for syntax errors to be detected before any execution has begun, 
and to allow for caching.

The Sieve engine is called by a delivery agent, using the Delivery 
Agent API (DAA, pronounced "duh").  The incoming message envelope and 
headers, and optionally all or the start of the body, are parsed into 
structures.  These structures are passed to the Sieve engine.  The 
Sieve engine expects various call-back functions to be available at 
link time.  These call-backs handle either utility tasks (such as 
address parsing), or platform-specific actions (such as generating a 
reply or setting the IMAP delivery folder).

The Sieve engine expects to read the Sieve script from a file.  It is 
passed the full path to the file, and opens it (using standard C).  It 
knows nothing of file system specifics.

The Sieve engine includes calls to simply parse (not execute) a Sieve 
script, to check for syntax errors.   Parse-time errors and warnings 
are returned in the Sieve structure, as integers (count of 
errors/warnings) and strings (specifics of errors/warnings, in the 
format specified by draft-gellens-acap-acnt-00.txt).

The Sieve engine has been running on Windows-NT for some months now.


Unix Delivery Agent
---- -------- -----

The Unix delivery agent parses the message headers into the DAA-defined 
structures, calls Sieve, and depending on the return value, either 
delivers or discards the message.

Current limitations:
    1) The envelope originator MUST be specified, with -f on the command line.
    2) Tracing/logging call-back not yet implemented.
    3) Reply, forward callbacks not yet implemented.
    4) Context stuct get assigned empty strings for envelope originator
       and recipient.
    5) No file locking yet on sieve script.  (Will be implemented using
       dot-locking in the same fashion as sievead.)
    6) Doesn't always write to mailbox correctly.  Messages get
       appended to others.


Unix Sieve ACAP Daemon
---- ----- ---- -----

The Sieve ACAP Daemon (sievead, pronouned "seh'-vee-ad" or 
"seh-vee'-ad") listens on the ACAP port (674), or a specified port (we 
will apply for one when we publish an I-D on this), and implements just 
enough ACAP to allow a client to retrieve or store a Sieve script, as 
specified in draft-gellens-acap-acnt-00.txt (that is, using attribute 
'account.sieve.script').  The Daemon reads and writes the Sieve script 
locally to "~/.sieve_script", using standard dot-file locking as the 
*only* file-locking mechanism (no flock() calls).

The Unix sievead is currently working.


Sieve GUI
----- ---

There is a Windows Sieve GUI, and an HTML/Perl based GUI, both of which 
allow users to easily create, delete, and modify simple Sieve rules. 
Based on the Eudora filters interface, the GUI presents a list of 
rules, each of which can have one or two conditions, and up to four 
actions.  Only a very limited subset of Sieve is used, to keep things 
simple.

The Windows GUI includes an edit box, so power users can roll their 
own, using Sieve syntax.

The Windows GUI calls the Sieve engine parser.  It also writes a Sieve 
script as a standardized set of comments at the file head.  Only Sieve 
syntax which fits into the GUI is written as comments.  The comments 
use the same syntax as the filters files in Eudora.  The HTML/Perl GUI 
also reads and writes these comments.  The Windows GUI processes the 
actual Sieve, and generates the comments as well.  The HTML/Perl GUI 
reads and writes the comments, but ignores the actual Sieve syntax.

The Windows GUI is usable, but the HTML/Perl code still needs to have 
authentication integrated into it, and needs more extensive testing.

Current Limitations:
    1. The Windows client currently stores authentication and server
       data, *including the password*, in cleartext in the Registry.
