; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

define i32 @atomicrmw_add_no_op(ptr align 4 %ptr, i32 %val) {
; CHECK-LABEL: define i32 @atomicrmw_add_no_op(
; CHECK-SAME: ptr nofree noundef nonnull align 4 captures(none) dereferenceable(4) [[PTR:%.*]], i32 [[VAL:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[RESULT:%.*]] = atomicrmw add ptr [[PTR]], i32 [[VAL]] seq_cst, align 4
; CHECK-NEXT:    ret i32 [[RESULT]]
;
  %result = atomicrmw add ptr %ptr, i32 %val seq_cst, align 4
  ret i32 %result
}

; Check that the aligment increases to 8
define i32 @atomicrmw_add_propagate(ptr align 8 %ptr, i32 %val) {
; CHECK-LABEL: define i32 @atomicrmw_add_propagate(
; CHECK-SAME: ptr nofree noundef nonnull align 8 captures(none) dereferenceable(4) [[PTR:%.*]], i32 [[VAL:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[RESULT:%.*]] = atomicrmw add ptr [[PTR]], i32 [[VAL]] seq_cst, align 8
; CHECK-NEXT:    ret i32 [[RESULT]]
;
  %result = atomicrmw add ptr %ptr, i32 %val seq_cst, align 2
  ret i32 %result
}

; Should increase alignment to 8, not 16.
define ptr @atomicrmw_non_ptr_op_no_propagate(ptr %ptr, ptr align 16 %val) {
; CHECK-LABEL: define ptr @atomicrmw_non_ptr_op_no_propagate(
; CHECK-SAME: ptr nofree noundef nonnull align 2 captures(none) dereferenceable(8) [[PTR:%.*]], ptr nofree align 16 [[VAL:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[RESULT:%.*]] = atomicrmw xchg ptr [[PTR]], ptr [[VAL]] seq_cst, align 2
; CHECK-NEXT:    ret ptr [[RESULT]]
;
  %result = atomicrmw xchg ptr %ptr, ptr %val seq_cst, align 2
  ret ptr %result
}

define i32 @cmpxchg_propagate(ptr align 8 %ptr, i32 %cmp, i32 %val) {
; CHECK-LABEL: define i32 @cmpxchg_propagate(
; CHECK-SAME: ptr nofree noundef nonnull align 8 captures(none) dereferenceable(4) [[PTR:%.*]], i32 [[CMP:%.*]], i32 [[VAL:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[PAIR:%.*]] = cmpxchg ptr [[PTR]], i32 [[CMP]], i32 [[VAL]] seq_cst monotonic, align 8
; CHECK-NEXT:    [[RESULT:%.*]] = extractvalue { i32, i1 } [[PAIR]], 0
; CHECK-NEXT:    ret i32 [[RESULT]]
;
  %pair = cmpxchg ptr %ptr, i32 %cmp, i32 %val seq_cst monotonic, align 2
  %result = extractvalue { i32, i1 } %pair, 0
  ret i32 %result
}

; Should not increase alignment
define ptr @cmpxchg_no_propagate(ptr %ptr, ptr align 16 %cmp, ptr align 32 %val) {
; CHECK-LABEL: define ptr @cmpxchg_no_propagate(
; CHECK-SAME: ptr nofree noundef nonnull align 2 captures(none) dereferenceable(8) [[PTR:%.*]], ptr nofree align 16 [[CMP:%.*]], ptr nofree align 32 [[VAL:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[PAIR:%.*]] = cmpxchg ptr [[PTR]], ptr [[CMP]], ptr [[VAL]] seq_cst monotonic, align 2
; CHECK-NEXT:    [[RESULT:%.*]] = extractvalue { ptr, i1 } [[PAIR]], 0
; CHECK-NEXT:    ret ptr [[RESULT]]
;
  %pair = cmpxchg ptr %ptr, ptr %cmp, ptr %val seq_cst monotonic, align 2
  %result = extractvalue { ptr, i1 } %pair, 0
  ret ptr %result
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CGSCC: {{.*}}
; TUNIT: {{.*}}
