// RUN: llvm-mc -triple=amdgcn -mcpu=bonaire -show-encoding %s | FileCheck %s

flat_load_ubyte v5, v[1:2]
// CHECK: [0x00,0x00,0x20,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte v255, v[1:2]
// CHECK: [0x00,0x00,0x20,0xdc,0x01,0x00,0x00,0xff]

flat_load_ubyte v5, v[254:255]
// CHECK: [0x00,0x00,0x20,0xdc,0xfe,0x00,0x00,0x05]

flat_load_ubyte v5, v[1:2] glc
// CHECK: [0x00,0x00,0x21,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte v5, v[1:2] slc
// CHECK: [0x00,0x00,0x22,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte v5, v[1:2]
// CHECK: [0x00,0x00,0x24,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte v255, v[1:2]
// CHECK: [0x00,0x00,0x24,0xdc,0x01,0x00,0x00,0xff]

flat_load_sbyte v5, v[254:255]
// CHECK: [0x00,0x00,0x24,0xdc,0xfe,0x00,0x00,0x05]

flat_load_sbyte v5, v[1:2] glc
// CHECK: [0x00,0x00,0x25,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte v5, v[1:2] slc
// CHECK: [0x00,0x00,0x26,0xdc,0x01,0x00,0x00,0x05]

flat_load_ushort v5, v[1:2]
// CHECK: [0x00,0x00,0x28,0xdc,0x01,0x00,0x00,0x05]

flat_load_ushort v255, v[1:2]
// CHECK: [0x00,0x00,0x28,0xdc,0x01,0x00,0x00,0xff]

flat_load_ushort v5, v[254:255]
// CHECK: [0x00,0x00,0x28,0xdc,0xfe,0x00,0x00,0x05]

flat_load_ushort v5, v[1:2] glc
// CHECK: [0x00,0x00,0x29,0xdc,0x01,0x00,0x00,0x05]

flat_load_ushort v5, v[1:2] slc
// CHECK: [0x00,0x00,0x2a,0xdc,0x01,0x00,0x00,0x05]

flat_load_sshort v5, v[1:2]
// CHECK: [0x00,0x00,0x2c,0xdc,0x01,0x00,0x00,0x05]

flat_load_sshort v255, v[1:2]
// CHECK: [0x00,0x00,0x2c,0xdc,0x01,0x00,0x00,0xff]

flat_load_sshort v5, v[254:255]
// CHECK: [0x00,0x00,0x2c,0xdc,0xfe,0x00,0x00,0x05]

flat_load_sshort v5, v[1:2] glc
// CHECK: [0x00,0x00,0x2d,0xdc,0x01,0x00,0x00,0x05]

flat_load_sshort v5, v[1:2] slc
// CHECK: [0x00,0x00,0x2e,0xdc,0x01,0x00,0x00,0x05]

flat_load_dword v5, v[1:2]
// CHECK: [0x00,0x00,0x30,0xdc,0x01,0x00,0x00,0x05]

flat_load_dword v255, v[1:2]
// CHECK: [0x00,0x00,0x30,0xdc,0x01,0x00,0x00,0xff]

flat_load_dword v5, v[254:255]
// CHECK: [0x00,0x00,0x30,0xdc,0xfe,0x00,0x00,0x05]

flat_load_dword v5, v[1:2] glc
// CHECK: [0x00,0x00,0x31,0xdc,0x01,0x00,0x00,0x05]

flat_load_dword v5, v[1:2] slc
// CHECK: [0x00,0x00,0x32,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx2 v[5:6], v[1:2]
// CHECK: [0x00,0x00,0x34,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx2 v[254:255], v[1:2]
// CHECK: [0x00,0x00,0x34,0xdc,0x01,0x00,0x00,0xfe]

flat_load_dwordx2 v[5:6], v[254:255]
// CHECK: [0x00,0x00,0x34,0xdc,0xfe,0x00,0x00,0x05]

flat_load_dwordx2 v[5:6], v[1:2] glc
// CHECK: [0x00,0x00,0x35,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx2 v[5:6], v[1:2] slc
// CHECK: [0x00,0x00,0x36,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx4 v[5:8], v[1:2]
// CHECK: [0x00,0x00,0x38,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx4 v[252:255], v[1:2]
// CHECK: [0x00,0x00,0x38,0xdc,0x01,0x00,0x00,0xfc]

flat_load_dwordx4 v[5:8], v[254:255]
// CHECK: [0x00,0x00,0x38,0xdc,0xfe,0x00,0x00,0x05]

flat_load_dwordx4 v[5:8], v[1:2] glc
// CHECK: [0x00,0x00,0x39,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx4 v[5:8], v[1:2] slc
// CHECK: [0x00,0x00,0x3a,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx3 v[5:7], v[1:2]
// CHECK: [0x00,0x00,0x3c,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx3 v[253:255], v[1:2]
// CHECK: [0x00,0x00,0x3c,0xdc,0x01,0x00,0x00,0xfd]

flat_load_dwordx3 v[5:7], v[254:255]
// CHECK: [0x00,0x00,0x3c,0xdc,0xfe,0x00,0x00,0x05]

flat_load_dwordx3 v[5:7], v[1:2] glc
// CHECK: [0x00,0x00,0x3d,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx3 v[5:7], v[1:2] slc
// CHECK: [0x00,0x00,0x3e,0xdc,0x01,0x00,0x00,0x05]

flat_store_byte v[1:2], v2
// CHECK: [0x00,0x00,0x60,0xdc,0x01,0x02,0x00,0x00]

flat_store_byte v[254:255], v2
// CHECK: [0x00,0x00,0x60,0xdc,0xfe,0x02,0x00,0x00]

flat_store_byte v[1:2], v255
// CHECK: [0x00,0x00,0x60,0xdc,0x01,0xff,0x00,0x00]

flat_store_byte v[1:2], v2 glc
// CHECK: [0x00,0x00,0x61,0xdc,0x01,0x02,0x00,0x00]

flat_store_byte v[1:2], v2 slc
// CHECK: [0x00,0x00,0x62,0xdc,0x01,0x02,0x00,0x00]

flat_store_short v[1:2], v2
// CHECK: [0x00,0x00,0x68,0xdc,0x01,0x02,0x00,0x00]

flat_store_short v[254:255], v2
// CHECK: [0x00,0x00,0x68,0xdc,0xfe,0x02,0x00,0x00]

flat_store_short v[1:2], v255
// CHECK: [0x00,0x00,0x68,0xdc,0x01,0xff,0x00,0x00]

flat_store_short v[1:2], v2 glc
// CHECK: [0x00,0x00,0x69,0xdc,0x01,0x02,0x00,0x00]

flat_store_short v[1:2], v2 slc
// CHECK: [0x00,0x00,0x6a,0xdc,0x01,0x02,0x00,0x00]

flat_store_dword v[1:2], v2
// CHECK: [0x00,0x00,0x70,0xdc,0x01,0x02,0x00,0x00]

flat_store_dword v[254:255], v2
// CHECK: [0x00,0x00,0x70,0xdc,0xfe,0x02,0x00,0x00]

flat_store_dword v[1:2], v255
// CHECK: [0x00,0x00,0x70,0xdc,0x01,0xff,0x00,0x00]

flat_store_dword v[1:2], v2 glc
// CHECK: [0x00,0x00,0x71,0xdc,0x01,0x02,0x00,0x00]

flat_store_dword v[1:2], v2 slc
// CHECK: [0x00,0x00,0x72,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x74,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x74,0xdc,0xfe,0x02,0x00,0x00]

flat_store_dwordx2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x74,0xdc,0x01,0xfe,0x00,0x00]

flat_store_dwordx2 v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x75,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x76,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx4 v[1:2], v[2:5]
// CHECK: [0x00,0x00,0x78,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx4 v[254:255], v[2:5]
// CHECK: [0x00,0x00,0x78,0xdc,0xfe,0x02,0x00,0x00]

flat_store_dwordx4 v[1:2], v[252:255]
// CHECK: [0x00,0x00,0x78,0xdc,0x01,0xfc,0x00,0x00]

flat_store_dwordx4 v[1:2], v[2:5] glc
// CHECK: [0x00,0x00,0x79,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx4 v[1:2], v[2:5] slc
// CHECK: [0x00,0x00,0x7a,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx3 v[1:2], v[2:4]
// CHECK: [0x00,0x00,0x7c,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx3 v[254:255], v[2:4]
// CHECK: [0x00,0x00,0x7c,0xdc,0xfe,0x02,0x00,0x00]

flat_store_dwordx3 v[1:2], v[253:255]
// CHECK: [0x00,0x00,0x7c,0xdc,0x01,0xfd,0x00,0x00]

flat_store_dwordx3 v[1:2], v[2:4] glc
// CHECK: [0x00,0x00,0x7d,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx3 v[1:2], v[2:4] slc
// CHECK: [0x00,0x00,0x7e,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_swap v[1:2], v2
// CHECK: [0x00,0x00,0xc0,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_swap v[254:255], v2
// CHECK: [0x00,0x00,0xc0,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_swap v[1:2], v255
// CHECK: [0x00,0x00,0xc0,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_swap v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xc1,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_swap v[1:2], v2 slc
// CHECK: [0x00,0x00,0xc2,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap v[1:2], v[2:3]
// CHECK: [0x00,0x00,0xc4,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap v[254:255], v[2:3]
// CHECK: [0x00,0x00,0xc4,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_cmpswap v[1:2], v[254:255]
// CHECK: [0x00,0x00,0xc4,0xdc,0x01,0xfe,0x00,0x00]

flat_atomic_cmpswap v0, v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0xc5,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0xc6,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_add v[1:2], v2
// CHECK: [0x00,0x00,0xc8,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_add v[254:255], v2
// CHECK: [0x00,0x00,0xc8,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_add v[1:2], v255
// CHECK: [0x00,0x00,0xc8,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_add v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xc9,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_add v[1:2], v2 slc
// CHECK: [0x00,0x00,0xca,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_sub v[1:2], v2
// CHECK: [0x00,0x00,0xcc,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_sub v[254:255], v2
// CHECK: [0x00,0x00,0xcc,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_sub v[1:2], v255
// CHECK: [0x00,0x00,0xcc,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_sub v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xcd,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_sub v[1:2], v2 slc
// CHECK: [0x00,0x00,0xce,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_smin v[1:2], v2
// CHECK: [0x00,0x00,0xd4,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_smin v[254:255], v2
// CHECK: [0x00,0x00,0xd4,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_smin v[1:2], v255
// CHECK: [0x00,0x00,0xd4,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_smin v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xd5,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_smin v[1:2], v2 slc
// CHECK: [0x00,0x00,0xd6,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_umin v[1:2], v2
// CHECK: [0x00,0x00,0xd8,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_umin v[254:255], v2
// CHECK: [0x00,0x00,0xd8,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_umin v[1:2], v255
// CHECK: [0x00,0x00,0xd8,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_umin v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xd9,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_umin v[1:2], v2 slc
// CHECK: [0x00,0x00,0xda,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_smax v[1:2], v2
// CHECK: [0x00,0x00,0xdc,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_smax v[254:255], v2
// CHECK: [0x00,0x00,0xdc,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_smax v[1:2], v255
// CHECK: [0x00,0x00,0xdc,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_smax v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xdd,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_smax v[1:2], v2 slc
// CHECK: [0x00,0x00,0xde,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_umax v[1:2], v2
// CHECK: [0x00,0x00,0xe0,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_umax v[254:255], v2
// CHECK: [0x00,0x00,0xe0,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_umax v[1:2], v255
// CHECK: [0x00,0x00,0xe0,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_umax v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xe1,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_umax v[1:2], v2 slc
// CHECK: [0x00,0x00,0xe2,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_and v[1:2], v2
// CHECK: [0x00,0x00,0xe4,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_and v[254:255], v2
// CHECK: [0x00,0x00,0xe4,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_and v[1:2], v255
// CHECK: [0x00,0x00,0xe4,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_and v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xe5,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_and v[1:2], v2 slc
// CHECK: [0x00,0x00,0xe6,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_or v[1:2], v2
// CHECK: [0x00,0x00,0xe8,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_or v[254:255], v2
// CHECK: [0x00,0x00,0xe8,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_or v[1:2], v255
// CHECK: [0x00,0x00,0xe8,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_or v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xe9,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_or v[1:2], v2 slc
// CHECK: [0x00,0x00,0xea,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_xor v[1:2], v2
// CHECK: [0x00,0x00,0xec,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_xor v[254:255], v2
// CHECK: [0x00,0x00,0xec,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_xor v[1:2], v255
// CHECK: [0x00,0x00,0xec,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_xor v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xed,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_xor v[1:2], v2 slc
// CHECK: [0x00,0x00,0xee,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_inc v[1:2], v2
// CHECK: [0x00,0x00,0xf0,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_inc v[254:255], v2
// CHECK: [0x00,0x00,0xf0,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_inc v[1:2], v255
// CHECK: [0x00,0x00,0xf0,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_inc v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xf1,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_inc v[1:2], v2 slc
// CHECK: [0x00,0x00,0xf2,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_dec v[1:2], v2
// CHECK: [0x00,0x00,0xf4,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_dec v[254:255], v2
// CHECK: [0x00,0x00,0xf4,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_dec v[1:2], v255
// CHECK: [0x00,0x00,0xf4,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_dec v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xf5,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_dec v[1:2], v2 slc
// CHECK: [0x00,0x00,0xf6,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_fcmpswap v[1:2], v[2:3]
// CHECK: [0x00,0x00,0xf8,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_fcmpswap v[254:255], v[2:3]
// CHECK: [0x00,0x00,0xf8,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_fcmpswap v[1:2], v[254:255]
// CHECK: [0x00,0x00,0xf8,0xdc,0x01,0xfe,0x00,0x00]

flat_atomic_fcmpswap v0, v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0xf9,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_fcmpswap v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0xfa,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_fmin v[1:2], v2
// CHECK: [0x00,0x00,0xfc,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_fmin v[254:255], v2
// CHECK: [0x00,0x00,0xfc,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_fmin v[1:2], v255
// CHECK: [0x00,0x00,0xfc,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_fmin v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xfd,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_fmin v[1:2], v2 slc
// CHECK: [0x00,0x00,0xfe,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_fmax v[1:2], v2
// CHECK: [0x00,0x00,0x00,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fmax v[254:255], v2
// CHECK: [0x00,0x00,0x00,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_fmax v[1:2], v255
// CHECK: [0x00,0x00,0x00,0xdd,0x01,0xff,0x00,0x00]

flat_atomic_fmax v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0x01,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fmax v[1:2], v2 slc
// CHECK: [0x00,0x00,0x02,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_swap_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x40,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_swap_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x40,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_swap_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x40,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_swap_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x41,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_swap_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x42,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap_x2 v[1:2], v[2:5]
// CHECK: [0x00,0x00,0x44,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap_x2 v[254:255], v[2:5]
// CHECK: [0x00,0x00,0x44,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_cmpswap_x2 v[1:2], v[252:255]
// CHECK: [0x00,0x00,0x44,0xdd,0x01,0xfc,0x00,0x00]

flat_atomic_cmpswap_x2 v[0:1], v[1:2], v[2:5] glc
// CHECK: [0x00,0x00,0x45,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap_x2 v[1:2], v[2:5] slc
// CHECK: [0x00,0x00,0x46,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x48,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x48,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_add_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x48,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_add_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x49,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x4a,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x4c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x4c,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_sub_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x4c,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_sub_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x4d,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x4e,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x54,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x54,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_smin_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x54,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_smin_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x55,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x56,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x58,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x58,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_umin_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x58,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_umin_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x59,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x5a,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x5c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x5c,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_smax_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x5c,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_smax_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x5d,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x5e,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x60,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x60,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_umax_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x60,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_umax_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x61,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x62,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x64,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x64,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_and_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x64,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_and_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x65,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x66,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x68,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x68,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_or_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x68,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_or_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x69,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x6a,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x6c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x6c,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_xor_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x6c,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_xor_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x6d,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x6e,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x70,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x70,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_inc_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x70,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_inc_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x71,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x72,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x74,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x74,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_dec_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x74,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_dec_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x75,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x76,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fcmpswap_x2 v[1:2], v[2:5]
// CHECK: [0x00,0x00,0x78,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fcmpswap_x2 v[254:255], v[2:5]
// CHECK: [0x00,0x00,0x78,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_fcmpswap_x2 v[1:2], v[252:255]
// CHECK: [0x00,0x00,0x78,0xdd,0x01,0xfc,0x00,0x00]

flat_atomic_fcmpswap_x2 v[0:1], v[1:2], v[2:5] glc
// CHECK: [0x00,0x00,0x79,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fcmpswap_x2 v[1:2], v[2:5] slc
// CHECK: [0x00,0x00,0x7a,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fmin_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x7c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fmin_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x7c,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_fmin_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x7c,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_fmin_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x7d,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fmin_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x7e,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fmax_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x80,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fmax_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x80,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_fmax_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x80,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_fmax_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x81,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fmax_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x82,0xdd,0x01,0x02,0x00,0x00]
