; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-- | FileCheck %s --check-prefixes=X86
; RUN: llc < %s -mtriple=x86_64-- | FileCheck %s --check-prefixes=X64

;
; fixed avg(x,y) = add(and(x,y),lshr(xor(x,y),1))
;
; lsb avg(x,y) = add(lshr(x,1),lshr(y,1),and(x,y,1))
;
; ext avg(x,y) = trunc(lshr(add(zext(x),zext(y)),1))
;

define i8 @test_fixed_i8(i8 %a0, i8 %a1) nounwind {
; X86-LABEL: test_fixed_i8:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    shrl %eax
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: test_fixed_i8:
; X64:       # %bb.0:
; X64-NEXT:    movzbl %sil, %ecx
; X64-NEXT:    movzbl %dil, %eax
; X64-NEXT:    addl %ecx, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %and = and i8 %a0, %a1
  %xor = xor i8 %a0, %a1
  %shift = lshr i8 %xor, 1
  %res = add i8 %and, %shift
  ret i8 %res
}

define i8 @test_lsb_i8(i8 %a0, i8 %a1) nounwind {
; X86-LABEL: test_lsb_i8:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    shrb %dl
; X86-NEXT:    andb %cl, %al
; X86-NEXT:    shrb %cl
; X86-NEXT:    addb %dl, %cl
; X86-NEXT:    andb $1, %al
; X86-NEXT:    addb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: test_lsb_i8:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shrb %al
; X64-NEXT:    andb %sil, %dil
; X64-NEXT:    shrb %sil
; X64-NEXT:    addb %sil, %al
; X64-NEXT:    andb $1, %dil
; X64-NEXT:    addb %dil, %al
; X64-NEXT:    retq
  %s0 = lshr i8 %a0, 1
  %s1 = lshr i8 %a1, 1
  %m0 = and i8 %a0, 1
  %m1 = and i8 %m0, %a1
  %r0 = add i8 %s0, %s1
  %r1 = add i8 %r0, %m1
  ret i8 %r1
}

define i8 @test_ext_i8(i8 %a0, i8 %a1) nounwind {
; X86-LABEL: test_ext_i8:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    shrl %eax
; X86-NEXT:    # kill: def $al killed $al killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: test_ext_i8:
; X64:       # %bb.0:
; X64-NEXT:    movzbl %sil, %ecx
; X64-NEXT:    movzbl %dil, %eax
; X64-NEXT:    addl %ecx, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %x0 = zext i8 %a0 to i16
  %x1 = zext i8 %a1 to i16
  %sum = add i16 %x0, %x1
  %shift = lshr i16 %sum, 1
  %res = trunc i16 %shift to i8
  ret i8 %res
}

define i16 @test_fixed_i16(i16 %a0, i16 %a1) nounwind {
; X86-LABEL: test_fixed_i16:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    shrl %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: test_fixed_i16:
; X64:       # %bb.0:
; X64-NEXT:    movzwl %si, %ecx
; X64-NEXT:    movzwl %di, %eax
; X64-NEXT:    addl %ecx, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %and = and i16 %a0, %a1
  %xor = xor i16 %a0, %a1
  %shift = lshr i16 %xor, 1
  %res = add i16 %and, %shift
  ret i16 %res
}

define i16 @test_lsb_i16(i16 %a0, i16 %a1) nounwind {
; X86-LABEL: test_lsb_i16:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    shrl %edx
; X86-NEXT:    andl %ecx, %eax
; X86-NEXT:    shrl %ecx
; X86-NEXT:    addl %edx, %ecx
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: test_lsb_i16:
; X64:       # %bb.0:
; X64-NEXT:    movzwl %si, %eax
; X64-NEXT:    movzwl %di, %ecx
; X64-NEXT:    shrl %ecx
; X64-NEXT:    shrl %eax
; X64-NEXT:    addl %ecx, %eax
; X64-NEXT:    andl %esi, %edi
; X64-NEXT:    andl $1, %edi
; X64-NEXT:    addl %edi, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %s0 = lshr i16 %a0, 1
  %s1 = lshr i16 %a1, 1
  %m0 = and i16 %a0, %a1
  %m1 = and i16 %m0, 1
  %r0 = add i16 %s0, %s1
  %r1 = add i16 %r0, %m1
  ret i16 %r1
}

define i16 @test_ext_i16(i16 %a0, i16 %a1) nounwind {
; X86-LABEL: test_ext_i16:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    shrl %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: test_ext_i16:
; X64:       # %bb.0:
; X64-NEXT:    movzwl %si, %ecx
; X64-NEXT:    movzwl %di, %eax
; X64-NEXT:    addl %ecx, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %x0 = zext i16 %a0 to i32
  %x1 = zext i16 %a1 to i32
  %sum = add i32 %x0, %x1
  %shift = lshr i32 %sum, 1
  %res = trunc i32 %shift to i16
  ret i16 %res
}

define i32 @test_fixed_i32(i32 %a0, i32 %a1) nounwind {
; X86-LABEL: test_fixed_i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    andl %ecx, %edx
; X86-NEXT:    xorl %ecx, %eax
; X86-NEXT:    shrl %eax
; X86-NEXT:    addl %edx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_fixed_i32:
; X64:       # %bb.0:
; X64-NEXT:    movl %esi, %ecx
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    addq %rcx, %rax
; X64-NEXT:    shrq %rax
; X64-NEXT:    # kill: def $eax killed $eax killed $rax
; X64-NEXT:    retq
  %and = and i32 %a0, %a1
  %xor = xor i32 %a1, %a0
  %shift = lshr i32 %xor, 1
  %res = add i32 %and, %shift
  ret i32 %res
}

define i32 @test_lsb_i32(i32 %a0, i32 %a1) nounwind {
; X86-LABEL: test_lsb_i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    shrl %edx
; X86-NEXT:    andl %ecx, %eax
; X86-NEXT:    shrl %ecx
; X86-NEXT:    addl %edx, %ecx
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_lsb_i32:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shrl %eax
; X64-NEXT:    andl %esi, %edi
; X64-NEXT:    shrl %esi
; X64-NEXT:    addl %esi, %eax
; X64-NEXT:    andl $1, %edi
; X64-NEXT:    addl %edi, %eax
; X64-NEXT:    retq
  %s0 = lshr i32 %a0, 1
  %s1 = lshr i32 %a1, 1
  %m0 = and i32 %a0, %a1
  %m1 = and i32 %m0, 1
  %r0 = add i32 %s0, %m1
  %r1 = add i32 %r0, %s1
  ret i32 %r1
}

define i32 @test_ext_i32(i32 %a0, i32 %a1) nounwind {
; X86-LABEL: test_ext_i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    andl %ecx, %edx
; X86-NEXT:    xorl %ecx, %eax
; X86-NEXT:    shrl %eax
; X86-NEXT:    addl %edx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_ext_i32:
; X64:       # %bb.0:
; X64-NEXT:    movl %esi, %ecx
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    addq %rcx, %rax
; X64-NEXT:    shrq %rax
; X64-NEXT:    # kill: def $eax killed $eax killed $rax
; X64-NEXT:    retq
  %x0 = zext i32 %a0 to i64
  %x1 = zext i32 %a1 to i64
  %sum = add i64 %x0, %x1
  %shift = lshr i64 %sum, 1
  %res = trunc i64 %shift to i32
  ret i32 %res
}

define i64 @test_fixed_i64(i64 %a0, i64 %a1) nounwind {
; X86-LABEL: test_fixed_i64:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    adcl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    setb %dl
; X86-NEXT:    movzbl %dl, %edx
; X86-NEXT:    shldl $31, %eax, %edx
; X86-NEXT:    shldl $31, %ecx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_fixed_i64:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    andq %rsi, %rax
; X64-NEXT:    xorq %rsi, %rdi
; X64-NEXT:    shrq %rdi
; X64-NEXT:    addq %rdi, %rax
; X64-NEXT:    retq
  %and = and i64 %a0, %a1
  %xor = xor i64 %a1, %a0
  %shift = lshr i64 %xor, 1
  %res = add i64 %and, %shift
  ret i64 %res
}

define i64 @test_lsb_i64(i64 %a0, i64 %a1) nounwind {
; X86-LABEL: test_lsb_i64:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl %edi, %ebx
; X86-NEXT:    shrl %ebx
; X86-NEXT:    shldl $31, %eax, %edi
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    shrl %edx
; X86-NEXT:    shldl $31, %esi, %ecx
; X86-NEXT:    addl %edi, %ecx
; X86-NEXT:    adcl %ebx, %edx
; X86-NEXT:    andl %esi, %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    addl %ecx, %eax
; X86-NEXT:    adcl $0, %edx
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
;
; X64-LABEL: test_lsb_i64:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rcx
; X64-NEXT:    shrq %rcx
; X64-NEXT:    andl %esi, %edi
; X64-NEXT:    movq %rsi, %rax
; X64-NEXT:    shrq %rax
; X64-NEXT:    addq %rcx, %rax
; X64-NEXT:    andl $1, %edi
; X64-NEXT:    addq %rdi, %rax
; X64-NEXT:    retq
  %s0 = lshr i64 %a0, 1
  %s1 = lshr i64 %a1, 1
  %s = add i64 %s1, %s0
  %m0 = and i64 %a0, 1
  %m1 = and i64 %m0, %a1
  %res = add i64 %s, %m1
  ret i64 %res
}

define i64 @test_ext_i64(i64 %a0, i64 %a1) nounwind {
; X86-LABEL: test_ext_i64:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    adcl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    setb %dl
; X86-NEXT:    movzbl %dl, %edx
; X86-NEXT:    shldl $31, %eax, %edx
; X86-NEXT:    shldl $31, %ecx, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_ext_i64:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    andq %rsi, %rax
; X64-NEXT:    xorq %rsi, %rdi
; X64-NEXT:    shrq %rdi
; X64-NEXT:    addq %rdi, %rax
; X64-NEXT:    retq
  %x0 = zext i64 %a0 to i128
  %x1 = zext i64 %a1 to i128
  %sum = add i128 %x0, %x1
  %shift = lshr i128 %sum, 1
  %res = trunc i128 %shift to i64
  ret i64 %res
}
