; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11,GFX11-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX11,GFX11-GISEL %s

declare void @llvm.amdgcn.s.ttracedata(i32)
declare void @llvm.amdgcn.s.ttracedata.imm(i16)

define amdgpu_cs void @ttracedata_c() {
; GFX11-LABEL: ttracedata_c:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_mov_b32 m0, 0xf4240
; GFX11-NEXT:    s_ttracedata
; GFX11-NEXT:    s_endpgm
  call void @llvm.amdgcn.s.ttracedata(i32 1000000)
  ret void
}

define amdgpu_cs void @ttracedata_s(i32 inreg %val) {
; GFX11-LABEL: ttracedata_s:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_mov_b32 m0, s0
; GFX11-NEXT:    s_ttracedata
; GFX11-NEXT:    s_endpgm
  call void @llvm.amdgcn.s.ttracedata(i32 %val)
  ret void
}

define amdgpu_cs void @ttracedata_v(i32 %val) {
; GFX11-LABEL: ttracedata_v:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-NEXT:    s_mov_b32 m0, s0
; GFX11-NEXT:    s_ttracedata
; GFX11-NEXT:    s_endpgm
  call void @llvm.amdgcn.s.ttracedata(i32 %val)
  ret void
}

define amdgpu_cs void @ttracedata_imm() {
; GFX11-LABEL: ttracedata_imm:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_ttracedata_imm 0x3e8
; GFX11-NEXT:    s_endpgm
  call void @llvm.amdgcn.s.ttracedata.imm(i16 1000)
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX11-GISEL: {{.*}}
; GFX11-SDAG: {{.*}}
