; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=arm64-linux-gnu | FileCheck %s
; RUN: llc < %s -global-isel -mtriple=arm64-linux-gnu | FileCheck %s --check-prefix=GISEL

@x1 = external hidden global [2 x i64]
@x2 = external hidden global [16777216 x i64]
@x3 = external hidden global { [9 x ptr], [8 x ptr] }

define i64 @f1() {
; CHECK-LABEL: f1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, x1+16
; CHECK-NEXT:    ldr x0, [x8, :lo12:x1+16]
; CHECK-NEXT:    ret
;
; GISEL-LABEL: f1:
; GISEL:       // %bb.0:
; GISEL-NEXT:    adrp x8, x1+16
; GISEL-NEXT:    ldr x0, [x8, :lo12:x1+16]
; GISEL-NEXT:    ret
  %l = load i64, ptr getelementptr ([2 x i64], ptr @x1, i64 0, i64 2)
  ret i64 %l
}

define i64 @f2() {
; CHECK-LABEL: f2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, x1
; CHECK-NEXT:    add x8, x8, :lo12:x1
; CHECK-NEXT:    ldr x0, [x8, #24]
; CHECK-NEXT:    ret
;
; GISEL-LABEL: f2:
; GISEL:       // %bb.0:
; GISEL-NEXT:    adrp x8, x1
; GISEL-NEXT:    add x8, x8, :lo12:x1
; GISEL-NEXT:    ldr x0, [x8, #24]
; GISEL-NEXT:    ret

  %l = load i64, ptr getelementptr ([2 x i64], ptr @x1, i64 0, i64 3)
  ret i64 %l
}

define i64 @f3() {
; CHECK-LABEL: f3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, x1+1
; CHECK-NEXT:    add x8, x8, :lo12:x1+1
; CHECK-NEXT:    ldr x0, [x8]
; CHECK-NEXT:    ret
;
; GISEL-LABEL: f3:
; GISEL:       // %bb.0:
; GISEL-NEXT:    adrp x8, x1+1
; GISEL-NEXT:    add x8, x8, :lo12:x1+1
; GISEL-NEXT:    ldr x0, [x8]
; GISEL-NEXT:    ret
  %l = load i64, ptr getelementptr (i8, ptr @x1, i64 1)
  ret i64 %l
}

define [2 x i64] @f4() {
; FIXME: GlobalISel misses the opportunity to form a LDP here.
;
; CHECK-LABEL: f4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, x2+8
; CHECK-NEXT:    add x8, x8, :lo12:x2+8
; CHECK-NEXT:    ldp x0, x1, [x8]
; CHECK-NEXT:    ret
;
; GISEL-LABEL: f4:
; GISEL:       // %bb.0:
; GISEL-NEXT:    adrp x8, x2+8
; GISEL-NEXT:    adrp x9, x2+8
; GISEL-NEXT:    add x9, x9, :lo12:x2+8
; GISEL-NEXT:    ldr x0, [x8, :lo12:x2+8]
; GISEL-NEXT:    ldr x1, [x9, #8]
; GISEL-NEXT:    ret
  %l = load [2 x i64], ptr getelementptr (i8, ptr @x2, i64 8)
  ret [2 x i64] %l
}

define i64 @f5() {
; CHECK-LABEL: f5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, x2+1048568
; CHECK-NEXT:    ldr x0, [x8, :lo12:x2+1048568]
; CHECK-NEXT:    ret
;
; GISEL-LABEL: f5:
; GISEL:       // %bb.0:
; GISEL-NEXT:    adrp x8, x2+1048568
; GISEL-NEXT:    ldr x0, [x8, :lo12:x2+1048568]
; GISEL-NEXT:    ret
  %l = load i64, ptr getelementptr ([16777216 x i64], ptr @x2, i64 0, i64 131071)
  ret i64 %l
}

define i64 @f6() {
; CHECK-LABEL: f6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #1048576
; CHECK-NEXT:    adrp x9, x2
; CHECK-NEXT:    add x9, x9, :lo12:x2
; CHECK-NEXT:    ldr x0, [x9, x8]
; CHECK-NEXT:    ret
;
; GISEL-LABEL: f6:
; GISEL:       // %bb.0:
; GISEL-NEXT:    mov w8, #1048576
; GISEL-NEXT:    adrp x9, x2
; GISEL-NEXT:    add x9, x9, :lo12:x2
; GISEL-NEXT:    ldr x0, [x9, x8]
; GISEL-NEXT:    ret
  %l = load i64, ptr getelementptr ([16777216 x i64], ptr @x2, i64 0, i64 131072)
  ret i64 %l
}

define i32 @f7() {
; CHECK-LABEL: f7:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, x3+108
; CHECK-NEXT:    ldr w0, [x8, :lo12:x3+108]
; CHECK-NEXT:    ret
;
; GISEL-LABEL: f7:
; GISEL:       // %bb.0: // %entry
; GISEL-NEXT:    adrp x8, x3+108
; GISEL-NEXT:    ldr w0, [x8, :lo12:x3+108]
; GISEL-NEXT:    ret

entry:
  %lshr = lshr i128 bitcast (<2 x i64> <i64 undef, i64 ptrtoint (ptr getelementptr inbounds ({ [9 x ptr], [8 x ptr] }, ptr @x3, i64 0, i32 1, i64 2) to i64)> to i128), 64
  %trunc = trunc i128 %lshr to i64
  %inttoptr = inttoptr i64 %trunc to ptr
  %gep = getelementptr i32, ptr %inttoptr, i64 5
  %l = load i32, ptr %gep
  ret i32 %l
}
