*+  PARSECON_TABINIT - Initialise parsing state-tables
      SUBROUTINE PARSECON_TABINIT ( STATUS )
*    Description :
*     Initialise the symbol state table which describes the syntax of the
*     interface file.
*    Invocation :
*     CALL PARSECON_TABINIT ( STATUS )
*    Parameters :
*     STATUS=INTEGER
*    Method :
*     The two tables storing the state-transitions are initialised so 
*     that all their entries correspond to error conditions. Then a series
*     of calls to PARSECON_TABSET is made, each one setting up one legal
*     situation. To determine whether a token is legal in a given context,
*     and what action to take, use PARSECON_TABENT.
*    Deficiencies :
*     <description of any deficiencies>
*    Bugs :
*     <description of any "bugs" which have not been fixed>
*    Authors :
*     W.F.Lupton (RGO)
*    History :
*     21.09.1984:  VAX version (REVAD::BDK)
*     23.08.1985:  handle monoliths (REVAD::BDK)
*     13.05.1986:  handle menus (REVAD::BDK)
*     05.05.1987:  allow monolith, action and parameter names to be 
*                  reserved words (REVAD::BDK)
*     05.05.1987:  add PPATH (REVAD::BDK)
*     26.05.1987:  add ACTEND action (REVAD::BDK)
*     10.11.1987:  allow parameter or action name to be a constant 
*                  (REVAD::BDK)
*     15.05.1990:  Add helpkey (RLVAD::AJC)
*     04.07.1990:  Add helplib in monolith or interface (RLVAD::AJC)
*     16.08.1990:  Allow name for ASSOCIATION
*                  Allow anything as TYPE or PTYPE
*                  ALLOW ANYTHING FOR PROMPT
*                  Allow PROMPT and DEFAULT on VPATH
*                  Allow DEFAULT on PPATH 
*                  Allow name or reserved word for HELPKEY (RLVAD::AJC)
*     17.10.1990:  Remove unused INCLUDE PARSECON_PAR (RLVAD::AJC)
*     12.11.1991:  Allow missing ENDINTERFACE (RLVAD::AJC)
*    endhistory
*    Type Definitions :
      IMPLICIT NONE
*    Global constants :
      INCLUDE 'SAE_PAR'
      INCLUDE 'PARSECON_PAR'

*    Status :
      INTEGER STATUS

*    Global variables :
      INCLUDE 'PARSECON_CMN'

*-

      IF ( STATUS .NE. SAI__OK ) RETURN

*
*   Load the tables with error conditions.
*
      CALL PARSECON_TABSTART ( STATUS )
*
*   Now load the valid states.
*   First, at the start INTERFACE, MONOLITH, ENDMONOLITH 
*   or HELPLIB is expected
*
      CALL PARSECON_TABSET ( START, IFACE, NONE, FACESTART )
      CALL PARSECON_TABSET ( START, MONOL, NONE, MONGOT )
      CALL PARSECON_TABSET ( START, EMONOL, ENDMON, FINISHED )
      CALL PARSECON_TABSET ( START, HELPLIB, SETHLIB, MHLPLB )
*
*   MONOLITH has been read. Expect a name (allow reserved word)
*
      CALL PARSECON_TABSET ( MONGOT, NAME, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, IFACE, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, EFACE, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, PARAM, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, EPARAM, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, ACTION, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, ENDACT, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, OBEY, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, ENDOBEY, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, CANCEL, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, ENDCANC, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, RANGE, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, IN, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, DEFAULT, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, TYPE, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, NEEDS, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, KEYWORD, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, POSITION, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, ACCESS, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, VPATH, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, HELP, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, HELPKEY, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, HELPLIB, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, PTYPE, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, ASSOC, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, PROGRAM, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, EPATH, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, MESSAGE, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, TEXT, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, EMESS, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, PROMPT, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, MONOL, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, EMONOL, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, MENU, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, COORDS, SETMON, START )
      CALL PARSECON_TABSET ( MONGOT, PPATH, SETMON, START )
*
*   INTERFACE has been read. Expect a name (allow a reserved word).
*
      CALL PARSECON_TABSET ( FACESTART, NAME, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, IFACE, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, EFACE, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, PARAM, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, EPARAM, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, ACTION, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, ENDACT, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, OBEY, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, ENDOBEY, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, CANCEL, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, ENDCANC, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, RANGE, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, IN, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, DEFAULT, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, TYPE, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, NEEDS, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, KEYWORD, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, POSITION, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, ACCESS, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, VPATH, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, HELP, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, HELPKEY, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, HELPLIB, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, PTYPE, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, ASSOC, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, PROGRAM, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, EPATH, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, MESSAGE, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, TEXT, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, EMESS, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, PROMPT, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, MONOL, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, EMONOL, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, MENU, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, COORDS, INAME, FACEGOT )
      CALL PARSECON_TABSET ( FACESTART, PPATH, INAME, FACEGOT )
*
*   HELPLIB definition outside an interface
*   expect a constant or a name (allow a reserved word).
*
      CALL PARSECON_TABSET ( MHLPLB, CONST, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, NAME, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, IFACE, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, EFACE, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, PARAM, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, EPARAM, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, ACTION, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, ENDACT, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, OBEY, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, ENDOBEY, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, CANCEL, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, ENDCANC, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, RANGE, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, IN, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, DEFAULT, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, TYPE, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, NEEDS, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, KEYWORD, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, POSITION, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, ACCESS, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, VPATH, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, HELP, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, HELPKEY, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, HELPLIB, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, PTYPE, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, ASSOC, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, PROGRAM, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, EPATH, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, MESSAGE, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, TEXT, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, EMESS, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, PROMPT, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, MONOL, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, EMONOL, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, MENU, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, COORDS, SETHLIB, START )
      CALL PARSECON_TABSET ( MHLPLB, PPATH, SETHLIB, START )
*
*   Are within interface definition. Expect ACTION, PARAMETER, 
*   ENDINTERFACE, PROGRAM, EPATH, HELPLIB or MESSAGE.
*
      CALL PARSECON_TABSET ( FACEGOT, EFACE, FACEND, FINISHED )
      CALL PARSECON_TABSET ( FACEGOT, PARAM, NONE, PARSTART )
      CALL PARSECON_TABSET ( FACEGOT, ACTION, NONE, ACTSTART )
      CALL PARSECON_TABSET ( FACEGOT, EPATH, NONE, EPSTART )
      CALL PARSECON_TABSET ( FACEGOT, HELPLIB, NONE, FHLPLB )
      CALL PARSECON_TABSET ( FACEGOT, MESSAGE, NONE, MESTART )
      CALL PARSECON_TABSET ( FACEGOT, PROGRAM, NONE, PROGSTART )
      CALL PARSECON_TABSET ( FACEGOT, IFACE, STFACE, FACESTART )
*
*   HELPLIB definition inside an interface.
*   Expect a name or constant (allow reserved word).
*
      CALL PARSECON_TABSET ( FHLPLB, CONST, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, NAME, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, IFACE, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, EFACE, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, PARAM, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, EPARAM, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, ACTION, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, ENDACT, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, OBEY, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, ENDOBEY, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, CANCEL, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, ENDCANC, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, RANGE, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, IN, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, DEFAULT, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, TYPE, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, NEEDS, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, KEYWORD, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, POSITION, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, ACCESS, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, VPATH, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, HELP, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, HELPKEY, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, HELPLIB, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, PTYPE, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, ASSOC, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, PROGRAM, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, EPATH, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, MESSAGE, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, TEXT, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, EMESS, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, PROMPT, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, MONOL, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, EMONOL, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, MENU, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, COORDS, SETHLIB, FACEGOT )
      CALL PARSECON_TABSET ( FHLPLB, PPATH, SETHLIB, FACEGOT )
*
*   Program declaration. Expect NAME or CONST (allow reserved word).
*
      CALL PARSECON_TABSET ( PROGSTART, NAME, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, CONST, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, IFACE, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, EFACE, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, PARAM, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, EPARAM, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, ACTION, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, ENDACT, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, OBEY, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, ENDOBEY, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, CANCEL, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, ENDCANC, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, RANGE, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, IN, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, DEFAULT, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, TYPE, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, NEEDS, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, KEYWORD, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, POSITION, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, ACCESS, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, VPATH, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, HELP, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, HELPKEY, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, HELPLIB, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, PTYPE, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, ASSOC, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, PROGRAM, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, EPATH, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, MESSAGE, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, TEXT, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, EMESS, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, PROMPT, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, MONOL, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, EMONOL, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, MENU, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, COORDS, PROG, FACEGOT )
      CALL PARSECON_TABSET ( PROGSTART, PPATH, PROG, FACEGOT )
*
*   EPATH declaration. Expect CONST.
*
      CALL PARSECON_TABSET ( EPSTART, CONST, EPDEC, FACEGOT )
*
*   MESSAGE declaration. Expect NAME (allow reserved word).
*
      CALL PARSECON_TABSET ( MESTART, NAME, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, IFACE, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, EFACE, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, PARAM, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, EPARAM, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, ACTION, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, ENDACT, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, OBEY, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, ENDOBEY, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, CANCEL, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, ENDCANC, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, RANGE, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, IN, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, DEFAULT, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, TYPE, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, NEEDS, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, KEYWORD, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, POSITION, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, ACCESS, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, VPATH, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, HELP, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, HELPKEY, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, HELPLIB, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, PTYPE, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, ASSOC, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, PROGRAM, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, EPATH, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, MESSAGE, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, TEXT, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, EMESS, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, PROMPT, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, MONOL, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, EMONOL, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, MENU, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, COORDS, NEWPAR, MESGOT )
      CALL PARSECON_TABSET ( MESTART, PPATH, NEWPAR, MESGOT )
*
*   Within message declaration. Expect TEXT or ENDMESSAGE.
*
      CALL PARSECON_TABSET ( MESGOT, TEXT, NONE, TEXTGOT )
      CALL PARSECON_TABSET ( MESGOT, EMESS, NONE, FACEGOT )
*
*   Getting message text. Expect CONST.
*
      CALL PARSECON_TABSET ( TEXTGOT, CONST, MESTEXT, MESGOT )
*
*   Start of PARAMETER definition. Expect NAME or CONST (allow reserved word).
*
      CALL PARSECON_TABSET ( PARSTART, NAME, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, CONST, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, IFACE, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, EFACE, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, PARAM, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, EPARAM, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, ACTION, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, ENDACT, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, OBEY, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, ENDOBEY, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, CANCEL, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, ENDCANC, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, RANGE, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, IN, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, DEFAULT, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, TYPE, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, NEEDS, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, KEYWORD, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, POSITION, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, ACCESS, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, VPATH, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, HELP, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, HELPKEY, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, HELPLIB, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, PTYPE, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, ASSOC, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, PROGRAM, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, EPATH, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, MESSAGE, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, TEXT, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, EMESS, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, PROMPT, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, MONOL, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, EMONOL, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, MENU, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, COORDS, NEWPAR, PARGOT )
      CALL PARSECON_TABSET ( PARSTART, PPATH, NEWPAR, PARGOT )
*
*   Within a parameter definition. Expect ENDPARAMETER or a parameter 
*   description.
*
      CALL PARSECON_TABSET ( PARGOT, EPARAM, PAREND, FACEGOT )
      CALL PARSECON_TABSET ( PARGOT, RANGE, NEWRANGE, PARANGE )
      CALL PARSECON_TABSET ( PARGOT, IN, NEWIN, PARIN )
      CALL PARSECON_TABSET ( PARGOT, DEFAULT, NONE, PARDEF )
      CALL PARSECON_TABSET ( PARGOT, TYPE, NONE, PARTYPE )
      CALL PARSECON_TABSET ( PARGOT, KEYWORD, NONE, PARKEY )
      CALL PARSECON_TABSET ( PARGOT, POSITION, NONE, PARPOS )
      CALL PARSECON_TABSET ( PARGOT, ACCESS, NONE, PARACC )
      CALL PARSECON_TABSET ( PARGOT, VPATH, NONE, PARVP )
      CALL PARSECON_TABSET ( PARGOT, HELP, NONE, PARHEL )
      CALL PARSECON_TABSET ( PARGOT, HELPKEY, NONE, PARHKY )
      CALL PARSECON_TABSET ( PARGOT, PTYPE, NONE, PARPTY )
      CALL PARSECON_TABSET ( PARGOT, ASSOC, NONE, PARASS )
      CALL PARSECON_TABSET ( PARGOT, PROMPT, NONE, PARPROM )
      CALL PARSECON_TABSET ( PARGOT, MENU, NONE, PARMENU )
      CALL PARSECON_TABSET ( PARGOT, COORDS, NEWPCOORDS, PARCOORDS )
      CALL PARSECON_TABSET ( PARGOT, PPATH, NONE, PARPP )
*
*   Within a parameter range definition. Expect a constant, ENDPARAMETER 
*   or a further parameter description.
*
      CALL PARSECON_TABSET ( PARANGE, EPARAM, PAREND, FACEGOT )
      CALL PARSECON_TABSET ( PARANGE, CONST, PARLIST, PARANGE )
      CALL PARSECON_TABSET ( PARANGE, DEFAULT, NONE, PARDEF )
      CALL PARSECON_TABSET ( PARANGE, KEYWORD, NONE, PARKEY )
      CALL PARSECON_TABSET ( PARANGE, POSITION, NONE, PARPOS )
      CALL PARSECON_TABSET ( PARANGE, ACCESS, NONE, PARACC )
      CALL PARSECON_TABSET ( PARANGE, VPATH, NONE, PARVP )
      CALL PARSECON_TABSET ( PARANGE, HELP, NONE, PARHEL )
      CALL PARSECON_TABSET ( PARANGE, HELPKEY, NONE, PARHKY )
      CALL PARSECON_TABSET ( PARANGE, PTYPE, NONE, PARPTY )
      CALL PARSECON_TABSET ( PARANGE, ASSOC, NONE, PARASS )
      CALL PARSECON_TABSET ( PARANGE, PROMPT, NONE, PARPROM )
      CALL PARSECON_TABSET ( PARANGE, MENU, NONE, PARMENU )
      CALL PARSECON_TABSET ( PARANGE, COORDS, NEWPCOORDS, PARCOORDS )
      CALL PARSECON_TABSET ( PARANGE, PPATH, NONE, PARPP )
*
*   Within a parameter IN definition. Expect a constant, ENDPARAMETER 
*   or a further parameter description.
*
      CALL PARSECON_TABSET ( PARIN, EPARAM, PAREND, FACEGOT )
      CALL PARSECON_TABSET ( PARIN, CONST, PARLIST, PARIN )
      CALL PARSECON_TABSET ( PARIN, DEFAULT, NONE, PARDEF )
      CALL PARSECON_TABSET ( PARIN, KEYWORD, NONE, PARKEY )
      CALL PARSECON_TABSET ( PARIN, POSITION, NONE, PARPOS )
      CALL PARSECON_TABSET ( PARIN, ACCESS, NONE, PARACC )
      CALL PARSECON_TABSET ( PARIN, VPATH, NONE, PARVP )
      CALL PARSECON_TABSET ( PARIN, HELP, NONE, PARHEL )
      CALL PARSECON_TABSET ( PARIN, HELPKEY, NONE, PARHKY )
      CALL PARSECON_TABSET ( PARIN, PTYPE, NONE, PARPTY )
      CALL PARSECON_TABSET ( PARIN, ASSOC, NONE, PARASS )
      CALL PARSECON_TABSET ( PARIN, PROMPT, NONE, PARPROM )
      CALL PARSECON_TABSET ( PARIN, MENU, NONE, PARMENU )
      CALL PARSECON_TABSET ( PARIN, COORDS, NEWPCOORDS, PARCOORDS )
      CALL PARSECON_TABSET ( PARIN, PPATH, NONE, PARPP )
*
*   Within a parameter DEFAULT definition. Expect a constant, a name,
*   ENDPARAMETER or a further parameter description.
*
      CALL PARSECON_TABSET ( PARDEF, EPARAM, PAREND, FACEGOT )
      CALL PARSECON_TABSET ( PARDEF, NAME, SETVAL, PARDEF )
      CALL PARSECON_TABSET ( PARDEF, CONST, SETVAL, PARDEF )
      CALL PARSECON_TABSET ( PARDEF, RANGE, NEWRANGE, PARANGE )
      CALL PARSECON_TABSET ( PARDEF, IN, NEWIN, PARIN )
      CALL PARSECON_TABSET ( PARDEF, KEYWORD, NONE, PARKEY )
      CALL PARSECON_TABSET ( PARDEF, POSITION, NONE, PARPOS )
      CALL PARSECON_TABSET ( PARDEF, ACCESS, NONE, PARACC )
      CALL PARSECON_TABSET ( PARDEF, VPATH, NONE, PARVP )
      CALL PARSECON_TABSET ( PARDEF, HELP, NONE, PARHEL )
      CALL PARSECON_TABSET ( PARDEF, HELPKEY, NONE, PARHKY )
      CALL PARSECON_TABSET ( PARDEF, PTYPE, NONE, PARPTY )
      CALL PARSECON_TABSET ( PARDEF, ASSOC, NONE, PARASS )
      CALL PARSECON_TABSET ( PARDEF, PROMPT, NONE, PARPROM )
      CALL PARSECON_TABSET ( PARDEF, MENU, NONE, PARMENU )
      CALL PARSECON_TABSET ( PARDEF, COORDS, NEWPCOORDS, PARCOORDS )
      CALL PARSECON_TABSET ( PARDEF, PPATH, NONE, PARPP )
*
*   Within parameter MENUCOORDS definition. Expect a constant, 
*   ENDPARAMETER or a further parameter description.
*
      CALL PARSECON_TABSET ( PARCOORDS, EPARAM, PAREND, FACEGOT )
      CALL PARSECON_TABSET ( PARCOORDS, CONST, SETPCOORDS, PARCOORDS )
      CALL PARSECON_TABSET ( PARCOORDS, RANGE, NEWRANGE, PARANGE )
      CALL PARSECON_TABSET ( PARCOORDS, IN, NEWIN, PARIN )
      CALL PARSECON_TABSET ( PARCOORDS, KEYWORD, NONE, PARKEY )
      CALL PARSECON_TABSET ( PARCOORDS, POSITION, NONE, PARPOS )
      CALL PARSECON_TABSET ( PARCOORDS, ACCESS, NONE, PARACC )
      CALL PARSECON_TABSET ( PARCOORDS, VPATH, NONE, PARVP )
      CALL PARSECON_TABSET ( PARCOORDS, HELP, NONE, PARHEL )
      CALL PARSECON_TABSET ( PARCOORDS, HELPKEY, NONE, PARHKY )
      CALL PARSECON_TABSET ( PARCOORDS, PTYPE, NONE, PARPTY )
      CALL PARSECON_TABSET ( PARCOORDS, ASSOC, NONE, PARASS )
      CALL PARSECON_TABSET ( PARCOORDS, PROMPT, NONE, PARPROM )
      CALL PARSECON_TABSET ( PARCOORDS, MENU, NONE, PARMENU )
      CALL PARSECON_TABSET ( PARCOORDS, PPATH, NONE, PARPP )
*
*   Start of ACTION definition. Expect a name or a constant.
*
      CALL PARSECON_TABSET ( ACTSTART, NAME, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, CONST, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, IFACE, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, EFACE, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, PARAM, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, EPARAM, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, ACTION, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, ENDACT, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, OBEY, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, ENDOBEY, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, CANCEL, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, ENDCANC, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, RANGE, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, IN, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, DEFAULT, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, TYPE, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, NEEDS, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, KEYWORD, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, POSITION, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, ACCESS, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, VPATH, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, HELP, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, HELPKEY, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, HELPLIB, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, PTYPE, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, ASSOC, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, PROGRAM, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, EPATH, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, MESSAGE, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, TEXT, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, EMESS, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, PROMPT, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, MONOL, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, EMONOL, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, MENU, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, COORDS, NEWACT, ACTGOT )
      CALL PARSECON_TABSET ( ACTSTART, PPATH, NEWACT, ACTGOT )
*
*   Within an ACTION definition. Expect OBEY, CANCEL, action description 
*   or ENDACTION.
*
      CALL PARSECON_TABSET ( ACTGOT, ENDACT, ACTEND, FACEGOT )
      CALL PARSECON_TABSET ( ACTGOT, OBEY, NEWOB, OGOT )
      CALL PARSECON_TABSET ( ACTGOT, CANCEL, NEWCAN, CGOT )
      CALL PARSECON_TABSET ( ACTGOT, KEYWORD, NONE, ACTKEY )
      CALL PARSECON_TABSET ( ACTGOT, HELP, NONE, ACTHEL )
      CALL PARSECON_TABSET ( ACTGOT, MENU, NONE, ACTMENU )
      CALL PARSECON_TABSET ( ACTGOT, COORDS, NEWACOORDS, ACTCOORDS )
*
*   Within an action MENUCOORDS definition. Expect a constant, OBEY, 
*   CANCEL, action description or ENDACTION.
*
      CALL PARSECON_TABSET ( ACTCOORDS, ENDACT, NONE, FACEGOT )
      CALL PARSECON_TABSET ( ACTCOORDS, OBEY, NEWOB, OGOT )
      CALL PARSECON_TABSET ( ACTCOORDS, CANCEL, NEWCAN, CGOT )
      CALL PARSECON_TABSET ( ACTCOORDS, KEYWORD, NONE, ACTKEY )
      CALL PARSECON_TABSET ( ACTCOORDS, HELP, NONE, ACTHEL )
      CALL PARSECON_TABSET ( ACTCOORDS, MENU, NONE, ACTMENU )
      CALL PARSECON_TABSET ( ACTCOORDS, CONST, SETACOORDS, ACTCOORDS )
*
*   Within an OBEY definition. Expect NEEDS or ENDOBEY.
*
      CALL PARSECON_TABSET ( OGOT, ENDOBEY, NONE, ACTGOT )
      CALL PARSECON_TABSET ( OGOT, NEEDS, NONE, ONEEDST )
*
*   Within a CANCEL definition. Expect NEEDS or ENDCANCEL.
*
      CALL PARSECON_TABSET ( CGOT, ENDCANC, NONE, ACTGOT )
      CALL PARSECON_TABSET ( CGOT, NEEDS, NONE, CNEEDST )
*
*   Start of OBEY NEEDS definition. Expect a name.
*
      CALL PARSECON_TABSET ( ONEEDST, NAME, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, IFACE, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, EFACE, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, PARAM, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, EPARAM, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, ACTION, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, ENDACT, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, OBEY, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, ENDOBEY, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, CANCEL, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, ENDCANC, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, RANGE, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, IN, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, DEFAULT, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, TYPE, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, NEEDS, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, KEYWORD, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, POSITION, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, ACCESS, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, VPATH, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, HELP, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, HELPKEY, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, HELPLIB, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, PTYPE, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, ASSOC, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, PROGRAM, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, EPATH, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, MESSAGE, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, TEXT, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, EMESS, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, PROMPT, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, MONOL, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, EMONOL, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, MENU, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, COORDS, OREQ, ONEED )
      CALL PARSECON_TABSET ( ONEEDST, PPATH, OREQ, ONEED )
*
*   Within OBEY NEEDS definition. Expect RANGE or IN (introducing a 
*   list) or start of a new NEEDS defintion, or ENDOBEY.
*
      CALL PARSECON_TABSET ( ONEED, ENDOBEY, NONE, ACTGOT )
      CALL PARSECON_TABSET ( ONEED, RANGE, CONTVALS, ORANGE )
      CALL PARSECON_TABSET ( ONEED, IN, DISCVALS, OBIN )
      CALL PARSECON_TABSET ( ONEED, NEEDS, NONE, ONEEDST )
*
*   Start of CANCEL NEEDS definition. Expect a name.
*
      CALL PARSECON_TABSET ( CNEEDST, NAME, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, IFACE, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, EFACE, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, PARAM, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, EPARAM, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, ACTION, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, ENDACT, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, OBEY, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, ENDOBEY, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, CANCEL, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, ENDCANC, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, RANGE, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, IN, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, DEFAULT, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, TYPE, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, NEEDS, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, KEYWORD, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, POSITION, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, ACCESS, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, VPATH, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, HELP, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, HELPKEY, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, HELPLIB, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, PTYPE, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, ASSOC, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, PROGRAM, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, EPATH, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, MESSAGE, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, TEXT, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, EMESS, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, PROMPT, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, MONOL, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, EMONOL, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, MENU, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, COORDS, CREQ, CNEED )
      CALL PARSECON_TABSET ( CNEEDST, PPATH, CREQ, CNEED )
*
*   Within CANCEL NEEDS definition. Expect RANGE or IN (introducing a 
*   list) or start of a new NEEDS defintion, or ENDOBEY.
*
      CALL PARSECON_TABSET ( CNEED, ENDCANC, NONE, ACTGOT )
      CALL PARSECON_TABSET ( CNEED, RANGE, CONTVALS, CRANGE )
      CALL PARSECON_TABSET ( CNEED, IN, DISCVALS, CANCIN )
      CALL PARSECON_TABSET ( CNEED, NEEDS, NONE, CNEEDST )
*
*   Within range definition for OBEY NEEDS. Expect a constant, the start 
*   of a new NEEDS definition or ENDOBEY.
*
      CALL PARSECON_TABSET ( ORANGE, ENDOBEY, NONE, ACTGOT )
      CALL PARSECON_TABSET ( ORANGE, NEEDS, NONE, ONEEDST )
      CALL PARSECON_TABSET ( ORANGE, CONST, ACTLIST, ORANGE )
*
*   Within range definition for CANCEL NEEDS. Expect a constant, the start 
*   of a new NEEDS definition or ENDCANCEL.
*
      CALL PARSECON_TABSET ( CRANGE, ENDCANC, NONE, ACTGOT )
      CALL PARSECON_TABSET ( CRANGE, NEEDS, NONE, CNEEDST )
      CALL PARSECON_TABSET ( CRANGE, CONST, ACTLIST, CRANGE )
*
*   Within IN definition for OBEY NEEDS. Expect a constant, the start 
*   of a new NEEDS definition or ENDOBEY.
*
      CALL PARSECON_TABSET ( OBIN, ENDOBEY, NONE, ACTGOT )
      CALL PARSECON_TABSET ( OBIN, NEEDS, NONE, ONEEDST )
      CALL PARSECON_TABSET ( OBIN, CONST, ACTLIST, OBIN )
*
*   Within IN definition for CANCEL NEEDS. Expect a constant, the start 
*   of a new NEEDS definition or ENDCANCEL.
*
      CALL PARSECON_TABSET ( CANCIN, ENDCANC, NONE, ACTGOT )
      CALL PARSECON_TABSET ( CANCIN, NEEDS, NONE, CNEEDST )
      CALL PARSECON_TABSET ( CANCIN, CONST, ACTLIST, CANCIN )
*
*   Action KEYWORD definition. Expect a name or a constant.
*
      CALL PARSECON_TABSET ( ACTKEY, NAME, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, CONST, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, IFACE, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, EFACE, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, PARAM, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, EPARAM, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, ACTION, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, ENDACT, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, OBEY, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, ENDOBEY, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, CANCEL, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, ENDCANC, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, RANGE, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, IN, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, DEFAULT, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, TYPE, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, NEEDS, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, KEYWORD, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, POSITION, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, ACCESS, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, VPATH, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, HELP, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, HELPKEY, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, HELPLIB, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, PTYPE, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, ASSOC, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, PROGRAM, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, EPATH, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, MESSAGE, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, TEXT, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, EMESS, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, PROMPT, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, MONOL, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, EMONOL, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, MENU, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, COORDS, SETAKEY, ACTGOT )
      CALL PARSECON_TABSET ( ACTKEY, PPATH, SETAKEY, ACTGOT )
*
*   Action HELP definition. Expect a constant.
*
      CALL PARSECON_TABSET ( ACTHEL, CONST, SETAHEL, ACTGOT )
*
*   Action MENU definition. Expect a name or a constant.
*
      CALL PARSECON_TABSET ( ACTMENU, NAME, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, CONST, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, IFACE, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, EFACE, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, PARAM, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, EPARAM, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, ACTION, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, ENDACT, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, OBEY, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, ENDOBEY, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, CANCEL, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, ENDCANC, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, RANGE, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, IN, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, DEFAULT, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, TYPE, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, NEEDS, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, KEYWORD, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, POSITION, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, ACCESS, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, VPATH, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, HELP, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, HELPKEY, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, HELPLIB, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, PTYPE, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, ASSOC, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, PROGRAM, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, EPATH, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, MESSAGE, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, TEXT, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, EMESS, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, PROMPT, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, MONOL, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, EMONOL, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, MENU, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, COORDS, SETAMENU, ACTGOT )
      CALL PARSECON_TABSET ( ACTMENU, PPATH, SETAMENU, ACTGOT )
*
*   Parameter TYPE definition. Expect NAME or CONST (allow reserved word).
*
      CALL PARSECON_TABSET ( PARTYPE, NAME, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, CONST, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, IFACE, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, EFACE, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, PARAM, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, EPARAM, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, ACTION, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, ENDACT, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, OBEY, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, ENDOBEY, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, CANCEL, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, ENDCANC, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, RANGE, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, IN, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, DEFAULT, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, TYPE, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, NEEDS, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, KEYWORD, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, POSITION, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, ACCESS, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, VPATH, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, HELP, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, HELPKEY, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, HELPLIB, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, PTYPE, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, ASSOC, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, PROGRAM, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, EPATH, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, MESSAGE, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, TEXT, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, EMESS, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, PROMPT, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, MONOL, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, EMONOL, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, MENU, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, COORDS, SETTYP, PARGOT )
      CALL PARSECON_TABSET ( PARTYPE, PPATH, SETTYP, PARGOT )
*
*   Parameter PTYPE definition. Expect NAME or CONST (allow reserved word).
*
      CALL PARSECON_TABSET ( PARPTY, NAME, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, CONST, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, IFACE, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, EFACE, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, PARAM, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, EPARAM, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, ACTION, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, ENDACT, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, OBEY, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, ENDOBEY, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, CANCEL, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, ENDCANC, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, RANGE, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, IN, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, DEFAULT, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, TYPE, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, NEEDS, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, KEYWORD, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, POSITION, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, ACCESS, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, VPATH, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, HELP, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, HELPKEY, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, HELPLIB, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, PTYPE, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, ASSOC, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, PROGRAM, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, EPATH, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, MESSAGE, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, TEXT, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, EMESS, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, PROMPT, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, MONOL, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, EMONOL, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, MENU, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, COORDS, SETPTY, PARGOT )
      CALL PARSECON_TABSET ( PARPTY, PPATH, SETPTY, PARGOT )
*
*   Parameter KEYWORD definition. Expect a name or a constant.
*
      CALL PARSECON_TABSET ( PARKEY, NAME, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, CONST, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, IFACE, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, EFACE, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, PARAM, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, EPARAM, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, ACTION, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, ENDACT, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, OBEY, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, ENDOBEY, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, CANCEL, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, ENDCANC, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, RANGE, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, IN, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, DEFAULT, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, TYPE, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, NEEDS, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, KEYWORD, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, POSITION, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, ACCESS, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, VPATH, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, HELP, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, HELPKEY, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, HELPLIB, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, PTYPE, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, ASSOC, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, PROGRAM, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, EPATH, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, MESSAGE, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, TEXT, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, EMESS, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, PROMPT, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, MONOL, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, EMONOL, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, MENU, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, COORDS, SETKEY, PARGOT )
      CALL PARSECON_TABSET ( PARKEY, PPATH, SETKEY, PARGOT )
*
*   Parameter POSITION definition. Expect a constant.
*
      CALL PARSECON_TABSET ( PARPOS, CONST, SETPOS, PARGOT )
*
*   Parameter ACCESS definition. Expect a name or a constant.
*
      CALL PARSECON_TABSET ( PARACC, NAME, SETACC, PARGOT )
      CALL PARSECON_TABSET ( PARACC, CONST, SETACC, PARGOT )
*
*   Parameter VPATH definition. Expect a name or a constant
*    or PROMPT or DEFAULT.
*
      CALL PARSECON_TABSET ( PARVP, NAME, SETVP, PARGOT )
      CALL PARSECON_TABSET ( PARVP, CONST, SETVP, PARGOT )
      CALL PARSECON_TABSET ( PARVP, PROMPT, SETVP, PARGOT )
      CALL PARSECON_TABSET ( PARVP, DEFAULT, SETVP, PARGOT )
*
*   Parameter HELP definition. Expect a constant.
*
      CALL PARSECON_TABSET ( PARHEL, CONST, SETHEL, PARGOT )
*
*   Parameter HELPKEY definition. Expect a constant allow NAME or reserved word.
*
      CALL PARSECON_TABSET ( PARHKY, CONST, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, NAME, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, IFACE, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, EFACE, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, PARAM, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, EPARAM, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, ACTION, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, ENDACT, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, OBEY, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, ENDOBEY, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, CANCEL, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, ENDCANC, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, RANGE, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, IN, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, DEFAULT, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, TYPE, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, NEEDS, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, KEYWORD, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, POSITION, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, ACCESS, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, VPATH, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, HELP, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, HELPKEY, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, HELPLIB, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, PTYPE, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, ASSOC, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, PROGRAM, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, EPATH, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, MESSAGE, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, TEXT, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, EMESS, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, PROMPT, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, MONOL, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, EMONOL, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, MENU, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, COORDS, SETHKEY, PARGOT )
      CALL PARSECON_TABSET ( PARHKY, PPATH, SETHKEY, PARGOT )
*
*   Parameter ASSOCIATION definition, expect NAME or CONST.
*
      CALL PARSECON_TABSET ( PARASS, CONST, SETASS, PARGOT )
      CALL PARSECON_TABSET ( PARASS, NAME, SETASS, PARGOT )
*
*   Parameter PROMPT definition. Expect a constant. Allow a NAME.
*
      CALL PARSECON_TABSET ( PARPROM, CONST, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, NAME, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, IFACE, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, EFACE, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, PARAM, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, EPARAM, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, ACTION, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, ENDACT, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, OBEY, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, ENDOBEY, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, CANCEL, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, ENDCANC, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, RANGE, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, IN, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, DEFAULT, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, TYPE, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, NEEDS, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, KEYWORD, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, POSITION, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, ACCESS, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, VPATH, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, HELP, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, HELPKEY, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, HELPLIB, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, PTYPE, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, ASSOC, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, PROGRAM, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, EPATH, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, MESSAGE, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, TEXT, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, EMESS, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, PROMPT, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, MONOL, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, EMONOL, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, MENU, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, COORDS, SETPROM, PARGOT )
      CALL PARSECON_TABSET ( PARPROM, PPATH, SETPROM, PARGOT )
*
*   Parameter MENU definition. Expect a constant. Allow a NAME.
*
      CALL PARSECON_TABSET ( PARMENU, CONST, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, NAME, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, IFACE, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, EFACE, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, PARAM, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, EPARAM, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, ACTION, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, ENDACT, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, OBEY, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, ENDOBEY, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, CANCEL, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, ENDCANC, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, RANGE, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, IN, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, DEFAULT, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, TYPE, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, NEEDS, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, KEYWORD, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, POSITION, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, ACCESS, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, VPATH, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, HELP, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, HELPKEY, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, HELPLIB, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, PTYPE, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, ASSOC, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, PROGRAM, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, EPATH, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, MESSAGE, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, TEXT, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, EMESS, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, PROMPT, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, MONOL, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, EMONOL, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, MENU, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, COORDS, SETPMENU, PARGOT )
      CALL PARSECON_TABSET ( PARMENU, PPATH, SETPMENU, PARGOT )
*
*   Parameter PPATH definition. Expect a name or a constant or DEFAULT.
*
      CALL PARSECON_TABSET ( PARPP, NAME, SETPP, PARGOT )
      CALL PARSECON_TABSET ( PARPP, CONST, SETPP, PARGOT )
      CALL PARSECON_TABSET ( PARPP, DEFAULT, SETPP, PARGOT )

      END
