/*
 * Copywrite 1997 Edscott Wilson Garcia 
 *
 * GPL licence. No warranty. Read license for details
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_PWD_H
#include <pwd.h>
#endif
#include <glob.h>
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_TIME_H
#include <time.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_UTIME_H
#include <utime.h>
#endif

#include <glob.h>

#define notTEST
#define PURGE
#define BLOCKSIZE 64000
#define ENCRYPT 1
#define DECRYPT 2

/* in order to support boxes where GLOB_NOMATCH is not
 * defined, all return error codes will be interpreted
 * as GLOB_NOMATCH */
/* in gnu-c, GLOB_NOMATCH is 3 */


unsigned char buff;


char *key;
int verbose=0,purge=1,opcion=0,recursivo=0,cryptcount=0,keypos=0,keyset=0,keylen;
int resetdate=1;
void cifrador(char *);
void realcrypt(char *);

int main(int argc,char **argv)
{
 char *input;

 if (argc < 3){
  error:
  printf("%s  [-redkv] (file) \n",argv[0]);
  printf("r= recursive, e=enscramble, d= descramble, k=don't purge (with -e), \n b=purge (with -d) v=verbose\nBy default, scramble will purge with -e and will not purge with -d\n");
  goto endit;  
 }


  if (strstr(argv[1],"-")==NULL) goto error;
  if ( (strstr(argv[1],"e")!=NULL) && (strstr(argv[1],"d")!=NULL)){
      fprintf(stderr,"need to know if -e or -d\n"); 
      goto error;
  }
  if ( (strstr(argv[1],"e")==NULL) && (strstr(argv[1],"d")==NULL)) goto error;
  if ( (strstr(argv[1],"k")!=NULL) && (strstr(argv[1],"b")!=NULL)) goto error;
  if (strstr(argv[1],"e")!=NULL) {opcion=ENCRYPT; purge=1;}
  if (strstr(argv[1],"d")!=NULL) {opcion=DECRYPT; purge=0;}
  if (strstr(argv[1],"r")!=NULL) recursivo=1;
  if (strstr(argv[1],"k")!=NULL) purge=0;
  if (strstr(argv[1],"b")!=NULL) purge=1;
  if (strstr(argv[1],"v")!=NULL) verbose=1;
  if (strstr(argv[1],"u")!=NULL) {verbose=1;}
  if (strstr(argv[1],"w")!=NULL) resetdate=0;

#if 0
		 cifrador(input);
#endif
		 
   /* modification for * bug. Will it work recursively with nested dirs? 
   * How much memory will it take up with a enormous tree, like /? */

 { 
	 int i;
	 for (i=2;i<argc;i++)
	 {
		 input=(char *)malloc(strlen(argv[i])+25);
		 sprintf(input,"%s",argv[i]);
		 if (verbose) 
		     printf("processing (%d/%d) =%s\n",i-1,argc-2,input);
		 cifrador(input);
		 free(input);
	 }
 }

 
/* cero out passwd (man recomendation) :*/
 for (keypos=0;keypos<keylen;keypos++) key[keypos]=0;
 if (cryptcount) printf("\n%s %d file(s)\n",(opcion==ENCRYPT)?"scrambled":"unscrambled",cryptcount);
 else printf("No file to (un)scramble.\n");

endit:
#if 10
 printf("press <return> to continue");fflush(NULL);
 getc(stdin);
#endif
 return 1;
}

char *OKchars="( -_~./;+&@)";
struct stat st;

void cifrador(char *input) {
 glob_t  dirlist;
 int i;
/* check for fichero*/
  
 dirlist.gl_offs=2;
#ifdef DEBUG
 printf("globbing %s:\n",input);
#endif
 if (glob(input,GLOB_ERR,NULL,&dirlist)!=0) 
 {
#ifdef DEBUG
 printf("%s: empty\n",input); 
#endif
  return;
 }

 /*printf ("cuenta=%d\n",dirlist.gl_pathc);*/
 for (i=0;i<dirlist.gl_pathc;i++) {
  /*printf("%s\n",dirlist.gl_pathv[i]);*/
 
  stat(dirlist.gl_pathv[i],&st);
  if ((S_IFMT&st.st_mode)==S_IFDIR) {
   if (recursivo==1) {
    char *Ninput;
    Ninput=(char *)malloc(strlen(dirlist.gl_pathv[i])+25);
    if (verbose) {
     printf("Directory \"%s\" will be %s recursively:\n",
	     input,
	     ((opcion==ENCRYPT)?"scrambled":"unscrambled")
	     );
    }
    sprintf(Ninput,"%s/*",dirlist.gl_pathv[i]);
    cifrador(Ninput);
    free(Ninput);
   }
   else { 
       fprintf(stderr,"%s is a directory\n",dirlist.gl_pathv[i]);
   }
  } else {
   int j;
   /* test for metachars */
   for (j=0;j<strlen(dirlist.gl_pathv[i]);j++) {
    int k;
    if ((dirlist.gl_pathv[i][j]<='z')&&(dirlist.gl_pathv[i][j]>='a')) goto OK;
    if ((dirlist.gl_pathv[i][j]<='Z')&&(dirlist.gl_pathv[i][j]>='A')) goto OK;
    if ((dirlist.gl_pathv[i][j]<='9')&&(dirlist.gl_pathv[i][j]>='0')) goto OK;
    for (k=0;k<strlen(OKchars);k++)  if (dirlist.gl_pathv[i][j]==OKchars[k]) goto OK;
    printf("\nrename %s before trying to scramble\n",dirlist.gl_pathv[i]);
    goto skip;
    OK:;
   }
   realcrypt(dirlist.gl_pathv[i]);
   skip:;
  }
 }
 globfree(&dirlist);
 /*printf("OK\n");*/
 return;
}

void realcrypt(char *input)
{
 /*struct stat stN;*/
 FILE *infile,*outfile;
 char *archivo,*archi;
 int filesize,fileplace;

 archivo=(char *)malloc(strlen(input)+25);


 if (opcion==DECRYPT) {
  int longitud;
  longitud=strlen(input);
  if ((input[longitud-1]!='t')||(input[longitud-2]!='y')||
       (input[longitud-3]!='c')||(input[longitud-4]!='.')) {
   fprintf(stderr,"%s is not .cyt file\n",input); 
   return;
  } 
  sprintf(archivo,"%s",input);
  archivo[longitud-4]=0;
  /*if (verbose) */
      printf("Unscrambling %s to %s :\n",input,archivo);
 } else { /*ENCRYPT   */
  int longitud;
  longitud=strlen(input);
  if ((input[longitud-1]=='t')&&(input[longitud-2]=='y')&&
       (input[longitud-3]=='c')&&(input[longitud-4]=='.')) {
   fprintf(stderr,"%s is already .cyt\n",input); 
   return;
  } 
  sprintf(archivo,"%s.cyt",input);
  /*if (verbose) */
      printf("Scrambling %s to %s :\n",input,archivo);
 }

 infile=fopen(input,"rb");
 if (infile==NULL) {
     fprintf(stderr,"File not found: %s\n",input);
     return;
 }
 /* get file size*/
 fseek(infile,0,SEEK_END); filesize = ftell(infile); rewind(infile); 
 cryptcount++;

/* key*/
/* very important:*/
   keypos=0; 
 
 
  if (keyset==0) {
  char buff[128];
  keyset=1;
  key=(char *)getpass("key:");
  keylen=strlen(key);
  strncpy(buff,key,128);
  /* confirma para evitar desastres:*/
  key=(char *)getpass("confirm key (avoid disasters):");
  if (strcmp(buff,key)!=0){
      fprintf(stderr,"The second key does not confirm with the first key\n"); 
      goto endit;
  }
  if (keylen<8) {
    fprintf(stderr,"Key cannot be less than 8 characters\n");
endit:
#if 0
    printf("press <return> to continue");fflush(NULL);
    getc(stdin);
#endif
    exit(1);
  }
 }
 
 /*printf("using key %s\n",key);*/
#ifndef TEST
 
 outfile=fopen(archivo,"wb");
 if (outfile==NULL) {
     fprintf(stderr,"Cannot generate output file \"%s\"\n",archivo);
     return;
 }

/* printf("longitud llave=%d, llave=%s\n",keylen,key);*/

 archi=(char *)malloc(BLOCKSIZE);

 fileplace=0;
 while (fileplace<filesize){
  void crypter(char *,int);
  int readblock;
  if (filesize-fileplace>=BLOCKSIZE) readblock=BLOCKSIZE; else readblock=filesize-fileplace;
/*/printf("reading %d / %d\n",fileplace,filesize);*/
  fread(archi,readblock,1,infile);/*/if (feof(infile)) break;*/
  crypter(archi,readblock);
  fwrite(archi,readblock,1,outfile);
  fileplace += readblock;           /*/ftell(infile);*/
 }


 fclose(infile);
 
 fclose(outfile);
 
 if (resetdate) {/*/ dont change the access time:*/
  struct utimbuf times;
/*/  stat(archivo,&stN); */
  times.modtime=st.st_mtime; /*/ modification time of unencrypted file*/
  times.actime=st.st_atime;   /*/ access time of unencrypted file crypted file*/
  utime(archivo,&times);
 }

#ifdef PURGE
 {
  int result;
  if (purge){
    infile=fopen(input,"rb+");
    if (infile) { /* shred before removing */
	fileplace=0;
	while (fileplace<filesize){
	    void crypter(char *,int);
	    int readblock;
	    if (filesize-fileplace>=BLOCKSIZE) readblock=BLOCKSIZE; else readblock=filesize-fileplace;
	    crypter(archi,readblock);
	    fwrite(archi,readblock,1,infile);
	    fileplace += readblock;           /*/ftell(infile);*/
	}
	fclose(infile);
    }
     
    result=remove(input);
    if (result<0) fprintf(stderr,"Cannot remove %s\n",input);
  }
 }
#endif


#endif 

if (verbose) {
 if (opcion==DECRYPT) printf("file unscrambled: %s\n",archivo);
 else printf("file scrambled: %s\n",archivo);
}else{
 printf("."); 
 fflush(stdout);
}

 free(archivo);
 free(archi);
 return;
}




void crypter(char *data,int length){
 int i;
 for (i=0;i<length;i++){
  if (opcion==DECRYPT) data[i] -= key[keypos++];
  else data[i] += key[keypos++];
  if (keypos==keylen) keypos=0;
 }
}

