/*
 * Copyright (C) 2023 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "CookieStore.h"

#include "CookieInit.h"
#include "CookieStoreDeleteOptions.h"
#include "CookieStoreGetOptions.h"
#include "JSDOMPromiseDeferred.h"
#include <wtf/IsoMallocInlines.h>
#include <wtf/Ref.h>
#include <wtf/text/WTFString.h>

namespace WebCore {

WTF_MAKE_ISO_ALLOCATED_IMPL(CookieStore);

Ref<CookieStore> CookieStore::create()
{
    return adoptRef(*new CookieStore());
}

CookieStore::CookieStore() = default;

CookieStore::~CookieStore() = default;

void CookieStore::get(const String&, Ref<DeferredPromise>&& promise)
{
    promise->reject(NotSupportedError);
}

void CookieStore::get(CookieStoreGetOptions&&, Ref<DeferredPromise>&& promise)
{
    promise->reject(NotSupportedError);
}

void CookieStore::getAll(const String&, Ref<DeferredPromise>&& promise)
{
    promise->reject(NotSupportedError);
}

void CookieStore::getAll(CookieStoreGetOptions&&, Ref<DeferredPromise>&& promise)
{
    promise->reject(NotSupportedError);
}

void CookieStore::set(const String&, const String&, Ref<DeferredPromise>&& promise)
{
    promise->reject(NotSupportedError);
}

void CookieStore::set(CookieInit&&, Ref<DeferredPromise>&& promise)
{
    promise->reject(NotSupportedError);
}

void CookieStore::remove(const String&, Ref<DeferredPromise>&& promise)
{
    promise->reject(NotSupportedError);
}

void CookieStore::remove(CookieStoreDeleteOptions&&, Ref<DeferredPromise>&& promise)
{
    promise->reject(NotSupportedError);
}

EventTargetInterface CookieStore::eventTargetInterface() const
{
    return CookieStoreEventTargetInterfaceType;
}

ScriptExecutionContext* CookieStore::scriptExecutionContext() const
{
    return nullptr;
}

}
