// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_1_0_autogen.cpp:
//   Defines the GLES 1.0 entry points.

#include "libGLESv2/entry_points_gles_1_0_autogen.h"

#include "common/entry_points_enum_autogen.h"
#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/capture/capture_gles_1_0_autogen.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationES1.h"
#include "libGLESv2/global_state.h"

using namespace gl;

extern "C" {
void GL_APIENTRY GL_AlphaFunc(GLenum func, GLfloat ref)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLAlphaFunc, "context = %d, func = %s, ref = %f", CID(context),
          GLenumToString(GLESEnum::AlphaFunction, func), ref);

    if (context)
    {
        AlphaTestFunc funcPacked = PackParam<AlphaTestFunc>(func);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLAlphaFunc) &&
              ValidateAlphaFunc(context, angle::EntryPoint::GLAlphaFunc, funcPacked, ref)));
        if (isCallValid)
        {
            context->alphaFunc(funcPacked, ref);
        }
        ANGLE_CAPTURE_GL(AlphaFunc, isCallValid, context, funcPacked, ref);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_AlphaFuncx(GLenum func, GLfixed ref)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLAlphaFuncx, "context = %d, func = %s, ref = 0x%X", CID(context),
          GLenumToString(GLESEnum::AlphaFunction, func), ref);

    if (context)
    {
        AlphaTestFunc funcPacked = PackParam<AlphaTestFunc>(func);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLAlphaFuncx) &&
              ValidateAlphaFuncx(context, angle::EntryPoint::GLAlphaFuncx, funcPacked, ref)));
        if (isCallValid)
        {
            context->alphaFuncx(funcPacked, ref);
        }
        ANGLE_CAPTURE_GL(AlphaFuncx, isCallValid, context, funcPacked, ref);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ClearColorx(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearColorx,
          "context = %d, red = 0x%X, green = 0x%X, blue = 0x%X, alpha = 0x%X", CID(context), red,
          green, blue, alpha);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLClearColorx) &&
              ValidateClearColorx(context, angle::EntryPoint::GLClearColorx, red, green, blue,
                                  alpha)));
        if (isCallValid)
        {
            context->clearColorx(red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(ClearColorx, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ClearDepthx(GLfixed depth)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClearDepthx, "context = %d, depth = 0x%X", CID(context), depth);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLClearDepthx) &&
              ValidateClearDepthx(context, angle::EntryPoint::GLClearDepthx, depth)));
        if (isCallValid)
        {
            context->clearDepthx(depth);
        }
        ANGLE_CAPTURE_GL(ClearDepthx, isCallValid, context, depth);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ClientActiveTexture(GLenum texture)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClientActiveTexture, "context = %d, texture = %s", CID(context),
          GLenumToString(GLESEnum::TextureUnit, texture));

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            (ValidatePixelLocalStorageInactive(
                                 context, angle::EntryPoint::GLClientActiveTexture) &&
                             ValidateClientActiveTexture(
                                 context, angle::EntryPoint::GLClientActiveTexture, texture)));
        if (isCallValid)
        {
            context->clientActiveTexture(texture);
        }
        ANGLE_CAPTURE_GL(ClientActiveTexture, isCallValid, context, texture);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ClipPlanef(GLenum p, const GLfloat *eqn)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClipPlanef, "context = %d, p = %s, eqn = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::ClipPlaneName, p), (uintptr_t)eqn);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLClipPlanef) &&
              ValidateClipPlanef(context, angle::EntryPoint::GLClipPlanef, p, eqn)));
        if (isCallValid)
        {
            context->clipPlanef(p, eqn);
        }
        ANGLE_CAPTURE_GL(ClipPlanef, isCallValid, context, p, eqn);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ClipPlanex(GLenum plane, const GLfixed *equation)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLClipPlanex, "context = %d, plane = %s, equation = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::ClipPlaneName, plane), (uintptr_t)equation);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLClipPlanex) &&
              ValidateClipPlanex(context, angle::EntryPoint::GLClipPlanex, plane, equation)));
        if (isCallValid)
        {
            context->clipPlanex(plane, equation);
        }
        ANGLE_CAPTURE_GL(ClipPlanex, isCallValid, context, plane, equation);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Color4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4f, "context = %d, red = %f, green = %f, blue = %f, alpha = %f",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLColor4f) &&
              ValidateColor4f(context, angle::EntryPoint::GLColor4f, red, green, blue, alpha)));
        if (isCallValid)
        {
            context->color4f(red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(Color4f, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Color4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4ub, "context = %d, red = %d, green = %d, blue = %d, alpha = %d",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLColor4ub) &&
              ValidateColor4ub(context, angle::EntryPoint::GLColor4ub, red, green, blue, alpha)));
        if (isCallValid)
        {
            context->color4ub(red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(Color4ub, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Color4x(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColor4x, "context = %d, red = 0x%X, green = 0x%X, blue = 0x%X, alpha = 0x%X",
          CID(context), red, green, blue, alpha);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLColor4x) &&
              ValidateColor4x(context, angle::EntryPoint::GLColor4x, red, green, blue, alpha)));
        if (isCallValid)
        {
            context->color4x(red, green, blue, alpha);
        }
        ANGLE_CAPTURE_GL(Color4x, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ColorPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLColorPointer,
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLESEnum::ColorPointerType, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked = PackParam<VertexAttribType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLColorPointer) &&
              ValidateColorPointer(context, angle::EntryPoint::GLColorPointer, size, typePacked,
                                   stride, pointer)));
        if (isCallValid)
        {
            context->colorPointer(size, typePacked, stride, pointer);
        }
        ANGLE_CAPTURE_GL(ColorPointer, isCallValid, context, size, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DepthRangex(GLfixed n, GLfixed f)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDepthRangex, "context = %d, n = 0x%X, f = 0x%X", CID(context), n, f);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLDepthRangex) &&
              ValidateDepthRangex(context, angle::EntryPoint::GLDepthRangex, n, f)));
        if (isCallValid)
        {
            context->depthRangex(n, f);
        }
        ANGLE_CAPTURE_GL(DepthRangex, isCallValid, context, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DisableClientState(GLenum array)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDisableClientState, "context = %d, array = %s", CID(context),
          GLenumToString(GLESEnum::EnableCap, array));

    if (context)
    {
        ClientVertexArrayType arrayPacked = PackParam<ClientVertexArrayType>(array);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLDisableClientState) &&
              ValidateDisableClientState(context, angle::EntryPoint::GLDisableClientState,
                                         arrayPacked)));
        if (isCallValid)
        {
            context->disableClientState(arrayPacked);
        }
        ANGLE_CAPTURE_GL(DisableClientState, isCallValid, context, arrayPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_EnableClientState(GLenum array)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEnableClientState, "context = %d, array = %s", CID(context),
          GLenumToString(GLESEnum::EnableCap, array));

    if (context)
    {
        ClientVertexArrayType arrayPacked = PackParam<ClientVertexArrayType>(array);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateEnableClientState(
                                context, angle::EntryPoint::GLEnableClientState, arrayPacked));
        if (isCallValid)
        {
            context->enableClientState(arrayPacked);
        }
        ANGLE_CAPTURE_GL(EnableClientState, isCallValid, context, arrayPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Fogf(GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFogf, "context = %d, pname = %s, param = %f", CID(context),
          GLenumToString(GLESEnum::FogParameter, pname), param);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLFogf) &&
              ValidateFogf(context, angle::EntryPoint::GLFogf, pname, param)));
        if (isCallValid)
        {
            context->fogf(pname, param);
        }
        ANGLE_CAPTURE_GL(Fogf, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Fogfv(GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFogfv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::FogParameter, pname), (uintptr_t)params);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLFogfv) &&
              ValidateFogfv(context, angle::EntryPoint::GLFogfv, pname, params)));
        if (isCallValid)
        {
            context->fogfv(pname, params);
        }
        ANGLE_CAPTURE_GL(Fogfv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Fogx(GLenum pname, GLfixed param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFogx, "context = %d, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLESEnum::FogPName, pname), param);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLFogx) &&
              ValidateFogx(context, angle::EntryPoint::GLFogx, pname, param)));
        if (isCallValid)
        {
            context->fogx(pname, param);
        }
        ANGLE_CAPTURE_GL(Fogx, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Fogxv(GLenum pname, const GLfixed *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFogxv, "context = %d, pname = %s, param = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::FogPName, pname), (uintptr_t)param);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLFogxv) &&
              ValidateFogxv(context, angle::EntryPoint::GLFogxv, pname, param)));
        if (isCallValid)
        {
            context->fogxv(pname, param);
        }
        ANGLE_CAPTURE_GL(Fogxv, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Frustumf(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFrustumf, "context = %d, l = %f, r = %f, b = %f, t = %f, n = %f, f = %f",
          CID(context), l, r, b, t, n, f);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLFrustumf) &&
              ValidateFrustumf(context, angle::EntryPoint::GLFrustumf, l, r, b, t, n, f)));
        if (isCallValid)
        {
            context->frustumf(l, r, b, t, n, f);
        }
        ANGLE_CAPTURE_GL(Frustumf, isCallValid, context, l, r, b, t, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Frustumx(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLFrustumx,
          "context = %d, l = 0x%X, r = 0x%X, b = 0x%X, t = 0x%X, n = 0x%X, f = 0x%X", CID(context),
          l, r, b, t, n, f);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLFrustumx) &&
              ValidateFrustumx(context, angle::EntryPoint::GLFrustumx, l, r, b, t, n, f)));
        if (isCallValid)
        {
            context->frustumx(l, r, b, t, n, f);
        }
        ANGLE_CAPTURE_GL(Frustumx, isCallValid, context, l, r, b, t, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetClipPlanef(GLenum plane, GLfloat *equation)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetClipPlanef, "context = %d, plane = %s, equation = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::ClipPlaneName, plane), (uintptr_t)equation);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetClipPlanef(context, angle::EntryPoint::GLGetClipPlanef, plane, equation));
        if (isCallValid)
        {
            context->getClipPlanef(plane, equation);
        }
        ANGLE_CAPTURE_GL(GetClipPlanef, isCallValid, context, plane, equation);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetClipPlanex(GLenum plane, GLfixed *equation)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetClipPlanex, "context = %d, plane = %s, equation = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::ClipPlaneName, plane), (uintptr_t)equation);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetClipPlanex(context, angle::EntryPoint::GLGetClipPlanex, plane, equation));
        if (isCallValid)
        {
            context->getClipPlanex(plane, equation);
        }
        ANGLE_CAPTURE_GL(GetClipPlanex, isCallValid, context, plane, equation);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetFixedv(GLenum pname, GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetFixedv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::GetPName, pname), (uintptr_t)params);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetFixedv(context, angle::EntryPoint::GLGetFixedv, pname, params));
        if (isCallValid)
        {
            context->getFixedv(pname, params);
        }
        ANGLE_CAPTURE_GL(GetFixedv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetLightfv(GLenum light, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetLightfv, "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::LightName, light),
          GLenumToString(GLESEnum::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        LightParameter pnamePacked = PackParam<LightParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetLightfv(context, angle::EntryPoint::GLGetLightfv, light,
                                               pnamePacked, params));
        if (isCallValid)
        {
            context->getLightfv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(GetLightfv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetLightxv(GLenum light, GLenum pname, GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetLightxv, "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::LightName, light),
          GLenumToString(GLESEnum::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        LightParameter pnamePacked = PackParam<LightParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetLightxv(context, angle::EntryPoint::GLGetLightxv, light,
                                               pnamePacked, params));
        if (isCallValid)
        {
            context->getLightxv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(GetLightxv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetMaterialfv(GLenum face, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetMaterialfv,
          "context = %d, face = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TriangleFace, face),
          GLenumToString(GLESEnum::MaterialParameter, pname), (uintptr_t)params);

    if (context)
    {
        MaterialParameter pnamePacked = PackParam<MaterialParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetMaterialfv(context, angle::EntryPoint::GLGetMaterialfv, face,
                                                  pnamePacked, params));
        if (isCallValid)
        {
            context->getMaterialfv(face, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(GetMaterialfv, isCallValid, context, face, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetMaterialxv(GLenum face, GLenum pname, GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetMaterialxv,
          "context = %d, face = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TriangleFace, face),
          GLenumToString(GLESEnum::MaterialParameter, pname), (uintptr_t)params);

    if (context)
    {
        MaterialParameter pnamePacked = PackParam<MaterialParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetMaterialxv(context, angle::EntryPoint::GLGetMaterialxv, face,
                                                  pnamePacked, params));
        if (isCallValid)
        {
            context->getMaterialxv(face, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(GetMaterialxv, isCallValid, context, face, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexEnvfv(GLenum target, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexEnvfv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetTexEnvfv(context, angle::EntryPoint::GLGetTexEnvfv,
                                                targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->getTexEnvfv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(GetTexEnvfv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexEnviv(GLenum target, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexEnviv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetTexEnviv(context, angle::EntryPoint::GLGetTexEnviv,
                                                targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->getTexEnviv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(GetTexEnviv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexEnvxv(GLenum target, GLenum pname, GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexEnvxv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateGetTexEnvxv(context, angle::EntryPoint::GLGetTexEnvxv,
                                                targetPacked, pnamePacked, params));
        if (isCallValid)
        {
            context->getTexEnvxv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(GetTexEnvxv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexParameterxv(GLenum target, GLenum pname, GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetTexParameterxv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetTexParameterxv(context, angle::EntryPoint::GLGetTexParameterxv,
                                       targetPacked, pname, params));
        if (isCallValid)
        {
            context->getTexParameterxv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexParameterxv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LightModelf(GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightModelf, "context = %d, pname = %s, param = %f", CID(context),
          GLenumToString(GLESEnum::LightModelParameter, pname), param);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLLightModelf) &&
              ValidateLightModelf(context, angle::EntryPoint::GLLightModelf, pname, param)));
        if (isCallValid)
        {
            context->lightModelf(pname, param);
        }
        ANGLE_CAPTURE_GL(LightModelf, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LightModelfv(GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightModelfv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::LightModelParameter, pname), (uintptr_t)params);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLLightModelfv) &&
              ValidateLightModelfv(context, angle::EntryPoint::GLLightModelfv, pname, params)));
        if (isCallValid)
        {
            context->lightModelfv(pname, params);
        }
        ANGLE_CAPTURE_GL(LightModelfv, isCallValid, context, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LightModelx(GLenum pname, GLfixed param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightModelx, "context = %d, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLESEnum::LightModelParameter, pname), param);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLLightModelx) &&
              ValidateLightModelx(context, angle::EntryPoint::GLLightModelx, pname, param)));
        if (isCallValid)
        {
            context->lightModelx(pname, param);
        }
        ANGLE_CAPTURE_GL(LightModelx, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LightModelxv(GLenum pname, const GLfixed *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightModelxv, "context = %d, pname = %s, param = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::LightModelParameter, pname), (uintptr_t)param);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLLightModelxv) &&
              ValidateLightModelxv(context, angle::EntryPoint::GLLightModelxv, pname, param)));
        if (isCallValid)
        {
            context->lightModelxv(pname, param);
        }
        ANGLE_CAPTURE_GL(LightModelxv, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Lightf(GLenum light, GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightf, "context = %d, light = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLESEnum::LightName, light),
          GLenumToString(GLESEnum::LightParameter, pname), param);

    if (context)
    {
        LightParameter pnamePacked = PackParam<LightParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLLightf) &&
              ValidateLightf(context, angle::EntryPoint::GLLightf, light, pnamePacked, param)));
        if (isCallValid)
        {
            context->lightf(light, pnamePacked, param);
        }
        ANGLE_CAPTURE_GL(Lightf, isCallValid, context, light, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Lightfv(GLenum light, GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightfv, "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::LightName, light),
          GLenumToString(GLESEnum::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        LightParameter pnamePacked = PackParam<LightParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLLightfv) &&
              ValidateLightfv(context, angle::EntryPoint::GLLightfv, light, pnamePacked, params)));
        if (isCallValid)
        {
            context->lightfv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(Lightfv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Lightx(GLenum light, GLenum pname, GLfixed param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightx, "context = %d, light = %s, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLESEnum::LightName, light),
          GLenumToString(GLESEnum::LightParameter, pname), param);

    if (context)
    {
        LightParameter pnamePacked = PackParam<LightParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLLightx) &&
              ValidateLightx(context, angle::EntryPoint::GLLightx, light, pnamePacked, param)));
        if (isCallValid)
        {
            context->lightx(light, pnamePacked, param);
        }
        ANGLE_CAPTURE_GL(Lightx, isCallValid, context, light, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Lightxv(GLenum light, GLenum pname, const GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLightxv, "context = %d, light = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::LightName, light),
          GLenumToString(GLESEnum::LightParameter, pname), (uintptr_t)params);

    if (context)
    {
        LightParameter pnamePacked = PackParam<LightParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLLightxv) &&
              ValidateLightxv(context, angle::EntryPoint::GLLightxv, light, pnamePacked, params)));
        if (isCallValid)
        {
            context->lightxv(light, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(Lightxv, isCallValid, context, light, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LineWidthx(GLfixed width)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLineWidthx, "context = %d, width = 0x%X", CID(context), width);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLLineWidthx) &&
              ValidateLineWidthx(context, angle::EntryPoint::GLLineWidthx, width)));
        if (isCallValid)
        {
            context->lineWidthx(width);
        }
        ANGLE_CAPTURE_GL(LineWidthx, isCallValid, context, width);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LoadIdentity()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLoadIdentity, "context = %d", CID(context));

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLLoadIdentity) &&
              ValidateLoadIdentity(context, angle::EntryPoint::GLLoadIdentity)));
        if (isCallValid)
        {
            context->loadIdentity();
        }
        ANGLE_CAPTURE_GL(LoadIdentity, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LoadMatrixf(const GLfloat *m)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLoadMatrixf, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLLoadMatrixf) &&
              ValidateLoadMatrixf(context, angle::EntryPoint::GLLoadMatrixf, m)));
        if (isCallValid)
        {
            context->loadMatrixf(m);
        }
        ANGLE_CAPTURE_GL(LoadMatrixf, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LoadMatrixx(const GLfixed *m)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLoadMatrixx, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLLoadMatrixx) &&
              ValidateLoadMatrixx(context, angle::EntryPoint::GLLoadMatrixx, m)));
        if (isCallValid)
        {
            context->loadMatrixx(m);
        }
        ANGLE_CAPTURE_GL(LoadMatrixx, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LogicOp(GLenum opcode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLogicOp, "context = %d, opcode = %s", CID(context),
          GLenumToString(GLESEnum::LogicOp, opcode));

    if (context)
    {
        LogicalOperation opcodePacked = PackParam<LogicalOperation>(opcode);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLLogicOp) &&
              ValidateLogicOp(context, angle::EntryPoint::GLLogicOp, opcodePacked)));
        if (isCallValid)
        {
            context->logicOp(opcodePacked);
        }
        ANGLE_CAPTURE_GL(LogicOp, isCallValid, context, opcodePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Materialf(GLenum face, GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMaterialf, "context = %d, face = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLESEnum::TriangleFace, face),
          GLenumToString(GLESEnum::MaterialParameter, pname), param);

    if (context)
    {
        MaterialParameter pnamePacked = PackParam<MaterialParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLMaterialf) &&
              ValidateMaterialf(context, angle::EntryPoint::GLMaterialf, face, pnamePacked,
                                param)));
        if (isCallValid)
        {
            context->materialf(face, pnamePacked, param);
        }
        ANGLE_CAPTURE_GL(Materialf, isCallValid, context, face, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Materialfv(GLenum face, GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMaterialfv, "context = %d, face = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TriangleFace, face),
          GLenumToString(GLESEnum::MaterialParameter, pname), (uintptr_t)params);

    if (context)
    {
        MaterialParameter pnamePacked = PackParam<MaterialParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLMaterialfv) &&
              ValidateMaterialfv(context, angle::EntryPoint::GLMaterialfv, face, pnamePacked,
                                 params)));
        if (isCallValid)
        {
            context->materialfv(face, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(Materialfv, isCallValid, context, face, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Materialx(GLenum face, GLenum pname, GLfixed param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMaterialx, "context = %d, face = %s, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLESEnum::TriangleFace, face),
          GLenumToString(GLESEnum::MaterialParameter, pname), param);

    if (context)
    {
        MaterialParameter pnamePacked = PackParam<MaterialParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLMaterialx) &&
              ValidateMaterialx(context, angle::EntryPoint::GLMaterialx, face, pnamePacked,
                                param)));
        if (isCallValid)
        {
            context->materialx(face, pnamePacked, param);
        }
        ANGLE_CAPTURE_GL(Materialx, isCallValid, context, face, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Materialxv(GLenum face, GLenum pname, const GLfixed *param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMaterialxv, "context = %d, face = %s, pname = %s, param = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TriangleFace, face),
          GLenumToString(GLESEnum::MaterialParameter, pname), (uintptr_t)param);

    if (context)
    {
        MaterialParameter pnamePacked = PackParam<MaterialParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLMaterialxv) &&
              ValidateMaterialxv(context, angle::EntryPoint::GLMaterialxv, face, pnamePacked,
                                 param)));
        if (isCallValid)
        {
            context->materialxv(face, pnamePacked, param);
        }
        ANGLE_CAPTURE_GL(Materialxv, isCallValid, context, face, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MatrixMode(GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMatrixMode, "context = %d, mode = %s", CID(context),
          GLenumToString(GLESEnum::MatrixMode, mode));

    if (context)
    {
        MatrixType modePacked = PackParam<MatrixType>(mode);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLMatrixMode) &&
              ValidateMatrixMode(context, angle::EntryPoint::GLMatrixMode, modePacked)));
        if (isCallValid)
        {
            context->matrixMode(modePacked);
        }
        ANGLE_CAPTURE_GL(MatrixMode, isCallValid, context, modePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultMatrixf(const GLfloat *m)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultMatrixf, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLMultMatrixf) &&
              ValidateMultMatrixf(context, angle::EntryPoint::GLMultMatrixf, m)));
        if (isCallValid)
        {
            context->multMatrixf(m);
        }
        ANGLE_CAPTURE_GL(MultMatrixf, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultMatrixx(const GLfixed *m)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultMatrixx, "context = %d, m = 0x%016" PRIxPTR "", CID(context),
          (uintptr_t)m);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLMultMatrixx) &&
              ValidateMultMatrixx(context, angle::EntryPoint::GLMultMatrixx, m)));
        if (isCallValid)
        {
            context->multMatrixx(m);
        }
        ANGLE_CAPTURE_GL(MultMatrixx, isCallValid, context, m);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiTexCoord4f(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord4f, "context = %d, target = %s, s = %f, t = %f, r = %f, q = %f",
          CID(context), GLenumToString(GLESEnum::TextureUnit, target), s, t, r, q);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLMultiTexCoord4f) &&
              ValidateMultiTexCoord4f(context, angle::EntryPoint::GLMultiTexCoord4f, target, s, t,
                                      r, q)));
        if (isCallValid)
        {
            context->multiTexCoord4f(target, s, t, r, q);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord4f, isCallValid, context, target, s, t, r, q);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MultiTexCoord4x(GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLMultiTexCoord4x,
          "context = %d, texture = %s, s = 0x%X, t = 0x%X, r = 0x%X, q = 0x%X", CID(context),
          GLenumToString(GLESEnum::TextureUnit, texture), s, t, r, q);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLMultiTexCoord4x) &&
              ValidateMultiTexCoord4x(context, angle::EntryPoint::GLMultiTexCoord4x, texture, s, t,
                                      r, q)));
        if (isCallValid)
        {
            context->multiTexCoord4x(texture, s, t, r, q);
        }
        ANGLE_CAPTURE_GL(MultiTexCoord4x, isCallValid, context, texture, s, t, r, q);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Normal3f(GLfloat nx, GLfloat ny, GLfloat nz)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormal3f, "context = %d, nx = %f, ny = %f, nz = %f", CID(context), nx, ny, nz);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLNormal3f) &&
              ValidateNormal3f(context, angle::EntryPoint::GLNormal3f, nx, ny, nz)));
        if (isCallValid)
        {
            context->normal3f(nx, ny, nz);
        }
        ANGLE_CAPTURE_GL(Normal3f, isCallValid, context, nx, ny, nz);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Normal3x(GLfixed nx, GLfixed ny, GLfixed nz)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormal3x, "context = %d, nx = 0x%X, ny = 0x%X, nz = 0x%X", CID(context), nx,
          ny, nz);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLNormal3x) &&
              ValidateNormal3x(context, angle::EntryPoint::GLNormal3x, nx, ny, nz)));
        if (isCallValid)
        {
            context->normal3x(nx, ny, nz);
        }
        ANGLE_CAPTURE_GL(Normal3x, isCallValid, context, nx, ny, nz);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_NormalPointer(GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLNormalPointer,
          "context = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::NormalPointerType, type), stride, (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked = PackParam<VertexAttribType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLNormalPointer) &&
              ValidateNormalPointer(context, angle::EntryPoint::GLNormalPointer, typePacked, stride,
                                    pointer)));
        if (isCallValid)
        {
            context->normalPointer(typePacked, stride, pointer);
        }
        ANGLE_CAPTURE_GL(NormalPointer, isCallValid, context, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Orthof(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLOrthof, "context = %d, l = %f, r = %f, b = %f, t = %f, n = %f, f = %f",
          CID(context), l, r, b, t, n, f);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLOrthof) &&
              ValidateOrthof(context, angle::EntryPoint::GLOrthof, l, r, b, t, n, f)));
        if (isCallValid)
        {
            context->orthof(l, r, b, t, n, f);
        }
        ANGLE_CAPTURE_GL(Orthof, isCallValid, context, l, r, b, t, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Orthox(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLOrthox,
          "context = %d, l = 0x%X, r = 0x%X, b = 0x%X, t = 0x%X, n = 0x%X, f = 0x%X", CID(context),
          l, r, b, t, n, f);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLOrthox) &&
              ValidateOrthox(context, angle::EntryPoint::GLOrthox, l, r, b, t, n, f)));
        if (isCallValid)
        {
            context->orthox(l, r, b, t, n, f);
        }
        ANGLE_CAPTURE_GL(Orthox, isCallValid, context, l, r, b, t, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PointParameterf(GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointParameterf, "context = %d, pname = %s, param = %f", CID(context),
          GLenumToString(GLESEnum::AllEnums, pname), param);

    if (context)
    {
        PointParameter pnamePacked = PackParam<PointParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLPointParameterf) &&
              ValidatePointParameterf(context, angle::EntryPoint::GLPointParameterf, pnamePacked,
                                      param)));
        if (isCallValid)
        {
            context->pointParameterf(pnamePacked, param);
        }
        ANGLE_CAPTURE_GL(PointParameterf, isCallValid, context, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PointParameterfv(GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointParameterfv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, pname), (uintptr_t)params);

    if (context)
    {
        PointParameter pnamePacked = PackParam<PointParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLPointParameterfv) &&
              ValidatePointParameterfv(context, angle::EntryPoint::GLPointParameterfv, pnamePacked,
                                       params)));
        if (isCallValid)
        {
            context->pointParameterfv(pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(PointParameterfv, isCallValid, context, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PointParameterx(GLenum pname, GLfixed param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointParameterx, "context = %d, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLESEnum::AllEnums, pname), param);

    if (context)
    {
        PointParameter pnamePacked = PackParam<PointParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLPointParameterx) &&
              ValidatePointParameterx(context, angle::EntryPoint::GLPointParameterx, pnamePacked,
                                      param)));
        if (isCallValid)
        {
            context->pointParameterx(pnamePacked, param);
        }
        ANGLE_CAPTURE_GL(PointParameterx, isCallValid, context, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PointParameterxv(GLenum pname, const GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointParameterxv, "context = %d, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::AllEnums, pname), (uintptr_t)params);

    if (context)
    {
        PointParameter pnamePacked = PackParam<PointParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLPointParameterxv) &&
              ValidatePointParameterxv(context, angle::EntryPoint::GLPointParameterxv, pnamePacked,
                                       params)));
        if (isCallValid)
        {
            context->pointParameterxv(pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(PointParameterxv, isCallValid, context, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PointSize(GLfloat size)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointSize, "context = %d, size = %f", CID(context), size);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLPointSize) &&
              ValidatePointSize(context, angle::EntryPoint::GLPointSize, size)));
        if (isCallValid)
        {
            context->pointSize(size);
        }
        ANGLE_CAPTURE_GL(PointSize, isCallValid, context, size);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PointSizex(GLfixed size)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPointSizex, "context = %d, size = 0x%X", CID(context), size);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLPointSizex) &&
              ValidatePointSizex(context, angle::EntryPoint::GLPointSizex, size)));
        if (isCallValid)
        {
            context->pointSizex(size);
        }
        ANGLE_CAPTURE_GL(PointSizex, isCallValid, context, size);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PolygonOffsetx(GLfixed factor, GLfixed units)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPolygonOffsetx, "context = %d, factor = 0x%X, units = 0x%X", CID(context),
          factor, units);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidatePolygonOffsetx(context, angle::EntryPoint::GLPolygonOffsetx, factor, units));
        if (isCallValid)
        {
            context->polygonOffsetx(factor, units);
        }
        ANGLE_CAPTURE_GL(PolygonOffsetx, isCallValid, context, factor, units);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PopMatrix()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPopMatrix, "context = %d", CID(context));

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLPopMatrix) &&
              ValidatePopMatrix(context, angle::EntryPoint::GLPopMatrix)));
        if (isCallValid)
        {
            context->popMatrix();
        }
        ANGLE_CAPTURE_GL(PopMatrix, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PushMatrix()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLPushMatrix, "context = %d", CID(context));

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLPushMatrix) &&
              ValidatePushMatrix(context, angle::EntryPoint::GLPushMatrix)));
        if (isCallValid)
        {
            context->pushMatrix();
        }
        ANGLE_CAPTURE_GL(PushMatrix, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Rotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRotatef, "context = %d, angle = %f, x = %f, y = %f, z = %f", CID(context),
          angle, x, y, z);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLRotatef) &&
              ValidateRotatef(context, angle::EntryPoint::GLRotatef, angle, x, y, z)));
        if (isCallValid)
        {
            context->rotatef(angle, x, y, z);
        }
        ANGLE_CAPTURE_GL(Rotatef, isCallValid, context, angle, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Rotatex(GLfixed angle, GLfixed x, GLfixed y, GLfixed z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLRotatex, "context = %d, angle = 0x%X, x = 0x%X, y = 0x%X, z = 0x%X",
          CID(context), angle, x, y, z);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLRotatex) &&
              ValidateRotatex(context, angle::EntryPoint::GLRotatex, angle, x, y, z)));
        if (isCallValid)
        {
            context->rotatex(angle, x, y, z);
        }
        ANGLE_CAPTURE_GL(Rotatex, isCallValid, context, angle, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SampleCoveragex(GLclampx value, GLboolean invert)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLSampleCoveragex, "context = %d, value = 0x%X, invert = %s", CID(context),
          value, GLbooleanToString(invert));

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLSampleCoveragex) &&
              ValidateSampleCoveragex(context, angle::EntryPoint::GLSampleCoveragex, value,
                                      invert)));
        if (isCallValid)
        {
            context->sampleCoveragex(value, invert);
        }
        ANGLE_CAPTURE_GL(SampleCoveragex, isCallValid, context, value, invert);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Scalef(GLfloat x, GLfloat y, GLfloat z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLScalef, "context = %d, x = %f, y = %f, z = %f", CID(context), x, y, z);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLScalef) &&
              ValidateScalef(context, angle::EntryPoint::GLScalef, x, y, z)));
        if (isCallValid)
        {
            context->scalef(x, y, z);
        }
        ANGLE_CAPTURE_GL(Scalef, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Scalex(GLfixed x, GLfixed y, GLfixed z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLScalex, "context = %d, x = 0x%X, y = 0x%X, z = 0x%X", CID(context), x, y, z);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLScalex) &&
              ValidateScalex(context, angle::EntryPoint::GLScalex, x, y, z)));
        if (isCallValid)
        {
            context->scalex(x, y, z);
        }
        ANGLE_CAPTURE_GL(Scalex, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ShadeModel(GLenum mode)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLShadeModel, "context = %d, mode = %s", CID(context),
          GLenumToString(GLESEnum::ShadingModel, mode));

    if (context)
    {
        ShadingModel modePacked = PackParam<ShadingModel>(mode);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLShadeModel) &&
              ValidateShadeModel(context, angle::EntryPoint::GLShadeModel, modePacked)));
        if (isCallValid)
        {
            context->shadeModel(modePacked);
        }
        ANGLE_CAPTURE_GL(ShadeModel, isCallValid, context, modePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexCoordPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexCoordPointer,
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLESEnum::TexCoordPointerType, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked = PackParam<VertexAttribType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTexCoordPointer) &&
              ValidateTexCoordPointer(context, angle::EntryPoint::GLTexCoordPointer, size,
                                      typePacked, stride, pointer)));
        if (isCallValid)
        {
            context->texCoordPointer(size, typePacked, stride, pointer);
        }
        ANGLE_CAPTURE_GL(TexCoordPointer, isCallValid, context, size, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexEnvf(GLenum target, GLenum pname, GLfloat param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexEnvf, "context = %d, target = %s, pname = %s, param = %f", CID(context),
          GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), param);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTexEnvf) &&
              ValidateTexEnvf(context, angle::EntryPoint::GLTexEnvf, targetPacked, pnamePacked,
                              param)));
        if (isCallValid)
        {
            context->texEnvf(targetPacked, pnamePacked, param);
        }
        ANGLE_CAPTURE_GL(TexEnvf, isCallValid, context, targetPacked, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexEnvfv(GLenum target, GLenum pname, const GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexEnvfv, "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTexEnvfv) &&
              ValidateTexEnvfv(context, angle::EntryPoint::GLTexEnvfv, targetPacked, pnamePacked,
                               params)));
        if (isCallValid)
        {
            context->texEnvfv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(TexEnvfv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexEnvi(GLenum target, GLenum pname, GLint param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexEnvi, "context = %d, target = %s, pname = %s, param = %d", CID(context),
          GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), param);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTexEnvi) &&
              ValidateTexEnvi(context, angle::EntryPoint::GLTexEnvi, targetPacked, pnamePacked,
                              param)));
        if (isCallValid)
        {
            context->texEnvi(targetPacked, pnamePacked, param);
        }
        ANGLE_CAPTURE_GL(TexEnvi, isCallValid, context, targetPacked, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexEnviv(GLenum target, GLenum pname, const GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexEnviv, "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTexEnviv) &&
              ValidateTexEnviv(context, angle::EntryPoint::GLTexEnviv, targetPacked, pnamePacked,
                               params)));
        if (isCallValid)
        {
            context->texEnviv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(TexEnviv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexEnvx(GLenum target, GLenum pname, GLfixed param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexEnvx, "context = %d, target = %s, pname = %s, param = 0x%X", CID(context),
          GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), param);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTexEnvx) &&
              ValidateTexEnvx(context, angle::EntryPoint::GLTexEnvx, targetPacked, pnamePacked,
                              param)));
        if (isCallValid)
        {
            context->texEnvx(targetPacked, pnamePacked, param);
        }
        ANGLE_CAPTURE_GL(TexEnvx, isCallValid, context, targetPacked, pnamePacked, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexEnvxv(GLenum target, GLenum pname, const GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexEnvxv, "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
          CID(context), GLenumToString(GLESEnum::TextureEnvTarget, target),
          GLenumToString(GLESEnum::TextureEnvParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureEnvTarget targetPacked   = PackParam<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = PackParam<TextureEnvParameter>(pname);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTexEnvxv) &&
              ValidateTexEnvxv(context, angle::EntryPoint::GLTexEnvxv, targetPacked, pnamePacked,
                               params)));
        if (isCallValid)
        {
            context->texEnvxv(targetPacked, pnamePacked, params);
        }
        ANGLE_CAPTURE_GL(TexEnvxv, isCallValid, context, targetPacked, pnamePacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexParameterx(GLenum target, GLenum pname, GLfixed param)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterx, "context = %d, target = %s, pname = %s, param = 0x%X",
          CID(context), GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::GetTextureParameter, pname), param);

    if (context)
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateTexParameterx(context, angle::EntryPoint::GLTexParameterx,
                                                  targetPacked, pname, param));
        if (isCallValid)
        {
            context->texParameterx(targetPacked, pname, param);
        }
        ANGLE_CAPTURE_GL(TexParameterx, isCallValid, context, targetPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexParameterxv(GLenum target, GLenum pname, const GLfixed *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTexParameterxv,
          "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          GLenumToString(GLESEnum::TextureTarget, target),
          GLenumToString(GLESEnum::GetTextureParameter, pname), (uintptr_t)params);

    if (context)
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = (context->skipValidation() ||
                            ValidateTexParameterxv(context, angle::EntryPoint::GLTexParameterxv,
                                                   targetPacked, pname, params));
        if (isCallValid)
        {
            context->texParameterxv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(TexParameterxv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Translatef(GLfloat x, GLfloat y, GLfloat z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTranslatef, "context = %d, x = %f, y = %f, z = %f", CID(context), x, y, z);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTranslatef) &&
              ValidateTranslatef(context, angle::EntryPoint::GLTranslatef, x, y, z)));
        if (isCallValid)
        {
            context->translatef(x, y, z);
        }
        ANGLE_CAPTURE_GL(Translatef, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Translatex(GLfixed x, GLfixed y, GLfixed z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLTranslatex, "context = %d, x = 0x%X, y = 0x%X, z = 0x%X", CID(context), x, y,
          z);

    if (context)
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLTranslatex) &&
              ValidateTranslatex(context, angle::EntryPoint::GLTranslatex, x, y, z)));
        if (isCallValid)
        {
            context->translatex(x, y, z);
        }
        ANGLE_CAPTURE_GL(Translatex, isCallValid, context, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexPointer,
          "context = %d, size = %d, type = %s, stride = %d, pointer = 0x%016" PRIxPTR "",
          CID(context), size, GLenumToString(GLESEnum::VertexPointerType, type), stride,
          (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked = PackParam<VertexAttribType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid =
            (context->skipValidation() ||
             (ValidatePixelLocalStorageInactive(context, angle::EntryPoint::GLVertexPointer) &&
              ValidateVertexPointer(context, angle::EntryPoint::GLVertexPointer, size, typePacked,
                                    stride, pointer)));
        if (isCallValid)
        {
            context->vertexPointer(size, typePacked, stride, pointer);
        }
        ANGLE_CAPTURE_GL(VertexPointer, isCallValid, context, size, typePacked, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

}  // extern "C"
