/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.LabelExistsException;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.shared.LockNone;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import virtuoso.jena.driver.VirtGraph;
import virtuoso.jena.driver.VirtModel;
import virtuoso.jena.driver.VirtResSetQIter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtDataset
extends VirtGraph
implements Dataset {
    Model defaultModel = null;
    private Context m_context = new Context();
    Lock lock = null;

    public VirtDataset() {
    }

    public VirtDataset(String string, DataSource dataSource) {
        super(string, dataSource);
    }

    protected VirtDataset(VirtGraph virtGraph) {
        this.graphName = virtGraph.getGraphName();
        this.setReadFromAllGraphs(virtGraph.getReadFromAllGraphs());
        this.url_hostlist = virtGraph.getGraphUrl();
        this.user = virtGraph.getGraphUser();
        this.password = virtGraph.getGraphPassword();
        this.roundrobin = virtGraph.roundrobin;
        this.setFetchSize(virtGraph.getFetchSize());
        this.connection = virtGraph.getConnection();
    }

    public VirtDataset(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public Model getDefaultModel() {
        return this.defaultModel;
    }

    public void setDefaultModel(Model model) {
        if (!(model instanceof VirtDataset)) {
            throw new IllegalArgumentException("VirtDataSource supports only VirtModel as default model");
        }
        this.defaultModel = model;
    }

    public Model getNamedModel(String string) {
        try {
            DataSource dataSource = this.getDataSource();
            if (dataSource != null) {
                return new VirtModel(new VirtGraph(string, dataSource));
            }
            return new VirtModel(new VirtGraph(string, this.getGraphUrl(), this.getGraphUser(), this.getGraphPassword()));
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public boolean containsNamedModel(String string) {
        String string2 = "select count(*) from (sparql select * where { graph `iri(??)` { ?s ?p ?o }})f";
        ResultSet resultSet = null;
        int n = 0;
        this.checkOpen();
        try {
            PreparedStatement preparedStatement = this.prepareStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
        return n != 0;
    }

    public void addNamedModel(String string, Model model) throws LabelExistsException {
        PreparedStatement preparedStatement;
        String string2 = "select count(*) from (sparql select * where { graph `iri(??)` { ?s ?p ?o }})f";
        ResultSet resultSet = null;
        int n = 0;
        this.checkOpen();
        try {
            preparedStatement = this.prepareStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
        try {
            if (n != 0) {
                throw new LabelExistsException("A model with ID '" + string + "' already exists.");
            }
            preparedStatement = model.getGraph();
            int n2 = 0;
            PreparedStatement preparedStatement2 = this.prepareStatement("sparql insert into graph iri(??) { `iri(??)` `iri(??)` `bif:__rdf_long_from_batch_params(??,??,??)` }");
            ExtendedIterator extendedIterator = preparedStatement.find(Node.ANY, Node.ANY, Node.ANY);
            while (extendedIterator.hasNext()) {
                Triple triple = (Triple)extendedIterator.next();
                preparedStatement2.setString(1, string);
                this.bindSubject(preparedStatement2, 2, triple.getSubject());
                this.bindPredicate(preparedStatement2, 3, triple.getPredicate());
                this.bindObject(preparedStatement2, 4, triple.getObject());
                preparedStatement2.addBatch();
                if (++n2 <= 5000) continue;
                preparedStatement2.executeBatch();
                preparedStatement2.clearBatch();
                n2 = 0;
            }
            if (n2 > 0) {
                preparedStatement2.executeBatch();
                preparedStatement2.clearBatch();
            }
            preparedStatement2.close();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public void removeNamedModel(String string) {
        String string2 = "sparql clear graph <" + string + ">";
        this.checkOpen();
        try {
            Statement statement = this.createStatement();
            statement.executeQuery(string2);
            statement.close();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public void replaceNamedModel(String string, Model model) {
        try {
            this.getConnection().setAutoCommit(false);
            this.removeNamedModel(string);
            this.addNamedModel(string, model);
            this.getConnection().commit();
            this.getConnection().setAutoCommit(true);
        }
        catch (Exception exception) {
            try {
                this.getConnection().rollback();
            }
            catch (Exception exception2) {
                throw new JenaException("Could not replace model, and could not rollback!", (Throwable)exception2);
            }
            throw new JenaException("Could not replace model:", (Throwable)exception);
        }
    }

    public Iterator<String> listNames() {
        String string = "DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS()";
        ResultSet resultSet = null;
        boolean bl = false;
        this.checkOpen();
        try {
            LinkedList<String> linkedList = new LinkedList<String>();
            Statement statement = this.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                linkedList.add(resultSet.getString(1));
            }
            resultSet.close();
            return linkedList.iterator();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public Lock getLock() {
        if (this.lock == null) {
            this.lock = new LockNone();
        }
        return this.lock;
    }

    public Context getContext() {
        return this.m_context;
    }

    public boolean supportsTransactions() {
        return true;
    }

    public void begin(ReadWrite readWrite) {
        try {
            this.getConnection().setAutoCommit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void commit() {
        try {
            this.getConnection().commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void abort() {
        try {
            this.getConnection().rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isInTransaction() {
        try {
            return !this.getConnection().getAutoCommit();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void end() {
        try {
            this.getConnection().rollback();
            this.getConnection().setAutoCommit(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DatasetGraph asDatasetGraph() {
        return new VirtDataSetGraph(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VirtDataSetGraph
    implements DatasetGraph {
        VirtDataset vd = null;

        public VirtDataSetGraph(VirtDataset virtDataset2) {
            this.vd = virtDataset2;
        }

        public Graph getDefaultGraph() {
            return this.vd;
        }

        public Graph getGraph(Node node) {
            try {
                return new VirtGraph(node.toString(), this.vd.getGraphUrl(), this.vd.getGraphUser(), this.vd.getGraphPassword());
            }
            catch (Exception exception) {
                throw new JenaException((Throwable)exception);
            }
        }

        public boolean containsGraph(Node node) {
            return VirtDataset.this.containsNamedModel(node.toString());
        }

        protected List<Node> getListGraphNodes() {
            String string = "DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS()";
            ResultSet resultSet = null;
            boolean bl = false;
            this.vd.checkOpen();
            try {
                LinkedList<Node> linkedList = new LinkedList<Node>();
                Statement statement = this.vd.createStatement();
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    linkedList.add(Node.createURI((String)resultSet.getString(1)));
                }
                resultSet.close();
                return linkedList;
            }
            catch (Exception exception) {
                throw new JenaException((Throwable)exception);
            }
        }

        public Iterator<Node> listGraphNodes() {
            return this.getListGraphNodes().iterator();
        }

        public Lock getLock() {
            return this.vd.getLock();
        }

        public long size() {
            return this.vd.size();
        }

        public void close() {
            this.vd.close();
        }

        public Context getContext() {
            return this.vd.m_context;
        }

        public void setDefaultGraph(Graph graph) {
            if (!(graph instanceof VirtGraph)) {
                throw new IllegalArgumentException("VirtDataSetGraph.setDefaultGraph() supports only VirtGraph as default graph");
            }
            this.vd = new VirtDataset((VirtGraph)graph);
        }

        public void addGraph(Node node, Graph graph) {
            boolean bl = false;
            try {
                bl = this.vd.getConnection().getAutoCommit();
                if (bl) {
                    this.vd.getConnection().setAutoCommit(false);
                }
                this.vd.clearGraph(node.toString());
                ExtendedIterator extendedIterator = graph.find(Node.ANY, Node.ANY, Node.ANY);
                this.vd.add(node.toString(), (Iterator<Triple>)extendedIterator, null);
                this.vd.getConnection().commit();
            }
            catch (Exception exception) {
                try {
                    this.vd.getConnection().rollback();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw new JenaException("Error in addGraph:" + exception);
            }
            finally {
                if (bl) {
                    try {
                        this.vd.getConnection().setAutoCommit(true);
                    }
                    catch (Exception exception) {}
                }
            }
        }

        public void removeGraph(Node node) {
            boolean bl = false;
            try {
                bl = this.vd.getConnection().getAutoCommit();
                if (bl) {
                    this.vd.getConnection().setAutoCommit(false);
                }
                this.vd.clearGraph(node.toString());
                this.vd.getConnection().commit();
            }
            catch (Exception exception) {
                try {
                    this.vd.getConnection().rollback();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw new JenaException("Error in removeGraph:" + exception);
            }
            finally {
                if (bl) {
                    try {
                        this.vd.getConnection().setAutoCommit(true);
                    }
                    catch (Exception exception) {}
                }
            }
        }

        public void add(Quad quad) {
            this.vd.performAdd(quad.getGraph().toString(), quad.getSubject(), quad.getPredicate(), quad.getObject());
        }

        public void delete(Quad quad) {
            this.vd.performDelete(quad.getGraph().toString(), quad.getSubject(), quad.getPredicate(), quad.getObject());
        }

        public void add(Node node, Node node2, Node node3, Node node4) {
            this.vd.performAdd(node.toString(), node2, node3, node4);
        }

        public void delete(Node node, Node node2, Node node3, Node node4) {
            this.vd.performDelete(node.toString(), node2, node3, node4);
        }

        public void deleteAny(Node node, Node node2, Node node3, Node node4) {
            Triple triple = new Triple(node2, node3, node4);
            if (Node.ANY.equals((Object)node)) {
                String string = "DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS()";
                ResultSet resultSet = null;
                Statement statement = null;
                this.vd.checkOpen();
                try {
                    statement = this.vd.createStatement();
                    resultSet = statement.executeQuery(string);
                    while (resultSet.next()) {
                        this.vd.delete_match(resultSet.getString(1), (TripleMatch)triple);
                    }
                }
                catch (Exception exception) {
                    throw new JenaException("Error in deleteAny():" + exception);
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            this.vd.delete_match(node.toString(), (TripleMatch)triple);
        }

        public Iterator<Quad> find() {
            return this.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
        }

        public Iterator<Quad> find(Quad quad) {
            return this.find(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
        }

        public Iterator<Quad> find(Node node, Node node2, Node node3, Node node4) {
            List<Node> list;
            if (this.isWildcard(node)) {
                list = this.getListGraphNodes();
            } else {
                list = new LinkedList<Node>();
                list.add(node);
            }
            return new VirtResSetQIter(this.vd, list.iterator(), (TripleMatch)new Triple(node2, node3, node4));
        }

        public Iterator<Quad> findNG(Node node, Node node2, Node node3, Node node4) {
            return this.find(node, node2, node3, node4);
        }

        public boolean contains(Node node, Node node2, Node node3, Node node4) {
            if (this.isWildcard(node)) {
                boolean bl = this.vd.getReadFromAllGraphs();
                this.vd.setReadFromAllGraphs(true);
                boolean bl2 = this.vd.graphBaseContains(null, new Triple(node2, node3, node4));
                this.vd.setReadFromAllGraphs(bl);
                return bl2;
            }
            return this.vd.graphBaseContains(node.toString(), new Triple(node2, node3, node4));
        }

        public boolean contains(Quad quad) {
            return this.contains(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
        }

        public boolean isEmpty() {
            return this.contains(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
        }

        protected boolean isWildcard(Node node) {
            return node == null || Node.ANY.equals((Object)node);
        }
    }
}

