<?xml version="1.0"?> 
<!--  
 -
 -  $Id: XBEL.xsl,v 1.2.2.2 2012/03/08 10:46:15 source Exp $
 -
 -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)
 -  project.
 -  
 -  Copyright (C) 1998-2012 OpenLink Software
 -  
 -  This project is free software; you can redistribute it and/or modify it
 -  under the terms of the GNU General Public License as published by the
 -  Free Software Foundation; only version 2 of the License, dated June 1991.
 -  
 -  This program is distributed in the hope that it will be useful, but
 -  WITHOUT ANY WARRANTY; without even the implied warranty of
 -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 -  General Public License for more details.
 -  
 -  You should have received a copy of the GNU General Public License along
 -  with this program; if not, write to the Free Software Foundation, Inc.,
 -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 -
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" indent="yes" encoding="UTF-8"/>
  <xsl:template match="root">
    <xbel version="1.0">
      <title>My Bookmarks</title>
      <xsl:apply-templates/>
    </xbel>
  </xsl:template>
  <xsl:template match="folder">
    <folder folded="yes">
      <xsl:attribute name="ID"><xsl:value-of select="@id"/></xsl:attribute>
      <title>
        <xsl:value-of select="@name"/>
      </title>
      <xsl:apply-templates select="bookmark"/>
      <xsl:apply-templates select="folder"/>
    </folder>
  </xsl:template>
  <xsl:template match="bookmark">
    <bookmark>
      <xsl:attribute name="href"><xsl:value-of select="@uri"/></xsl:attribute>
      <xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
      <title><xsl:value-of select="@name"/></title>
      <xsl:if test="./desc != ''">
        <desc><xsl:value-of select="./desc"/></desc>
      </xsl:if>
    </bookmark>
    <xsl:apply-templates select="bookmark"/>
  </xsl:template>
</xsl:stylesheet>
