/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};

static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;
static ValaCallableExpressionIface * vala_method_call_vala_callable_expression_parent_iface = NULL;

static void vala_method_call_set_call (ValaMethodCall* self,
                                ValaExpression* value);
static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self,
                                      gboolean value);
static void vala_method_call_real_add_argument (ValaCallableExpression* base,
                                         ValaExpression* arg);
static ValaList* vala_method_call_real_get_argument_list (ValaCallableExpression* base);
static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static void vala_method_call_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);
static GType vala_method_call_get_type_once (void);

static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}

ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_method_call_set_call (ValaMethodCall* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_method_call_real_get_is_yield_expression (ValaCallableExpression* base)
{
	gboolean result;
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	result = self->priv->_is_yield_expression;
	return result;
}

static void
vala_method_call_real_set_is_yield_expression (ValaCallableExpression* base,
                                               gboolean value)
{
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	self->priv->_is_yield_expression = value;
}

gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_assert;
	return result;
}

static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}

gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_constructv_chainup;
	return result;
}

static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}

gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_method_call_set_is_chainup (ValaMethodCall* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}

/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}

ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
static void
vala_method_call_real_add_argument (ValaCallableExpression* base,
                                    ValaExpression* arg)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
static ValaList*
vala_method_call_real_get_argument_list (ValaCallableExpression* base)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	ValaList* result = NULL;
	self = (ValaMethodCall*) base;
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		gint _expr_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_expr_list = _tmp2_;
		_tmp3_ = _expr_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_expr_size = _tmp5_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_expr_index = _expr_index + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = vala_list_get (_tmp8_, _expr_index);
			expr = (ValaExpression*) _tmp9_;
			_tmp10_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (expr);
		}
	}
}

static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	if (index >= 0) {
		ValaList* _tmp3_;
		_tmp3_ = self->priv->argument_list;
		vala_list_set (_tmp3_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = method_type;
	if (_tmp4_ != NULL) {
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = method_type;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strcmp0 (_tmp9_, "GLib.N_") == 0;
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			gboolean _tmp14_;
			_tmp11_ = self->priv->argument_list;
			_tmp12_ = vala_list_get (_tmp11_, 0);
			_tmp13_ = (ValaExpression*) _tmp12_;
			_tmp14_ = vala_expression_is_constant (_tmp13_);
			_vala_code_node_unref0 (_tmp13_);
			result = _tmp14_;
			return result;
		} else {
			ValaMethodType* _tmp15_;
			ValaMethod* _tmp16_;
			ValaMethod* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp15_ = method_type;
			_tmp16_ = vala_method_type_get_method_symbol (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp19_, "GLib.NC_") == 0;
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				gboolean _tmp21_ = FALSE;
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 0);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				if (_tmp25_) {
					ValaList* _tmp26_;
					gpointer _tmp27_;
					ValaExpression* _tmp28_;
					_tmp26_ = self->priv->argument_list;
					_tmp27_ = vala_list_get (_tmp26_, 1);
					_tmp28_ = (ValaExpression*) _tmp27_;
					_tmp21_ = vala_expression_is_constant (_tmp28_);
					_vala_code_node_unref0 (_tmp28_);
				} else {
					_tmp21_ = FALSE;
				}
				result = _tmp21_;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			if (!vala_expression_is_accessible (_tmp8_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp9_ = vala_method_call_get_call (self);
	_tmp10_ = _tmp9_;
	result = vala_expression_is_accessible (_tmp10_, sym);
	return result;
}

static void
vala_method_call_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference)
{
	ValaMethodCall * self;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_method_call_get_call (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_value_type (_tmp3_);
	_tmp5_ = _tmp4_;
	mtype = _tmp5_;
	_tmp6_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp6_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp7_ = mtype;
		_tmp8_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp9_ = _tmp8_;
		m = _tmp9_;
		_tmp12_ = m;
		_tmp13_ = vala_method_get_coroutine (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp15_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp16_ = _tmp15_;
			_tmp11_ = !_tmp16_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp20_ = _tmp19_;
			_tmp10_ = g_strcmp0 (_tmp20_, "end") != 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			ValaMethod* _tmp21_;
			_tmp21_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp21_, collection, source_reference);
		}
	} else {
		ValaDataType* _tmp22_;
		_tmp22_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp22_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp23_;
			ValaTypeSymbol* _tmp24_;
			ValaTypeSymbol* _tmp25_;
			ValaMethod* m = NULL;
			ValaClass* _tmp26_;
			ValaCreationMethod* _tmp27_;
			ValaCreationMethod* _tmp28_;
			ValaMethod* _tmp29_;
			_tmp23_ = mtype;
			_tmp24_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp25_ = _tmp24_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_CLASS, ValaClass);
			_tmp26_ = cl;
			_tmp27_ = vala_class_get_default_construction_method (_tmp26_);
			_tmp28_ = _tmp27_;
			m = (ValaMethod*) _tmp28_;
			_tmp29_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp29_, collection, source_reference);
		} else {
			ValaDataType* _tmp30_;
			_tmp30_ = mtype;
			if (VALA_IS_DELEGATE_TYPE (_tmp30_)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp31_;
				ValaDelegate* _tmp32_;
				ValaDelegate* _tmp33_;
				ValaDelegate* _tmp34_;
				_tmp31_ = mtype;
				_tmp32_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp33_ = _tmp32_;
				d = _tmp33_;
				_tmp34_ = d;
				vala_code_node_get_error_types ((ValaCodeNode*) _tmp34_, collection, source_reference);
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp35_;
		gint _expr_size = 0;
		ValaList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _expr_index = 0;
		_tmp35_ = self->priv->argument_list;
		_expr_list = _tmp35_;
		_tmp36_ = _expr_list;
		_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_expr_size = _tmp38_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp39_;
			gint _tmp40_;
			ValaExpression* expr = NULL;
			ValaList* _tmp41_;
			gpointer _tmp42_;
			ValaExpression* _tmp43_;
			_expr_index = _expr_index + 1;
			_tmp39_ = _expr_index;
			_tmp40_ = _expr_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _expr_list;
			_tmp42_ = vala_list_get (_tmp41_, _expr_index);
			expr = (ValaExpression*) _tmp42_;
			_tmp43_ = expr;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp43_, collection, source_reference);
			_vala_code_node_unref0 (expr);
		}
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp13_;
	ValaExpression* _tmp14_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp15_;
	ValaExpression* _tmp16_;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp111_;
	ValaExpression* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp114_;
	ValaDataType* _tmp115_;
	gboolean _tmp116_ = FALSE;
	ValaProfile _tmp117_;
	ValaProfile _tmp118_;
	gboolean gobject_chainup = FALSE;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp144_;
	gboolean _tmp230_ = FALSE;
	ValaExpression* _tmp231_;
	ValaExpression* _tmp232_;
	gboolean _tmp303_ = FALSE;
	gboolean _tmp304_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp319_;
	ValaDataType* _tmp320_;
	ValaDataType* _tmp321_;
	ValaList* params = NULL;
	ValaDataType* _tmp322_;
	ValaList* _tmp323_;
	ValaList* _tmp324_;
	ValaDataType* _tmp325_;
	ValaExpression* last_arg = NULL;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp381_;
	ValaIterator* _tmp382_;
	gboolean _tmp432_ = FALSE;
	ValaDataType* _tmp433_;
	gboolean _tmp454_ = FALSE;
	ValaDataType* _tmp455_;
	gboolean force_lambda_method_closure = FALSE;
	gboolean _tmp535_ = FALSE;
	gboolean _tmp536_;
	gboolean _tmp537_;
	ValaDataType* _tmp557_;
	ValaDataType* _tmp568_;
	ValaDataType* _tmp569_;
	ValaDataType* _tmp570_;
	ValaDataType* _tmp571_;
	ValaDataType* _tmp572_;
	ValaDataType* _tmp573_;
	ValaList* _tmp574_;
	ValaDataType* _tmp575_;
	ValaDataType* _tmp576_;
	gboolean _tmp577_;
	gboolean _tmp578_;
	ValaDataType* _tmp601_;
	ValaSemanticAnalyzer* _tmp850_;
	ValaSemanticAnalyzer* _tmp851_;
	ValaDataType* _tmp852_;
	ValaList* _tmp853_;
	ValaList* _tmp854_;
	gboolean _tmp881_ = FALSE;
	gboolean _tmp882_ = FALSE;
	ValaCreationMethod* _tmp883_;
	ValaDataType* _tmp911_;
	ValaDataType* _tmp912_;
	gboolean _tmp913_;
	gboolean _tmp914_;
	gboolean _tmp975_;
	gboolean _tmp976_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	if (VALA_IS_MEMBER_ACCESS (_tmp6_)) {
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = vala_method_call_get_call (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_member_access_get_null_safe_access (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp10_ = _tmp9_;
		_tmp4_ = _tmp10_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp11_;
		gboolean _tmp12_;
		vala_code_node_set_error ((ValaCodeNode*) self, !VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression), context));
		_tmp11_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		result = !_tmp12_;
		return result;
	}
	_tmp13_ = vala_method_call_get_call (self);
	_tmp14_ = _tmp13_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp14_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp15_ = vala_method_call_get_call (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_expression_get_value_type (_tmp16_);
	_tmp18_ = _tmp17_;
	if (VALA_IS_DELEGATE_TYPE (_tmp18_)) {
		ValaExpression* _tmp19_;
		ValaExpression* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		_tmp19_ = vala_method_call_get_call (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_expression_get_value_type (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _vala_code_node_ref0 (_tmp22_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp23_;
	} else {
		ValaExpression* _tmp24_;
		ValaExpression* _tmp25_;
		_tmp24_ = vala_method_call_get_call (self);
		_tmp25_ = _tmp24_;
		if (VALA_IS_MEMBER_ACCESS (_tmp25_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp26_;
			ValaExpression* _tmp27_;
			ValaMemberAccess* _tmp28_;
			gboolean _tmp29_;
			gboolean _tmp30_;
			ValaMemberAccess* _tmp39_;
			ValaList* _tmp40_;
			ValaList* _tmp41_;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			gboolean _tmp95_ = FALSE;
			ValaMemberAccess* _tmp96_;
			ValaSymbol* _tmp97_;
			ValaSymbol* _tmp98_;
			_tmp26_ = vala_method_call_get_call (self);
			_tmp27_ = _tmp26_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp28_ = ma;
			_tmp29_ = vala_member_access_get_prototype_access (_tmp28_);
			_tmp30_ = _tmp29_;
			if (_tmp30_) {
				ValaSourceReference* _tmp31_;
				ValaSourceReference* _tmp32_;
				ValaExpression* _tmp33_;
				ValaExpression* _tmp34_;
				ValaSymbol* _tmp35_;
				ValaSymbol* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_method_call_get_call (self);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_expression_get_symbol_reference (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_symbol_get_full_name (_tmp36_);
				_tmp38_ = _tmp37_;
				vala_report_error (_tmp32_, "Access to instance member `%s' denied", _tmp38_);
				_g_free0 (_tmp38_);
				result = FALSE;
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp39_ = ma;
			_tmp40_ = vala_member_access_get_type_arguments (_tmp39_);
			_tmp41_ = _vala_iterable_ref0 (_tmp40_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp41_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			if (_tmp44_ != NULL) {
				ValaMemberAccess* _tmp45_;
				ValaExpression* _tmp46_;
				ValaExpression* _tmp47_;
				ValaDataType* _tmp48_;
				ValaDataType* _tmp49_;
				ValaDataType* _tmp50_;
				ValaMemberAccess* _tmp51_;
				ValaExpression* _tmp52_;
				ValaExpression* _tmp53_;
				ValaSymbol* _tmp54_;
				ValaSymbol* _tmp55_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp66_;
				ValaSymbol* _tmp67_;
				ValaSymbol* _tmp68_;
				gboolean _tmp69_ = FALSE;
				ValaMethod* _tmp70_;
				_tmp45_ = ma;
				_tmp46_ = vala_member_access_get_inner (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = vala_expression_get_value_type (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = _vala_code_node_ref0 (_tmp49_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp50_;
				_tmp51_ = ma;
				_tmp52_ = vala_member_access_get_inner (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = vala_expression_get_symbol_reference (_tmp53_);
				_tmp55_ = _tmp54_;
				if (VALA_IS_SIGNAL (_tmp55_)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp56_;
					ValaExpression* _tmp57_;
					ValaExpression* _tmp58_;
					ValaMemberAccess* _tmp59_;
					_tmp56_ = ma;
					_tmp57_ = vala_member_access_get_inner (_tmp56_);
					_tmp58_ = _tmp57_;
					sig = VALA_IS_MEMBER_ACCESS (_tmp58_) ? ((ValaMemberAccess*) _tmp58_) : NULL;
					_tmp59_ = sig;
					if (_tmp59_ != NULL) {
						ValaMemberAccess* _tmp60_;
						ValaExpression* _tmp61_;
						ValaExpression* _tmp62_;
						ValaDataType* _tmp63_;
						ValaDataType* _tmp64_;
						ValaDataType* _tmp65_;
						_tmp60_ = sig;
						_tmp61_ = vala_member_access_get_inner (_tmp60_);
						_tmp62_ = _tmp61_;
						_tmp63_ = vala_expression_get_value_type (_tmp62_);
						_tmp64_ = _tmp63_;
						_tmp65_ = _vala_code_node_ref0 (_tmp64_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp65_;
					}
				}
				_tmp66_ = ma;
				_tmp67_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp66_);
				_tmp68_ = _tmp67_;
				m = VALA_IS_METHOD (_tmp68_) ? ((ValaMethod*) _tmp68_) : NULL;
				_tmp70_ = m;
				if (_tmp70_ != NULL) {
					ValaMethod* _tmp71_;
					gboolean _tmp72_;
					gboolean _tmp73_;
					_tmp71_ = m;
					_tmp72_ = vala_method_get_coroutine (_tmp71_);
					_tmp73_ = _tmp72_;
					_tmp69_ = _tmp73_;
				} else {
					_tmp69_ = FALSE;
				}
				if (_tmp69_) {
					gboolean _tmp74_ = FALSE;
					ValaMemberAccess* _tmp75_;
					const gchar* _tmp76_;
					const gchar* _tmp77_;
					_tmp75_ = ma;
					_tmp76_ = vala_member_access_get_member_name (_tmp75_);
					_tmp77_ = _tmp76_;
					if (g_strcmp0 (_tmp77_, "begin") == 0) {
						_tmp74_ = TRUE;
					} else {
						ValaMemberAccess* _tmp78_;
						const gchar* _tmp79_;
						const gchar* _tmp80_;
						_tmp78_ = ma;
						_tmp79_ = vala_member_access_get_member_name (_tmp78_);
						_tmp80_ = _tmp79_;
						_tmp74_ = g_strcmp0 (_tmp80_, "end") == 0;
					}
					if (_tmp74_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp81_;
						ValaExpression* _tmp82_;
						ValaExpression* _tmp83_;
						gboolean _tmp84_ = FALSE;
						ValaMemberAccess* _tmp85_;
						_tmp81_ = ma;
						_tmp82_ = vala_member_access_get_inner (_tmp81_);
						_tmp83_ = _tmp82_;
						method_access = VALA_IS_MEMBER_ACCESS (_tmp83_) ? ((ValaMemberAccess*) _tmp83_) : NULL;
						_tmp85_ = method_access;
						if (_tmp85_ != NULL) {
							ValaMemberAccess* _tmp86_;
							ValaExpression* _tmp87_;
							ValaExpression* _tmp88_;
							_tmp86_ = method_access;
							_tmp87_ = vala_member_access_get_inner (_tmp86_);
							_tmp88_ = _tmp87_;
							_tmp84_ = _tmp88_ != NULL;
						} else {
							_tmp84_ = FALSE;
						}
						if (_tmp84_) {
							ValaMemberAccess* _tmp89_;
							ValaExpression* _tmp90_;
							ValaExpression* _tmp91_;
							ValaDataType* _tmp92_;
							ValaDataType* _tmp93_;
							ValaDataType* _tmp94_;
							_tmp89_ = method_access;
							_tmp90_ = vala_member_access_get_inner (_tmp89_);
							_tmp91_ = _tmp90_;
							_tmp92_ = vala_expression_get_value_type (_tmp91_);
							_tmp93_ = _tmp92_;
							_tmp94_ = _vala_code_node_ref0 (_tmp93_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp94_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
					}
				}
			}
			_tmp96_ = ma;
			_tmp97_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp96_);
			_tmp98_ = _tmp97_;
			if (_tmp98_ != NULL) {
				ValaMemberAccess* _tmp99_;
				ValaSymbol* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaAttribute* _tmp102_;
				_tmp99_ = ma;
				_tmp100_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp99_);
				_tmp101_ = _tmp100_;
				_tmp102_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp101_, "Assert");
				_tmp95_ = _tmp102_ != NULL;
			} else {
				_tmp95_ = FALSE;
			}
			if (_tmp95_) {
				ValaList* _tmp103_;
				gint _tmp104_;
				gint _tmp105_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp103_ = self->priv->argument_list;
				_tmp104_ = vala_collection_get_size ((ValaCollection*) _tmp103_);
				_tmp105_ = _tmp104_;
				if (_tmp105_ == 1) {
					ValaList* _tmp106_;
					gpointer _tmp107_;
					ValaExpression* _tmp108_;
					ValaSourceReference* _tmp109_;
					ValaSourceReference* _tmp110_;
					_tmp106_ = self->priv->argument_list;
					_tmp107_ = vala_list_get (_tmp106_, 0);
					_tmp108_ = (ValaExpression*) _tmp107_;
					_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp108_);
					_tmp110_ = _tmp109_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp110_);
					_vala_code_node_unref0 (_tmp108_);
				}
			}
		}
	}
	_tmp111_ = vala_method_call_get_call (self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vala_expression_get_value_type (_tmp112_);
	_tmp114_ = _tmp113_;
	_tmp115_ = _vala_code_node_ref0 (_tmp114_);
	mtype = _tmp115_;
	_tmp117_ = vala_code_context_get_profile (context);
	_tmp118_ = _tmp117_;
	if (_tmp118_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp119_;
		ValaExpression* _tmp120_;
		ValaSymbol* _tmp121_;
		ValaSymbol* _tmp122_;
		ValaSemanticAnalyzer* _tmp123_;
		ValaSemanticAnalyzer* _tmp124_;
		ValaClass* _tmp125_;
		_tmp119_ = vala_method_call_get_call (self);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_expression_get_symbol_reference (_tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_code_context_get_analyzer (context);
		_tmp124_ = _tmp123_;
		_tmp125_ = _tmp124_->object_type;
		_tmp116_ = _tmp122_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp116_ = FALSE;
	}
	gobject_chainup = _tmp116_;
	vala_method_call_set_is_chainup (self, gobject_chainup);
	if (!gobject_chainup) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp126_;
		ValaExpression* _tmp127_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp128_;
		gboolean _tmp129_ = FALSE;
		ValaMemberAccess* _tmp130_;
		gboolean _tmp138_ = FALSE;
		ValaMemberAccess* _tmp139_;
		_tmp126_ = vala_method_call_get_call (self);
		_tmp127_ = _tmp126_;
		expr = _tmp127_;
		_tmp128_ = expr;
		ma = VALA_IS_MEMBER_ACCESS (_tmp128_) ? ((ValaMemberAccess*) _tmp128_) : NULL;
		_tmp130_ = ma;
		if (_tmp130_ != NULL) {
			ValaMemberAccess* _tmp131_;
			ValaSymbol* _tmp132_;
			ValaSymbol* _tmp133_;
			_tmp131_ = ma;
			_tmp132_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp131_);
			_tmp133_ = _tmp132_;
			_tmp129_ = VALA_IS_CREATION_METHOD (_tmp133_);
		} else {
			_tmp129_ = FALSE;
		}
		if (_tmp129_) {
			ValaMemberAccess* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			_tmp134_ = ma;
			_tmp135_ = vala_member_access_get_inner (_tmp134_);
			_tmp136_ = _tmp135_;
			expr = _tmp136_;
			_tmp137_ = expr;
			ma = VALA_IS_MEMBER_ACCESS (_tmp137_) ? ((ValaMemberAccess*) _tmp137_) : NULL;
		}
		_tmp139_ = ma;
		if (_tmp139_ != NULL) {
			ValaMemberAccess* _tmp140_;
			const gchar* _tmp141_;
			const gchar* _tmp142_;
			_tmp140_ = ma;
			_tmp141_ = vala_member_access_get_member_name (_tmp140_);
			_tmp142_ = _tmp141_;
			_tmp138_ = g_strcmp0 (_tmp142_, "this") == 0;
		} else {
			_tmp138_ = FALSE;
		}
		if (_tmp138_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp143_;
			_tmp143_ = expr;
			if (VALA_IS_BASE_ACCESS (_tmp143_)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
	}
	base_cm = NULL;
	_tmp144_ = self->priv->_is_chainup;
	if (_tmp144_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp145_;
		ValaSemanticAnalyzer* _tmp146_;
		ValaMethod* _tmp147_;
		ValaCreationMethod* _tmp148_;
		ValaCreationMethod* _tmp156_;
		ValaDataType* _tmp157_;
		_tmp145_ = vala_code_context_get_analyzer (context);
		_tmp146_ = _tmp145_;
		_tmp147_ = vala_semantic_analyzer_find_current_method (_tmp146_);
		cm = VALA_IS_CREATION_METHOD (_tmp147_) ? ((ValaCreationMethod*) _tmp147_) : NULL;
		_tmp148_ = cm;
		if (_tmp148_ == NULL) {
			ValaSourceReference* _tmp149_;
			ValaSourceReference* _tmp150_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp150_ = _tmp149_;
			vala_report_error (_tmp150_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp151_;
			gboolean _tmp152_;
			gboolean _tmp153_;
			_tmp151_ = cm;
			_tmp152_ = vala_creation_method_get_chain_up (_tmp151_);
			_tmp153_ = _tmp152_;
			if (_tmp153_) {
				ValaSourceReference* _tmp154_;
				ValaSourceReference* _tmp155_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp154_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp155_ = _tmp154_;
				vala_report_error (_tmp155_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp156_ = cm;
		vala_creation_method_set_chain_up (_tmp156_, TRUE);
		_tmp157_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp157_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp158_;
			ValaTypeSymbol* _tmp159_;
			ValaTypeSymbol* _tmp160_;
			ValaClass* _tmp161_;
			ValaCreationMethod* _tmp162_;
			ValaCreationMethod* _tmp163_;
			ValaCreationMethod* _tmp164_;
			_tmp158_ = mtype;
			_tmp159_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp158_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp160_ = _tmp159_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_CLASS, ValaClass);
			_tmp161_ = cl;
			_tmp162_ = vala_class_get_default_construction_method (_tmp161_);
			_tmp163_ = _tmp162_;
			base_cm = _tmp163_;
			_tmp164_ = base_cm;
			if (_tmp164_ == NULL) {
				ValaSourceReference* _tmp165_;
				ValaSourceReference* _tmp166_;
				ValaClass* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp165_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp166_ = _tmp165_;
				_tmp167_ = cl;
				_tmp168_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp167_);
				_tmp169_ = _tmp168_;
				vala_report_error (_tmp166_, "chain up to `%s' not supported", _tmp169_);
				_g_free0 (_tmp169_);
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp170_;
				gboolean _tmp171_;
				gboolean _tmp172_;
				_tmp170_ = base_cm;
				_tmp171_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp170_);
				_tmp172_ = _tmp171_;
				if (!_tmp172_) {
					ValaSourceReference* _tmp173_;
					ValaSourceReference* _tmp174_;
					ValaCreationMethod* _tmp175_;
					gchar* _tmp176_;
					gchar* _tmp177_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp173_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp174_ = _tmp173_;
					_tmp175_ = base_cm;
					_tmp176_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp175_);
					_tmp177_ = _tmp176_;
					vala_report_error (_tmp174_, "chain up to `%s' not supported", _tmp177_);
					_g_free0 (_tmp177_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
		} else {
			gboolean _tmp178_ = FALSE;
			ValaExpression* _tmp179_;
			ValaExpression* _tmp180_;
			ValaSymbol* _tmp181_;
			ValaSymbol* _tmp182_;
			_tmp179_ = vala_method_call_get_call (self);
			_tmp180_ = _tmp179_;
			_tmp181_ = vala_expression_get_symbol_reference (_tmp180_);
			_tmp182_ = _tmp181_;
			if (VALA_IS_CREATION_METHOD (_tmp182_)) {
				ValaExpression* _tmp183_;
				ValaExpression* _tmp184_;
				ValaSymbol* _tmp185_;
				ValaSymbol* _tmp186_;
				ValaSymbol* _tmp187_;
				ValaSymbol* _tmp188_;
				_tmp183_ = vala_method_call_get_call (self);
				_tmp184_ = _tmp183_;
				_tmp185_ = vala_expression_get_symbol_reference (_tmp184_);
				_tmp186_ = _tmp185_;
				_tmp187_ = vala_symbol_get_parent_symbol (_tmp186_);
				_tmp188_ = _tmp187_;
				_tmp178_ = VALA_IS_CLASS (_tmp188_);
			} else {
				_tmp178_ = FALSE;
			}
			if (_tmp178_) {
				ValaExpression* _tmp189_;
				ValaExpression* _tmp190_;
				ValaSymbol* _tmp191_;
				ValaSymbol* _tmp192_;
				ValaCreationMethod* _tmp193_;
				gboolean _tmp194_;
				gboolean _tmp195_;
				_tmp189_ = vala_method_call_get_call (self);
				_tmp190_ = _tmp189_;
				_tmp191_ = vala_expression_get_symbol_reference (_tmp190_);
				_tmp192_ = _tmp191_;
				base_cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp192_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
				_tmp193_ = base_cm;
				_tmp194_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp193_);
				_tmp195_ = _tmp194_;
				if (!_tmp195_) {
					ValaSourceReference* _tmp196_;
					ValaSourceReference* _tmp197_;
					ValaCreationMethod* _tmp198_;
					gchar* _tmp199_;
					gchar* _tmp200_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp196_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp197_ = _tmp196_;
					_tmp198_ = base_cm;
					_tmp199_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp198_);
					_tmp200_ = _tmp199_;
					vala_report_error (_tmp197_, "chain up to `%s' not supported", _tmp200_);
					_g_free0 (_tmp200_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				if (gobject_chainup) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp201_;
					ValaSymbol* _tmp202_;
					ValaSymbol* _tmp203_;
					gboolean _tmp204_ = FALSE;
					ValaClass* _tmp205_;
					ValaExpression* _tmp212_;
					ValaExpression* _tmp213_;
					ValaSemanticAnalyzer* _tmp214_;
					ValaSemanticAnalyzer* _tmp215_;
					ValaClass* _tmp216_;
					ValaObjectType* _tmp217_;
					ValaObjectType* _tmp218_;
					ValaExpression* _tmp219_;
					ValaExpression* _tmp220_;
					ValaDataType* _tmp221_;
					ValaDataType* _tmp222_;
					ValaSourceReference* _tmp223_;
					ValaSourceReference* _tmp224_;
					ValaExpression* _tmp225_;
					ValaExpression* _tmp226_;
					ValaDataType* _tmp227_;
					ValaDataType* _tmp228_;
					ValaDataType* _tmp229_;
					_tmp201_ = cm;
					_tmp202_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp201_);
					_tmp203_ = _tmp202_;
					cl = VALA_IS_CLASS (_tmp203_) ? ((ValaClass*) _tmp203_) : NULL;
					_tmp205_ = cl;
					if (_tmp205_ == NULL) {
						_tmp204_ = TRUE;
					} else {
						ValaClass* _tmp206_;
						ValaSemanticAnalyzer* _tmp207_;
						ValaSemanticAnalyzer* _tmp208_;
						ValaClass* _tmp209_;
						_tmp206_ = cl;
						_tmp207_ = vala_code_context_get_analyzer (context);
						_tmp208_ = _tmp207_;
						_tmp209_ = _tmp208_->object_type;
						_tmp204_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp206_, (ValaTypeSymbol*) _tmp209_);
					}
					if (_tmp204_) {
						ValaSourceReference* _tmp210_;
						ValaSourceReference* _tmp211_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp210_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp211_ = _tmp210_;
						vala_report_error (_tmp211_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp212_ = vala_method_call_get_call (self);
					_tmp213_ = _tmp212_;
					_tmp214_ = vala_code_context_get_analyzer (context);
					_tmp215_ = _tmp214_;
					_tmp216_ = _tmp215_->object_type;
					_tmp217_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp216_);
					_tmp218_ = _tmp217_;
					vala_expression_set_value_type (_tmp213_, (ValaDataType*) _tmp218_);
					_vala_code_node_unref0 (_tmp218_);
					_tmp219_ = vala_method_call_get_call (self);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_expression_get_value_type (_tmp220_);
					_tmp222_ = _tmp221_;
					_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp224_ = _tmp223_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp222_, _tmp224_);
					_tmp225_ = vala_method_call_get_call (self);
					_tmp226_ = _tmp225_;
					_tmp227_ = vala_expression_get_value_type (_tmp226_);
					_tmp228_ = _tmp227_;
					_tmp229_ = _vala_code_node_ref0 (_tmp228_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp229_;
				}
			}
		}
	}
	_tmp231_ = vala_method_call_get_call (self);
	_tmp232_ = _tmp231_;
	if (VALA_IS_MEMBER_ACCESS (_tmp232_)) {
		gboolean _tmp233_ = FALSE;
		gboolean _tmp234_ = FALSE;
		ValaExpression* _tmp235_;
		ValaExpression* _tmp236_;
		ValaSymbol* _tmp237_;
		ValaSymbol* _tmp238_;
		_tmp235_ = vala_method_call_get_call (self);
		_tmp236_ = _tmp235_;
		_tmp237_ = vala_expression_get_symbol_reference (_tmp236_);
		_tmp238_ = _tmp237_;
		if (VALA_IS_CREATION_METHOD (_tmp238_)) {
			ValaExpression* _tmp239_;
			ValaExpression* _tmp240_;
			ValaSymbol* _tmp241_;
			ValaSymbol* _tmp242_;
			ValaSymbol* _tmp243_;
			ValaSymbol* _tmp244_;
			_tmp239_ = vala_method_call_get_call (self);
			_tmp240_ = _tmp239_;
			_tmp241_ = vala_expression_get_symbol_reference (_tmp240_);
			_tmp242_ = _tmp241_;
			_tmp243_ = vala_symbol_get_parent_symbol (_tmp242_);
			_tmp244_ = _tmp243_;
			_tmp234_ = VALA_IS_STRUCT (_tmp244_);
		} else {
			_tmp234_ = FALSE;
		}
		if (_tmp234_) {
			_tmp233_ = TRUE;
		} else {
			ValaExpression* _tmp245_;
			ValaExpression* _tmp246_;
			ValaSymbol* _tmp247_;
			ValaSymbol* _tmp248_;
			_tmp245_ = vala_method_call_get_call (self);
			_tmp246_ = _tmp245_;
			_tmp247_ = vala_expression_get_symbol_reference (_tmp246_);
			_tmp248_ = _tmp247_;
			_tmp233_ = VALA_IS_STRUCT (_tmp248_);
		}
		_tmp230_ = _tmp233_;
	} else {
		_tmp230_ = FALSE;
	}
	if (_tmp230_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp249_;
		ValaExpression* _tmp250_;
		ValaSymbol* _tmp251_;
		ValaSymbol* _tmp252_;
		gboolean _tmp253_ = FALSE;
		gboolean _tmp254_ = FALSE;
		ValaStruct* _tmp255_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp266_;
		ValaExpression* _tmp267_;
		ValaSourceReference* _tmp268_;
		ValaSourceReference* _tmp269_;
		ValaObjectCreationExpression* _tmp270_;
		ValaObjectCreationExpression* _tmp271_;
		ValaObjectCreationExpression* _tmp282_;
		ValaDataType* _tmp283_;
		ValaDataType* _tmp284_;
		ValaSemanticAnalyzer* _tmp285_;
		ValaSemanticAnalyzer* _tmp286_;
		ValaList* _tmp287_;
		ValaCodeNode* _tmp288_;
		ValaCodeNode* _tmp289_;
		ValaObjectCreationExpression* _tmp290_;
		ValaObjectCreationExpression* _tmp291_;
		_tmp249_ = vala_method_call_get_call (self);
		_tmp250_ = _tmp249_;
		_tmp251_ = vala_expression_get_symbol_reference (_tmp250_);
		_tmp252_ = _tmp251_;
		st = VALA_IS_STRUCT (_tmp252_) ? ((ValaStruct*) _tmp252_) : NULL;
		_tmp255_ = st;
		if (_tmp255_ != NULL) {
			ValaStruct* _tmp256_;
			ValaCreationMethod* _tmp257_;
			ValaCreationMethod* _tmp258_;
			_tmp256_ = st;
			_tmp257_ = vala_struct_get_default_construction_method (_tmp256_);
			_tmp258_ = _tmp257_;
			_tmp254_ = _tmp258_ == NULL;
		} else {
			_tmp254_ = FALSE;
		}
		if (_tmp254_) {
			gboolean _tmp259_ = FALSE;
			gboolean _tmp260_ = FALSE;
			ValaStruct* _tmp261_;
			_tmp261_ = st;
			if (vala_struct_is_boolean_type (_tmp261_)) {
				_tmp260_ = TRUE;
			} else {
				ValaStruct* _tmp262_;
				_tmp262_ = st;
				_tmp260_ = vala_struct_is_integer_type (_tmp262_);
			}
			if (_tmp260_) {
				_tmp259_ = TRUE;
			} else {
				ValaStruct* _tmp263_;
				_tmp263_ = st;
				_tmp259_ = vala_struct_is_floating_type (_tmp263_);
			}
			_tmp253_ = _tmp259_;
		} else {
			_tmp253_ = FALSE;
		}
		if (_tmp253_) {
			ValaSourceReference* _tmp264_;
			ValaSourceReference* _tmp265_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp265_ = _tmp264_;
			vala_report_error (_tmp265_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp266_ = vala_method_call_get_call (self);
		_tmp267_ = _tmp266_;
		_tmp268_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp269_ = _tmp268_;
		_tmp270_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp267_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp269_);
		struct_creation_expression = _tmp270_;
		_tmp271_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp271_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp272_;
			gint _arg_size = 0;
			ValaList* _tmp273_;
			gint _tmp274_;
			gint _tmp275_;
			gint _arg_index = 0;
			_tmp272_ = self->priv->argument_list;
			_arg_list = _tmp272_;
			_tmp273_ = _arg_list;
			_tmp274_ = vala_collection_get_size ((ValaCollection*) _tmp273_);
			_tmp275_ = _tmp274_;
			_arg_size = _tmp275_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp276_;
				gint _tmp277_;
				ValaExpression* arg = NULL;
				ValaList* _tmp278_;
				gpointer _tmp279_;
				ValaObjectCreationExpression* _tmp280_;
				ValaExpression* _tmp281_;
				_arg_index = _arg_index + 1;
				_tmp276_ = _arg_index;
				_tmp277_ = _arg_size;
				if (!(_tmp276_ < _tmp277_)) {
					break;
				}
				_tmp278_ = _arg_list;
				_tmp279_ = vala_list_get (_tmp278_, _arg_index);
				arg = (ValaExpression*) _tmp279_;
				_tmp280_ = struct_creation_expression;
				_tmp281_ = arg;
				vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp280_, _tmp281_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp282_ = struct_creation_expression;
		_tmp283_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp284_ = _tmp283_;
		vala_expression_set_target_type ((ValaExpression*) _tmp282_, _tmp284_);
		_tmp285_ = vala_code_context_get_analyzer (context);
		_tmp286_ = _tmp285_;
		_tmp287_ = _tmp286_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp287_, (ValaCodeNode*) self);
		_tmp288_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp289_ = _tmp288_;
		_tmp290_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp289_, (ValaExpression*) self, (ValaExpression*) _tmp290_);
		_tmp291_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp291_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp292_ = FALSE;
		gboolean _tmp293_ = FALSE;
		gboolean _tmp294_;
		_tmp294_ = self->priv->_is_chainup;
		if (!_tmp294_) {
			ValaExpression* _tmp295_;
			ValaExpression* _tmp296_;
			_tmp295_ = vala_method_call_get_call (self);
			_tmp296_ = _tmp295_;
			_tmp293_ = VALA_IS_MEMBER_ACCESS (_tmp296_);
		} else {
			_tmp293_ = FALSE;
		}
		if (_tmp293_) {
			ValaExpression* _tmp297_;
			ValaExpression* _tmp298_;
			ValaSymbol* _tmp299_;
			ValaSymbol* _tmp300_;
			_tmp297_ = vala_method_call_get_call (self);
			_tmp298_ = _tmp297_;
			_tmp299_ = vala_expression_get_symbol_reference (_tmp298_);
			_tmp300_ = _tmp299_;
			_tmp292_ = VALA_IS_CREATION_METHOD (_tmp300_);
		} else {
			_tmp292_ = FALSE;
		}
		if (_tmp292_) {
			ValaSourceReference* _tmp301_;
			ValaSourceReference* _tmp302_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp301_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp302_ = _tmp301_;
			vala_report_error (_tmp302_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp304_ = self->priv->_is_chainup;
	if (!_tmp304_) {
		ValaDataType* _tmp305_;
		_tmp305_ = mtype;
		_tmp303_ = VALA_IS_OBJECT_TYPE (_tmp305_);
	} else {
		_tmp303_ = FALSE;
	}
	if (_tmp303_) {
		ValaSourceReference* _tmp306_;
		ValaSourceReference* _tmp307_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp306_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp307_ = _tmp306_;
		vala_report_error (_tmp307_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp308_ = FALSE;
		ValaDataType* _tmp309_;
		_tmp309_ = mtype;
		if (_tmp309_ != NULL) {
			ValaDataType* _tmp310_;
			_tmp310_ = mtype;
			_tmp308_ = vala_data_type_is_invokable (_tmp310_);
		} else {
			_tmp308_ = FALSE;
		}
		if (_tmp308_) {
		} else {
			ValaExpression* _tmp311_;
			ValaExpression* _tmp312_;
			ValaSymbol* _tmp313_;
			ValaSymbol* _tmp314_;
			_tmp311_ = vala_method_call_get_call (self);
			_tmp312_ = _tmp311_;
			_tmp313_ = vala_expression_get_symbol_reference (_tmp312_);
			_tmp314_ = _tmp313_;
			if (VALA_IS_CLASS (_tmp314_)) {
				ValaSourceReference* _tmp315_;
				ValaSourceReference* _tmp316_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp315_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp316_ = _tmp315_;
				vala_report_error (_tmp316_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp317_;
				ValaSourceReference* _tmp318_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp317_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp318_ = _tmp317_;
				vala_report_error (_tmp318_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp319_ = mtype;
	_tmp320_ = vala_data_type_get_return_type (_tmp319_);
	_tmp321_ = _vala_code_node_ref0 (_tmp320_);
	ret_type = _tmp321_;
	_tmp322_ = mtype;
	_tmp323_ = vala_data_type_get_parameters (_tmp322_);
	_tmp324_ = _vala_iterable_ref0 (_tmp323_);
	params = _tmp324_;
	_tmp325_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp325_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp326_;
		ValaExpression* _tmp327_;
		ValaMethod* m = NULL;
		ValaDataType* _tmp328_;
		ValaMethod* _tmp329_;
		ValaMethod* _tmp330_;
		ValaMethod* _tmp331_;
		gboolean _tmp332_;
		gboolean _tmp333_;
		gint n_type_params = 0;
		ValaMethod* _tmp365_;
		ValaList* _tmp366_;
		gint _tmp367_;
		gint _tmp368_;
		gint n_type_args = 0;
		ValaMemberAccess* _tmp369_;
		ValaList* _tmp370_;
		gint _tmp371_;
		gint _tmp372_;
		gboolean _tmp373_ = FALSE;
		_tmp326_ = vala_method_call_get_call (self);
		_tmp327_ = _tmp326_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp327_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp328_ = mtype;
		_tmp329_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp328_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp330_ = _tmp329_;
		m = _tmp330_;
		_tmp331_ = m;
		_tmp332_ = vala_method_get_coroutine (_tmp331_);
		_tmp333_ = _tmp332_;
		if (_tmp333_) {
			gboolean _tmp334_;
			gboolean _tmp335_;
			_tmp334_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp335_ = _tmp334_;
			if (!_tmp335_) {
				ValaMemberAccess* _tmp336_;
				const gchar* _tmp337_;
				const gchar* _tmp338_;
				_tmp336_ = ma;
				_tmp337_ = vala_member_access_get_member_name (_tmp336_);
				_tmp338_ = _tmp337_;
				if (g_strcmp0 (_tmp338_, "end") != 0) {
					ValaMemberAccess* _tmp339_;
					const gchar* _tmp340_;
					const gchar* _tmp341_;
					ValaMethod* _tmp345_;
					ValaList* _tmp346_;
					ValaList* _tmp347_;
					ValaVoidType* _tmp348_;
					_tmp339_ = ma;
					_tmp340_ = vala_member_access_get_member_name (_tmp339_);
					_tmp341_ = _tmp340_;
					if (g_strcmp0 (_tmp341_, "begin") != 0) {
						ValaMemberAccess* _tmp342_;
						ValaSourceReference* _tmp343_;
						ValaSourceReference* _tmp344_;
						_tmp342_ = ma;
						_tmp343_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp342_);
						_tmp344_ = _tmp343_;
						vala_report_deprecated (_tmp344_, "implicit .begin is deprecated");
					}
					_tmp345_ = m;
					_tmp346_ = vala_method_get_async_begin_parameters (_tmp345_);
					_tmp347_ = _vala_iterable_ref0 (_tmp346_);
					_vala_iterable_unref0 (params);
					params = _tmp347_;
					_tmp348_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp348_;
				} else {
					ValaMethod* _tmp349_;
					ValaList* _tmp350_;
					ValaList* _tmp351_;
					_tmp349_ = m;
					_tmp350_ = vala_method_get_async_end_parameters (_tmp349_);
					_tmp351_ = _vala_iterable_ref0 (_tmp350_);
					_vala_iterable_unref0 (params);
					params = _tmp351_;
				}
			} else {
				gboolean _tmp352_ = FALSE;
				ValaMemberAccess* _tmp353_;
				const gchar* _tmp354_;
				const gchar* _tmp355_;
				_tmp353_ = ma;
				_tmp354_ = vala_member_access_get_member_name (_tmp353_);
				_tmp355_ = _tmp354_;
				if (g_strcmp0 (_tmp355_, "begin") == 0) {
					_tmp352_ = TRUE;
				} else {
					ValaMemberAccess* _tmp356_;
					const gchar* _tmp357_;
					const gchar* _tmp358_;
					_tmp356_ = ma;
					_tmp357_ = vala_member_access_get_member_name (_tmp356_);
					_tmp358_ = _tmp357_;
					_tmp352_ = g_strcmp0 (_tmp358_, "end") == 0;
				}
				if (_tmp352_) {
					ValaMemberAccess* _tmp359_;
					ValaSourceReference* _tmp360_;
					ValaSourceReference* _tmp361_;
					ValaMemberAccess* _tmp362_;
					const gchar* _tmp363_;
					const gchar* _tmp364_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp359_ = ma;
					_tmp360_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp359_);
					_tmp361_ = _tmp360_;
					_tmp362_ = ma;
					_tmp363_ = vala_member_access_get_member_name (_tmp362_);
					_tmp364_ = _tmp363_;
					vala_report_error (_tmp361_, "use of `%s' not allowed in yield statement", _tmp364_);
				}
			}
		}
		_tmp365_ = m;
		_tmp366_ = vala_method_get_type_parameters (_tmp365_);
		_tmp367_ = vala_collection_get_size ((ValaCollection*) _tmp366_);
		_tmp368_ = _tmp367_;
		n_type_params = _tmp368_;
		_tmp369_ = ma;
		_tmp370_ = vala_member_access_get_type_arguments (_tmp369_);
		_tmp371_ = vala_collection_get_size ((ValaCollection*) _tmp370_);
		_tmp372_ = _tmp371_;
		n_type_args = _tmp372_;
		if (n_type_args > 0) {
			_tmp373_ = n_type_args < n_type_params;
		} else {
			_tmp373_ = FALSE;
		}
		if (_tmp373_) {
			ValaMemberAccess* _tmp374_;
			ValaSourceReference* _tmp375_;
			ValaSourceReference* _tmp376_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp374_ = ma;
			_tmp375_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp374_);
			_tmp376_ = _tmp375_;
			vala_report_error (_tmp376_, "too few type arguments");
			result = FALSE;
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			gboolean _tmp377_ = FALSE;
			if (n_type_args > 0) {
				_tmp377_ = n_type_args > n_type_params;
			} else {
				_tmp377_ = FALSE;
			}
			if (_tmp377_) {
				ValaMemberAccess* _tmp378_;
				ValaSourceReference* _tmp379_;
				ValaSourceReference* _tmp380_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp378_ = ma;
				_tmp379_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp378_);
				_tmp380_ = _tmp379_;
				vala_report_error (_tmp380_, "too many type arguments");
				result = FALSE;
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	last_arg = NULL;
	_tmp381_ = self->priv->argument_list;
	_tmp382_ = vala_iterable_iterator ((ValaIterable*) _tmp381_);
	arg_it = _tmp382_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp383_;
		gint _param_size = 0;
		ValaList* _tmp384_;
		gint _tmp385_;
		gint _tmp386_;
		gint _param_index = 0;
		_tmp383_ = params;
		_param_list = _tmp383_;
		_tmp384_ = _param_list;
		_tmp385_ = vala_collection_get_size ((ValaCollection*) _tmp384_);
		_tmp386_ = _tmp385_;
		_param_size = _tmp386_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp387_;
			gint _tmp388_;
			ValaParameter* param = NULL;
			ValaList* _tmp389_;
			gpointer _tmp390_;
			ValaParameter* _tmp391_;
			ValaParameter* _tmp392_;
			gboolean _tmp393_;
			gboolean _tmp394_;
			ValaParameter* _tmp395_;
			gboolean _tmp396_;
			gboolean _tmp397_;
			ValaIterator* _tmp415_;
			_param_index = _param_index + 1;
			_tmp387_ = _param_index;
			_tmp388_ = _param_size;
			if (!(_tmp387_ < _tmp388_)) {
				break;
			}
			_tmp389_ = _param_list;
			_tmp390_ = vala_list_get (_tmp389_, _param_index);
			param = (ValaParameter*) _tmp390_;
			_tmp391_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp391_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp392_ = param;
			_tmp393_ = vala_parameter_get_ellipsis (_tmp392_);
			_tmp394_ = _tmp393_;
			if (_tmp394_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp395_ = param;
			_tmp396_ = vala_parameter_get_params_array (_tmp395_);
			_tmp397_ = _tmp396_;
			if (_tmp397_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp398_;
				ValaDataType* _tmp399_;
				ValaDataType* _tmp400_;
				ValaArrayType* _tmp401_;
				_tmp398_ = param;
				_tmp399_ = vala_variable_get_variable_type ((ValaVariable*) _tmp398_);
				_tmp400_ = _tmp399_;
				_tmp401_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp400_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp401_;
				while (TRUE) {
					ValaIterator* _tmp402_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp403_;
					gpointer _tmp404_;
					ValaExpression* _tmp405_;
					ValaArrayType* _tmp406_;
					ValaDataType* _tmp407_;
					ValaDataType* _tmp408_;
					ValaExpression* _tmp409_;
					ValaDataType* _tmp410_;
					ValaDataType* _tmp411_;
					ValaArrayType* _tmp412_;
					gboolean _tmp413_;
					gboolean _tmp414_;
					_tmp402_ = arg_it;
					if (!vala_iterator_next (_tmp402_)) {
						break;
					}
					_tmp403_ = arg_it;
					_tmp404_ = vala_iterator_get (_tmp403_);
					arg = (ValaExpression*) _tmp404_;
					_tmp405_ = arg;
					_tmp406_ = array_type;
					_tmp407_ = vala_array_type_get_element_type (_tmp406_);
					_tmp408_ = _tmp407_;
					vala_expression_set_target_type (_tmp405_, _tmp408_);
					_tmp409_ = arg;
					_tmp410_ = vala_expression_get_target_type (_tmp409_);
					_tmp411_ = _tmp410_;
					_tmp412_ = array_type;
					_tmp413_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp412_);
					_tmp414_ = _tmp413_;
					vala_data_type_set_value_owned (_tmp411_, _tmp414_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp415_ = arg_it;
			if (vala_iterator_next (_tmp415_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp416_;
				gpointer _tmp417_;
				ValaExpression* _tmp418_;
				ValaParameter* _tmp419_;
				ValaDataType* _tmp420_;
				ValaDataType* _tmp421_;
				ValaExpression* _tmp422_;
				ValaExpression* _tmp423_;
				ValaDataType* _tmp424_;
				ValaDataType* _tmp425_;
				ValaDataType* _tmp426_;
				ValaList* _tmp427_;
				ValaDataType* _tmp428_;
				ValaDataType* _tmp429_;
				ValaExpression* _tmp430_;
				ValaExpression* _tmp431_;
				_tmp416_ = arg_it;
				_tmp417_ = vala_iterator_get (_tmp416_);
				arg = (ValaExpression*) _tmp417_;
				_tmp418_ = arg;
				_tmp419_ = param;
				_tmp420_ = vala_variable_get_variable_type ((ValaVariable*) _tmp419_);
				_tmp421_ = _tmp420_;
				vala_expression_set_formal_target_type (_tmp418_, _tmp421_);
				_tmp422_ = arg;
				_tmp423_ = arg;
				_tmp424_ = vala_expression_get_formal_target_type (_tmp423_);
				_tmp425_ = _tmp424_;
				_tmp426_ = target_object_type;
				_tmp427_ = method_type_args;
				_tmp428_ = vala_data_type_get_actual_type (_tmp425_, _tmp426_, _tmp427_, (ValaCodeNode*) self);
				_tmp429_ = _tmp428_;
				vala_expression_set_target_type (_tmp422_, _tmp429_);
				_vala_code_node_unref0 (_tmp429_);
				_tmp430_ = arg;
				_tmp431_ = _vala_code_node_ref0 (_tmp430_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp431_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp433_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp433_)) {
		ValaDataType* _tmp434_;
		ValaMethod* _tmp435_;
		ValaMethod* _tmp436_;
		ValaAttribute* _tmp437_;
		_tmp434_ = mtype;
		_tmp435_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp434_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp436_ = _tmp435_;
		_tmp437_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp436_, "Print");
		_tmp432_ = _tmp437_ != NULL;
	} else {
		_tmp432_ = FALSE;
	}
	if (_tmp432_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp438_;
		ValaSourceReference* _tmp439_;
		ValaTemplate* _tmp440_;
		ValaList* _tmp452_;
		ValaTemplate* _tmp453_;
		_tmp438_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp439_ = _tmp438_;
		_tmp440_ = vala_template_new (_tmp439_);
		template = _tmp440_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp441_;
			gint _arg_size = 0;
			ValaList* _tmp442_;
			gint _tmp443_;
			gint _tmp444_;
			gint _arg_index = 0;
			_tmp441_ = self->priv->argument_list;
			_arg_list = _tmp441_;
			_tmp442_ = _arg_list;
			_tmp443_ = vala_collection_get_size ((ValaCollection*) _tmp442_);
			_tmp444_ = _tmp443_;
			_arg_size = _tmp444_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp445_;
				gint _tmp446_;
				ValaExpression* arg = NULL;
				ValaList* _tmp447_;
				gpointer _tmp448_;
				ValaExpression* _tmp449_;
				ValaTemplate* _tmp450_;
				ValaExpression* _tmp451_;
				_arg_index = _arg_index + 1;
				_tmp445_ = _arg_index;
				_tmp446_ = _arg_size;
				if (!(_tmp445_ < _tmp446_)) {
					break;
				}
				_tmp447_ = _arg_list;
				_tmp448_ = vala_list_get (_tmp447_, _arg_index);
				arg = (ValaExpression*) _tmp448_;
				_tmp449_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp449_, NULL);
				_tmp450_ = template;
				_tmp451_ = arg;
				vala_template_add_expression (_tmp450_, _tmp451_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp452_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp452_);
		_tmp453_ = template;
		vala_callable_expression_add_argument ((ValaCallableExpression*) self, (ValaExpression*) _tmp453_);
		_vala_code_node_unref0 (template);
	}
	_tmp455_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp455_)) {
		ValaDataType* _tmp456_;
		ValaMethod* _tmp457_;
		ValaMethod* _tmp458_;
		gboolean _tmp459_;
		gboolean _tmp460_;
		_tmp456_ = mtype;
		_tmp457_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp456_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp458_ = _tmp457_;
		_tmp459_ = vala_method_get_printf_format (_tmp458_);
		_tmp460_ = _tmp459_;
		_tmp454_ = _tmp460_;
	} else {
		_tmp454_ = FALSE;
	}
	if (_tmp454_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp461_;
		ValaStringLiteral* _tmp510_;
		format_literal = NULL;
		_tmp461_ = last_arg;
		if (VALA_IS_NULL_LITERAL (_tmp461_)) {
		} else {
			ValaExpression* _tmp462_;
			_tmp462_ = last_arg;
			if (_tmp462_ != NULL) {
				ValaExpression* _tmp463_;
				ValaStringLiteral* _tmp464_;
				gboolean _tmp465_ = FALSE;
				ValaStringLiteral* _tmp466_;
				_tmp463_ = last_arg;
				_tmp464_ = vala_string_literal_get_format_literal (_tmp463_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp464_;
				_tmp466_ = format_literal;
				if (_tmp466_ == NULL) {
					ValaList* _tmp467_;
					gint _tmp468_;
					gint _tmp469_;
					ValaList* _tmp470_;
					gint _tmp471_;
					gint _tmp472_;
					_tmp467_ = self->priv->argument_list;
					_tmp468_ = vala_collection_get_size ((ValaCollection*) _tmp467_);
					_tmp469_ = _tmp468_;
					_tmp470_ = params;
					_tmp471_ = vala_collection_get_size ((ValaCollection*) _tmp470_);
					_tmp472_ = _tmp471_;
					_tmp465_ = _tmp469_ == (_tmp472_ - 1);
				} else {
					_tmp465_ = FALSE;
				}
				if (_tmp465_) {
					ValaStringLiteral* _tmp473_;
					ValaStringLiteral* _tmp474_;
					ValaSemanticAnalyzer* _tmp475_;
					ValaSemanticAnalyzer* _tmp476_;
					ValaDataType* _tmp477_;
					ValaDataType* _tmp478_;
					ValaDataType* _tmp479_;
					ValaList* _tmp480_;
					ValaList* _tmp481_;
					gint _tmp482_;
					gint _tmp483_;
					ValaStringLiteral* _tmp484_;
					ValaList* _tmp485_;
					ValaIterator* _tmp486_;
					_tmp473_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp473_;
					_tmp474_ = format_literal;
					_tmp475_ = vala_code_context_get_analyzer (context);
					_tmp476_ = _tmp475_;
					_tmp477_ = _tmp476_->string_type;
					_tmp478_ = vala_data_type_copy (_tmp477_);
					_tmp479_ = _tmp478_;
					vala_expression_set_target_type ((ValaExpression*) _tmp474_, _tmp479_);
					_vala_code_node_unref0 (_tmp479_);
					_tmp480_ = self->priv->argument_list;
					_tmp481_ = self->priv->argument_list;
					_tmp482_ = vala_collection_get_size ((ValaCollection*) _tmp481_);
					_tmp483_ = _tmp482_;
					_tmp484_ = format_literal;
					vala_list_insert (_tmp480_, _tmp483_ - 1, (ValaExpression*) _tmp484_);
					_tmp485_ = self->priv->argument_list;
					_tmp486_ = vala_iterable_iterator ((ValaIterable*) _tmp485_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp486_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp487_;
						gint _param_size = 0;
						ValaList* _tmp488_;
						gint _tmp489_;
						gint _tmp490_;
						gint _param_index = 0;
						_tmp487_ = params;
						_param_list = _tmp487_;
						_tmp488_ = _param_list;
						_tmp489_ = vala_collection_get_size ((ValaCollection*) _tmp488_);
						_tmp490_ = _tmp489_;
						_param_size = _tmp490_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp491_;
							gint _tmp492_;
							ValaParameter* param = NULL;
							ValaList* _tmp493_;
							gpointer _tmp494_;
							gboolean _tmp495_ = FALSE;
							ValaParameter* _tmp496_;
							gboolean _tmp497_;
							gboolean _tmp498_;
							ValaIterator* _tmp502_;
							_param_index = _param_index + 1;
							_tmp491_ = _param_index;
							_tmp492_ = _param_size;
							if (!(_tmp491_ < _tmp492_)) {
								break;
							}
							_tmp493_ = _param_list;
							_tmp494_ = vala_list_get (_tmp493_, _param_index);
							param = (ValaParameter*) _tmp494_;
							_tmp496_ = param;
							_tmp497_ = vala_parameter_get_ellipsis (_tmp496_);
							_tmp498_ = _tmp497_;
							if (_tmp498_) {
								_tmp495_ = TRUE;
							} else {
								ValaParameter* _tmp499_;
								gboolean _tmp500_;
								gboolean _tmp501_;
								_tmp499_ = param;
								_tmp500_ = vala_parameter_get_params_array (_tmp499_);
								_tmp501_ = _tmp500_;
								_tmp495_ = _tmp501_;
							}
							if (_tmp495_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp502_ = arg_it;
							vala_iterator_next (_tmp502_);
							_vala_code_node_unref0 (param);
						}
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp503_;
				ValaExpression* _tmp504_;
				ValaMemberAccess* _tmp505_;
				_tmp503_ = vala_method_call_get_call (self);
				_tmp504_ = _tmp503_;
				ma = VALA_IS_MEMBER_ACCESS (_tmp504_) ? ((ValaMemberAccess*) _tmp504_) : NULL;
				_tmp505_ = ma;
				if (_tmp505_ != NULL) {
					ValaMemberAccess* _tmp506_;
					ValaExpression* _tmp507_;
					ValaExpression* _tmp508_;
					ValaStringLiteral* _tmp509_;
					_tmp506_ = ma;
					_tmp507_ = vala_member_access_get_inner (_tmp506_);
					_tmp508_ = _tmp507_;
					_tmp509_ = vala_string_literal_get_format_literal (_tmp508_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp509_;
				}
			}
		}
		_tmp510_ = format_literal;
		if (_tmp510_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp511_;
			gchar* _tmp512_;
			ValaSemanticAnalyzer* _tmp513_;
			ValaSemanticAnalyzer* _tmp514_;
			const gchar* _tmp515_;
			ValaIterator* _tmp516_;
			ValaSourceReference* _tmp517_;
			ValaSourceReference* _tmp518_;
			_tmp511_ = format_literal;
			_tmp512_ = vala_string_literal_eval (_tmp511_);
			format = _tmp512_;
			_tmp513_ = vala_code_context_get_analyzer (context);
			_tmp514_ = _tmp513_;
			_tmp515_ = format;
			_tmp516_ = arg_it;
			_tmp517_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp518_ = _tmp517_;
			if (!vala_semantic_analyzer_check_print_format (_tmp514_, _tmp515_, _tmp516_, _tmp518_)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	force_lambda_method_closure = FALSE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp519_;
		gint _arg_size = 0;
		ValaList* _tmp520_;
		gint _tmp521_;
		gint _tmp522_;
		gint _arg_index = 0;
		_tmp519_ = self->priv->argument_list;
		_arg_list = _tmp519_;
		_tmp520_ = _arg_list;
		_tmp521_ = vala_collection_get_size ((ValaCollection*) _tmp520_);
		_tmp522_ = _tmp521_;
		_arg_size = _tmp522_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp523_;
			gint _tmp524_;
			ValaExpression* arg = NULL;
			ValaList* _tmp525_;
			gpointer _tmp526_;
			ValaExpression* _tmp527_;
			gboolean _tmp528_ = FALSE;
			ValaExpression* _tmp529_;
			_arg_index = _arg_index + 1;
			_tmp523_ = _arg_index;
			_tmp524_ = _arg_size;
			if (!(_tmp523_ < _tmp524_)) {
				break;
			}
			_tmp525_ = _arg_list;
			_tmp526_ = vala_list_get (_tmp525_, _arg_index);
			arg = (ValaExpression*) _tmp526_;
			_tmp527_ = arg;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp527_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp529_ = arg;
			if (VALA_IS_LAMBDA_EXPRESSION (_tmp529_)) {
				ValaExpression* _tmp530_;
				ValaMethod* _tmp531_;
				ValaMethod* _tmp532_;
				gboolean _tmp533_;
				gboolean _tmp534_;
				_tmp530_ = arg;
				_tmp531_ = vala_lambda_expression_get_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp530_, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression));
				_tmp532_ = _tmp531_;
				_tmp533_ = vala_method_get_closure (_tmp532_);
				_tmp534_ = _tmp533_;
				_tmp528_ = _tmp534_;
			} else {
				_tmp528_ = FALSE;
			}
			if (_tmp528_) {
				force_lambda_method_closure = TRUE;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp536_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp537_ = _tmp536_;
	if (!_tmp537_) {
		_tmp535_ = force_lambda_method_closure;
	} else {
		_tmp535_ = FALSE;
	}
	if (_tmp535_) {
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp538_;
			gint _arg_size = 0;
			ValaList* _tmp539_;
			gint _tmp540_;
			gint _tmp541_;
			gint _arg_index = 0;
			_tmp538_ = self->priv->argument_list;
			_arg_list = _tmp538_;
			_tmp539_ = _arg_list;
			_tmp540_ = vala_collection_get_size ((ValaCollection*) _tmp539_);
			_tmp541_ = _tmp540_;
			_arg_size = _tmp541_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp542_;
				gint _tmp543_;
				ValaExpression* arg = NULL;
				ValaList* _tmp544_;
				gpointer _tmp545_;
				ValaLambdaExpression* lambda = NULL;
				ValaExpression* _tmp546_;
				gboolean _tmp547_ = FALSE;
				ValaLambdaExpression* _tmp548_;
				_arg_index = _arg_index + 1;
				_tmp542_ = _arg_index;
				_tmp543_ = _arg_size;
				if (!(_tmp542_ < _tmp543_)) {
					break;
				}
				_tmp544_ = _arg_list;
				_tmp545_ = vala_list_get (_tmp544_, _arg_index);
				arg = (ValaExpression*) _tmp545_;
				_tmp546_ = arg;
				lambda = VALA_IS_LAMBDA_EXPRESSION (_tmp546_) ? ((ValaLambdaExpression*) _tmp546_) : NULL;
				_tmp548_ = lambda;
				if (_tmp548_ != NULL) {
					ValaLambdaExpression* _tmp549_;
					ValaMethod* _tmp550_;
					ValaMethod* _tmp551_;
					ValaMemberBinding _tmp552_;
					ValaMemberBinding _tmp553_;
					_tmp549_ = lambda;
					_tmp550_ = vala_lambda_expression_get_method (_tmp549_);
					_tmp551_ = _tmp550_;
					_tmp552_ = vala_method_get_binding (_tmp551_);
					_tmp553_ = _tmp552_;
					_tmp547_ = _tmp553_ != VALA_MEMBER_BINDING_STATIC;
				} else {
					_tmp547_ = FALSE;
				}
				if (_tmp547_) {
					ValaLambdaExpression* _tmp554_;
					ValaMethod* _tmp555_;
					ValaMethod* _tmp556_;
					_tmp554_ = lambda;
					_tmp555_ = vala_lambda_expression_get_method (_tmp554_);
					_tmp556_ = _tmp555_;
					vala_method_set_closure (_tmp556_, TRUE);
				}
				_vala_code_node_unref0 (arg);
			}
		}
	}
	_tmp557_ = ret_type;
	if (VALA_IS_VOID_TYPE (_tmp557_)) {
		gboolean _tmp558_ = FALSE;
		gboolean _tmp559_ = FALSE;
		ValaCodeNode* _tmp560_;
		ValaCodeNode* _tmp561_;
		_tmp560_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp561_ = _tmp560_;
		if (!VALA_IS_EXPRESSION_STATEMENT (_tmp561_)) {
			ValaCodeNode* _tmp562_;
			ValaCodeNode* _tmp563_;
			_tmp562_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp563_ = _tmp562_;
			_tmp559_ = !VALA_IS_FOR_STATEMENT (_tmp563_);
		} else {
			_tmp559_ = FALSE;
		}
		if (_tmp559_) {
			ValaCodeNode* _tmp564_;
			ValaCodeNode* _tmp565_;
			_tmp564_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp565_ = _tmp564_;
			_tmp558_ = !VALA_IS_YIELD_STATEMENT (_tmp565_);
		} else {
			_tmp558_ = FALSE;
		}
		if (_tmp558_) {
			ValaSourceReference* _tmp566_;
			ValaSourceReference* _tmp567_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp566_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp567_ = _tmp566_;
			vala_report_error (_tmp567_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp568_ = ret_type;
	_tmp569_ = vala_data_type_copy (_tmp568_);
	_tmp570_ = _tmp569_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp570_);
	_vala_code_node_unref0 (_tmp570_);
	_tmp571_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp572_ = _tmp571_;
	_tmp573_ = target_object_type;
	_tmp574_ = method_type_args;
	_tmp575_ = vala_data_type_get_actual_type (_tmp572_, _tmp573_, _tmp574_, (ValaCodeNode*) self);
	_tmp576_ = _tmp575_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp576_);
	_vala_code_node_unref0 (_tmp576_);
	_tmp577_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp578_ = _tmp577_;
	if (_tmp578_) {
		gboolean _tmp579_ = FALSE;
		ValaDataType* _tmp580_;
		gboolean _tmp588_ = FALSE;
		ValaSemanticAnalyzer* _tmp589_;
		ValaSemanticAnalyzer* _tmp590_;
		ValaMethod* _tmp591_;
		ValaMethod* _tmp592_;
		_tmp580_ = mtype;
		if (!VALA_IS_METHOD_TYPE (_tmp580_)) {
			_tmp579_ = TRUE;
		} else {
			ValaDataType* _tmp581_;
			ValaMethod* _tmp582_;
			ValaMethod* _tmp583_;
			gboolean _tmp584_;
			gboolean _tmp585_;
			_tmp581_ = mtype;
			_tmp582_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp581_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
			_tmp583_ = _tmp582_;
			_tmp584_ = vala_method_get_coroutine (_tmp583_);
			_tmp585_ = _tmp584_;
			_tmp579_ = !_tmp585_;
		}
		if (_tmp579_) {
			ValaSourceReference* _tmp586_;
			ValaSourceReference* _tmp587_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp586_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp587_ = _tmp586_;
			vala_report_error (_tmp587_, "yield expression requires async method");
		}
		_tmp589_ = vala_code_context_get_analyzer (context);
		_tmp590_ = _tmp589_;
		_tmp591_ = vala_semantic_analyzer_get_current_method (_tmp590_);
		_tmp592_ = _tmp591_;
		if (_tmp592_ == NULL) {
			_tmp588_ = TRUE;
		} else {
			ValaSemanticAnalyzer* _tmp593_;
			ValaSemanticAnalyzer* _tmp594_;
			ValaMethod* _tmp595_;
			ValaMethod* _tmp596_;
			gboolean _tmp597_;
			gboolean _tmp598_;
			_tmp593_ = vala_code_context_get_analyzer (context);
			_tmp594_ = _tmp593_;
			_tmp595_ = vala_semantic_analyzer_get_current_method (_tmp594_);
			_tmp596_ = _tmp595_;
			_tmp597_ = vala_method_get_coroutine (_tmp596_);
			_tmp598_ = _tmp597_;
			_tmp588_ = !_tmp598_;
		}
		if (_tmp588_) {
			ValaSourceReference* _tmp599_;
			ValaSourceReference* _tmp600_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp599_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp600_ = _tmp599_;
			vala_report_error (_tmp600_, "yield expression not available outside async method");
		}
	}
	_tmp601_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp601_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp602_;
		ValaMethod* _tmp603_;
		ValaMethod* _tmp604_;
		ValaMethod* _tmp605_;
		gboolean _tmp606_;
		gboolean _tmp607_;
		ValaMethod* _tmp610_;
		gboolean _tmp611_;
		gboolean _tmp612_;
		gboolean _tmp638_ = FALSE;
		gboolean _tmp639_ = FALSE;
		gboolean _tmp640_ = FALSE;
		gboolean _tmp641_;
		gboolean _tmp642_;
		ValaSignal* sig = NULL;
		ValaMethod* _tmp654_;
		ValaSymbol* _tmp655_;
		ValaSymbol* _tmp656_;
		gboolean _tmp657_ = FALSE;
		ValaSignal* _tmp658_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp671_;
		ValaSymbol* _tmp672_;
		ValaSymbol* _tmp673_;
		gboolean _tmp674_ = FALSE;
		ValaDynamicSignal* _tmp675_;
		gboolean _tmp725_ = FALSE;
		ValaMethod* _tmp726_;
		gboolean _tmp834_ = FALSE;
		ValaMethod* _tmp835_;
		_tmp602_ = mtype;
		_tmp603_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp602_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp604_ = _tmp603_;
		m = _tmp604_;
		_tmp605_ = m;
		_tmp606_ = vala_method_get_returns_floating_reference (_tmp605_);
		_tmp607_ = _tmp606_;
		if (_tmp607_) {
			ValaDataType* _tmp608_;
			ValaDataType* _tmp609_;
			_tmp608_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp609_ = _tmp608_;
			vala_data_type_set_floating_reference (_tmp609_, TRUE);
		}
		_tmp610_ = m;
		_tmp611_ = vala_method_get_returns_modified_pointer (_tmp610_);
		_tmp612_ = _tmp611_;
		if (_tmp612_) {
			ValaExpression* inner = NULL;
			ValaExpression* _tmp613_;
			ValaExpression* _tmp614_;
			ValaExpression* _tmp615_;
			ValaExpression* _tmp616_;
			ValaExpression* _tmp617_;
			ValaProperty* prop = NULL;
			ValaExpression* _tmp618_;
			ValaSymbol* _tmp619_;
			ValaSymbol* _tmp620_;
			gboolean _tmp621_ = FALSE;
			ValaProperty* _tmp622_;
			_tmp613_ = vala_method_call_get_call (self);
			_tmp614_ = _tmp613_;
			_tmp615_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp614_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp616_ = _tmp615_;
			inner = _tmp616_;
			_tmp617_ = inner;
			vala_expression_set_lvalue (_tmp617_, TRUE);
			_tmp618_ = inner;
			_tmp619_ = vala_expression_get_symbol_reference (_tmp618_);
			_tmp620_ = _tmp619_;
			prop = VALA_IS_PROPERTY (_tmp620_) ? ((ValaProperty*) _tmp620_) : NULL;
			_tmp622_ = prop;
			if (_tmp622_ != NULL) {
				gboolean _tmp623_ = FALSE;
				ValaProperty* _tmp624_;
				ValaPropertyAccessor* _tmp625_;
				ValaPropertyAccessor* _tmp626_;
				_tmp624_ = prop;
				_tmp625_ = vala_property_get_set_accessor (_tmp624_);
				_tmp626_ = _tmp625_;
				if (_tmp626_ == NULL) {
					_tmp623_ = TRUE;
				} else {
					ValaProperty* _tmp627_;
					ValaPropertyAccessor* _tmp628_;
					ValaPropertyAccessor* _tmp629_;
					gboolean _tmp630_;
					gboolean _tmp631_;
					_tmp627_ = prop;
					_tmp628_ = vala_property_get_set_accessor (_tmp627_);
					_tmp629_ = _tmp628_;
					_tmp630_ = vala_property_accessor_get_writable (_tmp629_);
					_tmp631_ = _tmp630_;
					_tmp623_ = !_tmp631_;
				}
				_tmp621_ = _tmp623_;
			} else {
				_tmp621_ = FALSE;
			}
			if (_tmp621_) {
				ValaExpression* _tmp632_;
				ValaSourceReference* _tmp633_;
				ValaSourceReference* _tmp634_;
				ValaProperty* _tmp635_;
				gchar* _tmp636_;
				gchar* _tmp637_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp632_ = inner;
				_tmp633_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp632_);
				_tmp634_ = _tmp633_;
				_tmp635_ = prop;
				_tmp636_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp635_);
				_tmp637_ = _tmp636_;
				vala_report_error (_tmp634_, "Property `%s' is read-only", _tmp637_);
				_g_free0 (_tmp637_);
			}
		}
		_tmp641_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp642_ = _tmp641_;
		if (_tmp642_) {
			ValaDataType* _tmp643_;
			ValaDataType* _tmp644_;
			gboolean _tmp645_;
			gboolean _tmp646_;
			_tmp643_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp644_ = _tmp643_;
			_tmp645_ = vala_data_type_get_nullable (_tmp644_);
			_tmp646_ = _tmp645_;
			_tmp640_ = !_tmp646_;
		} else {
			_tmp640_ = FALSE;
		}
		if (_tmp640_) {
			ValaDataType* _tmp647_;
			ValaDataType* _tmp648_;
			gboolean _tmp649_;
			gboolean _tmp650_;
			_tmp647_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp648_ = _tmp647_;
			_tmp649_ = vala_data_type_get_floating_reference (_tmp648_);
			_tmp650_ = _tmp649_;
			_tmp639_ = _tmp650_;
		} else {
			_tmp639_ = FALSE;
		}
		if (_tmp639_) {
			ValaDataType* _tmp651_;
			_tmp651_ = ret_type;
			_tmp638_ = VALA_IS_OBJECT_TYPE (_tmp651_);
		} else {
			_tmp638_ = FALSE;
		}
		if (_tmp638_) {
			ValaDataType* _tmp652_;
			ValaDataType* _tmp653_;
			_tmp652_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp653_ = _tmp652_;
			vala_data_type_set_nullable (_tmp653_, TRUE);
		}
		_tmp654_ = m;
		_tmp655_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp654_);
		_tmp656_ = _tmp655_;
		sig = VALA_IS_SIGNAL (_tmp656_) ? ((ValaSignal*) _tmp656_) : NULL;
		_tmp658_ = sig;
		if (_tmp658_ != NULL) {
			ValaMethod* _tmp659_;
			const gchar* _tmp660_;
			const gchar* _tmp661_;
			_tmp659_ = m;
			_tmp660_ = vala_symbol_get_name ((ValaSymbol*) _tmp659_);
			_tmp661_ = _tmp660_;
			_tmp657_ = g_strcmp0 (_tmp661_, "disconnect") == 0;
		} else {
			_tmp657_ = FALSE;
		}
		if (_tmp657_) {
			gboolean _tmp662_ = FALSE;
			ValaList* _tmp663_;
			gboolean _tmp664_;
			gboolean _tmp665_;
			_tmp663_ = self->priv->argument_list;
			_tmp664_ = vala_collection_get_is_empty ((ValaCollection*) _tmp663_);
			_tmp665_ = _tmp664_;
			if (!_tmp665_) {
				ValaList* _tmp666_;
				gpointer _tmp667_;
				ValaExpression* _tmp668_;
				_tmp666_ = self->priv->argument_list;
				_tmp667_ = vala_list_get (_tmp666_, 0);
				_tmp668_ = (ValaExpression*) _tmp667_;
				_tmp662_ = VALA_IS_LAMBDA_EXPRESSION (_tmp668_);
				_vala_code_node_unref0 (_tmp668_);
			} else {
				_tmp662_ = FALSE;
			}
			if (_tmp662_) {
				ValaSourceReference* _tmp669_;
				ValaSourceReference* _tmp670_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp669_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp670_ = _tmp669_;
				vala_report_error (_tmp670_, "Cannot disconnect lambda expression from signal");
				result = FALSE;
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp671_ = m;
		_tmp672_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp671_);
		_tmp673_ = _tmp672_;
		dynamic_sig = VALA_IS_DYNAMIC_SIGNAL (_tmp673_) ? ((ValaDynamicSignal*) _tmp673_) : NULL;
		_tmp675_ = dynamic_sig;
		if (_tmp675_ != NULL) {
			ValaDynamicSignal* _tmp676_;
			ValaExpression* _tmp677_;
			ValaExpression* _tmp678_;
			_tmp676_ = dynamic_sig;
			_tmp677_ = vala_dynamic_signal_get_handler (_tmp676_);
			_tmp678_ = _tmp677_;
			_tmp674_ = _tmp678_ != NULL;
		} else {
			_tmp674_ = FALSE;
		}
		if (_tmp674_) {
			ValaDynamicSignal* _tmp679_;
			ValaDynamicSignal* _tmp680_;
			ValaExpression* _tmp681_;
			ValaExpression* _tmp682_;
			ValaDataType* _tmp683_;
			ValaDataType* _tmp684_;
			ValaDataType* _tmp685_;
			ValaDataType* _tmp686_;
			ValaDataType* _tmp687_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp705_;
			ValaExpression* _tmp706_;
			ValaExpression* _tmp707_;
			ValaDynamicSignal* _tmp708_;
			ValaDynamicSignal* _tmp709_;
			ValaSymbol* _tmp710_;
			ValaSymbol* _tmp711_;
			ValaObjectType* _tmp712_;
			ValaObjectType* _tmp713_;
			ValaDelegate* _tmp714_;
			ValaDelegate* _tmp715_;
			ValaDelegateType* _tmp716_;
			ValaDelegateType* _tmp717_;
			ValaDynamicSignal* _tmp718_;
			ValaExpression* _tmp719_;
			ValaExpression* _tmp720_;
			ValaDataType* _tmp721_;
			ValaDataType* _tmp722_;
			ValaSourceReference* _tmp723_;
			ValaSourceReference* _tmp724_;
			_tmp679_ = dynamic_sig;
			_tmp680_ = dynamic_sig;
			_tmp681_ = vala_dynamic_signal_get_handler (_tmp680_);
			_tmp682_ = _tmp681_;
			_tmp683_ = vala_expression_get_value_type (_tmp682_);
			_tmp684_ = _tmp683_;
			_tmp685_ = vala_data_type_get_return_type (_tmp684_);
			_tmp686_ = vala_data_type_copy (_tmp685_);
			_tmp687_ = _tmp686_;
			vala_callable_set_return_type ((ValaCallable*) _tmp679_, _tmp687_);
			_vala_code_node_unref0 (_tmp687_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp688_;
				ValaExpression* _tmp689_;
				ValaExpression* _tmp690_;
				ValaDataType* _tmp691_;
				ValaDataType* _tmp692_;
				ValaList* _tmp693_;
				gint _param_size = 0;
				ValaList* _tmp694_;
				gint _tmp695_;
				gint _tmp696_;
				gint _param_index = 0;
				_tmp688_ = dynamic_sig;
				_tmp689_ = vala_dynamic_signal_get_handler (_tmp688_);
				_tmp690_ = _tmp689_;
				_tmp691_ = vala_expression_get_value_type (_tmp690_);
				_tmp692_ = _tmp691_;
				_tmp693_ = vala_data_type_get_parameters (_tmp692_);
				_param_list = _tmp693_;
				_tmp694_ = _param_list;
				_tmp695_ = vala_collection_get_size ((ValaCollection*) _tmp694_);
				_tmp696_ = _tmp695_;
				_param_size = _tmp696_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp697_;
					gint _tmp698_;
					ValaParameter* param = NULL;
					ValaList* _tmp699_;
					gpointer _tmp700_;
					_param_index = _param_index + 1;
					_tmp697_ = _param_index;
					_tmp698_ = _param_size;
					if (!(_tmp697_ < _tmp698_)) {
						break;
					}
					_tmp699_ = _param_list;
					_tmp700_ = vala_list_get (_tmp699_, _param_index);
					param = (ValaParameter*) _tmp700_;
					if (first) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp701_;
						ValaParameter* _tmp702_;
						ValaParameter* _tmp703_;
						ValaParameter* _tmp704_;
						_tmp701_ = dynamic_sig;
						_tmp702_ = param;
						_tmp703_ = vala_parameter_copy (_tmp702_);
						_tmp704_ = _tmp703_;
						vala_callable_add_parameter ((ValaCallable*) _tmp701_, _tmp704_);
						_vala_code_node_unref0 (_tmp704_);
					}
					_vala_code_node_unref0 (param);
				}
			}
			_tmp705_ = dynamic_sig;
			_tmp706_ = vala_dynamic_signal_get_handler (_tmp705_);
			_tmp707_ = _tmp706_;
			_tmp708_ = dynamic_sig;
			_tmp709_ = dynamic_sig;
			_tmp710_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp709_);
			_tmp711_ = _tmp710_;
			_tmp712_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp711_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp713_ = _tmp712_;
			_tmp714_ = vala_signal_get_delegate ((ValaSignal*) _tmp708_, (ValaDataType*) _tmp713_, (ValaCodeNode*) self);
			_tmp715_ = _tmp714_;
			_tmp716_ = vala_delegate_type_new (_tmp715_);
			_tmp717_ = _tmp716_;
			vala_expression_set_target_type (_tmp707_, (ValaDataType*) _tmp717_);
			_vala_code_node_unref0 (_tmp717_);
			_vala_code_node_unref0 (_tmp715_);
			_vala_code_node_unref0 (_tmp713_);
			_tmp718_ = dynamic_sig;
			_tmp719_ = vala_dynamic_signal_get_handler (_tmp718_);
			_tmp720_ = _tmp719_;
			_tmp721_ = vala_expression_get_target_type (_tmp720_);
			_tmp722_ = _tmp721_;
			_tmp723_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp724_ = _tmp723_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp722_, _tmp724_);
		}
		_tmp726_ = m;
		if (_tmp726_ != NULL) {
			ValaMethod* _tmp727_;
			_tmp727_ = m;
			_tmp725_ = vala_method_has_type_parameters (_tmp727_);
		} else {
			_tmp725_ = FALSE;
		}
		if (_tmp725_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp728_;
			ValaExpression* _tmp729_;
			ValaMemberAccess* _tmp730_;
			ValaList* _tmp731_;
			gint _tmp732_;
			gint _tmp733_;
			_tmp728_ = vala_method_call_get_call (self);
			_tmp729_ = _tmp728_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp729_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp730_ = ma;
			_tmp731_ = vala_member_access_get_type_arguments (_tmp730_);
			_tmp732_ = vala_collection_get_size ((ValaCollection*) _tmp731_);
			_tmp733_ = _tmp732_;
			if (_tmp733_ == 0) {
				ValaList* _tmp800_;
				ValaIterator* _tmp801_;
				ValaDataType* _tmp828_;
				ValaDataType* _tmp829_;
				ValaDataType* _tmp830_;
				ValaList* _tmp831_;
				ValaDataType* _tmp832_;
				ValaDataType* _tmp833_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp734_;
					ValaList* _tmp735_;
					gint _type_param_size = 0;
					ValaList* _tmp736_;
					gint _tmp737_;
					gint _tmp738_;
					gint _type_param_index = 0;
					_tmp734_ = m;
					_tmp735_ = vala_method_get_type_parameters (_tmp734_);
					_type_param_list = _tmp735_;
					_tmp736_ = _type_param_list;
					_tmp737_ = vala_collection_get_size ((ValaCollection*) _tmp736_);
					_tmp738_ = _tmp737_;
					_type_param_size = _tmp738_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp739_;
						gint _tmp740_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp741_;
						gpointer _tmp742_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp743_;
						ValaIterator* _tmp744_;
						gboolean _tmp780_ = FALSE;
						ValaDataType* _tmp781_;
						ValaDataType* _tmp791_;
						ValaMemberAccess* _tmp798_;
						ValaDataType* _tmp799_;
						_type_param_index = _type_param_index + 1;
						_tmp739_ = _type_param_index;
						_tmp740_ = _type_param_size;
						if (!(_tmp739_ < _tmp740_)) {
							break;
						}
						_tmp741_ = _type_param_list;
						_tmp742_ = vala_list_get (_tmp741_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp742_;
						type_arg = NULL;
						_tmp743_ = self->priv->argument_list;
						_tmp744_ = vala_iterable_iterator ((ValaIterable*) _tmp743_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp744_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp745_;
							gint _param_size = 0;
							ValaList* _tmp746_;
							gint _tmp747_;
							gint _tmp748_;
							gint _param_index = 0;
							_tmp745_ = params;
							_param_list = _tmp745_;
							_tmp746_ = _param_list;
							_tmp747_ = vala_collection_get_size ((ValaCollection*) _tmp746_);
							_tmp748_ = _tmp747_;
							_param_size = _tmp748_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp749_;
								gint _tmp750_;
								ValaParameter* param = NULL;
								ValaList* _tmp751_;
								gpointer _tmp752_;
								gboolean _tmp753_ = FALSE;
								ValaParameter* _tmp754_;
								gboolean _tmp755_;
								gboolean _tmp756_;
								ValaIterator* _tmp760_;
								_param_index = _param_index + 1;
								_tmp749_ = _param_index;
								_tmp750_ = _param_size;
								if (!(_tmp749_ < _tmp750_)) {
									break;
								}
								_tmp751_ = _param_list;
								_tmp752_ = vala_list_get (_tmp751_, _param_index);
								param = (ValaParameter*) _tmp752_;
								_tmp754_ = param;
								_tmp755_ = vala_parameter_get_ellipsis (_tmp754_);
								_tmp756_ = _tmp755_;
								if (_tmp756_) {
									_tmp753_ = TRUE;
								} else {
									ValaParameter* _tmp757_;
									gboolean _tmp758_;
									gboolean _tmp759_;
									_tmp757_ = param;
									_tmp758_ = vala_parameter_get_params_array (_tmp757_);
									_tmp759_ = _tmp758_;
									_tmp753_ = _tmp759_;
								}
								if (_tmp753_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp760_ = arg_it;
								if (vala_iterator_next (_tmp760_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp761_;
									gpointer _tmp762_;
									ValaParameter* _tmp763_;
									ValaDataType* _tmp764_;
									ValaDataType* _tmp765_;
									ValaTypeParameter* _tmp766_;
									ValaExpression* _tmp767_;
									ValaDataType* _tmp768_;
									ValaDataType* _tmp769_;
									ValaDataType* _tmp770_;
									ValaDataType* _tmp771_;
									ValaExpression* _tmp772_;
									ValaExpression* _tmp773_;
									ValaDataType* _tmp774_;
									ValaDataType* _tmp775_;
									ValaDataType* _tmp776_;
									ValaList* _tmp777_;
									ValaDataType* _tmp778_;
									ValaDataType* _tmp779_;
									_tmp761_ = arg_it;
									_tmp762_ = vala_iterator_get (_tmp761_);
									arg = (ValaExpression*) _tmp762_;
									_tmp763_ = param;
									_tmp764_ = vala_variable_get_variable_type ((ValaVariable*) _tmp763_);
									_tmp765_ = _tmp764_;
									_tmp766_ = type_param;
									_tmp767_ = arg;
									_tmp768_ = vala_expression_get_value_type (_tmp767_);
									_tmp769_ = _tmp768_;
									_tmp770_ = vala_data_type_infer_type_argument (_tmp765_, _tmp766_, _tmp769_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp770_;
									_tmp771_ = type_arg;
									if (_tmp771_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp772_ = arg;
									_tmp773_ = arg;
									_tmp774_ = vala_expression_get_formal_target_type (_tmp773_);
									_tmp775_ = _tmp774_;
									_tmp776_ = target_object_type;
									_tmp777_ = method_type_args;
									_tmp778_ = vala_data_type_get_actual_type (_tmp775_, _tmp776_, _tmp777_, (ValaCodeNode*) self);
									_tmp779_ = _tmp778_;
									vala_expression_set_target_type (_tmp772_, _tmp779_);
									_vala_code_node_unref0 (_tmp779_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp781_ = type_arg;
						if (_tmp781_ == NULL) {
							ValaDataType* _tmp782_;
							ValaDataType* _tmp783_;
							_tmp782_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp783_ = _tmp782_;
							_tmp780_ = _tmp783_ != NULL;
						} else {
							_tmp780_ = FALSE;
						}
						if (_tmp780_) {
							ValaMethod* _tmp784_;
							ValaDataType* _tmp785_;
							ValaDataType* _tmp786_;
							ValaTypeParameter* _tmp787_;
							ValaDataType* _tmp788_;
							ValaDataType* _tmp789_;
							ValaDataType* _tmp790_;
							_tmp784_ = m;
							_tmp785_ = vala_callable_get_return_type ((ValaCallable*) _tmp784_);
							_tmp786_ = _tmp785_;
							_tmp787_ = type_param;
							_tmp788_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp789_ = _tmp788_;
							_tmp790_ = vala_data_type_infer_type_argument (_tmp786_, _tmp787_, _tmp789_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp790_;
						}
						_tmp791_ = type_arg;
						if (_tmp791_ == NULL) {
							ValaMemberAccess* _tmp792_;
							ValaSourceReference* _tmp793_;
							ValaSourceReference* _tmp794_;
							ValaTypeParameter* _tmp795_;
							gchar* _tmp796_;
							gchar* _tmp797_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp792_ = ma;
							_tmp793_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp792_);
							_tmp794_ = _tmp793_;
							_tmp795_ = type_param;
							_tmp796_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp795_);
							_tmp797_ = _tmp796_;
							vala_report_error (_tmp794_, "cannot infer generic type argument for type parameter `%s'", _tmp797_);
							_g_free0 (_tmp797_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterator_unref0 (arg_it);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp798_ = ma;
						_tmp799_ = type_arg;
						vala_member_access_add_type_argument (_tmp798_, _tmp799_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
				}
				_tmp800_ = self->priv->argument_list;
				_tmp801_ = vala_iterable_iterator ((ValaIterable*) _tmp800_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp801_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp802_;
					gint _param_size = 0;
					ValaList* _tmp803_;
					gint _tmp804_;
					gint _tmp805_;
					gint _param_index = 0;
					_tmp802_ = params;
					_param_list = _tmp802_;
					_tmp803_ = _param_list;
					_tmp804_ = vala_collection_get_size ((ValaCollection*) _tmp803_);
					_tmp805_ = _tmp804_;
					_param_size = _tmp805_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp806_;
						gint _tmp807_;
						ValaParameter* param = NULL;
						ValaList* _tmp808_;
						gpointer _tmp809_;
						gboolean _tmp810_ = FALSE;
						ValaParameter* _tmp811_;
						gboolean _tmp812_;
						gboolean _tmp813_;
						ValaIterator* _tmp817_;
						_param_index = _param_index + 1;
						_tmp806_ = _param_index;
						_tmp807_ = _param_size;
						if (!(_tmp806_ < _tmp807_)) {
							break;
						}
						_tmp808_ = _param_list;
						_tmp809_ = vala_list_get (_tmp808_, _param_index);
						param = (ValaParameter*) _tmp809_;
						_tmp811_ = param;
						_tmp812_ = vala_parameter_get_ellipsis (_tmp811_);
						_tmp813_ = _tmp812_;
						if (_tmp813_) {
							_tmp810_ = TRUE;
						} else {
							ValaParameter* _tmp814_;
							gboolean _tmp815_;
							gboolean _tmp816_;
							_tmp814_ = param;
							_tmp815_ = vala_parameter_get_params_array (_tmp814_);
							_tmp816_ = _tmp815_;
							_tmp810_ = _tmp816_;
						}
						if (_tmp810_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp817_ = arg_it;
						if (vala_iterator_next (_tmp817_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp818_;
							gpointer _tmp819_;
							ValaExpression* _tmp820_;
							ValaExpression* _tmp821_;
							ValaDataType* _tmp822_;
							ValaDataType* _tmp823_;
							ValaDataType* _tmp824_;
							ValaList* _tmp825_;
							ValaDataType* _tmp826_;
							ValaDataType* _tmp827_;
							_tmp818_ = arg_it;
							_tmp819_ = vala_iterator_get (_tmp818_);
							arg = (ValaExpression*) _tmp819_;
							_tmp820_ = arg;
							_tmp821_ = arg;
							_tmp822_ = vala_expression_get_formal_target_type (_tmp821_);
							_tmp823_ = _tmp822_;
							_tmp824_ = target_object_type;
							_tmp825_ = method_type_args;
							_tmp826_ = vala_data_type_get_actual_type (_tmp823_, _tmp824_, _tmp825_, (ValaCodeNode*) self);
							_tmp827_ = _tmp826_;
							vala_expression_set_target_type (_tmp820_, _tmp827_);
							_vala_code_node_unref0 (_tmp827_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
				}
				_tmp828_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp829_ = _tmp828_;
				_tmp830_ = target_object_type;
				_tmp831_ = method_type_args;
				_tmp832_ = vala_data_type_get_actual_type (_tmp829_, _tmp830_, _tmp831_, (ValaCodeNode*) self);
				_tmp833_ = _tmp832_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp833_);
				_vala_code_node_unref0 (_tmp833_);
			}
		}
		_tmp835_ = m;
		if (_tmp835_ != NULL) {
			ValaMethod* _tmp836_;
			gboolean _tmp837_;
			gboolean _tmp838_;
			_tmp836_ = m;
			_tmp837_ = vala_method_get_coroutine (_tmp836_);
			_tmp838_ = _tmp837_;
			_tmp834_ = _tmp838_;
		} else {
			_tmp834_ = FALSE;
		}
		if (_tmp834_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp839_;
			ValaExpression* _tmp840_;
			ValaMemberAccess* _tmp841_;
			const gchar* _tmp842_;
			const gchar* _tmp843_;
			_tmp839_ = vala_method_call_get_call (self);
			_tmp840_ = _tmp839_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp840_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp841_ = ma;
			_tmp842_ = vala_member_access_get_member_name (_tmp841_);
			_tmp843_ = _tmp842_;
			if (g_strcmp0 (_tmp843_, "end") == 0) {
				ValaMethod* _tmp844_;
				ValaMethod* _tmp845_;
				ValaMethodType* _tmp846_;
				ValaDataType* _tmp847_;
				ValaSourceReference* _tmp848_;
				ValaSourceReference* _tmp849_;
				_tmp844_ = m;
				_tmp845_ = vala_method_get_end_method (_tmp844_);
				_tmp846_ = vala_method_type_new (_tmp845_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp846_;
				_tmp847_ = mtype;
				_tmp848_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp849_ = _tmp848_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp847_, _tmp849_);
			}
		}
	}
	_tmp850_ = vala_code_context_get_analyzer (context);
	_tmp851_ = _tmp850_;
	_tmp852_ = mtype;
	_tmp853_ = params;
	_tmp854_ = self->priv->argument_list;
	if (!vala_semantic_analyzer_check_arguments (_tmp851_, (ValaExpression*) self, _tmp852_, _tmp853_, _tmp854_)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp855_;
		gint _arg_size = 0;
		ValaList* _tmp856_;
		gint _tmp857_;
		gint _tmp858_;
		gint _arg_index = 0;
		_tmp855_ = self->priv->argument_list;
		_arg_list = _tmp855_;
		_tmp856_ = _arg_list;
		_tmp857_ = vala_collection_get_size ((ValaCollection*) _tmp856_);
		_tmp858_ = _tmp857_;
		_arg_size = _tmp858_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp859_;
			gint _tmp860_;
			ValaExpression* arg = NULL;
			ValaList* _tmp861_;
			gpointer _tmp862_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp863_;
			gboolean _tmp864_ = FALSE;
			ValaSizeofExpression* _tmp865_;
			_arg_index = _arg_index + 1;
			_tmp859_ = _arg_index;
			_tmp860_ = _arg_size;
			if (!(_tmp859_ < _tmp860_)) {
				break;
			}
			_tmp861_ = _arg_list;
			_tmp862_ = vala_list_get (_tmp861_, _arg_index);
			arg = (ValaExpression*) _tmp862_;
			_tmp863_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp863_) ? ((ValaSizeofExpression*) _tmp863_) : NULL;
			_tmp865_ = sizeof_expr;
			if (_tmp865_ != NULL) {
				ValaSizeofExpression* _tmp866_;
				ValaDataType* _tmp867_;
				ValaDataType* _tmp868_;
				_tmp866_ = sizeof_expr;
				_tmp867_ = vala_sizeof_expression_get_type_reference (_tmp866_);
				_tmp868_ = _tmp867_;
				_tmp864_ = VALA_IS_GENERIC_TYPE (_tmp868_);
			} else {
				_tmp864_ = FALSE;
			}
			if (_tmp864_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp869_;
				ValaDataType* _tmp870_;
				ValaDataType* _tmp871_;
				ValaDataType* _tmp872_;
				ValaList* _tmp873_;
				ValaDataType* _tmp874_;
				ValaExpression* _tmp875_;
				ValaDataType* _tmp876_;
				ValaSourceReference* _tmp877_;
				ValaSourceReference* _tmp878_;
				ValaSizeofExpression* _tmp879_;
				ValaSizeofExpression* _tmp880_;
				_tmp869_ = sizeof_expr;
				_tmp870_ = vala_sizeof_expression_get_type_reference (_tmp869_);
				_tmp871_ = _tmp870_;
				_tmp872_ = target_object_type;
				_tmp873_ = method_type_args;
				_tmp874_ = vala_data_type_get_actual_type (_tmp871_, _tmp872_, _tmp873_, (ValaCodeNode*) self);
				sizeof_type = _tmp874_;
				_tmp875_ = arg;
				_tmp876_ = sizeof_type;
				_tmp877_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp878_ = _tmp877_;
				_tmp879_ = vala_sizeof_expression_new (_tmp876_, _tmp878_);
				_tmp880_ = _tmp879_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp875_, (ValaExpression*) _tmp880_);
				_vala_code_node_unref0 (_tmp880_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp883_ = base_cm;
	if (_tmp883_ != NULL) {
		ValaCreationMethod* _tmp884_;
		_tmp884_ = base_cm;
		_tmp882_ = vala_method_is_variadic ((ValaMethod*) _tmp884_);
	} else {
		_tmp882_ = FALSE;
	}
	if (_tmp882_) {
		ValaList* _tmp885_;
		gint _tmp886_;
		gint _tmp887_;
		ValaCreationMethod* _tmp888_;
		ValaList* _tmp889_;
		gint _tmp890_;
		gint _tmp891_;
		_tmp885_ = self->priv->argument_list;
		_tmp886_ = vala_collection_get_size ((ValaCollection*) _tmp885_);
		_tmp887_ = _tmp886_;
		_tmp888_ = base_cm;
		_tmp889_ = vala_callable_get_parameters ((ValaCallable*) _tmp888_);
		_tmp890_ = vala_collection_get_size ((ValaCollection*) _tmp889_);
		_tmp891_ = _tmp890_;
		_tmp881_ = _tmp887_ == _tmp891_;
	} else {
		_tmp881_ = FALSE;
	}
	if (_tmp881_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp892_;
		ValaList* _tmp893_;
		gint _tmp894_;
		gint _tmp895_;
		gpointer _tmp896_;
		gboolean _tmp897_ = FALSE;
		ValaExpression* _tmp898_;
		ValaDataType* _tmp899_;
		ValaDataType* _tmp900_;
		_tmp892_ = self->priv->argument_list;
		_tmp893_ = self->priv->argument_list;
		_tmp894_ = vala_collection_get_size ((ValaCollection*) _tmp893_);
		_tmp895_ = _tmp894_;
		_tmp896_ = vala_list_get (_tmp892_, _tmp895_ - 1);
		this_last_arg = (ValaExpression*) _tmp896_;
		_tmp898_ = this_last_arg;
		_tmp899_ = vala_expression_get_value_type (_tmp898_);
		_tmp900_ = _tmp899_;
		if (VALA_IS_STRUCT_VALUE_TYPE (_tmp900_)) {
			ValaExpression* _tmp901_;
			ValaDataType* _tmp902_;
			ValaDataType* _tmp903_;
			ValaTypeSymbol* _tmp904_;
			ValaTypeSymbol* _tmp905_;
			ValaSemanticAnalyzer* _tmp906_;
			ValaSemanticAnalyzer* _tmp907_;
			ValaDataType* _tmp908_;
			ValaTypeSymbol* _tmp909_;
			ValaTypeSymbol* _tmp910_;
			_tmp901_ = this_last_arg;
			_tmp902_ = vala_expression_get_value_type (_tmp901_);
			_tmp903_ = _tmp902_;
			_tmp904_ = vala_data_type_get_type_symbol (_tmp903_);
			_tmp905_ = _tmp904_;
			_tmp906_ = vala_code_context_get_analyzer (context);
			_tmp907_ = _tmp906_;
			_tmp908_ = _tmp907_->va_list_type;
			_tmp909_ = vala_data_type_get_type_symbol (_tmp908_);
			_tmp910_ = _tmp909_;
			_tmp897_ = _tmp905_ == _tmp910_;
		} else {
			_tmp897_ = FALSE;
		}
		if (_tmp897_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp911_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp912_ = _tmp911_;
	vala_code_node_check ((ValaCodeNode*) _tmp912_, context);
	_tmp913_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp914_ = _tmp913_;
	if (_tmp914_) {
		gboolean _tmp915_ = FALSE;
		ValaCodeNode* _tmp916_;
		ValaCodeNode* _tmp917_;
		_tmp916_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp917_ = _tmp916_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp917_)) {
			_tmp915_ = TRUE;
		} else {
			ValaCodeNode* _tmp918_;
			ValaCodeNode* _tmp919_;
			_tmp918_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp919_ = _tmp918_;
			_tmp915_ = VALA_IS_EXPRESSION_STATEMENT (_tmp919_);
		}
		if (_tmp915_) {
		} else {
			ValaSemanticAnalyzer* _tmp920_;
			ValaSemanticAnalyzer* _tmp921_;
			ValaSymbol* _tmp922_;
			ValaSymbol* _tmp923_;
			_tmp920_ = vala_code_context_get_analyzer (context);
			_tmp921_ = _tmp920_;
			_tmp922_ = vala_semantic_analyzer_get_current_symbol (_tmp921_);
			_tmp923_ = _tmp922_;
			if (!VALA_IS_BLOCK (_tmp923_)) {
				ValaSourceReference* _tmp924_;
				ValaSourceReference* _tmp925_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp924_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp925_ = _tmp924_;
				vala_report_error (_tmp925_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp926_;
				ValaCodeNode* _tmp927_;
				ValaCodeNode* _tmp928_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp929_;
				ValaDataType* _tmp930_;
				ValaDataType* _tmp931_;
				ValaDataType* _tmp932_;
				gchar* _tmp933_;
				gchar* _tmp934_;
				ValaSourceReference* _tmp935_;
				ValaSourceReference* _tmp936_;
				ValaLocalVariable* _tmp937_;
				ValaLocalVariable* _tmp938_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp939_;
				ValaSourceReference* _tmp940_;
				ValaSourceReference* _tmp941_;
				ValaDeclarationStatement* _tmp942_;
				ValaDataType* _tmp943_;
				ValaDataType* _tmp944_;
				ValaSemanticAnalyzer* _tmp948_;
				ValaSemanticAnalyzer* _tmp949_;
				ValaBlock* _tmp950_;
				ValaDeclarationStatement* _tmp951_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp952_;
				ValaDataType* _tmp953_;
				ValaDataType* _tmp954_;
				ValaExpression* _tmp955_;
				ValaExpression* _tmp956_;
				ValaDataType* _tmp957_;
				ValaDataType* _tmp958_;
				ValaLocalVariable* _tmp959_;
				ValaDeclarationStatement* _tmp960_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp961_;
				ValaSemanticAnalyzer* _tmp962_;
				ValaSymbol* _tmp963_;
				ValaSymbol* _tmp964_;
				ValaBlock* _tmp965_;
				ValaBlock* _tmp966_;
				ValaLocalVariable* _tmp967_;
				ValaSemanticAnalyzer* _tmp968_;
				ValaSemanticAnalyzer* _tmp969_;
				ValaBlock* _tmp970_;
				ValaLocalVariable* _tmp971_;
				ValaCodeNode* _tmp972_;
				ValaExpression* _tmp973_;
				ValaExpression* _tmp974_;
				_tmp926_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp927_ = _tmp926_;
				_tmp928_ = _vala_code_node_ref0 (_tmp927_);
				old_parent_node = _tmp928_;
				_tmp929_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp930_ = _tmp929_;
				_tmp931_ = vala_data_type_copy (_tmp930_);
				_tmp932_ = _tmp931_;
				_tmp933_ = vala_code_node_get_temp_name ();
				_tmp934_ = _tmp933_;
				_tmp935_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp936_ = _tmp935_;
				_tmp937_ = vala_local_variable_new (_tmp932_, _tmp934_, NULL, _tmp936_);
				_tmp938_ = _tmp937_;
				_g_free0 (_tmp934_);
				_vala_code_node_unref0 (_tmp932_);
				local = _tmp938_;
				_tmp939_ = local;
				_tmp940_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp941_ = _tmp940_;
				_tmp942_ = vala_declaration_statement_new ((ValaSymbol*) _tmp939_, _tmp941_);
				decl = _tmp942_;
				_tmp943_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp944_ = _tmp943_;
				if (_tmp944_ == NULL) {
					ValaLocalVariable* _tmp945_;
					ValaDataType* _tmp946_;
					ValaDataType* _tmp947_;
					_tmp945_ = local;
					_tmp946_ = vala_variable_get_variable_type ((ValaVariable*) _tmp945_);
					_tmp947_ = _tmp946_;
					vala_data_type_set_floating_reference (_tmp947_, FALSE);
				}
				_tmp948_ = vala_code_context_get_analyzer (context);
				_tmp949_ = _tmp948_;
				_tmp950_ = _tmp949_->insert_block;
				_tmp951_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp950_, (ValaStatement*) _tmp951_);
				_tmp952_ = local;
				_tmp953_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp954_ = _tmp953_;
				_tmp955_ = vala_semantic_analyzer_create_temp_access (_tmp952_, _tmp954_);
				temp_access = _tmp955_;
				_tmp956_ = temp_access;
				_tmp957_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp958_ = _tmp957_;
				vala_expression_set_formal_target_type (_tmp956_, _tmp958_);
				_tmp959_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp959_, (ValaExpression*) self);
				_tmp960_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp960_, context);
				_tmp961_ = vala_code_context_get_analyzer (context);
				_tmp962_ = _tmp961_;
				_tmp963_ = vala_semantic_analyzer_get_current_symbol (_tmp962_);
				_tmp964_ = _tmp963_;
				_tmp965_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp964_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp965_;
				_tmp966_ = block;
				_tmp967_ = local;
				vala_block_remove_local_variable (_tmp966_, _tmp967_);
				_tmp968_ = vala_code_context_get_analyzer (context);
				_tmp969_ = _tmp968_;
				_tmp970_ = _tmp969_->insert_block;
				_tmp971_ = local;
				vala_block_add_local_variable (_tmp970_, _tmp971_);
				_tmp972_ = old_parent_node;
				_tmp973_ = temp_access;
				vala_code_node_replace_expression (_tmp972_, (ValaExpression*) self, _tmp973_);
				_tmp974_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp974_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp975_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp976_ = _tmp975_;
	result = !_tmp976_;
	_vala_iterator_unref0 (arg_it);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}

static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_SIGNAL (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		_tmp11_ = vala_method_call_get_call (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp14_ = _tmp13_;
		vala_code_node_emit ((ValaCodeNode*) _tmp14_, codegen);
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		vala_code_node_emit ((ValaCodeNode*) _tmp16_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp17_;
		gint _expr_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _expr_index = 0;
		_tmp17_ = self->priv->argument_list;
		_expr_list = _tmp17_;
		_tmp18_ = _expr_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_expr_size = _tmp20_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaExpression* expr = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaExpression* _tmp25_;
			_expr_index = _expr_index + 1;
			_tmp21_ = _expr_index;
			_tmp22_ = _expr_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _expr_list;
			_tmp24_ = vala_list_get (_tmp23_, _expr_index);
			expr = (ValaExpression*) _tmp24_;
			_tmp25_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp25_, codegen);
			_vala_code_node_unref0 (expr);
		}
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaStringLiteral* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	mtype = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = mtype;
	if (_tmp4_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = mtype;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		format_arg = vala_method_get_format_arg_index (_tmp7_);
		if (format_arg >= 0) {
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = self->priv->argument_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp8_ = format_arg < _tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaStringLiteral* _tmp15_;
			ValaStringLiteral* _tmp16_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, format_arg);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_string_literal_get_format_literal (_tmp14_);
			_tmp16_ = _tmp15_;
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp16_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp23_;
	GString* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* result = NULL;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		gint _expr_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_expr_list = _tmp10_;
		_tmp11_ = _expr_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_expr_size = _tmp13_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			ValaExpression* expr = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			GString* _tmp19_;
			ValaExpression* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_expr_index = _expr_index + 1;
			_tmp14_ = _expr_index;
			_tmp15_ = _expr_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _expr_list;
			_tmp17_ = vala_list_get (_tmp16_, _expr_index);
			expr = (ValaExpression*) _tmp17_;
			if (!first) {
				GString* _tmp18_;
				_tmp18_ = b;
				g_string_append (_tmp18_, ", ");
			}
			_tmp19_ = b;
			_tmp20_ = expr;
			_tmp21_ = vala_code_node_to_string ((ValaCodeNode*) _tmp20_);
			_tmp22_ = _tmp21_;
			g_string_append (_tmp19_, _tmp22_);
			_g_free0 (_tmp22_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp23_ = b;
	g_string_append_c (_tmp23_, ')');
	_tmp24_ = b;
	_tmp25_ = _tmp24_->str;
	_tmp26_ = g_strdup (_tmp25_);
	result = _tmp26_;
	_g_string_free0 (b);
	return result;
}

static void
vala_method_call_class_init (ValaMethodCallClass * klass,
                             gpointer klass_data)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_call_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}

static void
vala_method_call_vala_callable_expression_interface_init (ValaCallableExpressionIface * iface,
                                                          gpointer iface_data)
{
	vala_method_call_vala_callable_expression_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_argument = (void (*) (ValaCallableExpression*, ValaExpression*)) vala_method_call_real_add_argument;
	iface->get_argument_list = (ValaList* (*) (ValaCallableExpression*)) vala_method_call_real_get_argument_list;
	iface->get_is_yield_expression = vala_method_call_real_get_is_yield_expression;
	iface->set_is_yield_expression = vala_method_call_real_set_is_yield_expression;
}

static void
vala_method_call_instance_init (ValaMethodCall * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}

static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}

/**
 * Represents an invocation expression in the source code.
 */
static GType
vala_method_call_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
	static const GInterfaceInfo vala_callable_expression_info = { (GInterfaceInitFunc) vala_method_call_vala_callable_expression_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_method_call_type_id;
	vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
	g_type_add_interface_static (vala_method_call_type_id, VALA_TYPE_CALLABLE_EXPRESSION, &vala_callable_expression_info);
	ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
	return vala_method_call_type_id;
}

GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		GType vala_method_call_type_id;
		vala_method_call_type_id = vala_method_call_get_type_once ();
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}

