/* valafield.c generated by valac, the Vala compiler
 * generated from valafield.vala, do not modify */

/* valafield.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaFieldPrivate {
	ValaMemberBinding _binding;
	gboolean _is_volatile;
	gboolean _lock_used;
};

static gint ValaField_private_offset;
static gpointer vala_field_parent_class = NULL;
static ValaLockableIface * vala_field_vala_lockable_parent_iface = NULL;

static void vala_field_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_field_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_field_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node);
static void vala_field_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static gboolean vala_field_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_field_finalize (ValaCodeNode * obj);
static GType vala_field_get_type_once (void);

static inline gpointer
vala_field_get_instance_private (ValaField* self)
{
	return G_STRUCT_MEMBER_P (self, ValaField_private_offset);
}

ValaMemberBinding
vala_field_get_binding (ValaField* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}

void
vala_field_set_binding (ValaField* self,
                        ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_field_get_is_volatile (ValaField* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_volatile;
	return result;
}

void
vala_field_set_is_volatile (ValaField* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_volatile = value;
}

static gboolean
vala_field_real_get_lock_used (ValaLockable* base)
{
	gboolean result;
	ValaField* self;
	self = (ValaField*) base;
	result = self->priv->_lock_used;
	return result;
}

static void
vala_field_real_set_lock_used (ValaLockable* base,
                               gboolean value)
{
	ValaField* self;
	self = (ValaField*) base;
	self->priv->_lock_used = value;
}

/**
 * Creates a new field.
 *
 * @param name              field name
 * @param variable_type     field type
 * @param initializer       initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created field
 */
ValaField*
vala_field_construct (GType object_type,
                      const gchar* name,
                      ValaDataType* variable_type,
                      ValaExpression* initializer,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaField* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	self = (ValaField*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, comment);
	return self;
}

ValaField*
vala_field_new (const gchar* name,
                ValaDataType* variable_type,
                ValaExpression* initializer,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_field_construct (VALA_TYPE_FIELD, name, variable_type, initializer, source_reference, comment);
}

static void
vala_field_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaField * self;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_field (visitor, self);
}

static void
vala_field_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}

static void
vala_field_real_replace_expression (ValaCodeNode* base,
                                    ValaExpression* old_node,
                                    ValaExpression* new_node)
{
	ValaField * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_field_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_field_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaField * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaTypeSymbol* _tmp30_;
	ValaTypeSymbol* _tmp31_;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSemanticAnalyzer* _tmp33_;
	ValaDataType* _tmp34_;
	ValaTypeSymbol* _tmp35_;
	ValaTypeSymbol* _tmp36_;
	gboolean _tmp47_ = FALSE;
	ValaAttribute* _tmp48_;
	ValaDataType* _tmp57_;
	ValaDataType* _tmp58_;
	gboolean _tmp59_;
	gboolean _tmp60_;
	ValaSemanticAnalyzer* _tmp77_;
	ValaSemanticAnalyzer* _tmp78_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp80_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp91_;
	ValaDataType* _tmp92_;
	gboolean _tmp93_ = FALSE;
	gboolean _tmp94_ = FALSE;
	gboolean _tmp95_ = FALSE;
	ValaArrayType* _tmp96_;
	gboolean _tmp108_ = FALSE;
	gboolean _tmp109_ = FALSE;
	ValaArrayType* _tmp110_;
	ValaExpression* _tmp119_;
	ValaExpression* _tmp120_;
	gboolean _tmp243_ = FALSE;
	ValaMemberBinding _tmp244_;
	gboolean field_in_header = FALSE;
	ValaSymbol* _tmp249_;
	ValaSymbol* _tmp250_;
	gboolean _tmp259_ = FALSE;
	gboolean _tmp260_ = FALSE;
	gboolean _tmp261_;
	gboolean _tmp262_;
	ValaSemanticAnalyzer* _tmp277_;
	ValaSemanticAnalyzer* _tmp278_;
	ValaSourceFile* _tmp279_;
	ValaSemanticAnalyzer* _tmp280_;
	ValaSemanticAnalyzer* _tmp281_;
	ValaSymbol* _tmp282_;
	gboolean _tmp283_;
	gboolean _tmp284_;
	gboolean result = FALSE;
	self = (ValaField*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp25_ = _tmp24_;
	if (VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		vala_report_error (_tmp27_, "'void' not supported as field type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_data_type_get_type_symbol (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_code_context_get_analyzer (context);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_->va_list_type;
	_tmp35_ = vala_data_type_get_type_symbol (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp31_ == _tmp36_) {
		ValaSourceReference* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaTypeSymbol* _tmp41_;
		ValaTypeSymbol* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_data_type_get_type_symbol (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strdup_printf ("`%s' not supported as field type", _tmp44_);
		_tmp46_ = _tmp45_;
		vala_report_error (_tmp38_, _tmp46_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp44_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp48_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkChild");
	if (_tmp48_ != NULL) {
		ValaDataType* _tmp49_;
		ValaDataType* _tmp50_;
		gboolean _tmp51_;
		gboolean _tmp52_;
		_tmp49_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp50_ = _tmp49_;
		_tmp51_ = vala_data_type_get_value_owned (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp47_ = _tmp52_;
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		ValaSourceReference* _tmp53_;
		ValaSourceReference* _tmp54_;
		ValaDataType* _tmp55_;
		ValaDataType* _tmp56_;
		_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp54_ = _tmp53_;
		vala_report_warning (_tmp54_, "[GtkChild] fields must be declared as `unowned'");
		_tmp55_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp56_ = _tmp55_;
		vala_data_type_set_value_owned (_tmp56_, FALSE);
	}
	_tmp57_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp58_ = _tmp57_;
	vala_code_node_check ((ValaCodeNode*) _tmp58_, context);
	_tmp59_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp60_ = _tmp59_;
	if (!_tmp60_) {
		ValaSemanticAnalyzer* _tmp61_;
		ValaSemanticAnalyzer* _tmp62_;
		ValaDataType* _tmp63_;
		ValaDataType* _tmp64_;
		ValaDataType* _tmp65_;
		ValaDataType* _tmp66_;
		ValaTypeSymbol* _tmp67_;
		ValaTypeSymbol* _tmp68_;
		_tmp61_ = vala_code_context_get_analyzer (context);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp64_ = _tmp63_;
		vala_semantic_analyzer_check_type (_tmp62_, _tmp64_);
		_tmp65_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp66_ = _tmp65_;
		_tmp67_ = vala_data_type_get_type_symbol (_tmp66_);
		_tmp68_ = _tmp67_;
		if (_tmp68_ != NULL) {
			ValaDataType* _tmp69_;
			ValaDataType* _tmp70_;
			ValaTypeSymbol* _tmp71_;
			ValaTypeSymbol* _tmp72_;
			ValaVersionAttribute* _tmp73_;
			ValaVersionAttribute* _tmp74_;
			ValaSourceReference* _tmp75_;
			ValaSourceReference* _tmp76_;
			_tmp69_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp70_ = _tmp69_;
			_tmp71_ = vala_data_type_get_type_symbol (_tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = vala_symbol_get_version ((ValaSymbol*) _tmp72_);
			_tmp74_ = _tmp73_;
			_tmp75_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp76_ = _tmp75_;
			vala_version_attribute_check (_tmp74_, context, _tmp76_);
		}
	}
	_tmp77_ = vala_code_context_get_analyzer (context);
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp80_ = _tmp79_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp78_, (ValaSymbol*) self, _tmp80_)) {
		ValaSourceReference* _tmp81_;
		ValaSourceReference* _tmp82_;
		ValaDataType* _tmp83_;
		ValaDataType* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp84_ = _tmp83_;
		_tmp85_ = vala_code_node_to_string ((ValaCodeNode*) _tmp84_);
		_tmp86_ = _tmp85_;
		_tmp87_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp88_ = _tmp87_;
		_tmp89_ = g_strdup_printf ("field type `%s' is less accessible than field `%s'", _tmp86_, _tmp88_);
		_tmp90_ = _tmp89_;
		vala_report_error (_tmp82_, _tmp90_);
		_g_free0 (_tmp90_);
		_g_free0 (_tmp88_);
		_g_free0 (_tmp86_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp91_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp92_ = _tmp91_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp92_) ? ((ValaArrayType*) _tmp92_) : NULL;
	_tmp96_ = variable_array_type;
	if (_tmp96_ != NULL) {
		ValaArrayType* _tmp97_;
		gboolean _tmp98_;
		gboolean _tmp99_;
		_tmp97_ = variable_array_type;
		_tmp98_ = vala_array_type_get_inline_allocated (_tmp97_);
		_tmp99_ = _tmp98_;
		_tmp95_ = _tmp99_;
	} else {
		_tmp95_ = FALSE;
	}
	if (_tmp95_) {
		ValaExpression* _tmp100_;
		ValaExpression* _tmp101_;
		_tmp100_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp101_ = _tmp100_;
		_tmp94_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp101_);
	} else {
		_tmp94_ = FALSE;
	}
	if (_tmp94_) {
		ValaExpression* _tmp102_;
		ValaExpression* _tmp103_;
		ValaInitializerList* _tmp104_;
		ValaInitializerList* _tmp105_;
		_tmp102_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp103_ = _tmp102_;
		_tmp104_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp105_ = _tmp104_;
		_tmp93_ = _tmp105_ == NULL;
	} else {
		_tmp93_ = FALSE;
	}
	if (_tmp93_) {
		ValaSourceReference* _tmp106_;
		ValaSourceReference* _tmp107_;
		_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp107_ = _tmp106_;
		vala_report_warning (_tmp107_, "Inline allocated arrays don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp110_ = variable_array_type;
	if (_tmp110_ != NULL) {
		ValaArrayType* _tmp111_;
		gboolean _tmp112_;
		gboolean _tmp113_;
		_tmp111_ = variable_array_type;
		_tmp112_ = vala_array_type_get_inline_allocated (_tmp111_);
		_tmp113_ = _tmp112_;
		_tmp109_ = _tmp113_;
	} else {
		_tmp109_ = FALSE;
	}
	if (_tmp109_) {
		ValaArrayType* _tmp114_;
		gboolean _tmp115_;
		gboolean _tmp116_;
		_tmp114_ = variable_array_type;
		_tmp115_ = vala_array_type_get_fixed_length (_tmp114_);
		_tmp116_ = _tmp115_;
		_tmp108_ = !_tmp116_;
	} else {
		_tmp108_ = FALSE;
	}
	if (_tmp108_) {
		ValaSourceReference* _tmp117_;
		ValaSourceReference* _tmp118_;
		_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp118_ = _tmp117_;
		vala_report_error (_tmp118_, "Inline allocated array as field requires to have fixed length");
	}
	_tmp119_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp120_ = _tmp119_;
	if (_tmp120_ != NULL) {
		ValaExpression* _tmp121_;
		ValaExpression* _tmp122_;
		ValaDataType* _tmp123_;
		ValaDataType* _tmp124_;
		gboolean is_initializer_list = FALSE;
		gint initializer_size = 0;
		ValaExpression* _tmp125_;
		ValaExpression* _tmp126_;
		ValaExpression* _tmp131_;
		ValaExpression* _tmp132_;
		ValaExpression* _tmp133_;
		ValaExpression* _tmp134_;
		ValaDataType* _tmp135_;
		ValaDataType* _tmp136_;
		ValaExpression* _tmp139_;
		ValaExpression* _tmp140_;
		ValaDataType* _tmp141_;
		ValaDataType* _tmp142_;
		ValaDataType* _tmp143_;
		ValaDataType* _tmp144_;
		gboolean _tmp159_ = FALSE;
		gboolean _tmp160_ = FALSE;
		gboolean _tmp161_ = FALSE;
		ValaArrayType* _tmp162_;
		gboolean _tmp176_ = FALSE;
		gboolean _tmp177_ = FALSE;
		ValaArrayType* _tmp178_;
		ValaExpression* _tmp188_;
		ValaExpression* _tmp189_;
		ValaDataType* _tmp190_;
		ValaDataType* _tmp191_;
		gboolean _tmp201_ = FALSE;
		ValaSymbol* _tmp202_;
		ValaSymbol* _tmp203_;
		gboolean _tmp208_ = FALSE;
		gboolean _tmp209_ = FALSE;
		ValaSymbol* _tmp210_;
		ValaSymbol* _tmp211_;
		gboolean _tmp225_ = FALSE;
		gboolean _tmp226_ = FALSE;
		gboolean _tmp227_ = FALSE;
		ValaMemberBinding _tmp228_;
		gboolean _tmp239_;
		gboolean _tmp240_;
		_tmp121_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp124_ = _tmp123_;
		vala_expression_set_target_type (_tmp122_, _tmp124_);
		is_initializer_list = FALSE;
		initializer_size = -1;
		_tmp125_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp126_ = _tmp125_;
		if (VALA_IS_INITIALIZER_LIST (_tmp126_)) {
			ValaExpression* _tmp127_;
			ValaExpression* _tmp128_;
			gint _tmp129_;
			gint _tmp130_;
			_tmp127_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp128_ = _tmp127_;
			_tmp129_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp128_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp130_ = _tmp129_;
			initializer_size = _tmp130_;
			is_initializer_list = TRUE;
		}
		_tmp131_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp132_ = _tmp131_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp132_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp133_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp134_ = _tmp133_;
		_tmp135_ = vala_expression_get_value_type (_tmp134_);
		_tmp136_ = _tmp135_;
		if (_tmp136_ == NULL) {
			ValaSourceReference* _tmp137_;
			ValaSourceReference* _tmp138_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp138_ = _tmp137_;
			vala_report_error (_tmp138_, "expression type not allowed as initializer");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp139_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp140_ = _tmp139_;
		_tmp141_ = vala_expression_get_value_type (_tmp140_);
		_tmp142_ = _tmp141_;
		_tmp143_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp144_ = _tmp143_;
		if (!vala_data_type_compatible (_tmp142_, _tmp144_)) {
			ValaSourceReference* _tmp145_;
			ValaSourceReference* _tmp146_;
			ValaExpression* _tmp147_;
			ValaExpression* _tmp148_;
			ValaDataType* _tmp149_;
			ValaDataType* _tmp150_;
			gchar* _tmp151_;
			gchar* _tmp152_;
			ValaDataType* _tmp153_;
			ValaDataType* _tmp154_;
			gchar* _tmp155_;
			gchar* _tmp156_;
			gchar* _tmp157_;
			gchar* _tmp158_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp146_ = _tmp145_;
			_tmp147_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp148_ = _tmp147_;
			_tmp149_ = vala_expression_get_value_type (_tmp148_);
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_code_node_to_string ((ValaCodeNode*) _tmp150_);
			_tmp152_ = _tmp151_;
			_tmp153_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp154_ = _tmp153_;
			_tmp155_ = vala_code_node_to_string ((ValaCodeNode*) _tmp154_);
			_tmp156_ = _tmp155_;
			_tmp157_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp152_, _tmp156_);
			_tmp158_ = _tmp157_;
			vala_report_error (_tmp146_, _tmp158_);
			_g_free0 (_tmp158_);
			_g_free0 (_tmp156_);
			_g_free0 (_tmp152_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp162_ = variable_array_type;
		if (_tmp162_ != NULL) {
			ValaArrayType* _tmp163_;
			gboolean _tmp164_;
			gboolean _tmp165_;
			_tmp163_ = variable_array_type;
			_tmp164_ = vala_array_type_get_inline_allocated (_tmp163_);
			_tmp165_ = _tmp164_;
			_tmp161_ = _tmp165_;
		} else {
			_tmp161_ = FALSE;
		}
		if (_tmp161_) {
			ValaArrayType* _tmp166_;
			gboolean _tmp167_;
			gboolean _tmp168_;
			_tmp166_ = variable_array_type;
			_tmp167_ = vala_array_type_get_fixed_length (_tmp166_);
			_tmp168_ = _tmp167_;
			_tmp160_ = !_tmp168_;
		} else {
			_tmp160_ = FALSE;
		}
		if (_tmp160_) {
			_tmp159_ = is_initializer_list;
		} else {
			_tmp159_ = FALSE;
		}
		if (_tmp159_) {
			ValaArrayType* _tmp169_;
			gchar* _tmp170_;
			gchar* _tmp171_;
			ValaIntegerLiteral* _tmp172_;
			ValaIntegerLiteral* _tmp173_;
			ValaArrayType* _tmp174_;
			ValaArrayType* _tmp175_;
			_tmp169_ = variable_array_type;
			_tmp170_ = g_strdup_printf ("%i", initializer_size);
			_tmp171_ = _tmp170_;
			_tmp172_ = vala_integer_literal_new (_tmp171_, NULL);
			_tmp173_ = _tmp172_;
			vala_array_type_set_length (_tmp169_, (ValaExpression*) _tmp173_);
			_vala_code_node_unref0 (_tmp173_);
			_g_free0 (_tmp171_);
			_tmp174_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp174_, TRUE);
			_tmp175_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp175_, FALSE);
		}
		_tmp178_ = variable_array_type;
		if (_tmp178_ != NULL) {
			ValaArrayType* _tmp179_;
			gboolean _tmp180_;
			gboolean _tmp181_;
			_tmp179_ = variable_array_type;
			_tmp180_ = vala_array_type_get_inline_allocated (_tmp179_);
			_tmp181_ = _tmp180_;
			_tmp177_ = _tmp181_;
		} else {
			_tmp177_ = FALSE;
		}
		if (_tmp177_) {
			ValaExpression* _tmp182_;
			ValaExpression* _tmp183_;
			ValaDataType* _tmp184_;
			ValaDataType* _tmp185_;
			_tmp182_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp183_ = _tmp182_;
			_tmp184_ = vala_expression_get_value_type (_tmp183_);
			_tmp185_ = _tmp184_;
			_tmp176_ = !VALA_IS_ARRAY_TYPE (_tmp185_);
		} else {
			_tmp176_ = FALSE;
		}
		if (_tmp176_) {
			ValaSourceReference* _tmp186_;
			ValaSourceReference* _tmp187_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp186_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp187_ = _tmp186_;
			vala_report_error (_tmp187_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp188_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp189_ = _tmp188_;
		_tmp190_ = vala_expression_get_value_type (_tmp189_);
		_tmp191_ = _tmp190_;
		if (vala_data_type_is_disposable (_tmp191_)) {
			gboolean _tmp192_ = FALSE;
			ValaDataType* _tmp193_;
			ValaDataType* _tmp194_;
			_tmp193_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp194_ = _tmp193_;
			if (!VALA_IS_POINTER_TYPE (_tmp194_)) {
				ValaDataType* _tmp195_;
				ValaDataType* _tmp196_;
				gboolean _tmp197_;
				gboolean _tmp198_;
				_tmp195_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp196_ = _tmp195_;
				_tmp197_ = vala_data_type_get_value_owned (_tmp196_);
				_tmp198_ = _tmp197_;
				_tmp192_ = !_tmp198_;
			} else {
				_tmp192_ = FALSE;
			}
			if (_tmp192_) {
				ValaSourceReference* _tmp199_;
				ValaSourceReference* _tmp200_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp199_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp200_ = _tmp199_;
				vala_report_error (_tmp200_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp202_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp203_ = _tmp202_;
		if (VALA_IS_NAMESPACE (_tmp203_)) {
			ValaExpression* _tmp204_;
			ValaExpression* _tmp205_;
			_tmp204_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp205_ = _tmp204_;
			_tmp201_ = !vala_expression_is_constant (_tmp205_);
		} else {
			_tmp201_ = FALSE;
		}
		if (_tmp201_) {
			ValaSourceReference* _tmp206_;
			ValaSourceReference* _tmp207_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp206_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp207_ = _tmp206_;
			vala_report_error (_tmp207_, "Non-constant field initializers not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp210_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp211_ = _tmp210_;
		if (VALA_IS_NAMESPACE (_tmp211_)) {
			ValaExpression* _tmp212_;
			ValaExpression* _tmp213_;
			_tmp212_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp213_ = _tmp212_;
			_tmp209_ = vala_expression_is_constant (_tmp213_);
		} else {
			_tmp209_ = FALSE;
		}
		if (_tmp209_) {
			ValaExpression* _tmp214_;
			ValaExpression* _tmp215_;
			_tmp214_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp215_ = _tmp214_;
			_tmp208_ = vala_expression_is_non_null (_tmp215_);
		} else {
			_tmp208_ = FALSE;
		}
		if (_tmp208_) {
			gboolean _tmp216_ = FALSE;
			ValaDataType* _tmp217_;
			ValaDataType* _tmp218_;
			_tmp217_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp218_ = _tmp217_;
			if (vala_data_type_is_disposable (_tmp218_)) {
				ValaDataType* _tmp219_;
				ValaDataType* _tmp220_;
				gboolean _tmp221_;
				gboolean _tmp222_;
				_tmp219_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp220_ = _tmp219_;
				_tmp221_ = vala_data_type_get_value_owned (_tmp220_);
				_tmp222_ = _tmp221_;
				_tmp216_ = _tmp222_;
			} else {
				_tmp216_ = FALSE;
			}
			if (_tmp216_) {
				ValaSourceReference* _tmp223_;
				ValaSourceReference* _tmp224_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp224_ = _tmp223_;
				vala_report_error (_tmp224_, "Owned namespace fields can only be initialized in a function or method");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp228_ = self->priv->_binding;
		if (_tmp228_ == VALA_MEMBER_BINDING_STATIC) {
			ValaSymbol* _tmp229_;
			ValaSymbol* _tmp230_;
			_tmp229_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp230_ = _tmp229_;
			_tmp227_ = VALA_IS_CLASS (_tmp230_);
		} else {
			_tmp227_ = FALSE;
		}
		if (_tmp227_) {
			ValaSymbol* _tmp231_;
			ValaSymbol* _tmp232_;
			gboolean _tmp233_;
			gboolean _tmp234_;
			_tmp231_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp232_ = _tmp231_;
			_tmp233_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp232_, VALA_TYPE_CLASS, ValaClass));
			_tmp234_ = _tmp233_;
			_tmp226_ = _tmp234_;
		} else {
			_tmp226_ = FALSE;
		}
		if (_tmp226_) {
			ValaExpression* _tmp235_;
			ValaExpression* _tmp236_;
			_tmp235_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp236_ = _tmp235_;
			_tmp225_ = !vala_expression_is_constant (_tmp236_);
		} else {
			_tmp225_ = FALSE;
		}
		if (_tmp225_) {
			ValaSourceReference* _tmp237_;
			ValaSourceReference* _tmp238_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp238_ = _tmp237_;
			vala_report_error (_tmp238_, "Static fields in compact classes cannot have non-constant initializers");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp239_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp240_ = _tmp239_;
		if (_tmp240_) {
			ValaSourceReference* _tmp241_;
			ValaSourceReference* _tmp242_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp241_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp242_ = _tmp241_;
			vala_report_error (_tmp242_, "External fields cannot use initializers");
		}
	}
	_tmp244_ = self->priv->_binding;
	if (_tmp244_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSymbol* _tmp245_;
		ValaSymbol* _tmp246_;
		_tmp245_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp246_ = _tmp245_;
		_tmp243_ = VALA_IS_INTERFACE (_tmp246_);
	} else {
		_tmp243_ = FALSE;
	}
	if (_tmp243_) {
		ValaSourceReference* _tmp247_;
		ValaSourceReference* _tmp248_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp247_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp248_ = _tmp247_;
		vala_report_error (_tmp248_, "Interfaces may not have instance fields");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	field_in_header = !vala_symbol_is_internal_symbol ((ValaSymbol*) self);
	_tmp249_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp250_ = _tmp249_;
	if (VALA_IS_CLASS (_tmp250_)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp251_;
		ValaSymbol* _tmp252_;
		ValaClass* _tmp253_;
		gboolean _tmp254_ = FALSE;
		ValaClass* _tmp255_;
		gboolean _tmp256_;
		gboolean _tmp257_;
		_tmp251_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp252_ = _tmp251_;
		_tmp253_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp252_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp253_;
		_tmp255_ = cl;
		_tmp256_ = vala_class_get_is_compact (_tmp255_);
		_tmp257_ = _tmp256_;
		if (_tmp257_) {
			ValaClass* _tmp258_;
			_tmp258_ = cl;
			_tmp254_ = !vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp258_);
		} else {
			_tmp254_ = FALSE;
		}
		if (_tmp254_) {
			field_in_header = TRUE;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp261_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp262_ = _tmp261_;
	if (!_tmp262_) {
		gboolean _tmp263_;
		gboolean _tmp264_;
		_tmp263_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp264_ = _tmp263_;
		_tmp260_ = !_tmp264_;
	} else {
		_tmp260_ = FALSE;
	}
	if (_tmp260_) {
		ValaSymbol* _tmp265_;
		ValaSymbol* _tmp266_;
		_tmp265_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp266_ = _tmp265_;
		_tmp259_ = _tmp266_ != NULL;
		_vala_code_node_unref0 (_tmp266_);
	} else {
		_tmp259_ = FALSE;
	}
	if (_tmp259_) {
		ValaSourceReference* _tmp267_;
		ValaSourceReference* _tmp268_;
		gchar* _tmp269_;
		gchar* _tmp270_;
		ValaSymbol* _tmp271_;
		ValaSymbol* _tmp272_;
		gchar* _tmp273_;
		gchar* _tmp274_;
		gchar* _tmp275_;
		gchar* _tmp276_;
		_tmp267_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp268_ = _tmp267_;
		_tmp269_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp270_ = _tmp269_;
		_tmp271_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp272_ = _tmp271_;
		_tmp273_ = vala_symbol_get_full_name (_tmp272_);
		_tmp274_ = _tmp273_;
		_tmp275_ = g_strdup_printf ("%s hides inherited field `%s'. Use the `new' keyword if hiding was int" \
"entional", _tmp270_, _tmp274_);
		_tmp276_ = _tmp275_;
		vala_report_warning (_tmp268_, _tmp276_);
		_g_free0 (_tmp276_);
		_g_free0 (_tmp274_);
		_vala_code_node_unref0 (_tmp272_);
		_g_free0 (_tmp270_);
	}
	_tmp277_ = vala_code_context_get_analyzer (context);
	_tmp278_ = _tmp277_;
	_tmp279_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp278_, _tmp279_);
	_tmp280_ = vala_code_context_get_analyzer (context);
	_tmp281_ = _tmp280_;
	_tmp282_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp281_, _tmp282_);
	_tmp283_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp284_ = _tmp283_;
	result = !_tmp284_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_field_class_init (ValaFieldClass * klass,
                       gpointer klass_data)
{
	vala_field_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_field_finalize;
	g_type_class_adjust_private_offset (klass, &ValaField_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_field_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_field_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_field_real_check;
}

static void
vala_field_vala_lockable_interface_init (ValaLockableIface * iface,
                                         gpointer iface_data)
{
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = vala_field_real_get_lock_used;
	iface->set_lock_used = vala_field_real_set_lock_used;
}

static void
vala_field_instance_init (ValaField * self,
                          gpointer klass)
{
	self->priv = vala_field_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
}

static void
vala_field_finalize (ValaCodeNode * obj)
{
	ValaField * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FIELD, ValaField);
	VALA_CODE_NODE_CLASS (vala_field_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace field.
 */
static GType
vala_field_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_instance_init, NULL };
	static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_field_type_id;
	vala_field_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaField", &g_define_type_info, 0);
	g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
	ValaField_private_offset = g_type_add_instance_private (vala_field_type_id, sizeof (ValaFieldPrivate));
	return vala_field_type_id;
}

GType
vala_field_get_type (void)
{
	static volatile gsize vala_field_type_id__volatile = 0;
	if (g_once_init_enter (&vala_field_type_id__volatile)) {
		GType vala_field_type_id;
		vala_field_type_id = vala_field_get_type_once ();
		g_once_init_leave (&vala_field_type_id__volatile, vala_field_type_id);
	}
	return vala_field_type_id__volatile;
}

