/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
	gboolean is_with_variable_access;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaDataType* _tmp13_;
			_type_arg_index = _type_arg_index + 1;
			_tmp9_ = _type_arg_index;
			_tmp10_ = _type_arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _type_arg_list;
			_tmp12_ = vala_list_get (_tmp11_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp12_;
			_tmp13_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp18_;
	ValaArrayList* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp646_ = FALSE;
	gboolean _tmp647_ = FALSE;
	gboolean _tmp648_ = FALSE;
	ValaExpression* _tmp649_;
	ValaExpression* _tmp650_;
	ValaSymbol* _tmp678_;
	ValaSymbol* _tmp679_;
	ValaSymbol* _tmp751_;
	ValaSymbol* _tmp752_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp790_;
	ValaSymbol* _tmp791_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp792_;
	ValaSymbol* _tmp793_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1182_;
	ValaSymbol* _tmp1183_;
	ValaSymbol* _tmp1185_;
	ValaVersionAttribute* _tmp1186_;
	ValaVersionAttribute* _tmp1187_;
	ValaSourceReference* _tmp1188_;
	ValaSourceReference* _tmp1189_;
	gboolean _tmp1190_ = FALSE;
	ValaSymbolAccessibility _tmp1191_;
	gboolean _tmp1247_ = FALSE;
	gboolean _tmp1274_ = FALSE;
	gboolean _tmp1275_ = FALSE;
	ValaDataType* _tmp1554_;
	ValaDataType* _tmp1555_;
	gboolean _tmp1558_;
	gboolean _tmp1559_;
	gboolean _tmp1560_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaDataType* _tmp17_;
			_type_arg_index = _type_arg_index + 1;
			_tmp13_ = _type_arg_index;
			_tmp14_ = _type_arg_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _type_arg_list;
			_tmp16_ = vala_list_get (_tmp15_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp16_;
			_tmp17_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp17_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp18_);
	visited_types = _tmp19_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp20_ = self->priv->_qualified;
	if (_tmp20_) {
		ValaNamespace* _tmp21_;
		ValaNamespace* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaScope* _tmp24_;
		ValaScope* _tmp25_;
		const gchar* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaSymbol* _tmp28_;
		_tmp21_ = vala_code_context_get_root (context);
		_tmp22_ = _tmp21_;
		base_symbol = (ValaSymbol*) _tmp22_;
		_tmp23_ = base_symbol;
		_tmp24_ = vala_symbol_get_scope (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = self->priv->_member_name;
		_tmp27_ = vala_scope_lookup (_tmp25_, _tmp26_);
		_tmp28_ = _tmp27_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp28_);
		_vala_code_node_unref0 (_tmp28_);
	} else {
		ValaExpression* _tmp29_;
		ValaExpression* _tmp30_;
		_tmp29_ = vala_member_access_get_inner (self);
		_tmp30_ = _tmp29_;
		if (_tmp30_ == NULL) {
			const gchar* _tmp31_;
			ValaSemanticAnalyzer* _tmp36_;
			ValaSemanticAnalyzer* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaSymbol* _tmp39_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp40_;
			ValaSemanticAnalyzer* _tmp41_;
			ValaSymbol* _tmp42_;
			ValaSymbol* _tmp43_;
			gboolean _tmp180_ = FALSE;
			ValaSymbol* _tmp181_;
			ValaSymbol* _tmp182_;
			_tmp31_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp31_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp32_;
				ValaSemanticAnalyzer* _tmp33_;
				_tmp32_ = vala_code_context_get_analyzer (context);
				_tmp33_ = _tmp32_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp33_)) {
					ValaSourceReference* _tmp34_;
					ValaSourceReference* _tmp35_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp35_ = _tmp34_;
					vala_report_error (_tmp35_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp36_ = vala_code_context_get_analyzer (context);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_semantic_analyzer_get_current_symbol (_tmp37_);
			_tmp39_ = _tmp38_;
			base_symbol = _tmp39_;
			method_found = FALSE;
			_tmp40_ = vala_code_context_get_analyzer (context);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_semantic_analyzer_get_current_symbol (_tmp41_);
			_tmp43_ = _tmp42_;
			sym = _tmp43_;
			while (TRUE) {
				gboolean _tmp44_ = FALSE;
				ValaSymbol* _tmp45_;
				ValaSymbol* _tmp91_;
				const gchar* _tmp92_;
				ValaSymbol* _tmp93_;
				ValaSymbol* _tmp94_;
				gboolean _tmp95_ = FALSE;
				gboolean _tmp96_ = FALSE;
				gboolean _tmp133_ = FALSE;
				gboolean _tmp134_ = FALSE;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp136_;
				ValaSymbol* _tmp174_;
				ValaSymbol* _tmp175_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp178_;
				ValaSymbol* _tmp179_;
				_tmp45_ = sym;
				if (_tmp45_ != NULL) {
					ValaSymbol* _tmp46_;
					ValaSymbol* _tmp47_;
					_tmp46_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp47_ = _tmp46_;
					_tmp44_ = _tmp47_ == NULL;
				} else {
					_tmp44_ = FALSE;
				}
				if (!_tmp44_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp48_;
					_tmp48_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp48_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp49_;
						ValaCreationMethod* _tmp50_;
						ValaParameter* _tmp51_;
						ValaParameter* _tmp52_;
						_tmp49_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp50_ = cm;
						_tmp51_ = vala_method_get_this_parameter ((ValaMethod*) _tmp50_);
						_tmp52_ = _tmp51_;
						this_parameter = _tmp52_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp53_;
						_tmp53_ = sym;
						if (VALA_IS_PROPERTY (_tmp53_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp54_;
							ValaProperty* _tmp55_;
							ValaParameter* _tmp56_;
							ValaParameter* _tmp57_;
							ValaProperty* _tmp58_;
							ValaMemberBinding _tmp59_;
							ValaMemberBinding _tmp60_;
							ValaProperty* _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaMemberBinding _tmp63_;
							_tmp54_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp55_ = prop;
							_tmp56_ = vala_property_get_this_parameter (_tmp55_);
							_tmp57_ = _tmp56_;
							this_parameter = _tmp57_;
							_tmp58_ = prop;
							_tmp59_ = vala_property_get_binding (_tmp58_);
							_tmp60_ = _tmp59_;
							may_access_instance_members = _tmp60_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp61_ = prop;
							_tmp62_ = vala_property_get_binding (_tmp61_);
							_tmp63_ = _tmp62_;
							may_access_klass_members = _tmp63_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp64_;
							_tmp64_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp64_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp65_;
								ValaConstructor* _tmp66_;
								ValaParameter* _tmp67_;
								ValaParameter* _tmp68_;
								ValaConstructor* _tmp69_;
								ValaMemberBinding _tmp70_;
								ValaMemberBinding _tmp71_;
								_tmp65_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp66_ = c;
								_tmp67_ = vala_constructor_get_this_parameter (_tmp66_);
								_tmp68_ = _tmp67_;
								this_parameter = _tmp68_;
								_tmp69_ = c;
								_tmp70_ = vala_constructor_get_binding (_tmp69_);
								_tmp71_ = _tmp70_;
								may_access_instance_members = _tmp71_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp72_;
								_tmp72_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp72_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp73_;
									ValaDestructor* _tmp74_;
									ValaParameter* _tmp75_;
									ValaParameter* _tmp76_;
									ValaDestructor* _tmp77_;
									ValaMemberBinding _tmp78_;
									ValaMemberBinding _tmp79_;
									_tmp73_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp74_ = d;
									_tmp75_ = vala_destructor_get_this_parameter (_tmp74_);
									_tmp76_ = _tmp75_;
									this_parameter = _tmp76_;
									_tmp77_ = d;
									_tmp78_ = vala_destructor_get_binding (_tmp77_);
									_tmp79_ = _tmp78_;
									may_access_instance_members = _tmp79_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp80_;
									_tmp80_ = sym;
									if (VALA_IS_METHOD (_tmp80_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp81_;
										ValaMethod* _tmp82_;
										ValaParameter* _tmp83_;
										ValaParameter* _tmp84_;
										ValaMethod* _tmp85_;
										ValaMemberBinding _tmp86_;
										ValaMemberBinding _tmp87_;
										ValaMethod* _tmp88_;
										ValaMemberBinding _tmp89_;
										ValaMemberBinding _tmp90_;
										_tmp81_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, VALA_TYPE_METHOD, ValaMethod);
										_tmp82_ = m;
										_tmp83_ = vala_method_get_this_parameter (_tmp82_);
										_tmp84_ = _tmp83_;
										this_parameter = _tmp84_;
										_tmp85_ = m;
										_tmp86_ = vala_method_get_binding (_tmp85_);
										_tmp87_ = _tmp86_;
										may_access_instance_members = _tmp87_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp88_ = m;
										_tmp89_ = vala_method_get_binding (_tmp88_);
										_tmp90_ = _tmp89_;
										may_access_klass_members = _tmp90_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp91_ = sym;
				_tmp92_ = self->priv->_member_name;
				_tmp93_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp91_, _tmp92_);
				_tmp94_ = _tmp93_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp94_);
				_vala_code_node_unref0 (_tmp94_);
				if (!self->priv->is_with_variable_access) {
					ValaSymbol* _tmp97_;
					ValaSymbol* _tmp98_;
					_tmp97_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp98_ = _tmp97_;
					_tmp96_ = _tmp98_ == NULL;
				} else {
					_tmp96_ = FALSE;
				}
				if (_tmp96_) {
					ValaSymbol* _tmp99_;
					_tmp99_ = sym;
					_tmp95_ = VALA_IS_WITH_STATEMENT (_tmp99_);
				} else {
					_tmp95_ = FALSE;
				}
				if (_tmp95_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp100_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp101_;
					ValaLocalVariable* _tmp102_;
					ValaLocalVariable* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaDataType* _tmp106_;
					ValaDataType* _tmp107_;
					ValaArrayList* _tmp112_;
					ValaDataType* _tmp113_;
					ValaDataType* _tmp114_;
					const gchar* _tmp115_;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					ValaSymbol* _tmp118_;
					ValaSymbol* _tmp119_;
					_tmp100_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp101_ = w;
					_tmp102_ = vala_with_statement_get_with_variable (_tmp101_);
					_tmp103_ = _tmp102_;
					_tmp104_ = vala_variable_get_variable_type ((ValaVariable*) _tmp103_);
					_tmp105_ = _tmp104_;
					_tmp106_ = _vala_code_node_ref0 (_tmp105_);
					variable_type = _tmp106_;
					_tmp107_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp107_)) {
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaDataType* _tmp110_;
						ValaDataType* _tmp111_;
						_tmp108_ = variable_type;
						_tmp109_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp108_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp110_ = _tmp109_;
						_tmp111_ = _vala_code_node_ref0 (_tmp110_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp111_;
					}
					_tmp112_ = visited_types;
					_tmp113_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp112_, _tmp113_);
					_tmp114_ = variable_type;
					_tmp115_ = self->priv->_member_name;
					_tmp116_ = vala_data_type_get_member (_tmp114_, _tmp115_);
					_tmp117_ = _tmp116_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp117_);
					_vala_code_node_unref0 (_tmp117_);
					_tmp118_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp119_ = _tmp118_;
					if (_tmp119_ != NULL) {
						ValaWithStatement* _tmp120_;
						ValaLocalVariable* _tmp121_;
						ValaLocalVariable* _tmp122_;
						const gchar* _tmp123_;
						const gchar* _tmp124_;
						ValaSourceReference* _tmp125_;
						ValaSourceReference* _tmp126_;
						ValaMemberAccess* _tmp127_;
						ValaMemberAccess* _tmp128_;
						ValaExpression* _tmp129_;
						ValaExpression* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						_tmp120_ = w;
						_tmp121_ = vala_with_statement_get_with_variable (_tmp120_);
						_tmp122_ = _tmp121_;
						_tmp123_ = vala_symbol_get_name ((ValaSymbol*) _tmp122_);
						_tmp124_ = _tmp123_;
						_tmp125_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_member_access_new (NULL, _tmp124_, _tmp126_);
						_tmp128_ = _tmp127_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp128_);
						_vala_code_node_unref0 (_tmp128_);
						_tmp129_ = vala_member_access_get_inner (self);
						_tmp130_ = _tmp129_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp130_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess)->priv->is_with_variable_access = TRUE;
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						vala_code_node_check ((ValaCodeNode*) _tmp132_, context);
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp135_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp136_ = _tmp135_;
				if (_tmp136_ == NULL) {
					ValaSymbol* _tmp137_;
					_tmp137_ = sym;
					_tmp134_ = VALA_IS_TYPESYMBOL (_tmp137_);
				} else {
					_tmp134_ = FALSE;
				}
				if (_tmp134_) {
					_tmp133_ = may_access_instance_members;
				} else {
					_tmp133_ = FALSE;
				}
				if (_tmp133_) {
					ValaParameter* _tmp138_;
					ValaDataType* _tmp139_;
					ValaDataType* _tmp140_;
					const gchar* _tmp141_;
					ValaSymbol* _tmp142_;
					ValaSymbol* _tmp143_;
					gboolean _tmp144_ = FALSE;
					ValaSymbol* _tmp145_;
					ValaSymbol* _tmp146_;
					_tmp138_ = this_parameter;
					_tmp139_ = vala_variable_get_variable_type ((ValaVariable*) _tmp138_);
					_tmp140_ = _tmp139_;
					_tmp141_ = self->priv->_member_name;
					_tmp142_ = vala_data_type_get_member (_tmp140_, _tmp141_);
					_tmp143_ = _tmp142_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp143_);
					_vala_code_node_unref0 (_tmp143_);
					_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp146_ = _tmp145_;
					if (_tmp146_ != NULL) {
						ValaSymbol* _tmp147_;
						ValaSymbol* _tmp148_;
						_tmp147_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp148_ = _tmp147_;
						_tmp144_ = vala_member_access_is_instance_symbol (_tmp148_);
					} else {
						_tmp144_ = FALSE;
					}
					if (_tmp144_) {
						ValaSourceReference* _tmp149_;
						ValaSourceReference* _tmp150_;
						ValaMemberAccess* _tmp151_;
						ValaMemberAccess* _tmp152_;
						ValaExpression* _tmp153_;
						ValaExpression* _tmp154_;
						ValaParameter* _tmp155_;
						ValaDataType* _tmp156_;
						ValaDataType* _tmp157_;
						ValaDataType* _tmp158_;
						ValaDataType* _tmp159_;
						ValaExpression* _tmp160_;
						ValaExpression* _tmp161_;
						ValaDataType* _tmp162_;
						ValaDataType* _tmp163_;
						ValaExpression* _tmp164_;
						ValaExpression* _tmp165_;
						ValaParameter* _tmp166_;
						ValaExpression* _tmp167_;
						ValaExpression* _tmp168_;
						ValaDataType* _tmp169_;
						ValaDataType* _tmp170_;
						const gchar* _tmp171_;
						ValaSymbol* _tmp172_;
						ValaSymbol* _tmp173_;
						_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp150_ = _tmp149_;
						_tmp151_ = vala_member_access_new (NULL, "this", _tmp150_);
						_tmp152_ = _tmp151_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp152_);
						_vala_code_node_unref0 (_tmp152_);
						_tmp153_ = vala_member_access_get_inner (self);
						_tmp154_ = _tmp153_;
						_tmp155_ = this_parameter;
						_tmp156_ = vala_variable_get_variable_type ((ValaVariable*) _tmp155_);
						_tmp157_ = _tmp156_;
						_tmp158_ = vala_data_type_copy (_tmp157_);
						_tmp159_ = _tmp158_;
						vala_expression_set_value_type (_tmp154_, _tmp159_);
						_vala_code_node_unref0 (_tmp159_);
						_tmp160_ = vala_member_access_get_inner (self);
						_tmp161_ = _tmp160_;
						_tmp162_ = vala_expression_get_value_type (_tmp161_);
						_tmp163_ = _tmp162_;
						vala_data_type_set_value_owned (_tmp163_, FALSE);
						_tmp164_ = vala_member_access_get_inner (self);
						_tmp165_ = _tmp164_;
						_tmp166_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp165_, (ValaSymbol*) _tmp166_);
						_tmp167_ = vala_member_access_get_inner (self);
						_tmp168_ = _tmp167_;
						_tmp169_ = vala_expression_get_value_type (_tmp168_);
						_tmp170_ = _tmp169_;
						_tmp171_ = self->priv->_member_name;
						_tmp172_ = vala_data_type_get_member (_tmp170_, _tmp171_);
						_tmp173_ = _tmp172_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp173_);
						_vala_code_node_unref0 (_tmp173_);
					}
				}
				_tmp174_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp175_ = _tmp174_;
				if (_tmp175_ == NULL) {
					ValaSymbol* _tmp176_;
					_tmp176_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp176_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp177_ = sym;
				_tmp178_ = vala_symbol_get_parent_symbol (_tmp177_);
				_tmp179_ = _tmp178_;
				sym = _tmp179_;
			}
			_tmp181_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp182_ = _tmp181_;
			if (_tmp182_ == NULL) {
				ValaSourceReference* _tmp183_;
				ValaSourceReference* _tmp184_;
				_tmp183_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp184_ = _tmp183_;
				_tmp180_ = _tmp184_ != NULL;
			} else {
				_tmp180_ = FALSE;
			}
			if (_tmp180_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp185_;
					ValaSourceReference* _tmp186_;
					ValaList* _tmp187_;
					ValaList* _tmp188_;
					ValaList* _tmp189_;
					gint _ns_size = 0;
					ValaList* _tmp190_;
					gint _tmp191_;
					gint _tmp192_;
					gint _ns_index = 0;
					_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp186_ = _tmp185_;
					_tmp187_ = vala_source_reference_get_using_directives (_tmp186_);
					_tmp188_ = _tmp187_;
					_tmp189_ = _vala_iterable_ref0 (_tmp188_);
					_ns_list = _tmp189_;
					_tmp190_ = _ns_list;
					_tmp191_ = vala_collection_get_size ((ValaCollection*) _tmp190_);
					_tmp192_ = _tmp191_;
					_ns_size = _tmp192_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp193_;
						gint _tmp194_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp195_;
						gpointer _tmp196_;
						ValaUsingDirective* _tmp197_;
						gboolean _tmp198_;
						gboolean _tmp199_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp200_;
						ValaSymbol* _tmp201_;
						ValaSymbol* _tmp202_;
						ValaScope* _tmp203_;
						ValaScope* _tmp204_;
						const gchar* _tmp205_;
						ValaSymbol* _tmp206_;
						ValaSymbol* _tmp207_;
						_ns_index = _ns_index + 1;
						_tmp193_ = _ns_index;
						_tmp194_ = _ns_size;
						if (!(_tmp193_ < _tmp194_)) {
							break;
						}
						_tmp195_ = _ns_list;
						_tmp196_ = vala_list_get (_tmp195_, _ns_index);
						ns = (ValaUsingDirective*) _tmp196_;
						_tmp197_ = ns;
						_tmp198_ = vala_code_node_get_error ((ValaCodeNode*) _tmp197_);
						_tmp199_ = _tmp198_;
						if (_tmp199_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp200_ = ns;
						_tmp201_ = vala_using_directive_get_namespace_symbol (_tmp200_);
						_tmp202_ = _tmp201_;
						_tmp203_ = vala_symbol_get_scope (_tmp202_);
						_tmp204_ = _tmp203_;
						_tmp205_ = self->priv->_member_name;
						_tmp206_ = vala_scope_lookup (_tmp204_, _tmp205_);
						local_sym = _tmp206_;
						_tmp207_ = local_sym;
						if (_tmp207_ != NULL) {
							gboolean _tmp208_ = FALSE;
							ValaSymbol* _tmp209_;
							ValaSymbol* _tmp210_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp226_;
							ValaSymbol* _tmp227_;
							ValaSymbol* _tmp228_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp248_;
							ValaExpression* _tmp249_;
							ValaExpression* _tmp250_;
							ValaSymbol* _tmp251_;
							_tmp209_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp210_ = _tmp209_;
							if (_tmp210_ != NULL) {
								ValaSymbol* _tmp211_;
								ValaSymbol* _tmp212_;
								ValaSymbol* _tmp213_;
								_tmp211_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp212_ = _tmp211_;
								_tmp213_ = local_sym;
								_tmp208_ = _tmp212_ != _tmp213_;
							} else {
								_tmp208_ = FALSE;
							}
							if (_tmp208_) {
								ValaSourceReference* _tmp214_;
								ValaSourceReference* _tmp215_;
								const gchar* _tmp216_;
								ValaSymbol* _tmp217_;
								ValaSymbol* _tmp218_;
								gchar* _tmp219_;
								gchar* _tmp220_;
								ValaSymbol* _tmp221_;
								gchar* _tmp222_;
								gchar* _tmp223_;
								gchar* _tmp224_;
								gchar* _tmp225_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp215_ = _tmp214_;
								_tmp216_ = self->priv->_member_name;
								_tmp217_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp218_ = _tmp217_;
								_tmp219_ = vala_symbol_get_full_name (_tmp218_);
								_tmp220_ = _tmp219_;
								_tmp221_ = local_sym;
								_tmp222_ = vala_symbol_get_full_name (_tmp221_);
								_tmp223_ = _tmp222_;
								_tmp224_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp216_, _tmp220_, _tmp223_);
								_tmp225_ = _tmp224_;
								vala_report_error (_tmp215_, _tmp225_);
								_g_free0 (_tmp225_);
								_g_free0 (_tmp223_);
								_g_free0 (_tmp220_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp226_ = local_sym;
							_tmp227_ = vala_symbol_get_parent_symbol (_tmp226_);
							_tmp228_ = _tmp227_;
							inner_sym = _tmp228_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp229_ = FALSE;
								ValaSymbol* _tmp230_;
								ValaMemberAccess* _tmp234_;
								ValaSymbol* _tmp235_;
								const gchar* _tmp236_;
								const gchar* _tmp237_;
								ValaSourceReference* _tmp238_;
								ValaSourceReference* _tmp239_;
								ValaMemberAccess* _tmp240_;
								ValaMemberAccess* _tmp241_;
								ValaMemberAccess* _tmp242_;
								ValaExpression* _tmp243_;
								ValaExpression* _tmp244_;
								ValaSymbol* _tmp245_;
								ValaSymbol* _tmp246_;
								ValaSymbol* _tmp247_;
								_tmp230_ = inner_sym;
								if (_tmp230_ != NULL) {
									ValaSymbol* _tmp231_;
									const gchar* _tmp232_;
									const gchar* _tmp233_;
									_tmp231_ = inner_sym;
									_tmp232_ = vala_symbol_get_name (_tmp231_);
									_tmp233_ = _tmp232_;
									_tmp229_ = _tmp233_ != NULL;
								} else {
									_tmp229_ = FALSE;
								}
								if (!_tmp229_) {
									break;
								}
								_tmp234_ = inner_ma;
								_tmp235_ = inner_sym;
								_tmp236_ = vala_symbol_get_name (_tmp235_);
								_tmp237_ = _tmp236_;
								_tmp238_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp239_ = _tmp238_;
								_tmp240_ = vala_member_access_new (NULL, _tmp237_, _tmp239_);
								_tmp241_ = _tmp240_;
								vala_member_access_set_inner (_tmp234_, (ValaExpression*) _tmp241_);
								_vala_code_node_unref0 (_tmp241_);
								_tmp242_ = inner_ma;
								_tmp243_ = vala_member_access_get_inner (_tmp242_);
								_tmp244_ = _tmp243_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp244_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp245_ = inner_sym;
								_tmp246_ = vala_symbol_get_parent_symbol (_tmp245_);
								_tmp247_ = _tmp246_;
								inner_sym = _tmp247_;
							}
							_tmp248_ = inner_ma;
							vala_member_access_set_qualified (_tmp248_, TRUE);
							_tmp249_ = vala_member_access_get_inner (self);
							_tmp250_ = _tmp249_;
							vala_code_node_check ((ValaCodeNode*) _tmp250_, context);
							_tmp251_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp251_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
		} else {
			ValaExpression* _tmp252_;
			ValaExpression* _tmp253_;
			gboolean _tmp254_;
			gboolean _tmp255_;
			ValaExpression* _tmp256_;
			ValaExpression* _tmp257_;
			ValaDataType* _tmp258_;
			ValaDataType* _tmp259_;
			ValaExpression* _tmp277_;
			ValaExpression* _tmp278_;
			gboolean _tmp293_ = FALSE;
			ValaExpression* _tmp294_;
			ValaExpression* _tmp295_;
			gboolean _tmp302_ = FALSE;
			ValaExpression* _tmp303_;
			ValaExpression* _tmp304_;
			gboolean _tmp325_ = FALSE;
			ValaExpression* _tmp326_;
			ValaExpression* _tmp327_;
			gboolean _tmp346_ = FALSE;
			ValaSymbol* _tmp347_;
			ValaSymbol* _tmp348_;
			gboolean _tmp382_ = FALSE;
			gboolean _tmp383_ = FALSE;
			ValaSymbol* _tmp384_;
			ValaSymbol* _tmp385_;
			gboolean _tmp617_ = FALSE;
			ValaSymbol* _tmp618_;
			ValaSymbol* _tmp619_;
			_tmp252_ = vala_member_access_get_inner (self);
			_tmp253_ = _tmp252_;
			_tmp254_ = vala_code_node_get_error ((ValaCodeNode*) _tmp253_);
			_tmp255_ = _tmp254_;
			if (_tmp255_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp256_ = vala_member_access_get_inner (self);
			_tmp257_ = _tmp256_;
			_tmp258_ = vala_expression_get_value_type (_tmp257_);
			_tmp259_ = _tmp258_;
			if (VALA_IS_POINTER_TYPE (_tmp259_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp260_;
				ValaExpression* _tmp261_;
				ValaDataType* _tmp262_;
				ValaDataType* _tmp263_;
				gboolean _tmp264_ = FALSE;
				ValaPointerType* _tmp265_;
				_tmp260_ = vala_member_access_get_inner (self);
				_tmp261_ = _tmp260_;
				_tmp262_ = vala_expression_get_value_type (_tmp261_);
				_tmp263_ = _tmp262_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp263_) ? ((ValaPointerType*) _tmp263_) : NULL;
				_tmp265_ = pointer_type;
				if (_tmp265_ != NULL) {
					ValaPointerType* _tmp266_;
					ValaDataType* _tmp267_;
					ValaDataType* _tmp268_;
					_tmp266_ = pointer_type;
					_tmp267_ = vala_pointer_type_get_base_type (_tmp266_);
					_tmp268_ = _tmp267_;
					_tmp264_ = VALA_IS_VALUE_TYPE (_tmp268_);
				} else {
					_tmp264_ = FALSE;
				}
				if (_tmp264_) {
					ValaExpression* _tmp269_;
					ValaExpression* _tmp270_;
					ValaSourceReference* _tmp271_;
					ValaSourceReference* _tmp272_;
					ValaPointerIndirection* _tmp273_;
					ValaPointerIndirection* _tmp274_;
					ValaExpression* _tmp275_;
					ValaExpression* _tmp276_;
					_tmp269_ = vala_member_access_get_inner (self);
					_tmp270_ = _tmp269_;
					_tmp271_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp272_ = _tmp271_;
					_tmp273_ = vala_pointer_indirection_new (_tmp270_, _tmp272_);
					_tmp274_ = _tmp273_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp274_);
					_vala_code_node_unref0 (_tmp274_);
					_tmp275_ = vala_member_access_get_inner (self);
					_tmp276_ = _tmp275_;
					vala_code_node_check ((ValaCodeNode*) _tmp276_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp277_ = vala_member_access_get_inner (self);
			_tmp278_ = _tmp277_;
			if (VALA_IS_MEMBER_ACCESS (_tmp278_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp279_;
				ValaExpression* _tmp280_;
				ValaMemberAccess* _tmp281_;
				gboolean _tmp282_;
				_tmp279_ = vala_member_access_get_inner (self);
				_tmp280_ = _tmp279_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp280_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp281_ = ma;
				_tmp282_ = _tmp281_->priv->_prototype_access;
				if (_tmp282_) {
					ValaSourceReference* _tmp283_;
					ValaSourceReference* _tmp284_;
					ValaExpression* _tmp285_;
					ValaExpression* _tmp286_;
					ValaSymbol* _tmp287_;
					ValaSymbol* _tmp288_;
					gchar* _tmp289_;
					gchar* _tmp290_;
					gchar* _tmp291_;
					gchar* _tmp292_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp283_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp284_ = _tmp283_;
					_tmp285_ = vala_member_access_get_inner (self);
					_tmp286_ = _tmp285_;
					_tmp287_ = vala_expression_get_symbol_reference (_tmp286_);
					_tmp288_ = _tmp287_;
					_tmp289_ = vala_symbol_get_full_name (_tmp288_);
					_tmp290_ = _tmp289_;
					_tmp291_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp290_);
					_tmp292_ = _tmp291_;
					vala_report_error (_tmp284_, _tmp292_);
					_g_free0 (_tmp292_);
					_g_free0 (_tmp290_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp294_ = vala_member_access_get_inner (self);
			_tmp295_ = _tmp294_;
			if (VALA_IS_CAST_EXPRESSION (_tmp295_)) {
				ValaExpression* _tmp296_;
				ValaExpression* _tmp297_;
				gboolean _tmp298_;
				gboolean _tmp299_;
				_tmp296_ = vala_member_access_get_inner (self);
				_tmp297_ = _tmp296_;
				_tmp298_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp297_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp299_ = _tmp298_;
				_tmp293_ = _tmp299_;
			} else {
				_tmp293_ = FALSE;
			}
			if (_tmp293_) {
				ValaSourceReference* _tmp300_;
				ValaSourceReference* _tmp301_;
				_tmp300_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp301_ = _tmp300_;
				vala_report_warning (_tmp301_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp303_ = vala_member_access_get_inner (self);
			_tmp304_ = _tmp303_;
			if (VALA_IS_MEMBER_ACCESS (_tmp304_)) {
				_tmp302_ = TRUE;
			} else {
				ValaExpression* _tmp305_;
				ValaExpression* _tmp306_;
				_tmp305_ = vala_member_access_get_inner (self);
				_tmp306_ = _tmp305_;
				_tmp302_ = VALA_IS_BASE_ACCESS (_tmp306_);
			}
			if (_tmp302_) {
				ValaExpression* _tmp307_;
				ValaExpression* _tmp308_;
				ValaSymbol* _tmp309_;
				ValaSymbol* _tmp310_;
				gboolean _tmp311_ = FALSE;
				ValaSymbol* _tmp312_;
				ValaSymbol* _tmp313_;
				_tmp307_ = vala_member_access_get_inner (self);
				_tmp308_ = _tmp307_;
				_tmp309_ = vala_expression_get_symbol_reference (_tmp308_);
				_tmp310_ = _tmp309_;
				base_symbol = _tmp310_;
				_tmp312_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp313_ = _tmp312_;
				if (_tmp313_ == NULL) {
					gboolean _tmp314_ = FALSE;
					ValaSymbol* _tmp315_;
					_tmp315_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp315_)) {
						_tmp314_ = TRUE;
					} else {
						ValaSymbol* _tmp316_;
						_tmp316_ = base_symbol;
						_tmp314_ = VALA_IS_TYPESYMBOL (_tmp316_);
					}
					_tmp311_ = _tmp314_;
				} else {
					_tmp311_ = FALSE;
				}
				if (_tmp311_) {
					ValaSymbol* _tmp317_;
					ValaScope* _tmp318_;
					ValaScope* _tmp319_;
					const gchar* _tmp320_;
					ValaSymbol* _tmp321_;
					ValaSymbol* _tmp322_;
					ValaExpression* _tmp323_;
					ValaExpression* _tmp324_;
					_tmp317_ = base_symbol;
					_tmp318_ = vala_symbol_get_scope (_tmp317_);
					_tmp319_ = _tmp318_;
					_tmp320_ = self->priv->_member_name;
					_tmp321_ = vala_scope_lookup (_tmp319_, _tmp320_);
					_tmp322_ = _tmp321_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp322_);
					_vala_code_node_unref0 (_tmp322_);
					_tmp323_ = vala_member_access_get_inner (self);
					_tmp324_ = _tmp323_;
					if (VALA_IS_BASE_ACCESS (_tmp324_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp326_ = vala_member_access_get_inner (self);
			_tmp327_ = _tmp326_;
			if (VALA_IS_MEMBER_ACCESS (_tmp327_)) {
				ValaExpression* _tmp328_;
				ValaExpression* _tmp329_;
				ValaSymbol* _tmp330_;
				ValaSymbol* _tmp331_;
				_tmp328_ = vala_member_access_get_inner (self);
				_tmp329_ = _tmp328_;
				_tmp330_ = vala_expression_get_symbol_reference (_tmp329_);
				_tmp331_ = _tmp330_;
				_tmp325_ = VALA_IS_TYPEPARAMETER (_tmp331_);
			} else {
				_tmp325_ = FALSE;
			}
			if (_tmp325_) {
				ValaExpression* _tmp332_;
				ValaExpression* _tmp333_;
				ValaExpression* _tmp334_;
				ValaExpression* _tmp335_;
				ValaSymbol* _tmp336_;
				ValaSymbol* _tmp337_;
				ValaGenericType* _tmp338_;
				ValaGenericType* _tmp339_;
				ValaExpression* _tmp340_;
				ValaExpression* _tmp341_;
				ValaDataType* _tmp342_;
				ValaDataType* _tmp343_;
				ValaSourceReference* _tmp344_;
				ValaSourceReference* _tmp345_;
				_tmp332_ = vala_member_access_get_inner (self);
				_tmp333_ = _tmp332_;
				_tmp334_ = vala_member_access_get_inner (self);
				_tmp335_ = _tmp334_;
				_tmp336_ = vala_expression_get_symbol_reference (_tmp335_);
				_tmp337_ = _tmp336_;
				_tmp338_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp337_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp339_ = _tmp338_;
				vala_expression_set_value_type (_tmp333_, (ValaDataType*) _tmp339_);
				_vala_code_node_unref0 (_tmp339_);
				_tmp340_ = vala_member_access_get_inner (self);
				_tmp341_ = _tmp340_;
				_tmp342_ = vala_expression_get_value_type (_tmp341_);
				_tmp343_ = _tmp342_;
				_tmp344_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp345_ = _tmp344_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp343_, _tmp345_);
			}
			_tmp347_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp348_ = _tmp347_;
			if (_tmp348_ == NULL) {
				ValaExpression* _tmp349_;
				ValaExpression* _tmp350_;
				ValaDataType* _tmp351_;
				ValaDataType* _tmp352_;
				_tmp349_ = vala_member_access_get_inner (self);
				_tmp350_ = _tmp349_;
				_tmp351_ = vala_expression_get_value_type (_tmp350_);
				_tmp352_ = _tmp351_;
				_tmp346_ = _tmp352_ != NULL;
			} else {
				_tmp346_ = FALSE;
			}
			if (_tmp346_) {
				gboolean _tmp353_;
				ValaSymbol* _tmp380_;
				ValaSymbol* _tmp381_;
				_tmp353_ = self->priv->_pointer_member_access;
				if (_tmp353_) {
					ValaExpression* _tmp354_;
					ValaExpression* _tmp355_;
					ValaDataType* _tmp356_;
					ValaDataType* _tmp357_;
					const gchar* _tmp358_;
					ValaSymbol* _tmp359_;
					ValaSymbol* _tmp360_;
					_tmp354_ = vala_member_access_get_inner (self);
					_tmp355_ = _tmp354_;
					_tmp356_ = vala_expression_get_value_type (_tmp355_);
					_tmp357_ = _tmp356_;
					_tmp358_ = self->priv->_member_name;
					_tmp359_ = vala_data_type_get_pointer_member (_tmp357_, _tmp358_);
					_tmp360_ = _tmp359_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp360_);
					_vala_code_node_unref0 (_tmp360_);
				} else {
					ValaExpression* _tmp361_;
					ValaExpression* _tmp362_;
					ValaDataType* _tmp363_;
					ValaDataType* _tmp364_;
					ValaTypeSymbol* _tmp365_;
					ValaTypeSymbol* _tmp366_;
					ValaExpression* _tmp373_;
					ValaExpression* _tmp374_;
					ValaDataType* _tmp375_;
					ValaDataType* _tmp376_;
					const gchar* _tmp377_;
					ValaSymbol* _tmp378_;
					ValaSymbol* _tmp379_;
					_tmp361_ = vala_member_access_get_inner (self);
					_tmp362_ = _tmp361_;
					_tmp363_ = vala_expression_get_value_type (_tmp362_);
					_tmp364_ = _tmp363_;
					_tmp365_ = vala_data_type_get_type_symbol (_tmp364_);
					_tmp366_ = _tmp365_;
					if (_tmp366_ != NULL) {
						ValaExpression* _tmp367_;
						ValaExpression* _tmp368_;
						ValaDataType* _tmp369_;
						ValaDataType* _tmp370_;
						ValaTypeSymbol* _tmp371_;
						ValaTypeSymbol* _tmp372_;
						_tmp367_ = vala_member_access_get_inner (self);
						_tmp368_ = _tmp367_;
						_tmp369_ = vala_expression_get_value_type (_tmp368_);
						_tmp370_ = _tmp369_;
						_tmp371_ = vala_data_type_get_type_symbol (_tmp370_);
						_tmp372_ = _tmp371_;
						base_symbol = (ValaSymbol*) _tmp372_;
					}
					_tmp373_ = vala_member_access_get_inner (self);
					_tmp374_ = _tmp373_;
					_tmp375_ = vala_expression_get_value_type (_tmp374_);
					_tmp376_ = _tmp375_;
					_tmp377_ = self->priv->_member_name;
					_tmp378_ = vala_data_type_get_member (_tmp376_, _tmp377_);
					_tmp379_ = _tmp378_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp379_);
					_vala_code_node_unref0 (_tmp379_);
				}
				_tmp380_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp381_ = _tmp380_;
				if (_tmp381_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp384_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp385_ = _tmp384_;
			if (_tmp385_ == NULL) {
				ValaExpression* _tmp386_;
				ValaExpression* _tmp387_;
				ValaDataType* _tmp388_;
				ValaDataType* _tmp389_;
				_tmp386_ = vala_member_access_get_inner (self);
				_tmp387_ = _tmp386_;
				_tmp388_ = vala_expression_get_value_type (_tmp387_);
				_tmp389_ = _tmp388_;
				_tmp383_ = _tmp389_ != NULL;
			} else {
				_tmp383_ = FALSE;
			}
			if (_tmp383_) {
				ValaExpression* _tmp390_;
				ValaExpression* _tmp391_;
				ValaDataType* _tmp392_;
				ValaDataType* _tmp393_;
				gboolean _tmp394_;
				gboolean _tmp395_;
				_tmp390_ = vala_member_access_get_inner (self);
				_tmp391_ = _tmp390_;
				_tmp392_ = vala_expression_get_value_type (_tmp391_);
				_tmp393_ = _tmp392_;
				_tmp394_ = vala_data_type_get_is_dynamic (_tmp393_);
				_tmp395_ = _tmp394_;
				_tmp382_ = _tmp395_;
			} else {
				_tmp382_ = FALSE;
			}
			if (_tmp382_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp396_;
				ValaExpression* _tmp397_;
				ValaDataType* _tmp398_;
				ValaDataType* _tmp399_;
				ValaObjectType* _tmp400_;
				ValaCodeNode* _tmp401_;
				ValaCodeNode* _tmp402_;
				ValaSymbol* _tmp565_;
				ValaSymbol* _tmp566_;
				ValaSymbol* _tmp615_;
				ValaSymbol* _tmp616_;
				_tmp396_ = vala_member_access_get_inner (self);
				_tmp397_ = _tmp396_;
				_tmp398_ = vala_expression_get_value_type (_tmp397_);
				_tmp399_ = _tmp398_;
				_tmp400_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp399_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp400_;
				_tmp401_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp402_ = _tmp401_;
				if (VALA_IS_METHOD_CALL (_tmp402_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp403_;
					ValaCodeNode* _tmp404_;
					ValaMethodCall* _tmp405_;
					ValaExpression* _tmp406_;
					ValaExpression* _tmp407_;
					_tmp403_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp404_ = _tmp403_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp404_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp405_ = invoc;
					_tmp406_ = vala_method_call_get_call (_tmp405_);
					_tmp407_ = _tmp406_;
					if (_tmp407_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp408_;
						ValaDataType* _tmp409_;
						ValaDataType* _tmp410_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp425_;
						ValaExpression* _tmp426_;
						ValaDataType* _tmp427_;
						ValaDataType* _tmp428_;
						const gchar* _tmp429_;
						ValaDataType* _tmp430_;
						ValaSourceReference* _tmp431_;
						ValaSourceReference* _tmp432_;
						ValaDynamicMethod* _tmp433_;
						ValaDynamicMethod* _tmp434_;
						ValaMethodCall* _tmp435_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp436_;
						ValaErrorType* _tmp437_;
						ValaDynamicMethod* _tmp438_;
						ValaErrorType* _tmp439_;
						ValaDynamicMethod* _tmp440_;
						ValaDynamicMethod* _tmp441_;
						ValaParameter* _tmp442_;
						ValaParameter* _tmp443_;
						ValaDynamicMethod* _tmp444_;
						ValaObjectType* _tmp445_;
						ValaDataType* _tmp446_;
						ValaDataType* _tmp447_;
						ValaParameter* _tmp448_;
						ValaParameter* _tmp449_;
						ValaObjectType* _tmp450_;
						ValaTypeSymbol* _tmp451_;
						ValaTypeSymbol* _tmp452_;
						ValaScope* _tmp453_;
						ValaScope* _tmp454_;
						ValaDynamicMethod* _tmp455_;
						ValaDynamicMethod* _tmp456_;
						_tmp408_ = invoc;
						_tmp409_ = vala_expression_get_target_type ((ValaExpression*) _tmp408_);
						_tmp410_ = _tmp409_;
						if (_tmp410_ != NULL) {
							ValaMethodCall* _tmp411_;
							ValaDataType* _tmp412_;
							ValaDataType* _tmp413_;
							ValaDataType* _tmp414_;
							ValaDataType* _tmp415_;
							_tmp411_ = invoc;
							_tmp412_ = vala_expression_get_target_type ((ValaExpression*) _tmp411_);
							_tmp413_ = _tmp412_;
							_tmp414_ = vala_data_type_copy (_tmp413_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp414_;
							_tmp415_ = ret_type;
							vala_data_type_set_value_owned (_tmp415_, TRUE);
						} else {
							ValaMethodCall* _tmp416_;
							ValaCodeNode* _tmp417_;
							ValaCodeNode* _tmp418_;
							_tmp416_ = invoc;
							_tmp417_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp416_);
							_tmp418_ = _tmp417_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp418_)) {
								ValaVoidType* _tmp419_;
								_tmp419_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp419_;
							} else {
								ValaExpression* _tmp420_;
								ValaExpression* _tmp421_;
								ValaDataType* _tmp422_;
								ValaDataType* _tmp423_;
								ValaDataType* _tmp424_;
								_tmp420_ = vala_member_access_get_inner (self);
								_tmp421_ = _tmp420_;
								_tmp422_ = vala_expression_get_value_type (_tmp421_);
								_tmp423_ = _tmp422_;
								_tmp424_ = vala_data_type_copy (_tmp423_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp424_;
							}
						}
						_tmp425_ = vala_member_access_get_inner (self);
						_tmp426_ = _tmp425_;
						_tmp427_ = vala_expression_get_value_type (_tmp426_);
						_tmp428_ = _tmp427_;
						_tmp429_ = self->priv->_member_name;
						_tmp430_ = ret_type;
						_tmp431_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp432_ = _tmp431_;
						_tmp433_ = vala_dynamic_method_new (_tmp428_, _tmp429_, _tmp430_, _tmp432_, NULL);
						m = _tmp433_;
						_tmp434_ = m;
						_tmp435_ = invoc;
						vala_dynamic_method_set_invocation (_tmp434_, _tmp435_);
						_tmp436_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp436_;
						_tmp437_ = err;
						vala_error_type_set_dynamic_error (_tmp437_, TRUE);
						_tmp438_ = m;
						_tmp439_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp438_, (ValaDataType*) _tmp439_);
						_tmp440_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp440_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp441_ = m;
						_tmp442_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp443_ = _tmp442_;
						vala_callable_add_parameter ((ValaCallable*) _tmp441_, _tmp443_);
						_vala_code_node_unref0 (_tmp443_);
						_tmp444_ = m;
						_tmp445_ = dynamic_object_type;
						_tmp446_ = vala_data_type_copy ((ValaDataType*) _tmp445_);
						_tmp447_ = _tmp446_;
						_tmp448_ = vala_parameter_new ("this", _tmp447_, NULL);
						_tmp449_ = _tmp448_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp444_, _tmp449_);
						_vala_code_node_unref0 (_tmp449_);
						_vala_code_node_unref0 (_tmp447_);
						_tmp450_ = dynamic_object_type;
						_tmp451_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp450_);
						_tmp452_ = _tmp451_;
						_tmp453_ = vala_symbol_get_scope ((ValaSymbol*) _tmp452_);
						_tmp454_ = _tmp453_;
						_tmp455_ = m;
						vala_scope_add (_tmp454_, NULL, (ValaSymbol*) _tmp455_);
						_tmp456_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp456_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp457_;
					ValaCodeNode* _tmp458_;
					_tmp457_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp458_ = _tmp457_;
					if (VALA_IS_ASSIGNMENT (_tmp458_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp459_;
						ValaCodeNode* _tmp460_;
						ValaAssignment* _tmp461_;
						ValaExpression* _tmp462_;
						ValaExpression* _tmp463_;
						_tmp459_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp460_ = _tmp459_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp460_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp461_ = a;
						_tmp462_ = vala_assignment_get_left (_tmp461_);
						_tmp463_ = _tmp462_;
						if (_tmp463_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp464_;
							ValaExpression* _tmp465_;
							ValaDataType* _tmp466_;
							ValaDataType* _tmp467_;
							const gchar* _tmp468_;
							ValaSourceReference* _tmp469_;
							ValaSourceReference* _tmp470_;
							ValaDynamicProperty* _tmp471_;
							ValaDynamicProperty* _tmp472_;
							ValaDynamicProperty* _tmp473_;
							ValaDynamicProperty* _tmp474_;
							ValaSourceReference* _tmp475_;
							ValaSourceReference* _tmp476_;
							ValaPropertyAccessor* _tmp477_;
							ValaPropertyAccessor* _tmp478_;
							ValaDynamicProperty* _tmp479_;
							ValaExpression* _tmp480_;
							ValaExpression* _tmp481_;
							ValaDataType* _tmp482_;
							ValaDataType* _tmp483_;
							ValaTypeSymbol* _tmp484_;
							ValaTypeSymbol* _tmp485_;
							ValaScope* _tmp486_;
							ValaScope* _tmp487_;
							ValaObjectType* _tmp488_;
							ValaTypeSymbol* _tmp489_;
							ValaTypeSymbol* _tmp490_;
							ValaScope* _tmp491_;
							ValaScope* _tmp492_;
							ValaDynamicProperty* _tmp493_;
							ValaDynamicProperty* _tmp494_;
							_tmp464_ = vala_member_access_get_inner (self);
							_tmp465_ = _tmp464_;
							_tmp466_ = vala_expression_get_value_type (_tmp465_);
							_tmp467_ = _tmp466_;
							_tmp468_ = self->priv->_member_name;
							_tmp469_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp470_ = _tmp469_;
							_tmp471_ = vala_dynamic_property_new (_tmp467_, _tmp468_, _tmp470_, NULL);
							prop = _tmp471_;
							_tmp472_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp472_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp473_ = prop;
							_tmp474_ = prop;
							_tmp475_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp474_);
							_tmp476_ = _tmp475_;
							_tmp477_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp476_, NULL);
							_tmp478_ = _tmp477_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp473_, _tmp478_);
							_vala_code_node_unref0 (_tmp478_);
							_tmp479_ = prop;
							_tmp480_ = vala_member_access_get_inner (self);
							_tmp481_ = _tmp480_;
							_tmp482_ = vala_expression_get_value_type (_tmp481_);
							_tmp483_ = _tmp482_;
							_tmp484_ = vala_data_type_get_type_symbol (_tmp483_);
							_tmp485_ = _tmp484_;
							_tmp486_ = vala_symbol_get_scope ((ValaSymbol*) _tmp485_);
							_tmp487_ = _tmp486_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp479_, _tmp487_);
							_tmp488_ = dynamic_object_type;
							_tmp489_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp488_);
							_tmp490_ = _tmp489_;
							_tmp491_ = vala_symbol_get_scope ((ValaSymbol*) _tmp490_);
							_tmp492_ = _tmp491_;
							_tmp493_ = prop;
							vala_scope_add (_tmp492_, NULL, (ValaSymbol*) _tmp493_);
							_tmp494_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp494_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp495_ = FALSE;
						gboolean _tmp496_ = FALSE;
						ValaCodeNode* _tmp497_;
						ValaCodeNode* _tmp498_;
						_tmp497_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp498_ = _tmp497_;
						if (VALA_IS_MEMBER_ACCESS (_tmp498_)) {
							ValaExpression* _tmp499_;
							ValaExpression* _tmp500_;
							_tmp499_ = vala_member_access_get_inner (self);
							_tmp500_ = _tmp499_;
							_tmp496_ = VALA_IS_MEMBER_ACCESS (_tmp500_);
						} else {
							_tmp496_ = FALSE;
						}
						if (_tmp496_) {
							ValaCodeNode* _tmp501_;
							ValaCodeNode* _tmp502_;
							ValaCodeNode* _tmp503_;
							ValaCodeNode* _tmp504_;
							_tmp501_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp502_ = _tmp501_;
							_tmp503_ = vala_code_node_get_parent_node (_tmp502_);
							_tmp504_ = _tmp503_;
							_tmp495_ = VALA_IS_METHOD_CALL (_tmp504_);
						} else {
							_tmp495_ = FALSE;
						}
						if (_tmp495_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp505_;
							ValaCodeNode* _tmp506_;
							gboolean _tmp507_ = FALSE;
							ValaMemberAccess* _tmp508_;
							const gchar* _tmp509_;
							_tmp505_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp506_ = _tmp505_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp506_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp508_ = ma;
							_tmp509_ = _tmp508_->priv->_member_name;
							if (g_strcmp0 (_tmp509_, "connect") == 0) {
								_tmp507_ = TRUE;
							} else {
								ValaMemberAccess* _tmp510_;
								const gchar* _tmp511_;
								_tmp510_ = ma;
								_tmp511_ = _tmp510_->priv->_member_name;
								_tmp507_ = g_strcmp0 (_tmp511_, "connect_after") == 0;
							}
							if (_tmp507_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp512_;
								ValaExpression* _tmp513_;
								ValaDataType* _tmp514_;
								ValaDataType* _tmp515_;
								const gchar* _tmp516_;
								ValaVoidType* _tmp517_;
								ValaVoidType* _tmp518_;
								ValaSourceReference* _tmp519_;
								ValaSourceReference* _tmp520_;
								ValaDynamicSignal* _tmp521_;
								ValaDynamicSignal* _tmp522_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp523_;
								ValaCodeNode* _tmp524_;
								ValaCodeNode* _tmp525_;
								ValaCodeNode* _tmp526_;
								ValaMethodCall* _tmp527_;
								ValaMethodCall* _tmp528_;
								ValaList* _tmp529_;
								gint _tmp530_;
								gint _tmp531_;
								ValaDynamicSignal* _tmp557_;
								ValaObjectType* _tmp558_;
								ValaTypeSymbol* _tmp559_;
								ValaTypeSymbol* _tmp560_;
								ValaScope* _tmp561_;
								ValaScope* _tmp562_;
								ValaDynamicSignal* _tmp563_;
								ValaDynamicSignal* _tmp564_;
								_tmp512_ = vala_member_access_get_inner (self);
								_tmp513_ = _tmp512_;
								_tmp514_ = vala_expression_get_value_type (_tmp513_);
								_tmp515_ = _tmp514_;
								_tmp516_ = self->priv->_member_name;
								_tmp517_ = vala_void_type_new (NULL);
								_tmp518_ = _tmp517_;
								_tmp519_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp520_ = _tmp519_;
								_tmp521_ = vala_dynamic_signal_new (_tmp515_, _tmp516_, (ValaDataType*) _tmp518_, _tmp520_, NULL);
								_tmp522_ = _tmp521_;
								_vala_code_node_unref0 (_tmp518_);
								s = _tmp522_;
								_tmp523_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp524_ = _tmp523_;
								_tmp525_ = vala_code_node_get_parent_node (_tmp524_);
								_tmp526_ = _tmp525_;
								_tmp527_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp526_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp527_;
								_tmp528_ = mcall;
								_tmp529_ = vala_method_call_get_argument_list (_tmp528_);
								_tmp530_ = vala_collection_get_size ((ValaCollection*) _tmp529_);
								_tmp531_ = _tmp530_;
								if (_tmp531_ > 0) {
									ValaDynamicSignal* _tmp532_;
									ValaMethodCall* _tmp533_;
									ValaList* _tmp534_;
									gpointer _tmp535_;
									ValaExpression* _tmp536_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp537_;
									ValaExpression* _tmp538_;
									ValaExpression* _tmp539_;
									gboolean _tmp540_ = FALSE;
									gboolean _tmp541_ = FALSE;
									ValaMemberAccess* _tmp542_;
									_tmp532_ = s;
									_tmp533_ = mcall;
									_tmp534_ = vala_method_call_get_argument_list (_tmp533_);
									_tmp535_ = vala_list_get (_tmp534_, 0);
									_tmp536_ = (ValaExpression*) _tmp535_;
									vala_dynamic_signal_set_handler (_tmp532_, _tmp536_);
									_vala_code_node_unref0 (_tmp536_);
									_tmp537_ = s;
									_tmp538_ = vala_dynamic_signal_get_handler (_tmp537_);
									_tmp539_ = _tmp538_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp539_) ? ((ValaMemberAccess*) _tmp539_) : NULL;
									_tmp542_ = arg;
									if (_tmp542_ == NULL) {
										_tmp541_ = TRUE;
									} else {
										ValaMemberAccess* _tmp543_;
										_tmp543_ = arg;
										_tmp541_ = !vala_code_node_check ((ValaCodeNode*) _tmp543_, context);
									}
									if (_tmp541_) {
										_tmp540_ = TRUE;
									} else {
										ValaMemberAccess* _tmp544_;
										ValaSymbol* _tmp545_;
										ValaSymbol* _tmp546_;
										_tmp544_ = arg;
										_tmp545_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp544_);
										_tmp546_ = _tmp545_;
										_tmp540_ = !VALA_IS_METHOD (_tmp546_);
									}
									if (_tmp540_) {
										ValaDynamicSignal* _tmp547_;
										ValaExpression* _tmp548_;
										ValaExpression* _tmp549_;
										ValaSourceReference* _tmp550_;
										ValaSourceReference* _tmp551_;
										ValaDynamicSignal* _tmp552_;
										gchar* _tmp553_;
										gchar* _tmp554_;
										gchar* _tmp555_;
										gchar* _tmp556_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp547_ = s;
										_tmp548_ = vala_dynamic_signal_get_handler (_tmp547_);
										_tmp549_ = _tmp548_;
										_tmp550_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp549_);
										_tmp551_ = _tmp550_;
										_tmp552_ = s;
										_tmp553_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp552_);
										_tmp554_ = _tmp553_;
										_tmp555_ = g_strdup_printf ("Invalid handler for `%s'", _tmp554_);
										_tmp556_ = _tmp555_;
										vala_report_error (_tmp551_, _tmp556_);
										_g_free0 (_tmp556_);
										_g_free0 (_tmp554_);
									}
								}
								_tmp557_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp557_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp558_ = dynamic_object_type;
								_tmp559_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp558_);
								_tmp560_ = _tmp559_;
								_tmp561_ = vala_symbol_get_scope ((ValaSymbol*) _tmp560_);
								_tmp562_ = _tmp561_;
								_tmp563_ = s;
								vala_scope_add (_tmp562_, NULL, (ValaSymbol*) _tmp563_);
								_tmp564_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp564_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp565_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp566_ = _tmp565_;
				if (_tmp566_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp567_;
					ValaExpression* _tmp568_;
					ValaDataType* _tmp569_;
					ValaDataType* _tmp570_;
					const gchar* _tmp571_;
					ValaSourceReference* _tmp572_;
					ValaSourceReference* _tmp573_;
					ValaDynamicProperty* _tmp574_;
					ValaDataType* _tmp575_;
					ValaDataType* _tmp576_;
					ValaDynamicProperty* _tmp587_;
					ValaDynamicProperty* _tmp588_;
					ValaDynamicProperty* _tmp589_;
					ValaDataType* _tmp590_;
					ValaDataType* _tmp591_;
					ValaDataType* _tmp592_;
					ValaDataType* _tmp593_;
					ValaDynamicProperty* _tmp594_;
					ValaSourceReference* _tmp595_;
					ValaSourceReference* _tmp596_;
					ValaPropertyAccessor* _tmp597_;
					ValaPropertyAccessor* _tmp598_;
					ValaDynamicProperty* _tmp599_;
					ValaExpression* _tmp600_;
					ValaExpression* _tmp601_;
					ValaDataType* _tmp602_;
					ValaDataType* _tmp603_;
					ValaTypeSymbol* _tmp604_;
					ValaTypeSymbol* _tmp605_;
					ValaScope* _tmp606_;
					ValaScope* _tmp607_;
					ValaObjectType* _tmp608_;
					ValaTypeSymbol* _tmp609_;
					ValaTypeSymbol* _tmp610_;
					ValaScope* _tmp611_;
					ValaScope* _tmp612_;
					ValaDynamicProperty* _tmp613_;
					ValaDynamicProperty* _tmp614_;
					_tmp567_ = vala_member_access_get_inner (self);
					_tmp568_ = _tmp567_;
					_tmp569_ = vala_expression_get_value_type (_tmp568_);
					_tmp570_ = _tmp569_;
					_tmp571_ = self->priv->_member_name;
					_tmp572_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp573_ = _tmp572_;
					_tmp574_ = vala_dynamic_property_new (_tmp570_, _tmp571_, _tmp573_, NULL);
					prop = _tmp574_;
					_tmp575_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp576_ = _tmp575_;
					if (_tmp576_ != NULL) {
						ValaDynamicProperty* _tmp577_;
						ValaDataType* _tmp578_;
						ValaDataType* _tmp579_;
						_tmp577_ = prop;
						_tmp578_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp579_ = _tmp578_;
						vala_property_set_property_type ((ValaProperty*) _tmp577_, _tmp579_);
					} else {
						ValaDynamicProperty* _tmp580_;
						ValaExpression* _tmp581_;
						ValaExpression* _tmp582_;
						ValaDataType* _tmp583_;
						ValaDataType* _tmp584_;
						ValaDataType* _tmp585_;
						ValaDataType* _tmp586_;
						_tmp580_ = prop;
						_tmp581_ = vala_member_access_get_inner (self);
						_tmp582_ = _tmp581_;
						_tmp583_ = vala_expression_get_value_type (_tmp582_);
						_tmp584_ = _tmp583_;
						_tmp585_ = vala_data_type_copy (_tmp584_);
						_tmp586_ = _tmp585_;
						vala_property_set_property_type ((ValaProperty*) _tmp580_, _tmp586_);
						_vala_code_node_unref0 (_tmp586_);
					}
					_tmp587_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp587_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp588_ = prop;
					_tmp589_ = prop;
					_tmp590_ = vala_property_get_property_type ((ValaProperty*) _tmp589_);
					_tmp591_ = _tmp590_;
					_tmp592_ = vala_data_type_copy (_tmp591_);
					_tmp593_ = _tmp592_;
					_tmp594_ = prop;
					_tmp595_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp594_);
					_tmp596_ = _tmp595_;
					_tmp597_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp593_, NULL, _tmp596_, NULL);
					_tmp598_ = _tmp597_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp588_, _tmp598_);
					_vala_code_node_unref0 (_tmp598_);
					_vala_code_node_unref0 (_tmp593_);
					_tmp599_ = prop;
					_tmp600_ = vala_member_access_get_inner (self);
					_tmp601_ = _tmp600_;
					_tmp602_ = vala_expression_get_value_type (_tmp601_);
					_tmp603_ = _tmp602_;
					_tmp604_ = vala_data_type_get_type_symbol (_tmp603_);
					_tmp605_ = _tmp604_;
					_tmp606_ = vala_symbol_get_scope ((ValaSymbol*) _tmp605_);
					_tmp607_ = _tmp606_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp599_, _tmp607_);
					_tmp608_ = dynamic_object_type;
					_tmp609_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp608_);
					_tmp610_ = _tmp609_;
					_tmp611_ = vala_symbol_get_scope ((ValaSymbol*) _tmp610_);
					_tmp612_ = _tmp611_;
					_tmp613_ = prop;
					vala_scope_add (_tmp612_, NULL, (ValaSymbol*) _tmp613_);
					_tmp614_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp614_);
					_vala_code_node_unref0 (prop);
				}
				_tmp615_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp616_ = _tmp615_;
				if (_tmp616_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp618_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp619_ = _tmp618_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp619_)) {
				ValaExpression* _tmp620_;
				ValaExpression* _tmp621_;
				ValaSymbol* _tmp622_;
				ValaSymbol* _tmp623_;
				_tmp620_ = vala_member_access_get_inner (self);
				_tmp621_ = _tmp620_;
				_tmp622_ = vala_expression_get_symbol_reference (_tmp621_);
				_tmp623_ = _tmp622_;
				_tmp617_ = VALA_IS_VARIABLE (_tmp623_);
			} else {
				_tmp617_ = FALSE;
			}
			if (_tmp617_) {
				ValaArrayType* inner_type = NULL;
				ValaSemanticAnalyzer* _tmp624_;
				ValaSemanticAnalyzer* _tmp625_;
				ValaExpression* _tmp626_;
				ValaExpression* _tmp627_;
				ValaSymbol* _tmp628_;
				ValaSymbol* _tmp629_;
				ValaDataType* _tmp630_;
				ValaArrayType* _tmp631_;
				gboolean _tmp632_ = FALSE;
				ValaArrayType* _tmp633_;
				_tmp624_ = vala_code_context_get_analyzer (context);
				_tmp625_ = _tmp624_;
				_tmp626_ = vala_member_access_get_inner (self);
				_tmp627_ = _tmp626_;
				_tmp628_ = vala_expression_get_symbol_reference (_tmp627_);
				_tmp629_ = _tmp628_;
				_tmp630_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp625_, _tmp629_, TRUE);
				_tmp631_ = VALA_IS_ARRAY_TYPE (_tmp630_) ? ((ValaArrayType*) _tmp630_) : NULL;
				if (_tmp631_ == NULL) {
					_vala_code_node_unref0 (_tmp630_);
				}
				inner_type = _tmp631_;
				_tmp633_ = inner_type;
				if (_tmp633_ != NULL) {
					ValaArrayType* _tmp634_;
					gboolean _tmp635_;
					gboolean _tmp636_;
					_tmp634_ = inner_type;
					_tmp635_ = vala_array_type_get_inline_allocated (_tmp634_);
					_tmp636_ = _tmp635_;
					_tmp632_ = _tmp636_;
				} else {
					_tmp632_ = FALSE;
				}
				if (_tmp632_) {
					ValaSourceReference* _tmp637_;
					ValaSourceReference* _tmp638_;
					_tmp637_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp638_ = _tmp637_;
					vala_report_error (_tmp638_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				} else {
					gboolean _tmp639_ = FALSE;
					ValaArrayType* _tmp640_;
					_tmp640_ = inner_type;
					if (_tmp640_ != NULL) {
						ValaArrayType* _tmp641_;
						gboolean _tmp642_;
						gboolean _tmp643_;
						_tmp641_ = inner_type;
						_tmp642_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp641_);
						_tmp643_ = _tmp642_;
						_tmp639_ = !_tmp643_;
					} else {
						_tmp639_ = FALSE;
					}
					if (_tmp639_) {
						ValaSourceReference* _tmp644_;
						ValaSourceReference* _tmp645_;
						_tmp644_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp645_ = _tmp644_;
						vala_report_error (_tmp645_, "`resize' is not allowed for unowned array references");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
				_vala_code_node_unref0 (inner_type);
			}
		}
	}
	_tmp649_ = vala_member_access_get_inner (self);
	_tmp650_ = _tmp649_;
	if (_tmp650_ == NULL) {
		ValaSymbol* _tmp651_;
		ValaSymbol* _tmp652_;
		_tmp651_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp652_ = _tmp651_;
		_tmp648_ = _tmp652_ == NULL;
	} else {
		_tmp648_ = FALSE;
	}
	if (_tmp648_) {
		ValaDataType* _tmp653_;
		ValaDataType* _tmp654_;
		_tmp653_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp654_ = _tmp653_;
		_tmp647_ = _tmp654_ != NULL;
	} else {
		_tmp647_ = FALSE;
	}
	if (_tmp647_) {
		ValaDataType* _tmp655_;
		ValaDataType* _tmp656_;
		ValaTypeSymbol* _tmp657_;
		ValaTypeSymbol* _tmp658_;
		_tmp655_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp656_ = _tmp655_;
		_tmp657_ = vala_data_type_get_type_symbol (_tmp656_);
		_tmp658_ = _tmp657_;
		_tmp646_ = VALA_IS_ENUM (_tmp658_);
	} else {
		_tmp646_ = FALSE;
	}
	if (_tmp646_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp659_;
		ValaDataType* _tmp660_;
		ValaTypeSymbol* _tmp661_;
		ValaTypeSymbol* _tmp662_;
		_tmp659_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp660_ = _tmp659_;
		_tmp661_ = vala_data_type_get_type_symbol (_tmp660_);
		_tmp662_ = _tmp661_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp662_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp663_;
			ValaList* _tmp664_;
			ValaList* _tmp665_;
			gint _val_size = 0;
			ValaList* _tmp666_;
			gint _tmp667_;
			gint _tmp668_;
			gint _val_index = 0;
			_tmp663_ = enum_type;
			_tmp664_ = vala_enum_get_values (_tmp663_);
			_tmp665_ = _vala_iterable_ref0 (_tmp664_);
			_val_list = _tmp665_;
			_tmp666_ = _val_list;
			_tmp667_ = vala_collection_get_size ((ValaCollection*) _tmp666_);
			_tmp668_ = _tmp667_;
			_val_size = _tmp668_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp669_;
				gint _tmp670_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp671_;
				gpointer _tmp672_;
				const gchar* _tmp673_;
				ValaEnumValue* _tmp674_;
				const gchar* _tmp675_;
				const gchar* _tmp676_;
				_val_index = _val_index + 1;
				_tmp669_ = _val_index;
				_tmp670_ = _val_size;
				if (!(_tmp669_ < _tmp670_)) {
					break;
				}
				_tmp671_ = _val_list;
				_tmp672_ = vala_list_get (_tmp671_, _val_index);
				val = (ValaEnumValue*) _tmp672_;
				_tmp673_ = self->priv->_member_name;
				_tmp674_ = val;
				_tmp675_ = vala_symbol_get_name ((ValaSymbol*) _tmp674_);
				_tmp676_ = _tmp675_;
				if (g_strcmp0 (_tmp673_, _tmp676_) == 0) {
					ValaEnumValue* _tmp677_;
					_tmp677_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp677_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
	}
	_tmp678_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp679_ = _tmp678_;
	if (_tmp679_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp680_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp681_ = FALSE;
		ValaExpression* _tmp682_;
		ValaExpression* _tmp683_;
		gchar* base_type_package = NULL;
		gchar* _tmp703_;
		gboolean _tmp704_ = FALSE;
		ValaSymbol* _tmp705_;
		gchar* visited_types_string = NULL;
		gchar* _tmp720_;
		ValaSourceReference* _tmp737_;
		ValaSourceReference* _tmp738_;
		const gchar* _tmp739_;
		const gchar* _tmp740_;
		const gchar* _tmp741_;
		const gchar* _tmp742_;
		gchar* _tmp743_;
		gchar* _tmp744_;
		ValaInvalidType* _tmp745_;
		ValaInvalidType* _tmp746_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp680_ = g_strdup ("(null)");
		base_type_name = _tmp680_;
		base_type = NULL;
		_tmp682_ = vala_member_access_get_inner (self);
		_tmp683_ = _tmp682_;
		if (_tmp683_ != NULL) {
			ValaExpression* _tmp684_;
			ValaExpression* _tmp685_;
			ValaDataType* _tmp686_;
			ValaDataType* _tmp687_;
			_tmp684_ = vala_member_access_get_inner (self);
			_tmp685_ = _tmp684_;
			_tmp686_ = vala_expression_get_value_type (_tmp685_);
			_tmp687_ = _tmp686_;
			_tmp681_ = _tmp687_ != NULL;
		} else {
			_tmp681_ = FALSE;
		}
		if (_tmp681_) {
			ValaExpression* _tmp688_;
			ValaExpression* _tmp689_;
			ValaDataType* _tmp690_;
			ValaDataType* _tmp691_;
			gchar* _tmp692_;
			ValaExpression* _tmp693_;
			ValaExpression* _tmp694_;
			ValaDataType* _tmp695_;
			ValaDataType* _tmp696_;
			ValaTypeSymbol* _tmp697_;
			ValaTypeSymbol* _tmp698_;
			_tmp688_ = vala_member_access_get_inner (self);
			_tmp689_ = _tmp688_;
			_tmp690_ = vala_expression_get_value_type (_tmp689_);
			_tmp691_ = _tmp690_;
			_tmp692_ = vala_code_node_to_string ((ValaCodeNode*) _tmp691_);
			_g_free0 (base_type_name);
			base_type_name = _tmp692_;
			_tmp693_ = vala_member_access_get_inner (self);
			_tmp694_ = _tmp693_;
			_tmp695_ = vala_expression_get_value_type (_tmp694_);
			_tmp696_ = _tmp695_;
			_tmp697_ = vala_data_type_get_type_symbol (_tmp696_);
			_tmp698_ = _tmp697_;
			base_type = (ValaSymbol*) _tmp698_;
		} else {
			ValaSymbol* _tmp699_;
			_tmp699_ = base_symbol;
			if (_tmp699_ != NULL) {
				ValaSymbol* _tmp700_;
				gchar* _tmp701_;
				ValaSymbol* _tmp702_;
				_tmp700_ = base_symbol;
				_tmp701_ = vala_symbol_get_full_name (_tmp700_);
				_g_free0 (base_type_name);
				base_type_name = _tmp701_;
				_tmp702_ = base_symbol;
				base_type = _tmp702_;
			}
		}
		_tmp703_ = g_strdup ("");
		base_type_package = _tmp703_;
		_tmp705_ = base_type;
		if (_tmp705_ != NULL) {
			ValaSymbol* _tmp706_;
			gboolean _tmp707_;
			gboolean _tmp708_;
			_tmp706_ = base_type;
			_tmp707_ = vala_symbol_get_external_package (_tmp706_);
			_tmp708_ = _tmp707_;
			_tmp704_ = _tmp708_;
		} else {
			_tmp704_ = FALSE;
		}
		if (_tmp704_) {
			ValaSymbol* _tmp709_;
			ValaSourceReference* _tmp710_;
			ValaSourceReference* _tmp711_;
			ValaSourceFile* _tmp712_;
			ValaSourceFile* _tmp713_;
			const gchar* _tmp714_;
			const gchar* _tmp715_;
			gchar* _tmp716_;
			const gchar* _tmp717_;
			_tmp709_ = base_symbol;
			_tmp710_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp709_);
			_tmp711_ = _tmp710_;
			_tmp712_ = vala_source_reference_get_file (_tmp711_);
			_tmp713_ = _tmp712_;
			_tmp714_ = vala_source_file_get_package_name (_tmp713_);
			_tmp715_ = _tmp714_;
			_tmp716_ = g_strdup (_tmp715_);
			_g_free0 (base_type_package);
			base_type_package = _tmp716_;
			_tmp717_ = base_type_package;
			if (_tmp717_ != NULL) {
				const gchar* _tmp718_;
				gchar* _tmp719_;
				_tmp718_ = base_type_package;
				_tmp719_ = g_strdup_printf (" (%s)", _tmp718_);
				_g_free0 (base_type_package);
				base_type_package = _tmp719_;
			}
		}
		_tmp720_ = g_strdup ("");
		visited_types_string = _tmp720_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp721_;
			ValaArrayList* _tmp722_;
			gint _type_size = 0;
			ValaArrayList* _tmp723_;
			gint _tmp724_;
			gint _tmp725_;
			gint _type_index = 0;
			_tmp721_ = visited_types;
			_tmp722_ = _vala_iterable_ref0 (_tmp721_);
			_type_list = _tmp722_;
			_tmp723_ = _type_list;
			_tmp724_ = vala_collection_get_size ((ValaCollection*) _tmp723_);
			_tmp725_ = _tmp724_;
			_type_size = _tmp725_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp726_;
				gint _tmp727_;
				ValaDataType* type = NULL;
				ValaArrayList* _tmp728_;
				gpointer _tmp729_;
				const gchar* _tmp730_;
				ValaDataType* _tmp731_;
				gchar* _tmp732_;
				gchar* _tmp733_;
				gchar* _tmp734_;
				gchar* _tmp735_;
				gchar* _tmp736_;
				_type_index = _type_index + 1;
				_tmp726_ = _type_index;
				_tmp727_ = _type_size;
				if (!(_tmp726_ < _tmp727_)) {
					break;
				}
				_tmp728_ = _type_list;
				_tmp729_ = vala_list_get ((ValaList*) _tmp728_, _type_index);
				type = (ValaDataType*) _tmp729_;
				_tmp730_ = visited_types_string;
				_tmp731_ = type;
				_tmp732_ = vala_code_node_to_string ((ValaCodeNode*) _tmp731_);
				_tmp733_ = _tmp732_;
				_tmp734_ = g_strdup_printf (" or `%s'", _tmp733_);
				_tmp735_ = _tmp734_;
				_tmp736_ = g_strconcat (_tmp730_, _tmp735_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp736_;
				_g_free0 (_tmp735_);
				_g_free0 (_tmp733_);
				_vala_code_node_unref0 (type);
			}
			_vala_iterable_unref0 (_type_list);
		}
		_tmp737_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp738_ = _tmp737_;
		_tmp739_ = self->priv->_member_name;
		_tmp740_ = base_type_name;
		_tmp741_ = base_type_package;
		_tmp742_ = visited_types_string;
		_tmp743_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'%s%s", _tmp739_, _tmp740_, _tmp741_, _tmp742_);
		_tmp744_ = _tmp743_;
		vala_report_error (_tmp738_, _tmp744_);
		_g_free0 (_tmp744_);
		_tmp745_ = vala_invalid_type_new ();
		_tmp746_ = _tmp745_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp746_);
		_vala_code_node_unref0 (_tmp746_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp747_;
		ValaSymbol* _tmp748_;
		gboolean _tmp749_;
		gboolean _tmp750_;
		_tmp747_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp748_ = _tmp747_;
		_tmp749_ = vala_code_node_get_error ((ValaCodeNode*) _tmp748_);
		_tmp750_ = _tmp749_;
		if (_tmp750_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp751_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp752_ = _tmp751_;
	if (VALA_IS_SIGNAL (_tmp752_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp753_;
		ValaSymbol* _tmp754_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp761_;
		ValaCodeNode* _tmp762_;
		ValaCodeNode* _tmp763_;
		gboolean _tmp764_ = FALSE;
		gboolean _tmp765_ = FALSE;
		gboolean _tmp766_ = FALSE;
		ValaCodeNode* _tmp767_;
		_tmp753_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp754_ = _tmp753_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp754_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp755_;
			ValaCodeNode* _tmp756_;
			ValaCodeNode* _tmp757_;
			ValaCodeNode* _tmp758_;
			ValaCodeNode* _tmp759_;
			ValaCodeNode* _tmp760_;
			_tmp755_ = ma;
			_tmp756_ = vala_code_node_get_parent_node (_tmp755_);
			_tmp757_ = _tmp756_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp757_)) {
				break;
			}
			_tmp758_ = ma;
			_tmp759_ = vala_code_node_get_parent_node (_tmp758_);
			_tmp760_ = _tmp759_;
			ma = _tmp760_;
		}
		_tmp761_ = ma;
		_tmp762_ = vala_code_node_get_parent_node (_tmp761_);
		_tmp763_ = _tmp762_;
		parent = _tmp763_;
		_tmp767_ = parent;
		if (_tmp767_ != NULL) {
			ValaCodeNode* _tmp768_;
			_tmp768_ = parent;
			_tmp766_ = !VALA_IS_ELEMENT_ACCESS (_tmp768_);
		} else {
			_tmp766_ = FALSE;
		}
		if (_tmp766_) {
			ValaCodeNode* _tmp769_;
			ValaExpression* _tmp770_;
			ValaExpression* _tmp771_;
			_tmp769_ = ma;
			_tmp770_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp769_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp771_ = _tmp770_;
			_tmp765_ = !VALA_IS_BASE_ACCESS (_tmp771_);
		} else {
			_tmp765_ = FALSE;
		}
		if (_tmp765_) {
			gboolean _tmp772_ = FALSE;
			ValaCodeNode* _tmp773_;
			_tmp773_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp773_)) {
				_tmp772_ = TRUE;
			} else {
				ValaCodeNode* _tmp774_;
				ValaList* _tmp775_;
				_tmp774_ = parent;
				_tmp775_ = vala_method_call_get_argument_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp774_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp772_ = vala_collection_contains ((ValaCollection*) _tmp775_, (ValaExpression*) self);
			}
			_tmp764_ = _tmp772_;
		} else {
			_tmp764_ = FALSE;
		}
		if (_tmp764_) {
			ValaSignal* _tmp776_;
			ValaAttribute* _tmp777_;
			_tmp776_ = sig;
			_tmp777_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp776_, "HasEmitter");
			if (_tmp777_ != NULL) {
				ValaSignal* _tmp778_;
				ValaSignal* _tmp779_;
				ValaMethod* _tmp780_;
				ValaMethod* _tmp781_;
				_tmp778_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp778_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp779_ = sig;
				_tmp780_ = vala_signal_get_emitter (_tmp779_);
				_tmp781_ = _tmp780_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp781_);
			} else {
				ValaSourceReference* _tmp782_;
				ValaSourceReference* _tmp783_;
				ValaSymbol* _tmp784_;
				ValaSymbol* _tmp785_;
				gchar* _tmp786_;
				gchar* _tmp787_;
				gchar* _tmp788_;
				gchar* _tmp789_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp782_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp783_ = _tmp782_;
				_tmp784_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp785_ = _tmp784_;
				_tmp786_ = vala_symbol_get_full_name (_tmp785_);
				_tmp787_ = _tmp786_;
				_tmp788_ = g_strdup_printf ("Signal `%s' requires emitter in this context", _tmp787_);
				_tmp789_ = _tmp788_;
				vala_report_error (_tmp783_, _tmp789_);
				_g_free0 (_tmp789_);
				_g_free0 (_tmp787_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp790_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp791_ = _tmp790_;
	member = _tmp791_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp792_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp792_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp793_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp793_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp794_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp795_;
		ValaSymbol* _tmp796_;
		ValaSymbol* _tmp797_;
		gboolean _tmp798_ = FALSE;
		ValaBlock* _tmp799_;
		_tmp794_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp794_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp795_ = local;
		_tmp796_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp795_);
		_tmp797_ = _tmp796_;
		block = VALA_IS_BLOCK (_tmp797_) ? ((ValaBlock*) _tmp797_) : NULL;
		_tmp799_ = block;
		if (_tmp799_ != NULL) {
			ValaBlock* _tmp800_;
			ValaSymbol* _tmp801_;
			ValaSemanticAnalyzer* _tmp802_;
			ValaSemanticAnalyzer* _tmp803_;
			ValaSymbol* _tmp804_;
			ValaSymbol* _tmp805_;
			_tmp800_ = block;
			_tmp801_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp800_);
			_tmp802_ = vala_code_context_get_analyzer (context);
			_tmp803_ = _tmp802_;
			_tmp804_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp803_);
			_tmp805_ = _tmp804_;
			_tmp798_ = _tmp801_ != _tmp805_;
		} else {
			_tmp798_ = FALSE;
		}
		if (_tmp798_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp806_;
			ValaSemanticAnalyzer* _tmp807_;
			ValaSymbol* _tmp808_;
			ValaSymbol* _tmp809_;
			ValaLocalVariable* _tmp820_;
			ValaBlock* _tmp821_;
			_tmp806_ = vala_code_context_get_analyzer (context);
			_tmp807_ = _tmp806_;
			_tmp808_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp807_);
			_tmp809_ = _tmp808_;
			sym = _tmp809_;
			while (TRUE) {
				ValaSymbol* _tmp810_;
				ValaBlock* _tmp811_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp812_;
				ValaMethod* _tmp813_;
				ValaSymbol* _tmp817_;
				ValaSymbol* _tmp818_;
				ValaSymbol* _tmp819_;
				_tmp810_ = sym;
				_tmp811_ = block;
				if (!(_tmp810_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp811_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp812_ = sym;
				method = VALA_IS_METHOD (_tmp812_) ? ((ValaMethod*) _tmp812_) : NULL;
				_tmp813_ = method;
				if (_tmp813_ != NULL) {
					ValaMethod* _tmp814_;
					ValaMethod* _tmp815_;
					ValaLocalVariable* _tmp816_;
					_tmp814_ = method;
					vala_method_set_closure (_tmp814_, TRUE);
					_tmp815_ = method;
					_tmp816_ = local;
					vala_method_add_captured_variable (_tmp815_, _tmp816_);
				}
				_tmp817_ = sym;
				_tmp818_ = vala_symbol_get_parent_symbol (_tmp817_);
				_tmp819_ = _tmp818_;
				sym = _tmp819_;
			}
			_tmp820_ = local;
			vala_local_variable_set_captured (_tmp820_, TRUE);
			_tmp821_ = block;
			vala_block_set_captured (_tmp821_, TRUE);
		}
	} else {
		ValaSymbol* _tmp822_;
		_tmp822_ = member;
		if (VALA_IS_PARAMETER (_tmp822_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp823_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp824_;
			ValaSymbol* _tmp825_;
			ValaSymbol* _tmp826_;
			gboolean _tmp827_ = FALSE;
			gboolean _tmp828_ = FALSE;
			ValaMethod* _tmp829_;
			_tmp823_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp823_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp824_ = param;
			_tmp825_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp824_);
			_tmp826_ = _tmp825_;
			m = VALA_IS_METHOD (_tmp826_) ? ((ValaMethod*) _tmp826_) : NULL;
			_tmp829_ = m;
			if (_tmp829_ != NULL) {
				ValaMethod* _tmp830_;
				ValaSemanticAnalyzer* _tmp831_;
				ValaSemanticAnalyzer* _tmp832_;
				ValaSymbol* _tmp833_;
				ValaSymbol* _tmp834_;
				_tmp830_ = m;
				_tmp831_ = vala_code_context_get_analyzer (context);
				_tmp832_ = _tmp831_;
				_tmp833_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp832_);
				_tmp834_ = _tmp833_;
				_tmp828_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp830_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp834_;
			} else {
				_tmp828_ = FALSE;
			}
			if (_tmp828_) {
				ValaParameter* _tmp835_;
				ValaMethod* _tmp836_;
				ValaParameter* _tmp837_;
				ValaParameter* _tmp838_;
				_tmp835_ = param;
				_tmp836_ = m;
				_tmp837_ = vala_method_get_this_parameter (_tmp836_);
				_tmp838_ = _tmp837_;
				_tmp827_ = _tmp835_ != _tmp838_;
			} else {
				_tmp827_ = FALSE;
			}
			if (_tmp827_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp839_;
				ValaSemanticAnalyzer* _tmp840_;
				ValaSymbol* _tmp841_;
				ValaSymbol* _tmp842_;
				ValaParameter* _tmp851_;
				ValaMethod* _tmp852_;
				ValaBlock* _tmp853_;
				ValaBlock* _tmp854_;
				ValaParameter* _tmp855_;
				ValaParameterDirection _tmp856_;
				ValaParameterDirection _tmp857_;
				_tmp839_ = vala_code_context_get_analyzer (context);
				_tmp840_ = _tmp839_;
				_tmp841_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp840_);
				_tmp842_ = _tmp841_;
				sym = _tmp842_;
				while (TRUE) {
					ValaSymbol* _tmp843_;
					ValaMethod* _tmp844_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp845_;
					ValaMethod* _tmp846_;
					ValaSymbol* _tmp848_;
					ValaSymbol* _tmp849_;
					ValaSymbol* _tmp850_;
					_tmp843_ = sym;
					_tmp844_ = m;
					if (!(_tmp843_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp844_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp845_ = sym;
					method = VALA_IS_METHOD (_tmp845_) ? ((ValaMethod*) _tmp845_) : NULL;
					_tmp846_ = method;
					if (_tmp846_ != NULL) {
						ValaMethod* _tmp847_;
						_tmp847_ = method;
						vala_method_set_closure (_tmp847_, TRUE);
					}
					_tmp848_ = sym;
					_tmp849_ = vala_symbol_get_parent_symbol (_tmp848_);
					_tmp850_ = _tmp849_;
					sym = _tmp850_;
				}
				_tmp851_ = param;
				vala_parameter_set_captured (_tmp851_, TRUE);
				_tmp852_ = m;
				_tmp853_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp852_);
				_tmp854_ = _tmp853_;
				vala_block_set_captured (_tmp854_, TRUE);
				_tmp855_ = param;
				_tmp856_ = vala_parameter_get_direction (_tmp855_);
				_tmp857_ = _tmp856_;
				if (_tmp857_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp858_;
					ValaSourceReference* _tmp859_;
					ValaParameter* _tmp860_;
					gchar* _tmp861_;
					gchar* _tmp862_;
					gchar* _tmp863_;
					gchar* _tmp864_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp858_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp859_ = _tmp858_;
					_tmp860_ = param;
					_tmp861_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp860_);
					_tmp862_ = _tmp861_;
					_tmp863_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp862_);
					_tmp864_ = _tmp863_;
					vala_report_error (_tmp859_, _tmp864_);
					_g_free0 (_tmp864_);
					_g_free0 (_tmp862_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp865_;
				ValaSymbol* _tmp866_;
				ValaSymbol* _tmp867_;
				ValaSymbol* _tmp868_;
				ValaSymbol* _tmp869_;
				gboolean _tmp870_ = FALSE;
				gboolean _tmp871_ = FALSE;
				ValaPropertyAccessor* _tmp872_;
				_tmp865_ = param;
				_tmp866_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp865_);
				_tmp867_ = _tmp866_;
				_tmp868_ = vala_symbol_get_parent_symbol (_tmp867_);
				_tmp869_ = _tmp868_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp869_) ? ((ValaPropertyAccessor*) _tmp869_) : NULL;
				_tmp872_ = acc;
				if (_tmp872_ != NULL) {
					ValaPropertyAccessor* _tmp873_;
					ValaSemanticAnalyzer* _tmp874_;
					ValaSemanticAnalyzer* _tmp875_;
					ValaSymbol* _tmp876_;
					ValaSymbol* _tmp877_;
					_tmp873_ = acc;
					_tmp874_ = vala_code_context_get_analyzer (context);
					_tmp875_ = _tmp874_;
					_tmp876_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp875_);
					_tmp877_ = _tmp876_;
					_tmp871_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp873_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp877_;
				} else {
					_tmp871_ = FALSE;
				}
				if (_tmp871_) {
					ValaParameter* _tmp878_;
					ValaPropertyAccessor* _tmp879_;
					ValaProperty* _tmp880_;
					ValaProperty* _tmp881_;
					ValaParameter* _tmp882_;
					ValaParameter* _tmp883_;
					_tmp878_ = param;
					_tmp879_ = acc;
					_tmp880_ = vala_property_accessor_get_prop (_tmp879_);
					_tmp881_ = _tmp880_;
					_tmp882_ = vala_property_get_this_parameter (_tmp881_);
					_tmp883_ = _tmp882_;
					_tmp870_ = _tmp878_ != _tmp883_;
				} else {
					_tmp870_ = FALSE;
				}
				if (_tmp870_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp884_;
					ValaSemanticAnalyzer* _tmp885_;
					ValaSymbol* _tmp886_;
					ValaSymbol* _tmp887_;
					ValaParameter* _tmp896_;
					ValaPropertyAccessor* _tmp897_;
					ValaBlock* _tmp898_;
					ValaBlock* _tmp899_;
					_tmp884_ = vala_code_context_get_analyzer (context);
					_tmp885_ = _tmp884_;
					_tmp886_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp885_);
					_tmp887_ = _tmp886_;
					sym = _tmp887_;
					while (TRUE) {
						ValaSymbol* _tmp888_;
						ValaMethod* _tmp889_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp890_;
						ValaMethod* _tmp891_;
						ValaSymbol* _tmp893_;
						ValaSymbol* _tmp894_;
						ValaSymbol* _tmp895_;
						_tmp888_ = sym;
						_tmp889_ = m;
						if (!(_tmp888_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp889_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp890_ = sym;
						method = VALA_IS_METHOD (_tmp890_) ? ((ValaMethod*) _tmp890_) : NULL;
						_tmp891_ = method;
						if (_tmp891_ != NULL) {
							ValaMethod* _tmp892_;
							_tmp892_ = method;
							vala_method_set_closure (_tmp892_, TRUE);
						}
						_tmp893_ = sym;
						_tmp894_ = vala_symbol_get_parent_symbol (_tmp893_);
						_tmp895_ = _tmp894_;
						sym = _tmp895_;
					}
					_tmp896_ = param;
					vala_parameter_set_captured (_tmp896_, TRUE);
					_tmp897_ = acc;
					_tmp898_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp897_);
					_tmp899_ = _tmp898_;
					vala_block_set_captured (_tmp899_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp900_;
			_tmp900_ = member;
			if (VALA_IS_FIELD (_tmp900_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp901_;
				ValaField* _tmp902_;
				ValaSymbolAccessibility _tmp903_;
				ValaSymbolAccessibility _tmp904_;
				ValaField* _tmp905_;
				ValaMemberBinding _tmp906_;
				ValaMemberBinding _tmp907_;
				ValaField* _tmp908_;
				ValaMemberBinding _tmp909_;
				ValaMemberBinding _tmp910_;
				ValaField* _tmp911_;
				ValaDataType* _tmp912_;
				ValaDataType* _tmp913_;
				_tmp901_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp901_, VALA_TYPE_FIELD, ValaField);
				_tmp902_ = f;
				_tmp903_ = vala_symbol_get_access ((ValaSymbol*) _tmp902_);
				_tmp904_ = _tmp903_;
				access = _tmp904_;
				_tmp905_ = f;
				_tmp906_ = vala_field_get_binding (_tmp905_);
				_tmp907_ = _tmp906_;
				instance = _tmp907_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp908_ = f;
				_tmp909_ = vala_field_get_binding (_tmp908_);
				_tmp910_ = _tmp909_;
				klass = _tmp910_ == VALA_MEMBER_BINDING_CLASS;
				_tmp911_ = f;
				_tmp912_ = vala_variable_get_variable_type ((ValaVariable*) _tmp911_);
				_tmp913_ = _tmp912_;
				if (VALA_IS_GENERIC_TYPE (_tmp913_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp914_;
				_tmp914_ = member;
				if (VALA_IS_CONSTANT (_tmp914_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp915_;
					ValaConstant* _tmp916_;
					ValaSymbolAccessibility _tmp917_;
					ValaSymbolAccessibility _tmp918_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp919_;
					ValaSymbol* _tmp920_;
					ValaSymbol* _tmp921_;
					gboolean _tmp922_ = FALSE;
					ValaBlock* _tmp923_;
					_tmp915_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp915_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp916_ = c;
					_tmp917_ = vala_symbol_get_access ((ValaSymbol*) _tmp916_);
					_tmp918_ = _tmp917_;
					access = _tmp918_;
					_tmp919_ = c;
					_tmp920_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp919_);
					_tmp921_ = _tmp920_;
					block = VALA_IS_BLOCK (_tmp921_) ? ((ValaBlock*) _tmp921_) : NULL;
					_tmp923_ = block;
					if (_tmp923_ != NULL) {
						ValaBlock* _tmp924_;
						ValaSymbol* _tmp925_;
						ValaSemanticAnalyzer* _tmp926_;
						ValaSemanticAnalyzer* _tmp927_;
						ValaSymbol* _tmp928_;
						ValaSymbol* _tmp929_;
						_tmp924_ = block;
						_tmp925_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp924_);
						_tmp926_ = vala_code_context_get_analyzer (context);
						_tmp927_ = _tmp926_;
						_tmp928_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp927_);
						_tmp929_ = _tmp928_;
						_tmp922_ = _tmp925_ != _tmp929_;
					} else {
						_tmp922_ = FALSE;
					}
					if (_tmp922_) {
						ValaSourceReference* _tmp930_;
						ValaSourceReference* _tmp931_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp930_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp931_ = _tmp930_;
						vala_report_error (_tmp931_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp932_;
					_tmp932_ = member;
					if (VALA_IS_METHOD (_tmp932_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp933_;
						ValaMethod* _tmp934_;
						gboolean _tmp935_;
						gboolean _tmp936_;
						ValaMethod* _tmp1025_;
						ValaSymbolAccessibility _tmp1026_;
						ValaSymbolAccessibility _tmp1027_;
						ValaMethod* _tmp1028_;
						ValaMethod* _tmp1032_;
						ValaMemberBinding _tmp1033_;
						ValaMemberBinding _tmp1034_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1055_;
						ValaDataType* _tmp1056_;
						ValaDataType* _tmp1057_;
						gboolean _tmp1058_ = FALSE;
						ValaGenericType* _tmp1059_;
						_tmp933_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp933_, VALA_TYPE_METHOD, ValaMethod);
						_tmp934_ = m;
						_tmp935_ = vala_method_get_is_async_callback (_tmp934_);
						_tmp936_ = _tmp935_;
						if (_tmp936_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp937_;
							ValaSemanticAnalyzer* _tmp938_;
							ValaMethod* _tmp939_;
							ValaMethod* _tmp940_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp941_;
							ValaMethod* _tmp970_;
							ValaSemanticAnalyzer* _tmp971_;
							ValaSemanticAnalyzer* _tmp972_;
							ValaMethod* _tmp973_;
							ValaMethod* _tmp974_;
							ValaMethod* _tmp990_;
							ValaMethod* _tmp991_;
							ValaMethod* _tmp992_;
							ValaSymbol* _tmp993_;
							ValaSymbol* _tmp994_;
							_tmp937_ = vala_code_context_get_analyzer (context);
							_tmp938_ = _tmp937_;
							_tmp939_ = vala_semantic_analyzer_get_current_async_method (_tmp938_);
							_tmp940_ = _tmp939_;
							async_method = _tmp940_;
							is_valid_access = FALSE;
							_tmp941_ = async_method;
							if (_tmp941_ != NULL) {
								ValaMethod* _tmp942_;
								ValaMethod* _tmp943_;
								ValaMethod* _tmp944_;
								_tmp942_ = m;
								_tmp943_ = async_method;
								_tmp944_ = vala_method_get_callback_method (_tmp943_);
								if (_tmp942_ == _tmp944_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp945_ = FALSE;
									ValaMethod* _tmp946_;
									ValaMethod* _tmp947_;
									ValaMethod* _tmp948_;
									_tmp946_ = async_method;
									_tmp947_ = vala_method_get_base_method (_tmp946_);
									_tmp948_ = _tmp947_;
									if (_tmp948_ != NULL) {
										ValaMethod* _tmp949_;
										ValaMethod* _tmp950_;
										ValaMethod* _tmp951_;
										ValaMethod* _tmp952_;
										ValaMethod* _tmp953_;
										_tmp949_ = m;
										_tmp950_ = async_method;
										_tmp951_ = vala_method_get_base_method (_tmp950_);
										_tmp952_ = _tmp951_;
										_tmp953_ = vala_method_get_callback_method (_tmp952_);
										_tmp945_ = _tmp949_ == _tmp953_;
									} else {
										_tmp945_ = FALSE;
									}
									if (_tmp945_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp954_ = FALSE;
										ValaMethod* _tmp955_;
										ValaMethod* _tmp956_;
										ValaMethod* _tmp957_;
										_tmp955_ = async_method;
										_tmp956_ = vala_method_get_base_interface_method (_tmp955_);
										_tmp957_ = _tmp956_;
										if (_tmp957_ != NULL) {
											ValaMethod* _tmp958_;
											ValaMethod* _tmp959_;
											ValaMethod* _tmp960_;
											ValaMethod* _tmp961_;
											ValaMethod* _tmp962_;
											_tmp958_ = m;
											_tmp959_ = async_method;
											_tmp960_ = vala_method_get_base_interface_method (_tmp959_);
											_tmp961_ = _tmp960_;
											_tmp962_ = vala_method_get_callback_method (_tmp961_);
											_tmp954_ = _tmp958_ == _tmp962_;
										} else {
											_tmp954_ = FALSE;
										}
										if (_tmp954_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp963_;
								ValaSourceReference* _tmp964_;
								ValaMethod* _tmp965_;
								gchar* _tmp966_;
								gchar* _tmp967_;
								gchar* _tmp968_;
								gchar* _tmp969_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp963_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp964_ = _tmp963_;
								_tmp965_ = m;
								_tmp966_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp965_);
								_tmp967_ = _tmp966_;
								_tmp968_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp967_);
								_tmp969_ = _tmp968_;
								vala_report_error (_tmp964_, _tmp969_);
								_g_free0 (_tmp969_);
								_g_free0 (_tmp967_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp970_ = async_method;
							_tmp971_ = vala_code_context_get_analyzer (context);
							_tmp972_ = _tmp971_;
							_tmp973_ = vala_semantic_analyzer_get_current_method (_tmp972_);
							_tmp974_ = _tmp973_;
							if (_tmp970_ != _tmp974_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp975_;
								ValaSemanticAnalyzer* _tmp976_;
								ValaMethod* _tmp977_;
								ValaMethod* _tmp978_;
								ValaMethod* _tmp987_;
								ValaBlock* _tmp988_;
								ValaBlock* _tmp989_;
								_tmp975_ = vala_code_context_get_analyzer (context);
								_tmp976_ = _tmp975_;
								_tmp977_ = vala_semantic_analyzer_get_current_method (_tmp976_);
								_tmp978_ = _tmp977_;
								sym = (ValaSymbol*) _tmp978_;
								while (TRUE) {
									ValaSymbol* _tmp979_;
									ValaMethod* _tmp980_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp981_;
									ValaMethod* _tmp982_;
									ValaSymbol* _tmp984_;
									ValaSymbol* _tmp985_;
									ValaSymbol* _tmp986_;
									_tmp979_ = sym;
									_tmp980_ = async_method;
									if (!(_tmp979_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp980_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp981_ = sym;
									method = VALA_IS_METHOD (_tmp981_) ? ((ValaMethod*) _tmp981_) : NULL;
									_tmp982_ = method;
									if (_tmp982_ != NULL) {
										ValaMethod* _tmp983_;
										_tmp983_ = method;
										vala_method_set_closure (_tmp983_, TRUE);
									}
									_tmp984_ = sym;
									_tmp985_ = vala_symbol_get_parent_symbol (_tmp984_);
									_tmp986_ = _tmp985_;
									sym = _tmp986_;
								}
								_tmp987_ = async_method;
								_tmp988_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp987_);
								_tmp989_ = _tmp988_;
								vala_block_set_captured (_tmp989_, TRUE);
							}
							_tmp990_ = async_method;
							_tmp991_ = vala_method_get_callback_method (_tmp990_);
							m = _tmp991_;
							_tmp992_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp992_);
							_tmp993_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp994_ = _tmp993_;
							member = _tmp994_;
						} else {
							ValaMethod* _tmp995_;
							ValaMethod* _tmp996_;
							ValaMethod* _tmp997_;
							_tmp995_ = m;
							_tmp996_ = vala_method_get_base_method (_tmp995_);
							_tmp997_ = _tmp996_;
							if (_tmp997_ != NULL) {
								ValaMethod* _tmp998_;
								ValaMethod* _tmp999_;
								ValaMethod* _tmp1000_;
								ValaMethod* _tmp1001_;
								ValaSignal* _tmp1002_;
								ValaSignal* _tmp1003_;
								ValaSymbol* _tmp1008_;
								ValaSymbol* _tmp1009_;
								_tmp998_ = m;
								_tmp999_ = vala_method_get_base_method (_tmp998_);
								_tmp1000_ = _tmp999_;
								m = _tmp1000_;
								_tmp1001_ = m;
								_tmp1002_ = vala_method_get_signal_reference (_tmp1001_);
								_tmp1003_ = _tmp1002_;
								if (_tmp1003_ != NULL) {
									ValaMethod* _tmp1004_;
									ValaSignal* _tmp1005_;
									ValaSignal* _tmp1006_;
									_tmp1004_ = m;
									_tmp1005_ = vala_method_get_signal_reference (_tmp1004_);
									_tmp1006_ = _tmp1005_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1006_);
								} else {
									ValaMethod* _tmp1007_;
									_tmp1007_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1007_);
								}
								_tmp1008_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1009_ = _tmp1008_;
								member = _tmp1009_;
							} else {
								ValaMethod* _tmp1010_;
								ValaMethod* _tmp1011_;
								ValaMethod* _tmp1012_;
								_tmp1010_ = m;
								_tmp1011_ = vala_method_get_base_interface_method (_tmp1010_);
								_tmp1012_ = _tmp1011_;
								if (_tmp1012_ != NULL) {
									ValaMethod* _tmp1013_;
									ValaMethod* _tmp1014_;
									ValaMethod* _tmp1015_;
									ValaMethod* _tmp1016_;
									ValaSignal* _tmp1017_;
									ValaSignal* _tmp1018_;
									ValaSymbol* _tmp1023_;
									ValaSymbol* _tmp1024_;
									_tmp1013_ = m;
									_tmp1014_ = vala_method_get_base_interface_method (_tmp1013_);
									_tmp1015_ = _tmp1014_;
									m = _tmp1015_;
									_tmp1016_ = m;
									_tmp1017_ = vala_method_get_signal_reference (_tmp1016_);
									_tmp1018_ = _tmp1017_;
									if (_tmp1018_ != NULL) {
										ValaMethod* _tmp1019_;
										ValaSignal* _tmp1020_;
										ValaSignal* _tmp1021_;
										_tmp1019_ = m;
										_tmp1020_ = vala_method_get_signal_reference (_tmp1019_);
										_tmp1021_ = _tmp1020_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1021_);
									} else {
										ValaMethod* _tmp1022_;
										_tmp1022_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1022_);
									}
									_tmp1023_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1024_ = _tmp1023_;
									member = _tmp1024_;
								}
							}
						}
						_tmp1025_ = m;
						_tmp1026_ = vala_symbol_get_access ((ValaSymbol*) _tmp1025_);
						_tmp1027_ = _tmp1026_;
						access = _tmp1027_;
						_tmp1028_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1028_)) {
							ValaMethod* _tmp1029_;
							ValaMemberBinding _tmp1030_;
							ValaMemberBinding _tmp1031_;
							_tmp1029_ = m;
							_tmp1030_ = vala_method_get_binding (_tmp1029_);
							_tmp1031_ = _tmp1030_;
							instance = _tmp1031_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1032_ = m;
						_tmp1033_ = vala_method_get_binding (_tmp1032_);
						_tmp1034_ = _tmp1033_;
						klass = _tmp1034_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1035_;
							ValaList* _tmp1036_;
							ValaList* _tmp1037_;
							gint _param_size = 0;
							ValaList* _tmp1038_;
							gint _tmp1039_;
							gint _tmp1040_;
							gint _param_index = 0;
							_tmp1035_ = m;
							_tmp1036_ = vala_callable_get_parameters ((ValaCallable*) _tmp1035_);
							_tmp1037_ = _vala_iterable_ref0 (_tmp1036_);
							_param_list = _tmp1037_;
							_tmp1038_ = _param_list;
							_tmp1039_ = vala_collection_get_size ((ValaCollection*) _tmp1038_);
							_tmp1040_ = _tmp1039_;
							_param_size = _tmp1040_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1041_;
								gint _tmp1042_;
								ValaParameter* param = NULL;
								ValaList* _tmp1043_;
								gpointer _tmp1044_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1045_;
								ValaDataType* _tmp1046_;
								ValaDataType* _tmp1047_;
								gboolean _tmp1048_ = FALSE;
								ValaGenericType* _tmp1049_;
								_param_index = _param_index + 1;
								_tmp1041_ = _param_index;
								_tmp1042_ = _param_size;
								if (!(_tmp1041_ < _tmp1042_)) {
									break;
								}
								_tmp1043_ = _param_list;
								_tmp1044_ = vala_list_get (_tmp1043_, _param_index);
								param = (ValaParameter*) _tmp1044_;
								_tmp1045_ = param;
								_tmp1046_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1045_);
								_tmp1047_ = _tmp1046_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1047_) ? ((ValaGenericType*) _tmp1047_) : NULL;
								_tmp1049_ = generic_type;
								if (_tmp1049_ != NULL) {
									ValaGenericType* _tmp1050_;
									ValaTypeParameter* _tmp1051_;
									ValaTypeParameter* _tmp1052_;
									ValaSymbol* _tmp1053_;
									ValaSymbol* _tmp1054_;
									_tmp1050_ = generic_type;
									_tmp1051_ = vala_generic_type_get_type_parameter (_tmp1050_);
									_tmp1052_ = _tmp1051_;
									_tmp1053_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1052_);
									_tmp1054_ = _tmp1053_;
									_tmp1048_ = VALA_IS_TYPESYMBOL (_tmp1054_);
								} else {
									_tmp1048_ = FALSE;
								}
								if (_tmp1048_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp1055_ = m;
						_tmp1056_ = vala_callable_get_return_type ((ValaCallable*) _tmp1055_);
						_tmp1057_ = _tmp1056_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1057_) ? ((ValaGenericType*) _tmp1057_) : NULL;
						_tmp1059_ = generic_type;
						if (_tmp1059_ != NULL) {
							ValaGenericType* _tmp1060_;
							ValaTypeParameter* _tmp1061_;
							ValaTypeParameter* _tmp1062_;
							ValaSymbol* _tmp1063_;
							ValaSymbol* _tmp1064_;
							_tmp1060_ = generic_type;
							_tmp1061_ = vala_generic_type_get_type_parameter (_tmp1060_);
							_tmp1062_ = _tmp1061_;
							_tmp1063_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1062_);
							_tmp1064_ = _tmp1063_;
							_tmp1058_ = VALA_IS_TYPESYMBOL (_tmp1064_);
						} else {
							_tmp1058_ = FALSE;
						}
						if (_tmp1058_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1065_;
						_tmp1065_ = member;
						if (VALA_IS_PROPERTY (_tmp1065_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1066_;
							ValaProperty* _tmp1067_;
							ValaProperty* _tmp1068_;
							ValaProperty* _tmp1069_;
							ValaProperty* _tmp1070_;
							ValaProperty* _tmp1086_;
							ValaSymbolAccessibility _tmp1087_;
							ValaSymbolAccessibility _tmp1088_;
							gboolean _tmp1089_;
							gboolean _tmp1090_;
							ValaProperty* _tmp1155_;
							ValaMemberBinding _tmp1156_;
							ValaMemberBinding _tmp1157_;
							ValaProperty* _tmp1158_;
							ValaDataType* _tmp1159_;
							ValaDataType* _tmp1160_;
							_tmp1066_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1066_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1067_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1067_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1068_ = prop;
							_tmp1069_ = vala_property_get_base_property (_tmp1068_);
							_tmp1070_ = _tmp1069_;
							if (_tmp1070_ != NULL) {
								ValaProperty* _tmp1071_;
								ValaProperty* _tmp1072_;
								ValaProperty* _tmp1073_;
								ValaProperty* _tmp1074_;
								ValaSymbol* _tmp1075_;
								ValaSymbol* _tmp1076_;
								_tmp1071_ = prop;
								_tmp1072_ = vala_property_get_base_property (_tmp1071_);
								_tmp1073_ = _tmp1072_;
								prop = _tmp1073_;
								_tmp1074_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1074_);
								_tmp1075_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1076_ = _tmp1075_;
								member = _tmp1076_;
							} else {
								ValaProperty* _tmp1077_;
								ValaProperty* _tmp1078_;
								ValaProperty* _tmp1079_;
								_tmp1077_ = prop;
								_tmp1078_ = vala_property_get_base_interface_property (_tmp1077_);
								_tmp1079_ = _tmp1078_;
								if (_tmp1079_ != NULL) {
									ValaProperty* _tmp1080_;
									ValaProperty* _tmp1081_;
									ValaProperty* _tmp1082_;
									ValaProperty* _tmp1083_;
									ValaSymbol* _tmp1084_;
									ValaSymbol* _tmp1085_;
									_tmp1080_ = prop;
									_tmp1081_ = vala_property_get_base_interface_property (_tmp1080_);
									_tmp1082_ = _tmp1081_;
									prop = _tmp1082_;
									_tmp1083_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1083_);
									_tmp1084_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1085_ = _tmp1084_;
									member = _tmp1085_;
								}
							}
							_tmp1086_ = prop;
							_tmp1087_ = vala_symbol_get_access ((ValaSymbol*) _tmp1086_);
							_tmp1088_ = _tmp1087_;
							access = _tmp1088_;
							_tmp1089_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1090_ = _tmp1089_;
							if (_tmp1090_) {
								ValaProperty* _tmp1091_;
								ValaPropertyAccessor* _tmp1092_;
								ValaPropertyAccessor* _tmp1093_;
								ValaProperty* _tmp1101_;
								ValaSymbolAccessibility _tmp1102_;
								ValaSymbolAccessibility _tmp1103_;
								_tmp1091_ = prop;
								_tmp1092_ = vala_property_get_set_accessor (_tmp1091_);
								_tmp1093_ = _tmp1092_;
								if (_tmp1093_ == NULL) {
									ValaSourceReference* _tmp1094_;
									ValaSourceReference* _tmp1095_;
									ValaProperty* _tmp1096_;
									gchar* _tmp1097_;
									gchar* _tmp1098_;
									gchar* _tmp1099_;
									gchar* _tmp1100_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1094_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1095_ = _tmp1094_;
									_tmp1096_ = prop;
									_tmp1097_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1096_);
									_tmp1098_ = _tmp1097_;
									_tmp1099_ = g_strdup_printf ("Property `%s' is read-only", _tmp1098_);
									_tmp1100_ = _tmp1099_;
									vala_report_error (_tmp1095_, _tmp1100_);
									_g_free0 (_tmp1100_);
									_g_free0 (_tmp1098_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1101_ = prop;
								_tmp1102_ = vala_symbol_get_access ((ValaSymbol*) _tmp1101_);
								_tmp1103_ = _tmp1102_;
								if (_tmp1103_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1104_;
									ValaPropertyAccessor* _tmp1105_;
									ValaPropertyAccessor* _tmp1106_;
									ValaSymbolAccessibility _tmp1107_;
									ValaSymbolAccessibility _tmp1108_;
									_tmp1104_ = prop;
									_tmp1105_ = vala_property_get_set_accessor (_tmp1104_);
									_tmp1106_ = _tmp1105_;
									_tmp1107_ = vala_symbol_get_access ((ValaSymbol*) _tmp1106_);
									_tmp1108_ = _tmp1107_;
									access = _tmp1108_;
								} else {
									gboolean _tmp1109_ = FALSE;
									ValaProperty* _tmp1110_;
									ValaSymbolAccessibility _tmp1111_;
									ValaSymbolAccessibility _tmp1112_;
									_tmp1110_ = prop;
									_tmp1111_ = vala_symbol_get_access ((ValaSymbol*) _tmp1110_);
									_tmp1112_ = _tmp1111_;
									if (_tmp1112_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1113_;
										ValaPropertyAccessor* _tmp1114_;
										ValaPropertyAccessor* _tmp1115_;
										ValaSymbolAccessibility _tmp1116_;
										ValaSymbolAccessibility _tmp1117_;
										_tmp1113_ = prop;
										_tmp1114_ = vala_property_get_set_accessor (_tmp1113_);
										_tmp1115_ = _tmp1114_;
										_tmp1116_ = vala_symbol_get_access ((ValaSymbol*) _tmp1115_);
										_tmp1117_ = _tmp1116_;
										_tmp1109_ = _tmp1117_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1109_ = FALSE;
									}
									if (_tmp1109_) {
										ValaProperty* _tmp1118_;
										ValaPropertyAccessor* _tmp1119_;
										ValaPropertyAccessor* _tmp1120_;
										ValaSymbolAccessibility _tmp1121_;
										ValaSymbolAccessibility _tmp1122_;
										_tmp1118_ = prop;
										_tmp1119_ = vala_property_get_set_accessor (_tmp1118_);
										_tmp1120_ = _tmp1119_;
										_tmp1121_ = vala_symbol_get_access ((ValaSymbol*) _tmp1120_);
										_tmp1122_ = _tmp1121_;
										access = _tmp1122_;
									}
								}
							} else {
								ValaProperty* _tmp1123_;
								ValaPropertyAccessor* _tmp1124_;
								ValaPropertyAccessor* _tmp1125_;
								ValaProperty* _tmp1133_;
								ValaSymbolAccessibility _tmp1134_;
								ValaSymbolAccessibility _tmp1135_;
								_tmp1123_ = prop;
								_tmp1124_ = vala_property_get_get_accessor (_tmp1123_);
								_tmp1125_ = _tmp1124_;
								if (_tmp1125_ == NULL) {
									ValaSourceReference* _tmp1126_;
									ValaSourceReference* _tmp1127_;
									ValaProperty* _tmp1128_;
									gchar* _tmp1129_;
									gchar* _tmp1130_;
									gchar* _tmp1131_;
									gchar* _tmp1132_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1126_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1127_ = _tmp1126_;
									_tmp1128_ = prop;
									_tmp1129_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1128_);
									_tmp1130_ = _tmp1129_;
									_tmp1131_ = g_strdup_printf ("Property `%s' is write-only", _tmp1130_);
									_tmp1132_ = _tmp1131_;
									vala_report_error (_tmp1127_, _tmp1132_);
									_g_free0 (_tmp1132_);
									_g_free0 (_tmp1130_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1133_ = prop;
								_tmp1134_ = vala_symbol_get_access ((ValaSymbol*) _tmp1133_);
								_tmp1135_ = _tmp1134_;
								if (_tmp1135_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1136_;
									ValaPropertyAccessor* _tmp1137_;
									ValaPropertyAccessor* _tmp1138_;
									ValaSymbolAccessibility _tmp1139_;
									ValaSymbolAccessibility _tmp1140_;
									_tmp1136_ = prop;
									_tmp1137_ = vala_property_get_get_accessor (_tmp1136_);
									_tmp1138_ = _tmp1137_;
									_tmp1139_ = vala_symbol_get_access ((ValaSymbol*) _tmp1138_);
									_tmp1140_ = _tmp1139_;
									access = _tmp1140_;
								} else {
									gboolean _tmp1141_ = FALSE;
									ValaProperty* _tmp1142_;
									ValaSymbolAccessibility _tmp1143_;
									ValaSymbolAccessibility _tmp1144_;
									_tmp1142_ = prop;
									_tmp1143_ = vala_symbol_get_access ((ValaSymbol*) _tmp1142_);
									_tmp1144_ = _tmp1143_;
									if (_tmp1144_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1145_;
										ValaPropertyAccessor* _tmp1146_;
										ValaPropertyAccessor* _tmp1147_;
										ValaSymbolAccessibility _tmp1148_;
										ValaSymbolAccessibility _tmp1149_;
										_tmp1145_ = prop;
										_tmp1146_ = vala_property_get_get_accessor (_tmp1145_);
										_tmp1147_ = _tmp1146_;
										_tmp1148_ = vala_symbol_get_access ((ValaSymbol*) _tmp1147_);
										_tmp1149_ = _tmp1148_;
										_tmp1141_ = _tmp1149_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1141_ = FALSE;
									}
									if (_tmp1141_) {
										ValaProperty* _tmp1150_;
										ValaPropertyAccessor* _tmp1151_;
										ValaPropertyAccessor* _tmp1152_;
										ValaSymbolAccessibility _tmp1153_;
										ValaSymbolAccessibility _tmp1154_;
										_tmp1150_ = prop;
										_tmp1151_ = vala_property_get_get_accessor (_tmp1150_);
										_tmp1152_ = _tmp1151_;
										_tmp1153_ = vala_symbol_get_access ((ValaSymbol*) _tmp1152_);
										_tmp1154_ = _tmp1153_;
										access = _tmp1154_;
									}
								}
							}
							_tmp1155_ = prop;
							_tmp1156_ = vala_property_get_binding (_tmp1155_);
							_tmp1157_ = _tmp1156_;
							instance = _tmp1157_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1158_ = prop;
							_tmp1159_ = vala_property_get_property_type (_tmp1158_);
							_tmp1160_ = _tmp1159_;
							if (VALA_IS_GENERIC_TYPE (_tmp1160_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1161_;
							_tmp1161_ = member;
							if (VALA_IS_SIGNAL (_tmp1161_)) {
								ValaSymbol* _tmp1162_;
								ValaSymbolAccessibility _tmp1163_;
								ValaSymbolAccessibility _tmp1164_;
								instance = TRUE;
								_tmp1162_ = member;
								_tmp1163_ = vala_symbol_get_access (_tmp1162_);
								_tmp1164_ = _tmp1163_;
								access = _tmp1164_;
							} else {
								gboolean _tmp1165_ = FALSE;
								gboolean _tmp1166_;
								_tmp1166_ = self->priv->_creation_member;
								if (!_tmp1166_) {
									ValaSymbol* _tmp1167_;
									_tmp1167_ = member;
									_tmp1165_ = VALA_IS_ERROR_CODE (_tmp1167_);
								} else {
									_tmp1165_ = FALSE;
								}
								if (_tmp1165_) {
									ValaSymbol* _tmp1168_;
									ValaConstant* _tmp1169_;
									ValaConstant* _tmp1170_;
									ValaSymbol* _tmp1171_;
									ValaSymbol* _tmp1172_;
									_tmp1168_ = member;
									_tmp1169_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1168_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1170_ = _tmp1169_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1170_);
									_tmp1171_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1172_ = _tmp1171_;
									member = _tmp1172_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1173_;
		ValaSymbol* _tmp1174_;
		ValaCodeNode* _tmp1175_;
		ValaCodeNode* _tmp1176_;
		ValaCodeNode* _tmp1177_;
		gboolean _tmp1178_ = FALSE;
		ValaCodeNode* _tmp1179_;
		_tmp1173_ = parent;
		_tmp1174_ = member;
		if (!(_tmp1173_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1174_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1175_ = parent;
		_tmp1176_ = vala_code_node_get_parent_node (_tmp1175_);
		_tmp1177_ = _tmp1176_;
		parent = _tmp1177_;
		_tmp1179_ = parent;
		if (_tmp1179_ == NULL) {
			_tmp1178_ = TRUE;
		} else {
			ValaCodeNode* _tmp1180_;
			ValaSymbol* _tmp1181_;
			_tmp1180_ = parent;
			_tmp1181_ = member;
			_tmp1178_ = _tmp1180_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1181_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1178_) {
			break;
		}
	}
	_tmp1182_ = parent;
	_tmp1183_ = member;
	if (_tmp1182_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1183_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1184_;
		_tmp1184_ = member;
		vala_symbol_set_used (_tmp1184_, TRUE);
	}
	_tmp1185_ = member;
	_tmp1186_ = vala_symbol_get_version (_tmp1185_);
	_tmp1187_ = _tmp1186_;
	_tmp1188_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1189_ = _tmp1188_;
	vala_version_attribute_check (_tmp1187_, context, _tmp1189_);
	_tmp1191_ = access;
	if (_tmp1191_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1192_;
		ValaSymbol* _tmp1193_;
		ValaSymbol* _tmp1194_;
		_tmp1192_ = member;
		_tmp1193_ = vala_symbol_get_parent_symbol (_tmp1192_);
		_tmp1194_ = _tmp1193_;
		_tmp1190_ = VALA_IS_TYPESYMBOL (_tmp1194_);
	} else {
		_tmp1190_ = FALSE;
	}
	if (_tmp1190_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1195_;
		ValaSymbol* _tmp1196_;
		ValaSymbol* _tmp1197_;
		gboolean in_subtype = FALSE;
		_tmp1195_ = member;
		_tmp1196_ = vala_symbol_get_parent_symbol (_tmp1195_);
		_tmp1197_ = _tmp1196_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1197_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1198_;
			ValaSemanticAnalyzer* _tmp1199_;
			ValaSymbol* _tmp1200_;
			ValaSymbol* _tmp1201_;
			ValaSymbol* _tmp1202_;
			_tmp1198_ = vala_code_context_get_analyzer (context);
			_tmp1199_ = _tmp1198_;
			_tmp1200_ = vala_semantic_analyzer_get_current_symbol (_tmp1199_);
			_tmp1201_ = _tmp1200_;
			_tmp1202_ = _vala_code_node_ref0 (_tmp1201_);
			this_symbol = _tmp1202_;
			{
				gboolean _tmp1203_ = FALSE;
				_tmp1203_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1208_;
					ValaSymbol* _tmp1209_;
					ValaTypeSymbol* _tmp1210_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1211_;
					gboolean _tmp1212_ = FALSE;
					ValaClass* _tmp1213_;
					if (!_tmp1203_) {
						ValaSymbol* _tmp1204_;
						ValaSymbol* _tmp1205_;
						ValaSymbol* _tmp1206_;
						ValaSymbol* _tmp1207_;
						_tmp1204_ = this_symbol;
						_tmp1205_ = vala_symbol_get_parent_symbol (_tmp1204_);
						_tmp1206_ = _tmp1205_;
						_tmp1207_ = _vala_code_node_ref0 (_tmp1206_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1207_;
					}
					_tmp1203_ = FALSE;
					_tmp1208_ = this_symbol;
					if (!(_tmp1208_ != NULL)) {
						break;
					}
					_tmp1209_ = this_symbol;
					_tmp1210_ = target_type;
					if (_tmp1209_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1210_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1211_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1211_) ? ((ValaClass*) _tmp1211_) : NULL;
					_tmp1213_ = cl;
					if (_tmp1213_ != NULL) {
						ValaClass* _tmp1214_;
						ValaTypeSymbol* _tmp1215_;
						_tmp1214_ = cl;
						_tmp1215_ = target_type;
						_tmp1212_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1214_, _tmp1215_);
					} else {
						_tmp1212_ = FALSE;
					}
					if (_tmp1212_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1216_;
			ValaSourceReference* _tmp1217_;
			ValaSymbol* _tmp1218_;
			gchar* _tmp1219_;
			gchar* _tmp1220_;
			gchar* _tmp1221_;
			gchar* _tmp1222_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1216_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1217_ = _tmp1216_;
			_tmp1218_ = member;
			_tmp1219_ = vala_symbol_get_full_name (_tmp1218_);
			_tmp1220_ = _tmp1219_;
			_tmp1221_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1220_);
			_tmp1222_ = _tmp1221_;
			vala_report_error (_tmp1217_, _tmp1222_);
			_g_free0 (_tmp1222_);
			_g_free0 (_tmp1220_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1223_;
		_tmp1223_ = access;
		if (_tmp1223_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1224_;
			ValaSymbol* _tmp1225_;
			ValaSymbol* _tmp1226_;
			gboolean in_target_type = FALSE;
			_tmp1224_ = member;
			_tmp1225_ = vala_symbol_get_parent_symbol (_tmp1224_);
			_tmp1226_ = _tmp1225_;
			target_type = _tmp1226_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1227_;
				ValaSemanticAnalyzer* _tmp1228_;
				ValaSymbol* _tmp1229_;
				ValaSymbol* _tmp1230_;
				ValaSymbol* _tmp1231_;
				_tmp1227_ = vala_code_context_get_analyzer (context);
				_tmp1228_ = _tmp1227_;
				_tmp1229_ = vala_semantic_analyzer_get_current_symbol (_tmp1228_);
				_tmp1230_ = _tmp1229_;
				_tmp1231_ = _vala_code_node_ref0 (_tmp1230_);
				this_symbol = _tmp1231_;
				{
					gboolean _tmp1232_ = FALSE;
					_tmp1232_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1237_;
						ValaSymbol* _tmp1238_;
						ValaSymbol* _tmp1239_;
						if (!_tmp1232_) {
							ValaSymbol* _tmp1233_;
							ValaSymbol* _tmp1234_;
							ValaSymbol* _tmp1235_;
							ValaSymbol* _tmp1236_;
							_tmp1233_ = this_symbol;
							_tmp1234_ = vala_symbol_get_parent_symbol (_tmp1233_);
							_tmp1235_ = _tmp1234_;
							_tmp1236_ = _vala_code_node_ref0 (_tmp1235_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1236_;
						}
						_tmp1232_ = FALSE;
						_tmp1237_ = this_symbol;
						if (!(_tmp1237_ != NULL)) {
							break;
						}
						_tmp1238_ = target_type;
						_tmp1239_ = this_symbol;
						if (_tmp1238_ == _tmp1239_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1240_;
				ValaSourceReference* _tmp1241_;
				ValaSymbol* _tmp1242_;
				gchar* _tmp1243_;
				gchar* _tmp1244_;
				gchar* _tmp1245_;
				gchar* _tmp1246_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1240_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1241_ = _tmp1240_;
				_tmp1242_ = member;
				_tmp1243_ = vala_symbol_get_full_name (_tmp1242_);
				_tmp1244_ = _tmp1243_;
				_tmp1245_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1244_);
				_tmp1246_ = _tmp1245_;
				vala_report_error (_tmp1241_, _tmp1246_);
				_g_free0 (_tmp1246_);
				_g_free0 (_tmp1244_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1248_;
		ValaExpression* _tmp1249_;
		_tmp1248_ = vala_member_access_get_inner (self);
		_tmp1249_ = _tmp1248_;
		_tmp1247_ = _tmp1249_ != NULL;
	} else {
		_tmp1247_ = FALSE;
	}
	if (_tmp1247_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1250_;
		ValaExpression* _tmp1251_;
		ValaDataType* _tmp1252_;
		ValaDataType* _tmp1253_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1254_;
		ValaExpression* _tmp1255_;
		ValaDataType* _tmp1256_;
		ValaDataType* _tmp1257_;
		ValaPointerType* _tmp1258_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1262_;
		gboolean _tmp1263_ = FALSE;
		gboolean _tmp1264_ = FALSE;
		ValaObjectType* _tmp1265_;
		_tmp1250_ = vala_member_access_get_inner (self);
		_tmp1251_ = _tmp1250_;
		_tmp1252_ = vala_expression_get_value_type (_tmp1251_);
		_tmp1253_ = _tmp1252_;
		instance_type = _tmp1253_;
		_tmp1254_ = vala_member_access_get_inner (self);
		_tmp1255_ = _tmp1254_;
		_tmp1256_ = vala_expression_get_value_type (_tmp1255_);
		_tmp1257_ = _tmp1256_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1257_) ? ((ValaPointerType*) _tmp1257_) : NULL;
		_tmp1258_ = pointer_type;
		if (_tmp1258_ != NULL) {
			ValaPointerType* _tmp1259_;
			ValaDataType* _tmp1260_;
			ValaDataType* _tmp1261_;
			_tmp1259_ = pointer_type;
			_tmp1260_ = vala_pointer_type_get_base_type (_tmp1259_);
			_tmp1261_ = _tmp1260_;
			instance_type = _tmp1261_;
		}
		_tmp1262_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1262_) ? ((ValaObjectType*) _tmp1262_) : NULL;
		_tmp1265_ = object_type;
		if (_tmp1265_ != NULL) {
			ValaObjectType* _tmp1266_;
			ValaObjectTypeSymbol* _tmp1267_;
			ValaObjectTypeSymbol* _tmp1268_;
			_tmp1266_ = object_type;
			_tmp1267_ = vala_object_type_get_object_type_symbol (_tmp1266_);
			_tmp1268_ = _tmp1267_;
			_tmp1264_ = vala_object_type_symbol_has_type_parameters (_tmp1268_);
		} else {
			_tmp1264_ = FALSE;
		}
		if (_tmp1264_) {
			ValaDataType* _tmp1269_;
			_tmp1269_ = instance_type;
			_tmp1263_ = !vala_data_type_has_type_arguments (_tmp1269_);
		} else {
			_tmp1263_ = FALSE;
		}
		if (_tmp1263_) {
			ValaExpression* _tmp1270_;
			ValaExpression* _tmp1271_;
			ValaSourceReference* _tmp1272_;
			ValaSourceReference* _tmp1273_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1270_ = vala_member_access_get_inner (self);
			_tmp1271_ = _tmp1270_;
			_tmp1272_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1271_);
			_tmp1273_ = _tmp1272_;
			vala_report_error (_tmp1273_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1275_ = !may_access_instance_members;
	} else {
		_tmp1275_ = FALSE;
	}
	if (_tmp1275_) {
		_tmp1274_ = TRUE;
	} else {
		gboolean _tmp1276_ = FALSE;
		if (klass) {
			_tmp1276_ = !may_access_klass_members;
		} else {
			_tmp1276_ = FALSE;
		}
		_tmp1274_ = _tmp1276_;
	}
	if (_tmp1274_) {
		ValaSymbol* _tmp1277_;
		ValaSymbol* _tmp1278_;
		ValaDataType* _tmp1301_;
		ValaDataType* _tmp1302_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1277_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1278_ = _tmp1277_;
		if (VALA_IS_METHOD (_tmp1278_)) {
			ValaSemanticAnalyzer* _tmp1279_;
			ValaSemanticAnalyzer* _tmp1280_;
			ValaSymbol* _tmp1281_;
			ValaSymbol* _tmp1282_;
			gboolean _tmp1283_;
			gboolean _tmp1284_;
			ValaDataType* _tmp1285_;
			ValaDataType* _tmp1286_;
			_tmp1279_ = vala_code_context_get_analyzer (context);
			_tmp1280_ = _tmp1279_;
			_tmp1281_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1282_ = _tmp1281_;
			_tmp1283_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1284_ = _tmp1283_;
			_tmp1285_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1280_, _tmp1282_, _tmp1284_);
			_tmp1286_ = _tmp1285_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1286_);
			_vala_code_node_unref0 (_tmp1286_);
		} else {
			ValaSymbol* _tmp1287_;
			ValaSymbol* _tmp1288_;
			_tmp1287_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1288_ = _tmp1287_;
			if (VALA_IS_FIELD (_tmp1288_)) {
				ValaSymbol* _tmp1289_;
				ValaSymbol* _tmp1290_;
				ValaFieldPrototype* _tmp1291_;
				ValaFieldPrototype* _tmp1292_;
				_tmp1289_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1290_ = _tmp1289_;
				_tmp1291_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1290_, VALA_TYPE_FIELD, ValaField));
				_tmp1292_ = _tmp1291_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1292_);
				_vala_code_node_unref0 (_tmp1292_);
			} else {
				ValaSymbol* _tmp1293_;
				ValaSymbol* _tmp1294_;
				_tmp1293_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1294_ = _tmp1293_;
				if (VALA_IS_PROPERTY (_tmp1294_)) {
					ValaSymbol* _tmp1295_;
					ValaSymbol* _tmp1296_;
					ValaPropertyPrototype* _tmp1297_;
					ValaPropertyPrototype* _tmp1298_;
					_tmp1295_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1296_ = _tmp1295_;
					_tmp1297_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1296_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1298_ = _tmp1297_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1298_);
					_vala_code_node_unref0 (_tmp1298_);
				} else {
					ValaInvalidType* _tmp1299_;
					ValaInvalidType* _tmp1300_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1299_ = vala_invalid_type_new ();
					_tmp1300_ = _tmp1299_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1300_);
					_vala_code_node_unref0 (_tmp1300_);
				}
			}
		}
		_tmp1301_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1302_ = _tmp1301_;
		if (_tmp1302_ != NULL) {
			ValaDataType* _tmp1303_;
			ValaDataType* _tmp1304_;
			ValaDataType* _tmp1305_;
			ValaDataType* _tmp1306_;
			gboolean _tmp1307_;
			gboolean _tmp1308_;
			_tmp1303_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1304_ = _tmp1303_;
			_tmp1305_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1306_ = _tmp1305_;
			_tmp1307_ = vala_data_type_get_value_owned (_tmp1306_);
			_tmp1308_ = _tmp1307_;
			vala_data_type_set_value_owned (_tmp1304_, _tmp1308_);
		}
	} else {
		gboolean _tmp1309_ = FALSE;
		gboolean _tmp1330_ = FALSE;
		gboolean _tmp1331_ = FALSE;
		gboolean _tmp1332_ = FALSE;
		gboolean _tmp1333_ = FALSE;
		gboolean _tmp1375_ = FALSE;
		gboolean _tmp1376_ = FALSE;
		gboolean _tmp1377_ = FALSE;
		gboolean _tmp1378_ = FALSE;
		gboolean _tmp1379_ = FALSE;
		gboolean _tmp1380_;
		gboolean _tmp1381_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1408_;
		ValaSymbol* _tmp1409_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1410_;
		ValaExpression* _tmp1411_;
		gboolean _tmp1412_ = FALSE;
		gboolean _tmp1413_ = FALSE;
		gboolean _tmp1414_ = FALSE;
		gboolean _tmp1415_ = FALSE;
		gboolean _tmp1416_ = FALSE;
		ValaMethod* _tmp1417_;
		ValaSemanticAnalyzer* _tmp1456_;
		ValaSemanticAnalyzer* _tmp1457_;
		ValaSymbol* _tmp1458_;
		ValaSymbol* _tmp1459_;
		gboolean _tmp1460_;
		gboolean _tmp1461_;
		ValaDataType* _tmp1462_;
		ValaDataType* _tmp1463_;
		gboolean _tmp1464_ = FALSE;
		ValaExpression* _tmp1465_;
		ValaExpression* _tmp1466_;
		ValaSymbol* _tmp1479_;
		ValaSymbol* _tmp1480_;
		if (instance) {
			ValaExpression* _tmp1310_;
			ValaExpression* _tmp1311_;
			_tmp1310_ = vala_member_access_get_inner (self);
			_tmp1311_ = _tmp1310_;
			_tmp1309_ = _tmp1311_ == NULL;
		} else {
			_tmp1309_ = FALSE;
		}
		if (_tmp1309_) {
			ValaSourceReference* _tmp1312_;
			ValaSourceReference* _tmp1313_;
			ValaMemberAccess* _tmp1314_;
			ValaMemberAccess* _tmp1315_;
			ValaExpression* _tmp1316_;
			ValaExpression* _tmp1317_;
			ValaParameter* _tmp1318_;
			ValaDataType* _tmp1319_;
			ValaDataType* _tmp1320_;
			ValaDataType* _tmp1321_;
			ValaDataType* _tmp1322_;
			ValaExpression* _tmp1323_;
			ValaExpression* _tmp1324_;
			ValaDataType* _tmp1325_;
			ValaDataType* _tmp1326_;
			ValaExpression* _tmp1327_;
			ValaExpression* _tmp1328_;
			ValaParameter* _tmp1329_;
			_tmp1312_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1313_ = _tmp1312_;
			_tmp1314_ = vala_member_access_new (NULL, "this", _tmp1313_);
			_tmp1315_ = _tmp1314_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1315_);
			_vala_code_node_unref0 (_tmp1315_);
			_tmp1316_ = vala_member_access_get_inner (self);
			_tmp1317_ = _tmp1316_;
			_tmp1318_ = this_parameter;
			_tmp1319_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1318_);
			_tmp1320_ = _tmp1319_;
			_tmp1321_ = vala_data_type_copy (_tmp1320_);
			_tmp1322_ = _tmp1321_;
			vala_expression_set_value_type (_tmp1317_, _tmp1322_);
			_vala_code_node_unref0 (_tmp1322_);
			_tmp1323_ = vala_member_access_get_inner (self);
			_tmp1324_ = _tmp1323_;
			_tmp1325_ = vala_expression_get_value_type (_tmp1324_);
			_tmp1326_ = _tmp1325_;
			vala_data_type_set_value_owned (_tmp1326_, FALSE);
			_tmp1327_ = vala_member_access_get_inner (self);
			_tmp1328_ = _tmp1327_;
			_tmp1329_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1328_, (ValaSymbol*) _tmp1329_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1333_ = !klass;
		} else {
			_tmp1333_ = FALSE;
		}
		if (_tmp1333_) {
			ValaSymbol* _tmp1334_;
			ValaSymbol* _tmp1335_;
			_tmp1334_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1335_ = _tmp1334_;
			_tmp1332_ = !VALA_IS_CREATION_METHOD (_tmp1335_);
		} else {
			_tmp1332_ = FALSE;
		}
		if (_tmp1332_) {
			_tmp1331_ = may_access_instance_members;
		} else {
			_tmp1331_ = FALSE;
		}
		if (_tmp1331_) {
			ValaExpression* _tmp1336_;
			ValaExpression* _tmp1337_;
			_tmp1336_ = vala_member_access_get_inner (self);
			_tmp1337_ = _tmp1336_;
			_tmp1330_ = _tmp1337_ != NULL;
		} else {
			_tmp1330_ = FALSE;
		}
		if (_tmp1330_) {
			ValaExpression* _tmp1338_;
			ValaExpression* _tmp1339_;
			ValaSymbol* _tmp1340_;
			ValaSymbol* _tmp1341_;
			_tmp1338_ = vala_member_access_get_inner (self);
			_tmp1339_ = _tmp1338_;
			_tmp1340_ = vala_expression_get_symbol_reference (_tmp1339_);
			_tmp1341_ = _tmp1340_;
			if (VALA_IS_METHOD (_tmp1341_)) {
			} else {
				ValaSourceReference* _tmp1342_;
				ValaSourceReference* _tmp1343_;
				ValaSymbol* _tmp1344_;
				ValaSymbol* _tmp1345_;
				gchar* _tmp1346_;
				gchar* _tmp1347_;
				gchar* _tmp1348_;
				gchar* _tmp1349_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1350_;
				ValaSymbol* _tmp1351_;
				ValaSymbol* _tmp1352_;
				ValaSymbol* _tmp1353_;
				ValaMemberAccess* inner_ma = NULL;
				ValaExpression* _tmp1373_;
				ValaExpression* _tmp1374_;
				_tmp1342_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1343_ = _tmp1342_;
				_tmp1344_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1345_ = _tmp1344_;
				_tmp1346_ = vala_symbol_get_full_name (_tmp1345_);
				_tmp1347_ = _tmp1346_;
				_tmp1348_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1347_);
				_tmp1349_ = _tmp1348_;
				vala_report_warning (_tmp1343_, _tmp1349_);
				_g_free0 (_tmp1349_);
				_g_free0 (_tmp1347_);
				_tmp1350_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1351_ = _tmp1350_;
				_tmp1352_ = vala_symbol_get_parent_symbol (_tmp1351_);
				_tmp1353_ = _tmp1352_;
				inner_sym = _tmp1353_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1354_ = FALSE;
					ValaSymbol* _tmp1355_;
					ValaMemberAccess* _tmp1359_;
					ValaSymbol* _tmp1360_;
					const gchar* _tmp1361_;
					const gchar* _tmp1362_;
					ValaSourceReference* _tmp1363_;
					ValaSourceReference* _tmp1364_;
					ValaMemberAccess* _tmp1365_;
					ValaMemberAccess* _tmp1366_;
					ValaMemberAccess* _tmp1367_;
					ValaExpression* _tmp1368_;
					ValaExpression* _tmp1369_;
					ValaSymbol* _tmp1370_;
					ValaSymbol* _tmp1371_;
					ValaSymbol* _tmp1372_;
					_tmp1355_ = inner_sym;
					if (_tmp1355_ != NULL) {
						ValaSymbol* _tmp1356_;
						const gchar* _tmp1357_;
						const gchar* _tmp1358_;
						_tmp1356_ = inner_sym;
						_tmp1357_ = vala_symbol_get_name (_tmp1356_);
						_tmp1358_ = _tmp1357_;
						_tmp1354_ = _tmp1358_ != NULL;
					} else {
						_tmp1354_ = FALSE;
					}
					if (!_tmp1354_) {
						break;
					}
					_tmp1359_ = inner_ma;
					_tmp1360_ = inner_sym;
					_tmp1361_ = vala_symbol_get_name (_tmp1360_);
					_tmp1362_ = _tmp1361_;
					_tmp1363_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1364_ = _tmp1363_;
					_tmp1365_ = vala_member_access_new (NULL, _tmp1362_, _tmp1364_);
					_tmp1366_ = _tmp1365_;
					vala_member_access_set_inner (_tmp1359_, (ValaExpression*) _tmp1366_);
					_vala_code_node_unref0 (_tmp1366_);
					_tmp1367_ = inner_ma;
					_tmp1368_ = vala_member_access_get_inner (_tmp1367_);
					_tmp1369_ = _tmp1368_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1369_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1370_ = inner_sym;
					_tmp1371_ = vala_symbol_get_parent_symbol (_tmp1370_);
					_tmp1372_ = _tmp1371_;
					inner_sym = _tmp1372_;
				}
				_tmp1373_ = vala_member_access_get_inner (self);
				_tmp1374_ = _tmp1373_;
				vala_code_node_check ((ValaCodeNode*) _tmp1374_, context);
			}
		}
		_tmp1380_ = vala_code_context_get_experimental_non_null (context);
		_tmp1381_ = _tmp1380_;
		if (_tmp1381_) {
			_tmp1379_ = instance;
		} else {
			_tmp1379_ = FALSE;
		}
		if (_tmp1379_) {
			ValaExpression* _tmp1382_;
			ValaExpression* _tmp1383_;
			ValaDataType* _tmp1384_;
			ValaDataType* _tmp1385_;
			gboolean _tmp1386_;
			gboolean _tmp1387_;
			_tmp1382_ = vala_member_access_get_inner (self);
			_tmp1383_ = _tmp1382_;
			_tmp1384_ = vala_expression_get_value_type (_tmp1383_);
			_tmp1385_ = _tmp1384_;
			_tmp1386_ = vala_data_type_get_nullable (_tmp1385_);
			_tmp1387_ = _tmp1386_;
			_tmp1378_ = _tmp1387_;
		} else {
			_tmp1378_ = FALSE;
		}
		if (_tmp1378_) {
			ValaExpression* _tmp1388_;
			ValaExpression* _tmp1389_;
			ValaDataType* _tmp1390_;
			ValaDataType* _tmp1391_;
			_tmp1388_ = vala_member_access_get_inner (self);
			_tmp1389_ = _tmp1388_;
			_tmp1390_ = vala_expression_get_value_type (_tmp1389_);
			_tmp1391_ = _tmp1390_;
			_tmp1377_ = !VALA_IS_POINTER_TYPE (_tmp1391_);
		} else {
			_tmp1377_ = FALSE;
		}
		if (_tmp1377_) {
			ValaExpression* _tmp1392_;
			ValaExpression* _tmp1393_;
			ValaDataType* _tmp1394_;
			ValaDataType* _tmp1395_;
			_tmp1392_ = vala_member_access_get_inner (self);
			_tmp1393_ = _tmp1392_;
			_tmp1394_ = vala_expression_get_value_type (_tmp1393_);
			_tmp1395_ = _tmp1394_;
			_tmp1376_ = !VALA_IS_GENERIC_TYPE (_tmp1395_);
		} else {
			_tmp1376_ = FALSE;
		}
		if (_tmp1376_) {
			ValaExpression* _tmp1396_;
			ValaExpression* _tmp1397_;
			ValaDataType* _tmp1398_;
			ValaDataType* _tmp1399_;
			_tmp1396_ = vala_member_access_get_inner (self);
			_tmp1397_ = _tmp1396_;
			_tmp1398_ = vala_expression_get_value_type (_tmp1397_);
			_tmp1399_ = _tmp1398_;
			_tmp1375_ = !VALA_IS_ARRAY_TYPE (_tmp1399_);
		} else {
			_tmp1375_ = FALSE;
		}
		if (_tmp1375_) {
			ValaSourceReference* _tmp1400_;
			ValaSourceReference* _tmp1401_;
			ValaSymbol* _tmp1402_;
			ValaSymbol* _tmp1403_;
			gchar* _tmp1404_;
			gchar* _tmp1405_;
			gchar* _tmp1406_;
			gchar* _tmp1407_;
			_tmp1400_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1401_ = _tmp1400_;
			_tmp1402_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1403_ = _tmp1402_;
			_tmp1404_ = vala_symbol_get_full_name (_tmp1403_);
			_tmp1405_ = _tmp1404_;
			_tmp1406_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1405_);
			_tmp1407_ = _tmp1406_;
			vala_report_error (_tmp1401_, _tmp1407_);
			_g_free0 (_tmp1407_);
			_g_free0 (_tmp1405_);
		}
		_tmp1408_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1409_ = _tmp1408_;
		m = VALA_IS_METHOD (_tmp1409_) ? ((ValaMethod*) _tmp1409_) : NULL;
		_tmp1410_ = vala_member_access_get_inner (self);
		_tmp1411_ = _tmp1410_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1411_) ? ((ValaMemberAccess*) _tmp1411_) : NULL;
		_tmp1417_ = m;
		if (_tmp1417_ != NULL) {
			ValaMethod* _tmp1418_;
			ValaMemberBinding _tmp1419_;
			ValaMemberBinding _tmp1420_;
			_tmp1418_ = m;
			_tmp1419_ = vala_method_get_binding (_tmp1418_);
			_tmp1420_ = _tmp1419_;
			_tmp1416_ = _tmp1420_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1416_ = FALSE;
		}
		if (_tmp1416_) {
			ValaMethod* _tmp1421_;
			ValaSymbol* _tmp1422_;
			ValaSymbol* _tmp1423_;
			_tmp1421_ = m;
			_tmp1422_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1421_);
			_tmp1423_ = _tmp1422_;
			_tmp1415_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1423_);
		} else {
			_tmp1415_ = FALSE;
		}
		if (_tmp1415_) {
			ValaExpression* _tmp1424_;
			ValaExpression* _tmp1425_;
			_tmp1424_ = vala_member_access_get_inner (self);
			_tmp1425_ = _tmp1424_;
			_tmp1414_ = _tmp1425_ != NULL;
		} else {
			_tmp1414_ = FALSE;
		}
		if (_tmp1414_) {
			ValaExpression* _tmp1426_;
			ValaExpression* _tmp1427_;
			ValaDataType* _tmp1428_;
			ValaDataType* _tmp1429_;
			_tmp1426_ = vala_member_access_get_inner (self);
			_tmp1427_ = _tmp1426_;
			_tmp1428_ = vala_expression_get_value_type (_tmp1427_);
			_tmp1429_ = _tmp1428_;
			_tmp1413_ = _tmp1429_ == NULL;
		} else {
			_tmp1413_ = FALSE;
		}
		if (_tmp1413_) {
			ValaMemberAccess* _tmp1430_;
			ValaList* _tmp1431_;
			gint _tmp1432_;
			gint _tmp1433_;
			_tmp1430_ = inner_ma;
			_tmp1431_ = _tmp1430_->priv->type_argument_list;
			_tmp1432_ = vala_collection_get_size ((ValaCollection*) _tmp1431_);
			_tmp1433_ = _tmp1432_;
			_tmp1412_ = _tmp1433_ > 0;
		} else {
			_tmp1412_ = FALSE;
		}
		if (_tmp1412_) {
			ValaExpression* _tmp1434_;
			ValaExpression* _tmp1435_;
			ValaMethod* _tmp1436_;
			ValaSymbol* _tmp1437_;
			ValaSymbol* _tmp1438_;
			ValaObjectType* _tmp1439_;
			ValaObjectType* _tmp1440_;
			_tmp1434_ = vala_member_access_get_inner (self);
			_tmp1435_ = _tmp1434_;
			_tmp1436_ = m;
			_tmp1437_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1436_);
			_tmp1438_ = _tmp1437_;
			_tmp1439_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1438_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1440_ = _tmp1439_;
			vala_expression_set_value_type (_tmp1435_, (ValaDataType*) _tmp1440_);
			_vala_code_node_unref0 (_tmp1440_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1441_;
				ValaList* _tmp1442_;
				ValaList* _tmp1443_;
				gint _type_argument_size = 0;
				ValaList* _tmp1444_;
				gint _tmp1445_;
				gint _tmp1446_;
				gint _type_argument_index = 0;
				_tmp1441_ = inner_ma;
				_tmp1442_ = _tmp1441_->priv->type_argument_list;
				_tmp1443_ = _vala_iterable_ref0 (_tmp1442_);
				_type_argument_list = _tmp1443_;
				_tmp1444_ = _type_argument_list;
				_tmp1445_ = vala_collection_get_size ((ValaCollection*) _tmp1444_);
				_tmp1446_ = _tmp1445_;
				_type_argument_size = _tmp1446_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1447_;
					gint _tmp1448_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1449_;
					gpointer _tmp1450_;
					ValaExpression* _tmp1451_;
					ValaExpression* _tmp1452_;
					ValaDataType* _tmp1453_;
					ValaDataType* _tmp1454_;
					ValaDataType* _tmp1455_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1447_ = _type_argument_index;
					_tmp1448_ = _type_argument_size;
					if (!(_tmp1447_ < _tmp1448_)) {
						break;
					}
					_tmp1449_ = _type_argument_list;
					_tmp1450_ = vala_list_get (_tmp1449_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1450_;
					_tmp1451_ = vala_member_access_get_inner (self);
					_tmp1452_ = _tmp1451_;
					_tmp1453_ = vala_expression_get_value_type (_tmp1452_);
					_tmp1454_ = _tmp1453_;
					_tmp1455_ = type_argument;
					vala_data_type_add_type_argument (_tmp1454_, _tmp1455_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1456_ = vala_code_context_get_analyzer (context);
		_tmp1457_ = _tmp1456_;
		_tmp1458_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1459_ = _tmp1458_;
		_tmp1460_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1461_ = _tmp1460_;
		_tmp1462_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1457_, _tmp1459_, _tmp1461_);
		_tmp1463_ = _tmp1462_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1463_);
		_vala_code_node_unref0 (_tmp1463_);
		_tmp1465_ = vala_member_access_get_inner (self);
		_tmp1466_ = _tmp1465_;
		if (_tmp1466_ != NULL) {
			ValaDataType* _tmp1467_;
			ValaDataType* _tmp1468_;
			_tmp1467_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1468_ = _tmp1467_;
			_tmp1464_ = _tmp1468_ != NULL;
		} else {
			_tmp1464_ = FALSE;
		}
		if (_tmp1464_) {
			ValaDataType* _tmp1469_;
			ValaDataType* _tmp1470_;
			ValaExpression* _tmp1471_;
			ValaExpression* _tmp1472_;
			ValaDataType* _tmp1473_;
			ValaDataType* _tmp1474_;
			ValaDataType* _tmp1475_;
			ValaDataType* _tmp1476_;
			_tmp1469_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1470_ = _tmp1469_;
			_tmp1471_ = vala_member_access_get_inner (self);
			_tmp1472_ = _tmp1471_;
			_tmp1473_ = vala_expression_get_value_type (_tmp1472_);
			_tmp1474_ = _tmp1473_;
			_tmp1475_ = vala_data_type_get_actual_type (_tmp1470_, _tmp1474_, NULL, (ValaCodeNode*) self);
			_tmp1476_ = _tmp1475_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1476_);
			_vala_code_node_unref0 (_tmp1476_);
		} else {
			ValaDataType* _tmp1477_;
			ValaDataType* _tmp1478_;
			_tmp1477_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1478_ = _tmp1477_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1478_);
		}
		_tmp1479_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1480_ = _tmp1479_;
		if (VALA_IS_METHOD (_tmp1480_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1481_;
			ValaSymbol* _tmp1482_;
			ValaDataType* _tmp1483_;
			ValaDataType* _tmp1484_;
			gboolean _tmp1491_ = FALSE;
			_tmp1481_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1482_ = _tmp1481_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1482_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1483_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1484_ = _tmp1483_;
			if (_tmp1484_ != NULL) {
				ValaDataType* _tmp1485_;
				ValaDataType* _tmp1486_;
				ValaDataType* _tmp1487_;
				ValaDataType* _tmp1488_;
				gboolean _tmp1489_;
				gboolean _tmp1490_;
				_tmp1485_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1486_ = _tmp1485_;
				_tmp1487_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1488_ = _tmp1487_;
				_tmp1489_ = vala_data_type_get_value_owned (_tmp1488_);
				_tmp1490_ = _tmp1489_;
				vala_data_type_set_value_owned (_tmp1486_, _tmp1490_);
			}
			if (instance) {
				ValaMethod* _tmp1492_;
				ValaSymbol* _tmp1493_;
				ValaSymbol* _tmp1494_;
				_tmp1492_ = method;
				_tmp1493_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1492_);
				_tmp1494_ = _tmp1493_;
				_tmp1491_ = VALA_IS_TYPESYMBOL (_tmp1494_);
			} else {
				_tmp1491_ = FALSE;
			}
			if (_tmp1491_) {
				ValaExpression* _tmp1495_;
				ValaExpression* _tmp1496_;
				ValaMethod* _tmp1497_;
				ValaSymbol* _tmp1498_;
				ValaSymbol* _tmp1499_;
				ValaDataType* _tmp1500_;
				ValaDataType* _tmp1501_;
				ValaExpression* _tmp1502_;
				ValaExpression* _tmp1503_;
				ValaDataType* _tmp1504_;
				ValaDataType* _tmp1505_;
				ValaMethod* _tmp1506_;
				ValaParameter* _tmp1507_;
				ValaParameter* _tmp1508_;
				ValaDataType* _tmp1509_;
				ValaDataType* _tmp1510_;
				gboolean _tmp1511_;
				gboolean _tmp1512_;
				_tmp1495_ = vala_member_access_get_inner (self);
				_tmp1496_ = _tmp1495_;
				_tmp1497_ = method;
				_tmp1498_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1497_);
				_tmp1499_ = _tmp1498_;
				_tmp1500_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1499_);
				_tmp1501_ = _tmp1500_;
				vala_expression_set_target_type (_tmp1496_, _tmp1501_);
				_vala_code_node_unref0 (_tmp1501_);
				_tmp1502_ = vala_member_access_get_inner (self);
				_tmp1503_ = _tmp1502_;
				_tmp1504_ = vala_expression_get_target_type (_tmp1503_);
				_tmp1505_ = _tmp1504_;
				_tmp1506_ = method;
				_tmp1507_ = vala_method_get_this_parameter (_tmp1506_);
				_tmp1508_ = _tmp1507_;
				_tmp1509_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1508_);
				_tmp1510_ = _tmp1509_;
				_tmp1511_ = vala_data_type_get_value_owned (_tmp1510_);
				_tmp1512_ = _tmp1511_;
				vala_data_type_set_value_owned (_tmp1505_, _tmp1512_);
			}
		} else {
			gboolean _tmp1513_ = FALSE;
			gboolean _tmp1514_ = FALSE;
			ValaSymbol* _tmp1515_;
			ValaSymbol* _tmp1516_;
			_tmp1515_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1516_ = _tmp1515_;
			if (VALA_IS_PROPERTY (_tmp1516_)) {
				_tmp1514_ = instance;
			} else {
				_tmp1514_ = FALSE;
			}
			if (_tmp1514_) {
				ValaSymbol* _tmp1517_;
				ValaSymbol* _tmp1518_;
				ValaSymbol* _tmp1519_;
				ValaSymbol* _tmp1520_;
				_tmp1517_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1518_ = _tmp1517_;
				_tmp1519_ = vala_symbol_get_parent_symbol (_tmp1518_);
				_tmp1520_ = _tmp1519_;
				_tmp1513_ = _tmp1520_ != NULL;
			} else {
				_tmp1513_ = FALSE;
			}
			if (_tmp1513_) {
				ValaExpression* _tmp1521_;
				ValaExpression* _tmp1522_;
				ValaSymbol* _tmp1523_;
				ValaSymbol* _tmp1524_;
				ValaSymbol* _tmp1525_;
				ValaSymbol* _tmp1526_;
				ValaDataType* _tmp1527_;
				ValaDataType* _tmp1528_;
				_tmp1521_ = vala_member_access_get_inner (self);
				_tmp1522_ = _tmp1521_;
				_tmp1523_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1524_ = _tmp1523_;
				_tmp1525_ = vala_symbol_get_parent_symbol (_tmp1524_);
				_tmp1526_ = _tmp1525_;
				_tmp1527_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1526_);
				_tmp1528_ = _tmp1527_;
				vala_expression_set_target_type (_tmp1522_, _tmp1528_);
				_vala_code_node_unref0 (_tmp1528_);
			} else {
				gboolean _tmp1529_ = FALSE;
				gboolean _tmp1530_ = FALSE;
				gboolean _tmp1531_ = FALSE;
				ValaSymbol* _tmp1532_;
				ValaSymbol* _tmp1533_;
				_tmp1532_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1533_ = _tmp1532_;
				if (VALA_IS_FIELD (_tmp1533_)) {
					_tmp1531_ = TRUE;
				} else {
					ValaSymbol* _tmp1534_;
					ValaSymbol* _tmp1535_;
					_tmp1534_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1535_ = _tmp1534_;
					_tmp1531_ = VALA_IS_SIGNAL (_tmp1535_);
				}
				if (_tmp1531_) {
					_tmp1530_ = instance;
				} else {
					_tmp1530_ = FALSE;
				}
				if (_tmp1530_) {
					ValaSymbol* _tmp1536_;
					ValaSymbol* _tmp1537_;
					ValaSymbol* _tmp1538_;
					ValaSymbol* _tmp1539_;
					_tmp1536_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1537_ = _tmp1536_;
					_tmp1538_ = vala_symbol_get_parent_symbol (_tmp1537_);
					_tmp1539_ = _tmp1538_;
					_tmp1529_ = _tmp1539_ != NULL;
				} else {
					_tmp1529_ = FALSE;
				}
				if (_tmp1529_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1540_;
					ValaSymbol* _tmp1541_;
					ValaSymbol* _tmp1542_;
					ValaSymbol* _tmp1543_;
					ValaDataType* _tmp1544_;
					ValaExpression* _tmp1545_;
					ValaExpression* _tmp1546_;
					ValaDataType* _tmp1547_;
					ValaExpression* _tmp1548_;
					ValaExpression* _tmp1549_;
					ValaDataType* _tmp1550_;
					ValaDataType* _tmp1551_;
					ValaDataType* _tmp1552_;
					ValaDataType* _tmp1553_;
					_tmp1540_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1541_ = _tmp1540_;
					_tmp1542_ = vala_symbol_get_parent_symbol (_tmp1541_);
					_tmp1543_ = _tmp1542_;
					_tmp1544_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1543_);
					parent_type = _tmp1544_;
					_tmp1545_ = vala_member_access_get_inner (self);
					_tmp1546_ = _tmp1545_;
					_tmp1547_ = parent_type;
					_tmp1548_ = vala_member_access_get_inner (self);
					_tmp1549_ = _tmp1548_;
					_tmp1550_ = vala_expression_get_value_type (_tmp1549_);
					_tmp1551_ = _tmp1550_;
					_tmp1552_ = vala_data_type_get_actual_type (_tmp1547_, _tmp1551_, NULL, (ValaCodeNode*) self);
					_tmp1553_ = _tmp1552_;
					vala_expression_set_target_type (_tmp1546_, _tmp1553_);
					_vala_code_node_unref0 (_tmp1553_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
	}
	_tmp1554_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1555_ = _tmp1554_;
	if (_tmp1555_ != NULL) {
		ValaDataType* _tmp1556_;
		ValaDataType* _tmp1557_;
		_tmp1556_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1557_ = _tmp1556_;
		vala_code_node_check ((ValaCodeNode*) _tmp1557_, context);
	}
	_tmp1558_ = self->priv->_tainted_access;
	if (!_tmp1558_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1559_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1560_ = _tmp1559_;
	result = !_tmp1560_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result = 0;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

