/* treebuilder.c generated by valac, the Vala compiler
 * generated from treebuilder.vala, do not modify */

/* treebuilder.vala
 *
 * Copyright (C) 2011  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include <vala.h>
#include <glib-object.h>
#include <valagee.h>
#include <valadoc.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valacodegen.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define VALADOC_TYPE_TREE_BUILDER (valadoc_tree_builder_get_type ())
#define VALADOC_TREE_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALADOC_TYPE_TREE_BUILDER, ValadocTreeBuilder))
#define VALADOC_TREE_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALADOC_TYPE_TREE_BUILDER, ValadocTreeBuilderClass))
#define VALADOC_IS_TREE_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALADOC_TYPE_TREE_BUILDER))
#define VALADOC_IS_TREE_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALADOC_TYPE_TREE_BUILDER))
#define VALADOC_TREE_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALADOC_TYPE_TREE_BUILDER, ValadocTreeBuilderClass))

typedef struct _ValadocTreeBuilder ValadocTreeBuilder;
typedef struct _ValadocTreeBuilderClass ValadocTreeBuilderClass;
typedef struct _ValadocTreeBuilderPrivate ValadocTreeBuilderPrivate;

#define VALADOC_TREE_BUILDER_TYPE_PACKAGE_META_DATA (valadoc_tree_builder_package_meta_data_get_type ())
#define VALADOC_TREE_BUILDER_PACKAGE_META_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALADOC_TREE_BUILDER_TYPE_PACKAGE_META_DATA, ValadocTreeBuilderPackageMetaData))
#define VALADOC_TREE_BUILDER_PACKAGE_META_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALADOC_TREE_BUILDER_TYPE_PACKAGE_META_DATA, ValadocTreeBuilderPackageMetaDataClass))
#define VALADOC_TREE_BUILDER_IS_PACKAGE_META_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALADOC_TREE_BUILDER_TYPE_PACKAGE_META_DATA))
#define VALADOC_TREE_BUILDER_IS_PACKAGE_META_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALADOC_TREE_BUILDER_TYPE_PACKAGE_META_DATA))
#define VALADOC_TREE_BUILDER_PACKAGE_META_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALADOC_TREE_BUILDER_TYPE_PACKAGE_META_DATA, ValadocTreeBuilderPackageMetaDataClass))

typedef struct _ValadocTreeBuilderPackageMetaData ValadocTreeBuilderPackageMetaData;
typedef struct _ValadocTreeBuilderPackageMetaDataClass ValadocTreeBuilderPackageMetaDataClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _valadoc_tree_builder_package_meta_data_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_tree_builder_package_meta_data_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _valadoc_api_tree_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_tree_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _valadoc_api_source_comment_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_source_comment_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _vala_map_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_iterator_unref (var), NULL)))
typedef struct _ValadocTreeBuilderPackageMetaDataPrivate ValadocTreeBuilderPackageMetaDataPrivate;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
typedef struct _ValadocTreeBuilderParamSpecPackageMetaData ValadocTreeBuilderParamSpecPackageMetaData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocTreeBuilder {
	ValaCodeVisitor parent_instance;
	ValadocTreeBuilderPrivate * priv;
};

struct _ValadocTreeBuilderClass {
	ValaCodeVisitorClass parent_class;
};

struct _ValadocTreeBuilderPrivate {
	ValaArrayList* packages;
	ValadocTreeBuilderPackageMetaData* source_package;
	ValaHashMap* files;
	ValaHashMap* symbol_map;
	ValadocErrorReporter* reporter;
	ValadocSettings* settings;
	ValadocApiNode* current_node;
	ValadocApiTree* tree;
	ValadocApiClass* glib_error;
};

struct _ValadocTreeBuilderPackageMetaData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValadocApiPackage* package;
	ValaHashMap* namespaces;
	ValaArrayList* files;
	ValadocTreeBuilderPackageMetaDataPrivate * priv;
};

struct _ValadocTreeBuilderPackageMetaDataClass {
	GTypeClass parent_class;
	void (*finalize) (ValadocTreeBuilderPackageMetaData *self);
};

struct _ValadocTreeBuilderParamSpecPackageMetaData {
	GParamSpec parent_instance;
};

static gint ValadocTreeBuilder_private_offset;
static gpointer valadoc_tree_builder_parent_class = NULL;
static gpointer valadoc_tree_builder_package_meta_data_parent_class = NULL;

GType valadoc_tree_builder_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValadocTreeBuilder, vala_code_visitor_unref)
static gpointer valadoc_tree_builder_package_meta_data_ref (gpointer instance);
static void valadoc_tree_builder_package_meta_data_unref (gpointer instance);
static GParamSpec* valadoc_tree_builder_param_spec_package_meta_data (const gchar* name,
                                                               const gchar* nick,
                                                               const gchar* blurb,
                                                               GType object_type,
                                                               GParamFlags flags) G_GNUC_UNUSED;
static void valadoc_tree_builder_value_set_package_meta_data (GValue* value,
                                                       gpointer v_object) G_GNUC_UNUSED;
static void valadoc_tree_builder_value_take_package_meta_data (GValue* value,
                                                        gpointer v_object) G_GNUC_UNUSED;
static gpointer valadoc_tree_builder_value_get_package_meta_data (const GValue* value) G_GNUC_UNUSED;
static GType valadoc_tree_builder_package_meta_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValadocTreeBuilderPackageMetaData, valadoc_tree_builder_package_meta_data_unref)
ValadocApiClass* valadoc_tree_builder_get_glib_error (ValadocTreeBuilder* self);
ValaHashMap* valadoc_tree_builder_get_symbol_map (ValadocTreeBuilder* self);
static ValadocApiPointer* valadoc_tree_builder_create_pointer (ValadocTreeBuilder* self,
                                                        ValaPointerType* vtyperef,
                                                        ValadocApiItem* parent,
                                                        ValadocApiNode* caller);
static ValadocApiArray* valadoc_tree_builder_create_array (ValadocTreeBuilder* self,
                                                    ValaArrayType* vtyperef,
                                                    ValadocApiItem* parent,
                                                    ValadocApiNode* caller);
static ValadocApiTypeReference* valadoc_tree_builder_create_type_reference (ValadocTreeBuilder* self,
                                                                     ValaDataType* vtyperef,
                                                                     ValadocApiItem* parent,
                                                                     ValadocApiNode* caller);
static void valadoc_tree_builder_process_attributes (ValadocTreeBuilder* self,
                                              ValadocApiSymbol* parent,
                                              GList* lst);
static ValadocApiSourceComment* valadoc_tree_builder_create_comment (ValadocTreeBuilder* self,
                                                              ValaComment* comment);
static gchar* valadoc_tree_builder_get_method_name (ValadocTreeBuilder* self,
                                             ValaMethod* element);
static ValadocTreeBuilderPackageMetaData* valadoc_tree_builder_get_package_meta_data (ValadocTreeBuilder* self,
                                                                               ValadocApiPackage* pkg);
static ValadocTreeBuilderPackageMetaData* valadoc_tree_builder_register_package (ValadocTreeBuilder* self,
                                                                          ValadocApiPackage* package);
static ValadocTreeBuilderPackageMetaData* valadoc_tree_builder_package_meta_data_new (ValadocApiPackage* package);
static ValadocTreeBuilderPackageMetaData* valadoc_tree_builder_package_meta_data_construct (GType object_type,
                                                                                     ValadocApiPackage* package);
static ValadocApiSourceFile* valadoc_tree_builder_register_source_file (ValadocTreeBuilder* self,
                                                                 ValadocTreeBuilderPackageMetaData* meta_data,
                                                                 ValaSourceFile* source_file);
static void valadoc_tree_builder_package_meta_data_register_source_file (ValadocTreeBuilderPackageMetaData* self,
                                                                  ValaSourceFile* file);
static ValadocApiSourceFile* valadoc_tree_builder_get_source_file (ValadocTreeBuilder* self,
                                                            ValaSymbol* symbol);
static ValadocApiPackage* valadoc_tree_builder_find_package_for_file (ValadocTreeBuilder* self,
                                                               ValaSourceFile* source_file);
static gboolean valadoc_tree_builder_package_meta_data_is_package_for_file (ValadocTreeBuilderPackageMetaData* self,
                                                                     ValaSourceFile* source_file);
static ValadocApiNamespace* valadoc_tree_builder_get_namespace (ValadocTreeBuilder* self,
                                                         ValadocApiPackage* pkg,
                                                         ValaSymbol* symbol,
                                                         ValadocApiSourceFile* file);
static ValadocApiNamespace* valadoc_tree_builder_package_meta_data_get_namespace (ValadocTreeBuilderPackageMetaData* self,
                                                                           ValaNamespace* vns,
                                                                           ValadocApiSourceFile* file);
static gchar* valadoc_tree_builder_get_package_name (ValadocTreeBuilder* self,
                                              const gchar* path);
static gboolean valadoc_tree_builder_add_package (ValadocTreeBuilder* self,
                                           ValaCodeContext* context,
                                           const gchar* pkg);
static void valadoc_tree_builder_add_deps (ValadocTreeBuilder* self,
                                    ValaCodeContext* context,
                                    const gchar* file_path,
                                    const gchar* pkg_name);
static void valadoc_tree_builder_add_depencies (ValadocTreeBuilder* self,
                                         ValaCodeContext* context,
                                         gchar** packages,
                                         gint packages_length1);
static void valadoc_tree_builder_add_documented_files (ValadocTreeBuilder* self,
                                                ValaCodeContext* context,
                                                gchar** sources,
                                                gint sources_length1);
static void valadoc_tree_builder_create_valac_tree (ValadocTreeBuilder* self,
                                             ValaCodeContext* context,
                                             ValadocSettings* settings);
static void valadoc_tree_builder_process_children (ValadocTreeBuilder* self,
                                            ValadocApiNode* node,
                                            ValaCodeNode* element);
static ValadocApiNode* valadoc_tree_builder_get_parent_node_for (ValadocTreeBuilder* self,
                                                          ValaSymbol* element);
static void valadoc_tree_builder_real_visit_namespace (ValaCodeVisitor* base,
                                                ValaNamespace* element);
static void valadoc_tree_builder_real_visit_class (ValaCodeVisitor* base,
                                            ValaClass* element);
static void valadoc_tree_builder_real_visit_interface (ValaCodeVisitor* base,
                                                ValaInterface* element);
static void valadoc_tree_builder_real_visit_struct (ValaCodeVisitor* base,
                                             ValaStruct* element);
static void valadoc_tree_builder_real_visit_field (ValaCodeVisitor* base,
                                            ValaField* element);
static void valadoc_tree_builder_real_visit_property (ValaCodeVisitor* base,
                                               ValaProperty* element);
static void valadoc_tree_builder_real_visit_creation_method (ValaCodeVisitor* base,
                                                      ValaCreationMethod* element);
static void valadoc_tree_builder_real_visit_method (ValaCodeVisitor* base,
                                             ValaMethod* element);
static void valadoc_tree_builder_real_visit_signal (ValaCodeVisitor* base,
                                             ValaSignal* element);
static void valadoc_tree_builder_real_visit_delegate (ValaCodeVisitor* base,
                                               ValaDelegate* element);
static void valadoc_tree_builder_real_visit_enum (ValaCodeVisitor* base,
                                           ValaEnum* element);
static void valadoc_tree_builder_real_visit_enum_value (ValaCodeVisitor* base,
                                                 ValaEnumValue* element);
static void valadoc_tree_builder_real_visit_constant (ValaCodeVisitor* base,
                                               ValaConstant* element);
static void valadoc_tree_builder_real_visit_error_domain (ValaCodeVisitor* base,
                                                   ValaErrorDomain* element);
static void valadoc_tree_builder_real_visit_error_code (ValaCodeVisitor* base,
                                                 ValaErrorCode* element);
static void valadoc_tree_builder_real_visit_type_parameter (ValaCodeVisitor* base,
                                                     ValaTypeParameter* element);
static void valadoc_tree_builder_real_visit_formal_parameter (ValaCodeVisitor* base,
                                                       ValaParameter* element);
ValadocApiTree* valadoc_tree_builder_build (ValadocTreeBuilder* self,
                                            ValadocSettings* settings,
                                            ValadocErrorReporter* reporter);
ValadocTreeBuilder* valadoc_tree_builder_new (void);
ValadocTreeBuilder* valadoc_tree_builder_construct (GType object_type);
static void valadoc_tree_builder_package_meta_data_finalize (ValadocTreeBuilderPackageMetaData * obj);
static void valadoc_tree_builder_finalize (ValaCodeVisitor * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
valadoc_tree_builder_get_instance_private (ValadocTreeBuilder* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocTreeBuilder_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ValadocApiClass*
valadoc_tree_builder_get_glib_error (ValadocTreeBuilder* self)
{
	ValadocApiClass* _tmp0_;
	ValadocApiClass* _tmp1_;
	ValadocApiClass* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->glib_error;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

ValaHashMap*
valadoc_tree_builder_get_symbol_map (ValadocTreeBuilder* self)
{
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	ValaHashMap* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->symbol_map;
	_tmp1_ = _vala_map_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static ValadocApiPointer*
valadoc_tree_builder_create_pointer (ValadocTreeBuilder* self,
                                     ValaPointerType* vtyperef,
                                     ValadocApiItem* parent,
                                     ValadocApiNode* caller)
{
	ValadocApiPointer* ptr = NULL;
	ValadocApiPointer* _tmp0_;
	ValaDataType* vntype = NULL;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaDataType* _tmp4_;
	ValadocApiPointer* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (vtyperef != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (caller != NULL, NULL);
	_tmp0_ = valadoc_api_pointer_new (parent, vtyperef);
	ptr = _tmp0_;
	_tmp1_ = vala_pointer_type_get_base_type (vtyperef);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_code_node_ref0 (_tmp2_);
	vntype = _tmp3_;
	_tmp4_ = vntype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_POINTER_TYPE)) {
		ValadocApiPointer* _tmp5_;
		ValaDataType* _tmp6_;
		ValadocApiPointer* _tmp7_;
		ValadocApiPointer* _tmp8_;
		ValadocApiPointer* _tmp9_;
		_tmp5_ = ptr;
		_tmp6_ = vntype;
		_tmp7_ = ptr;
		_tmp8_ = valadoc_tree_builder_create_pointer (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_POINTER_TYPE, ValaPointerType), (ValadocApiItem*) _tmp7_, caller);
		_tmp9_ = _tmp8_;
		valadoc_api_pointer_set_data_type (_tmp5_, (ValadocApiItem*) _tmp9_);
		_g_object_unref0 (_tmp9_);
	} else {
		ValaDataType* _tmp10_;
		_tmp10_ = vntype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_ARRAY_TYPE)) {
			ValadocApiPointer* _tmp11_;
			ValaDataType* _tmp12_;
			ValadocApiPointer* _tmp13_;
			ValadocApiArray* _tmp14_;
			ValadocApiArray* _tmp15_;
			_tmp11_ = ptr;
			_tmp12_ = vntype;
			_tmp13_ = ptr;
			_tmp14_ = valadoc_tree_builder_create_array (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), (ValadocApiItem*) _tmp13_, caller);
			_tmp15_ = _tmp14_;
			valadoc_api_pointer_set_data_type (_tmp11_, (ValadocApiItem*) _tmp15_);
			_g_object_unref0 (_tmp15_);
		} else {
			ValadocApiPointer* _tmp16_;
			ValaDataType* _tmp17_;
			ValadocApiPointer* _tmp18_;
			ValadocApiTypeReference* _tmp19_;
			ValadocApiTypeReference* _tmp20_;
			_tmp16_ = ptr;
			_tmp17_ = vntype;
			_tmp18_ = ptr;
			_tmp19_ = valadoc_tree_builder_create_type_reference (self, _tmp17_, (ValadocApiItem*) _tmp18_, caller);
			_tmp20_ = _tmp19_;
			valadoc_api_pointer_set_data_type (_tmp16_, (ValadocApiItem*) _tmp20_);
			_g_object_unref0 (_tmp20_);
		}
	}
	result = ptr;
	_vala_code_node_unref0 (vntype);
	return result;
}

static ValadocApiArray*
valadoc_tree_builder_create_array (ValadocTreeBuilder* self,
                                   ValaArrayType* vtyperef,
                                   ValadocApiItem* parent,
                                   ValadocApiNode* caller)
{
	ValadocApiArray* arr = NULL;
	ValadocApiArray* _tmp0_;
	ValaDataType* vntype = NULL;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaDataType* _tmp4_;
	ValadocApiArray* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (vtyperef != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (caller != NULL, NULL);
	_tmp0_ = valadoc_api_array_new (parent, vtyperef);
	arr = _tmp0_;
	_tmp1_ = vala_array_type_get_element_type (vtyperef);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_code_node_ref0 (_tmp2_);
	vntype = _tmp3_;
	_tmp4_ = vntype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ARRAY_TYPE)) {
		ValadocApiArray* _tmp5_;
		ValaDataType* _tmp6_;
		ValadocApiArray* _tmp7_;
		ValadocApiArray* _tmp8_;
		ValadocApiArray* _tmp9_;
		_tmp5_ = arr;
		_tmp6_ = vntype;
		_tmp7_ = arr;
		_tmp8_ = valadoc_tree_builder_create_array (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_ARRAY_TYPE, ValaArrayType), (ValadocApiItem*) _tmp7_, caller);
		_tmp9_ = _tmp8_;
		valadoc_api_array_set_data_type (_tmp5_, (ValadocApiItem*) _tmp9_);
		_g_object_unref0 (_tmp9_);
	} else {
		ValadocApiArray* _tmp10_;
		ValaDataType* _tmp11_;
		ValadocApiArray* _tmp12_;
		ValadocApiTypeReference* _tmp13_;
		ValadocApiTypeReference* _tmp14_;
		_tmp10_ = arr;
		_tmp11_ = vntype;
		_tmp12_ = arr;
		_tmp13_ = valadoc_tree_builder_create_type_reference (self, _tmp11_, (ValadocApiItem*) _tmp12_, caller);
		_tmp14_ = _tmp13_;
		valadoc_api_array_set_data_type (_tmp10_, (ValadocApiItem*) _tmp14_);
		_g_object_unref0 (_tmp14_);
	}
	result = arr;
	_vala_code_node_unref0 (vntype);
	return result;
}

static ValadocApiTypeReference*
valadoc_tree_builder_create_type_reference (ValadocTreeBuilder* self,
                                            ValaDataType* vtyperef,
                                            ValadocApiItem* parent,
                                            ValadocApiNode* caller)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean is_nullable = FALSE;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* signature = NULL;
	gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean is_dynamic = FALSE;
	ValadocApiTypeReference* type_ref = NULL;
	const gchar* _tmp16_;
	ValadocApiTypeReference* _tmp17_;
	ValadocApiTypeReference* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (caller != NULL, NULL);
	if (vtyperef != NULL) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = vala_data_type_get_nullable (vtyperef);
		_tmp4_ = _tmp3_;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = !G_TYPE_CHECK_INSTANCE_TYPE (vtyperef, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !G_TYPE_CHECK_INSTANCE_TYPE (vtyperef, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp0_ = FALSE;
	}
	is_nullable = _tmp0_;
	if (vtyperef != NULL) {
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		_tmp7_ = vala_data_type_get_data_type (vtyperef);
		_tmp8_ = _tmp7_;
		_tmp6_ = _tmp8_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaTypeSymbol* _tmp9_;
		ValaTypeSymbol* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = vala_data_type_get_data_type (vtyperef);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_gvariant_module_get_dbus_signature ((ValaSymbol*) _tmp10_);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp11_;
	} else {
		_g_free0 (_tmp5_);
		_tmp5_ = NULL;
	}
	_tmp12_ = g_strdup (_tmp5_);
	signature = _tmp12_;
	if (vtyperef != NULL) {
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp14_ = vala_data_type_get_is_dynamic (vtyperef);
		_tmp15_ = _tmp14_;
		_tmp13_ = _tmp15_;
	} else {
		_tmp13_ = FALSE;
	}
	is_dynamic = _tmp13_;
	_tmp16_ = signature;
	_tmp17_ = valadoc_api_typereference_new (parent, is_dynamic, is_nullable, _tmp16_, vtyperef);
	type_ref = _tmp17_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (vtyperef, VALA_TYPE_POINTER_TYPE)) {
		ValadocApiTypeReference* _tmp18_;
		ValadocApiTypeReference* _tmp19_;
		ValadocApiPointer* _tmp20_;
		ValadocApiPointer* _tmp21_;
		_tmp18_ = type_ref;
		_tmp19_ = type_ref;
		_tmp20_ = valadoc_tree_builder_create_pointer (self, G_TYPE_CHECK_INSTANCE_CAST (vtyperef, VALA_TYPE_POINTER_TYPE, ValaPointerType), (ValadocApiItem*) _tmp19_, caller);
		_tmp21_ = _tmp20_;
		valadoc_api_typereference_set_data_type (_tmp18_, (ValadocApiItem*) _tmp21_);
		_g_object_unref0 (_tmp21_);
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (vtyperef, VALA_TYPE_ARRAY_TYPE)) {
			ValadocApiTypeReference* _tmp22_;
			ValadocApiTypeReference* _tmp23_;
			ValadocApiArray* _tmp24_;
			ValadocApiArray* _tmp25_;
			_tmp22_ = type_ref;
			_tmp23_ = type_ref;
			_tmp24_ = valadoc_tree_builder_create_array (self, G_TYPE_CHECK_INSTANCE_CAST (vtyperef, VALA_TYPE_ARRAY_TYPE, ValaArrayType), (ValadocApiItem*) _tmp23_, caller);
			_tmp25_ = _tmp24_;
			valadoc_api_typereference_set_data_type (_tmp22_, (ValadocApiItem*) _tmp25_);
			_g_object_unref0 (_tmp25_);
		}
	}
	if (vtyperef != NULL) {
		{
			ValaList* _vdtype_list = NULL;
			ValaList* _tmp26_;
			gint _vdtype_size = 0;
			ValaList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _vdtype_index = 0;
			_tmp26_ = vala_data_type_get_type_arguments (vtyperef);
			_vdtype_list = _tmp26_;
			_tmp27_ = _vdtype_list;
			_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
			_tmp29_ = _tmp28_;
			_vdtype_size = _tmp29_;
			_vdtype_index = -1;
			while (TRUE) {
				ValaDataType* vdtype = NULL;
				ValaList* _tmp30_;
				gpointer _tmp31_;
				ValadocApiTypeReference* type_param = NULL;
				ValaDataType* _tmp32_;
				ValadocApiTypeReference* _tmp33_;
				ValadocApiTypeReference* _tmp34_;
				ValadocApiTypeReference* _tmp35_;
				ValadocApiTypeReference* _tmp36_;
				_vdtype_index = _vdtype_index + 1;
				if (!(_vdtype_index < _vdtype_size)) {
					break;
				}
				_tmp30_ = _vdtype_list;
				_tmp31_ = vala_list_get (_tmp30_, _vdtype_index);
				vdtype = (ValaDataType*) _tmp31_;
				_tmp32_ = vdtype;
				_tmp33_ = type_ref;
				_tmp34_ = valadoc_tree_builder_create_type_reference (self, _tmp32_, (ValadocApiItem*) _tmp33_, caller);
				type_param = _tmp34_;
				_tmp35_ = type_ref;
				_tmp36_ = type_param;
				valadoc_api_typereference_add_type_argument (_tmp35_, _tmp36_);
				_g_object_unref0 (type_param);
				_vala_code_node_unref0 (vdtype);
			}
			_vala_iterable_unref0 (_vdtype_list);
		}
	}
	result = type_ref;
	_g_free0 (signature);
	_g_free0 (_tmp5_);
	return result;
}

static void
valadoc_tree_builder_process_attributes (ValadocTreeBuilder* self,
                                         ValadocApiSymbol* parent,
                                         GList* lst)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	{
		GList* att_collection = NULL;
		GList* att_it = NULL;
		att_collection = lst;
		for (att_it = att_collection; att_it != NULL; att_it = att_it->next) {
			ValaAttribute* _tmp0_;
			ValaAttribute* att = NULL;
			_tmp0_ = _vala_code_node_ref0 ((ValaAttribute*) att_it->data);
			att = _tmp0_;
			{
				ValadocApiAttribute* new_attribute = NULL;
				ValadocApiSourceFile* _tmp1_;
				ValadocApiSourceFile* _tmp2_;
				ValaAttribute* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				ValaAttribute* _tmp6_;
				ValadocApiAttribute* _tmp7_;
				ValadocApiAttribute* _tmp8_;
				ValadocApiAttribute* _tmp9_;
				_tmp1_ = valadoc_api_node_get_source_file ((ValadocApiNode*) parent);
				_tmp2_ = _tmp1_;
				_tmp3_ = att;
				_tmp4_ = vala_attribute_get_name (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = att;
				_tmp7_ = valadoc_api_attribute_new ((ValadocApiNode*) parent, _tmp2_, _tmp5_, _tmp6_);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp2_);
				new_attribute = _tmp8_;
				_tmp9_ = new_attribute;
				valadoc_api_symbol_add_attribute (parent, _tmp9_);
				_g_object_unref0 (new_attribute);
				_vala_code_node_unref0 (att);
			}
		}
	}
}

static gpointer
_vala_source_reference_ref0 (gpointer self)
{
	return self ? vala_source_reference_ref (self) : NULL;
}

static ValadocApiSourceComment*
valadoc_tree_builder_create_comment (ValadocTreeBuilder* self,
                                     ValaComment* comment)
{
	ValadocApiSourceComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (comment != NULL) {
		ValaSourceReference* pos = NULL;
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		ValadocApiSourceFile* file = NULL;
		ValaHashMap* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceFile* _tmp5_;
		ValaSourceFile* _tmp6_;
		gpointer _tmp7_;
		_tmp0_ = vala_comment_get_source_reference (comment);
		_tmp1_ = _tmp0_;
		_tmp2_ = _vala_source_reference_ref0 (_tmp1_);
		pos = _tmp2_;
		_tmp3_ = self->priv->files;
		_tmp4_ = pos;
		_tmp5_ = vala_source_reference_get_file (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_map_get ((ValaMap*) _tmp3_, _tmp6_);
		file = (ValadocApiSourceFile*) _tmp7_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (comment, VALA_TYPE_GIR_COMMENT)) {
			ValadocApiGirSourceComment* tmp = NULL;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			ValadocApiSourceFile* _tmp10_;
			ValaSourceReference* _tmp11_;
			ValaSourceLocation _tmp12_ = {0};
			ValaSourceLocation _tmp13_;
			ValaSourceReference* _tmp14_;
			ValaSourceLocation _tmp15_ = {0};
			ValaSourceLocation _tmp16_;
			ValaSourceReference* _tmp17_;
			ValaSourceLocation _tmp18_ = {0};
			ValaSourceLocation _tmp19_;
			ValaSourceReference* _tmp20_;
			ValaSourceLocation _tmp21_ = {0};
			ValaSourceLocation _tmp22_;
			ValadocApiGirSourceComment* _tmp23_;
			ValaComment* _tmp24_;
			ValaComment* _tmp25_;
			ValaMapIterator* it = NULL;
			ValaMapIterator* _tmp51_;
			_tmp8_ = vala_comment_get_content (comment);
			_tmp9_ = _tmp8_;
			_tmp10_ = file;
			_tmp11_ = pos;
			vala_source_reference_get_begin (_tmp11_, &_tmp12_);
			_tmp13_ = _tmp12_;
			_tmp14_ = pos;
			vala_source_reference_get_begin (_tmp14_, &_tmp15_);
			_tmp16_ = _tmp15_;
			_tmp17_ = pos;
			vala_source_reference_get_end (_tmp17_, &_tmp18_);
			_tmp19_ = _tmp18_;
			_tmp20_ = pos;
			vala_source_reference_get_end (_tmp20_, &_tmp21_);
			_tmp22_ = _tmp21_;
			_tmp23_ = valadoc_api_gir_source_comment_new (_tmp9_, _tmp10_, _tmp13_.line, _tmp16_.column, _tmp19_.line, _tmp22_.column);
			tmp = _tmp23_;
			_tmp24_ = vala_gir_comment_get_return_content (G_TYPE_CHECK_INSTANCE_CAST (comment, VALA_TYPE_GIR_COMMENT, ValaGirComment));
			_tmp25_ = _tmp24_;
			if (_tmp25_ != NULL) {
				ValaSourceReference* return_pos = NULL;
				ValaComment* _tmp26_;
				ValaComment* _tmp27_;
				ValaSourceReference* _tmp28_;
				ValaSourceReference* _tmp29_;
				ValaSourceReference* _tmp30_;
				ValadocApiGirSourceComment* _tmp31_;
				ValaComment* _tmp32_;
				ValaComment* _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				ValadocApiSourceFile* _tmp36_;
				ValaSourceReference* _tmp37_;
				ValaSourceLocation _tmp38_ = {0};
				ValaSourceLocation _tmp39_;
				ValaSourceReference* _tmp40_;
				ValaSourceLocation _tmp41_ = {0};
				ValaSourceLocation _tmp42_;
				ValaSourceReference* _tmp43_;
				ValaSourceLocation _tmp44_ = {0};
				ValaSourceLocation _tmp45_;
				ValaSourceReference* _tmp46_;
				ValaSourceLocation _tmp47_ = {0};
				ValaSourceLocation _tmp48_;
				ValadocApiSourceComment* _tmp49_;
				ValadocApiSourceComment* _tmp50_;
				_tmp26_ = vala_gir_comment_get_return_content (G_TYPE_CHECK_INSTANCE_CAST (comment, VALA_TYPE_GIR_COMMENT, ValaGirComment));
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_comment_get_source_reference (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = _vala_source_reference_ref0 (_tmp29_);
				return_pos = _tmp30_;
				_tmp31_ = tmp;
				_tmp32_ = vala_gir_comment_get_return_content (G_TYPE_CHECK_INSTANCE_CAST (comment, VALA_TYPE_GIR_COMMENT, ValaGirComment));
				_tmp33_ = _tmp32_;
				_tmp34_ = vala_comment_get_content (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = file;
				_tmp37_ = return_pos;
				vala_source_reference_get_begin (_tmp37_, &_tmp38_);
				_tmp39_ = _tmp38_;
				_tmp40_ = return_pos;
				vala_source_reference_get_begin (_tmp40_, &_tmp41_);
				_tmp42_ = _tmp41_;
				_tmp43_ = return_pos;
				vala_source_reference_get_end (_tmp43_, &_tmp44_);
				_tmp45_ = _tmp44_;
				_tmp46_ = return_pos;
				vala_source_reference_get_end (_tmp46_, &_tmp47_);
				_tmp48_ = _tmp47_;
				_tmp49_ = valadoc_api_source_comment_new (_tmp35_, _tmp36_, _tmp39_.line, _tmp42_.column, _tmp45_.line, _tmp48_.column);
				_tmp50_ = _tmp49_;
				valadoc_api_gir_source_comment_set_return_comment (_tmp31_, _tmp50_);
				_valadoc_api_source_comment_unref0 (_tmp50_);
				_vala_source_reference_unref0 (return_pos);
			}
			_tmp51_ = vala_gir_comment_parameter_iterator (G_TYPE_CHECK_INSTANCE_CAST (comment, VALA_TYPE_GIR_COMMENT, ValaGirComment));
			it = _tmp51_;
			while (TRUE) {
				ValaMapIterator* _tmp52_;
				ValaComment* vala_param = NULL;
				ValaMapIterator* _tmp53_;
				gpointer _tmp54_;
				ValaSourceReference* param_pos = NULL;
				ValaComment* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaSourceReference* _tmp57_;
				ValaSourceReference* _tmp58_;
				ValadocApiSourceComment* param_comment = NULL;
				ValaComment* _tmp59_;
				const gchar* _tmp60_;
				const gchar* _tmp61_;
				ValadocApiSourceFile* _tmp62_;
				ValaSourceReference* _tmp63_;
				ValaSourceLocation _tmp64_ = {0};
				ValaSourceLocation _tmp65_;
				ValaSourceReference* _tmp66_;
				ValaSourceLocation _tmp67_ = {0};
				ValaSourceLocation _tmp68_;
				ValaSourceReference* _tmp69_;
				ValaSourceLocation _tmp70_ = {0};
				ValaSourceLocation _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaSourceLocation _tmp73_ = {0};
				ValaSourceLocation _tmp74_;
				ValadocApiSourceComment* _tmp75_;
				ValadocApiGirSourceComment* _tmp76_;
				ValaMapIterator* _tmp77_;
				gpointer _tmp78_;
				gchar* _tmp79_;
				ValadocApiSourceComment* _tmp80_;
				_tmp52_ = it;
				if (!vala_map_iterator_next (_tmp52_)) {
					break;
				}
				_tmp53_ = it;
				_tmp54_ = vala_map_iterator_get_value (_tmp53_);
				vala_param = (ValaComment*) _tmp54_;
				_tmp55_ = vala_param;
				_tmp56_ = vala_comment_get_source_reference (_tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = _vala_source_reference_ref0 (_tmp57_);
				param_pos = _tmp58_;
				_tmp59_ = vala_param;
				_tmp60_ = vala_comment_get_content (_tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = file;
				_tmp63_ = param_pos;
				vala_source_reference_get_begin (_tmp63_, &_tmp64_);
				_tmp65_ = _tmp64_;
				_tmp66_ = param_pos;
				vala_source_reference_get_begin (_tmp66_, &_tmp67_);
				_tmp68_ = _tmp67_;
				_tmp69_ = param_pos;
				vala_source_reference_get_end (_tmp69_, &_tmp70_);
				_tmp71_ = _tmp70_;
				_tmp72_ = param_pos;
				vala_source_reference_get_end (_tmp72_, &_tmp73_);
				_tmp74_ = _tmp73_;
				_tmp75_ = valadoc_api_source_comment_new (_tmp61_, _tmp62_, _tmp65_.line, _tmp68_.column, _tmp71_.line, _tmp74_.column);
				param_comment = _tmp75_;
				_tmp76_ = tmp;
				_tmp77_ = it;
				_tmp78_ = vala_map_iterator_get_key (_tmp77_);
				_tmp79_ = (gchar*) _tmp78_;
				_tmp80_ = param_comment;
				valadoc_api_gir_source_comment_add_parameter_content (_tmp76_, _tmp79_, _tmp80_);
				_g_free0 (_tmp79_);
				_valadoc_api_source_comment_unref0 (param_comment);
				_vala_source_reference_unref0 (param_pos);
				_vala_comment_unref0 (vala_param);
			}
			result = (ValadocApiSourceComment*) tmp;
			_vala_map_iterator_unref0 (it);
			_g_object_unref0 (file);
			_vala_source_reference_unref0 (pos);
			return result;
		} else {
			const gchar* _tmp81_;
			const gchar* _tmp82_;
			ValadocApiSourceFile* _tmp83_;
			ValaSourceReference* _tmp84_;
			ValaSourceLocation _tmp85_ = {0};
			ValaSourceLocation _tmp86_;
			ValaSourceReference* _tmp87_;
			ValaSourceLocation _tmp88_ = {0};
			ValaSourceLocation _tmp89_;
			ValaSourceReference* _tmp90_;
			ValaSourceLocation _tmp91_ = {0};
			ValaSourceLocation _tmp92_;
			ValaSourceReference* _tmp93_;
			ValaSourceLocation _tmp94_ = {0};
			ValaSourceLocation _tmp95_;
			ValadocApiSourceComment* _tmp96_;
			_tmp81_ = vala_comment_get_content (comment);
			_tmp82_ = _tmp81_;
			_tmp83_ = file;
			_tmp84_ = pos;
			vala_source_reference_get_begin (_tmp84_, &_tmp85_);
			_tmp86_ = _tmp85_;
			_tmp87_ = pos;
			vala_source_reference_get_begin (_tmp87_, &_tmp88_);
			_tmp89_ = _tmp88_;
			_tmp90_ = pos;
			vala_source_reference_get_end (_tmp90_, &_tmp91_);
			_tmp92_ = _tmp91_;
			_tmp93_ = pos;
			vala_source_reference_get_end (_tmp93_, &_tmp94_);
			_tmp95_ = _tmp94_;
			_tmp96_ = valadoc_api_source_comment_new (_tmp82_, _tmp83_, _tmp86_.line, _tmp89_.column, _tmp92_.line, _tmp95_.column);
			result = _tmp96_;
			_g_object_unref0 (file);
			_vala_source_reference_unref0 (pos);
			return result;
		}
		_g_object_unref0 (file);
		_vala_source_reference_unref0 (pos);
	}
	result = NULL;
	return result;
}

static gchar*
valadoc_tree_builder_get_method_name (ValadocTreeBuilder* self,
                                      ValaMethod* element)
{
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (element, VALA_TYPE_CREATION_METHOD)) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = vala_symbol_get_name ((ValaSymbol*) element);
		_tmp1_ = _tmp0_;
		if (g_strcmp0 (_tmp1_, ".new") == 0) {
			ValaSymbol* _tmp2_;
			ValaSymbol* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) element);
			_tmp3_ = _tmp2_;
			_tmp4_ = vala_symbol_get_name (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			return result;
		} else {
			ValaSymbol* _tmp7_;
			ValaSymbol* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) element);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strconcat (_tmp10_, ".", NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_symbol_get_name ((ValaSymbol*) element);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat (_tmp12_, _tmp14_, NULL);
			_tmp16_ = _tmp15_;
			_g_free0 (_tmp12_);
			result = _tmp16_;
			return result;
		}
	}
	_tmp17_ = vala_symbol_get_name ((ValaSymbol*) element);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup (_tmp18_);
	result = _tmp19_;
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static ValadocTreeBuilderPackageMetaData*
valadoc_tree_builder_get_package_meta_data (ValadocTreeBuilder* self,
                                            ValadocApiPackage* pkg)
{
	ValadocTreeBuilderPackageMetaData* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pkg != NULL, NULL);
	{
		ValaArrayList* _data_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _data_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _data_index = 0;
		_tmp0_ = self->priv->packages;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_data_list = _tmp1_;
		_tmp2_ = _data_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_data_size = _tmp4_;
		_data_index = -1;
		while (TRUE) {
			ValadocTreeBuilderPackageMetaData* data = NULL;
			ValaArrayList* _tmp5_;
			gpointer _tmp6_;
			ValadocTreeBuilderPackageMetaData* _tmp7_;
			ValadocApiPackage* _tmp8_;
			_data_index = _data_index + 1;
			if (!(_data_index < _data_size)) {
				break;
			}
			_tmp5_ = _data_list;
			_tmp6_ = vala_list_get ((ValaList*) _tmp5_, _data_index);
			data = (ValadocTreeBuilderPackageMetaData*) _tmp6_;
			_tmp7_ = data;
			_tmp8_ = _tmp7_->package;
			if (_tmp8_ == pkg) {
				result = data;
				_vala_iterable_unref0 (_data_list);
				return result;
			}
			_valadoc_tree_builder_package_meta_data_unref0 (data);
		}
		_vala_iterable_unref0 (_data_list);
	}
	result = NULL;
	return result;
}

static ValadocTreeBuilderPackageMetaData*
valadoc_tree_builder_register_package (ValadocTreeBuilder* self,
                                       ValadocApiPackage* package)
{
	ValadocTreeBuilderPackageMetaData* meta_data = NULL;
	ValadocTreeBuilderPackageMetaData* _tmp0_;
	ValadocApiTree* _tmp1_;
	ValaArrayList* _tmp2_;
	ValadocTreeBuilderPackageMetaData* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (package != NULL, NULL);
	_tmp0_ = valadoc_tree_builder_package_meta_data_new (package);
	meta_data = _tmp0_;
	_tmp1_ = self->priv->tree;
	valadoc_api_tree_add_package (_tmp1_, package);
	_tmp2_ = self->priv->packages;
	vala_collection_add ((ValaCollection*) _tmp2_, meta_data);
	result = meta_data;
	return result;
}

static ValadocApiSourceFile*
valadoc_tree_builder_register_source_file (ValadocTreeBuilder* self,
                                           ValadocTreeBuilderPackageMetaData* meta_data,
                                           ValaSourceFile* source_file)
{
	ValadocApiSourceFile* file = NULL;
	ValadocApiPackage* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ValadocApiSourceFile* _tmp5_;
	ValadocApiSourceFile* _tmp6_;
	ValaHashMap* _tmp7_;
	ValadocApiSourceFile* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (meta_data != NULL, NULL);
	g_return_val_if_fail (source_file != NULL, NULL);
	_tmp0_ = meta_data->package;
	_tmp1_ = vala_source_file_get_relative_filename (source_file);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_source_file_get_csource_filename (source_file);
	_tmp4_ = _tmp3_;
	_tmp5_ = valadoc_api_source_file_new (_tmp0_, _tmp2_, _tmp4_, source_file);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	file = _tmp6_;
	_tmp7_ = self->priv->files;
	vala_map_set ((ValaMap*) _tmp7_, source_file, file);
	valadoc_tree_builder_package_meta_data_register_source_file (meta_data, source_file);
	result = file;
	return result;
}

static ValadocApiSourceFile*
valadoc_tree_builder_get_source_file (ValadocTreeBuilder* self,
                                      ValaSymbol* symbol)
{
	ValaSourceReference* source_ref = NULL;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValadocApiSourceFile* file = NULL;
	ValaHashMap* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	gpointer _tmp8_;
	ValadocApiSourceFile* _tmp9_;
	ValadocApiSourceFile* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) symbol);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_source_reference_ref0 (_tmp1_);
	source_ref = _tmp2_;
	_tmp3_ = source_ref;
	if (_tmp3_ == NULL) {
		result = NULL;
		_vala_source_reference_unref0 (source_ref);
		return result;
	}
	_tmp4_ = self->priv->files;
	_tmp5_ = source_ref;
	_tmp6_ = vala_source_reference_get_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_map_get ((ValaMap*) _tmp4_, _tmp7_);
	file = (ValadocApiSourceFile*) _tmp8_;
	_tmp9_ = file;
	_vala_assert (_tmp9_ != NULL, "file != null");
	result = file;
	_vala_source_reference_unref0 (source_ref);
	return result;
}

static ValadocApiPackage*
valadoc_tree_builder_find_package_for_file (ValadocTreeBuilder* self,
                                            ValaSourceFile* source_file)
{
	ValadocApiPackage* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source_file != NULL, NULL);
	{
		ValaArrayList* _pkg_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _pkg_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _pkg_index = 0;
		_tmp0_ = self->priv->packages;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_pkg_list = _tmp1_;
		_tmp2_ = _pkg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_pkg_size = _tmp4_;
		_pkg_index = -1;
		while (TRUE) {
			ValadocTreeBuilderPackageMetaData* pkg = NULL;
			ValaArrayList* _tmp5_;
			gpointer _tmp6_;
			ValadocTreeBuilderPackageMetaData* _tmp7_;
			_pkg_index = _pkg_index + 1;
			if (!(_pkg_index < _pkg_size)) {
				break;
			}
			_tmp5_ = _pkg_list;
			_tmp6_ = vala_list_get ((ValaList*) _tmp5_, _pkg_index);
			pkg = (ValadocTreeBuilderPackageMetaData*) _tmp6_;
			_tmp7_ = pkg;
			if (valadoc_tree_builder_package_meta_data_is_package_for_file (_tmp7_, source_file)) {
				ValadocTreeBuilderPackageMetaData* _tmp8_;
				ValadocApiPackage* _tmp9_;
				ValadocApiPackage* _tmp10_;
				_tmp8_ = pkg;
				_tmp9_ = _tmp8_->package;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				result = _tmp10_;
				_valadoc_tree_builder_package_meta_data_unref0 (pkg);
				_vala_iterable_unref0 (_pkg_list);
				return result;
			}
			_valadoc_tree_builder_package_meta_data_unref0 (pkg);
		}
		_vala_iterable_unref0 (_pkg_list);
	}
	result = NULL;
	return result;
}

static ValadocApiNamespace*
valadoc_tree_builder_get_namespace (ValadocTreeBuilder* self,
                                    ValadocApiPackage* pkg,
                                    ValaSymbol* symbol,
                                    ValadocApiSourceFile* file)
{
	ValaSymbol* namespace_symbol = NULL;
	ValaSymbol* _tmp0_;
	ValadocTreeBuilderPackageMetaData* meta_data = NULL;
	ValadocTreeBuilderPackageMetaData* _tmp6_;
	ValaSymbol* _tmp7_;
	ValadocApiNamespace* _tmp8_;
	ValadocApiNamespace* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pkg != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = _vala_code_node_ref0 (symbol);
	namespace_symbol = _tmp0_;
	while (TRUE) {
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		_tmp1_ = namespace_symbol;
		if (!(!G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_NAMESPACE))) {
			break;
		}
		_tmp2_ = namespace_symbol;
		_tmp3_ = vala_symbol_get_parent_symbol (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _vala_code_node_ref0 (_tmp4_);
		_vala_code_node_unref0 (namespace_symbol);
		namespace_symbol = _tmp5_;
	}
	_tmp6_ = valadoc_tree_builder_get_package_meta_data (self, pkg);
	meta_data = _tmp6_;
	_vala_assert (meta_data != NULL, "meta_data != null");
	_tmp7_ = namespace_symbol;
	_tmp8_ = valadoc_tree_builder_package_meta_data_get_namespace (meta_data, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_NAMESPACE, ValaNamespace), file);
	result = _tmp8_;
	_valadoc_tree_builder_package_meta_data_unref0 (meta_data);
	_vala_code_node_unref0 (namespace_symbol);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
valadoc_tree_builder_get_package_name (ValadocTreeBuilder* self,
                                       const gchar* path)
{
	gchar* file_name = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_path_get_basename (path);
	file_name = _tmp0_;
	_tmp1_ = string_substring (file_name, (glong) 0, (glong) string_last_index_of_char (file_name, (gunichar) '.', 0));
	result = _tmp1_;
	_g_free0 (file_name);
	return result;
}

static gboolean
valadoc_tree_builder_add_package (ValadocTreeBuilder* self,
                                  ValaCodeContext* context,
                                  const gchar* pkg)
{
	gchar* vapi_name = NULL;
	gchar* _tmp0_;
	gchar* gir_name = NULL;
	gchar* _tmp1_;
	ValadocSettings* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* package_path = NULL;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	ValaSourceFile* vfile = NULL;
	const gchar* _tmp19_;
	ValaSourceFile* _tmp20_;
	ValaSourceFile* _tmp21_;
	ValadocApiPackage* vdpkg = NULL;
	ValadocApiPackage* _tmp22_;
	ValadocApiPackage* _tmp23_;
	ValadocTreeBuilderPackageMetaData* _tmp24_;
	ValadocTreeBuilderPackageMetaData* _tmp25_;
	ValaSourceFile* _tmp26_;
	ValadocApiSourceFile* _tmp27_;
	ValadocApiSourceFile* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	if (vala_code_context_has_package (context, pkg)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = g_strconcat (pkg, ".vapi", NULL);
	vapi_name = _tmp0_;
	_tmp1_ = g_strconcat (pkg, ".gir", NULL);
	gir_name = _tmp1_;
	_tmp2_ = self->priv->settings;
	_tmp3_ = _tmp2_->source_files;
	_tmp3__length1 = _tmp2_->source_files_length1;
	{
		gchar** source_file_collection = NULL;
		gint source_file_collection_length1 = 0;
		gint _source_file_collection_size_ = 0;
		gint source_file_it = 0;
		source_file_collection = _tmp3_;
		source_file_collection_length1 = _tmp3__length1;
		for (source_file_it = 0; source_file_it < source_file_collection_length1; source_file_it = source_file_it + 1) {
			gchar* _tmp4_;
			gchar* source_file = NULL;
			_tmp4_ = g_strdup (source_file_collection[source_file_it]);
			source_file = _tmp4_;
			{
				gchar* basename = NULL;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				gboolean _tmp7_ = FALSE;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp5_ = source_file;
				_tmp6_ = g_path_get_basename (_tmp5_);
				basename = _tmp6_;
				_tmp8_ = basename;
				_tmp9_ = vapi_name;
				if (g_strcmp0 (_tmp8_, _tmp9_) == 0) {
					_tmp7_ = TRUE;
				} else {
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					_tmp10_ = basename;
					_tmp11_ = gir_name;
					_tmp7_ = g_strcmp0 (_tmp10_, _tmp11_) == 0;
				}
				if (_tmp7_) {
					result = TRUE;
					_g_free0 (basename);
					_g_free0 (source_file);
					_g_free0 (gir_name);
					_g_free0 (vapi_name);
					return result;
				}
				_g_free0 (basename);
				_g_free0 (source_file);
			}
		}
	}
	_tmp13_ = vala_code_context_get_vapi_path (context, pkg);
	_tmp12_ = _tmp13_;
	if (_tmp12_ == NULL) {
		gchar* _tmp14_;
		_tmp14_ = vala_code_context_get_gir_path (context, pkg);
		_g_free0 (_tmp12_);
		_tmp12_ = _tmp14_;
	}
	_tmp15_ = g_strdup (_tmp12_);
	package_path = _tmp15_;
	_tmp16_ = package_path;
	if (_tmp16_ == NULL) {
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp17_ = g_strdup_printf ("Package `%s' not found in specified Vala API directories or GObject-In" \
"trospection GIR directories", pkg);
		_tmp18_ = _tmp17_;
		vala_report_error (NULL, _tmp18_);
		_g_free0 (_tmp18_);
		result = FALSE;
		_g_free0 (package_path);
		_g_free0 (_tmp12_);
		_g_free0 (gir_name);
		_g_free0 (vapi_name);
		return result;
	}
	vala_code_context_add_package (context, pkg);
	_tmp19_ = package_path;
	_tmp20_ = vala_source_file_new (context, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp19_, NULL, FALSE);
	vfile = _tmp20_;
	_tmp21_ = vfile;
	vala_code_context_add_source_file (context, _tmp21_);
	_tmp22_ = valadoc_api_package_new (pkg, TRUE, NULL);
	vdpkg = _tmp22_;
	_tmp23_ = vdpkg;
	_tmp24_ = valadoc_tree_builder_register_package (self, _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vfile;
	_tmp27_ = valadoc_tree_builder_register_source_file (self, _tmp25_, _tmp26_);
	_tmp28_ = _tmp27_;
	_g_object_unref0 (_tmp28_);
	_valadoc_tree_builder_package_meta_data_unref0 (_tmp25_);
	_tmp29_ = package_path;
	_tmp30_ = g_path_get_dirname (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strdup_printf ("%s.deps", pkg);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_build_filename (_tmp31_, _tmp33_, NULL);
	_tmp35_ = _tmp34_;
	valadoc_tree_builder_add_deps (self, context, _tmp35_, pkg);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	result = TRUE;
	_g_object_unref0 (vdpkg);
	_vala_source_file_unref0 (vfile);
	_g_free0 (package_path);
	_g_free0 (_tmp12_);
	_g_free0 (gir_name);
	_g_free0 (vapi_name);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}

static void
valadoc_tree_builder_add_deps (ValadocTreeBuilder* self,
                               ValaCodeContext* context,
                               const gchar* file_path,
                               const gchar* pkg_name)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (file_path != NULL);
	g_return_if_fail (pkg_name != NULL);
	if (g_file_test (file_path, G_FILE_TEST_EXISTS)) {
		{
			gchar* deps_content = NULL;
			gulong deps_len = 0UL;
			gchar* _tmp0_ = NULL;
			gsize _tmp1_ = 0UL;
			const gchar* _tmp2_;
			gchar** _tmp3_;
			gchar** _tmp4_;
			g_file_get_contents (file_path, &_tmp0_, &_tmp1_, &_inner_error0_);
			_g_free0 (deps_content);
			deps_content = _tmp0_;
			deps_len = (gulong) _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (deps_content);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp2_ = deps_content;
			_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "\n", 0);
			{
				gchar** dep_collection = NULL;
				gint dep_collection_length1 = 0;
				gint _dep_collection_size_ = 0;
				gint dep_it = 0;
				dep_collection = _tmp4_;
				dep_collection_length1 = _vala_array_length (_tmp3_);
				for (dep_it = 0; dep_it < dep_collection_length1; dep_it = dep_it + 1) {
					gchar* _tmp5_;
					gchar* dep = NULL;
					_tmp5_ = g_strdup (dep_collection[dep_it]);
					dep = _tmp5_;
					{
						const gchar* _tmp6_;
						gchar* _tmp7_;
						const gchar* _tmp8_;
						_tmp6_ = dep;
						_tmp7_ = string_strip (_tmp6_);
						_g_free0 (dep);
						dep = _tmp7_;
						_tmp8_ = dep;
						if (g_strcmp0 (_tmp8_, "") != 0) {
							const gchar* _tmp9_;
							_tmp9_ = dep;
							if (!valadoc_tree_builder_add_package (self, context, _tmp9_)) {
								const gchar* _tmp10_;
								gchar* _tmp11_;
								gchar* _tmp12_;
								_tmp10_ = dep;
								_tmp11_ = g_strdup_printf ("%s, dependency of %s, not found in specified Vala API directories", _tmp10_, pkg_name);
								_tmp12_ = _tmp11_;
								vala_report_error (NULL, _tmp12_);
								_g_free0 (_tmp12_);
							}
						}
						_g_free0 (dep);
					}
				}
				dep_collection = (_vala_array_free (dep_collection, dep_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (deps_content);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError* e = NULL;
			GError* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			_tmp15_ = g_strdup_printf ("Unable to read dependency file: %s", _tmp14_);
			_tmp16_ = _tmp15_;
			vala_report_error (NULL, _tmp16_);
			_g_free0 (_tmp16_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

/**
 * Adds the specified packages to the list of used packages.
 *
 * @param context The code context
 * @param packages a list of package names
 */
static void
valadoc_tree_builder_add_depencies (ValadocTreeBuilder* self,
                                    ValaCodeContext* context,
                                    gchar** packages,
                                    gint packages_length1)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	{
		gchar** package_collection = NULL;
		gint package_collection_length1 = 0;
		gint _package_collection_size_ = 0;
		gint package_it = 0;
		package_collection = packages;
		package_collection_length1 = packages_length1;
		for (package_it = 0; package_it < package_collection_length1; package_it = package_it + 1) {
			gchar* _tmp0_;
			gchar* package = NULL;
			_tmp0_ = g_strdup (package_collection[package_it]);
			package = _tmp0_;
			{
				const gchar* _tmp1_;
				_tmp1_ = package;
				if (!valadoc_tree_builder_add_package (self, context, _tmp1_)) {
					const gchar* _tmp2_;
					gchar* _tmp3_;
					gchar* _tmp4_;
					_tmp2_ = package;
					_tmp3_ = g_strdup_printf ("Package `%s' not found in specified Vala API directories or GObject-In" \
"trospection GIR directories", _tmp2_);
					_tmp4_ = _tmp3_;
					vala_report_error (NULL, _tmp4_);
					_g_free0 (_tmp4_);
				}
				_g_free0 (package);
			}
		}
	}
}

/**
 * Add the specified source file to the context. Only .vala, .vapi, .gs,
 * and .c files are supported.
 */
static void
valadoc_tree_builder_add_documented_files (ValadocTreeBuilder* self,
                                           ValaCodeContext* context,
                                           gchar** sources,
                                           gint sources_length1)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	if (sources == NULL) {
		return;
	}
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = sources;
		source_collection_length1 = sources_length1;
		for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
			gchar* _tmp0_;
			gchar* source = NULL;
			_tmp0_ = g_strdup (source_collection[source_it]);
			source = _tmp0_;
			{
				const gchar* _tmp1_;
				_tmp1_ = source;
				if (g_file_test (_tmp1_, G_FILE_TEST_EXISTS)) {
					gchar* rpath = NULL;
					const gchar* _tmp2_;
					gchar* _tmp3_;
					gboolean _tmp4_ = FALSE;
					const gchar* _tmp5_;
					_tmp2_ = source;
					_tmp3_ = vala_code_context_realpath (_tmp2_);
					rpath = _tmp3_;
					_tmp5_ = source;
					if (g_str_has_suffix (_tmp5_, ".vala")) {
						_tmp4_ = TRUE;
					} else {
						const gchar* _tmp6_;
						_tmp6_ = source;
						_tmp4_ = g_str_has_suffix (_tmp6_, ".gs");
					}
					if (_tmp4_) {
						ValaSourceFile* source_file = NULL;
						const gchar* _tmp7_;
						ValaSourceFile* _tmp8_;
						ValadocTreeBuilderPackageMetaData* _tmp9_;
						ValadocTreeBuilderPackageMetaData* _tmp15_;
						ValaSourceFile* _tmp16_;
						ValadocApiSourceFile* _tmp17_;
						ValadocApiSourceFile* _tmp18_;
						ValaProfile _tmp19_;
						ValaProfile _tmp20_;
						ValaSourceFile* _tmp30_;
						_tmp7_ = rpath;
						_tmp8_ = vala_source_file_new (context, VALA_SOURCE_FILE_TYPE_SOURCE, _tmp7_, NULL, FALSE);
						source_file = _tmp8_;
						_tmp9_ = self->priv->source_package;
						if (_tmp9_ == NULL) {
							ValadocSettings* _tmp10_;
							const gchar* _tmp11_;
							ValadocApiPackage* _tmp12_;
							ValadocApiPackage* _tmp13_;
							ValadocTreeBuilderPackageMetaData* _tmp14_;
							_tmp10_ = self->priv->settings;
							_tmp11_ = _tmp10_->pkg_name;
							_tmp12_ = valadoc_api_package_new (_tmp11_, FALSE, NULL);
							_tmp13_ = _tmp12_;
							_tmp14_ = valadoc_tree_builder_register_package (self, _tmp13_);
							_valadoc_tree_builder_package_meta_data_unref0 (self->priv->source_package);
							self->priv->source_package = _tmp14_;
							_g_object_unref0 (_tmp13_);
						}
						_tmp15_ = self->priv->source_package;
						_tmp16_ = source_file;
						_tmp17_ = valadoc_tree_builder_register_source_file (self, _tmp15_, _tmp16_);
						_tmp18_ = _tmp17_;
						_g_object_unref0 (_tmp18_);
						_tmp19_ = vala_code_context_get_profile (context);
						_tmp20_ = _tmp19_;
						if (_tmp20_ == VALA_PROFILE_GOBJECT) {
							ValaUsingDirective* ns_ref = NULL;
							ValaUnresolvedSymbol* _tmp21_;
							ValaUnresolvedSymbol* _tmp22_;
							ValaUsingDirective* _tmp23_;
							ValaUsingDirective* _tmp24_;
							ValaSourceFile* _tmp25_;
							ValaUsingDirective* _tmp26_;
							ValaNamespace* _tmp27_;
							ValaNamespace* _tmp28_;
							ValaUsingDirective* _tmp29_;
							_tmp21_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
							_tmp22_ = _tmp21_;
							_tmp23_ = vala_using_directive_new ((ValaSymbol*) _tmp22_, NULL);
							_tmp24_ = _tmp23_;
							_vala_code_node_unref0 (_tmp22_);
							ns_ref = _tmp24_;
							_tmp25_ = source_file;
							_tmp26_ = ns_ref;
							vala_source_file_add_using_directive (_tmp25_, _tmp26_);
							_tmp27_ = vala_code_context_get_root (context);
							_tmp28_ = _tmp27_;
							_tmp29_ = ns_ref;
							vala_namespace_add_using_directive (_tmp28_, _tmp29_);
							_vala_code_node_unref0 (ns_ref);
						}
						_tmp30_ = source_file;
						vala_code_context_add_source_file (context, _tmp30_);
						_vala_source_file_unref0 (source_file);
					} else {
						gboolean _tmp31_ = FALSE;
						const gchar* _tmp32_;
						_tmp32_ = source;
						if (g_str_has_suffix (_tmp32_, ".vapi")) {
							_tmp31_ = TRUE;
						} else {
							const gchar* _tmp33_;
							_tmp33_ = source;
							_tmp31_ = g_str_has_suffix (_tmp33_, ".gir");
						}
						if (_tmp31_) {
							gchar* file_name = NULL;
							const gchar* _tmp34_;
							gchar* _tmp35_;
							ValaSourceFile* vfile = NULL;
							const gchar* _tmp36_;
							ValaSourceFile* _tmp37_;
							ValaSourceFile* _tmp38_;
							ValadocTreeBuilderPackageMetaData* _tmp39_;
							ValadocTreeBuilderPackageMetaData* _tmp45_;
							ValaSourceFile* _tmp46_;
							ValadocApiSourceFile* _tmp47_;
							ValadocApiSourceFile* _tmp48_;
							const gchar* _tmp49_;
							gchar* _tmp50_;
							gchar* _tmp51_;
							const gchar* _tmp52_;
							gchar* _tmp53_;
							gchar* _tmp54_;
							gchar* _tmp55_;
							gchar* _tmp56_;
							const gchar* _tmp57_;
							_tmp34_ = source;
							_tmp35_ = valadoc_tree_builder_get_package_name (self, _tmp34_);
							file_name = _tmp35_;
							_tmp36_ = rpath;
							_tmp37_ = vala_source_file_new (context, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp36_, NULL, FALSE);
							vfile = _tmp37_;
							_tmp38_ = vfile;
							vala_code_context_add_source_file (context, _tmp38_);
							_tmp39_ = self->priv->source_package;
							if (_tmp39_ == NULL) {
								ValadocSettings* _tmp40_;
								const gchar* _tmp41_;
								ValadocApiPackage* _tmp42_;
								ValadocApiPackage* _tmp43_;
								ValadocTreeBuilderPackageMetaData* _tmp44_;
								_tmp40_ = self->priv->settings;
								_tmp41_ = _tmp40_->pkg_name;
								_tmp42_ = valadoc_api_package_new (_tmp41_, FALSE, NULL);
								_tmp43_ = _tmp42_;
								_tmp44_ = valadoc_tree_builder_register_package (self, _tmp43_);
								_valadoc_tree_builder_package_meta_data_unref0 (self->priv->source_package);
								self->priv->source_package = _tmp44_;
								_g_object_unref0 (_tmp43_);
							}
							_tmp45_ = self->priv->source_package;
							_tmp46_ = vfile;
							_tmp47_ = valadoc_tree_builder_register_source_file (self, _tmp45_, _tmp46_);
							_tmp48_ = _tmp47_;
							_g_object_unref0 (_tmp48_);
							_tmp49_ = source;
							_tmp50_ = g_path_get_dirname (_tmp49_);
							_tmp51_ = _tmp50_;
							_tmp52_ = file_name;
							_tmp53_ = g_strdup_printf ("%s.deps", _tmp52_);
							_tmp54_ = _tmp53_;
							_tmp55_ = g_build_filename (_tmp51_, _tmp54_, NULL);
							_tmp56_ = _tmp55_;
							_tmp57_ = file_name;
							valadoc_tree_builder_add_deps (self, context, _tmp56_, _tmp57_);
							_g_free0 (_tmp56_);
							_g_free0 (_tmp54_);
							_g_free0 (_tmp51_);
							_vala_source_file_unref0 (vfile);
							_g_free0 (file_name);
						} else {
							const gchar* _tmp58_;
							_tmp58_ = source;
							if (g_str_has_suffix (_tmp58_, ".c")) {
								const gchar* _tmp59_;
								ValadocApiTree* _tmp60_;
								const gchar* _tmp61_;
								_tmp59_ = rpath;
								vala_code_context_add_c_source_file (context, _tmp59_);
								_tmp60_ = self->priv->tree;
								_tmp61_ = rpath;
								valadoc_api_tree_add_external_c_files (_tmp60_, _tmp61_);
							} else {
								const gchar* _tmp62_;
								gchar* _tmp63_;
								gchar* _tmp64_;
								_tmp62_ = source;
								_tmp63_ = g_strdup_printf ("%s is not a supported source file type. Only .vala, .vapi, .gs, and .c" \
" files are supported.", _tmp62_);
								_tmp64_ = _tmp63_;
								vala_report_error (NULL, _tmp64_);
								_g_free0 (_tmp64_);
							}
						}
					}
					_g_free0 (rpath);
				} else {
					const gchar* _tmp65_;
					gchar* _tmp66_;
					gchar* _tmp67_;
					_tmp65_ = source;
					_tmp66_ = g_strdup_printf ("%s not found", _tmp65_);
					_tmp67_ = _tmp66_;
					vala_report_error (NULL, _tmp67_);
					_g_free0 (_tmp67_);
				}
				_g_free0 (source);
			}
		}
	}
}

static void
valadoc_tree_builder_create_valac_tree (ValadocTreeBuilder* self,
                                        ValaCodeContext* context,
                                        ValadocSettings* settings)
{
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	const gchar* _tmp12_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	ValaProfile _tmp27_;
	ValaProfile _tmp28_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	ValadocErrorReporter* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	ValadocErrorReporter* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	ValaParser* parser = NULL;
	ValaParser* _tmp39_;
	ValaParser* _tmp40_;
	ValaReport* _tmp41_;
	ValaReport* _tmp42_;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp43_;
	ValaGirParser* _tmp44_;
	ValaReport* _tmp45_;
	ValaReport* _tmp46_;
	ValaReport* _tmp47_;
	ValaReport* _tmp48_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (settings != NULL);
	vala_code_context_set_experimental (context, settings->experimental);
	if (settings->experimental) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = settings->experimental_non_null;
	}
	vala_code_context_set_experimental_non_null (context, _tmp0_);
	_tmp1_ = settings->vapi_directories;
	_tmp1__length1 = settings->vapi_directories_length1;
	vala_code_context_set_vapi_directories (context, _tmp1_, _tmp1__length1);
	_tmp2_ = vala_code_context_get_report (context);
	_tmp3_ = _tmp2_;
	vala_report_set_enable_warnings (_tmp3_, settings->verbose);
	_tmp4_ = settings->metadata_directories;
	_tmp4__length1 = settings->metadata_directories_length1;
	vala_code_context_set_metadata_directories (context, _tmp4_, _tmp4__length1);
	_tmp5_ = settings->gir_directories;
	_tmp5__length1 = settings->gir_directories_length1;
	vala_code_context_set_gir_directories (context, _tmp5_, _tmp5__length1);
	_tmp6_ = settings->basedir;
	if (_tmp6_ == NULL) {
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = vala_code_context_realpath (".");
		_tmp8_ = _tmp7_;
		vala_code_context_set_basedir (context, _tmp8_);
		_g_free0 (_tmp8_);
	} else {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = settings->basedir;
		_tmp10_ = vala_code_context_realpath (_tmp9_);
		_tmp11_ = _tmp10_;
		vala_code_context_set_basedir (context, _tmp11_);
		_g_free0 (_tmp11_);
	}
	_tmp12_ = settings->directory;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp13_ = settings->directory;
		_tmp14_ = vala_code_context_realpath (_tmp13_);
		_tmp15_ = _tmp14_;
		vala_code_context_set_directory (context, _tmp15_);
		_g_free0 (_tmp15_);
	} else {
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp16_ = vala_code_context_get_basedir (context);
		_tmp17_ = _tmp16_;
		vala_code_context_set_directory (context, _tmp17_);
	}
	_tmp20_ = settings->profile;
	if (g_strcmp0 (_tmp20_, "gobject-2.0") == 0) {
		_tmp19_ = TRUE;
	} else {
		const gchar* _tmp21_;
		_tmp21_ = settings->profile;
		_tmp19_ = g_strcmp0 (_tmp21_, "gobject") == 0;
	}
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		const gchar* _tmp22_;
		_tmp22_ = settings->profile;
		_tmp18_ = _tmp22_ == NULL;
	}
	if (_tmp18_) {
		vala_code_context_set_profile (context, VALA_PROFILE_GOBJECT);
		vala_code_context_add_define (context, "GOBJECT");
	}
	_tmp23_ = settings->defines;
	_tmp23__length1 = settings->defines_length1;
	if (_tmp23_ != NULL) {
		gchar** _tmp24_;
		gint _tmp24__length1;
		_tmp24_ = settings->defines;
		_tmp24__length1 = settings->defines_length1;
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp24_;
			define_collection_length1 = _tmp24__length1;
			for (define_it = 0; define_it < define_collection_length1; define_it = define_it + 1) {
				gchar* _tmp25_;
				gchar* define = NULL;
				_tmp25_ = g_strdup (define_collection[define_it]);
				define = _tmp25_;
				{
					const gchar* _tmp26_;
					_tmp26_ = define;
					vala_code_context_add_define (context, _tmp26_);
					_g_free0 (define);
				}
			}
		}
	}
	_tmp27_ = vala_code_context_get_profile (context);
	_tmp28_ = _tmp27_;
	if (_tmp28_ == VALA_PROFILE_GOBJECT) {
		const gchar* _tmp29_;
		_tmp29_ = settings->target_glib;
		if (_tmp29_ != NULL) {
			const gchar* _tmp30_;
			_tmp30_ = settings->target_glib;
			vala_code_context_set_target_glib_version (context, _tmp30_);
		}
		if (!valadoc_tree_builder_add_package (self, context, "glib-2.0")) {
			vala_report_error (NULL, "glib-2.0 not found in specified Vala API directories");
		}
		if (!valadoc_tree_builder_add_package (self, context, "gobject-2.0")) {
			vala_report_error (NULL, "gobject-2.0 not found in specified Vala API directories");
		}
	}
	_tmp31_ = settings->packages;
	_tmp31__length1 = settings->packages_length1;
	valadoc_tree_builder_add_depencies (self, context, _tmp31_, (gint) _tmp31__length1);
	_tmp32_ = self->priv->reporter;
	_tmp33_ = valadoc_error_reporter_get_errors (_tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_ > 0) {
		return;
	}
	_tmp35_ = settings->source_files;
	_tmp35__length1 = settings->source_files_length1;
	valadoc_tree_builder_add_documented_files (self, context, _tmp35_, (gint) _tmp35__length1);
	_tmp36_ = self->priv->reporter;
	_tmp37_ = valadoc_error_reporter_get_errors (_tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_ > 0) {
		return;
	}
	_tmp39_ = vala_parser_new ();
	parser = _tmp39_;
	_tmp40_ = parser;
	vala_parser_parse (_tmp40_, context);
	_tmp41_ = vala_code_context_get_report (context);
	_tmp42_ = _tmp41_;
	if (vala_report_get_errors (_tmp42_) > 0) {
		_vala_code_visitor_unref0 (parser);
		return;
	}
	_tmp43_ = vala_gir_parser_new ();
	gir_parser = _tmp43_;
	_tmp44_ = gir_parser;
	vala_gir_parser_parse (_tmp44_, context);
	_tmp45_ = vala_code_context_get_report (context);
	_tmp46_ = _tmp45_;
	if (vala_report_get_errors (_tmp46_) > 0) {
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (parser);
		return;
	}
	vala_code_context_check (context);
	_tmp47_ = vala_code_context_get_report (context);
	_tmp48_ = _tmp47_;
	if (vala_report_get_errors (_tmp48_) > 0) {
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (parser);
		return;
	}
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (parser);
}

static void
valadoc_tree_builder_process_children (ValadocTreeBuilder* self,
                                       ValadocApiNode* node,
                                       ValaCodeNode* element)
{
	ValadocApiNode* old_node = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiNode* _tmp1_;
	ValadocApiNode* _tmp2_;
	ValadocApiNode* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->current_node;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	old_node = _tmp1_;
	_tmp2_ = _g_object_ref0 (node);
	_g_object_unref0 (self->priv->current_node);
	self->priv->current_node = _tmp2_;
	vala_code_node_accept_children (element, (ValaCodeVisitor*) self);
	_tmp3_ = _g_object_ref0 (old_node);
	_g_object_unref0 (self->priv->current_node);
	self->priv->current_node = _tmp3_;
	_g_object_unref0 (old_node);
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static ValadocApiNode*
valadoc_tree_builder_get_parent_node_for (ValadocTreeBuilder* self,
                                          ValaSymbol* element)
{
	ValadocApiNode* _tmp0_;
	ValaSourceFile* vala_source_file = NULL;
	ValaSourceReference* _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceFile* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValadocApiPackage* package = NULL;
	ValaSourceFile* _tmp8_;
	ValadocApiPackage* _tmp9_;
	ValadocApiSourceFile* source_file = NULL;
	ValadocApiSourceFile* _tmp10_;
	ValadocApiPackage* _tmp11_;
	ValadocApiSourceFile* _tmp12_;
	ValadocApiNamespace* _tmp13_;
	ValadocApiNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	_tmp0_ = self->priv->current_node;
	if (_tmp0_ != NULL) {
		ValadocApiNode* _tmp1_;
		ValadocApiNode* _tmp2_;
		_tmp1_ = self->priv->current_node;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_code_node_get_source_reference ((ValaCodeNode*) element);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_source_reference_get_file (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _vala_source_file_ref0 (_tmp6_);
	vala_source_file = _tmp7_;
	_tmp8_ = vala_source_file;
	_tmp9_ = valadoc_tree_builder_find_package_for_file (self, _tmp8_);
	package = _tmp9_;
	_tmp10_ = valadoc_tree_builder_get_source_file (self, element);
	source_file = _tmp10_;
	_tmp11_ = package;
	_tmp12_ = source_file;
	_tmp13_ = valadoc_tree_builder_get_namespace (self, _tmp11_, element, _tmp12_);
	result = (ValadocApiNode*) _tmp13_;
	_g_object_unref0 (source_file);
	_g_object_unref0 (package);
	_vala_source_file_unref0 (vala_source_file);
	return result;
}

/**
 * {@inheritDoc}
 */
static void
valadoc_tree_builder_real_visit_namespace (ValaCodeVisitor* base,
                                           ValaNamespace* element)
{
	ValadocTreeBuilder * self;
	self = (ValadocTreeBuilder*) base;
	g_return_if_fail (element != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) element, (ValaCodeVisitor*) self);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_tree_builder_real_visit_class (ValaCodeVisitor* base,
                                       ValaClass* element)
{
	ValadocTreeBuilder * self;
	ValadocApiNode* parent = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiSourceFile* file = NULL;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSourceComment* comment = NULL;
	ValaComment* _tmp2_;
	ValaComment* _tmp3_;
	ValadocApiSourceComment* _tmp4_;
	ValadocApiClass* node = NULL;
	ValadocApiNode* _tmp5_;
	ValadocApiSourceFile* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	ValaSymbolAccessibility _tmp9_;
	ValaSymbolAccessibility _tmp10_;
	ValadocApiSourceComment* _tmp11_;
	ValadocApiClass* _tmp12_;
	ValaHashMap* _tmp13_;
	ValadocApiClass* _tmp14_;
	ValadocApiNode* _tmp15_;
	ValadocApiClass* _tmp16_;
	ValadocApiClass* _tmp37_;
	GList* _tmp38_;
	ValadocApiClass* _tmp39_;
	gboolean _tmp40_ = FALSE;
	ValadocApiClass* _tmp41_;
	self = (ValadocTreeBuilder*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_tree_builder_get_parent_node_for (self, (ValaSymbol*) element);
	parent = _tmp0_;
	_tmp1_ = valadoc_tree_builder_get_source_file (self, (ValaSymbol*) element);
	file = _tmp1_;
	_tmp2_ = vala_symbol_get_comment ((ValaSymbol*) element);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_tree_builder_create_comment (self, _tmp3_);
	comment = _tmp4_;
	_tmp5_ = parent;
	_tmp6_ = file;
	_tmp7_ = vala_symbol_get_name ((ValaSymbol*) element);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_symbol_get_access ((ValaSymbol*) element);
	_tmp10_ = _tmp9_;
	_tmp11_ = comment;
	_tmp12_ = valadoc_api_class_new (_tmp5_, _tmp6_, _tmp8_, _tmp10_, _tmp11_, element);
	node = _tmp12_;
	_tmp13_ = self->priv->symbol_map;
	_tmp14_ = node;
	vala_map_set ((ValaMap*) _tmp13_, (ValaSymbol*) element, (ValadocApiSymbol*) _tmp14_);
	_tmp15_ = parent;
	_tmp16_ = node;
	valadoc_api_node_add_child (_tmp15_, (ValadocApiSymbol*) _tmp16_);
	{
		ValaList* _vala_type_ref_list = NULL;
		ValaList* _tmp17_;
		gint _vala_type_ref_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _vala_type_ref_index = 0;
		_tmp17_ = vala_class_get_base_types (element);
		_vala_type_ref_list = _tmp17_;
		_tmp18_ = _vala_type_ref_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_vala_type_ref_size = _tmp20_;
		_vala_type_ref_index = -1;
		while (TRUE) {
			ValaDataType* vala_type_ref = NULL;
			ValaList* _tmp21_;
			gpointer _tmp22_;
			ValadocApiTypeReference* type_ref = NULL;
			ValaDataType* _tmp23_;
			ValadocApiClass* _tmp24_;
			ValadocApiClass* _tmp25_;
			ValadocApiTypeReference* _tmp26_;
			ValaDataType* _tmp27_;
			ValaTypeSymbol* _tmp28_;
			ValaTypeSymbol* _tmp29_;
			_vala_type_ref_index = _vala_type_ref_index + 1;
			if (!(_vala_type_ref_index < _vala_type_ref_size)) {
				break;
			}
			_tmp21_ = _vala_type_ref_list;
			_tmp22_ = vala_list_get (_tmp21_, _vala_type_ref_index);
			vala_type_ref = (ValaDataType*) _tmp22_;
			_tmp23_ = vala_type_ref;
			_tmp24_ = node;
			_tmp25_ = node;
			_tmp26_ = valadoc_tree_builder_create_type_reference (self, _tmp23_, (ValadocApiItem*) _tmp24_, (ValadocApiNode*) _tmp25_);
			type_ref = _tmp26_;
			_tmp27_ = vala_type_ref;
			_tmp28_ = vala_data_type_get_data_type (_tmp27_);
			_tmp29_ = _tmp28_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_INTERFACE)) {
				ValadocApiClass* _tmp30_;
				ValadocApiTypeReference* _tmp31_;
				_tmp30_ = node;
				_tmp31_ = type_ref;
				valadoc_api_class_add_interface (_tmp30_, _tmp31_);
			} else {
				ValaDataType* _tmp32_;
				ValaTypeSymbol* _tmp33_;
				ValaTypeSymbol* _tmp34_;
				_tmp32_ = vala_type_ref;
				_tmp33_ = vala_data_type_get_data_type (_tmp32_);
				_tmp34_ = _tmp33_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, VALA_TYPE_CLASS)) {
					ValadocApiClass* _tmp35_;
					ValadocApiTypeReference* _tmp36_;
					_tmp35_ = node;
					_tmp36_ = type_ref;
					valadoc_api_class_set_base_type (_tmp35_, _tmp36_);
				}
			}
			_g_object_unref0 (type_ref);
			_vala_code_node_unref0 (vala_type_ref);
		}
		_vala_iterable_unref0 (_vala_type_ref_list);
	}
	_tmp37_ = node;
	_tmp38_ = ((ValaCodeNode*) element)->attributes;
	valadoc_tree_builder_process_attributes (self, (ValadocApiSymbol*) _tmp37_, _tmp38_);
	_tmp39_ = node;
	valadoc_tree_builder_process_children (self, (ValadocApiNode*) _tmp39_, (ValaCodeNode*) element);
	_tmp41_ = self->priv->glib_error;
	if (_tmp41_ == NULL) {
		ValadocApiClass* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		_tmp42_ = node;
		_tmp43_ = valadoc_api_node_get_full_name ((ValadocApiNode*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp40_ = g_strcmp0 (_tmp44_, "GLib.Error") == 0;
		_g_free0 (_tmp44_);
	} else {
		_tmp40_ = FALSE;
	}
	if (_tmp40_) {
		ValadocApiClass* _tmp45_;
		ValadocApiClass* _tmp46_;
		_tmp45_ = node;
		_tmp46_ = _g_object_ref0 (_tmp45_);
		_g_object_unref0 (self->priv->glib_error);
		self->priv->glib_error = _tmp46_;
	}
	_g_object_unref0 (node);
	_valadoc_api_source_comment_unref0 (comment);
	_g_object_unref0 (file);
	_g_object_unref0 (parent);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_tree_builder_real_visit_interface (ValaCodeVisitor* base,
                                           ValaInterface* element)
{
	ValadocTreeBuilder * self;
	ValadocApiNode* parent = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiSourceFile* file = NULL;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSourceComment* comment = NULL;
	ValaComment* _tmp2_;
	ValaComment* _tmp3_;
	ValadocApiSourceComment* _tmp4_;
	ValadocApiInterface* node = NULL;
	ValadocApiNode* _tmp5_;
	ValadocApiSourceFile* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	ValaSymbolAccessibility _tmp9_;
	ValaSymbolAccessibility _tmp10_;
	ValadocApiSourceComment* _tmp11_;
	ValadocApiInterface* _tmp12_;
	ValaHashMap* _tmp13_;
	ValadocApiInterface* _tmp14_;
	ValadocApiNode* _tmp15_;
	ValadocApiInterface* _tmp16_;
	ValadocApiInterface* _tmp34_;
	GList* _tmp35_;
	ValadocApiInterface* _tmp36_;
	self = (ValadocTreeBuilder*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_tree_builder_get_parent_node_for (self, (ValaSymbol*) element);
	parent = _tmp0_;
	_tmp1_ = valadoc_tree_builder_get_source_file (self, (ValaSymbol*) element);
	file = _tmp1_;
	_tmp2_ = vala_symbol_get_comment ((ValaSymbol*) element);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_tree_builder_create_comment (self, _tmp3_);
	comment = _tmp4_;
	_tmp5_ = parent;
	_tmp6_ = file;
	_tmp7_ = vala_symbol_get_name ((ValaSymbol*) element);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_symbol_get_access ((ValaSymbol*) element);
	_tmp10_ = _tmp9_;
	_tmp11_ = comment;
	_tmp12_ = valadoc_api_interface_new (_tmp5_, _tmp6_, _tmp8_, _tmp10_, _tmp11_, element);
	node = _tmp12_;
	_tmp13_ = self->priv->symbol_map;
	_tmp14_ = node;
	vala_map_set ((ValaMap*) _tmp13_, (ValaSymbol*) element, (ValadocApiSymbol*) _tmp14_);
	_tmp15_ = parent;
	_tmp16_ = node;
	valadoc_api_node_add_child (_tmp15_, (ValadocApiSymbol*) _tmp16_);
	{
		ValaList* _vala_type_ref_list = NULL;
		ValaList* _tmp17_;
		gint _vala_type_ref_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _vala_type_ref_index = 0;
		_tmp17_ = vala_interface_get_prerequisites (element);
		_vala_type_ref_list = _tmp17_;
		_tmp18_ = _vala_type_ref_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_vala_type_ref_size = _tmp20_;
		_vala_type_ref_index = -1;
		while (TRUE) {
			ValaDataType* vala_type_ref = NULL;
			ValaList* _tmp21_;
			gpointer _tmp22_;
			ValadocApiTypeReference* type_ref = NULL;
			ValaDataType* _tmp23_;
			ValadocApiInterface* _tmp24_;
			ValadocApiInterface* _tmp25_;
			ValadocApiTypeReference* _tmp26_;
			ValaDataType* _tmp27_;
			ValaTypeSymbol* _tmp28_;
			ValaTypeSymbol* _tmp29_;
			_vala_type_ref_index = _vala_type_ref_index + 1;
			if (!(_vala_type_ref_index < _vala_type_ref_size)) {
				break;
			}
			_tmp21_ = _vala_type_ref_list;
			_tmp22_ = vala_list_get (_tmp21_, _vala_type_ref_index);
			vala_type_ref = (ValaDataType*) _tmp22_;
			_tmp23_ = vala_type_ref;
			_tmp24_ = node;
			_tmp25_ = node;
			_tmp26_ = valadoc_tree_builder_create_type_reference (self, _tmp23_, (ValadocApiItem*) _tmp24_, (ValadocApiNode*) _tmp25_);
			type_ref = _tmp26_;
			_tmp27_ = vala_type_ref;
			_tmp28_ = vala_data_type_get_data_type (_tmp27_);
			_tmp29_ = _tmp28_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_INTERFACE)) {
				ValadocApiInterface* _tmp30_;
				ValadocApiTypeReference* _tmp31_;
				_tmp30_ = node;
				_tmp31_ = type_ref;
				valadoc_api_interface_add_interface (_tmp30_, _tmp31_);
			} else {
				ValadocApiInterface* _tmp32_;
				ValadocApiTypeReference* _tmp33_;
				_tmp32_ = node;
				_tmp33_ = type_ref;
				valadoc_api_interface_set_base_type (_tmp32_, _tmp33_);
			}
			_g_object_unref0 (type_ref);
			_vala_code_node_unref0 (vala_type_ref);
		}
		_vala_iterable_unref0 (_vala_type_ref_list);
	}
	_tmp34_ = node;
	_tmp35_ = ((ValaCodeNode*) element)->attributes;
	valadoc_tree_builder_process_attributes (self, (ValadocApiSymbol*) _tmp34_, _tmp35_);
	_tmp36_ = node;
	valadoc_tree_builder_process_children (self, (ValadocApiNode*) _tmp36_, (ValaCodeNode*) element);
	_g_object_unref0 (node);
	_valadoc_api_source_comment_unref0 (comment);
	_g_object_unref0 (file);
	_g_object_unref0 (parent);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_tree_builder_real_visit_struct (ValaCodeVisitor* base,
                                        ValaStruct* element)
{
	ValadocTreeBuilder * self;
	ValadocApiNode* parent = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiSourceFile* file = NULL;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSourceComment* comment = NULL;
	ValaComment* _tmp2_;
	ValaComment* _tmp3_;
	ValadocApiSourceComment* _tmp4_;
	ValadocApiStruct* node = NULL;
	ValadocApiNode* _tmp5_;
	ValadocApiSourceFile* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	ValaSymbolAccessibility _tmp9_;
	ValaSymbolAccessibility _tmp10_;
	ValadocApiSourceComment* _tmp11_;
	ValadocApiStruct* _tmp12_;
	ValaHashMap* _tmp13_;
	ValadocApiStruct* _tmp14_;
	ValadocApiNode* _tmp15_;
	ValadocApiStruct* _tmp16_;
	ValaValueType* basetype = NULL;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	ValaValueType* _tmp19_;
	ValaValueType* _tmp20_;
	ValadocApiStruct* _tmp27_;
	GList* _tmp28_;
	ValadocApiStruct* _tmp29_;
	self = (ValadocTreeBuilder*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_tree_builder_get_parent_node_for (self, (ValaSymbol*) element);
	parent = _tmp0_;
	_tmp1_ = valadoc_tree_builder_get_source_file (self, (ValaSymbol*) element);
	file = _tmp1_;
	_tmp2_ = vala_symbol_get_comment ((ValaSymbol*) element);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_tree_builder_create_comment (self, _tmp3_);
	comment = _tmp4_;
	_tmp5_ = parent;
	_tmp6_ = file;
	_tmp7_ = vala_symbol_get_name ((ValaSymbol*) element);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_symbol_get_access ((ValaSymbol*) element);
	_tmp10_ = _tmp9_;
	_tmp11_ = comment;
	_tmp12_ = valadoc_api_struct_new (_tmp5_, _tmp6_, _tmp8_, _tmp10_, _tmp11_, element);
	node = _tmp12_;
	_tmp13_ = self->priv->symbol_map;
	_tmp14_ = node;
	vala_map_set ((ValaMap*) _tmp13_, (ValaSymbol*) element, (ValadocApiSymbol*) _tmp14_);
	_tmp15_ = parent;
	_tmp16_ = node;
	valadoc_api_node_add_child (_tmp15_, (ValadocApiSymbol*) _tmp16_);
	_tmp17_ = vala_struct_get_base_type (element);
	_tmp18_ = _tmp17_;
	_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_VALUE_TYPE) ? ((ValaValueType*) _tmp18_) : NULL);
	basetype = _tmp19_;
	_tmp20_ = basetype;
	if (_tmp20_ != NULL) {
		ValadocApiStruct* _tmp21_;
		ValaValueType* _tmp22_;
		ValadocApiStruct* _tmp23_;
		ValadocApiStruct* _tmp24_;
		ValadocApiTypeReference* _tmp25_;
		ValadocApiTypeReference* _tmp26_;
		_tmp21_ = node;
		_tmp22_ = basetype;
		_tmp23_ = node;
		_tmp24_ = node;
		_tmp25_ = valadoc_tree_builder_create_type_reference (self, (ValaDataType*) _tmp22_, (ValadocApiItem*) _tmp23_, (ValadocApiNode*) _tmp24_);
		_tmp26_ = _tmp25_;
		valadoc_api_struct_set_base_type (_tmp21_, _tmp26_);
		_g_object_unref0 (_tmp26_);
	}
	_tmp27_ = node;
	_tmp28_ = ((ValaCodeNode*) element)->attributes;
	valadoc_tree_builder_process_attributes (self, (ValadocApiSymbol*) _tmp27_, _tmp28_);
	_tmp29_ = node;
	valadoc_tree_builder_process_children (self, (ValadocApiNode*) _tmp29_, (ValaCodeNode*) element);
	_vala_code_node_unref0 (basetype);
	_g_object_unref0 (node);
	_valadoc_api_source_comment_unref0 (comment);
	_g_object_unref0 (file);
	_g_object_unref0 (parent);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_tree_builder_real_visit_field (ValaCodeVisitor* base,
                                       ValaField* element)
{
	ValadocTreeBuilder * self;
	ValadocApiNode* parent = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiSourceFile* file = NULL;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSourceComment* comment = NULL;
	ValaComment* _tmp2_;
	ValaComment* _tmp3_;
	ValadocApiSourceComment* _tmp4_;
	ValadocApiField* node = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaSymbolAccessibility _tmp7_;
	ValaSymbolAccessibility _tmp8_;
	ValadocApiField* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValadocApiTypeReference* _tmp12_;
	ValadocApiTypeReference* _tmp13_;
	ValaHashMap* _tmp14_;
	GList* _tmp15_;
	self = (ValadocTreeBuilder*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_tree_builder_get_parent_node_for (self, (ValaSymbol*) element);
	parent = _tmp0_;
	_tmp1_ = valadoc_tree_builder_get_source_file (self, (ValaSymbol*) element);
	file = _tmp1_;
	_tmp2_ = vala_symbol_get_comment ((ValaSymbol*) element);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_tree_builder_create_comment (self, _tmp3_);
	comment = _tmp4_;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) element);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_access ((ValaSymbol*) element);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_api_field_new (parent, file, _tmp6_, _tmp8_, comment, element);
	node = _tmp9_;
	_tmp10_ = vala_variable_get_variable_type ((ValaVariable*) element);
	_tmp11_ = _tmp10_;
	_tmp12_ = valadoc_tree_builder_create_type_reference (self, _tmp11_, (ValadocApiItem*) node, (ValadocApiNode*) node);
	_tmp13_ = _tmp12_;
	valadoc_api_field_set_field_type (node, _tmp13_);
	_g_object_unref0 (_tmp13_);
	_tmp14_ = self->priv->symbol_map;
	vala_map_set ((ValaMap*) _tmp14_, (ValaSymbol*) element, (ValadocApiSymbol*) node);
	valadoc_api_node_add_child (parent, (ValadocApiSymbol*) node);
	_tmp15_ = ((ValaCodeNode*) element)->attributes;
	valadoc_tree_builder_process_attributes (self, (ValadocApiSymbol*) node, _tmp15_);
	valadoc_tree_builder_process_children (self, (ValadocApiNode*) node, (ValaCodeNode*) element);
	_g_object_unref0 (node);
	_valadoc_api_source_comment_unref0 (comment);
	_g_object_unref0 (file);
	_g_object_unref0 (parent);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_tree_builder_real_visit_property (ValaCodeVisitor* base,
                                          ValaProperty* element)
{
	ValadocTreeBuilder * self;
	ValadocApiNode* parent = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiSourceFile* file = NULL;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSourceComment* comment = NULL;
	ValaComment* _tmp2_;
	ValaComment* _tmp3_;
	ValadocApiSourceComment* _tmp4_;
	ValadocApiProperty* node = NULL;
	ValadocApiNode* _tmp5_;
	ValadocApiSourceFile* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	ValaSymbolAccessibility _tmp9_;
	ValaSymbolAccessibility _tmp10_;
	ValadocApiSourceComment* _tmp11_;
	ValadocApiProperty* _tmp12_;
	ValadocApiProperty* _tmp13_;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	ValadocApiProperty* _tmp16_;
	ValadocApiProperty* _tmp17_;
	ValadocApiTypeReference* _tmp18_;
	ValadocApiTypeReference* _tmp19_;
	ValaHashMap* _tmp20_;
	ValadocApiProperty* _tmp21_;
	ValadocApiNode* _tmp22_;
	ValadocApiProperty* _tmp23_;
	ValaPropertyAccessor* _tmp24_;
	ValaPropertyAccessor* _tmp25_;
	ValaPropertyAccessor* _tmp40_;
	ValaPropertyAccessor* _tmp41_;
	ValadocApiProperty* _tmp56_;
	GList* _tmp57_;
	ValadocApiProperty* _tmp58_;
	self = (ValadocTreeBuilder*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_tree_builder_get_parent_node_for (self, (ValaSymbol*) element);
	parent = _tmp0_;
	_tmp1_ = valadoc_tree_builder_get_source_file (self, (ValaSymbol*) element);
	file = _tmp1_;
	_tmp2_ = vala_symbol_get_comment ((ValaSymbol*) element);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_tree_builder_create_comment (self, _tmp3_);
	comment = _tmp4_;
	_tmp5_ = parent;
	_tmp6_ = file;
	_tmp7_ = vala_symbol_get_name ((ValaSymbol*) element);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_symbol_get_access ((ValaSymbol*) element);
	_tmp10_ = _tmp9_;
	_tmp11_ = comment;
	_tmp12_ = valadoc_api_property_new (_tmp5_, _tmp6_, _tmp8_, _tmp10_, _tmp11_, element);
	node = _tmp12_;
	_tmp13_ = node;
	_tmp14_ = vala_property_get_property_type (element);
	_tmp15_ = _tmp14_;
	_tmp16_ = node;
	_tmp17_ = node;
	_tmp18_ = valadoc_tree_builder_create_type_reference (self, _tmp15_, (ValadocApiItem*) _tmp16_, (ValadocApiNode*) _tmp17_);
	_tmp19_ = _tmp18_;
	valadoc_api_property_set_property_type (_tmp13_, _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = self->priv->symbol_map;
	_tmp21_ = node;
	vala_map_set ((ValaMap*) _tmp20_, (ValaSymbol*) element, (ValadocApiSymbol*) _tmp21_);
	_tmp22_ = parent;
	_tmp23_ = node;
	valadoc_api_node_add_child (_tmp22_, (ValadocApiSymbol*) _tmp23_);
	_tmp24_ = vala_property_get_get_accessor (element);
	_tmp25_ = _tmp24_;
	if (_tmp25_ != NULL) {
		ValaPropertyAccessor* accessor = NULL;
		ValaPropertyAccessor* _tmp26_;
		ValaPropertyAccessor* _tmp27_;
		ValaPropertyAccessor* _tmp28_;
		ValadocApiProperty* _tmp29_;
		ValadocApiProperty* _tmp30_;
		ValadocApiSourceFile* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		ValaPropertyAccessor* _tmp34_;
		ValaSymbolAccessibility _tmp35_;
		ValaSymbolAccessibility _tmp36_;
		ValaPropertyAccessor* _tmp37_;
		ValadocApiPropertyAccessor* _tmp38_;
		ValadocApiPropertyAccessor* _tmp39_;
		_tmp26_ = vala_property_get_get_accessor (element);
		_tmp27_ = _tmp26_;
		_tmp28_ = _vala_code_node_ref0 (_tmp27_);
		accessor = _tmp28_;
		_tmp29_ = node;
		_tmp30_ = node;
		_tmp31_ = file;
		_tmp32_ = vala_symbol_get_name ((ValaSymbol*) element);
		_tmp33_ = _tmp32_;
		_tmp34_ = accessor;
		_tmp35_ = vala_symbol_get_access ((ValaSymbol*) _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = accessor;
		_tmp38_ = valadoc_api_property_accessor_new (_tmp30_, _tmp31_, _tmp33_, _tmp36_, _tmp37_);
		_tmp39_ = _tmp38_;
		valadoc_api_property_set_getter (_tmp29_, _tmp39_);
		_g_object_unref0 (_tmp39_);
		_vala_code_node_unref0 (accessor);
	}
	_tmp40_ = vala_property_get_set_accessor (element);
	_tmp41_ = _tmp40_;
	if (_tmp41_ != NULL) {
		ValaPropertyAccessor* accessor = NULL;
		ValaPropertyAccessor* _tmp42_;
		ValaPropertyAccessor* _tmp43_;
		ValaPropertyAccessor* _tmp44_;
		ValadocApiProperty* _tmp45_;
		ValadocApiProperty* _tmp46_;
		ValadocApiSourceFile* _tmp47_;
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		ValaPropertyAccessor* _tmp50_;
		ValaSymbolAccessibility _tmp51_;
		ValaSymbolAccessibility _tmp52_;
		ValaPropertyAccessor* _tmp53_;
		ValadocApiPropertyAccessor* _tmp54_;
		ValadocApiPropertyAccessor* _tmp55_;
		_tmp42_ = vala_property_get_set_accessor (element);
		_tmp43_ = _tmp42_;
		_tmp44_ = _vala_code_node_ref0 (_tmp43_);
		accessor = _tmp44_;
		_tmp45_ = node;
		_tmp46_ = node;
		_tmp47_ = file;
		_tmp48_ = vala_symbol_get_name ((ValaSymbol*) element);
		_tmp49_ = _tmp48_;
		_tmp50_ = accessor;
		_tmp51_ = vala_symbol_get_access ((ValaSymbol*) _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = accessor;
		_tmp54_ = valadoc_api_property_accessor_new (_tmp46_, _tmp47_, _tmp49_, _tmp52_, _tmp53_);
		_tmp55_ = _tmp54_;
		valadoc_api_property_set_setter (_tmp45_, _tmp55_);
		_g_object_unref0 (_tmp55_);
		_vala_code_node_unref0 (accessor);
	}
	_tmp56_ = node;
	_tmp57_ = ((ValaCodeNode*) element)->attributes;
	valadoc_tree_builder_process_attributes (self, (ValadocApiSymbol*) _tmp56_, _tmp57_);
	_tmp58_ = node;
	valadoc_tree_builder_process_children (self, (ValadocApiNode*) _tmp58_, (ValaCodeNode*) element);
	_g_object_unref0 (node);
	_valadoc_api_source_comment_unref0 (comment);
	_g_object_unref0 (file);
	_g_object_unref0 (parent);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_tree_builder_real_visit_creation_method (ValaCodeVisitor* base,
                                                 ValaCreationMethod* element)
{
	ValadocTreeBuilder * self;
	ValadocApiNode* parent = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiSourceFile* file = NULL;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSourceComment* comment = NULL;
	ValaComment* _tmp2_;
	ValaComment* _tmp3_;
	ValadocApiSourceComment* _tmp4_;
	ValadocApiMethod* node = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaSymbolAccessibility _tmp7_;
	ValaSymbolAccessibility _tmp8_;
	ValadocApiMethod* _tmp9_;
	ValadocApiMethod* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValadocApiTypeReference* _tmp13_;
	ValadocApiTypeReference* _tmp14_;
	ValaHashMap* _tmp15_;
	GList* _tmp16_;
	self = (ValadocTreeBuilder*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_tree_builder_get_parent_node_for (self, (ValaSymbol*) element);
	parent = _tmp0_;
	_tmp1_ = valadoc_tree_builder_get_source_file (self, (ValaSymbol*) element);
	file = _tmp1_;
	_tmp2_ = vala_symbol_get_comment ((ValaSymbol*) element);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_tree_builder_create_comment (self, _tmp3_);
	comment = _tmp4_;
	_tmp5_ = valadoc_tree_builder_get_method_name (self, (ValaMethod*) element);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_access ((ValaSymbol*) element);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_api_method_new (parent, file, _tmp6_, _tmp8_, comment, (ValaMethod*) element);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp6_);
	node = _tmp10_;
	_tmp11_ = vala_callable_get_return_type ((ValaCallable*) element);
	_tmp12_ = _tmp11_;
	_tmp13_ = valadoc_tree_builder_create_type_reference (self, _tmp12_, (ValadocApiItem*) node, (ValadocApiNode*) node);
	_tmp14_ = _tmp13_;
	valadoc_api_callable_set_return_type ((ValadocApiCallable*) node, _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = self->priv->symbol_map;
	vala_map_set ((ValaMap*) _tmp15_, (ValaSymbol*) element, (ValadocApiSymbol*) node);
	valadoc_api_node_add_child (parent, (ValadocApiSymbol*) node);
	_tmp16_ = ((ValaCodeNode*) element)->attributes;
	valadoc_tree_builder_process_attributes (self, (ValadocApiSymbol*) node, _tmp16_);
	valadoc_tree_builder_process_children (self, (ValadocApiNode*) node, (ValaCodeNode*) element);
	_g_object_unref0 (node);
	_valadoc_api_source_comment_unref0 (comment);
	_g_object_unref0 (file);
	_g_object_unref0 (parent);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_tree_builder_real_visit_method (ValaCodeVisitor* base,
                                        ValaMethod* element)
{
	ValadocTreeBuilder * self;
	ValadocApiNode* parent = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiSourceFile* file = NULL;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSourceComment* comment = NULL;
	ValaComment* _tmp2_;
	ValaComment* _tmp3_;
	ValadocApiSourceComment* _tmp4_;
	ValadocApiMethod* node = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaSymbolAccessibility _tmp7_;
	ValaSymbolAccessibility _tmp8_;
	ValadocApiMethod* _tmp9_;
	ValadocApiMethod* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValadocApiTypeReference* _tmp13_;
	ValadocApiTypeReference* _tmp14_;
	ValaHashMap* _tmp15_;
	GList* _tmp16_;
	self = (ValadocTreeBuilder*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_tree_builder_get_parent_node_for (self, (ValaSymbol*) element);
	parent = _tmp0_;
	_tmp1_ = valadoc_tree_builder_get_source_file (self, (ValaSymbol*) element);
	file = _tmp1_;
	_tmp2_ = vala_symbol_get_comment ((ValaSymbol*) element);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_tree_builder_create_comment (self, _tmp3_);
	comment = _tmp4_;
	_tmp5_ = valadoc_tree_builder_get_method_name (self, element);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_access ((ValaSymbol*) element);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_api_method_new (parent, file, _tmp6_, _tmp8_, comment, element);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp6_);
	node = _tmp10_;
	_tmp11_ = vala_callable_get_return_type ((ValaCallable*) element);
	_tmp12_ = _tmp11_;
	_tmp13_ = valadoc_tree_builder_create_type_reference (self, _tmp12_, (ValadocApiItem*) node, (ValadocApiNode*) node);
	_tmp14_ = _tmp13_;
	valadoc_api_callable_set_return_type ((ValadocApiCallable*) node, _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = self->priv->symbol_map;
	vala_map_set ((ValaMap*) _tmp15_, (ValaSymbol*) element, (ValadocApiSymbol*) node);
	valadoc_api_node_add_child (parent, (ValadocApiSymbol*) node);
	_tmp16_ = ((ValaCodeNode*) element)->attributes;
	valadoc_tree_builder_process_attributes (self, (ValadocApiSymbol*) node, _tmp16_);
	valadoc_tree_builder_process_children (self, (ValadocApiNode*) node, (ValaCodeNode*) element);
	_g_object_unref0 (node);
	_valadoc_api_source_comment_unref0 (comment);
	_g_object_unref0 (file);
	_g_object_unref0 (parent);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_tree_builder_real_visit_signal (ValaCodeVisitor* base,
                                        ValaSignal* element)
{
	ValadocTreeBuilder * self;
	ValadocApiNode* parent = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiSourceFile* file = NULL;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSourceComment* comment = NULL;
	ValaComment* _tmp2_;
	ValaComment* _tmp3_;
	ValadocApiSourceComment* _tmp4_;
	ValadocApiSignal* node = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaSymbolAccessibility _tmp7_;
	ValaSymbolAccessibility _tmp8_;
	ValadocApiSignal* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValadocApiTypeReference* _tmp12_;
	ValadocApiTypeReference* _tmp13_;
	ValaHashMap* _tmp14_;
	GList* _tmp15_;
	self = (ValadocTreeBuilder*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_tree_builder_get_parent_node_for (self, (ValaSymbol*) element);
	parent = _tmp0_;
	_tmp1_ = valadoc_tree_builder_get_source_file (self, (ValaSymbol*) element);
	file = _tmp1_;
	_tmp2_ = vala_symbol_get_comment ((ValaSymbol*) element);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_tree_builder_create_comment (self, _tmp3_);
	comment = _tmp4_;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) element);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_access ((ValaSymbol*) element);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_api_signal_new (parent, file, _tmp6_, _tmp8_, comment, element);
	node = _tmp9_;
	_tmp10_ = vala_callable_get_return_type ((ValaCallable*) element);
	_tmp11_ = _tmp10_;
	_tmp12_ = valadoc_tree_builder_create_type_reference (self, _tmp11_, (ValadocApiItem*) node, (ValadocApiNode*) node);
	_tmp13_ = _tmp12_;
	valadoc_api_callable_set_return_type ((ValadocApiCallable*) node, _tmp13_);
	_g_object_unref0 (_tmp13_);
	_tmp14_ = self->priv->symbol_map;
	vala_map_set ((ValaMap*) _tmp14_, (ValaSymbol*) element, (ValadocApiSymbol*) node);
	valadoc_api_node_add_child (parent, (ValadocApiSymbol*) node);
	_tmp15_ = ((ValaCodeNode*) element)->attributes;
	valadoc_tree_builder_process_attributes (self, (ValadocApiSymbol*) node, _tmp15_);
	valadoc_tree_builder_process_children (self, (ValadocApiNode*) node, (ValaCodeNode*) element);
	_g_object_unref0 (node);
	_valadoc_api_source_comment_unref0 (comment);
	_g_object_unref0 (file);
	_g_object_unref0 (parent);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_tree_builder_real_visit_delegate (ValaCodeVisitor* base,
                                          ValaDelegate* element)
{
	ValadocTreeBuilder * self;
	ValadocApiNode* parent = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiSourceFile* file = NULL;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSourceComment* comment = NULL;
	ValaComment* _tmp2_;
	ValaComment* _tmp3_;
	ValadocApiSourceComment* _tmp4_;
	ValadocApiDelegate* node = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaSymbolAccessibility _tmp7_;
	ValaSymbolAccessibility _tmp8_;
	ValadocApiDelegate* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValadocApiTypeReference* _tmp12_;
	ValadocApiTypeReference* _tmp13_;
	ValaHashMap* _tmp14_;
	GList* _tmp15_;
	self = (ValadocTreeBuilder*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_tree_builder_get_parent_node_for (self, (ValaSymbol*) element);
	parent = _tmp0_;
	_tmp1_ = valadoc_tree_builder_get_source_file (self, (ValaSymbol*) element);
	file = _tmp1_;
	_tmp2_ = vala_symbol_get_comment ((ValaSymbol*) element);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_tree_builder_create_comment (self, _tmp3_);
	comment = _tmp4_;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) element);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_access ((ValaSymbol*) element);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_api_delegate_new (parent, file, _tmp6_, _tmp8_, comment, element);
	node = _tmp9_;
	_tmp10_ = vala_callable_get_return_type ((ValaCallable*) element);
	_tmp11_ = _tmp10_;
	_tmp12_ = valadoc_tree_builder_create_type_reference (self, _tmp11_, (ValadocApiItem*) node, (ValadocApiNode*) node);
	_tmp13_ = _tmp12_;
	valadoc_api_callable_set_return_type ((ValadocApiCallable*) node, _tmp13_);
	_g_object_unref0 (_tmp13_);
	_tmp14_ = self->priv->symbol_map;
	vala_map_set ((ValaMap*) _tmp14_, (ValaSymbol*) element, (ValadocApiSymbol*) node);
	valadoc_api_node_add_child (parent, (ValadocApiSymbol*) node);
	_tmp15_ = ((ValaCodeNode*) element)->attributes;
	valadoc_tree_builder_process_attributes (self, (ValadocApiSymbol*) node, _tmp15_);
	valadoc_tree_builder_process_children (self, (ValadocApiNode*) node, (ValaCodeNode*) element);
	_g_object_unref0 (node);
	_valadoc_api_source_comment_unref0 (comment);
	_g_object_unref0 (file);
	_g_object_unref0 (parent);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_tree_builder_real_visit_enum (ValaCodeVisitor* base,
                                      ValaEnum* element)
{
	ValadocTreeBuilder * self;
	ValadocApiNode* parent = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiSourceFile* file = NULL;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSourceComment* comment = NULL;
	ValaComment* _tmp2_;
	ValaComment* _tmp3_;
	ValadocApiSourceComment* _tmp4_;
	ValadocApiSymbol* node = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaSymbolAccessibility _tmp7_;
	ValaSymbolAccessibility _tmp8_;
	ValadocApiEnum* _tmp9_;
	ValaHashMap* _tmp10_;
	GList* _tmp11_;
	self = (ValadocTreeBuilder*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_tree_builder_get_parent_node_for (self, (ValaSymbol*) element);
	parent = _tmp0_;
	_tmp1_ = valadoc_tree_builder_get_source_file (self, (ValaSymbol*) element);
	file = _tmp1_;
	_tmp2_ = vala_symbol_get_comment ((ValaSymbol*) element);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_tree_builder_create_comment (self, _tmp3_);
	comment = _tmp4_;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) element);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_access ((ValaSymbol*) element);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_api_enum_new (parent, file, _tmp6_, _tmp8_, comment, element);
	node = (ValadocApiSymbol*) _tmp9_;
	_tmp10_ = self->priv->symbol_map;
	vala_map_set ((ValaMap*) _tmp10_, (ValaSymbol*) element, node);
	valadoc_api_node_add_child (parent, node);
	_tmp11_ = ((ValaCodeNode*) element)->attributes;
	valadoc_tree_builder_process_attributes (self, node, _tmp11_);
	valadoc_tree_builder_process_children (self, (ValadocApiNode*) node, (ValaCodeNode*) element);
	_g_object_unref0 (node);
	_valadoc_api_source_comment_unref0 (comment);
	_g_object_unref0 (file);
	_g_object_unref0 (parent);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_tree_builder_real_visit_enum_value (ValaCodeVisitor* base,
                                            ValaEnumValue* element)
{
	ValadocTreeBuilder * self;
	ValadocApiEnum* parent = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiSourceFile* file = NULL;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSourceComment* comment = NULL;
	ValaComment* _tmp2_;
	ValaComment* _tmp3_;
	ValadocApiSourceComment* _tmp4_;
	ValadocApiSymbol* node = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValadocApiEnumValue* _tmp7_;
	ValaHashMap* _tmp8_;
	GList* _tmp9_;
	self = (ValadocTreeBuilder*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_tree_builder_get_parent_node_for (self, (ValaSymbol*) element);
	parent = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_API_TYPE_ENUM, ValadocApiEnum);
	_tmp1_ = valadoc_tree_builder_get_source_file (self, (ValaSymbol*) element);
	file = _tmp1_;
	_tmp2_ = vala_symbol_get_comment ((ValaSymbol*) element);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_tree_builder_create_comment (self, _tmp3_);
	comment = _tmp4_;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) element);
	_tmp6_ = _tmp5_;
	_tmp7_ = valadoc_api_enum_value_new (parent, file, _tmp6_, comment, element);
	node = (ValadocApiSymbol*) _tmp7_;
	_tmp8_ = self->priv->symbol_map;
	vala_map_set ((ValaMap*) _tmp8_, (ValaSymbol*) element, node);
	valadoc_api_node_add_child ((ValadocApiNode*) parent, node);
	_tmp9_ = ((ValaCodeNode*) element)->attributes;
	valadoc_tree_builder_process_attributes (self, node, _tmp9_);
	valadoc_tree_builder_process_children (self, (ValadocApiNode*) node, (ValaCodeNode*) element);
	_g_object_unref0 (node);
	_valadoc_api_source_comment_unref0 (comment);
	_g_object_unref0 (file);
	_g_object_unref0 (parent);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_tree_builder_real_visit_constant (ValaCodeVisitor* base,
                                          ValaConstant* element)
{
	ValadocTreeBuilder * self;
	ValadocApiNode* parent = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiSourceFile* file = NULL;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSourceComment* comment = NULL;
	ValaComment* _tmp2_;
	ValaComment* _tmp3_;
	ValadocApiSourceComment* _tmp4_;
	ValadocApiConstant* node = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaSymbolAccessibility _tmp7_;
	ValaSymbolAccessibility _tmp8_;
	ValadocApiConstant* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValadocApiTypeReference* _tmp12_;
	ValadocApiTypeReference* _tmp13_;
	ValaHashMap* _tmp14_;
	GList* _tmp15_;
	self = (ValadocTreeBuilder*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_tree_builder_get_parent_node_for (self, (ValaSymbol*) element);
	parent = _tmp0_;
	_tmp1_ = valadoc_tree_builder_get_source_file (self, (ValaSymbol*) element);
	file = _tmp1_;
	_tmp2_ = vala_symbol_get_comment ((ValaSymbol*) element);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_tree_builder_create_comment (self, _tmp3_);
	comment = _tmp4_;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) element);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_access ((ValaSymbol*) element);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_api_constant_new (parent, file, _tmp6_, _tmp8_, comment, element);
	node = _tmp9_;
	_tmp10_ = vala_constant_get_type_reference (element);
	_tmp11_ = _tmp10_;
	_tmp12_ = valadoc_tree_builder_create_type_reference (self, _tmp11_, (ValadocApiItem*) node, (ValadocApiNode*) node);
	_tmp13_ = _tmp12_;
	valadoc_api_constant_set_constant_type (node, _tmp13_);
	_g_object_unref0 (_tmp13_);
	_tmp14_ = self->priv->symbol_map;
	vala_map_set ((ValaMap*) _tmp14_, (ValaSymbol*) element, (ValadocApiSymbol*) node);
	valadoc_api_node_add_child (parent, (ValadocApiSymbol*) node);
	_tmp15_ = ((ValaCodeNode*) element)->attributes;
	valadoc_tree_builder_process_attributes (self, (ValadocApiSymbol*) node, _tmp15_);
	valadoc_tree_builder_process_children (self, (ValadocApiNode*) node, (ValaCodeNode*) element);
	_g_object_unref0 (node);
	_valadoc_api_source_comment_unref0 (comment);
	_g_object_unref0 (file);
	_g_object_unref0 (parent);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_tree_builder_real_visit_error_domain (ValaCodeVisitor* base,
                                              ValaErrorDomain* element)
{
	ValadocTreeBuilder * self;
	ValadocApiNode* parent = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiSourceFile* file = NULL;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSourceComment* comment = NULL;
	ValaComment* _tmp2_;
	ValaComment* _tmp3_;
	ValadocApiSourceComment* _tmp4_;
	ValadocApiSymbol* node = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaSymbolAccessibility _tmp7_;
	ValaSymbolAccessibility _tmp8_;
	ValadocApiErrorDomain* _tmp9_;
	ValaHashMap* _tmp10_;
	GList* _tmp11_;
	self = (ValadocTreeBuilder*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_tree_builder_get_parent_node_for (self, (ValaSymbol*) element);
	parent = _tmp0_;
	_tmp1_ = valadoc_tree_builder_get_source_file (self, (ValaSymbol*) element);
	file = _tmp1_;
	_tmp2_ = vala_symbol_get_comment ((ValaSymbol*) element);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_tree_builder_create_comment (self, _tmp3_);
	comment = _tmp4_;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) element);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_access ((ValaSymbol*) element);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_api_error_domain_new (parent, file, _tmp6_, _tmp8_, comment, element);
	node = (ValadocApiSymbol*) _tmp9_;
	_tmp10_ = self->priv->symbol_map;
	vala_map_set ((ValaMap*) _tmp10_, (ValaSymbol*) element, node);
	valadoc_api_node_add_child (parent, node);
	_tmp11_ = ((ValaCodeNode*) element)->attributes;
	valadoc_tree_builder_process_attributes (self, node, _tmp11_);
	valadoc_tree_builder_process_children (self, (ValadocApiNode*) node, (ValaCodeNode*) element);
	_g_object_unref0 (node);
	_valadoc_api_source_comment_unref0 (comment);
	_g_object_unref0 (file);
	_g_object_unref0 (parent);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_tree_builder_real_visit_error_code (ValaCodeVisitor* base,
                                            ValaErrorCode* element)
{
	ValadocTreeBuilder * self;
	ValadocApiErrorDomain* parent = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiSourceFile* file = NULL;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSourceFile* _tmp2_;
	ValadocApiSourceComment* comment = NULL;
	ValaComment* _tmp5_;
	ValaComment* _tmp6_;
	ValadocApiSourceComment* _tmp7_;
	ValadocApiSymbol* node = NULL;
	ValadocApiErrorDomain* _tmp8_;
	ValadocApiSourceFile* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ValadocApiErrorCode* _tmp12_;
	ValaHashMap* _tmp13_;
	ValadocApiErrorDomain* _tmp14_;
	GList* _tmp15_;
	self = (ValadocTreeBuilder*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_tree_builder_get_parent_node_for (self, (ValaSymbol*) element);
	parent = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_API_TYPE_ERROR_DOMAIN, ValadocApiErrorDomain);
	_tmp1_ = valadoc_tree_builder_get_source_file (self, (ValaSymbol*) element);
	file = _tmp1_;
	_tmp2_ = file;
	if (_tmp2_ == NULL) {
		ValadocApiErrorDomain* _tmp3_;
		ValadocApiSourceFile* _tmp4_;
		_tmp3_ = parent;
		_tmp4_ = valadoc_api_node_get_source_file ((ValadocApiNode*) _tmp3_);
		_g_object_unref0 (file);
		file = _tmp4_;
	}
	_tmp5_ = vala_symbol_get_comment ((ValaSymbol*) element);
	_tmp6_ = _tmp5_;
	_tmp7_ = valadoc_tree_builder_create_comment (self, _tmp6_);
	comment = _tmp7_;
	_tmp8_ = parent;
	_tmp9_ = file;
	_tmp10_ = vala_symbol_get_name ((ValaSymbol*) element);
	_tmp11_ = _tmp10_;
	_tmp12_ = valadoc_api_error_code_new (_tmp8_, _tmp9_, _tmp11_, comment, element);
	node = (ValadocApiSymbol*) _tmp12_;
	_tmp13_ = self->priv->symbol_map;
	vala_map_set ((ValaMap*) _tmp13_, (ValaSymbol*) element, node);
	_tmp14_ = parent;
	valadoc_api_node_add_child ((ValadocApiNode*) _tmp14_, node);
	_tmp15_ = ((ValaCodeNode*) element)->attributes;
	valadoc_tree_builder_process_attributes (self, node, _tmp15_);
	valadoc_tree_builder_process_children (self, (ValadocApiNode*) node, (ValaCodeNode*) element);
	_g_object_unref0 (node);
	_valadoc_api_source_comment_unref0 (comment);
	_g_object_unref0 (file);
	_g_object_unref0 (parent);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_tree_builder_real_visit_type_parameter (ValaCodeVisitor* base,
                                                ValaTypeParameter* element)
{
	ValadocTreeBuilder * self;
	ValadocApiNode* parent = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiSourceFile* file = NULL;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSymbol* node = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValadocApiTypeParameter* _tmp4_;
	ValaHashMap* _tmp5_;
	self = (ValadocTreeBuilder*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_tree_builder_get_parent_node_for (self, (ValaSymbol*) element);
	parent = _tmp0_;
	_tmp1_ = valadoc_tree_builder_get_source_file (self, (ValaSymbol*) element);
	file = _tmp1_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) element);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_api_typeparameter_new (parent, file, _tmp3_, element);
	node = (ValadocApiSymbol*) _tmp4_;
	_tmp5_ = self->priv->symbol_map;
	vala_map_set ((ValaMap*) _tmp5_, (ValaSymbol*) element, node);
	valadoc_api_node_add_child (parent, node);
	valadoc_tree_builder_process_children (self, (ValadocApiNode*) node, (ValaCodeNode*) element);
	_g_object_unref0 (node);
	_g_object_unref0 (file);
	_g_object_unref0 (parent);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_tree_builder_real_visit_formal_parameter (ValaCodeVisitor* base,
                                                  ValaParameter* element)
{
	ValadocTreeBuilder * self;
	ValadocApiNode* parent = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiSourceFile* file = NULL;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiFormalParameter* node = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbolAccessibility _tmp4_;
	ValaSymbolAccessibility _tmp5_;
	ValaParameterDirection _tmp6_;
	ValaParameterDirection _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	ValadocApiFormalParameter* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValadocApiTypeReference* _tmp13_;
	ValadocApiTypeReference* _tmp14_;
	self = (ValadocTreeBuilder*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_tree_builder_get_parent_node_for (self, (ValaSymbol*) element);
	parent = _tmp0_;
	_tmp1_ = valadoc_tree_builder_get_source_file (self, (ValaSymbol*) element);
	file = _tmp1_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) element);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_symbol_get_access ((ValaSymbol*) element);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_parameter_get_direction (element);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_parameter_get_ellipsis (element);
	_tmp9_ = _tmp8_;
	_tmp10_ = valadoc_api_formal_parameter_new (parent, file, _tmp3_, _tmp5_, _tmp7_, _tmp9_, element);
	node = _tmp10_;
	_tmp11_ = vala_variable_get_variable_type ((ValaVariable*) element);
	_tmp12_ = _tmp11_;
	_tmp13_ = valadoc_tree_builder_create_type_reference (self, _tmp12_, (ValadocApiItem*) node, (ValadocApiNode*) node);
	_tmp14_ = _tmp13_;
	valadoc_api_formal_parameter_set_parameter_type (node, _tmp14_);
	_g_object_unref0 (_tmp14_);
	valadoc_api_node_add_child (parent, (ValadocApiSymbol*) node);
	valadoc_tree_builder_process_children (self, (ValadocApiNode*) node, (ValaCodeNode*) element);
	_g_object_unref0 (node);
	_g_object_unref0 (file);
	_g_object_unref0 (parent);
}

static gpointer
_valadoc_api_tree_ref0 (gpointer self)
{
	return self ? valadoc_api_tree_ref (self) : NULL;
}

ValadocApiTree*
valadoc_tree_builder_build (ValadocTreeBuilder* self,
                            ValadocSettings* settings,
                            ValadocErrorReporter* reporter)
{
	ValadocSettings* _tmp0_;
	ValadocErrorReporter* _tmp1_;
	ValaCodeContext* context = NULL;
	ValaCodeContext* _tmp2_;
	ValaCodeContext* _tmp3_;
	ValaCodeContext* _tmp4_;
	ValadocApiTree* _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaCodeContext* _tmp7_;
	ValaReport* _tmp8_;
	ValaReport* _tmp9_;
	ValaCodeContext* _tmp10_;
	ValaReport* _tmp11_;
	ValaReport* _tmp12_;
	ValaCodeContext* _tmp45_;
	ValadocApiTree* _tmp46_ = NULL;
	gint _tmp47_;
	gint _tmp48_;
	ValadocApiTree* _tmp50_;
	ValadocApiTree* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = _g_object_ref0 (reporter);
	_g_object_unref0 (self->priv->reporter);
	self->priv->reporter = _tmp1_;
	_tmp2_ = vala_code_context_new ();
	context = _tmp2_;
	_tmp3_ = context;
	vala_code_context_push (_tmp3_);
	_tmp4_ = context;
	_tmp5_ = valadoc_api_tree_new (reporter, settings, _tmp4_);
	_valadoc_api_tree_unref0 (self->priv->tree);
	self->priv->tree = _tmp5_;
	_tmp6_ = context;
	valadoc_tree_builder_create_valac_tree (self, _tmp6_, settings);
	_tmp7_ = context;
	_tmp8_ = vala_code_context_get_report (_tmp7_);
	_tmp9_ = _tmp8_;
	valadoc_error_reporter_set_warnings_offset (reporter, vala_report_get_warnings (_tmp9_));
	_tmp10_ = context;
	_tmp11_ = vala_code_context_get_report (_tmp10_);
	_tmp12_ = _tmp11_;
	valadoc_error_reporter_set_errors_offset (reporter, vala_report_get_errors (_tmp12_));
	{
		ValaList* _vfile_list = NULL;
		ValaCodeContext* _tmp13_;
		ValaList* _tmp14_;
		gint _vfile_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _vfile_index = 0;
		_tmp13_ = context;
		_tmp14_ = vala_code_context_get_source_files (_tmp13_);
		_vfile_list = _tmp14_;
		_tmp15_ = _vfile_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_vfile_size = _tmp17_;
		_vfile_index = -1;
		while (TRUE) {
			ValaSourceFile* vfile = NULL;
			ValaList* _tmp18_;
			gpointer _tmp19_;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			ValaSourceFile* _tmp22_;
			ValaSourceFileType _tmp23_;
			ValaSourceFileType _tmp24_;
			_vfile_index = _vfile_index + 1;
			if (!(_vfile_index < _vfile_size)) {
				break;
			}
			_tmp18_ = _vfile_list;
			_tmp19_ = vala_list_get (_tmp18_, _vfile_index);
			vfile = (ValaSourceFile*) _tmp19_;
			_tmp22_ = vfile;
			_tmp23_ = vala_source_file_get_file_type (_tmp22_);
			_tmp24_ = _tmp23_;
			if (_tmp24_ == VALA_SOURCE_FILE_TYPE_PACKAGE) {
				ValaSourceFile* _tmp25_;
				ValaList* _tmp26_;
				ValaList* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				_tmp25_ = vfile;
				_tmp26_ = vala_source_file_get_nodes (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
				_tmp29_ = _tmp28_;
				_tmp21_ = _tmp29_ > 0;
				_vala_iterable_unref0 (_tmp27_);
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				ValaHashMap* _tmp30_;
				ValaSourceFile* _tmp31_;
				_tmp30_ = self->priv->files;
				_tmp31_ = vfile;
				_tmp20_ = vala_map_contains ((ValaMap*) _tmp30_, _tmp31_) == FALSE;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				ValadocApiPackage* vdpkg = NULL;
				ValaSourceFile* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				ValadocApiPackage* _tmp37_;
				ValadocApiPackage* _tmp38_;
				ValadocApiPackage* _tmp39_;
				ValadocTreeBuilderPackageMetaData* _tmp40_;
				ValadocTreeBuilderPackageMetaData* _tmp41_;
				ValaSourceFile* _tmp42_;
				ValadocApiSourceFile* _tmp43_;
				ValadocApiSourceFile* _tmp44_;
				_tmp32_ = vfile;
				_tmp33_ = vala_source_file_get_filename (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = valadoc_tree_builder_get_package_name (self, _tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = valadoc_api_package_new (_tmp36_, TRUE, NULL);
				_tmp38_ = _tmp37_;
				_g_free0 (_tmp36_);
				vdpkg = _tmp38_;
				_tmp39_ = vdpkg;
				_tmp40_ = valadoc_tree_builder_register_package (self, _tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = vfile;
				_tmp43_ = valadoc_tree_builder_register_source_file (self, _tmp41_, _tmp42_);
				_tmp44_ = _tmp43_;
				_g_object_unref0 (_tmp44_);
				_valadoc_tree_builder_package_meta_data_unref0 (_tmp41_);
				_g_object_unref0 (vdpkg);
			}
			_vala_source_file_unref0 (vfile);
		}
		_vala_iterable_unref0 (_vfile_list);
	}
	_tmp45_ = context;
	vala_code_context_accept (_tmp45_, (ValaCodeVisitor*) self);
	_tmp47_ = valadoc_error_reporter_get_errors (reporter);
	_tmp48_ = _tmp47_;
	if (_tmp48_ == 0) {
		ValadocApiTree* _tmp49_;
		_tmp49_ = self->priv->tree;
		_tmp46_ = _tmp49_;
	} else {
		_tmp46_ = NULL;
	}
	_tmp50_ = _valadoc_api_tree_ref0 (_tmp46_);
	result = _tmp50_;
	_vala_code_context_unref0 (context);
	return result;
}

ValadocTreeBuilder*
valadoc_tree_builder_construct (GType object_type)
{
	ValadocTreeBuilder* self = NULL;
	self = (ValadocTreeBuilder*) vala_code_visitor_construct (object_type);
	return self;
}

ValadocTreeBuilder*
valadoc_tree_builder_new (void)
{
	return valadoc_tree_builder_construct (VALADOC_TYPE_TREE_BUILDER);
}

static ValadocTreeBuilderPackageMetaData*
valadoc_tree_builder_package_meta_data_construct (GType object_type,
                                                  ValadocApiPackage* package)
{
	ValadocTreeBuilderPackageMetaData* self = NULL;
	ValadocApiPackage* _tmp0_;
	g_return_val_if_fail (package != NULL, NULL);
	self = (ValadocTreeBuilderPackageMetaData*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (package);
	_g_object_unref0 (self->package);
	self->package = _tmp0_;
	return self;
}

static ValadocTreeBuilderPackageMetaData*
valadoc_tree_builder_package_meta_data_new (ValadocApiPackage* package)
{
	return valadoc_tree_builder_package_meta_data_construct (VALADOC_TREE_BUILDER_TYPE_PACKAGE_META_DATA, package);
}

static ValadocApiNamespace*
valadoc_tree_builder_package_meta_data_get_namespace (ValadocTreeBuilderPackageMetaData* self,
                                                      ValaNamespace* vns,
                                                      ValadocApiSourceFile* file)
{
	ValadocApiNamespace* ns = NULL;
	ValaHashMap* _tmp0_;
	gpointer _tmp1_;
	ValadocApiNamespace* _tmp2_;
	ValadocApiSourceComment* comment = NULL;
	ValaSourceReference* _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSymbol* parent_vns = NULL;
	ValaSymbol* _tmp68_;
	ValaSymbol* _tmp69_;
	ValaSymbol* _tmp70_;
	ValaSymbol* _tmp71_;
	ValaHashMap* _tmp88_;
	ValadocApiNamespace* _tmp89_;
	ValadocApiNamespace* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (vns != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = self->namespaces;
	_tmp1_ = vala_map_get ((ValaMap*) _tmp0_, vns);
	ns = (ValadocApiNamespace*) _tmp1_;
	_tmp2_ = ns;
	if (_tmp2_ != NULL) {
		result = ns;
		return result;
	}
	comment = NULL;
	_tmp3_ = vala_code_node_get_source_reference ((ValaCodeNode*) vns);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		{
			ValaList* _c_list = NULL;
			ValaList* _tmp5_;
			gint _c_size = 0;
			ValaList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _c_index = 0;
			_tmp5_ = vala_namespace_get_comments (vns);
			_c_list = _tmp5_;
			_tmp6_ = _c_list;
			_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_c_size = _tmp8_;
			_c_index = -1;
			while (TRUE) {
				ValaComment* c = NULL;
				ValaList* _tmp9_;
				gpointer _tmp10_;
				gboolean _tmp11_ = FALSE;
				ValaComment* _tmp12_;
				ValaSourceReference* _tmp13_;
				ValaSourceReference* _tmp14_;
				ValaSourceFile* _tmp15_;
				ValaSourceFile* _tmp16_;
				ValaSourceFile* _tmp17_;
				ValaSourceFile* _tmp18_;
				_c_index = _c_index + 1;
				if (!(_c_index < _c_size)) {
					break;
				}
				_tmp9_ = _c_list;
				_tmp10_ = vala_list_get (_tmp9_, _c_index);
				c = (ValaComment*) _tmp10_;
				_tmp12_ = c;
				_tmp13_ = vala_comment_get_source_reference (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = vala_source_reference_get_file (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = valadoc_api_source_file_get_data (file);
				_tmp18_ = _tmp17_;
				if (_tmp16_ == _tmp18_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp19_ = FALSE;
					ValaComment* _tmp20_;
					ValaSourceReference* _tmp21_;
					ValaSourceReference* _tmp22_;
					ValaSourceFile* _tmp23_;
					ValaSourceFile* _tmp24_;
					ValaSourceFileType _tmp25_;
					ValaSourceFileType _tmp26_;
					_tmp20_ = c;
					_tmp21_ = vala_comment_get_source_reference (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = vala_source_reference_get_file (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = vala_source_file_get_file_type (_tmp24_);
					_tmp26_ = _tmp25_;
					if (_tmp26_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
						ValaSourceFile* _tmp27_;
						ValaSourceFile* _tmp28_;
						ValaSourceFileType _tmp29_;
						ValaSourceFileType _tmp30_;
						_tmp27_ = valadoc_api_source_file_get_data (file);
						_tmp28_ = _tmp27_;
						_tmp29_ = vala_source_file_get_file_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_SOURCE_FILE, ValaSourceFile));
						_tmp30_ = _tmp29_;
						_tmp19_ = _tmp30_ == VALA_SOURCE_FILE_TYPE_SOURCE;
					} else {
						_tmp19_ = FALSE;
					}
					_tmp11_ = _tmp19_;
				}
				if (_tmp11_) {
					ValaSourceReference* pos = NULL;
					ValaComment* _tmp31_;
					ValaSourceReference* _tmp32_;
					ValaSourceReference* _tmp33_;
					ValaSourceReference* _tmp34_;
					ValaComment* _tmp35_;
					_tmp31_ = c;
					_tmp32_ = vala_comment_get_source_reference (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = _vala_source_reference_ref0 (_tmp33_);
					pos = _tmp34_;
					_tmp35_ = c;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, VALA_TYPE_GIR_COMMENT)) {
						ValaComment* _tmp36_;
						const gchar* _tmp37_;
						const gchar* _tmp38_;
						ValaSourceReference* _tmp39_;
						ValaSourceLocation _tmp40_ = {0};
						ValaSourceLocation _tmp41_;
						ValaSourceReference* _tmp42_;
						ValaSourceLocation _tmp43_ = {0};
						ValaSourceLocation _tmp44_;
						ValaSourceReference* _tmp45_;
						ValaSourceLocation _tmp46_ = {0};
						ValaSourceLocation _tmp47_;
						ValaSourceReference* _tmp48_;
						ValaSourceLocation _tmp49_ = {0};
						ValaSourceLocation _tmp50_;
						ValadocApiGirSourceComment* _tmp51_;
						_tmp36_ = c;
						_tmp37_ = vala_comment_get_content (_tmp36_);
						_tmp38_ = _tmp37_;
						_tmp39_ = pos;
						vala_source_reference_get_begin (_tmp39_, &_tmp40_);
						_tmp41_ = _tmp40_;
						_tmp42_ = pos;
						vala_source_reference_get_begin (_tmp42_, &_tmp43_);
						_tmp44_ = _tmp43_;
						_tmp45_ = pos;
						vala_source_reference_get_end (_tmp45_, &_tmp46_);
						_tmp47_ = _tmp46_;
						_tmp48_ = pos;
						vala_source_reference_get_end (_tmp48_, &_tmp49_);
						_tmp50_ = _tmp49_;
						_tmp51_ = valadoc_api_gir_source_comment_new (_tmp38_, file, _tmp41_.line, _tmp44_.column, _tmp47_.line, _tmp50_.column);
						_valadoc_api_source_comment_unref0 (comment);
						comment = (ValadocApiSourceComment*) _tmp51_;
					} else {
						ValaComment* _tmp52_;
						const gchar* _tmp53_;
						const gchar* _tmp54_;
						ValaSourceReference* _tmp55_;
						ValaSourceLocation _tmp56_ = {0};
						ValaSourceLocation _tmp57_;
						ValaSourceReference* _tmp58_;
						ValaSourceLocation _tmp59_ = {0};
						ValaSourceLocation _tmp60_;
						ValaSourceReference* _tmp61_;
						ValaSourceLocation _tmp62_ = {0};
						ValaSourceLocation _tmp63_;
						ValaSourceReference* _tmp64_;
						ValaSourceLocation _tmp65_ = {0};
						ValaSourceLocation _tmp66_;
						ValadocApiSourceComment* _tmp67_;
						_tmp52_ = c;
						_tmp53_ = vala_comment_get_content (_tmp52_);
						_tmp54_ = _tmp53_;
						_tmp55_ = pos;
						vala_source_reference_get_begin (_tmp55_, &_tmp56_);
						_tmp57_ = _tmp56_;
						_tmp58_ = pos;
						vala_source_reference_get_begin (_tmp58_, &_tmp59_);
						_tmp60_ = _tmp59_;
						_tmp61_ = pos;
						vala_source_reference_get_end (_tmp61_, &_tmp62_);
						_tmp63_ = _tmp62_;
						_tmp64_ = pos;
						vala_source_reference_get_end (_tmp64_, &_tmp65_);
						_tmp66_ = _tmp65_;
						_tmp67_ = valadoc_api_source_comment_new (_tmp54_, file, _tmp57_.line, _tmp60_.column, _tmp63_.line, _tmp66_.column);
						_valadoc_api_source_comment_unref0 (comment);
						comment = _tmp67_;
					}
					_vala_source_reference_unref0 (pos);
					_vala_comment_unref0 (c);
					break;
				}
				_vala_comment_unref0 (c);
			}
			_vala_iterable_unref0 (_c_list);
		}
	}
	_tmp68_ = vala_symbol_get_parent_symbol ((ValaSymbol*) vns);
	_tmp69_ = _tmp68_;
	_tmp70_ = _vala_code_node_ref0 (_tmp69_);
	parent_vns = _tmp70_;
	_tmp71_ = parent_vns;
	if (_tmp71_ == NULL) {
		ValadocApiPackage* _tmp72_;
		const gchar* _tmp73_;
		const gchar* _tmp74_;
		ValadocApiSourceComment* _tmp75_;
		ValadocApiNamespace* _tmp76_;
		ValadocApiPackage* _tmp77_;
		ValadocApiNamespace* _tmp78_;
		_tmp72_ = self->package;
		_tmp73_ = vala_symbol_get_name ((ValaSymbol*) vns);
		_tmp74_ = _tmp73_;
		_tmp75_ = comment;
		_tmp76_ = valadoc_api_namespace_new ((ValadocApiNode*) _tmp72_, file, _tmp74_, _tmp75_, vns);
		_g_object_unref0 (ns);
		ns = _tmp76_;
		_tmp77_ = self->package;
		_tmp78_ = ns;
		valadoc_api_node_add_child ((ValadocApiNode*) _tmp77_, (ValadocApiSymbol*) _tmp78_);
	} else {
		ValadocApiNamespace* parent_ns = NULL;
		ValaSymbol* _tmp79_;
		ValadocApiNamespace* _tmp80_;
		ValadocApiNamespace* _tmp81_;
		const gchar* _tmp82_;
		const gchar* _tmp83_;
		ValadocApiSourceComment* _tmp84_;
		ValadocApiNamespace* _tmp85_;
		ValadocApiNamespace* _tmp86_;
		ValadocApiNamespace* _tmp87_;
		_tmp79_ = parent_vns;
		_tmp80_ = valadoc_tree_builder_package_meta_data_get_namespace (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALA_TYPE_NAMESPACE, ValaNamespace), file);
		parent_ns = _tmp80_;
		_tmp81_ = parent_ns;
		_tmp82_ = vala_symbol_get_name ((ValaSymbol*) vns);
		_tmp83_ = _tmp82_;
		_tmp84_ = comment;
		_tmp85_ = valadoc_api_namespace_new ((ValadocApiNode*) _tmp81_, file, _tmp83_, _tmp84_, vns);
		_g_object_unref0 (ns);
		ns = _tmp85_;
		_tmp86_ = parent_ns;
		_tmp87_ = ns;
		valadoc_api_node_add_child ((ValadocApiNode*) _tmp86_, (ValadocApiSymbol*) _tmp87_);
		_g_object_unref0 (parent_ns);
	}
	_tmp88_ = self->namespaces;
	_tmp89_ = ns;
	vala_map_set ((ValaMap*) _tmp88_, vns, _tmp89_);
	result = ns;
	_vala_code_node_unref0 (parent_vns);
	_valadoc_api_source_comment_unref0 (comment);
	return result;
}

static void
valadoc_tree_builder_package_meta_data_register_source_file (ValadocTreeBuilderPackageMetaData* self,
                                                             ValaSourceFile* file)
{
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->files;
	vala_collection_add ((ValaCollection*) _tmp0_, file);
}

static gboolean
valadoc_tree_builder_package_meta_data_is_package_for_file (ValadocTreeBuilderPackageMetaData* self,
                                                            ValaSourceFile* source_file)
{
	gboolean _tmp0_ = FALSE;
	ValaSourceFileType _tmp1_;
	ValaSourceFileType _tmp2_;
	ValaArrayList* _tmp6_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source_file != NULL, FALSE);
	_tmp1_ = vala_source_file_get_file_type (source_file);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		ValadocApiPackage* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->package;
		_tmp4_ = valadoc_api_package_get_is_package (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp6_ = self->files;
	result = vala_collection_contains ((ValaCollection*) _tmp6_, source_file);
	return result;
}

static void
valadoc_tree_builder_value_package_meta_data_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
valadoc_tree_builder_value_package_meta_data_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		valadoc_tree_builder_package_meta_data_unref (value->data[0].v_pointer);
	}
}

static void
valadoc_tree_builder_value_package_meta_data_copy_value (const GValue* src_value,
                                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = valadoc_tree_builder_package_meta_data_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
valadoc_tree_builder_value_package_meta_data_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
valadoc_tree_builder_value_package_meta_data_collect_value (GValue* value,
                                                            guint n_collect_values,
                                                            GTypeCValue* collect_values,
                                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValadocTreeBuilderPackageMetaData * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = valadoc_tree_builder_package_meta_data_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
valadoc_tree_builder_value_package_meta_data_lcopy_value (const GValue* value,
                                                          guint n_collect_values,
                                                          GTypeCValue* collect_values,
                                                          guint collect_flags)
{
	ValadocTreeBuilderPackageMetaData ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = valadoc_tree_builder_package_meta_data_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
valadoc_tree_builder_param_spec_package_meta_data (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags)
{
	ValadocTreeBuilderParamSpecPackageMetaData* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALADOC_TREE_BUILDER_TYPE_PACKAGE_META_DATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
valadoc_tree_builder_value_get_package_meta_data (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_TREE_BUILDER_TYPE_PACKAGE_META_DATA), NULL);
	return value->data[0].v_pointer;
}

static void
valadoc_tree_builder_value_set_package_meta_data (GValue* value,
                                                  gpointer v_object)
{
	ValadocTreeBuilderPackageMetaData * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_TREE_BUILDER_TYPE_PACKAGE_META_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_TREE_BUILDER_TYPE_PACKAGE_META_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		valadoc_tree_builder_package_meta_data_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_tree_builder_package_meta_data_unref (old);
	}
}

static void
valadoc_tree_builder_value_take_package_meta_data (GValue* value,
                                                   gpointer v_object)
{
	ValadocTreeBuilderPackageMetaData * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_TREE_BUILDER_TYPE_PACKAGE_META_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_TREE_BUILDER_TYPE_PACKAGE_META_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_tree_builder_package_meta_data_unref (old);
	}
}

static void
valadoc_tree_builder_package_meta_data_class_init (ValadocTreeBuilderPackageMetaDataClass * klass,
                                                   gpointer klass_data)
{
	valadoc_tree_builder_package_meta_data_parent_class = g_type_class_peek_parent (klass);
	((ValadocTreeBuilderPackageMetaDataClass *) klass)->finalize = valadoc_tree_builder_package_meta_data_finalize;
}

static void
valadoc_tree_builder_package_meta_data_instance_init (ValadocTreeBuilderPackageMetaData * self,
                                                      gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALADOC_API_TYPE_NAMESPACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_, _tmp1_, _tmp2_);
	self->namespaces = _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_SOURCE_FILE, (GBoxedCopyFunc) vala_source_file_ref, (GDestroyNotify) vala_source_file_unref, _tmp4_);
	self->files = _tmp5_;
	self->ref_count = 1;
}

static void
valadoc_tree_builder_package_meta_data_finalize (ValadocTreeBuilderPackageMetaData * obj)
{
	ValadocTreeBuilderPackageMetaData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TREE_BUILDER_TYPE_PACKAGE_META_DATA, ValadocTreeBuilderPackageMetaData);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->package);
	_vala_map_unref0 (self->namespaces);
	_vala_iterable_unref0 (self->files);
}

static GType
valadoc_tree_builder_package_meta_data_get_type (void)
{
	static volatile gsize valadoc_tree_builder_package_meta_data_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_tree_builder_package_meta_data_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { valadoc_tree_builder_value_package_meta_data_init, valadoc_tree_builder_value_package_meta_data_free_value, valadoc_tree_builder_value_package_meta_data_copy_value, valadoc_tree_builder_value_package_meta_data_peek_pointer, "p", valadoc_tree_builder_value_package_meta_data_collect_value, "p", valadoc_tree_builder_value_package_meta_data_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValadocTreeBuilderPackageMetaDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_tree_builder_package_meta_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocTreeBuilderPackageMetaData), 0, (GInstanceInitFunc) valadoc_tree_builder_package_meta_data_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType valadoc_tree_builder_package_meta_data_type_id;
		valadoc_tree_builder_package_meta_data_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValadocTreeBuilderPackageMetaData", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&valadoc_tree_builder_package_meta_data_type_id__volatile, valadoc_tree_builder_package_meta_data_type_id);
	}
	return valadoc_tree_builder_package_meta_data_type_id__volatile;
}

static gpointer
valadoc_tree_builder_package_meta_data_ref (gpointer instance)
{
	ValadocTreeBuilderPackageMetaData * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
valadoc_tree_builder_package_meta_data_unref (gpointer instance)
{
	ValadocTreeBuilderPackageMetaData * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALADOC_TREE_BUILDER_PACKAGE_META_DATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
valadoc_tree_builder_class_init (ValadocTreeBuilderClass * klass,
                                 gpointer klass_data)
{
	valadoc_tree_builder_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = valadoc_tree_builder_finalize;
	g_type_class_adjust_private_offset (klass, &ValadocTreeBuilder_private_offset);
	((ValaCodeVisitorClass *) klass)->visit_namespace = (void (*) (ValaCodeVisitor*, ValaNamespace*)) valadoc_tree_builder_real_visit_namespace;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) valadoc_tree_builder_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor*, ValaInterface*)) valadoc_tree_builder_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor*, ValaStruct*)) valadoc_tree_builder_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor*, ValaField*)) valadoc_tree_builder_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor*, ValaProperty*)) valadoc_tree_builder_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_creation_method = (void (*) (ValaCodeVisitor*, ValaCreationMethod*)) valadoc_tree_builder_real_visit_creation_method;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor*, ValaMethod*)) valadoc_tree_builder_real_visit_method;
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor*, ValaSignal*)) valadoc_tree_builder_real_visit_signal;
	((ValaCodeVisitorClass *) klass)->visit_delegate = (void (*) (ValaCodeVisitor*, ValaDelegate*)) valadoc_tree_builder_real_visit_delegate;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor*, ValaEnum*)) valadoc_tree_builder_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_enum_value = (void (*) (ValaCodeVisitor*, ValaEnumValue*)) valadoc_tree_builder_real_visit_enum_value;
	((ValaCodeVisitorClass *) klass)->visit_constant = (void (*) (ValaCodeVisitor*, ValaConstant*)) valadoc_tree_builder_real_visit_constant;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) valadoc_tree_builder_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_error_code = (void (*) (ValaCodeVisitor*, ValaErrorCode*)) valadoc_tree_builder_real_visit_error_code;
	((ValaCodeVisitorClass *) klass)->visit_type_parameter = (void (*) (ValaCodeVisitor*, ValaTypeParameter*)) valadoc_tree_builder_real_visit_type_parameter;
	((ValaCodeVisitorClass *) klass)->visit_formal_parameter = (void (*) (ValaCodeVisitor*, ValaParameter*)) valadoc_tree_builder_real_visit_formal_parameter;
}

static void
valadoc_tree_builder_instance_init (ValadocTreeBuilder * self,
                                    gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GEqualFunc _tmp4_;
	ValaHashMap* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GEqualFunc _tmp8_;
	ValaHashMap* _tmp9_;
	self->priv = valadoc_tree_builder_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_TREE_BUILDER_TYPE_PACKAGE_META_DATA, (GBoxedCopyFunc) valadoc_tree_builder_package_meta_data_ref, (GDestroyNotify) valadoc_tree_builder_package_meta_data_unref, _tmp0_);
	self->priv->packages = _tmp1_;
	_tmp2_ = g_direct_hash;
	_tmp3_ = g_direct_equal;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_hash_map_new (VALA_TYPE_SOURCE_FILE, (GBoxedCopyFunc) vala_source_file_ref, (GDestroyNotify) vala_source_file_unref, VALADOC_API_TYPE_SOURCE_FILE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp2_, _tmp3_, _tmp4_);
	self->priv->files = _tmp5_;
	_tmp6_ = g_direct_hash;
	_tmp7_ = g_direct_equal;
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_hash_map_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALADOC_API_TYPE_SYMBOL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp6_, _tmp7_, _tmp8_);
	self->priv->symbol_map = _tmp9_;
	self->priv->glib_error = NULL;
}

static void
valadoc_tree_builder_finalize (ValaCodeVisitor * obj)
{
	ValadocTreeBuilder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_TREE_BUILDER, ValadocTreeBuilder);
	_vala_iterable_unref0 (self->priv->packages);
	_valadoc_tree_builder_package_meta_data_unref0 (self->priv->source_package);
	_vala_map_unref0 (self->priv->files);
	_vala_map_unref0 (self->priv->symbol_map);
	_g_object_unref0 (self->priv->reporter);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->current_node);
	_valadoc_api_tree_unref0 (self->priv->tree);
	_g_object_unref0 (self->priv->glib_error);
	VALA_CODE_VISITOR_CLASS (valadoc_tree_builder_parent_class)->finalize (obj);
}

/**
 * Creates an simpler, minimized, more abstract AST for valacs AST.
 */
GType
valadoc_tree_builder_get_type (void)
{
	static volatile gsize valadoc_tree_builder_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_tree_builder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocTreeBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_tree_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocTreeBuilder), 0, (GInstanceInitFunc) valadoc_tree_builder_instance_init, NULL };
		GType valadoc_tree_builder_type_id;
		valadoc_tree_builder_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValadocTreeBuilder", &g_define_type_info, 0);
		ValadocTreeBuilder_private_offset = g_type_add_instance_private (valadoc_tree_builder_type_id, sizeof (ValadocTreeBuilderPrivate));
		g_once_init_leave (&valadoc_tree_builder_type_id__volatile, valadoc_tree_builder_type_id);
	}
	return valadoc_tree_builder_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

