/* ctyperesolver.c generated by valac, the Vala compiler
 * generated from ctyperesolver.vala, do not modify */

/* ctyperesolver.vala
 *
 * Copyright (C) 2010 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include "valadoc.h"
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

enum  {
	VALADOC_CTYPE_RESOLVER_0_PROPERTY,
	VALADOC_CTYPE_RESOLVER_NUM_PROPERTIES
};
static GParamSpec* valadoc_ctype_resolver_properties[VALADOC_CTYPE_RESOLVER_NUM_PROPERTIES];
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _valadoc_api_tree_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_tree_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocCTypeResolverPrivate {
	ValaMap* types;
	ValaMap* nodes;
	ValadocApiTree* tree;
};

static gint ValadocCTypeResolver_private_offset;
static gpointer valadoc_ctype_resolver_parent_class = NULL;

static gchar* valadoc_ctype_resolver_convert_array_to_camelcase (ValadocCTypeResolver* self,
                                                          gchar** elements,
                                                          gint elements_length1);
static gboolean valadoc_ctype_resolver_is_capitalized_and_underscored (ValadocCTypeResolver* self,
                                                                const gchar* name);
static gchar* valadoc_ctype_resolver_translate_cname_to_g (ValadocCTypeResolver* self,
                                                    const gchar* name);
static gchar** _vala_array_dup1 (gchar** self,
                          int length);
static void valadoc_ctype_resolver_register_symbol_type (ValadocCTypeResolver* self,
                                                  const gchar* name,
                                                  ValadocApiTypeSymbol* symbol);
static void valadoc_ctype_resolver_register_symbol (ValadocCTypeResolver* self,
                                             const gchar* name,
                                             ValadocApiNode* node);
static gchar* valadoc_ctype_resolver_get_parent_type_cname (ValadocCTypeResolver* self,
                                                     ValadocApiItem* item);
static void valadoc_ctype_resolver_real_visit_tree (ValadocApiVisitor* base,
                                             ValadocApiTree* item);
static void valadoc_ctype_resolver_real_visit_package (ValadocApiVisitor* base,
                                                ValadocApiPackage* item);
static void valadoc_ctype_resolver_real_visit_namespace (ValadocApiVisitor* base,
                                                  ValadocApiNamespace* item);
static void valadoc_ctype_resolver_real_visit_interface (ValadocApiVisitor* base,
                                                  ValadocApiInterface* item);
static void valadoc_ctype_resolver_real_visit_class (ValadocApiVisitor* base,
                                              ValadocApiClass* item);
static void valadoc_ctype_resolver_real_visit_struct (ValadocApiVisitor* base,
                                               ValadocApiStruct* item);
static void valadoc_ctype_resolver_real_visit_property (ValadocApiVisitor* base,
                                                 ValadocApiProperty* item);
static void valadoc_ctype_resolver_real_visit_field (ValadocApiVisitor* base,
                                              ValadocApiField* item);
static void valadoc_ctype_resolver_real_visit_constant (ValadocApiVisitor* base,
                                                 ValadocApiConstant* item);
static void valadoc_ctype_resolver_real_visit_delegate (ValadocApiVisitor* base,
                                                 ValadocApiDelegate* item);
static void valadoc_ctype_resolver_real_visit_signal (ValadocApiVisitor* base,
                                               ValadocApiSignal* item);
static void valadoc_ctype_resolver_real_visit_method (ValadocApiVisitor* base,
                                               ValadocApiMethod* item);
static void valadoc_ctype_resolver_real_visit_error_domain (ValadocApiVisitor* base,
                                                     ValadocApiErrorDomain* item);
static void valadoc_ctype_resolver_real_visit_error_code (ValadocApiVisitor* base,
                                                   ValadocApiErrorCode* item);
static void valadoc_ctype_resolver_real_visit_enum (ValadocApiVisitor* base,
                                             ValadocApiEnum* item);
static void valadoc_ctype_resolver_real_visit_enum_value (ValadocApiVisitor* base,
                                                   ValadocApiEnumValue* item);
static void valadoc_ctype_resolver_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
valadoc_ctype_resolver_get_instance_private (ValadocCTypeResolver* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocCTypeResolver_private_offset);
}

static gpointer
_valadoc_api_tree_ref0 (gpointer self)
{
	return self ? valadoc_api_tree_ref (self) : NULL;
}

ValadocCTypeResolver*
valadoc_ctype_resolver_construct (GType object_type,
                                  ValadocApiTree* tree)
{
	ValadocCTypeResolver * self = NULL;
	ValadocApiTree* _tmp0_;
	g_return_val_if_fail (tree != NULL, NULL);
	self = (ValadocCTypeResolver*) valadoc_api_visitor_construct (object_type);
	valadoc_api_tree_accept (tree, (ValadocApiVisitor*) self);
	_tmp0_ = _valadoc_api_tree_ref0 (tree);
	_valadoc_api_tree_unref0 (self->priv->tree);
	self->priv->tree = _tmp0_;
	return self;
}

ValadocCTypeResolver*
valadoc_ctype_resolver_new (ValadocApiTree* tree)
{
	return valadoc_ctype_resolver_construct (VALADOC_TYPE_CTYPE_RESOLVER, tree);
}

static gchar*
valadoc_ctype_resolver_convert_array_to_camelcase (ValadocCTypeResolver* self,
                                                   gchar** elements,
                                                   gint elements_length1)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp10_;
	gchar* _tmp11_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		gchar** element_collection = NULL;
		gint element_collection_length1 = 0;
		gint _element_collection_size_ = 0;
		gint element_it = 0;
		element_collection = elements;
		element_collection_length1 = elements_length1;
		for (element_it = 0; element_it < element_collection_length1; element_it = element_it + 1) {
			gchar* _tmp1_;
			gchar* element = NULL;
			_tmp1_ = g_strdup (element_collection[element_it]);
			element = _tmp1_;
			{
				GString* _tmp2_;
				const gchar* _tmp3_;
				gchar _tmp4_;
				GString* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp2_ = builder;
				_tmp3_ = element;
				_tmp4_ = ((gchar*) _tmp3_)[0];
				g_string_append_c (_tmp2_, g_ascii_toupper (_tmp4_));
				_tmp5_ = builder;
				_tmp6_ = element;
				_tmp7_ = g_utf8_next_char (_tmp6_);
				_tmp8_ = g_utf8_strdown (_tmp7_, (gssize) -1);
				_tmp9_ = _tmp8_;
				g_string_append (_tmp5_, _tmp9_);
				_g_free0 (_tmp9_);
				_g_free0 (element);
			}
		}
	}
	_tmp10_ = builder;
	_tmp11_ = _tmp10_->str;
	_tmp10_->str = NULL;
	result = _tmp11_;
	_g_string_free0 (builder);
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gboolean
valadoc_ctype_resolver_is_capitalized_and_underscored (ValadocCTypeResolver* self,
                                                       const gchar* name)
{
	const gchar* pos = NULL;
	gunichar c = 0U;
	gboolean _tmp0_ = FALSE;
	gboolean last_was_underscore = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	c = string_get_char (name, (glong) 0);
	if (c < ((gunichar) 'A')) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c > ((gunichar) 'Z');
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	last_was_underscore = FALSE;
	{
		const gchar* _tmp1_;
		gboolean _tmp2_ = FALSE;
		pos = name;
		_tmp1_ = pos;
		c = string_get_char (_tmp1_, (glong) 0);
		_tmp2_ = TRUE;
		while (TRUE) {
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			if (!_tmp2_) {
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp3_ = pos;
				_tmp4_ = g_utf8_next_char (_tmp3_);
				pos = _tmp4_;
				_tmp5_ = pos;
				c = string_get_char (_tmp5_, (glong) 0);
			}
			_tmp2_ = FALSE;
			if (!(c != ((gunichar) '\0'))) {
				break;
			}
			if (c != ((gunichar) '_')) {
				gboolean _tmp8_ = FALSE;
				if (c >= ((gunichar) 'A')) {
					_tmp8_ = c <= ((gunichar) 'Z');
				} else {
					_tmp8_ = FALSE;
				}
				_tmp7_ = !_tmp8_;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				_tmp6_ = TRUE;
			} else {
				gboolean _tmp9_ = FALSE;
				if (last_was_underscore) {
					_tmp9_ = c == ((gunichar) '_');
				} else {
					_tmp9_ = FALSE;
				}
				_tmp6_ = _tmp9_;
			}
			if (_tmp6_) {
				result = FALSE;
				return result;
			}
			last_was_underscore = c == ((gunichar) '_');
		}
	}
	result = !last_was_underscore;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
valadoc_ctype_resolver_translate_cname_to_g (ValadocCTypeResolver* self,
                                             const gchar* name)
{
	gint length = 0;
	gint _tmp8_;
	gint _tmp9_;
	gboolean _tmp10_ = FALSE;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (valadoc_ctype_resolver_is_capitalized_and_underscored (self, name)) {
		gchar** segments = NULL;
		gchar** _tmp0_;
		gchar** _tmp1_;
		gint segments_length1;
		gint _segments_size_;
		const gchar* last_segment = NULL;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar** _tmp3_;
		gint _tmp3__length1;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_;
		_tmp1_ = _tmp0_ = g_strsplit (name, "_", 0);
		segments = _tmp1_;
		segments_length1 = _vala_array_length (_tmp0_);
		_segments_size_ = segments_length1;
		_tmp2_ = segments;
		_tmp2__length1 = segments_length1;
		_tmp3_ = segments;
		_tmp3__length1 = segments_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		last_segment = _tmp4_;
		_tmp5_ = last_segment;
		if (g_strcmp0 (_tmp5_, "ERROR") != 0) {
			result = NULL;
			segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_tmp6_ = segments;
		_tmp6__length1 = segments_length1;
		_tmp7_ = valadoc_ctype_resolver_convert_array_to_camelcase (self, _tmp6_, (gint) _tmp6__length1);
		result = _tmp7_;
		segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp8_ = strlen (name);
	_tmp9_ = _tmp8_;
	length = _tmp9_;
	if (length > 5) {
		_tmp10_ = g_str_has_suffix (name, "Iface");
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		gchar* _tmp11_;
		_tmp11_ = string_substring (name, (glong) 0, (glong) (length - 5));
		result = _tmp11_;
		return result;
	} else {
		gboolean _tmp12_ = FALSE;
		if (length > 5) {
			_tmp12_ = g_str_has_suffix (name, "Class");
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			gchar* _tmp13_;
			_tmp13_ = string_substring (name, (glong) 0, (glong) (length - 5));
			result = _tmp13_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

ValadocApiTypeSymbol*
valadoc_ctype_resolver_resolve_symbol_type (ValadocCTypeResolver* self,
                                            const gchar* name)
{
	ValadocApiTypeSymbol* symbol = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValadocApiTypeSymbol* _tmp2_;
	ValadocApiTypeSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->types;
	_tmp1_ = vala_map_get (_tmp0_, name);
	symbol = (ValadocApiTypeSymbol*) _tmp1_;
	_tmp2_ = symbol;
	if (_tmp2_ != NULL) {
		result = symbol;
		return result;
	}
	if (valadoc_ctype_resolver_is_capitalized_and_underscored (self, name)) {
		gchar** segments = NULL;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint segments_length1;
		gint _segments_size_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		_tmp4_ = _tmp3_ = g_strsplit (name, "_", 0);
		segments = _tmp4_;
		segments_length1 = _vala_array_length (_tmp3_);
		_segments_size_ = segments_length1;
		_tmp5_ = segments;
		_tmp5__length1 = segments_length1;
		_tmp6_ = segments;
		_tmp6__length1 = segments_length1;
		_tmp7_ = _tmp5_[_tmp6__length1 - 1];
		if (g_strcmp0 (_tmp7_, "TYPE") == 0) {
			gchar** _tmp8_;
			gint _tmp8__length1;
			gint _tmp9_;
			ValaMap* _tmp10_;
			gchar** _tmp11_;
			gint _tmp11__length1;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gpointer _tmp14_;
			ValadocApiTypeSymbol* _tmp15_;
			_tmp8_ = segments;
			_tmp8__length1 = segments_length1;
			_tmp9_ = _tmp8__length1 - 1;
			segments = g_renew (gchar*, segments, _tmp8__length1 - 1);
			(_tmp9_ > segments_length1) ? memset (segments + segments_length1, 0, sizeof (gchar*) * (_tmp9_ - segments_length1)) : NULL;
			segments_length1 = _tmp9_;
			_segments_size_ = _tmp9_;
			_tmp10_ = self->priv->types;
			_tmp11_ = segments;
			_tmp11__length1 = segments_length1;
			_tmp12_ = valadoc_ctype_resolver_convert_array_to_camelcase (self, _tmp11_, (gint) _tmp11__length1);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_map_get (_tmp10_, _tmp13_);
			_tmp15_ = (ValadocApiTypeSymbol*) _tmp14_;
			_g_free0 (_tmp13_);
			result = _tmp15_;
			segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (symbol);
			return result;
		} else {
			gboolean _tmp16_ = FALSE;
			gchar** _tmp17_;
			gint _tmp17__length1;
			_tmp17_ = segments;
			_tmp17__length1 = segments_length1;
			if (_tmp17__length1 > 2) {
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp19_;
				_tmp18_ = segments;
				_tmp18__length1 = segments_length1;
				_tmp19_ = _tmp18_[1];
				_tmp16_ = g_strcmp0 (_tmp19_, "TYPE") == 0;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				gchar** _segments = NULL;
				gchar** _tmp20_;
				gint _tmp20__length1;
				gchar** _tmp21_;
				gint _tmp21__length1;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _segments_length1;
				gint __segments_size_;
				gchar** _tmp23_;
				gint _tmp23__length1;
				gchar** _tmp24_;
				gint _tmp24__length1;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				ValaMap* _tmp27_;
				gchar** _tmp28_;
				gint _tmp28__length1;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gpointer _tmp31_;
				ValadocApiTypeSymbol* _tmp32_;
				_tmp20_ = segments;
				_tmp20__length1 = segments_length1;
				_tmp21_ = segments;
				_tmp21__length1 = segments_length1;
				_tmp22_ = ((_tmp20_ + 1) != NULL) ? _vala_array_dup1 (_tmp20_ + 1, _tmp21__length1 - 1) : ((gpointer) (_tmp20_ + 1));
				_tmp22__length1 = _tmp21__length1 - 1;
				_segments = _tmp22_;
				_segments_length1 = _tmp22__length1;
				__segments_size_ = _segments_length1;
				_tmp23_ = _segments;
				_tmp23__length1 = _segments_length1;
				_tmp24_ = segments;
				_tmp24__length1 = segments_length1;
				_tmp25_ = _tmp24_[0];
				_tmp26_ = g_strdup (_tmp25_);
				_g_free0 (_tmp23_[0]);
				_tmp23_[0] = _tmp26_;
				_tmp27_ = self->priv->types;
				_tmp28_ = _segments;
				_tmp28__length1 = _segments_length1;
				_tmp29_ = valadoc_ctype_resolver_convert_array_to_camelcase (self, _tmp28_, (gint) _tmp28__length1);
				_tmp30_ = _tmp29_;
				_tmp31_ = vala_map_get (_tmp27_, _tmp30_);
				_tmp32_ = (ValadocApiTypeSymbol*) _tmp31_;
				_g_free0 (_tmp30_);
				result = _tmp32_;
				_segments = (_vala_array_free (_segments, _segments_length1, (GDestroyNotify) g_free), NULL);
				segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (symbol);
				return result;
			}
		}
		segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
	}
	result = NULL;
	_g_object_unref0 (symbol);
	return result;
}

/**
 * Resolves symbols by C-names
 *
 * @param _name a C-name
 * @return the resolved node or null
 */
static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

ValadocApiNode*
valadoc_ctype_resolver_resolve_symbol (ValadocCTypeResolver* self,
                                       ValadocApiNode* element,
                                       const gchar* _name)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValadocApiNode* node = NULL;
	ValaMap* _tmp36_;
	const gchar* _tmp37_;
	gpointer _tmp38_;
	ValadocApiNode* _tmp39_;
	gchar* alternative = NULL;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	gboolean _tmp46_ = FALSE;
	const gchar* _tmp74_;
	gint dotpos = 0;
	const gchar* _tmp80_;
	ValadocApiNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (_name != NULL, NULL);
	_tmp0_ = string_replace (_name, "->", ".");
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "-", "_");
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	name = _tmp3_;
	if (element != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = name;
		_tmp4_ = g_str_has_prefix (_tmp5_, ":");
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValadocApiItem* parent = NULL;
		ValadocApiItem* _tmp6_;
		gboolean _tmp16_ = FALSE;
		ValadocApiItem* _tmp17_;
		_tmp6_ = _g_object_ref0 ((ValadocApiItem*) element);
		parent = _tmp6_;
		while (TRUE) {
			gboolean _tmp7_ = FALSE;
			ValadocApiItem* _tmp8_;
			ValadocApiItem* _tmp12_;
			ValadocApiItem* _tmp13_;
			ValadocApiItem* _tmp14_;
			ValadocApiItem* _tmp15_;
			_tmp8_ = parent;
			if (_tmp8_ != NULL) {
				gboolean _tmp9_ = FALSE;
				ValadocApiItem* _tmp10_;
				_tmp10_ = parent;
				if (VALADOC_API_IS_CLASS (_tmp10_)) {
					_tmp9_ = TRUE;
				} else {
					ValadocApiItem* _tmp11_;
					_tmp11_ = parent;
					_tmp9_ = VALADOC_API_IS_INTERFACE (_tmp11_);
				}
				_tmp7_ = !_tmp9_;
			} else {
				_tmp7_ = FALSE;
			}
			if (!_tmp7_) {
				break;
			}
			_tmp12_ = parent;
			_tmp13_ = valadoc_api_item_get_parent (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = _g_object_ref0 (_tmp14_);
			_g_object_unref0 (parent);
			parent = _tmp15_;
		}
		_tmp17_ = parent;
		if (VALADOC_API_IS_CLASS (_tmp17_)) {
			ValadocApiItem* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp18_ = parent;
			_tmp19_ = valadoc_api_class_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_tmp20_ = _tmp19_;
			_tmp16_ = _tmp20_ != NULL;
			_g_free0 (_tmp20_);
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			ValadocApiItem* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp21_ = parent;
			_tmp22_ = valadoc_api_class_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_tmp23_ = _tmp22_;
			_tmp24_ = name;
			_tmp25_ = g_strconcat (_tmp23_, _tmp24_, NULL);
			_g_free0 (name);
			name = _tmp25_;
			_g_free0 (_tmp23_);
		} else {
			gboolean _tmp26_ = FALSE;
			ValadocApiItem* _tmp27_;
			_tmp27_ = parent;
			if (VALADOC_API_IS_INTERFACE (_tmp27_)) {
				ValadocApiItem* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp28_ = parent;
				_tmp29_ = valadoc_api_interface_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
				_tmp30_ = _tmp29_;
				_tmp26_ = _tmp30_ != NULL;
				_g_free0 (_tmp30_);
			} else {
				_tmp26_ = FALSE;
			}
			if (_tmp26_) {
				ValadocApiItem* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				const gchar* _tmp34_;
				gchar* _tmp35_;
				_tmp31_ = parent;
				_tmp32_ = valadoc_api_interface_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
				_tmp33_ = _tmp32_;
				_tmp34_ = name;
				_tmp35_ = g_strconcat (_tmp33_, _tmp34_, NULL);
				_g_free0 (name);
				name = _tmp35_;
				_g_free0 (_tmp33_);
			} else {
				result = NULL;
				_g_object_unref0 (parent);
				_g_free0 (name);
				return result;
			}
		}
		_g_object_unref0 (parent);
	}
	_tmp36_ = self->priv->nodes;
	_tmp37_ = name;
	_tmp38_ = vala_map_get (_tmp36_, _tmp37_);
	node = (ValadocApiNode*) _tmp38_;
	_tmp39_ = node;
	if (_tmp39_ != NULL) {
		result = node;
		_g_free0 (name);
		return result;
	}
	_tmp40_ = name;
	_tmp41_ = valadoc_ctype_resolver_translate_cname_to_g (self, _tmp40_);
	alternative = _tmp41_;
	_tmp42_ = alternative;
	if (_tmp42_ != NULL) {
		ValaMap* _tmp43_;
		const gchar* _tmp44_;
		gpointer _tmp45_;
		_tmp43_ = self->priv->nodes;
		_tmp44_ = alternative;
		_tmp45_ = vala_map_get (_tmp43_, _tmp44_);
		result = (ValadocApiNode*) _tmp45_;
		_g_free0 (alternative);
		_g_object_unref0 (node);
		_g_free0 (name);
		return result;
	}
	if (element != NULL) {
		const gchar* _tmp47_;
		_tmp47_ = name;
		_tmp46_ = g_str_has_prefix (_tmp47_, ":");
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		gboolean _tmp48_ = FALSE;
		if (VALADOC_API_IS_CLASS (element)) {
			gchar* _tmp49_;
			gchar* _tmp50_;
			_tmp49_ = valadoc_api_class_get_cname (G_TYPE_CHECK_INSTANCE_CAST (element, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_tmp50_ = _tmp49_;
			_tmp48_ = _tmp50_ != NULL;
			_g_free0 (_tmp50_);
		} else {
			_tmp48_ = FALSE;
		}
		if (_tmp48_) {
			ValaMap* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			const gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gpointer _tmp59_;
			ValadocApiNode* _tmp60_;
			_tmp51_ = self->priv->nodes;
			_tmp52_ = valadoc_api_class_get_cname (G_TYPE_CHECK_INSTANCE_CAST (element, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_tmp53_ = _tmp52_;
			_tmp54_ = g_strconcat (_tmp53_, ".", NULL);
			_tmp55_ = _tmp54_;
			_tmp56_ = name;
			_tmp57_ = g_strconcat (_tmp55_, _tmp56_, NULL);
			_tmp58_ = _tmp57_;
			_tmp59_ = vala_map_get (_tmp51_, _tmp58_);
			_tmp60_ = (ValadocApiNode*) _tmp59_;
			_g_free0 (_tmp58_);
			_g_free0 (_tmp55_);
			_g_free0 (_tmp53_);
			result = _tmp60_;
			_g_free0 (alternative);
			_g_object_unref0 (node);
			_g_free0 (name);
			return result;
		} else {
			gboolean _tmp61_ = FALSE;
			if (VALADOC_API_IS_STRUCT (element)) {
				gchar* _tmp62_;
				gchar* _tmp63_;
				_tmp62_ = valadoc_api_struct_get_cname (G_TYPE_CHECK_INSTANCE_CAST (element, VALADOC_API_TYPE_STRUCT, ValadocApiStruct));
				_tmp63_ = _tmp62_;
				_tmp61_ = _tmp63_ != NULL;
				_g_free0 (_tmp63_);
			} else {
				_tmp61_ = FALSE;
			}
			if (_tmp61_) {
				ValaMap* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				const gchar* _tmp69_;
				gchar* _tmp70_;
				gchar* _tmp71_;
				gpointer _tmp72_;
				ValadocApiNode* _tmp73_;
				_tmp64_ = self->priv->nodes;
				_tmp65_ = valadoc_api_struct_get_cname (G_TYPE_CHECK_INSTANCE_CAST (element, VALADOC_API_TYPE_STRUCT, ValadocApiStruct));
				_tmp66_ = _tmp65_;
				_tmp67_ = g_strconcat (_tmp66_, ".", NULL);
				_tmp68_ = _tmp67_;
				_tmp69_ = name;
				_tmp70_ = g_strconcat (_tmp68_, _tmp69_, NULL);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_map_get (_tmp64_, _tmp71_);
				_tmp73_ = (ValadocApiNode*) _tmp72_;
				_g_free0 (_tmp71_);
				_g_free0 (_tmp68_);
				_g_free0 (_tmp66_);
				result = _tmp73_;
				_g_free0 (alternative);
				_g_object_unref0 (node);
				_g_free0 (name);
				return result;
			}
		}
	}
	_tmp74_ = name;
	if (g_strcmp0 (_tmp74_, "dgettext") == 0) {
		ValaMap* _tmp75_;
		gpointer _tmp76_;
		_tmp75_ = self->priv->nodes;
		_tmp76_ = vala_map_get (_tmp75_, "g_dgettext");
		result = (ValadocApiNode*) _tmp76_;
		_g_free0 (alternative);
		_g_object_unref0 (node);
		_g_free0 (name);
		return result;
	} else {
		const gchar* _tmp77_;
		_tmp77_ = name;
		if (g_strcmp0 (_tmp77_, "printf") == 0) {
			ValadocApiTree* _tmp78_;
			ValadocApiNode* _tmp79_;
			_tmp78_ = self->priv->tree;
			_tmp79_ = valadoc_api_tree_search_symbol_str (_tmp78_, NULL, "GLib.FileStream.printf");
			result = _tmp79_;
			_g_free0 (alternative);
			_g_object_unref0 (node);
			_g_free0 (name);
			return result;
		}
	}
	_tmp80_ = name;
	dotpos = string_index_of_char (_tmp80_, (gunichar) '.', 0);
	if (dotpos > 0) {
		gchar* fst = NULL;
		const gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* snd = NULL;
		const gchar* _tmp83_;
		gchar* _tmp84_;
		ValaMap* _tmp85_;
		const gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		const gchar* _tmp89_;
		gchar* _tmp90_;
		gchar* _tmp91_;
		gpointer _tmp92_;
		ValadocApiNode* _tmp93_;
		_tmp81_ = name;
		_tmp82_ = string_substring (_tmp81_, (glong) 0, (glong) dotpos);
		fst = _tmp82_;
		_tmp83_ = name;
		_tmp84_ = string_substring (_tmp83_, (glong) (dotpos + 1), (glong) -1);
		snd = _tmp84_;
		_tmp85_ = self->priv->nodes;
		_tmp86_ = fst;
		_tmp87_ = g_strconcat (_tmp86_, ":", NULL);
		_tmp88_ = _tmp87_;
		_tmp89_ = snd;
		_tmp90_ = g_strconcat (_tmp88_, _tmp89_, NULL);
		_tmp91_ = _tmp90_;
		_tmp92_ = vala_map_get (_tmp85_, _tmp91_);
		_tmp93_ = (ValadocApiNode*) _tmp92_;
		_g_free0 (_tmp91_);
		_g_free0 (_tmp88_);
		result = _tmp93_;
		_g_free0 (snd);
		_g_free0 (fst);
		_g_free0 (alternative);
		_g_object_unref0 (node);
		_g_free0 (name);
		return result;
	}
	result = NULL;
	_g_free0 (alternative);
	_g_object_unref0 (node);
	_g_free0 (name);
	return result;
}

static void
valadoc_ctype_resolver_register_symbol_type (ValadocCTypeResolver* self,
                                             const gchar* name,
                                             ValadocApiTypeSymbol* symbol)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	if (name != NULL) {
		ValaMap* _tmp0_;
		_tmp0_ = self->priv->types;
		vala_map_set (_tmp0_, name, symbol);
	}
}

static void
valadoc_ctype_resolver_register_symbol (ValadocCTypeResolver* self,
                                        const gchar* name,
                                        ValadocApiNode* node)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	if (name != NULL) {
		ValaMap* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->nodes;
		_tmp1_ = string_replace (name, "-", "_");
		_tmp2_ = _tmp1_;
		vala_map_set (_tmp0_, _tmp2_, node);
		_g_free0 (_tmp2_);
	}
}

static gchar*
valadoc_ctype_resolver_get_parent_type_cname (ValadocCTypeResolver* self,
                                              ValadocApiItem* item)
{
	gchar* parent_cname = NULL;
	ValadocApiItem* _tmp0_;
	ValadocApiItem* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	parent_cname = NULL;
	_tmp0_ = valadoc_api_item_get_parent (item);
	_tmp1_ = _tmp0_;
	if (VALADOC_API_IS_CLASS (_tmp1_)) {
		ValadocApiItem* _tmp2_;
		ValadocApiItem* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = valadoc_api_item_get_parent (item);
		_tmp3_ = _tmp2_;
		_tmp4_ = valadoc_api_class_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
		_g_free0 (parent_cname);
		parent_cname = _tmp4_;
	} else {
		ValadocApiItem* _tmp5_;
		ValadocApiItem* _tmp6_;
		_tmp5_ = valadoc_api_item_get_parent (item);
		_tmp6_ = _tmp5_;
		if (VALADOC_API_IS_INTERFACE (_tmp6_)) {
			ValadocApiItem* _tmp7_;
			ValadocApiItem* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = valadoc_api_item_get_parent (item);
			_tmp8_ = _tmp7_;
			_tmp9_ = valadoc_api_interface_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
			_g_free0 (parent_cname);
			parent_cname = _tmp9_;
		} else {
			ValadocApiItem* _tmp10_;
			ValadocApiItem* _tmp11_;
			_tmp10_ = valadoc_api_item_get_parent (item);
			_tmp11_ = _tmp10_;
			if (VALADOC_API_IS_STRUCT (_tmp11_)) {
				ValadocApiItem* _tmp12_;
				ValadocApiItem* _tmp13_;
				gchar* _tmp14_;
				_tmp12_ = valadoc_api_item_get_parent (item);
				_tmp13_ = _tmp12_;
				_tmp14_ = valadoc_api_struct_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALADOC_API_TYPE_STRUCT, ValadocApiStruct));
				_g_free0 (parent_cname);
				parent_cname = _tmp14_;
			} else {
				ValadocApiItem* _tmp15_;
				ValadocApiItem* _tmp16_;
				_tmp15_ = valadoc_api_item_get_parent (item);
				_tmp16_ = _tmp15_;
				if (VALADOC_API_IS_ERROR_DOMAIN (_tmp16_)) {
					ValadocApiItem* _tmp17_;
					ValadocApiItem* _tmp18_;
					gchar* _tmp19_;
					_tmp17_ = valadoc_api_item_get_parent (item);
					_tmp18_ = _tmp17_;
					_tmp19_ = valadoc_api_error_domain_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALADOC_API_TYPE_ERROR_DOMAIN, ValadocApiErrorDomain));
					_g_free0 (parent_cname);
					parent_cname = _tmp19_;
				} else {
					ValadocApiItem* _tmp20_;
					ValadocApiItem* _tmp21_;
					_tmp20_ = valadoc_api_item_get_parent (item);
					_tmp21_ = _tmp20_;
					if (VALADOC_API_IS_ENUM (_tmp21_)) {
						ValadocApiItem* _tmp22_;
						ValadocApiItem* _tmp23_;
						gchar* _tmp24_;
						_tmp22_ = valadoc_api_item_get_parent (item);
						_tmp23_ = _tmp22_;
						_tmp24_ = valadoc_api_enum_get_cname (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALADOC_API_TYPE_ENUM, ValadocApiEnum));
						_g_free0 (parent_cname);
						parent_cname = _tmp24_;
					} else {
						_vala_assert (TRUE, "true");
					}
				}
			}
		}
	}
	result = parent_cname;
	return result;
}

/**
 * {@inheritDoc}
 */
static void
valadoc_ctype_resolver_real_visit_tree (ValadocApiVisitor* base,
                                        ValadocApiTree* item)
{
	ValadocCTypeResolver * self;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	valadoc_api_tree_accept_children (item, (ValadocApiVisitor*) self);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_ctype_resolver_real_visit_package (ValadocApiVisitor* base,
                                           ValadocApiPackage* item)
{
	ValadocCTypeResolver * self;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	valadoc_api_node_accept_all_children ((ValadocApiNode*) item, (ValadocApiVisitor*) self, FALSE);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_ctype_resolver_real_visit_namespace (ValadocApiVisitor* base,
                                             ValadocApiNamespace* item)
{
	ValadocCTypeResolver * self;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	valadoc_api_node_accept_all_children ((ValadocApiNode*) item, (ValadocApiVisitor*) self, FALSE);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_ctype_resolver_real_visit_interface (ValadocApiVisitor* base,
                                             ValadocApiInterface* item)
{
	ValadocCTypeResolver * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = valadoc_api_interface_get_type_id (item);
	_tmp1_ = _tmp0_;
	valadoc_ctype_resolver_register_symbol_type (self, _tmp1_, (ValadocApiTypeSymbol*) item);
	_g_free0 (_tmp1_);
	_tmp2_ = valadoc_api_interface_get_cname (item);
	_tmp3_ = _tmp2_;
	valadoc_ctype_resolver_register_symbol (self, _tmp3_, (ValadocApiNode*) item);
	_g_free0 (_tmp3_);
	valadoc_api_node_accept_all_children ((ValadocApiNode*) item, (ValadocApiVisitor*) self, FALSE);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_ctype_resolver_real_visit_class (ValadocApiVisitor* base,
                                         ValadocApiClass* item)
{
	ValadocCTypeResolver * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = valadoc_api_class_get_type_id (item);
	_tmp1_ = _tmp0_;
	valadoc_ctype_resolver_register_symbol_type (self, _tmp1_, (ValadocApiTypeSymbol*) item);
	_g_free0 (_tmp1_);
	_tmp2_ = valadoc_api_class_get_cname (item);
	_tmp3_ = _tmp2_;
	valadoc_ctype_resolver_register_symbol (self, _tmp3_, (ValadocApiNode*) item);
	_g_free0 (_tmp3_);
	valadoc_api_node_accept_all_children ((ValadocApiNode*) item, (ValadocApiVisitor*) self, FALSE);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_ctype_resolver_real_visit_struct (ValadocApiVisitor* base,
                                          ValadocApiStruct* item)
{
	ValadocCTypeResolver * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = valadoc_api_struct_get_type_id (item);
	_tmp1_ = _tmp0_;
	valadoc_ctype_resolver_register_symbol_type (self, _tmp1_, (ValadocApiTypeSymbol*) item);
	_g_free0 (_tmp1_);
	_tmp2_ = valadoc_api_struct_get_cname (item);
	_tmp3_ = _tmp2_;
	valadoc_ctype_resolver_register_symbol (self, _tmp3_, (ValadocApiNode*) item);
	_g_free0 (_tmp3_);
	valadoc_api_node_accept_all_children ((ValadocApiNode*) item, (ValadocApiVisitor*) self, FALSE);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_ctype_resolver_real_visit_property (ValadocApiVisitor* base,
                                            ValadocApiProperty* item)
{
	ValadocCTypeResolver * self;
	gchar* parent_cname = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* cname = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ValaCollection* interfaces = NULL;
	ValaCollection* classes = NULL;
	ValadocApiItem* _tmp9_;
	ValadocApiItem* _tmp10_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = valadoc_ctype_resolver_get_parent_type_cname (self, (ValadocApiItem*) item);
	parent_cname = _tmp0_;
	_tmp1_ = parent_cname;
	_vala_assert (_tmp1_ != NULL, "parent_cname != null");
	_tmp2_ = valadoc_api_property_get_cname (item);
	cname = _tmp2_;
	_tmp3_ = parent_cname;
	_tmp4_ = g_strconcat (_tmp3_, ":", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = cname;
	_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	valadoc_ctype_resolver_register_symbol (self, _tmp8_, (ValadocApiNode*) item);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	_tmp9_ = valadoc_api_item_get_parent ((ValadocApiItem*) item);
	_tmp10_ = _tmp9_;
	if (VALADOC_API_IS_INTERFACE (_tmp10_)) {
		ValadocApiItem* _tmp11_;
		ValadocApiItem* _tmp12_;
		ValaCollection* _tmp13_;
		ValadocApiItem* _tmp14_;
		ValadocApiItem* _tmp15_;
		ValaCollection* _tmp16_;
		_tmp11_ = valadoc_api_item_get_parent ((ValadocApiItem*) item);
		_tmp12_ = _tmp11_;
		_tmp13_ = valadoc_api_interface_get_known_related_interfaces (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
		_vala_iterable_unref0 (interfaces);
		interfaces = _tmp13_;
		_tmp14_ = valadoc_api_item_get_parent ((ValadocApiItem*) item);
		_tmp15_ = _tmp14_;
		_tmp16_ = valadoc_api_interface_get_known_implementations (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
		_vala_iterable_unref0 (classes);
		classes = _tmp16_;
	} else {
		ValadocApiItem* _tmp17_;
		ValadocApiItem* _tmp18_;
		_tmp17_ = valadoc_api_item_get_parent ((ValadocApiItem*) item);
		_tmp18_ = _tmp17_;
		if (VALADOC_API_IS_CLASS (_tmp18_)) {
			ValadocApiItem* _tmp19_;
			ValadocApiItem* _tmp20_;
			ValaCollection* _tmp21_;
			ValadocApiItem* _tmp22_;
			ValadocApiItem* _tmp23_;
			ValaCollection* _tmp24_;
			_tmp19_ = valadoc_api_item_get_parent ((ValadocApiItem*) item);
			_tmp20_ = _tmp19_;
			_tmp21_ = valadoc_api_class_get_known_derived_interfaces (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_vala_iterable_unref0 (interfaces);
			interfaces = _tmp21_;
			_tmp22_ = valadoc_api_item_get_parent ((ValadocApiItem*) item);
			_tmp23_ = _tmp22_;
			_tmp24_ = valadoc_api_class_get_known_child_classes (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_vala_iterable_unref0 (classes);
			classes = _tmp24_;
		} else {
			ValadocApiItem* _tmp25_;
			ValadocApiItem* _tmp26_;
			_tmp25_ = valadoc_api_item_get_parent ((ValadocApiItem*) item);
			_tmp26_ = _tmp25_;
			if (VALADOC_API_IS_STRUCT (_tmp26_)) {
				_vala_iterable_unref0 (classes);
				_vala_iterable_unref0 (interfaces);
				_g_free0 (cname);
				_g_free0 (parent_cname);
				return;
			} else {
				g_assert_not_reached ();
			}
		}
	}
	{
		ValaIterator* _iface_it = NULL;
		ValaCollection* _tmp27_;
		ValaIterator* _tmp28_;
		_tmp27_ = interfaces;
		_tmp28_ = vala_iterable_iterator ((ValaIterable*) _tmp27_);
		_iface_it = _tmp28_;
		while (TRUE) {
			ValaIterator* _tmp29_;
			ValadocApiInterface* iface = NULL;
			ValaIterator* _tmp30_;
			gpointer _tmp31_;
			ValadocApiInterface* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			_tmp29_ = _iface_it;
			if (!vala_iterator_next (_tmp29_)) {
				break;
			}
			_tmp30_ = _iface_it;
			_tmp31_ = vala_iterator_get (_tmp30_);
			iface = (ValadocApiInterface*) _tmp31_;
			_tmp32_ = iface;
			_tmp33_ = valadoc_api_interface_get_cname (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strconcat (_tmp34_, ":", NULL);
			_tmp36_ = _tmp35_;
			_tmp37_ = cname;
			_tmp38_ = g_strconcat (_tmp36_, _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			valadoc_ctype_resolver_register_symbol (self, _tmp39_, (ValadocApiNode*) item);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp36_);
			_g_free0 (_tmp34_);
			_g_object_unref0 (iface);
		}
		_vala_iterator_unref0 (_iface_it);
	}
	{
		ValaIterator* _cl_it = NULL;
		ValaCollection* _tmp40_;
		ValaIterator* _tmp41_;
		_tmp40_ = classes;
		_tmp41_ = vala_iterable_iterator ((ValaIterable*) _tmp40_);
		_cl_it = _tmp41_;
		while (TRUE) {
			ValaIterator* _tmp42_;
			ValadocApiClass* cl = NULL;
			ValaIterator* _tmp43_;
			gpointer _tmp44_;
			ValadocApiClass* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			const gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			_tmp42_ = _cl_it;
			if (!vala_iterator_next (_tmp42_)) {
				break;
			}
			_tmp43_ = _cl_it;
			_tmp44_ = vala_iterator_get (_tmp43_);
			cl = (ValadocApiClass*) _tmp44_;
			_tmp45_ = cl;
			_tmp46_ = valadoc_api_class_get_cname (_tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = g_strconcat (_tmp47_, ":", NULL);
			_tmp49_ = _tmp48_;
			_tmp50_ = cname;
			_tmp51_ = g_strconcat (_tmp49_, _tmp50_, NULL);
			_tmp52_ = _tmp51_;
			valadoc_ctype_resolver_register_symbol (self, _tmp52_, (ValadocApiNode*) item);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp49_);
			_g_free0 (_tmp47_);
			_g_object_unref0 (cl);
		}
		_vala_iterator_unref0 (_cl_it);
	}
	_vala_iterable_unref0 (classes);
	_vala_iterable_unref0 (interfaces);
	_g_free0 (cname);
	_g_free0 (parent_cname);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_ctype_resolver_real_visit_field (ValadocApiVisitor* base,
                                         ValadocApiField* item)
{
	ValadocCTypeResolver * self;
	gboolean _tmp0_ = FALSE;
	ValadocApiItem* _tmp1_;
	ValadocApiItem* _tmp2_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp1_ = valadoc_api_item_get_parent ((ValadocApiItem*) item);
	_tmp2_ = _tmp1_;
	if (VALADOC_API_IS_NAMESPACE (_tmp2_)) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = valadoc_api_field_get_is_static (item);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = valadoc_api_field_get_cname (item);
		_tmp6_ = _tmp5_;
		valadoc_ctype_resolver_register_symbol (self, _tmp6_, (ValadocApiNode*) item);
		_g_free0 (_tmp6_);
	} else {
		gchar* parent_cname = NULL;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = valadoc_ctype_resolver_get_parent_type_cname (self, (ValadocApiItem*) item);
		parent_cname = _tmp7_;
		_tmp8_ = parent_cname;
		if (_tmp8_ != NULL) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp9_ = parent_cname;
			_tmp10_ = g_strconcat (_tmp9_, ".", NULL);
			_tmp11_ = _tmp10_;
			_tmp12_ = valadoc_api_field_get_cname (item);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
			_tmp15_ = _tmp14_;
			valadoc_ctype_resolver_register_symbol (self, _tmp15_, (ValadocApiNode*) item);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
			_g_free0 (_tmp11_);
		}
		_g_free0 (parent_cname);
	}
}

/**
 * {@inheritDoc}
 */
static void
valadoc_ctype_resolver_real_visit_constant (ValadocApiVisitor* base,
                                            ValadocApiConstant* item)
{
	ValadocCTypeResolver * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = valadoc_api_constant_get_cname (item);
	_tmp1_ = _tmp0_;
	valadoc_ctype_resolver_register_symbol (self, _tmp1_, (ValadocApiNode*) item);
	_g_free0 (_tmp1_);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_ctype_resolver_real_visit_delegate (ValadocApiVisitor* base,
                                            ValadocApiDelegate* item)
{
	ValadocCTypeResolver * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = valadoc_api_delegate_get_cname (item);
	_tmp1_ = _tmp0_;
	valadoc_ctype_resolver_register_symbol (self, _tmp1_, (ValadocApiNode*) item);
	_g_free0 (_tmp1_);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_ctype_resolver_real_visit_signal (ValadocApiVisitor* base,
                                          ValadocApiSignal* item)
{
	ValadocCTypeResolver * self;
	gchar* parent_cname = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* default_impl_cname = NULL;
	gchar* _tmp2_;
	gchar* cname = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	ValaCollection* interfaces = NULL;
	ValaCollection* classes = NULL;
	ValadocApiItem* _tmp19_;
	ValadocApiItem* _tmp20_;
	const gchar* _tmp61_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = valadoc_ctype_resolver_get_parent_type_cname (self, (ValadocApiItem*) item);
	parent_cname = _tmp0_;
	_tmp1_ = parent_cname;
	_vala_assert (_tmp1_ != NULL, "parent_cname != null");
	_tmp2_ = valadoc_api_signal_get_default_impl_cname (item);
	default_impl_cname = _tmp2_;
	_tmp3_ = valadoc_api_signal_get_cname (item);
	cname = _tmp3_;
	_tmp4_ = parent_cname;
	_tmp5_ = g_strconcat (_tmp4_, "::", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = cname;
	_tmp8_ = g_strconcat (_tmp6_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	valadoc_ctype_resolver_register_symbol (self, _tmp9_, (ValadocApiNode*) item);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_tmp10_ = valadoc_api_signal_get_is_virtual (item);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp12_ = parent_cname;
		_tmp13_ = g_strconcat (_tmp12_, "Class.", NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = valadoc_api_node_get_name ((ValadocApiNode*) item);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp14_, _tmp16_, NULL);
		_tmp18_ = _tmp17_;
		valadoc_ctype_resolver_register_symbol (self, _tmp18_, (ValadocApiNode*) item);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp14_);
	}
	interfaces = NULL;
	classes = NULL;
	_tmp19_ = valadoc_api_item_get_parent ((ValadocApiItem*) item);
	_tmp20_ = _tmp19_;
	if (VALADOC_API_IS_INTERFACE (_tmp20_)) {
		ValadocApiItem* _tmp21_;
		ValadocApiItem* _tmp22_;
		ValaCollection* _tmp23_;
		ValadocApiItem* _tmp24_;
		ValadocApiItem* _tmp25_;
		ValaCollection* _tmp26_;
		_tmp21_ = valadoc_api_item_get_parent ((ValadocApiItem*) item);
		_tmp22_ = _tmp21_;
		_tmp23_ = valadoc_api_interface_get_known_related_interfaces (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
		_vala_iterable_unref0 (interfaces);
		interfaces = _tmp23_;
		_tmp24_ = valadoc_api_item_get_parent ((ValadocApiItem*) item);
		_tmp25_ = _tmp24_;
		_tmp26_ = valadoc_api_interface_get_known_implementations (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
		_vala_iterable_unref0 (classes);
		classes = _tmp26_;
	} else {
		ValadocApiItem* _tmp27_;
		ValadocApiItem* _tmp28_;
		_tmp27_ = valadoc_api_item_get_parent ((ValadocApiItem*) item);
		_tmp28_ = _tmp27_;
		if (VALADOC_API_IS_CLASS (_tmp28_)) {
			ValadocApiItem* _tmp29_;
			ValadocApiItem* _tmp30_;
			ValaCollection* _tmp31_;
			ValadocApiItem* _tmp32_;
			ValadocApiItem* _tmp33_;
			ValaCollection* _tmp34_;
			_tmp29_ = valadoc_api_item_get_parent ((ValadocApiItem*) item);
			_tmp30_ = _tmp29_;
			_tmp31_ = valadoc_api_class_get_known_derived_interfaces (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_vala_iterable_unref0 (interfaces);
			interfaces = _tmp31_;
			_tmp32_ = valadoc_api_item_get_parent ((ValadocApiItem*) item);
			_tmp33_ = _tmp32_;
			_tmp34_ = valadoc_api_class_get_known_child_classes (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_vala_iterable_unref0 (classes);
			classes = _tmp34_;
		}
	}
	{
		ValaIterator* _iface_it = NULL;
		ValaCollection* _tmp35_;
		ValaIterator* _tmp36_;
		_tmp35_ = interfaces;
		_tmp36_ = vala_iterable_iterator ((ValaIterable*) _tmp35_);
		_iface_it = _tmp36_;
		while (TRUE) {
			ValaIterator* _tmp37_;
			ValadocApiInterface* iface = NULL;
			ValaIterator* _tmp38_;
			gpointer _tmp39_;
			ValadocApiInterface* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			const gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			_tmp37_ = _iface_it;
			if (!vala_iterator_next (_tmp37_)) {
				break;
			}
			_tmp38_ = _iface_it;
			_tmp39_ = vala_iterator_get (_tmp38_);
			iface = (ValadocApiInterface*) _tmp39_;
			_tmp40_ = iface;
			_tmp41_ = valadoc_api_interface_get_cname (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat (_tmp42_, "::", NULL);
			_tmp44_ = _tmp43_;
			_tmp45_ = cname;
			_tmp46_ = g_strconcat (_tmp44_, _tmp45_, NULL);
			_tmp47_ = _tmp46_;
			valadoc_ctype_resolver_register_symbol (self, _tmp47_, (ValadocApiNode*) item);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_object_unref0 (iface);
		}
		_vala_iterator_unref0 (_iface_it);
	}
	{
		ValaIterator* _cl_it = NULL;
		ValaCollection* _tmp48_;
		ValaIterator* _tmp49_;
		_tmp48_ = classes;
		_tmp49_ = vala_iterable_iterator ((ValaIterable*) _tmp48_);
		_cl_it = _tmp49_;
		while (TRUE) {
			ValaIterator* _tmp50_;
			ValadocApiClass* cl = NULL;
			ValaIterator* _tmp51_;
			gpointer _tmp52_;
			ValadocApiClass* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			const gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			_tmp50_ = _cl_it;
			if (!vala_iterator_next (_tmp50_)) {
				break;
			}
			_tmp51_ = _cl_it;
			_tmp52_ = vala_iterator_get (_tmp51_);
			cl = (ValadocApiClass*) _tmp52_;
			_tmp53_ = cl;
			_tmp54_ = valadoc_api_class_get_cname (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = g_strconcat (_tmp55_, "::", NULL);
			_tmp57_ = _tmp56_;
			_tmp58_ = cname;
			_tmp59_ = g_strconcat (_tmp57_, _tmp58_, NULL);
			_tmp60_ = _tmp59_;
			valadoc_ctype_resolver_register_symbol (self, _tmp60_, (ValadocApiNode*) item);
			_g_free0 (_tmp60_);
			_g_free0 (_tmp57_);
			_g_free0 (_tmp55_);
			_g_object_unref0 (cl);
		}
		_vala_iterator_unref0 (_cl_it);
	}
	_tmp61_ = default_impl_cname;
	if (_tmp61_ != NULL) {
		const gchar* _tmp62_;
		_tmp62_ = default_impl_cname;
		valadoc_ctype_resolver_register_symbol (self, _tmp62_, (ValadocApiNode*) item);
	}
	_vala_iterable_unref0 (classes);
	_vala_iterable_unref0 (interfaces);
	_g_free0 (cname);
	_g_free0 (default_impl_cname);
	_g_free0 (parent_cname);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_ctype_resolver_real_visit_method (ValadocApiVisitor* base,
                                          ValadocApiMethod* item)
{
	ValadocCTypeResolver * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp2_ = valadoc_api_method_get_is_abstract (item);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = valadoc_api_method_get_is_virtual (item);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = valadoc_api_method_get_is_override (item);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_;
	}
	if (_tmp0_) {
		gchar* parent_cname = NULL;
		gchar* _tmp8_;
		ValadocApiItem* _tmp9_;
		ValadocApiItem* _tmp10_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp8_ = valadoc_ctype_resolver_get_parent_type_cname (self, (ValadocApiItem*) item);
		parent_cname = _tmp8_;
		_tmp9_ = valadoc_api_item_get_parent ((ValadocApiItem*) item);
		_tmp10_ = _tmp9_;
		if (VALADOC_API_IS_CLASS (_tmp10_)) {
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp11_ = parent_cname;
			_tmp12_ = g_strconcat (_tmp11_, "Class.", NULL);
			_tmp13_ = _tmp12_;
			_tmp14_ = valadoc_api_node_get_name ((ValadocApiNode*) item);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat (_tmp13_, _tmp15_, NULL);
			_tmp17_ = _tmp16_;
			valadoc_ctype_resolver_register_symbol (self, _tmp17_, (ValadocApiNode*) item);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp13_);
		} else {
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp18_ = parent_cname;
			_tmp19_ = g_strconcat (_tmp18_, "Iface.", NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = valadoc_api_node_get_name ((ValadocApiNode*) item);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strconcat (_tmp20_, _tmp22_, NULL);
			_tmp24_ = _tmp23_;
			valadoc_ctype_resolver_register_symbol (self, _tmp24_, (ValadocApiNode*) item);
			_g_free0 (_tmp24_);
			_g_free0 (_tmp20_);
		}
		_tmp25_ = parent_cname;
		_tmp26_ = g_strconcat (_tmp25_, ".", NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = valadoc_api_node_get_name ((ValadocApiNode*) item);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp27_, _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		valadoc_ctype_resolver_register_symbol (self, _tmp31_, (ValadocApiNode*) item);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp27_);
		_g_free0 (parent_cname);
	}
	_tmp32_ = valadoc_api_method_get_cname (item);
	_tmp33_ = _tmp32_;
	valadoc_ctype_resolver_register_symbol (self, _tmp33_, (ValadocApiNode*) item);
	_g_free0 (_tmp33_);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_ctype_resolver_real_visit_error_domain (ValadocApiVisitor* base,
                                                ValadocApiErrorDomain* item)
{
	ValadocCTypeResolver * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = valadoc_api_error_domain_get_cname (item);
	_tmp1_ = _tmp0_;
	valadoc_ctype_resolver_register_symbol (self, _tmp1_, (ValadocApiNode*) item);
	_g_free0 (_tmp1_);
	valadoc_api_node_accept_all_children ((ValadocApiNode*) item, (ValadocApiVisitor*) self, FALSE);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_ctype_resolver_real_visit_error_code (ValadocApiVisitor* base,
                                              ValadocApiErrorCode* item)
{
	ValadocCTypeResolver * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = valadoc_api_error_code_get_cname (item);
	_tmp1_ = _tmp0_;
	valadoc_ctype_resolver_register_symbol (self, _tmp1_, (ValadocApiNode*) item);
	_g_free0 (_tmp1_);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_ctype_resolver_real_visit_enum (ValadocApiVisitor* base,
                                        ValadocApiEnum* item)
{
	ValadocCTypeResolver * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = valadoc_api_enum_get_type_id (item);
	_tmp1_ = _tmp0_;
	valadoc_ctype_resolver_register_symbol_type (self, _tmp1_, (ValadocApiTypeSymbol*) item);
	_g_free0 (_tmp1_);
	_tmp2_ = valadoc_api_enum_get_cname (item);
	_tmp3_ = _tmp2_;
	valadoc_ctype_resolver_register_symbol (self, _tmp3_, (ValadocApiNode*) item);
	_g_free0 (_tmp3_);
	valadoc_api_node_accept_all_children ((ValadocApiNode*) item, (ValadocApiVisitor*) self, FALSE);
}

/**
 * {@inheritDoc}
 */
static void
valadoc_ctype_resolver_real_visit_enum_value (ValadocApiVisitor* base,
                                              ValadocApiEnumValue* item)
{
	ValadocCTypeResolver * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ValadocCTypeResolver*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = valadoc_api_enum_value_get_cname (item);
	_tmp1_ = _tmp0_;
	valadoc_ctype_resolver_register_symbol (self, _tmp1_, (ValadocApiNode*) item);
	_g_free0 (_tmp1_);
}

static void
valadoc_ctype_resolver_class_init (ValadocCTypeResolverClass * klass,
                                   gpointer klass_data)
{
	valadoc_ctype_resolver_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocCTypeResolver_private_offset);
	((ValadocApiVisitorClass *) klass)->visit_tree = (void (*) (ValadocApiVisitor*, ValadocApiTree*)) valadoc_ctype_resolver_real_visit_tree;
	((ValadocApiVisitorClass *) klass)->visit_package = (void (*) (ValadocApiVisitor*, ValadocApiPackage*)) valadoc_ctype_resolver_real_visit_package;
	((ValadocApiVisitorClass *) klass)->visit_namespace = (void (*) (ValadocApiVisitor*, ValadocApiNamespace*)) valadoc_ctype_resolver_real_visit_namespace;
	((ValadocApiVisitorClass *) klass)->visit_interface = (void (*) (ValadocApiVisitor*, ValadocApiInterface*)) valadoc_ctype_resolver_real_visit_interface;
	((ValadocApiVisitorClass *) klass)->visit_class = (void (*) (ValadocApiVisitor*, ValadocApiClass*)) valadoc_ctype_resolver_real_visit_class;
	((ValadocApiVisitorClass *) klass)->visit_struct = (void (*) (ValadocApiVisitor*, ValadocApiStruct*)) valadoc_ctype_resolver_real_visit_struct;
	((ValadocApiVisitorClass *) klass)->visit_property = (void (*) (ValadocApiVisitor*, ValadocApiProperty*)) valadoc_ctype_resolver_real_visit_property;
	((ValadocApiVisitorClass *) klass)->visit_field = (void (*) (ValadocApiVisitor*, ValadocApiField*)) valadoc_ctype_resolver_real_visit_field;
	((ValadocApiVisitorClass *) klass)->visit_constant = (void (*) (ValadocApiVisitor*, ValadocApiConstant*)) valadoc_ctype_resolver_real_visit_constant;
	((ValadocApiVisitorClass *) klass)->visit_delegate = (void (*) (ValadocApiVisitor*, ValadocApiDelegate*)) valadoc_ctype_resolver_real_visit_delegate;
	((ValadocApiVisitorClass *) klass)->visit_signal = (void (*) (ValadocApiVisitor*, ValadocApiSignal*)) valadoc_ctype_resolver_real_visit_signal;
	((ValadocApiVisitorClass *) klass)->visit_method = (void (*) (ValadocApiVisitor*, ValadocApiMethod*)) valadoc_ctype_resolver_real_visit_method;
	((ValadocApiVisitorClass *) klass)->visit_error_domain = (void (*) (ValadocApiVisitor*, ValadocApiErrorDomain*)) valadoc_ctype_resolver_real_visit_error_domain;
	((ValadocApiVisitorClass *) klass)->visit_error_code = (void (*) (ValadocApiVisitor*, ValadocApiErrorCode*)) valadoc_ctype_resolver_real_visit_error_code;
	((ValadocApiVisitorClass *) klass)->visit_enum = (void (*) (ValadocApiVisitor*, ValadocApiEnum*)) valadoc_ctype_resolver_real_visit_enum;
	((ValadocApiVisitorClass *) klass)->visit_enum_value = (void (*) (ValadocApiVisitor*, ValadocApiEnumValue*)) valadoc_ctype_resolver_real_visit_enum_value;
	G_OBJECT_CLASS (klass)->finalize = valadoc_ctype_resolver_finalize;
}

static void
valadoc_ctype_resolver_instance_init (ValadocCTypeResolver * self,
                                      gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GEqualFunc _tmp6_;
	ValaHashMap* _tmp7_;
	self->priv = valadoc_ctype_resolver_get_instance_private (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALADOC_API_TYPE_TYPESYMBOL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_, _tmp1_, _tmp2_);
	self->priv->types = (ValaMap*) _tmp3_;
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALADOC_API_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp4_, _tmp5_, _tmp6_);
	self->priv->nodes = (ValaMap*) _tmp7_;
}

static void
valadoc_ctype_resolver_finalize (GObject * obj)
{
	ValadocCTypeResolver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_CTYPE_RESOLVER, ValadocCTypeResolver);
	_vala_map_unref0 (self->priv->types);
	_vala_map_unref0 (self->priv->nodes);
	_valadoc_api_tree_unref0 (self->priv->tree);
	G_OBJECT_CLASS (valadoc_ctype_resolver_parent_class)->finalize (obj);
}

/**
 * Resolves symbols by C-names
 */
GType
valadoc_ctype_resolver_get_type (void)
{
	static volatile gsize valadoc_ctype_resolver_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_ctype_resolver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocCTypeResolverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_ctype_resolver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocCTypeResolver), 0, (GInstanceInitFunc) valadoc_ctype_resolver_instance_init, NULL };
		GType valadoc_ctype_resolver_type_id;
		valadoc_ctype_resolver_type_id = g_type_register_static (VALADOC_API_TYPE_VISITOR, "ValadocCTypeResolver", &g_define_type_info, 0);
		ValadocCTypeResolver_private_offset = g_type_add_instance_private (valadoc_ctype_resolver_type_id, sizeof (ValadocCTypeResolverPrivate));
		g_once_init_leave (&valadoc_ctype_resolver_type_id__volatile, valadoc_ctype_resolver_type_id);
	}
	return valadoc_ctype_resolver_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

