/* valaconditionalexpression.c generated by valac, the Vala compiler
 * generated from valaconditionalexpression.vala, do not modify */

/* valaconditionalexpression.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_CONDITIONAL_EXPRESSION_0_PROPERTY,
	VALA_CONDITIONAL_EXPRESSION_NUM_PROPERTIES
};
static GParamSpec* vala_conditional_expression_properties[VALA_CONDITIONAL_EXPRESSION_NUM_PROPERTIES];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaConditionalExpressionPrivate {
	ValaExpression* _condition;
	ValaExpression* _true_expression;
	ValaExpression* _false_expression;
};


static gpointer vala_conditional_expression_parent_class = NULL;

#define VALA_CONDITIONAL_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionPrivate))
static void vala_conditional_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_conditional_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_conditional_expression_real_is_pure (ValaExpression* base);
static gboolean vala_conditional_expression_real_is_accessible (ValaExpression* base, ValaSymbol* sym);
static gboolean vala_conditional_expression_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_conditional_expression_finalize (ValaCodeNode * obj);


/**
 * Creates a new conditional expression.
 *
 * @param cond       a condition
 * @param true_expr  expression to be evaluated if condition is true
 * @param false_expr expression to be evaluated if condition is false
 * @return           newly created conditional expression
 */
ValaConditionalExpression* vala_conditional_expression_construct (GType object_type, ValaExpression* cond, ValaExpression* true_expr, ValaExpression* false_expr, ValaSourceReference* source) {
	ValaConditionalExpression* self = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaSourceReference* _tmp3_;
	g_return_val_if_fail (cond != NULL, NULL);
	g_return_val_if_fail (true_expr != NULL, NULL);
	g_return_val_if_fail (false_expr != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = (ValaConditionalExpression*) vala_expression_construct (object_type);
	_tmp0_ = cond;
	vala_conditional_expression_set_condition (self, _tmp0_);
	_tmp1_ = true_expr;
	vala_conditional_expression_set_true_expression (self, _tmp1_);
	_tmp2_ = false_expr;
	vala_conditional_expression_set_false_expression (self, _tmp2_);
	_tmp3_ = source;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp3_);
	return self;
}


ValaConditionalExpression* vala_conditional_expression_new (ValaExpression* cond, ValaExpression* true_expr, ValaExpression* false_expr, ValaSourceReference* source) {
	return vala_conditional_expression_construct (VALA_TYPE_CONDITIONAL_EXPRESSION, cond, true_expr, false_expr, source);
}


static void vala_conditional_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaConditionalExpression * self;
	ValaCodeVisitor* _tmp0_;
	ValaCodeVisitor* _tmp1_;
	self = (ValaConditionalExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_conditional_expression (_tmp0_, self);
	_tmp1_ = visitor;
	vala_code_visitor_visit_expression (_tmp1_, (ValaExpression*) self);
}


static void vala_conditional_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaConditionalExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaCodeVisitor* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaCodeVisitor* _tmp8_;
	self = (ValaConditionalExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_conditional_expression_get_condition (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = vala_conditional_expression_get_true_expression (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp4_, _tmp5_);
	_tmp6_ = vala_conditional_expression_get_false_expression (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp7_, _tmp8_);
}


static gboolean vala_conditional_expression_real_is_pure (ValaExpression* base) {
	ValaConditionalExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean _tmp4_;
	self = (ValaConditionalExpression*) base;
	_tmp2_ = vala_conditional_expression_get_condition (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_is_pure (_tmp3_);
	if (_tmp4_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = vala_conditional_expression_get_true_expression (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_expression_is_pure (_tmp6_);
		_tmp1_ = _tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaExpression* _tmp8_;
		ValaExpression* _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = vala_conditional_expression_get_false_expression (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_expression_is_pure (_tmp9_);
		_tmp0_ = _tmp10_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean vala_conditional_expression_real_is_accessible (ValaExpression* base, ValaSymbol* sym) {
	ValaConditionalExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean _tmp5_;
	self = (ValaConditionalExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_conditional_expression_get_condition (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = sym;
	_tmp5_ = vala_expression_is_accessible (_tmp3_, _tmp4_);
	if (_tmp5_) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaSymbol* _tmp8_;
		gboolean _tmp9_;
		_tmp6_ = vala_conditional_expression_get_true_expression (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = sym;
		_tmp9_ = vala_expression_is_accessible (_tmp7_, _tmp8_);
		_tmp1_ = _tmp9_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaSymbol* _tmp12_;
		gboolean _tmp13_;
		_tmp10_ = vala_conditional_expression_get_false_expression (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = sym;
		_tmp13_ = vala_expression_is_accessible (_tmp11_, _tmp12_);
		_tmp0_ = _tmp13_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean vala_conditional_expression_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaConditionalExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaCodeContext* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	gchar* temp_name = NULL;
	gchar* _tmp11_;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	ValaExpression* _tmp16_;
	ValaExpression* _tmp17_;
	ValaDataType* _tmp18_;
	ValaDataType* _tmp19_;
	ValaLocalVariable* local = NULL;
	const gchar* _tmp20_;
	ValaSourceReference* _tmp21_;
	ValaSourceReference* _tmp22_;
	ValaLocalVariable* _tmp23_;
	ValaDeclarationStatement* decl = NULL;
	ValaLocalVariable* _tmp24_;
	ValaSourceReference* _tmp25_;
	ValaSourceReference* _tmp26_;
	ValaDeclarationStatement* _tmp27_;
	ValaLocalVariable* true_local = NULL;
	const gchar* _tmp28_;
	ValaExpression* _tmp29_;
	ValaExpression* _tmp30_;
	ValaExpression* _tmp31_;
	ValaExpression* _tmp32_;
	ValaSourceReference* _tmp33_;
	ValaSourceReference* _tmp34_;
	ValaLocalVariable* _tmp35_;
	ValaBlock* true_block = NULL;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaSourceReference* _tmp38_;
	ValaSourceReference* _tmp39_;
	ValaBlock* _tmp40_;
	ValaDeclarationStatement* true_decl = NULL;
	ValaLocalVariable* _tmp41_;
	ValaExpression* _tmp42_;
	ValaExpression* _tmp43_;
	ValaSourceReference* _tmp44_;
	ValaSourceReference* _tmp45_;
	ValaDeclarationStatement* _tmp46_;
	ValaBlock* _tmp47_;
	ValaDeclarationStatement* _tmp48_;
	ValaLocalVariable* false_local = NULL;
	const gchar* _tmp49_;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	ValaExpression* _tmp52_;
	ValaExpression* _tmp53_;
	ValaSourceReference* _tmp54_;
	ValaSourceReference* _tmp55_;
	ValaLocalVariable* _tmp56_;
	ValaBlock* false_block = NULL;
	ValaExpression* _tmp57_;
	ValaExpression* _tmp58_;
	ValaSourceReference* _tmp59_;
	ValaSourceReference* _tmp60_;
	ValaBlock* _tmp61_;
	ValaDeclarationStatement* false_decl = NULL;
	ValaLocalVariable* _tmp62_;
	ValaExpression* _tmp63_;
	ValaExpression* _tmp64_;
	ValaSourceReference* _tmp65_;
	ValaSourceReference* _tmp66_;
	ValaDeclarationStatement* _tmp67_;
	ValaBlock* _tmp68_;
	ValaDeclarationStatement* _tmp69_;
	ValaIfStatement* if_stmt = NULL;
	ValaExpression* _tmp70_;
	ValaExpression* _tmp71_;
	ValaBlock* _tmp72_;
	ValaBlock* _tmp73_;
	ValaSourceReference* _tmp74_;
	ValaSourceReference* _tmp75_;
	ValaIfStatement* _tmp76_;
	ValaCodeContext* _tmp77_;
	ValaSemanticAnalyzer* _tmp78_;
	ValaSemanticAnalyzer* _tmp79_;
	ValaBlock* _tmp80_;
	ValaDeclarationStatement* _tmp81_;
	ValaCodeContext* _tmp82_;
	ValaSemanticAnalyzer* _tmp83_;
	ValaSemanticAnalyzer* _tmp84_;
	ValaBlock* _tmp85_;
	ValaIfStatement* _tmp86_;
	gboolean _tmp87_ = FALSE;
	gboolean _tmp88_ = FALSE;
	ValaIfStatement* _tmp89_;
	ValaCodeContext* _tmp90_;
	gboolean _tmp91_;
	ValaLocalVariable* _tmp100_;
	ValaExpression* _tmp101_;
	ValaExpression* _tmp102_;
	ValaLocalVariable* _tmp103_;
	ValaExpression* _tmp104_;
	ValaExpression* _tmp105_;
	ValaBlock* _tmp106_;
	ValaLocalVariable* _tmp107_;
	ValaBlock* _tmp108_;
	ValaLocalVariable* _tmp109_;
	ValaExpression* _tmp110_;
	ValaExpression* _tmp111_;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	ValaExpression* _tmp114_;
	ValaExpression* _tmp115_;
	ValaDataType* _tmp116_;
	ValaDataType* _tmp117_;
	gboolean _tmp118_;
	gboolean _tmp144_ = FALSE;
	ValaExpression* _tmp145_;
	ValaExpression* _tmp146_;
	ValaDataType* _tmp147_;
	ValaDataType* _tmp148_;
	gboolean _tmp149_;
	gboolean _tmp150_;
	ValaDataType* _tmp157_;
	ValaDataType* _tmp158_;
	ValaLocalVariable* _tmp159_;
	ValaDataType* _tmp160_;
	ValaDataType* _tmp161_;
	ValaDeclarationStatement* _tmp162_;
	ValaCodeContext* _tmp163_;
	ValaExpression* _tmp164_;
	ValaExpression* _tmp165_;
	ValaDataType* _tmp166_;
	ValaDataType* _tmp167_;
	ValaExpression* _tmp168_;
	ValaExpression* _tmp169_;
	ValaDataType* _tmp170_;
	ValaDataType* _tmp171_;
	ValaExpressionStatement* true_stmt = NULL;
	ValaLocalVariable* _tmp172_;
	const gchar* _tmp173_;
	const gchar* _tmp174_;
	ValaExpression* _tmp175_;
	ValaExpression* _tmp176_;
	ValaSourceReference* _tmp177_;
	ValaSourceReference* _tmp178_;
	ValaMemberAccess* _tmp179_;
	ValaMemberAccess* _tmp180_;
	ValaExpression* _tmp181_;
	ValaExpression* _tmp182_;
	ValaExpression* _tmp183_;
	ValaExpression* _tmp184_;
	ValaSourceReference* _tmp185_;
	ValaSourceReference* _tmp186_;
	ValaAssignment* _tmp187_;
	ValaAssignment* _tmp188_;
	ValaExpression* _tmp189_;
	ValaExpression* _tmp190_;
	ValaSourceReference* _tmp191_;
	ValaSourceReference* _tmp192_;
	ValaExpressionStatement* _tmp193_;
	ValaExpressionStatement* _tmp194_;
	ValaExpressionStatement* _tmp195_;
	ValaCodeContext* _tmp196_;
	ValaExpressionStatement* false_stmt = NULL;
	ValaLocalVariable* _tmp197_;
	const gchar* _tmp198_;
	const gchar* _tmp199_;
	ValaExpression* _tmp200_;
	ValaExpression* _tmp201_;
	ValaSourceReference* _tmp202_;
	ValaSourceReference* _tmp203_;
	ValaMemberAccess* _tmp204_;
	ValaMemberAccess* _tmp205_;
	ValaExpression* _tmp206_;
	ValaExpression* _tmp207_;
	ValaExpression* _tmp208_;
	ValaExpression* _tmp209_;
	ValaSourceReference* _tmp210_;
	ValaSourceReference* _tmp211_;
	ValaAssignment* _tmp212_;
	ValaAssignment* _tmp213_;
	ValaExpression* _tmp214_;
	ValaExpression* _tmp215_;
	ValaSourceReference* _tmp216_;
	ValaSourceReference* _tmp217_;
	ValaExpressionStatement* _tmp218_;
	ValaExpressionStatement* _tmp219_;
	ValaExpressionStatement* _tmp220_;
	ValaCodeContext* _tmp221_;
	ValaBlock* _tmp222_;
	ValaDeclarationStatement* _tmp223_;
	ValaExpressionStatement* _tmp224_;
	ValaBlock* _tmp225_;
	ValaDeclarationStatement* _tmp226_;
	ValaExpressionStatement* _tmp227_;
	ValaMemberAccess* ma = NULL;
	ValaLocalVariable* _tmp228_;
	const gchar* _tmp229_;
	const gchar* _tmp230_;
	ValaSourceReference* _tmp231_;
	ValaSourceReference* _tmp232_;
	ValaMemberAccess* _tmp233_;
	ValaMemberAccess* _tmp234_;
	ValaDataType* _tmp235_;
	ValaDataType* _tmp236_;
	ValaMemberAccess* _tmp237_;
	ValaDataType* _tmp238_;
	ValaDataType* _tmp239_;
	ValaMemberAccess* _tmp240_;
	ValaCodeContext* _tmp241_;
	ValaCodeNode* _tmp242_;
	ValaCodeNode* _tmp243_;
	ValaMemberAccess* _tmp244_;
	self = (ValaConditionalExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_symbol (_tmp6_);
	_tmp8_ = _tmp7_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_BLOCK)) {
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		vala_report_error (_tmp10_, "Conditional expressions may only be used in blocks");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp11_ = vala_code_node_get_temp_name ();
	temp_name = _tmp11_;
	_tmp12_ = vala_conditional_expression_get_true_expression (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp15_ = _tmp14_;
	vala_expression_set_target_type (_tmp13_, _tmp15_);
	_tmp16_ = vala_conditional_expression_get_false_expression (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp19_ = _tmp18_;
	vala_expression_set_target_type (_tmp17_, _tmp19_);
	_tmp20_ = temp_name;
	_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_local_variable_new (NULL, _tmp20_, NULL, _tmp22_);
	local = _tmp23_;
	_tmp24_ = local;
	_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_declaration_statement_new ((ValaSymbol*) _tmp24_, _tmp26_);
	decl = _tmp27_;
	_tmp28_ = temp_name;
	_tmp29_ = vala_conditional_expression_get_true_expression (self);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_conditional_expression_get_true_expression (self);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_local_variable_new (NULL, _tmp28_, _tmp30_, _tmp34_);
	true_local = _tmp35_;
	_tmp36_ = vala_conditional_expression_get_true_expression (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_block_new (_tmp39_);
	true_block = _tmp40_;
	_tmp41_ = true_local;
	_tmp42_ = vala_conditional_expression_get_true_expression (self);
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_declaration_statement_new ((ValaSymbol*) _tmp41_, _tmp45_);
	true_decl = _tmp46_;
	_tmp47_ = true_block;
	_tmp48_ = true_decl;
	vala_block_add_statement (_tmp47_, (ValaStatement*) _tmp48_);
	_tmp49_ = temp_name;
	_tmp50_ = vala_conditional_expression_get_false_expression (self);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_conditional_expression_get_false_expression (self);
	_tmp53_ = _tmp52_;
	_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = vala_local_variable_new (NULL, _tmp49_, _tmp51_, _tmp55_);
	false_local = _tmp56_;
	_tmp57_ = vala_conditional_expression_get_false_expression (self);
	_tmp58_ = _tmp57_;
	_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp58_);
	_tmp60_ = _tmp59_;
	_tmp61_ = vala_block_new (_tmp60_);
	false_block = _tmp61_;
	_tmp62_ = false_local;
	_tmp63_ = vala_conditional_expression_get_false_expression (self);
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = vala_declaration_statement_new ((ValaSymbol*) _tmp62_, _tmp66_);
	false_decl = _tmp67_;
	_tmp68_ = false_block;
	_tmp69_ = false_decl;
	vala_block_add_statement (_tmp68_, (ValaStatement*) _tmp69_);
	_tmp70_ = vala_conditional_expression_get_condition (self);
	_tmp71_ = _tmp70_;
	_tmp72_ = true_block;
	_tmp73_ = false_block;
	_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = vala_if_statement_new (_tmp71_, _tmp72_, _tmp73_, _tmp75_);
	if_stmt = _tmp76_;
	_tmp77_ = context;
	_tmp78_ = vala_code_context_get_analyzer (_tmp77_);
	_tmp79_ = _tmp78_;
	_tmp80_ = _tmp79_->insert_block;
	_tmp81_ = decl;
	vala_expression_insert_statement ((ValaExpression*) self, _tmp80_, (ValaStatement*) _tmp81_);
	_tmp82_ = context;
	_tmp83_ = vala_code_context_get_analyzer (_tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = _tmp84_->insert_block;
	_tmp86_ = if_stmt;
	vala_expression_insert_statement ((ValaExpression*) self, _tmp85_, (ValaStatement*) _tmp86_);
	_tmp89_ = if_stmt;
	_tmp90_ = context;
	_tmp91_ = vala_code_node_check ((ValaCodeNode*) _tmp89_, _tmp90_);
	if (!_tmp91_) {
		_tmp88_ = TRUE;
	} else {
		ValaExpression* _tmp92_;
		ValaExpression* _tmp93_;
		gboolean _tmp94_;
		gboolean _tmp95_;
		_tmp92_ = vala_conditional_expression_get_true_expression (self);
		_tmp93_ = _tmp92_;
		_tmp94_ = vala_code_node_get_error ((ValaCodeNode*) _tmp93_);
		_tmp95_ = _tmp94_;
		_tmp88_ = _tmp95_;
	}
	if (_tmp88_) {
		_tmp87_ = TRUE;
	} else {
		ValaExpression* _tmp96_;
		ValaExpression* _tmp97_;
		gboolean _tmp98_;
		gboolean _tmp99_;
		_tmp96_ = vala_conditional_expression_get_false_expression (self);
		_tmp97_ = _tmp96_;
		_tmp98_ = vala_code_node_get_error ((ValaCodeNode*) _tmp97_);
		_tmp99_ = _tmp98_;
		_tmp87_ = _tmp99_;
	}
	if (_tmp87_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (false_decl);
		_vala_code_node_unref0 (false_block);
		_vala_code_node_unref0 (false_local);
		_vala_code_node_unref0 (true_decl);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (true_local);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_g_free0 (temp_name);
		return result;
	}
	_tmp100_ = true_local;
	_tmp101_ = vala_variable_get_initializer ((ValaVariable*) _tmp100_);
	_tmp102_ = _tmp101_;
	vala_conditional_expression_set_true_expression (self, _tmp102_);
	_tmp103_ = false_local;
	_tmp104_ = vala_variable_get_initializer ((ValaVariable*) _tmp103_);
	_tmp105_ = _tmp104_;
	vala_conditional_expression_set_false_expression (self, _tmp105_);
	_tmp106_ = true_block;
	_tmp107_ = true_local;
	vala_block_remove_local_variable (_tmp106_, _tmp107_);
	_tmp108_ = false_block;
	_tmp109_ = false_local;
	vala_block_remove_local_variable (_tmp108_, _tmp109_);
	_tmp110_ = vala_conditional_expression_get_false_expression (self);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_expression_get_value_type (_tmp111_);
	_tmp113_ = _tmp112_;
	_tmp114_ = vala_conditional_expression_get_true_expression (self);
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_expression_get_value_type (_tmp115_);
	_tmp117_ = _tmp116_;
	_tmp118_ = vala_data_type_compatible (_tmp113_, _tmp117_);
	if (_tmp118_) {
		ValaExpression* _tmp119_;
		ValaExpression* _tmp120_;
		ValaDataType* _tmp121_;
		ValaDataType* _tmp122_;
		ValaDataType* _tmp123_;
		ValaDataType* _tmp124_;
		_tmp119_ = vala_conditional_expression_get_true_expression (self);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_expression_get_value_type (_tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_data_type_copy (_tmp122_);
		_tmp124_ = _tmp123_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp124_);
		_vala_code_node_unref0 (_tmp124_);
	} else {
		ValaExpression* _tmp125_;
		ValaExpression* _tmp126_;
		ValaDataType* _tmp127_;
		ValaDataType* _tmp128_;
		ValaExpression* _tmp129_;
		ValaExpression* _tmp130_;
		ValaDataType* _tmp131_;
		ValaDataType* _tmp132_;
		gboolean _tmp133_;
		_tmp125_ = vala_conditional_expression_get_true_expression (self);
		_tmp126_ = _tmp125_;
		_tmp127_ = vala_expression_get_value_type (_tmp126_);
		_tmp128_ = _tmp127_;
		_tmp129_ = vala_conditional_expression_get_false_expression (self);
		_tmp130_ = _tmp129_;
		_tmp131_ = vala_expression_get_value_type (_tmp130_);
		_tmp132_ = _tmp131_;
		_tmp133_ = vala_data_type_compatible (_tmp128_, _tmp132_);
		if (_tmp133_) {
			ValaExpression* _tmp134_;
			ValaExpression* _tmp135_;
			ValaDataType* _tmp136_;
			ValaDataType* _tmp137_;
			ValaDataType* _tmp138_;
			ValaDataType* _tmp139_;
			_tmp134_ = vala_conditional_expression_get_false_expression (self);
			_tmp135_ = _tmp134_;
			_tmp136_ = vala_expression_get_value_type (_tmp135_);
			_tmp137_ = _tmp136_;
			_tmp138_ = vala_data_type_copy (_tmp137_);
			_tmp139_ = _tmp138_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp139_);
			_vala_code_node_unref0 (_tmp139_);
		} else {
			ValaExpression* _tmp140_;
			ValaExpression* _tmp141_;
			ValaSourceReference* _tmp142_;
			ValaSourceReference* _tmp143_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp140_ = vala_conditional_expression_get_condition (self);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp141_);
			_tmp143_ = _tmp142_;
			vala_report_error (_tmp143_, "Incompatible expressions");
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (false_decl);
			_vala_code_node_unref0 (false_block);
			_vala_code_node_unref0 (false_local);
			_vala_code_node_unref0 (true_decl);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (true_local);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_g_free0 (temp_name);
			return result;
		}
	}
	_tmp145_ = vala_conditional_expression_get_true_expression (self);
	_tmp146_ = _tmp145_;
	_tmp147_ = vala_expression_get_value_type (_tmp146_);
	_tmp148_ = _tmp147_;
	_tmp149_ = vala_data_type_get_value_owned (_tmp148_);
	_tmp150_ = _tmp149_;
	if (_tmp150_) {
		_tmp144_ = TRUE;
	} else {
		ValaExpression* _tmp151_;
		ValaExpression* _tmp152_;
		ValaDataType* _tmp153_;
		ValaDataType* _tmp154_;
		gboolean _tmp155_;
		gboolean _tmp156_;
		_tmp151_ = vala_conditional_expression_get_false_expression (self);
		_tmp152_ = _tmp151_;
		_tmp153_ = vala_expression_get_value_type (_tmp152_);
		_tmp154_ = _tmp153_;
		_tmp155_ = vala_data_type_get_value_owned (_tmp154_);
		_tmp156_ = _tmp155_;
		_tmp144_ = _tmp156_;
	}
	_tmp157_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp158_ = _tmp157_;
	vala_data_type_set_value_owned (_tmp158_, _tmp144_);
	_tmp159_ = local;
	_tmp160_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp161_ = _tmp160_;
	vala_variable_set_variable_type ((ValaVariable*) _tmp159_, _tmp161_);
	_tmp162_ = decl;
	_tmp163_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp162_, _tmp163_);
	_tmp164_ = vala_conditional_expression_get_true_expression (self);
	_tmp165_ = _tmp164_;
	_tmp166_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp167_ = _tmp166_;
	vala_expression_set_target_type (_tmp165_, _tmp167_);
	_tmp168_ = vala_conditional_expression_get_false_expression (self);
	_tmp169_ = _tmp168_;
	_tmp170_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp171_ = _tmp170_;
	vala_expression_set_target_type (_tmp169_, _tmp171_);
	_tmp172_ = local;
	_tmp173_ = vala_symbol_get_name ((ValaSymbol*) _tmp172_);
	_tmp174_ = _tmp173_;
	_tmp175_ = vala_conditional_expression_get_true_expression (self);
	_tmp176_ = _tmp175_;
	_tmp177_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp176_);
	_tmp178_ = _tmp177_;
	_tmp179_ = vala_member_access_new_simple (_tmp174_, _tmp178_);
	_tmp180_ = _tmp179_;
	_tmp181_ = vala_conditional_expression_get_true_expression (self);
	_tmp182_ = _tmp181_;
	_tmp183_ = vala_conditional_expression_get_true_expression (self);
	_tmp184_ = _tmp183_;
	_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp184_);
	_tmp186_ = _tmp185_;
	_tmp187_ = vala_assignment_new ((ValaExpression*) _tmp180_, _tmp182_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp186_);
	_tmp188_ = _tmp187_;
	_tmp189_ = vala_conditional_expression_get_true_expression (self);
	_tmp190_ = _tmp189_;
	_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp190_);
	_tmp192_ = _tmp191_;
	_tmp193_ = vala_expression_statement_new ((ValaExpression*) _tmp188_, _tmp192_);
	_tmp194_ = _tmp193_;
	_vala_code_node_unref0 (_tmp188_);
	_vala_code_node_unref0 (_tmp180_);
	true_stmt = _tmp194_;
	_tmp195_ = true_stmt;
	_tmp196_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp195_, _tmp196_);
	_tmp197_ = local;
	_tmp198_ = vala_symbol_get_name ((ValaSymbol*) _tmp197_);
	_tmp199_ = _tmp198_;
	_tmp200_ = vala_conditional_expression_get_false_expression (self);
	_tmp201_ = _tmp200_;
	_tmp202_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp201_);
	_tmp203_ = _tmp202_;
	_tmp204_ = vala_member_access_new_simple (_tmp199_, _tmp203_);
	_tmp205_ = _tmp204_;
	_tmp206_ = vala_conditional_expression_get_false_expression (self);
	_tmp207_ = _tmp206_;
	_tmp208_ = vala_conditional_expression_get_false_expression (self);
	_tmp209_ = _tmp208_;
	_tmp210_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp209_);
	_tmp211_ = _tmp210_;
	_tmp212_ = vala_assignment_new ((ValaExpression*) _tmp205_, _tmp207_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp211_);
	_tmp213_ = _tmp212_;
	_tmp214_ = vala_conditional_expression_get_false_expression (self);
	_tmp215_ = _tmp214_;
	_tmp216_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp215_);
	_tmp217_ = _tmp216_;
	_tmp218_ = vala_expression_statement_new ((ValaExpression*) _tmp213_, _tmp217_);
	_tmp219_ = _tmp218_;
	_vala_code_node_unref0 (_tmp213_);
	_vala_code_node_unref0 (_tmp205_);
	false_stmt = _tmp219_;
	_tmp220_ = false_stmt;
	_tmp221_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp220_, _tmp221_);
	_tmp222_ = true_block;
	_tmp223_ = true_decl;
	_tmp224_ = true_stmt;
	vala_block_replace_statement (_tmp222_, (ValaStatement*) _tmp223_, (ValaStatement*) _tmp224_);
	_tmp225_ = false_block;
	_tmp226_ = false_decl;
	_tmp227_ = false_stmt;
	vala_block_replace_statement (_tmp225_, (ValaStatement*) _tmp226_, (ValaStatement*) _tmp227_);
	_tmp228_ = local;
	_tmp229_ = vala_symbol_get_name ((ValaSymbol*) _tmp228_);
	_tmp230_ = _tmp229_;
	_tmp231_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp232_ = _tmp231_;
	_tmp233_ = vala_member_access_new_simple (_tmp230_, _tmp232_);
	ma = _tmp233_;
	_tmp234_ = ma;
	_tmp235_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
	_tmp236_ = _tmp235_;
	vala_expression_set_formal_target_type ((ValaExpression*) _tmp234_, _tmp236_);
	_tmp237_ = ma;
	_tmp238_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp239_ = _tmp238_;
	vala_expression_set_target_type ((ValaExpression*) _tmp237_, _tmp239_);
	_tmp240_ = ma;
	_tmp241_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp240_, _tmp241_);
	_tmp242_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp243_ = _tmp242_;
	_tmp244_ = ma;
	vala_code_node_replace_expression (_tmp243_, (ValaExpression*) self, (ValaExpression*) _tmp244_);
	result = TRUE;
	_vala_code_node_unref0 (ma);
	_vala_code_node_unref0 (false_stmt);
	_vala_code_node_unref0 (true_stmt);
	_vala_code_node_unref0 (if_stmt);
	_vala_code_node_unref0 (false_decl);
	_vala_code_node_unref0 (false_block);
	_vala_code_node_unref0 (false_local);
	_vala_code_node_unref0 (true_decl);
	_vala_code_node_unref0 (true_block);
	_vala_code_node_unref0 (true_local);
	_vala_code_node_unref0 (decl);
	_vala_code_node_unref0 (local);
	_g_free0 (temp_name);
	return result;
}


ValaExpression* vala_conditional_expression_get_condition (ValaConditionalExpression* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_condition;
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_conditional_expression_set_condition (ValaConditionalExpression* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_condition);
	self->priv->_condition = _tmp1_;
	_tmp2_ = self->priv->_condition;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaExpression* vala_conditional_expression_get_true_expression (ValaConditionalExpression* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_true_expression;
	result = _tmp0_;
	return result;
}


void vala_conditional_expression_set_true_expression (ValaConditionalExpression* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_true_expression);
	self->priv->_true_expression = _tmp1_;
	_tmp2_ = self->priv->_true_expression;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaExpression* vala_conditional_expression_get_false_expression (ValaConditionalExpression* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_false_expression;
	result = _tmp0_;
	return result;
}


void vala_conditional_expression_set_false_expression (ValaConditionalExpression* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_false_expression);
	self->priv->_false_expression = _tmp1_;
	_tmp2_ = self->priv->_false_expression;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


static void vala_conditional_expression_class_init (ValaConditionalExpressionClass * klass) {
	vala_conditional_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_conditional_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaConditionalExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_conditional_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_conditional_expression_real_accept_children;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_conditional_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_conditional_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_conditional_expression_real_check;
}


static void vala_conditional_expression_instance_init (ValaConditionalExpression * self) {
	self->priv = VALA_CONDITIONAL_EXPRESSION_GET_PRIVATE (self);
}


static void vala_conditional_expression_finalize (ValaCodeNode * obj) {
	ValaConditionalExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpression);
	_vala_code_node_unref0 (self->priv->_condition);
	_vala_code_node_unref0 (self->priv->_true_expression);
	_vala_code_node_unref0 (self->priv->_false_expression);
	VALA_CODE_NODE_CLASS (vala_conditional_expression_parent_class)->finalize (obj);
}


/**
 * Represents a conditional expression in the source code.
 */
GType vala_conditional_expression_get_type (void) {
	static volatile gsize vala_conditional_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_conditional_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaConditionalExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_conditional_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaConditionalExpression), 0, (GInstanceInitFunc) vala_conditional_expression_instance_init, NULL };
		GType vala_conditional_expression_type_id;
		vala_conditional_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaConditionalExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_conditional_expression_type_id__volatile, vala_conditional_expression_type_id);
	}
	return vala_conditional_expression_type_id__volatile;
}



