/* valareturnstatement.c generated by valac, the Vala compiler
 * generated from valareturnstatement.vala, do not modify */

/* valareturnstatement.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_RETURN_STATEMENT_DUMMY_PROPERTY,
	VALA_RETURN_STATEMENT_LAST_PROPERTY
};
static GParamSpec* vala_return_statement_properties[VALA_RETURN_STATEMENT_LAST_PROPERTY];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaReturnStatementPrivate {
	ValaExpression* _return_expression;
};


static gpointer vala_return_statement_parent_class = NULL;
static ValaStatementIface * vala_return_statement_vala_statement_parent_iface = NULL;

#define VALA_RETURN_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementPrivate))
static void vala_return_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_return_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_return_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_return_statement_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_return_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_return_statement_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_return_statement_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_return_statement_finalize (ValaCodeNode * obj);


/**
 * Creates a new return statement.
 *
 * @param return_expression the return expression
 * @param source_reference  reference to source code
 * @return                  newly created return statement
 */
ValaReturnStatement* vala_return_statement_construct (GType object_type, ValaExpression* return_expression, ValaSourceReference* source_reference) {
	ValaReturnStatement* self = NULL;
	ValaSourceReference* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaReturnStatement*) vala_code_node_construct (object_type);
	_tmp0_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp0_);
	_tmp1_ = return_expression;
	vala_return_statement_set_return_expression (self, _tmp1_);
	return self;
}


ValaReturnStatement* vala_return_statement_new (ValaExpression* return_expression, ValaSourceReference* source_reference) {
	return vala_return_statement_construct (VALA_TYPE_RETURN_STATEMENT, return_expression, source_reference);
}


static void vala_return_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaReturnStatement * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_return_statement (_tmp0_, self);
}


static void vala_return_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaReturnStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_return_statement_get_return_expression (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaCodeVisitor* _tmp4_;
		ValaCodeVisitor* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp2_ = vala_return_statement_get_return_expression (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, _tmp4_);
		_tmp5_ = visitor;
		_tmp6_ = vala_return_statement_get_return_expression (self);
		_tmp7_ = _tmp6_;
		vala_code_visitor_visit_end_full_expression (_tmp5_, _tmp7_);
	}
}


static void vala_return_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaReturnStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_return_statement_get_return_expression (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_;
		_tmp3_ = new_node;
		vala_return_statement_set_return_expression (self, _tmp3_);
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_return_statement_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaReturnStatement * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	gboolean _tmp13_ = FALSE;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	ValaCodeContext* _tmp20_;
	ValaSemanticAnalyzer* _tmp21_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaDataType* _tmp23_;
	ValaDataType* _tmp24_;
	ValaExpression* _tmp27_;
	ValaExpression* _tmp28_;
	ValaCodeContext* _tmp38_;
	ValaSemanticAnalyzer* _tmp39_;
	ValaSemanticAnalyzer* _tmp40_;
	ValaDataType* _tmp41_;
	ValaDataType* _tmp42_;
	ValaExpression* _tmp45_;
	ValaExpression* _tmp46_;
	ValaDataType* _tmp47_;
	ValaDataType* _tmp48_;
	ValaExpression* _tmp51_;
	ValaExpression* _tmp52_;
	ValaDataType* _tmp53_;
	ValaDataType* _tmp54_;
	ValaCodeContext* _tmp55_;
	ValaSemanticAnalyzer* _tmp56_;
	ValaSemanticAnalyzer* _tmp57_;
	ValaDataType* _tmp58_;
	ValaDataType* _tmp59_;
	gboolean _tmp60_;
	gboolean _tmp78_ = FALSE;
	ValaExpression* _tmp79_;
	ValaExpression* _tmp80_;
	ValaDataType* _tmp81_;
	ValaDataType* _tmp82_;
	gboolean _tmp83_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp93_;
	ValaExpression* _tmp94_;
	ValaSymbol* _tmp95_;
	ValaSymbol* _tmp96_;
	ValaLocalVariable* _tmp97_;
	gboolean _tmp98_ = FALSE;
	gboolean _tmp99_ = FALSE;
	ValaLocalVariable* _tmp100_;
	gboolean _tmp114_ = FALSE;
	ValaExpression* _tmp115_;
	ValaExpression* _tmp116_;
	ValaExpression* _tmp135_;
	ValaExpression* _tmp136_;
	ValaList* _tmp137_;
	ValaList* _tmp138_;
	gboolean _tmp139_;
	gboolean _tmp140_;
	self = (ValaReturnStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_return_statement_get_return_expression (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaCodeContext* _tmp8_;
		ValaSemanticAnalyzer* _tmp9_;
		ValaSemanticAnalyzer* _tmp10_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		_tmp6_ = vala_return_statement_get_return_expression (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = context;
		_tmp9_ = vala_code_context_get_analyzer (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_semantic_analyzer_get_current_return_type (_tmp10_);
		_tmp12_ = _tmp11_;
		vala_expression_set_target_type (_tmp7_, _tmp12_);
	}
	_tmp14_ = vala_return_statement_get_return_expression (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaCodeContext* _tmp18_;
		gboolean _tmp19_;
		_tmp16_ = vala_return_statement_get_return_expression (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = context;
		_tmp19_ = vala_code_node_check ((ValaCodeNode*) _tmp17_, _tmp18_);
		_tmp13_ = !_tmp19_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp20_ = context;
	_tmp21_ = vala_code_context_get_analyzer (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_semantic_analyzer_get_current_return_type (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_ == NULL) {
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp26_ = _tmp25_;
		vala_report_error (_tmp26_, "Return not allowed in this context");
		result = FALSE;
		return result;
	}
	_tmp27_ = vala_return_statement_get_return_expression (self);
	_tmp28_ = _tmp27_;
	if (_tmp28_ == NULL) {
		ValaCodeContext* _tmp29_;
		ValaSemanticAnalyzer* _tmp30_;
		ValaSemanticAnalyzer* _tmp31_;
		ValaDataType* _tmp32_;
		ValaDataType* _tmp33_;
		gboolean _tmp36_;
		gboolean _tmp37_;
		_tmp29_ = context;
		_tmp30_ = vala_code_context_get_analyzer (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_semantic_analyzer_get_current_return_type (_tmp31_);
		_tmp33_ = _tmp32_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_VOID_TYPE)) {
			ValaSourceReference* _tmp34_;
			ValaSourceReference* _tmp35_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp35_ = _tmp34_;
			vala_report_error (_tmp35_, "Return without value in non-void function");
		}
		_tmp36_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp37_ = _tmp36_;
		result = !_tmp37_;
		return result;
	}
	_tmp38_ = context;
	_tmp39_ = vala_code_context_get_analyzer (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = vala_semantic_analyzer_get_current_return_type (_tmp40_);
	_tmp42_ = _tmp41_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, VALA_TYPE_VOID_TYPE)) {
		ValaSourceReference* _tmp43_;
		ValaSourceReference* _tmp44_;
		_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp44_ = _tmp43_;
		vala_report_error (_tmp44_, "Return with value in void function");
		result = FALSE;
		return result;
	}
	_tmp45_ = vala_return_statement_get_return_expression (self);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_expression_get_value_type (_tmp46_);
	_tmp48_ = _tmp47_;
	if (_tmp48_ == NULL) {
		ValaSourceReference* _tmp49_;
		ValaSourceReference* _tmp50_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp50_ = _tmp49_;
		vala_report_error (_tmp50_, "Invalid expression in return value");
		result = FALSE;
		return result;
	}
	_tmp51_ = vala_return_statement_get_return_expression (self);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_expression_get_value_type (_tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = context;
	_tmp56_ = vala_code_context_get_analyzer (_tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_semantic_analyzer_get_current_return_type (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_data_type_compatible (_tmp54_, _tmp59_);
	if (!_tmp60_) {
		ValaSourceReference* _tmp61_;
		ValaSourceReference* _tmp62_;
		ValaExpression* _tmp63_;
		ValaExpression* _tmp64_;
		ValaDataType* _tmp65_;
		ValaDataType* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		ValaCodeContext* _tmp69_;
		ValaSemanticAnalyzer* _tmp70_;
		ValaSemanticAnalyzer* _tmp71_;
		ValaDataType* _tmp72_;
		ValaDataType* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_return_statement_get_return_expression (self);
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_expression_get_value_type (_tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = vala_code_node_to_string ((ValaCodeNode*) _tmp66_);
		_tmp68_ = _tmp67_;
		_tmp69_ = context;
		_tmp70_ = vala_code_context_get_analyzer (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_semantic_analyzer_get_current_return_type (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_code_node_to_string ((ValaCodeNode*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = g_strdup_printf ("Return: Cannot convert from `%s' to `%s'", _tmp68_, _tmp75_);
		_tmp77_ = _tmp76_;
		vala_report_error (_tmp62_, _tmp77_);
		_g_free0 (_tmp77_);
		_g_free0 (_tmp75_);
		_g_free0 (_tmp68_);
		result = FALSE;
		return result;
	}
	_tmp79_ = vala_return_statement_get_return_expression (self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_expression_get_value_type (_tmp80_);
	_tmp82_ = _tmp81_;
	_tmp83_ = vala_data_type_is_disposable (_tmp82_);
	if (_tmp83_) {
		ValaCodeContext* _tmp84_;
		ValaSemanticAnalyzer* _tmp85_;
		ValaSemanticAnalyzer* _tmp86_;
		ValaDataType* _tmp87_;
		ValaDataType* _tmp88_;
		gboolean _tmp89_;
		gboolean _tmp90_;
		_tmp84_ = context;
		_tmp85_ = vala_code_context_get_analyzer (_tmp84_);
		_tmp86_ = _tmp85_;
		_tmp87_ = vala_semantic_analyzer_get_current_return_type (_tmp86_);
		_tmp88_ = _tmp87_;
		_tmp89_ = vala_data_type_get_value_owned (_tmp88_);
		_tmp90_ = _tmp89_;
		_tmp78_ = !_tmp90_;
	} else {
		_tmp78_ = FALSE;
	}
	if (_tmp78_) {
		ValaSourceReference* _tmp91_;
		ValaSourceReference* _tmp92_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp91_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp92_ = _tmp91_;
		vala_report_error (_tmp92_, "Return value transfers ownership but method return type hasn't been de" \
"clared to transfer ownership");
		result = FALSE;
		return result;
	}
	_tmp93_ = vala_return_statement_get_return_expression (self);
	_tmp94_ = _tmp93_;
	_tmp95_ = vala_expression_get_symbol_reference (_tmp94_);
	_tmp96_ = _tmp95_;
	_tmp97_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp96_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp96_) : NULL);
	local = _tmp97_;
	_tmp100_ = local;
	if (_tmp100_ != NULL) {
		ValaLocalVariable* _tmp101_;
		ValaDataType* _tmp102_;
		ValaDataType* _tmp103_;
		gboolean _tmp104_;
		_tmp101_ = local;
		_tmp102_ = vala_variable_get_variable_type ((ValaVariable*) _tmp101_);
		_tmp103_ = _tmp102_;
		_tmp104_ = vala_data_type_is_disposable (_tmp103_);
		_tmp99_ = _tmp104_;
	} else {
		_tmp99_ = FALSE;
	}
	if (_tmp99_) {
		ValaCodeContext* _tmp105_;
		ValaSemanticAnalyzer* _tmp106_;
		ValaSemanticAnalyzer* _tmp107_;
		ValaDataType* _tmp108_;
		ValaDataType* _tmp109_;
		gboolean _tmp110_;
		gboolean _tmp111_;
		_tmp105_ = context;
		_tmp106_ = vala_code_context_get_analyzer (_tmp105_);
		_tmp107_ = _tmp106_;
		_tmp108_ = vala_semantic_analyzer_get_current_return_type (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = vala_data_type_get_value_owned (_tmp109_);
		_tmp111_ = _tmp110_;
		_tmp98_ = !_tmp111_;
	} else {
		_tmp98_ = FALSE;
	}
	if (_tmp98_) {
		ValaSourceReference* _tmp112_;
		ValaSourceReference* _tmp113_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp112_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp113_ = _tmp112_;
		vala_report_error (_tmp113_, "Local variable with strong reference used as return value and method r" \
"eturn type has not been declared to transfer ownership");
		result = FALSE;
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp115_ = vala_return_statement_get_return_expression (self);
	_tmp116_ = _tmp115_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp116_, VALA_TYPE_NULL_LITERAL)) {
		ValaCodeContext* _tmp117_;
		ValaSemanticAnalyzer* _tmp118_;
		ValaSemanticAnalyzer* _tmp119_;
		ValaDataType* _tmp120_;
		ValaDataType* _tmp121_;
		gboolean _tmp122_;
		gboolean _tmp123_;
		_tmp117_ = context;
		_tmp118_ = vala_code_context_get_analyzer (_tmp117_);
		_tmp119_ = _tmp118_;
		_tmp120_ = vala_semantic_analyzer_get_current_return_type (_tmp119_);
		_tmp121_ = _tmp120_;
		_tmp122_ = vala_data_type_get_nullable (_tmp121_);
		_tmp123_ = _tmp122_;
		_tmp114_ = !_tmp123_;
	} else {
		_tmp114_ = FALSE;
	}
	if (_tmp114_) {
		ValaSourceReference* _tmp124_;
		ValaSourceReference* _tmp125_;
		ValaCodeContext* _tmp126_;
		ValaSemanticAnalyzer* _tmp127_;
		ValaSemanticAnalyzer* _tmp128_;
		ValaDataType* _tmp129_;
		ValaDataType* _tmp130_;
		gchar* _tmp131_;
		gchar* _tmp132_;
		gchar* _tmp133_;
		gchar* _tmp134_;
		_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp125_ = _tmp124_;
		_tmp126_ = context;
		_tmp127_ = vala_code_context_get_analyzer (_tmp126_);
		_tmp128_ = _tmp127_;
		_tmp129_ = vala_semantic_analyzer_get_current_return_type (_tmp128_);
		_tmp130_ = _tmp129_;
		_tmp131_ = vala_code_node_to_string ((ValaCodeNode*) _tmp130_);
		_tmp132_ = _tmp131_;
		_tmp133_ = g_strdup_printf ("`null' incompatible with return type `%s`", _tmp132_);
		_tmp134_ = _tmp133_;
		vala_report_warning (_tmp125_, _tmp134_);
		_g_free0 (_tmp134_);
		_g_free0 (_tmp132_);
	}
	_tmp135_ = vala_return_statement_get_return_expression (self);
	_tmp136_ = _tmp135_;
	_tmp137_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp136_);
	_tmp138_ = _tmp137_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp138_);
	_vala_iterable_unref0 (_tmp138_);
	_tmp139_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp140_ = _tmp139_;
	result = !_tmp140_;
	_vala_code_node_unref0 (local);
	return result;
}


static void vala_return_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaReturnStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeGenerator* _tmp8_;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_return_statement_get_return_expression (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaCodeGenerator* _tmp4_;
		ValaCodeGenerator* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp2_ = vala_return_statement_get_return_expression (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = codegen;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, _tmp4_);
		_tmp5_ = codegen;
		_tmp6_ = vala_return_statement_get_return_expression (self);
		_tmp7_ = _tmp6_;
		vala_code_visitor_visit_end_full_expression ((ValaCodeVisitor*) _tmp5_, _tmp7_);
	}
	_tmp8_ = codegen;
	vala_code_visitor_visit_return_statement ((ValaCodeVisitor*) _tmp8_, self);
}


static void vala_return_statement_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaReturnStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_return_statement_get_return_expression (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaCollection* _tmp4_;
		_tmp2_ = vala_return_statement_get_return_expression (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = collection;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, _tmp4_);
	}
}


static void vala_return_statement_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaReturnStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaReturnStatement*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_return_statement_get_return_expression (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaCollection* _tmp4_;
		_tmp2_ = vala_return_statement_get_return_expression (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = collection;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, _tmp4_);
	}
}


ValaExpression* vala_return_statement_get_return_expression (ValaReturnStatement* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_return_expression;
	result = _tmp0_;
	return result;
}


void vala_return_statement_set_return_expression (ValaReturnStatement* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_return_expression);
	self->priv->_return_expression = _tmp1_;
	_tmp2_ = self->priv->_return_expression;
	if (_tmp2_ != NULL) {
		ValaExpression* _tmp3_;
		_tmp3_ = self->priv->_return_expression;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp3_, (ValaCodeNode*) self);
	}
}


static void vala_return_statement_class_init (ValaReturnStatementClass * klass) {
	vala_return_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_return_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaReturnStatementPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_return_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_return_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_return_statement_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_return_statement_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_return_statement_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_return_statement_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_return_statement_real_get_used_variables;
}


static void vala_return_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_return_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_return_statement_instance_init (ValaReturnStatement * self) {
	self->priv = VALA_RETURN_STATEMENT_GET_PRIVATE (self);
}


static void vala_return_statement_finalize (ValaCodeNode * obj) {
	ValaReturnStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_RETURN_STATEMENT, ValaReturnStatement);
	_vala_code_node_unref0 (self->priv->_return_expression);
	VALA_CODE_NODE_CLASS (vala_return_statement_parent_class)->finalize (obj);
}


/**
 * Represents a return statement in the source code.
 */
GType vala_return_statement_get_type (void) {
	static volatile gsize vala_return_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_return_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaReturnStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_return_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaReturnStatement), 0, (GInstanceInitFunc) vala_return_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_return_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_return_statement_type_id;
		vala_return_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaReturnStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_return_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		g_once_init_leave (&vala_return_statement_type_id__volatile, vala_return_statement_type_id);
	}
	return vala_return_statement_type_id__volatile;
}



