/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valacodegen.h>
#include <version.h>
#include <config.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gchar** vala_compiler_gresources;
static gchar** vala_compiler_gresources = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_thread;
static gboolean vala_compiler_thread = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;

gpointer vala_compiler_ref (gpointer instance);
void vala_compiler_unref (gpointer instance);
GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_compiler (GValue* value, gpointer v_object);
void vala_value_take_compiler (GValue* value, gpointer v_object);
gpointer vala_value_get_compiler (const GValue* value);
GType vala_compiler_get_type (void) G_GNUC_CONST;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
enum  {
	VALA_COMPILER_DUMMY_PROPERTY
};
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gint vala_compiler_run_source (gchar** args, int args_length1);
ValaCompiler* vala_compiler_new (void);
ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda3_ (Block1Data* _data1_, GPid pid, gint status);
static void ____lambda3__gchild_watch_func (GPid pid, gint status, gpointer self);
static gint vala_compiler_main (gchar** args, int args_length1);
static void vala_compiler_finalize (ValaCompiler* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[50] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Output directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_thread, "Enable multithreading support", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"gresources", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_gresources, "XML of gresources", "FILE..."}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static gint vala_compiler_quit (ValaCompiler* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_ = NULL;
	ValaReport* _tmp2_ = NULL;
	ValaReport* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp9_ = FALSE;
	ValaCodeContext* _tmp10_ = NULL;
	ValaReport* _tmp11_ = NULL;
	ValaReport* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_report_get_errors (_tmp3_);
	if (_tmp4_ == 0) {
		ValaCodeContext* _tmp5_ = NULL;
		ValaReport* _tmp6_ = NULL;
		ValaReport* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp5_ = self->priv->context;
		_tmp6_ = vala_code_context_get_report (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_report_get_warnings (_tmp7_);
		_tmp0_ = _tmp8_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp10_ = self->priv->context;
	_tmp11_ = vala_code_context_get_report (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_report_get_errors (_tmp12_);
	if (_tmp13_ == 0) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		_tmp15_ = vala_compiler_fatal_warnings;
		if (!_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			ValaCodeContext* _tmp16_ = NULL;
			ValaReport* _tmp17_ = NULL;
			ValaReport* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			_tmp16_ = self->priv->context;
			_tmp17_ = vala_code_context_get_report (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_report_get_warnings (_tmp18_);
			_tmp14_ = _tmp19_ == 0;
		}
		_tmp9_ = _tmp14_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean _tmp20_ = FALSE;
		_tmp20_ = vala_compiler_quiet_mode;
		if (!_tmp20_) {
			FILE* _tmp21_ = NULL;
			ValaCodeContext* _tmp22_ = NULL;
			ValaReport* _tmp23_ = NULL;
			ValaReport* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			_tmp21_ = stdout;
			_tmp22_ = self->priv->context;
			_tmp23_ = vala_code_context_get_report (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_report_get_warnings (_tmp24_);
			fprintf (_tmp21_, "Compilation succeeded - %d warning(s)\n", _tmp25_);
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp26_ = FALSE;
		_tmp26_ = vala_compiler_quiet_mode;
		if (!_tmp26_) {
			FILE* _tmp27_ = NULL;
			ValaCodeContext* _tmp28_ = NULL;
			ValaReport* _tmp29_ = NULL;
			ValaReport* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			ValaCodeContext* _tmp32_ = NULL;
			ValaReport* _tmp33_ = NULL;
			ValaReport* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			_tmp27_ = stdout;
			_tmp28_ = self->priv->context;
			_tmp29_ = vala_code_context_get_report (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_report_get_errors (_tmp30_);
			_tmp32_ = self->priv->context;
			_tmp33_ = vala_code_context_get_report (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_report_get_warnings (_tmp34_);
			fprintf (_tmp27_, "Compilation failed: %d error(s), %d warning(s)\n", _tmp31_, _tmp35_);
		}
		result = 1;
		return result;
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint vala_compiler_run (ValaCompiler* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	ValaCodeContext* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	ValaCodeContext* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	ValaCodeContext* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	ValaCodeContext* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	ValaCodeContext* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	ValaCodeContext* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	ValaCodeContext* _tmp31_ = NULL;
	ValaReport* _tmp32_ = NULL;
	ValaReport* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	ValaCodeContext* _tmp35_ = NULL;
	ValaReport* _tmp36_ = NULL;
	ValaReport* _tmp37_ = NULL;
	gboolean _tmp38_ = FALSE;
	ValaCodeContext* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	ValaCodeContext* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	ValaCodeContext* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	ValaCodeContext* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	ValaCodeContext* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	gboolean _tmp49_ = FALSE;
	const gchar* _tmp50_ = NULL;
	ValaCodeContext* _tmp52_ = NULL;
	gboolean _tmp53_ = FALSE;
	ValaCodeContext* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	ValaCodeContext* _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	ValaCodeContext* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	ValaCodeContext* _tmp60_ = NULL;
	const gchar* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	const gchar* _tmp70_ = NULL;
	ValaCodeContext* _tmp79_ = NULL;
	gchar** _tmp80_ = NULL;
	gint _tmp80__length1 = 0;
	gchar** _tmp81_ = NULL;
	gint _tmp81__length1 = 0;
	ValaCodeContext* _tmp82_ = NULL;
	gchar** _tmp83_ = NULL;
	gint _tmp83__length1 = 0;
	gchar** _tmp84_ = NULL;
	gint _tmp84__length1 = 0;
	ValaCodeContext* _tmp85_ = NULL;
	gchar** _tmp86_ = NULL;
	gint _tmp86__length1 = 0;
	gchar** _tmp87_ = NULL;
	gint _tmp87__length1 = 0;
	ValaCodeContext* _tmp88_ = NULL;
	gboolean _tmp89_ = FALSE;
	ValaCodeContext* _tmp90_ = NULL;
	gboolean _tmp91_ = FALSE;
	ValaCodeContext* _tmp92_ = NULL;
	gboolean _tmp93_ = FALSE;
	ValaCodeContext* _tmp94_ = NULL;
	gboolean _tmp95_ = FALSE;
	gboolean _tmp96_ = FALSE;
	gboolean _tmp97_ = FALSE;
	const gchar* _tmp98_ = NULL;
	gboolean _tmp106_ = FALSE;
	const gchar* _tmp107_ = NULL;
	ValaCodeContext* _tmp108_ = NULL;
	gboolean _tmp109_ = FALSE;
	ValaCodeContext* _tmp110_ = NULL;
	const gchar* _tmp111_ = NULL;
	ValaCodeContext* _tmp112_ = NULL;
	gboolean _tmp113_ = FALSE;
	gchar** _tmp114_ = NULL;
	gint _tmp114__length1 = 0;
	gint glib_major = 0;
	gint glib_minor = 0;
	gboolean _tmp126_ = FALSE;
	const gchar* _tmp127_ = NULL;
	ValaCodeContext* _tmp130_ = NULL;
	gint _tmp131_ = 0;
	ValaCodeContext* _tmp132_ = NULL;
	gint _tmp133_ = 0;
	ValaCodeContext* _tmp134_ = NULL;
	gint _tmp135_ = 0;
	gint _tmp136_ = 0;
	gboolean _tmp145_ = FALSE;
	gchar** _tmp148_ = NULL;
	gint _tmp148__length1 = 0;
	gchar** _tmp153_ = NULL;
	gint _tmp153__length1 = 0;
	ValaCodeContext* _tmp164_ = NULL;
	gchar** _tmp165_ = NULL;
	gint _tmp165__length1 = 0;
	gchar** _tmp166_ = NULL;
	gint _tmp166__length1 = 0;
	gboolean _tmp167_ = FALSE;
	ValaCodeContext* _tmp168_ = NULL;
	ValaReport* _tmp169_ = NULL;
	ValaReport* _tmp170_ = NULL;
	gint _tmp171_ = 0;
	ValaCodeContext* _tmp179_ = NULL;
	ValaGDBusServerModule* _tmp180_ = NULL;
	ValaGDBusServerModule* _tmp181_ = NULL;
	gboolean has_c_files = FALSE;
	gchar** _tmp182_ = NULL;
	gint _tmp182__length1 = 0;
	gboolean _tmp190_ = FALSE;
	ValaCodeContext* _tmp191_ = NULL;
	ValaReport* _tmp192_ = NULL;
	ValaReport* _tmp193_ = NULL;
	gint _tmp194_ = 0;
	ValaParser* parser = NULL;
	ValaParser* _tmp202_ = NULL;
	ValaParser* _tmp203_ = NULL;
	ValaCodeContext* _tmp204_ = NULL;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp205_ = NULL;
	ValaGenieParser* _tmp206_ = NULL;
	ValaCodeContext* _tmp207_ = NULL;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp208_ = NULL;
	ValaGirParser* _tmp209_ = NULL;
	ValaCodeContext* _tmp210_ = NULL;
	gboolean _tmp211_ = FALSE;
	ValaCodeContext* _tmp212_ = NULL;
	ValaReport* _tmp213_ = NULL;
	ValaReport* _tmp214_ = NULL;
	gint _tmp215_ = 0;
	const gchar* _tmp223_ = NULL;
	ValaCodeContext* _tmp229_ = NULL;
	gboolean _tmp230_ = FALSE;
	ValaCodeContext* _tmp231_ = NULL;
	ValaReport* _tmp232_ = NULL;
	ValaReport* _tmp233_ = NULL;
	gint _tmp234_ = 0;
	gboolean _tmp242_ = FALSE;
	gboolean _tmp243_ = FALSE;
	gboolean _tmp244_ = FALSE;
	const gchar* _tmp252_ = NULL;
	gboolean _tmp257_ = FALSE;
	ValaCodeContext* _tmp258_ = NULL;
	ValaReport* _tmp259_ = NULL;
	ValaReport* _tmp260_ = NULL;
	gint _tmp261_ = 0;
	ValaCodeContext* _tmp269_ = NULL;
	ValaCodeGenerator* _tmp270_ = NULL;
	ValaCodeGenerator* _tmp271_ = NULL;
	ValaCodeContext* _tmp272_ = NULL;
	gboolean _tmp273_ = FALSE;
	ValaCodeContext* _tmp274_ = NULL;
	ValaReport* _tmp275_ = NULL;
	ValaReport* _tmp276_ = NULL;
	gint _tmp277_ = 0;
	gboolean _tmp285_ = FALSE;
	const gchar* _tmp286_ = NULL;
	const gchar* _tmp290_ = NULL;
	const gchar* _tmp342_ = NULL;
	const gchar* _tmp356_ = NULL;
	const gchar* _tmp379_ = NULL;
	gboolean _tmp382_ = FALSE;
	gint _tmp399_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	_tmp4_ = vala_compiler_ccode_only;
	if (!_tmp4_) {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = vala_compiler_compile_only;
		_tmp3_ = !_tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = vala_compiler_output;
		_tmp2_ = _tmp6_ == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		_tmp7_ = vala_compiler_sources;
		_tmp7__length1 = _vala_array_length (vala_compiler_sources);
		_tmp8_ = _tmp7_[0];
		_tmp9_ = string_last_index_of_char (_tmp8_, (gunichar) '.', 0);
		if (_tmp9_ != (-1)) {
			gint dot = 0;
			gchar** _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			const gchar* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gchar** _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			const gchar* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			_tmp10_ = vala_compiler_sources;
			_tmp10__length1 = _vala_array_length (vala_compiler_sources);
			_tmp11_ = _tmp10_[0];
			_tmp12_ = string_last_index_of_char (_tmp11_, (gunichar) '.', 0);
			dot = _tmp12_;
			_tmp13_ = vala_compiler_sources;
			_tmp13__length1 = _vala_array_length (vala_compiler_sources);
			_tmp14_ = _tmp13_[0];
			_tmp15_ = dot;
			_tmp16_ = string_substring (_tmp14_, (glong) 0, (glong) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_path_get_basename (_tmp17_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp18_;
			_g_free0 (_tmp17_);
		}
	}
	_tmp19_ = self->priv->context;
	_tmp20_ = vala_compiler_disable_assert;
	vala_code_context_set_assert (_tmp19_, !_tmp20_);
	_tmp21_ = self->priv->context;
	_tmp22_ = vala_compiler_enable_checking;
	vala_code_context_set_checking (_tmp21_, _tmp22_);
	_tmp23_ = self->priv->context;
	_tmp24_ = vala_compiler_deprecated;
	vala_code_context_set_deprecated (_tmp23_, _tmp24_);
	_tmp25_ = self->priv->context;
	_tmp26_ = vala_compiler_experimental;
	vala_code_context_set_experimental (_tmp25_, _tmp26_);
	_tmp27_ = self->priv->context;
	_tmp28_ = vala_compiler_experimental_non_null;
	vala_code_context_set_experimental_non_null (_tmp27_, _tmp28_);
	_tmp29_ = self->priv->context;
	_tmp30_ = vala_compiler_gobject_tracing;
	vala_code_context_set_gobject_tracing (_tmp29_, _tmp30_);
	_tmp31_ = self->priv->context;
	_tmp32_ = vala_code_context_get_report (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_compiler_disable_warnings;
	vala_report_set_enable_warnings (_tmp33_, !_tmp34_);
	_tmp35_ = self->priv->context;
	_tmp36_ = vala_code_context_get_report (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_compiler_quiet_mode;
	vala_report_set_verbose_errors (_tmp37_, !_tmp38_);
	_tmp39_ = self->priv->context;
	_tmp40_ = vala_compiler_verbose_mode;
	vala_code_context_set_verbose_mode (_tmp39_, _tmp40_);
	_tmp41_ = self->priv->context;
	_tmp42_ = vala_compiler_disable_version_header;
	vala_code_context_set_version_header (_tmp41_, !_tmp42_);
	_tmp43_ = self->priv->context;
	_tmp44_ = vala_compiler_ccode_only;
	vala_code_context_set_ccode_only (_tmp43_, _tmp44_);
	_tmp45_ = self->priv->context;
	_tmp46_ = vala_compiler_compile_only;
	vala_code_context_set_compile_only (_tmp45_, _tmp46_);
	_tmp47_ = self->priv->context;
	_tmp48_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp47_, _tmp48_);
	_tmp50_ = vala_compiler_header_filename;
	if (_tmp50_ == NULL) {
		gboolean _tmp51_ = FALSE;
		_tmp51_ = vala_compiler_use_header;
		_tmp49_ = _tmp51_;
	} else {
		_tmp49_ = FALSE;
	}
	if (_tmp49_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp52_ = self->priv->context;
	_tmp53_ = vala_compiler_use_header;
	vala_code_context_set_use_header (_tmp52_, _tmp53_);
	_tmp54_ = self->priv->context;
	_tmp55_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp54_, _tmp55_);
	_tmp56_ = self->priv->context;
	_tmp57_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp56_, _tmp57_);
	_tmp58_ = self->priv->context;
	_tmp59_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp58_, _tmp59_);
	_tmp60_ = self->priv->context;
	_tmp61_ = vala_compiler_output;
	vala_code_context_set_output (_tmp60_, _tmp61_);
	_tmp62_ = vala_compiler_basedir;
	if (_tmp62_ == NULL) {
		ValaCodeContext* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		gchar* _tmp65_ = NULL;
		_tmp63_ = self->priv->context;
		_tmp64_ = vala_code_context_realpath (".");
		_tmp65_ = _tmp64_;
		vala_code_context_set_basedir (_tmp63_, _tmp65_);
		_g_free0 (_tmp65_);
	} else {
		ValaCodeContext* _tmp66_ = NULL;
		const gchar* _tmp67_ = NULL;
		gchar* _tmp68_ = NULL;
		gchar* _tmp69_ = NULL;
		_tmp66_ = self->priv->context;
		_tmp67_ = vala_compiler_basedir;
		_tmp68_ = vala_code_context_realpath (_tmp67_);
		_tmp69_ = _tmp68_;
		vala_code_context_set_basedir (_tmp66_, _tmp69_);
		_g_free0 (_tmp69_);
	}
	_tmp70_ = vala_compiler_directory;
	if (_tmp70_ != NULL) {
		ValaCodeContext* _tmp71_ = NULL;
		const gchar* _tmp72_ = NULL;
		gchar* _tmp73_ = NULL;
		gchar* _tmp74_ = NULL;
		_tmp71_ = self->priv->context;
		_tmp72_ = vala_compiler_directory;
		_tmp73_ = vala_code_context_realpath (_tmp72_);
		_tmp74_ = _tmp73_;
		vala_code_context_set_directory (_tmp71_, _tmp74_);
		_g_free0 (_tmp74_);
	} else {
		ValaCodeContext* _tmp75_ = NULL;
		ValaCodeContext* _tmp76_ = NULL;
		const gchar* _tmp77_ = NULL;
		const gchar* _tmp78_ = NULL;
		_tmp75_ = self->priv->context;
		_tmp76_ = self->priv->context;
		_tmp77_ = vala_code_context_get_basedir (_tmp76_);
		_tmp78_ = _tmp77_;
		vala_code_context_set_directory (_tmp75_, _tmp78_);
	}
	_tmp79_ = self->priv->context;
	_tmp80_ = vala_compiler_vapi_directories;
	_tmp80__length1 = _vala_array_length (vala_compiler_vapi_directories);
	_tmp81_ = (_tmp80_ != NULL) ? _vala_array_dup1 (_tmp80_, _tmp80__length1) : ((gpointer) _tmp80_);
	_tmp81__length1 = _tmp80__length1;
	_tmp79_->vapi_directories = (_vala_array_free (_tmp79_->vapi_directories, _tmp79_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp79_->vapi_directories = _tmp81_;
	_tmp79_->vapi_directories_length1 = _tmp81__length1;
	_tmp82_ = self->priv->context;
	_tmp83_ = vala_compiler_gir_directories;
	_tmp83__length1 = _vala_array_length (vala_compiler_gir_directories);
	_tmp84_ = (_tmp83_ != NULL) ? _vala_array_dup2 (_tmp83_, _tmp83__length1) : ((gpointer) _tmp83_);
	_tmp84__length1 = _tmp83__length1;
	_tmp82_->gir_directories = (_vala_array_free (_tmp82_->gir_directories, _tmp82_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp82_->gir_directories = _tmp84_;
	_tmp82_->gir_directories_length1 = _tmp84__length1;
	_tmp85_ = self->priv->context;
	_tmp86_ = vala_compiler_metadata_directories;
	_tmp86__length1 = _vala_array_length (vala_compiler_metadata_directories);
	_tmp87_ = (_tmp86_ != NULL) ? _vala_array_dup3 (_tmp86_, _tmp86__length1) : ((gpointer) _tmp86_);
	_tmp87__length1 = _tmp86__length1;
	_tmp85_->metadata_directories = (_vala_array_free (_tmp85_->metadata_directories, _tmp85_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp85_->metadata_directories = _tmp87_;
	_tmp85_->metadata_directories_length1 = _tmp87__length1;
	_tmp88_ = self->priv->context;
	_tmp89_ = vala_compiler_debug;
	vala_code_context_set_debug (_tmp88_, _tmp89_);
	_tmp90_ = self->priv->context;
	_tmp91_ = vala_compiler_thread;
	vala_code_context_set_thread (_tmp90_, _tmp91_);
	_tmp92_ = self->priv->context;
	_tmp93_ = vala_compiler_mem_profiler;
	vala_code_context_set_mem_profiler (_tmp92_, _tmp93_);
	_tmp94_ = self->priv->context;
	_tmp95_ = vala_compiler_save_temps;
	vala_code_context_set_save_temps (_tmp94_, _tmp95_);
	_tmp98_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp98_, "gobject-2.0") == 0) {
		_tmp97_ = TRUE;
	} else {
		const gchar* _tmp99_ = NULL;
		_tmp99_ = vala_compiler_profile;
		_tmp97_ = g_strcmp0 (_tmp99_, "gobject") == 0;
	}
	if (_tmp97_) {
		_tmp96_ = TRUE;
	} else {
		const gchar* _tmp100_ = NULL;
		_tmp100_ = vala_compiler_profile;
		_tmp96_ = _tmp100_ == NULL;
	}
	if (_tmp96_) {
		ValaCodeContext* _tmp101_ = NULL;
		ValaCodeContext* _tmp102_ = NULL;
		_tmp101_ = self->priv->context;
		vala_code_context_set_profile (_tmp101_, VALA_PROFILE_GOBJECT);
		_tmp102_ = self->priv->context;
		vala_code_context_add_define (_tmp102_, "GOBJECT");
	} else {
		const gchar* _tmp103_ = NULL;
		gchar* _tmp104_ = NULL;
		gchar* _tmp105_ = NULL;
		_tmp103_ = vala_compiler_profile;
		_tmp104_ = g_strdup_printf ("Unknown profile %s", _tmp103_);
		_tmp105_ = _tmp104_;
		vala_report_error (NULL, _tmp105_);
		_g_free0 (_tmp105_);
	}
	_tmp106_ = vala_compiler_nostdpkg;
	_tmp107_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = _tmp106_ | (_tmp107_ != NULL);
	_tmp108_ = self->priv->context;
	_tmp109_ = vala_compiler_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp108_, _tmp109_);
	_tmp110_ = self->priv->context;
	_tmp111_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp110_, _tmp111_);
	_tmp112_ = self->priv->context;
	_tmp113_ = vala_compiler_run_output;
	vala_code_context_set_run_output (_tmp112_, _tmp113_);
	_tmp114_ = vala_compiler_defines;
	_tmp114__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp114_ != NULL) {
		gchar** _tmp115_ = NULL;
		gint _tmp115__length1 = 0;
		_tmp115_ = vala_compiler_defines;
		_tmp115__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp115_;
			define_collection_length1 = _tmp115__length1;
			for (define_it = 0; define_it < _tmp115__length1; define_it = define_it + 1) {
				gchar* _tmp116_ = NULL;
				gchar* define = NULL;
				_tmp116_ = g_strdup (define_collection[define_it]);
				define = _tmp116_;
				{
					ValaCodeContext* _tmp117_ = NULL;
					const gchar* _tmp118_ = NULL;
					_tmp117_ = self->priv->context;
					_tmp118_ = define;
					vala_code_context_add_define (_tmp117_, _tmp118_);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp119_ = FALSE;
			_tmp119_ = TRUE;
			while (TRUE) {
				gint _tmp121_ = 0;
				ValaCodeContext* _tmp122_ = NULL;
				gint _tmp123_ = 0;
				gchar* _tmp124_ = NULL;
				gchar* _tmp125_ = NULL;
				if (!_tmp119_) {
					gint _tmp120_ = 0;
					_tmp120_ = i;
					i = _tmp120_ + 2;
				}
				_tmp119_ = FALSE;
				_tmp121_ = i;
				if (!(_tmp121_ <= 24)) {
					break;
				}
				_tmp122_ = self->priv->context;
				_tmp123_ = i;
				_tmp124_ = g_strdup_printf ("VALA_0_%d", _tmp123_);
				_tmp125_ = _tmp124_;
				vala_code_context_add_define (_tmp122_, _tmp125_);
				_g_free0 (_tmp125_);
			}
		}
	}
	glib_major = 2;
	glib_minor = 18;
	_tmp127_ = vala_compiler_target_glib;
	if (_tmp127_ != NULL) {
		const gchar* _tmp128_ = NULL;
		gint _tmp129_ = 0;
		_tmp128_ = vala_compiler_target_glib;
		_tmp129_ = sscanf (_tmp128_, "%d.%d", &glib_major, &glib_minor);
		_tmp126_ = _tmp129_ != 2;
	} else {
		_tmp126_ = FALSE;
	}
	if (_tmp126_) {
		vala_report_error (NULL, "Invalid format for --target-glib");
	}
	_tmp130_ = self->priv->context;
	_tmp131_ = glib_major;
	vala_code_context_set_target_glib_major (_tmp130_, _tmp131_);
	_tmp132_ = self->priv->context;
	_tmp133_ = glib_minor;
	vala_code_context_set_target_glib_minor (_tmp132_, _tmp133_);
	_tmp134_ = self->priv->context;
	_tmp135_ = vala_code_context_get_target_glib_major (_tmp134_);
	_tmp136_ = _tmp135_;
	if (_tmp136_ != 2) {
		vala_report_error (NULL, "This version of valac only supports GLib 2");
	}
	{
		gint i = 0;
		i = 16;
		{
			gboolean _tmp137_ = FALSE;
			_tmp137_ = TRUE;
			while (TRUE) {
				gint _tmp139_ = 0;
				gint _tmp140_ = 0;
				ValaCodeContext* _tmp141_ = NULL;
				gint _tmp142_ = 0;
				gchar* _tmp143_ = NULL;
				gchar* _tmp144_ = NULL;
				if (!_tmp137_) {
					gint _tmp138_ = 0;
					_tmp138_ = i;
					i = _tmp138_ + 2;
				}
				_tmp137_ = FALSE;
				_tmp139_ = i;
				_tmp140_ = glib_minor;
				if (!(_tmp139_ <= _tmp140_)) {
					break;
				}
				_tmp141_ = self->priv->context;
				_tmp142_ = i;
				_tmp143_ = g_strdup_printf ("GLIB_2_%d", _tmp142_);
				_tmp144_ = _tmp143_;
				vala_code_context_add_define (_tmp141_, _tmp144_);
				_g_free0 (_tmp144_);
			}
		}
	}
	_tmp145_ = vala_compiler_nostdpkg;
	if (!_tmp145_) {
		ValaCodeContext* _tmp146_ = NULL;
		ValaCodeContext* _tmp147_ = NULL;
		_tmp146_ = self->priv->context;
		vala_code_context_add_external_package (_tmp146_, "glib-2.0");
		_tmp147_ = self->priv->context;
		vala_code_context_add_external_package (_tmp147_, "gobject-2.0");
	}
	_tmp148_ = vala_compiler_packages;
	_tmp148__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp148_ != NULL) {
		gchar** _tmp149_ = NULL;
		gint _tmp149__length1 = 0;
		_tmp149_ = vala_compiler_packages;
		_tmp149__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp149_;
			package_collection_length1 = _tmp149__length1;
			for (package_it = 0; package_it < _tmp149__length1; package_it = package_it + 1) {
				gchar* _tmp150_ = NULL;
				gchar* package = NULL;
				_tmp150_ = g_strdup (package_collection[package_it]);
				package = _tmp150_;
				{
					ValaCodeContext* _tmp151_ = NULL;
					const gchar* _tmp152_ = NULL;
					_tmp151_ = self->priv->context;
					_tmp152_ = package;
					vala_code_context_add_external_package (_tmp151_, _tmp152_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp153_ = vala_compiler_fast_vapis;
	_tmp153__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp153_ != NULL) {
		gchar** _tmp154_ = NULL;
		gint _tmp154__length1 = 0;
		ValaCodeContext* _tmp163_ = NULL;
		_tmp154_ = vala_compiler_fast_vapis;
		_tmp154__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp154_;
			vapi_collection_length1 = _tmp154__length1;
			for (vapi_it = 0; vapi_it < _tmp154__length1; vapi_it = vapi_it + 1) {
				gchar* _tmp155_ = NULL;
				gchar* vapi = NULL;
				_tmp155_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp155_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp156_ = NULL;
					gchar* _tmp157_ = NULL;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp158_ = NULL;
					const gchar* _tmp159_ = NULL;
					ValaSourceFile* _tmp160_ = NULL;
					ValaCodeContext* _tmp161_ = NULL;
					ValaSourceFile* _tmp162_ = NULL;
					_tmp156_ = vapi;
					_tmp157_ = vala_code_context_realpath (_tmp156_);
					rpath = _tmp157_;
					_tmp158_ = self->priv->context;
					_tmp159_ = rpath;
					_tmp160_ = vala_source_file_new (_tmp158_, VALA_SOURCE_FILE_TYPE_FAST, _tmp159_, NULL, FALSE);
					source_file = _tmp160_;
					_tmp161_ = self->priv->context;
					_tmp162_ = source_file;
					vala_code_context_add_source_file (_tmp161_, _tmp162_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp163_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp163_, TRUE);
	}
	_tmp164_ = self->priv->context;
	_tmp165_ = vala_compiler_gresources;
	_tmp165__length1 = _vala_array_length (vala_compiler_gresources);
	_tmp166_ = (_tmp165_ != NULL) ? _vala_array_dup4 (_tmp165_, _tmp165__length1) : ((gpointer) _tmp165_);
	_tmp166__length1 = _tmp165__length1;
	_tmp164_->gresources = (_vala_array_free (_tmp164_->gresources, _tmp164_->gresources_length1, (GDestroyNotify) g_free), NULL);
	_tmp164_->gresources = _tmp166_;
	_tmp164_->gresources_length1 = _tmp166__length1;
	_tmp168_ = self->priv->context;
	_tmp169_ = vala_code_context_get_report (_tmp168_);
	_tmp170_ = _tmp169_;
	_tmp171_ = vala_report_get_errors (_tmp170_);
	if (_tmp171_ > 0) {
		_tmp167_ = TRUE;
	} else {
		gboolean _tmp172_ = FALSE;
		gboolean _tmp173_ = FALSE;
		_tmp173_ = vala_compiler_fatal_warnings;
		if (_tmp173_) {
			ValaCodeContext* _tmp174_ = NULL;
			ValaReport* _tmp175_ = NULL;
			ValaReport* _tmp176_ = NULL;
			gint _tmp177_ = 0;
			_tmp174_ = self->priv->context;
			_tmp175_ = vala_code_context_get_report (_tmp174_);
			_tmp176_ = _tmp175_;
			_tmp177_ = vala_report_get_warnings (_tmp176_);
			_tmp172_ = _tmp177_ > 0;
		} else {
			_tmp172_ = FALSE;
		}
		_tmp167_ = _tmp172_;
	}
	if (_tmp167_) {
		gint _tmp178_ = 0;
		_tmp178_ = vala_compiler_quit (self);
		result = _tmp178_;
		return result;
	}
	_tmp179_ = self->priv->context;
	_tmp180_ = vala_gd_bus_server_module_new ();
	_tmp181_ = _tmp180_;
	vala_code_context_set_codegen (_tmp179_, (ValaCodeGenerator*) _tmp181_);
	_vala_code_visitor_unref0 (_tmp181_);
	has_c_files = FALSE;
	_tmp182_ = vala_compiler_sources;
	_tmp182__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp182_;
		source_collection_length1 = _tmp182__length1;
		for (source_it = 0; source_it < _tmp182__length1; source_it = source_it + 1) {
			gchar* _tmp183_ = NULL;
			gchar* source = NULL;
			_tmp183_ = g_strdup (source_collection[source_it]);
			source = _tmp183_;
			{
				ValaCodeContext* _tmp184_ = NULL;
				const gchar* _tmp185_ = NULL;
				gboolean _tmp186_ = FALSE;
				gboolean _tmp187_ = FALSE;
				_tmp184_ = self->priv->context;
				_tmp185_ = source;
				_tmp186_ = vala_compiler_run_output;
				_tmp187_ = vala_code_context_add_source_filename (_tmp184_, _tmp185_, _tmp186_, TRUE);
				if (_tmp187_) {
					const gchar* _tmp188_ = NULL;
					gboolean _tmp189_ = FALSE;
					_tmp188_ = source;
					_tmp189_ = g_str_has_suffix (_tmp188_, ".c");
					if (_tmp189_) {
						has_c_files = TRUE;
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	_tmp191_ = self->priv->context;
	_tmp192_ = vala_code_context_get_report (_tmp191_);
	_tmp193_ = _tmp192_;
	_tmp194_ = vala_report_get_errors (_tmp193_);
	if (_tmp194_ > 0) {
		_tmp190_ = TRUE;
	} else {
		gboolean _tmp195_ = FALSE;
		gboolean _tmp196_ = FALSE;
		_tmp196_ = vala_compiler_fatal_warnings;
		if (_tmp196_) {
			ValaCodeContext* _tmp197_ = NULL;
			ValaReport* _tmp198_ = NULL;
			ValaReport* _tmp199_ = NULL;
			gint _tmp200_ = 0;
			_tmp197_ = self->priv->context;
			_tmp198_ = vala_code_context_get_report (_tmp197_);
			_tmp199_ = _tmp198_;
			_tmp200_ = vala_report_get_warnings (_tmp199_);
			_tmp195_ = _tmp200_ > 0;
		} else {
			_tmp195_ = FALSE;
		}
		_tmp190_ = _tmp195_;
	}
	if (_tmp190_) {
		gint _tmp201_ = 0;
		_tmp201_ = vala_compiler_quit (self);
		result = _tmp201_;
		return result;
	}
	_tmp202_ = vala_parser_new ();
	parser = _tmp202_;
	_tmp203_ = parser;
	_tmp204_ = self->priv->context;
	vala_parser_parse (_tmp203_, _tmp204_);
	_tmp205_ = vala_genie_parser_new ();
	genie_parser = _tmp205_;
	_tmp206_ = genie_parser;
	_tmp207_ = self->priv->context;
	vala_genie_parser_parse (_tmp206_, _tmp207_);
	_tmp208_ = vala_gir_parser_new ();
	gir_parser = _tmp208_;
	_tmp209_ = gir_parser;
	_tmp210_ = self->priv->context;
	vala_gir_parser_parse (_tmp209_, _tmp210_);
	_tmp212_ = self->priv->context;
	_tmp213_ = vala_code_context_get_report (_tmp212_);
	_tmp214_ = _tmp213_;
	_tmp215_ = vala_report_get_errors (_tmp214_);
	if (_tmp215_ > 0) {
		_tmp211_ = TRUE;
	} else {
		gboolean _tmp216_ = FALSE;
		gboolean _tmp217_ = FALSE;
		_tmp217_ = vala_compiler_fatal_warnings;
		if (_tmp217_) {
			ValaCodeContext* _tmp218_ = NULL;
			ValaReport* _tmp219_ = NULL;
			ValaReport* _tmp220_ = NULL;
			gint _tmp221_ = 0;
			_tmp218_ = self->priv->context;
			_tmp219_ = vala_code_context_get_report (_tmp218_);
			_tmp220_ = _tmp219_;
			_tmp221_ = vala_report_get_warnings (_tmp220_);
			_tmp216_ = _tmp221_ > 0;
		} else {
			_tmp216_ = FALSE;
		}
		_tmp211_ = _tmp216_;
	}
	if (_tmp211_) {
		gint _tmp222_ = 0;
		_tmp222_ = vala_compiler_quit (self);
		result = _tmp222_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp223_ = vala_compiler_fast_vapi_filename;
	if (_tmp223_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp224_ = NULL;
		ValaCodeWriter* _tmp225_ = NULL;
		ValaCodeContext* _tmp226_ = NULL;
		const gchar* _tmp227_ = NULL;
		gint _tmp228_ = 0;
		_tmp224_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp224_;
		_tmp225_ = interface_writer;
		_tmp226_ = self->priv->context;
		_tmp227_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp225_, _tmp226_, _tmp227_);
		_tmp228_ = vala_compiler_quit (self);
		result = _tmp228_;
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp229_ = self->priv->context;
	vala_code_context_check (_tmp229_);
	_tmp231_ = self->priv->context;
	_tmp232_ = vala_code_context_get_report (_tmp231_);
	_tmp233_ = _tmp232_;
	_tmp234_ = vala_report_get_errors (_tmp233_);
	if (_tmp234_ > 0) {
		_tmp230_ = TRUE;
	} else {
		gboolean _tmp235_ = FALSE;
		gboolean _tmp236_ = FALSE;
		_tmp236_ = vala_compiler_fatal_warnings;
		if (_tmp236_) {
			ValaCodeContext* _tmp237_ = NULL;
			ValaReport* _tmp238_ = NULL;
			ValaReport* _tmp239_ = NULL;
			gint _tmp240_ = 0;
			_tmp237_ = self->priv->context;
			_tmp238_ = vala_code_context_get_report (_tmp237_);
			_tmp239_ = _tmp238_;
			_tmp240_ = vala_report_get_warnings (_tmp239_);
			_tmp235_ = _tmp240_ > 0;
		} else {
			_tmp235_ = FALSE;
		}
		_tmp230_ = _tmp235_;
	}
	if (_tmp230_) {
		gint _tmp241_ = 0;
		_tmp241_ = vala_compiler_quit (self);
		result = _tmp241_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp244_ = vala_compiler_ccode_only;
	if (!_tmp244_) {
		gboolean _tmp245_ = FALSE;
		_tmp245_ = vala_compiler_compile_only;
		_tmp243_ = !_tmp245_;
	} else {
		_tmp243_ = FALSE;
	}
	if (_tmp243_) {
		const gchar* _tmp246_ = NULL;
		_tmp246_ = vala_compiler_library;
		_tmp242_ = _tmp246_ == NULL;
	} else {
		_tmp242_ = FALSE;
	}
	if (_tmp242_) {
		gboolean _tmp247_ = FALSE;
		gboolean _tmp248_ = FALSE;
		_tmp248_ = has_c_files;
		if (!_tmp248_) {
			ValaCodeContext* _tmp249_ = NULL;
			ValaMethod* _tmp250_ = NULL;
			ValaMethod* _tmp251_ = NULL;
			_tmp249_ = self->priv->context;
			_tmp250_ = vala_code_context_get_entry_point (_tmp249_);
			_tmp251_ = _tmp250_;
			_tmp247_ = _tmp251_ == NULL;
		} else {
			_tmp247_ = FALSE;
		}
		if (_tmp247_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp252_ = vala_compiler_dump_tree;
	if (_tmp252_ != NULL) {
		ValaCodeWriter* code_writer = NULL;
		ValaCodeWriter* _tmp253_ = NULL;
		ValaCodeWriter* _tmp254_ = NULL;
		ValaCodeContext* _tmp255_ = NULL;
		const gchar* _tmp256_ = NULL;
		_tmp253_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp253_;
		_tmp254_ = code_writer;
		_tmp255_ = self->priv->context;
		_tmp256_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp254_, _tmp255_, _tmp256_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp258_ = self->priv->context;
	_tmp259_ = vala_code_context_get_report (_tmp258_);
	_tmp260_ = _tmp259_;
	_tmp261_ = vala_report_get_errors (_tmp260_);
	if (_tmp261_ > 0) {
		_tmp257_ = TRUE;
	} else {
		gboolean _tmp262_ = FALSE;
		gboolean _tmp263_ = FALSE;
		_tmp263_ = vala_compiler_fatal_warnings;
		if (_tmp263_) {
			ValaCodeContext* _tmp264_ = NULL;
			ValaReport* _tmp265_ = NULL;
			ValaReport* _tmp266_ = NULL;
			gint _tmp267_ = 0;
			_tmp264_ = self->priv->context;
			_tmp265_ = vala_code_context_get_report (_tmp264_);
			_tmp266_ = _tmp265_;
			_tmp267_ = vala_report_get_warnings (_tmp266_);
			_tmp262_ = _tmp267_ > 0;
		} else {
			_tmp262_ = FALSE;
		}
		_tmp257_ = _tmp262_;
	}
	if (_tmp257_) {
		gint _tmp268_ = 0;
		_tmp268_ = vala_compiler_quit (self);
		result = _tmp268_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp269_ = self->priv->context;
	_tmp270_ = vala_code_context_get_codegen (_tmp269_);
	_tmp271_ = _tmp270_;
	_tmp272_ = self->priv->context;
	vala_code_generator_emit (_tmp271_, _tmp272_);
	_tmp274_ = self->priv->context;
	_tmp275_ = vala_code_context_get_report (_tmp274_);
	_tmp276_ = _tmp275_;
	_tmp277_ = vala_report_get_errors (_tmp276_);
	if (_tmp277_ > 0) {
		_tmp273_ = TRUE;
	} else {
		gboolean _tmp278_ = FALSE;
		gboolean _tmp279_ = FALSE;
		_tmp279_ = vala_compiler_fatal_warnings;
		if (_tmp279_) {
			ValaCodeContext* _tmp280_ = NULL;
			ValaReport* _tmp281_ = NULL;
			ValaReport* _tmp282_ = NULL;
			gint _tmp283_ = 0;
			_tmp280_ = self->priv->context;
			_tmp281_ = vala_code_context_get_report (_tmp280_);
			_tmp282_ = _tmp281_;
			_tmp283_ = vala_report_get_warnings (_tmp282_);
			_tmp278_ = _tmp283_ > 0;
		} else {
			_tmp278_ = FALSE;
		}
		_tmp273_ = _tmp278_;
	}
	if (_tmp273_) {
		gint _tmp284_ = 0;
		_tmp284_ = vala_compiler_quit (self);
		result = _tmp284_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp286_ = vala_compiler_vapi_filename;
	if (_tmp286_ == NULL) {
		const gchar* _tmp287_ = NULL;
		_tmp287_ = vala_compiler_library;
		_tmp285_ = _tmp287_ != NULL;
	} else {
		_tmp285_ = FALSE;
	}
	if (_tmp285_) {
		const gchar* _tmp288_ = NULL;
		gchar* _tmp289_ = NULL;
		_tmp288_ = vala_compiler_library;
		_tmp289_ = g_strdup_printf ("%s.vapi", _tmp288_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp289_;
	}
	_tmp290_ = vala_compiler_library;
	if (_tmp290_ != NULL) {
		const gchar* _tmp291_ = NULL;
		_tmp291_ = vala_compiler_gir;
		if (_tmp291_ != NULL) {
			gchar* gir_base = NULL;
			const gchar* _tmp292_ = NULL;
			gchar* _tmp293_ = NULL;
			glong gir_len = 0L;
			const gchar* _tmp294_ = NULL;
			gint _tmp295_ = 0;
			gint _tmp296_ = 0;
			gint last_hyphen = 0;
			const gchar* _tmp297_ = NULL;
			gint _tmp298_ = 0;
			gboolean _tmp299_ = FALSE;
			gint _tmp300_ = 0;
			_tmp292_ = vala_compiler_gir;
			_tmp293_ = g_path_get_basename (_tmp292_);
			gir_base = _tmp293_;
			_tmp294_ = gir_base;
			_tmp295_ = strlen (_tmp294_);
			_tmp296_ = _tmp295_;
			gir_len = (glong) _tmp296_;
			_tmp297_ = gir_base;
			_tmp298_ = string_last_index_of_char (_tmp297_, (gunichar) '-', 0);
			last_hyphen = _tmp298_;
			_tmp300_ = last_hyphen;
			if (_tmp300_ == (-1)) {
				_tmp299_ = TRUE;
			} else {
				const gchar* _tmp301_ = NULL;
				gboolean _tmp302_ = FALSE;
				_tmp301_ = gir_base;
				_tmp302_ = g_str_has_suffix (_tmp301_, ".gir");
				_tmp299_ = !_tmp302_;
			}
			if (_tmp299_) {
				const gchar* _tmp303_ = NULL;
				gchar* _tmp304_ = NULL;
				gchar* _tmp305_ = NULL;
				_tmp303_ = vala_compiler_gir;
				_tmp304_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp303_);
				_tmp305_ = _tmp304_;
				vala_report_error (NULL, _tmp305_);
				_g_free0 (_tmp305_);
			} else {
				gchar* gir_namespace = NULL;
				const gchar* _tmp306_ = NULL;
				gint _tmp307_ = 0;
				gchar* _tmp308_ = NULL;
				gchar* gir_version = NULL;
				const gchar* _tmp309_ = NULL;
				gint _tmp310_ = 0;
				glong _tmp311_ = 0L;
				gint _tmp312_ = 0;
				gchar* _tmp313_ = NULL;
				const gchar* _tmp314_ = NULL;
				gboolean _tmp315_ = FALSE;
				gboolean _tmp316_ = FALSE;
				gboolean _tmp317_ = FALSE;
				const gchar* _tmp318_ = NULL;
				_tmp306_ = gir_base;
				_tmp307_ = last_hyphen;
				_tmp308_ = string_substring (_tmp306_, (glong) 0, (glong) _tmp307_);
				gir_namespace = _tmp308_;
				_tmp309_ = gir_base;
				_tmp310_ = last_hyphen;
				_tmp311_ = gir_len;
				_tmp312_ = last_hyphen;
				_tmp313_ = string_substring (_tmp309_, (glong) (_tmp310_ + 1), (_tmp311_ - _tmp312_) - 5);
				gir_version = _tmp313_;
				_tmp314_ = gir_version;
				g_strcanon (_tmp314_, "0123456789.", '?');
				_tmp318_ = gir_namespace;
				if (g_strcmp0 (_tmp318_, "") == 0) {
					_tmp317_ = TRUE;
				} else {
					const gchar* _tmp319_ = NULL;
					_tmp319_ = gir_version;
					_tmp317_ = g_strcmp0 (_tmp319_, "") == 0;
				}
				if (_tmp317_) {
					_tmp316_ = TRUE;
				} else {
					const gchar* _tmp320_ = NULL;
					gchar _tmp321_ = '\0';
					gboolean _tmp322_ = FALSE;
					_tmp320_ = gir_version;
					_tmp321_ = string_get (_tmp320_, (glong) 0);
					_tmp322_ = g_ascii_isdigit (_tmp321_);
					_tmp316_ = !_tmp322_;
				}
				if (_tmp316_) {
					_tmp315_ = TRUE;
				} else {
					const gchar* _tmp323_ = NULL;
					gboolean _tmp324_ = FALSE;
					_tmp323_ = gir_version;
					_tmp324_ = string_contains (_tmp323_, "?");
					_tmp315_ = _tmp324_;
				}
				if (_tmp315_) {
					const gchar* _tmp325_ = NULL;
					gchar* _tmp326_ = NULL;
					gchar* _tmp327_ = NULL;
					_tmp325_ = vala_compiler_gir;
					_tmp326_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp325_);
					_tmp327_ = _tmp326_;
					vala_report_error (NULL, _tmp327_);
					_g_free0 (_tmp327_);
				} else {
					ValaGIRWriter* gir_writer = NULL;
					ValaGIRWriter* _tmp328_ = NULL;
					gchar* gir_directory = NULL;
					gchar* _tmp329_ = NULL;
					const gchar* _tmp330_ = NULL;
					ValaGIRWriter* _tmp335_ = NULL;
					ValaCodeContext* _tmp336_ = NULL;
					const gchar* _tmp337_ = NULL;
					const gchar* _tmp338_ = NULL;
					const gchar* _tmp339_ = NULL;
					const gchar* _tmp340_ = NULL;
					const gchar* _tmp341_ = NULL;
					_tmp328_ = vala_gir_writer_new ();
					gir_writer = _tmp328_;
					_tmp329_ = g_strdup (".");
					gir_directory = _tmp329_;
					_tmp330_ = vala_compiler_directory;
					if (_tmp330_ != NULL) {
						ValaCodeContext* _tmp331_ = NULL;
						const gchar* _tmp332_ = NULL;
						const gchar* _tmp333_ = NULL;
						gchar* _tmp334_ = NULL;
						_tmp331_ = self->priv->context;
						_tmp332_ = vala_code_context_get_directory (_tmp331_);
						_tmp333_ = _tmp332_;
						_tmp334_ = g_strdup (_tmp333_);
						_g_free0 (gir_directory);
						gir_directory = _tmp334_;
					}
					_tmp335_ = gir_writer;
					_tmp336_ = self->priv->context;
					_tmp337_ = gir_directory;
					_tmp338_ = vala_compiler_gir;
					_tmp339_ = gir_namespace;
					_tmp340_ = gir_version;
					_tmp341_ = vala_compiler_library;
					vala_gir_writer_write_file (_tmp335_, _tmp336_, _tmp337_, _tmp338_, _tmp339_, _tmp340_, _tmp341_);
					_g_free0 (gir_directory);
					_vala_code_visitor_unref0 (gir_writer);
				}
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
			_g_free0 (gir_base);
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	}
	_tmp342_ = vala_compiler_vapi_filename;
	if (_tmp342_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp343_ = NULL;
		gboolean _tmp344_ = FALSE;
		const gchar* _tmp345_ = NULL;
		ValaCodeWriter* _tmp353_ = NULL;
		ValaCodeContext* _tmp354_ = NULL;
		const gchar* _tmp355_ = NULL;
		_tmp343_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp343_;
		_tmp345_ = vala_compiler_directory;
		if (_tmp345_ != NULL) {
			const gchar* _tmp346_ = NULL;
			gboolean _tmp347_ = FALSE;
			_tmp346_ = vala_compiler_vapi_filename;
			_tmp347_ = g_path_is_absolute (_tmp346_);
			_tmp344_ = !_tmp347_;
		} else {
			_tmp344_ = FALSE;
		}
		if (_tmp344_) {
			ValaCodeContext* _tmp348_ = NULL;
			const gchar* _tmp349_ = NULL;
			const gchar* _tmp350_ = NULL;
			const gchar* _tmp351_ = NULL;
			gchar* _tmp352_ = NULL;
			_tmp348_ = self->priv->context;
			_tmp349_ = vala_code_context_get_directory (_tmp348_);
			_tmp350_ = _tmp349_;
			_tmp351_ = vala_compiler_vapi_filename;
			_tmp352_ = g_strdup_printf ("%s%c%s", _tmp350_, (gint) G_DIR_SEPARATOR, _tmp351_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp352_;
		}
		_tmp353_ = interface_writer;
		_tmp354_ = self->priv->context;
		_tmp355_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp353_, _tmp354_, _tmp355_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp356_ = vala_compiler_internal_vapi_filename;
	if (_tmp356_ != NULL) {
		gboolean _tmp357_ = FALSE;
		const gchar* _tmp358_ = NULL;
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp361_ = NULL;
		ValaCodeWriter* _tmp362_ = NULL;
		const gchar* _tmp363_ = NULL;
		const gchar* _tmp364_ = NULL;
		gchar* vapi_filename = NULL;
		const gchar* _tmp365_ = NULL;
		gchar* _tmp366_ = NULL;
		gboolean _tmp367_ = FALSE;
		const gchar* _tmp368_ = NULL;
		ValaCodeWriter* _tmp376_ = NULL;
		ValaCodeContext* _tmp377_ = NULL;
		const gchar* _tmp378_ = NULL;
		_tmp358_ = vala_compiler_internal_header_filename;
		if (_tmp358_ == NULL) {
			_tmp357_ = TRUE;
		} else {
			const gchar* _tmp359_ = NULL;
			_tmp359_ = vala_compiler_header_filename;
			_tmp357_ = _tmp359_ == NULL;
		}
		if (_tmp357_) {
			gint _tmp360_ = 0;
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			_tmp360_ = vala_compiler_quit (self);
			result = _tmp360_;
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp361_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp361_;
		_tmp362_ = interface_writer;
		_tmp363_ = vala_compiler_header_filename;
		_tmp364_ = vala_compiler_internal_header_filename;
		vala_code_writer_set_cheader_override (_tmp362_, _tmp363_, _tmp364_);
		_tmp365_ = vala_compiler_internal_vapi_filename;
		_tmp366_ = g_strdup (_tmp365_);
		vapi_filename = _tmp366_;
		_tmp368_ = vala_compiler_directory;
		if (_tmp368_ != NULL) {
			const gchar* _tmp369_ = NULL;
			gboolean _tmp370_ = FALSE;
			_tmp369_ = vapi_filename;
			_tmp370_ = g_path_is_absolute (_tmp369_);
			_tmp367_ = !_tmp370_;
		} else {
			_tmp367_ = FALSE;
		}
		if (_tmp367_) {
			ValaCodeContext* _tmp371_ = NULL;
			const gchar* _tmp372_ = NULL;
			const gchar* _tmp373_ = NULL;
			const gchar* _tmp374_ = NULL;
			gchar* _tmp375_ = NULL;
			_tmp371_ = self->priv->context;
			_tmp372_ = vala_code_context_get_directory (_tmp371_);
			_tmp373_ = _tmp372_;
			_tmp374_ = vapi_filename;
			_tmp375_ = g_strdup_printf ("%s%c%s", _tmp373_, (gint) G_DIR_SEPARATOR, _tmp374_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp375_;
		}
		_tmp376_ = interface_writer;
		_tmp377_ = self->priv->context;
		_tmp378_ = vapi_filename;
		vala_code_writer_write_file (_tmp376_, _tmp377_, _tmp378_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp379_ = vala_compiler_dependencies;
	if (_tmp379_ != NULL) {
		ValaCodeContext* _tmp380_ = NULL;
		const gchar* _tmp381_ = NULL;
		_tmp380_ = self->priv->context;
		_tmp381_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp380_, _tmp381_);
	}
	_tmp382_ = vala_compiler_ccode_only;
	if (!_tmp382_) {
		ValaCCodeCompiler* ccompiler = NULL;
		ValaCCodeCompiler* _tmp383_ = NULL;
		gboolean _tmp384_ = FALSE;
		const gchar* _tmp385_ = NULL;
		gchar** _tmp389_ = NULL;
		gint _tmp389__length1 = 0;
		_tmp383_ = vala_ccode_compiler_new ();
		ccompiler = _tmp383_;
		_tmp385_ = vala_compiler_cc_command;
		if (_tmp385_ == NULL) {
			const gchar* _tmp386_ = NULL;
			_tmp386_ = g_getenv ("CC");
			_tmp384_ = _tmp386_ != NULL;
		} else {
			_tmp384_ = FALSE;
		}
		if (_tmp384_) {
			const gchar* _tmp387_ = NULL;
			gchar* _tmp388_ = NULL;
			_tmp387_ = g_getenv ("CC");
			_tmp388_ = g_strdup (_tmp387_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp388_;
		}
		_tmp389_ = vala_compiler_cc_options;
		_tmp389__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp389_ == NULL) {
			ValaCCodeCompiler* _tmp390_ = NULL;
			ValaCodeContext* _tmp391_ = NULL;
			const gchar* _tmp392_ = NULL;
			gchar** _tmp393_ = NULL;
			gchar** _tmp394_ = NULL;
			gint _tmp394__length1 = 0;
			_tmp390_ = ccompiler;
			_tmp391_ = self->priv->context;
			_tmp392_ = vala_compiler_cc_command;
			_tmp393_ = g_new0 (gchar*, 0 + 1);
			_tmp394_ = _tmp393_;
			_tmp394__length1 = 0;
			vala_ccode_compiler_compile (_tmp390_, _tmp391_, _tmp392_, _tmp394_, 0);
			_tmp394_ = (_vala_array_free (_tmp394_, _tmp394__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp395_ = NULL;
			ValaCodeContext* _tmp396_ = NULL;
			const gchar* _tmp397_ = NULL;
			gchar** _tmp398_ = NULL;
			gint _tmp398__length1 = 0;
			_tmp395_ = ccompiler;
			_tmp396_ = self->priv->context;
			_tmp397_ = vala_compiler_cc_command;
			_tmp398_ = vala_compiler_cc_options;
			_tmp398__length1 = _vala_array_length (vala_compiler_cc_options);
			vala_ccode_compiler_compile (_tmp395_, _tmp396_, _tmp397_, _tmp398_, _tmp398__length1);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	_tmp399_ = vala_compiler_quit (self);
	result = _tmp399_;
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda3_ (Block1Data* _data1_, GPid pid, gint status) {
	gint _tmp0_ = 0;
	GMainLoop* _tmp1_ = NULL;
	_tmp0_ = status;
	_data1_->child_status = (_tmp0_ & 0xff00) >> 8;
	_tmp1_ = _data1_->loop;
	g_main_loop_quit (_tmp1_);
}


static void ____lambda3__gchild_watch_func (GPid pid, gint status, gpointer self) {
	___lambda3_ (self, pid, status);
}


static gint vala_compiler_run_source (gchar** args, int args_length1) {
	gint result = 0;
	gint i = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp29_ = FALSE;
	gchar** _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	gint _tmp36_ = 0;
	const gchar* _tmp37_ = NULL;
	gchar** _tmp39_ = NULL;
	gint _tmp39__length1 = 0;
	gint _tmp40_ = 0;
	const gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar** _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	gchar** _tmp45_ = NULL;
	gint _tmp45__length1 = 0;
	gint _tmp46_ = 0;
	const gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gint outputfd = 0;
	const gchar* _tmp51_ = NULL;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp54_ = NULL;
	gint ret = 0;
	ValaCompiler* _tmp55_ = NULL;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	gint _tmp58_ = 0;
	const gchar* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gchar** target_args = NULL;
	const gchar* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	gchar** _tmp64_ = NULL;
	gint target_args_length1 = 0;
	gint _target_args_size_ = 0;
	GError * _inner_error_ = NULL;
	i = 1;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = i;
	_tmp3_ = _tmp1_[_tmp2_];
	if (_tmp3_ != NULL) {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gint _tmp5_ = 0;
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = args;
		_tmp4__length1 = args_length1;
		_tmp5_ = i;
		_tmp6_ = _tmp4_[_tmp5_];
		_tmp7_ = g_str_has_prefix (_tmp6_, "-");
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp28_ = 0;
		{
			gchar** compile_args = NULL;
			gint compile_args_length1 = 0;
			gint _compile_args_size_ = 0;
			gchar** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar** _tmp12_ = NULL;
			gint _tmp13_ = 0;
			GOptionContext* opt_context = NULL;
			GOptionContext* _tmp14_ = NULL;
			GOptionContext* _tmp15_ = NULL;
			GOptionContext* _tmp16_ = NULL;
			gchar** temp_args = NULL;
			gchar** _tmp17_ = NULL;
			gint _tmp17__length1 = 0;
			gint temp_args_length1 = 0;
			gint _temp_args_size_ = 0;
			GOptionContext* _tmp18_ = NULL;
			_tmp8_ = args;
			_tmp8__length1 = args_length1;
			_tmp9_ = _tmp8_[1];
			_tmp10_ = g_strconcat ("valac ", _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			g_shell_parse_argv (_tmp11_, &_tmp13_, &_tmp12_, &_inner_error_);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
			compile_args = _tmp12_;
			compile_args_length1 = _tmp13_;
			_compile_args_size_ = compile_args_length1;
			_g_free0 (_tmp11_);
			if (_inner_error_ != NULL) {
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_tmp14_ = g_option_context_new ("- Vala");
			opt_context = _tmp14_;
			_tmp15_ = opt_context;
			g_option_context_set_help_enabled (_tmp15_, TRUE);
			_tmp16_ = opt_context;
			g_option_context_add_main_entries (_tmp16_, VALA_COMPILER_options, NULL);
			_tmp17_ = compile_args;
			_tmp17__length1 = compile_args_length1;
			temp_args = _tmp17_;
			temp_args_length1 = _tmp17__length1;
			_temp_args_size_ = temp_args_length1;
			_tmp18_ = opt_context;
			g_option_context_parse (_tmp18_, &temp_args_length1, &temp_args, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_g_option_context_free0 (opt_context);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally0;
		__catch0_g_shell_error:
		{
			GError* e = NULL;
			FILE* _tmp19_ = NULL;
			GError* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp19_ = stdout;
			_tmp20_ = e;
			_tmp21_ = _tmp20_->message;
			fprintf (_tmp19_, "%s\n", _tmp21_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		goto __finally0;
		__catch0_g_option_error:
		{
			GError* e = NULL;
			FILE* _tmp22_ = NULL;
			GError* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			FILE* _tmp25_ = NULL;
			gchar** _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			const gchar* _tmp27_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp22_ = stdout;
			_tmp23_ = e;
			_tmp24_ = _tmp23_->message;
			fprintf (_tmp22_, "%s\n", _tmp24_);
			_tmp25_ = stdout;
			_tmp26_ = args;
			_tmp26__length1 = args_length1;
			_tmp27_ = _tmp26_[0];
			fprintf (_tmp25_, "Run '%s --help' to see a full list of available command line options.\n", _tmp27_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp28_ = i;
		i = _tmp28_ + 1;
	}
	_tmp29_ = vala_compiler_version;
	if (_tmp29_) {
		FILE* _tmp30_ = NULL;
		_tmp30_ = stdout;
		fprintf (_tmp30_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp31_ = FALSE;
		_tmp31_ = vala_compiler_api_version;
		if (_tmp31_) {
			FILE* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			_tmp32_ = stdout;
			_tmp33_ = string_substring (PACKAGE_SUFFIX, (glong) 1, (glong) (-1));
			_tmp34_ = _tmp33_;
			fprintf (_tmp32_, "%s\n", _tmp34_);
			_g_free0 (_tmp34_);
			result = 0;
			return result;
		}
	}
	_tmp35_ = args;
	_tmp35__length1 = args_length1;
	_tmp36_ = i;
	_tmp37_ = _tmp35_[_tmp36_];
	if (_tmp37_ == NULL) {
		FILE* _tmp38_ = NULL;
		_tmp38_ = stderr;
		fprintf (_tmp38_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp39_ = args;
	_tmp39__length1 = args_length1;
	_tmp40_ = i;
	_tmp41_ = _tmp39_[_tmp40_];
	_tmp42_ = g_strdup (_tmp41_);
	_tmp43_ = g_new0 (gchar*, 1 + 1);
	_tmp43_[0] = _tmp42_;
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = _tmp43_;
	_tmp44_ = g_get_tmp_dir ();
	_tmp45_ = args;
	_tmp45__length1 = args_length1;
	_tmp46_ = i;
	_tmp47_ = _tmp45_[_tmp46_];
	_tmp48_ = g_path_get_basename (_tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp44_, _tmp49_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp50_;
	_g_free0 (_tmp49_);
	_tmp51_ = vala_compiler_output;
	_tmp52_ = g_mkstemp (_tmp51_);
	outputfd = _tmp52_;
	_tmp53_ = outputfd;
	if (_tmp53_ < 0) {
		result = 1;
		return result;
	}
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_tmp54_ = vala_compiler_new ();
	compiler = _tmp54_;
	_tmp55_ = compiler;
	_tmp56_ = vala_compiler_run (_tmp55_);
	ret = _tmp56_;
	_tmp57_ = ret;
	if (_tmp57_ != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp58_ = outputfd;
	close (_tmp58_);
	_tmp59_ = vala_compiler_output;
	_tmp60_ = g_chmod (_tmp59_, 0700);
	if (_tmp60_ != 0) {
		const gchar* _tmp61_ = NULL;
		_tmp61_ = vala_compiler_output;
		g_unlink (_tmp61_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp62_ = vala_compiler_output;
	_tmp63_ = g_strdup (_tmp62_);
	_tmp64_ = g_new0 (gchar*, 1 + 1);
	_tmp64_[0] = _tmp63_;
	target_args = _tmp64_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	while (TRUE) {
		gint _tmp65_ = 0;
		gchar** _tmp66_ = NULL;
		gint _tmp66__length1 = 0;
		gchar** _tmp67_ = NULL;
		gint _tmp67__length1 = 0;
		gchar** _tmp68_ = NULL;
		gint _tmp68__length1 = 0;
		gint _tmp69_ = 0;
		const gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		gint _tmp72_ = 0;
		_tmp65_ = i;
		_tmp66_ = args;
		_tmp66__length1 = args_length1;
		if (!(_tmp65_ < _tmp66__length1)) {
			break;
		}
		_tmp67_ = target_args;
		_tmp67__length1 = target_args_length1;
		_tmp68_ = args;
		_tmp68__length1 = args_length1;
		_tmp69_ = i;
		_tmp70_ = _tmp68_[_tmp69_];
		_tmp71_ = g_strdup (_tmp70_);
		_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp71_);
		_tmp72_ = i;
		i = _tmp72_ + 1;
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp73_ = NULL;
		gchar** _tmp74_ = NULL;
		gint _tmp74__length1 = 0;
		GPid _tmp75_ = 0;
		const gchar* _tmp76_ = NULL;
		GPid _tmp77_ = 0;
		GMainLoop* _tmp78_ = NULL;
		gint _tmp79_ = 0;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp73_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp73_;
		_data1_->child_status = 0;
		_tmp74_ = target_args;
		_tmp74__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp74_, NULL, (G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_FILE_AND_ARGV_ZERO, NULL, NULL, &_tmp75_, &_inner_error_);
		pid = _tmp75_;
		if (_inner_error_ != NULL) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp76_ = vala_compiler_output;
		g_unlink (_tmp76_);
		_tmp77_ = pid;
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp77_, ____lambda3__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp78_ = _data1_->loop;
		g_main_loop_run (_tmp78_);
		_tmp79_ = _data1_->child_status;
		result = _tmp79_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp80_ = NULL;
		GError* _tmp81_ = NULL;
		const gchar* _tmp82_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp80_ = stdout;
		_tmp81_ = e;
		_tmp82_ = _tmp81_->message;
		fprintf (_tmp80_, "%s\n", _tmp82_);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


static gint vala_compiler_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp32_ = NULL;
	ValaCompiler* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_path_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "vala") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = g_path_get_basename (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = g_strcmp0 (_tmp9_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp9_);
	}
	if (_tmp0_) {
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		gint _tmp11_ = 0;
		_tmp10_ = args;
		_tmp10__length1 = args_length1;
		_tmp11_ = vala_compiler_run_source (_tmp10_, _tmp10__length1);
		result = _tmp11_;
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp12_ = NULL;
		GOptionContext* _tmp13_ = NULL;
		GOptionContext* _tmp14_ = NULL;
		GOptionContext* _tmp15_ = NULL;
		_tmp12_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp12_;
		_tmp13_ = opt_context;
		g_option_context_set_help_enabled (_tmp13_, TRUE);
		_tmp14_ = opt_context;
		g_option_context_add_main_entries (_tmp14_, VALA_COMPILER_options, NULL);
		_tmp15_ = opt_context;
		g_option_context_parse (_tmp15_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		FILE* _tmp19_ = NULL;
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		const gchar* _tmp21_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = stdout;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		fprintf (_tmp16_, "%s\n", _tmp18_);
		_tmp19_ = stdout;
		_tmp20_ = args;
		_tmp20__length1 = args_length1;
		_tmp21_ = _tmp20_[0];
		fprintf (_tmp19_, "Run '%s --help' to see a full list of available command line options.\n", _tmp21_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp22_ = vala_compiler_version;
	if (_tmp22_) {
		FILE* _tmp23_ = NULL;
		_tmp23_ = stdout;
		fprintf (_tmp23_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp24_ = FALSE;
		_tmp24_ = vala_compiler_api_version;
		if (_tmp24_) {
			FILE* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			_tmp25_ = stdout;
			_tmp26_ = string_substring (PACKAGE_SUFFIX, (glong) 1, (glong) (-1));
			_tmp27_ = _tmp26_;
			fprintf (_tmp25_, "%s\n", _tmp27_);
			_g_free0 (_tmp27_);
			result = 0;
			return result;
		}
	}
	_tmp29_ = vala_compiler_sources;
	_tmp29__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp29_ == NULL) {
		gchar** _tmp30_ = NULL;
		gint _tmp30__length1 = 0;
		_tmp30_ = vala_compiler_fast_vapis;
		_tmp30__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp28_ = _tmp30_ == NULL;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		FILE* _tmp31_ = NULL;
		_tmp31_ = stderr;
		fprintf (_tmp31_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp32_ = vala_compiler_new ();
	compiler = _tmp32_;
	_tmp33_ = compiler;
	_tmp34_ = vala_compiler_run (_tmp33_);
	result = _tmp34_;
	_vala_compiler_unref0 (compiler);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return vala_compiler_main (argv, argc);
}


ValaCompiler* vala_compiler_construct (GType object_type) {
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCompiler* vala_compiler_new (void) {
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void vala_value_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCompiler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCompiler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


void vala_value_take_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void vala_compiler_class_init (ValaCompilerClass * klass) {
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	VALA_COMPILER_CLASS (klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void vala_compiler_instance_init (ValaCompiler * self) {
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_compiler_finalize (ValaCompiler* obj) {
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	_vala_code_context_unref0 (self->priv->context);
}


GType vala_compiler_get_type (void) {
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


gpointer vala_compiler_ref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_compiler_unref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



