if(DEFLATE_PREFER_STATIC_LIB)
    set(DEFLATE_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES ${CMAKE_FIND_LIBRARY_SUFFIXES})
    if(WIN32)
        set(CMAKE_FIND_LIBRARY_SUFFIXES .a .lib ${CMAKE_FIND_LIBRARY_SUFFIXES})
    else()
        set(CMAKE_FIND_LIBRARY_SUFFIXES .a ${CMAKE_FIND_LIBRARY_SUFFIXES})
    endif()
endif()

if(UNIX)
    find_package(PkgConfig QUIET)
    # pkg-config support added in libdeflate v1.9
    pkg_check_modules(_DEFLATE libdeflate>=${DEFLATE_MINIMUM})
endif()

find_path(DEFLATE_INCLUDE_DIR
    NAMES libdeflate.h
    HINTS ${_DEFLATE_INCLUDEDIR})
find_library(DEFLATE_LIBRARY
    NAMES deflate
    HINTS ${_DEFLATE_LIBDIR})

set(DEFLATE_INCLUDE_DIRS ${DEFLATE_INCLUDE_DIR})
set(DEFLATE_LIBRARIES ${DEFLATE_LIBRARY})
set(DEFLATE_VERSION ${_DEFLATE_VERSION})

include(FindPackageHandleStandardArgs)

find_package_handle_standard_args(DEFLATE
    REQUIRED_VARS
        DEFLATE_INCLUDE_DIR
        DEFLATE_LIBRARY
        DEFLATE_VERSION)

mark_as_advanced(DEFLATE_INCLUDE_DIR DEFLATE_LIBRARY)

if(DEFLATE_PREFER_STATIC_LIB)
    set(CMAKE_FIND_LIBRARY_SUFFIXES ${DEFLATE_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES})
    unset(DEFLATE_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES)
endif()
