#pragma once

/***
  This file is part of systemd.

  Copyright 2013 Holger Hans Peter Freyther

  systemd is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as published by
  the Free Software Foundation; either version 2.1 of the License, or
  (at your option) any later version.

  systemd is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with systemd; If not, see <http://www.gnu.org/licenses/>.
***/

#include "sd-daemon.h"

#include "macro.h"

#define TEST_REQ_RUNNING_SYSTEMD(x)                                 \
        if (sd_booted() > 0) {                                      \
                x;                                                  \
        } else {                                                    \
                printf("systemd not booted skipping '%s'\n", #x);   \
        }

#define MANAGER_SKIP_TEST(r)                                    \
        IN_SET(r,                                               \
               -EPERM,                                          \
               -EACCES,                                         \
               -EADDRINUSE,                                     \
               -EHOSTDOWN,                                      \
               -ENOENT,                                         \
               -ENOMEDIUM /* cannot determine cgroup */         \
               )

void enter_cgroup_subroot(void);
