/* dhparam.c: initial DH parameters for stunnel */
#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void)
{
    static unsigned char dhp_2048[] = {
        0x91, 0xC2, 0x73, 0x35, 0xC8, 0x30, 0xC4, 0xD8, 0xF4, 0xB5,
        0x3E, 0xCD, 0xC7, 0x3C, 0xD3, 0x5A, 0x4D, 0xBA, 0x5C, 0x38,
        0xB2, 0x7B, 0x5B, 0xCA, 0xFB, 0xF8, 0x9B, 0xC9, 0x98, 0x00,
        0x79, 0xDC, 0xA6, 0xFF, 0xE6, 0xB3, 0x61, 0x0E, 0xFB, 0x1B,
        0xC0, 0x95, 0xDE, 0xA4, 0xB6, 0x1B, 0xA6, 0x9B, 0x76, 0x8E,
        0x7B, 0x84, 0x03, 0xB7, 0x2F, 0x6A, 0x5D, 0x35, 0xE3, 0x04,
        0x1A, 0x14, 0x47, 0x27, 0xDC, 0x57, 0x74, 0x81, 0x1B, 0x91,
        0x42, 0x87, 0x34, 0xCE, 0x41, 0x96, 0xC8, 0x38, 0xB4, 0xBB,
        0x95, 0x41, 0x7A, 0x5F, 0x18, 0x1F, 0xA5, 0x2C, 0x3F, 0xAD,
        0xEA, 0xC7, 0xD7, 0x0C, 0x25, 0x13, 0xBA, 0x0A, 0x84, 0x57,
        0x7E, 0xD1, 0xE5, 0x9C, 0x0F, 0x62, 0xAA, 0x47, 0x94, 0x75,
        0xFA, 0x36, 0x0A, 0xF6, 0xEE, 0xFD, 0x95, 0x40, 0x36, 0x79,
        0xD0, 0x35, 0x7A, 0x6D, 0x46, 0xDA, 0xBD, 0xFA, 0xCF, 0xE2,
        0x01, 0xEC, 0x49, 0x43, 0x2A, 0x46, 0xC6, 0xA7, 0xBC, 0xC3,
        0x1A, 0xA7, 0x6F, 0x54, 0xA6, 0x10, 0x54, 0xDA, 0x5F, 0x21,
        0x95, 0x3F, 0xF4, 0x77, 0x99, 0x90, 0xE9, 0xD0, 0x0A, 0xB4,
        0x09, 0x10, 0xAC, 0xE7, 0x1D, 0x38, 0x21, 0x14, 0xF5, 0xC9,
        0xC9, 0xFA, 0xCA, 0xA7, 0x61, 0x1D, 0x13, 0xB5, 0x84, 0xA2,
        0x10, 0x6B, 0xF8, 0x85, 0xB1, 0x1C, 0x1C, 0x1A, 0x67, 0x98,
        0xDC, 0x67, 0xA4, 0xE8, 0x52, 0xC1, 0x05, 0xBA, 0x08, 0x9D,
        0xDD, 0xAC, 0x56, 0x72, 0x7B, 0x33, 0x25, 0x37, 0xCA, 0x85,
        0xAA, 0xB8, 0xB1, 0x60, 0x6D, 0x07, 0x1C, 0xC6, 0xD8, 0x73,
        0x76, 0xB2, 0xB3, 0xFC, 0x2A, 0x0F, 0xF8, 0x5F, 0x7D, 0x2B,
        0x56, 0x30, 0xB8, 0x00, 0x3B, 0x21, 0x6B, 0xAB, 0x30, 0xEA,
        0x7C, 0x62, 0xA4, 0xD2, 0x3B, 0xE2, 0x2F, 0x98, 0xA0, 0xF4,
        0x59, 0x31, 0xB5, 0x83, 0x6A, 0x93
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.60 */
