/* dhparam.c: initial DH parameters for stunnel */
#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void)
{
    static unsigned char dhp_2048[] = {
        0xCF, 0x9F, 0x3A, 0x9C, 0xC5, 0xA5, 0x89, 0x27, 0x6D, 0x2C,
        0x2C, 0xF3, 0xA6, 0x00, 0xD2, 0x7C, 0xEA, 0xFA, 0xF2, 0x43,
        0x4F, 0x49, 0x0A, 0xFC, 0xA6, 0xE7, 0x75, 0xCA, 0x07, 0xDC,
        0xA5, 0xF2, 0x83, 0x4E, 0x5A, 0xA0, 0xA0, 0xF5, 0x9C, 0xFD,
        0x02, 0xE6, 0x9E, 0xFC, 0x01, 0x59, 0xD7, 0xB6, 0xC1, 0x4E,
        0xC0, 0xB6, 0x71, 0x49, 0xF0, 0xC7, 0xD5, 0x2F, 0x8D, 0xDF,
        0xD3, 0xF1, 0x82, 0x82, 0x23, 0x33, 0x13, 0x93, 0xEB, 0x50,
        0x29, 0xFD, 0x1B, 0x5A, 0x2F, 0xD5, 0x08, 0x99, 0x64, 0xE9,
        0x7B, 0x1A, 0xDD, 0x68, 0x16, 0x08, 0xD0, 0x13, 0x82, 0xB6,
        0x86, 0x62, 0x76, 0xAA, 0x16, 0x14, 0xCC, 0x86, 0x72, 0x26,
        0x45, 0x8E, 0x2A, 0x82, 0x5B, 0x6F, 0xC1, 0xDF, 0xAA, 0x18,
        0x43, 0xB8, 0xAD, 0x84, 0x52, 0xF2, 0xD9, 0x9C, 0xC0, 0x47,
        0x52, 0x1B, 0x8E, 0x42, 0xC4, 0xD3, 0x61, 0x7B, 0x65, 0xA7,
        0x69, 0x03, 0xB5, 0xD4, 0x6C, 0x83, 0x6A, 0x46, 0x73, 0xAF,
        0x76, 0x77, 0x70, 0xC2, 0xD0, 0x74, 0xFE, 0x78, 0xF5, 0x75,
        0x3B, 0xCE, 0xE2, 0xB6, 0xA0, 0x25, 0xE9, 0xE8, 0x4B, 0xA2,
        0xF1, 0x20, 0x88, 0x13, 0x07, 0xED, 0x66, 0xBC, 0x46, 0xA1,
        0xB3, 0x44, 0xAF, 0x2C, 0xED, 0x73, 0x75, 0x3D, 0x14, 0x6E,
        0x43, 0x92, 0x40, 0x99, 0xB0, 0xD1, 0xBF, 0x2C, 0x4D, 0x0F,
        0x2A, 0x63, 0xF4, 0x85, 0x7B, 0x1B, 0x0E, 0x48, 0x5A, 0x06,
        0x02, 0xA6, 0x3D, 0x9E, 0x78, 0x05, 0xA8, 0x7C, 0xAD, 0x54,
        0x49, 0xDE, 0x7A, 0xE6, 0x36, 0x5C, 0x50, 0xFC, 0x09, 0x81,
        0x9E, 0x83, 0x53, 0x8C, 0x42, 0xEF, 0x12, 0x36, 0x4F, 0x22,
        0x16, 0x2A, 0x15, 0x88, 0x83, 0xA9, 0x00, 0x66, 0x9E, 0xD1,
        0xDC, 0x0F, 0x54, 0xC0, 0x32, 0x5C, 0x4C, 0x5E, 0xE2, 0x3D,
        0xBC, 0x56, 0x89, 0x75, 0x28, 0xA3
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.57 */
