/* dhparam.c: initial DH parameters for stunnel */
#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void)
{
    static unsigned char dhp_2048[] = {
        0x98, 0x4E, 0xCF, 0x65, 0xB6, 0x63, 0x5F, 0x50, 0xB1, 0x39,
        0x9C, 0x77, 0x0B, 0x61, 0x78, 0x04, 0x1E, 0x61, 0x56, 0x2C,
        0x88, 0xE7, 0xA4, 0x99, 0xDA, 0xC2, 0xFB, 0xF3, 0xC2, 0x09,
        0xA5, 0x7E, 0xE0, 0xBD, 0x3E, 0x9E, 0xFE, 0x4A, 0xE0, 0x5C,
        0xAE, 0x05, 0x26, 0x0A, 0xED, 0xDC, 0x83, 0xC3, 0xDA, 0x99,
        0x09, 0xA4, 0xB2, 0xA7, 0x6C, 0x81, 0x92, 0xE0, 0xFC, 0x53,
        0xF3, 0xE3, 0x42, 0x0C, 0xEE, 0x4D, 0x1A, 0xB2, 0x80, 0xE4,
        0xA0, 0xF5, 0xA8, 0x45, 0x35, 0x8F, 0xDC, 0xB3, 0x30, 0xA1,
        0x69, 0x02, 0x40, 0x46, 0x2E, 0x08, 0x5E, 0x4F, 0x8C, 0xB5,
        0xF9, 0x7F, 0xFB, 0x5F, 0xD8, 0xC2, 0x88, 0xDA, 0x28, 0x29,
        0xA6, 0x7D, 0x81, 0x64, 0x68, 0x64, 0x45, 0xA0, 0x8F, 0x0E,
        0x2F, 0xB7, 0xAB, 0xA9, 0x2A, 0xD0, 0x08, 0x0D, 0xCE, 0xDF,
        0x63, 0xD2, 0x46, 0x2A, 0x90, 0xAE, 0xCE, 0xD6, 0x94, 0x4A,
        0x88, 0xC0, 0xF8, 0x49, 0x18, 0x45, 0xC3, 0x55, 0x15, 0x9F,
        0xE3, 0x41, 0x7C, 0x05, 0xD4, 0xE3, 0x67, 0x60, 0x23, 0xBD,
        0x59, 0x55, 0x9F, 0xA7, 0x6D, 0x31, 0x7B, 0x81, 0xCC, 0xF2,
        0x57, 0x51, 0x80, 0x7A, 0x14, 0x94, 0x38, 0x53, 0x5E, 0xBC,
        0xA9, 0x3D, 0x25, 0x40, 0xB3, 0x53, 0xF1, 0x1E, 0x04, 0xB6,
        0x84, 0x70, 0x9E, 0xF7, 0x14, 0xFC, 0xB1, 0x8D, 0xB5, 0x28,
        0x0E, 0x82, 0xA1, 0x95, 0x4B, 0x74, 0xE1, 0xD5, 0x99, 0x7D,
        0x6C, 0xD0, 0xCC, 0x23, 0xEA, 0x4E, 0x8C, 0x3A, 0xEA, 0x2F,
        0x21, 0x29, 0x5F, 0xEC, 0x84, 0xD2, 0x71, 0x63, 0xA0, 0x5D,
        0x6D, 0x07, 0x40, 0xA8, 0xC0, 0xCA, 0x87, 0xEF, 0x00, 0x87,
        0x95, 0x58, 0xBD, 0x94, 0x2A, 0xFA, 0x0B, 0x54, 0x9F, 0x5B,
        0x97, 0xE2, 0xD4, 0xD7, 0x3C, 0xCF, 0xAD, 0x5D, 0x96, 0xAF,
        0xAD, 0xBE, 0x32, 0x19, 0x83, 0x53
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.54 */
