#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xAB, 0xF7, 0x30, 0x6D, 0xD2, 0x87, 0x0A, 0x6D, 0x5F, 0x2D, 
	0x95, 0xED, 0xC5, 0x32, 0x8C, 0x0D, 0x59, 0x14, 0x18, 0x14, 
	0xFD, 0x49, 0xCD, 0x1A, 0x83, 0x2D, 0xBA, 0xF3, 0xD3, 0xBE, 
	0x7B, 0x7B, 0x22, 0xE8, 0xD1, 0x73, 0x8D, 0x39, 0x74, 0x5E, 
	0x74, 0x94, 0xD3, 0x4D, 0xA6, 0x69, 0x70, 0xB4, 0x6E, 0xAA, 
	0xD7, 0x58, 0x8B, 0xEF, 0x79, 0xCC, 0x8B, 0xB0, 0x35, 0xCB, 
	0x49, 0xDB, 0x31, 0xE4, 0x8E, 0x12, 0x65, 0x0C, 0x42, 0x28, 
	0x29, 0x41, 0xAB, 0x2E, 0xE7, 0x36, 0x24, 0x32, 0x2F, 0xFA, 
	0x44, 0x6A, 0x2A, 0x93, 0x73, 0x66, 0xE9, 0x65, 0x98, 0x9C, 
	0xE7, 0xB6, 0x52, 0xD9, 0xEA, 0x96, 0xF9, 0x66, 0x46, 0x5A, 
	0x88, 0x5A, 0x3F, 0x8C, 0xEE, 0xBB, 0x71, 0xCC, 0x6E, 0xCC, 
	0x6A, 0x21, 0xDF, 0xDA, 0x5E, 0xB1, 0x5D, 0x1E, 0x3B, 0x40, 
	0x68, 0xD8, 0xEF, 0x38, 0xFC, 0x42, 0x19, 0x46, 0x8E, 0x13, 
	0x9B, 0x3F, 0x2D, 0x49, 0x13, 0xC6, 0xA7, 0x2D, 0x97, 0x4A, 
	0x05, 0x58, 0xCF, 0xC7, 0xEB, 0xC6, 0x29, 0x50, 0x99, 0xF4, 
	0x6D, 0x61, 0x0D, 0x4D, 0x43, 0xC6, 0xEA, 0x86, 0x4B, 0xB4, 
	0x16, 0x10, 0x13, 0xAD, 0xBC, 0x48, 0x3B, 0x8F, 0x10, 0x25, 
	0xFA, 0x53, 0xA5, 0x3C, 0xDE, 0x85, 0xDB, 0x9B, 0x79, 0xDC, 
	0x32, 0xA6, 0xFD, 0x19, 0x2E, 0x7C, 0xAE, 0x32, 0x9D, 0x72, 
	0xAD, 0x03, 0x14, 0x9C, 0x04, 0x61, 0x83, 0x20, 0x9C, 0x07, 
	0x5A, 0x0E, 0x91, 0xC7, 0xED, 0xDB, 0x60, 0xE2, 0xC9, 0x0B, 
	0x21, 0xD9, 0xDF, 0xA7, 0x14, 0x4A, 0x5E, 0x6B, 0xD6, 0xE6, 
	0xEB, 0x5A, 0x14, 0xE6, 0xD4, 0x13, 0x8E, 0x9D, 0x26, 0x88, 
	0x1F, 0x3B, 0x65, 0x01, 0x0F, 0x66, 0xC6, 0x45, 0xE2, 0xBD, 
	0x51, 0x41, 0x43, 0x92, 0xE2, 0x38, 0x5C, 0x56, 0x6B, 0x79, 
	0x92, 0xD9, 0xA0, 0x09, 0x0D, 0x3B
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DH_new();
    BIGNUM *dhp_bn, *dhg_bn;

    if (dh == NULL)
        return NULL;
    dhp_bn = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    dhg_bn = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (dhp_bn == NULL || dhg_bn == NULL
            || !DH_set0_pqg(dh, dhp_bn, NULL, dhg_bn)) {
        DH_free(dh);
        BN_free(dhp_bn);
        BN_free(dhg_bn);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
