#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0x8A, 0x70, 0x35, 0xEB, 0x74, 0x8D, 0x59, 0x43, 0x9F, 0x72, 
	0x8A, 0x41, 0xF4, 0x5F, 0xD0, 0xC0, 0x30, 0x1E, 0x1A, 0xA4, 
	0x00, 0x96, 0x26, 0x32, 0x93, 0xE7, 0x83, 0x4C, 0xFC, 0x73, 
	0x60, 0x7F, 0x9E, 0xEE, 0x69, 0x2C, 0xEF, 0x10, 0x89, 0x7B, 
	0xC2, 0x00, 0xCB, 0x60, 0x87, 0xA3, 0x9D, 0x2F, 0xC7, 0xD8, 
	0xA9, 0x14, 0xB1, 0xD7, 0xCB, 0x56, 0xB2, 0x16, 0x2D, 0xAB, 
	0x8B, 0xCC, 0x49, 0x55, 0x22, 0x12, 0x34, 0xEC, 0x59, 0x6A, 
	0x36, 0x33, 0x21, 0x0C, 0xC1, 0x29, 0xE7, 0x05, 0x54, 0x61, 
	0xB9, 0x9E, 0x92, 0x01, 0xBE, 0x59, 0xB2, 0xA5, 0xD6, 0xD7, 
	0xC7, 0x68, 0x9F, 0xB1, 0x64, 0x93, 0x87, 0xBD, 0x65, 0x0C, 
	0xE2, 0x41, 0x2D, 0x95, 0x4C, 0x07, 0x14, 0x08, 0x9C, 0x60, 
	0xFB, 0x53, 0xF6, 0x8B, 0x22, 0x40, 0x8C, 0xDD, 0x13, 0xC0, 
	0x8E, 0x92, 0xA9, 0x54, 0x4B, 0x46, 0x0D, 0x17, 0x9C, 0x83, 
	0x47, 0x9D, 0xA7, 0xD7, 0x42, 0x30, 0x2D, 0x21, 0x65, 0x5E, 
	0xA6, 0xE3, 0xE8, 0x7E, 0x81, 0x86, 0xE6, 0x42, 0xDE, 0xC4, 
	0xB7, 0x18, 0x9C, 0x3F, 0x45, 0x15, 0x6F, 0x8C, 0xA2, 0x5C, 
	0x43, 0xDC, 0x8D, 0x56, 0xD4, 0x03, 0xCE, 0x12, 0x40, 0x6F, 
	0xBE, 0xE4, 0x0E, 0xB1, 0xB0, 0xBC, 0x91, 0x45, 0x03, 0x8A, 
	0xBF, 0x7D, 0x92, 0x93, 0x86, 0xC6, 0x09, 0x0E, 0xBA, 0xA1, 
	0x51, 0xDE, 0x41, 0x24, 0xAF, 0xA0, 0x5A, 0xAF, 0xCB, 0xA1, 
	0x3F, 0xAA, 0x86, 0xE5, 0x67, 0x03, 0x0B, 0xF4, 0x90, 0x6F, 
	0x15, 0x9A, 0x9F, 0xD5, 0xB7, 0x9A, 0x4B, 0x55, 0xE1, 0x04, 
	0x19, 0x6E, 0x98, 0xAB, 0x69, 0x27, 0xD5, 0xFE, 0x77, 0x32, 
	0xA3, 0x4F, 0xDD, 0x6B, 0x97, 0x21, 0xAF, 0x88, 0x88, 0x6C, 
	0xE9, 0xB9, 0xA3, 0x56, 0x60, 0x01, 0x31, 0x79, 0x1F, 0x68, 
	0xA3, 0xE8, 0xB2, 0xCA, 0x43, 0x53
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DH_new();
    BIGNUM *dhp_bn, *dhg_bn;

    if (dh == NULL)
        return NULL;
    dhp_bn = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    dhg_bn = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (dhp_bn == NULL || dhg_bn == NULL
            || !DH_set0_pqg(dh, dhp_bn, NULL, dhg_bn)) {
        DH_free(dh);
        BN_free(dhp_bn);
        BN_free(dhg_bn);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
