#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xC0, 0x05, 0xDB, 0x9E, 0x7F, 0x3A, 0x8D, 0x7D, 0xDA, 0xCD, 
	0x57, 0x90, 0x20, 0xF9, 0xDC, 0x82, 0xF0, 0x0C, 0xCB, 0x52, 
	0x96, 0xF9, 0x8D, 0x93, 0xBD, 0x38, 0xCE, 0xEA, 0xA3, 0x9A, 
	0x49, 0x81, 0x87, 0x1B, 0xF7, 0xDA, 0x1A, 0x02, 0x78, 0xC2, 
	0xC2, 0xA5, 0x19, 0x13, 0x3B, 0x02, 0xBA, 0x25, 0x6D, 0xE2, 
	0x37, 0x7A, 0xA9, 0x8C, 0xAD, 0xE5, 0x67, 0x82, 0x91, 0x41, 
	0xC4, 0x8A, 0xB7, 0xE8, 0x24, 0xC7, 0x47, 0x5D, 0x78, 0xA2, 
	0x5A, 0x7F, 0xA5, 0x38, 0xB1, 0xAB, 0x9A, 0xA8, 0xE8, 0x45, 
	0x54, 0x75, 0xB0, 0xC0, 0x9F, 0xC9, 0x09, 0xB2, 0x63, 0x30, 
	0x28, 0xA1, 0xAB, 0x00, 0xC0, 0xDE, 0xD3, 0x96, 0xDC, 0xCE, 
	0x72, 0xA4, 0xC9, 0x01, 0xCA, 0xF4, 0xBC, 0x8B, 0x37, 0x4F, 
	0x5E, 0x07, 0xA1, 0x2F, 0x2C, 0x86, 0x68, 0xFC, 0xA8, 0x6B, 
	0xC1, 0xDB, 0x48, 0x06, 0xDD, 0xB8, 0x82, 0xC3, 0x5B, 0xD7, 
	0xA0, 0x33, 0x41, 0x95, 0x6B, 0x75, 0x4C, 0x43, 0x56, 0xDA, 
	0x49, 0xAB, 0x66, 0x41, 0x7F, 0x66, 0x15, 0x6D, 0xF3, 0x69, 
	0x39, 0x56, 0x54, 0xDC, 0xFA, 0xF9, 0x20, 0x72, 0x4A, 0x0B, 
	0xEB, 0xD1, 0x3D, 0xB2, 0x1F, 0xD6, 0x02, 0x9F, 0xEC, 0x60, 
	0xE2, 0xC3, 0x08, 0x2E, 0x74, 0xFF, 0xFA, 0xE1, 0xAF, 0xB8, 
	0x8F, 0x13, 0x32, 0xC7, 0xAD, 0x90, 0x26, 0x5F, 0x9A, 0x80, 
	0x6C, 0xA4, 0x59, 0x3A, 0xC0, 0x4C, 0xDB, 0xDA, 0x22, 0x4E, 
	0xCC, 0x5C, 0xA1, 0xDD, 0xA1, 0x88, 0x2E, 0x27, 0x8D, 0x8B, 
	0x13, 0xBA, 0x34, 0xBC, 0x6C, 0x00, 0x73, 0xDB, 0x6E, 0x74, 
	0x5F, 0x48, 0xCB, 0xE4, 0x37, 0x25, 0xCD, 0xFE, 0x19, 0x33, 
	0x29, 0xA3, 0xB0, 0x1E, 0xA1, 0xFE, 0x2B, 0xC2, 0xF5, 0xD0, 
	0x72, 0x63, 0x1F, 0xD1, 0x50, 0x03, 0x24, 0x41, 0xEF, 0xFF, 
	0xB9, 0xAA, 0xB1, 0x5C, 0xA6, 0xBB
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DH_new();
    BIGNUM *dhp_bn, *dhg_bn;

    if (dh == NULL)
        return NULL;
    dhp_bn = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dhg_bn = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (dhp_bn == NULL || dhg_bn == NULL
            || !DH_set0_pqg(dh, dhp_bn, NULL, dhg_bn)) {
        DH_free(dh);
        BN_free(dhp_bn);
        BN_free(dhg_bn);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
