#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xF1, 0x0C, 0xA5, 0x5A, 0x57, 0xA6, 0x9A, 0xAB, 0xEA, 0x42, 
	0x39, 0xC2, 0x6F, 0x72, 0xF7, 0x9E, 0x0D, 0x2C, 0x93, 0x6E, 
	0x34, 0x0A, 0x9D, 0x4C, 0x18, 0x30, 0xFF, 0xCD, 0x4F, 0x96, 
	0x39, 0xE4, 0x69, 0xC7, 0x47, 0x31, 0x50, 0xAD, 0x1F, 0x4A, 
	0x40, 0xDC, 0x3E, 0x6B, 0xB9, 0x17, 0xFA, 0x96, 0x11, 0x78, 
	0x17, 0xB8, 0x7E, 0x51, 0xFB, 0x5C, 0x09, 0xD1, 0xF7, 0x5B, 
	0x3F, 0xB1, 0xB8, 0x85, 0xDE, 0x24, 0x70, 0x58, 0x47, 0xB6, 
	0x47, 0x96, 0x09, 0x57, 0x62, 0xC6, 0x28, 0x30, 0x53, 0x15, 
	0x2F, 0x5D, 0xCE, 0x93, 0xD0, 0x23, 0x90, 0x09, 0xCD, 0x2E, 
	0x68, 0x82, 0x39, 0x2E, 0x9C, 0xAF, 0xB0, 0x81, 0xB4, 0xC4, 
	0xD3, 0x38, 0x4A, 0xB5, 0x12, 0x36, 0x55, 0x2A, 0xAE, 0xFE, 
	0x80, 0xD4, 0xC4, 0xD4, 0x77, 0x1A, 0x25, 0x76, 0xA9, 0x07, 
	0xA7, 0x3E, 0xA0, 0xA0, 0x06, 0xB7, 0x5F, 0xB8, 0x3A, 0x20, 
	0x41, 0x41, 0x69, 0x08, 0x3E, 0x52, 0xC2, 0xDF, 0x95, 0xCA, 
	0xEA, 0x54, 0xBA, 0x4A, 0x95, 0xCD, 0x6F, 0x05, 0xC8, 0x3A, 
	0xBB, 0x18, 0x2E, 0xDC, 0xE8, 0x02, 0x2E, 0xFB, 0x77, 0x7E, 
	0xE7, 0x09, 0xAB, 0x16, 0x7A, 0xDC, 0xAC, 0x6F, 0x28, 0xDB, 
	0x51, 0x5B, 0x41, 0xF3, 0x5F, 0xEA, 0x56, 0xE0, 0x8A, 0xF2, 
	0x64, 0x9D, 0x33, 0xB2, 0x55, 0x14, 0x1C, 0x28, 0xC2, 0xA1, 
	0x34, 0x85, 0xA4, 0x58, 0x28, 0xEB, 0x20, 0x76, 0x12, 0x50, 
	0xA8, 0x9E, 0x7A, 0x3A, 0x42, 0xBF, 0xB3, 0xC3, 0x5B, 0x6D, 
	0x3C, 0x1E, 0x9B, 0x94, 0xC7, 0xE4, 0xF3, 0x97, 0xDE, 0xF1, 
	0x00, 0xEB, 0x8C, 0x6A, 0x0C, 0x92, 0xF2, 0xC9, 0x29, 0x12, 
	0x4C, 0xF3, 0x4B, 0x22, 0x3F, 0xB5, 0x87, 0xBA, 0x6E, 0xC3, 
	0x43, 0xDD, 0xAE, 0xB4, 0xDF, 0xA9, 0x46, 0x37, 0x47, 0x08, 
	0x5D, 0x82, 0xEA, 0x32, 0x52, 0x6B
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DH_new();
    BIGNUM *dhp_bn, *dhg_bn;

    if (dh == NULL)
        return NULL;
    dhp_bn = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dhg_bn = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (dhp_bn == NULL || dhg_bn == NULL
            || !DH_set0_pqg(dh, dhp_bn, NULL, dhg_bn)) {
        DH_free(dh);
        BN_free(dhp_bn);
        BN_free(dhg_bn);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
