#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0x9E, 0xBC, 0x82, 0xA5, 0x93, 0xF9, 0xCA, 0xAA, 0x3A, 0x0D, 
	0xF1, 0x79, 0xB9, 0xEE, 0x72, 0x95, 0x84, 0x81, 0xF6, 0x27, 
	0x79, 0x73, 0x60, 0x2B, 0x30, 0x2A, 0x89, 0x5A, 0x17, 0x20, 
	0x0F, 0x33, 0xA6, 0x71, 0xBC, 0xAA, 0x1A, 0xE3, 0x08, 0x3E, 
	0x64, 0x70, 0x23, 0x97, 0x27, 0x57, 0x36, 0xDB, 0x3D, 0xF6, 
	0x10, 0x05, 0xAF, 0x58, 0xDA, 0xDE, 0x52, 0xAC, 0x77, 0x52, 
	0xE9, 0x9A, 0xC3, 0xCD, 0xB0, 0x5A, 0xAE, 0xC5, 0xD5, 0x8A, 
	0xBF, 0x9A, 0x28, 0x87, 0xC7, 0x53, 0x95, 0x21, 0x92, 0x5B, 
	0x5C, 0xAC, 0x5C, 0x9B, 0x79, 0x02, 0xF1, 0x09, 0x48, 0x49, 
	0x91, 0x7D, 0x99, 0x13, 0x75, 0x97, 0x76, 0x8F, 0xE0, 0xDD, 
	0x2C, 0x08, 0xDA, 0x66, 0x7B, 0x8D, 0xBD, 0x39, 0xEC, 0x8C, 
	0xC1, 0xD7, 0x35, 0x03, 0xA0, 0xAE, 0x21, 0xC7, 0x71, 0x81, 
	0x23, 0x51, 0x96, 0x5D, 0xEB, 0x59, 0x32, 0xAA, 0x2B, 0x21, 
	0xB5, 0xB7, 0x1A, 0xBA, 0x7B, 0xAF, 0xCD, 0xB3, 0xBE, 0x3A, 
	0x0E, 0xEF, 0x17, 0xDC, 0xB6, 0x08, 0xD5, 0x7F, 0x09, 0x75, 
	0xF2, 0xDE, 0x26, 0xCE, 0x83, 0x36, 0xE0, 0x1F, 0x7B, 0x63, 
	0x65, 0xEF, 0x84, 0xED, 0x48, 0x47, 0xA5, 0x59, 0x4A, 0x8D, 
	0x14, 0x4F, 0x74, 0x2C, 0x4C, 0x2B, 0x3B, 0x18, 0x2B, 0x3D, 
	0x13, 0xE1, 0xE7, 0xA7, 0xF5, 0x14, 0x29, 0xA9, 0xFB, 0x0C, 
	0x7E, 0x59, 0x88, 0x42, 0xE4, 0x85, 0xE4, 0x6A, 0x43, 0x7A, 
	0x82, 0x65, 0xE9, 0xAA, 0x0F, 0x70, 0x7D, 0xDD, 0x27, 0x7F, 
	0xE1, 0x20, 0x63, 0x88, 0x10, 0xF8, 0xA3, 0xDB, 0x89, 0x6E, 
	0x2A, 0xE3, 0xE0, 0xFE, 0x12, 0x5F, 0xD0, 0x01, 0x55, 0x0B, 
	0x69, 0x90, 0x90, 0x9A, 0x49, 0xDD, 0x61, 0x76, 0x37, 0x2C, 
	0xD5, 0x88, 0xF8, 0x54, 0xB1, 0xD2, 0x74, 0xE9, 0x6E, 0x25, 
	0xA3, 0x55, 0x3C, 0xED, 0x11, 0xB3
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DN_new();

    if (dh == NULL)
        return NULL;
    dh->p = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dh->g = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (!dh->p || !dh->g) {
        DH_free(dh);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
