#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
#include <openssl/dh.h>
#endif
DH *get_dh2048()
	{
	static unsigned char dh2048_p[]={
		0xF8,0x41,0xAE,0xC8,0x92,0xAF,0xC6,0xD4,0x8B,0xC2,0x06,0x04,
		0x83,0x57,0x08,0x80,0xD6,0xC3,0xA7,0x8A,0xFD,0x8E,0xCF,0xAC,
		0x8F,0x8A,0x43,0x20,0x05,0x2B,0xD1,0x70,0x01,0xD0,0x9F,0x7B,
		0x44,0x92,0xB5,0x64,0xA7,0xE9,0xF1,0x1E,0xBC,0x9E,0x51,0x87,
		0xDB,0x66,0xA6,0x0A,0xD6,0xF4,0xBD,0xBD,0xDF,0x50,0xF6,0xBA,
		0x5D,0xB3,0x9C,0x2F,0x3F,0x41,0xEB,0xDD,0xEE,0xE1,0x7B,0xAD,
		0x99,0x5D,0xA6,0x69,0xC6,0x2F,0x5A,0x2F,0x47,0x5E,0x49,0x48,
		0xA4,0x87,0xA4,0x65,0x12,0x93,0xB9,0xA3,0x09,0x04,0x01,0xA0,
		0xD0,0xFB,0x0E,0x47,0x7F,0x8C,0x5C,0x74,0x50,0xEA,0xFB,0xFD,
		0x39,0xD4,0x00,0x30,0x0A,0xDE,0x7E,0xB7,0xBE,0x5E,0x30,0x06,
		0x5A,0xAC,0xC2,0x79,0xC3,0x3A,0xFC,0x72,0xC2,0x15,0x7A,0xBE,
		0x49,0xBE,0x36,0x7A,0xED,0x38,0x83,0x3F,0x44,0xAB,0x26,0x81,
		0x89,0xEF,0x58,0xDF,0x55,0x14,0xD5,0x42,0xB4,0x57,0xD6,0x01,
		0xE2,0x9C,0x2D,0x7B,0xC1,0xDA,0xB9,0x10,0x8C,0x5A,0xF7,0x98,
		0xE2,0x00,0x8F,0xA8,0x22,0x6C,0x60,0x90,0x35,0x6A,0x74,0x29,
		0x7B,0xE0,0xF9,0x46,0xF3,0x79,0x9C,0x7A,0x30,0x62,0x16,0x9D,
		0x42,0xBD,0xD2,0x5E,0x17,0x49,0x71,0xC5,0xB0,0x51,0xCA,0xAC,
		0x53,0xC2,0xC5,0x59,0x9E,0x02,0xA7,0xCB,0x82,0xA7,0x98,0x33,
		0x2D,0x89,0xC4,0x89,0x46,0x86,0xAF,0x1C,0xDC,0xB8,0x52,0xD1,
		0x06,0x2D,0x94,0x99,0x67,0x76,0xF5,0xE5,0xA3,0x5D,0x87,0x5F,
		0xD1,0x77,0x3A,0xEA,0x17,0x05,0xC9,0x87,0x9F,0x24,0x82,0xBD,
		0xDB,0x15,0x1C,0xBB,
		};
	static unsigned char dh2048_g[]={
		0x02,
		};
	DH *dh;

	if ((dh=DH_new()) == NULL) return(NULL);
	dh->p=BN_bin2bn(dh2048_p,sizeof(dh2048_p),NULL);
	dh->g=BN_bin2bn(dh2048_g,sizeof(dh2048_g),NULL);
	if ((dh->p == NULL) || (dh->g == NULL))
		{ DH_free(dh); return(NULL); }
	return(dh);
	}
#endif /* OPENSSL_NO_DH */
