#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xC8, 0xD8, 0x1E, 0x44, 0xD4, 0x57, 0x91, 0x10, 0xAE, 0xDC, 
	0x8D, 0xC5, 0x70, 0xE4, 0x1D, 0xA4, 0x2F, 0xCA, 0x44, 0x10, 
	0x32, 0x0E, 0xF5, 0xDB, 0xBA, 0x9A, 0x4A, 0x15, 0x41, 0x60, 
	0x81, 0x4E, 0x90, 0x63, 0x2B, 0xEF, 0x77, 0x6F, 0x61, 0x5A, 
	0x23, 0x62, 0x80, 0xA7, 0x6B, 0x8D, 0x07, 0x6D, 0xA1, 0x1A, 
	0x97, 0x20, 0x95, 0x58, 0x19, 0x72, 0x07, 0xAB, 0x5B, 0x81, 
	0xBA, 0x99, 0x65, 0x9A, 0xE5, 0x52, 0x8C, 0xE4, 0xE5, 0xBE, 
	0x34, 0xC8, 0x03, 0x54, 0x25, 0x56, 0xE9, 0x67, 0xC1, 0x25, 
	0x7F, 0xA2, 0x1C, 0xA3, 0xD4, 0x53, 0xE4, 0xAB, 0x26, 0x53, 
	0xAF, 0x7F, 0xE3, 0x50, 0x2B, 0xD9, 0xFB, 0xD4, 0x2A, 0x79, 
	0xE8, 0xA0, 0xF2, 0x92, 0xBA, 0xEC, 0x88, 0x24, 0x33, 0xB8, 
	0x92, 0xC0, 0xF0, 0x1B, 0x00, 0x78, 0x23, 0xB4, 0xDB, 0x5A, 
	0x21, 0x05, 0x40, 0x99, 0xBE, 0xC3, 0xC0, 0xEB, 0x0A, 0x7D, 
	0xAF, 0xB7, 0x7D, 0x7F, 0x73, 0x33, 0xEB, 0x93, 0xC2, 0x53, 
	0x73, 0x8B, 0x11, 0xEF, 0x60, 0x52, 0x65, 0x0C, 0xB6, 0xDD, 
	0xA1, 0x80, 0x7C, 0x96, 0x2B, 0x28, 0xB0, 0xA0, 0x9C, 0x83, 
	0xE5, 0xB2, 0x6B, 0xBE, 0x13, 0xE8, 0x8D, 0xD5, 0x1C, 0xAB, 
	0xBB, 0x00, 0x4C, 0x11, 0xF0, 0x90, 0x0D, 0x97, 0xB5, 0x52, 
	0x41, 0xC3, 0x64, 0x94, 0x5F, 0x5D, 0x2B, 0x4F, 0x01, 0x99, 
	0x34, 0x0D, 0xAE, 0xD5, 0xA7, 0xB9, 0x20, 0x1B, 0x47, 0x97, 
	0x2F, 0x97, 0xD0, 0xFA, 0x91, 0x12, 0x12, 0x14, 0x9F, 0x13, 
	0xEE, 0x99, 0xCC, 0xD1, 0x42, 0x45, 0xEE, 0xB6, 0x2D, 0x57, 
	0xAC, 0xEB, 0x85, 0x1F, 0x33, 0xC4, 0x5F, 0x96, 0xD4, 0xCA, 
	0xA0, 0x6C, 0x4C, 0xAC, 0x4F, 0xF9, 0x46, 0x70, 0x55, 0x91, 
	0xE1, 0x4F, 0xE1, 0xAF, 0x99, 0x9D, 0xEB, 0x6D, 0x20, 0x34, 
	0x09, 0xD1, 0x9C, 0xF0, 0x33, 0x43
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DN_new();

    if (dh == NULL)
        return NULL;
    dh->p = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dh->g = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (!dh->p || !dh->g) {
        DH_free(dh);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
