/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";

/**
 * Tests the event notification service for the profiler actor.
 */

const { ProfilerFront } = require("devtools/shared/fronts/profiler");

add_task(function* () {
  let [client, form] = yield getChromeActors();
  let front = new ProfilerFront(client, form);

  let events = [0, 0, 0, 0];
  front.on("console-api-profiler", () => events[0]++);
  front.on("profiler-started", () => events[1]++);
  front.on("profiler-stopped", () => events[2]++);
  client.addListener("eventNotification", (type, response) => {
    Assert.ok(type === "eventNotification");
    events[3]++;
  });

  yield front.startProfiler();
  yield front.stopProfiler();

  // All should be empty without binding events
  Assert.ok(events[0] === 0);
  Assert.ok(events[1] === 0);
  Assert.ok(events[2] === 0);
  Assert.ok(events[3] === 0);

  let ret = yield front.registerEventNotifications(
    { events: ["console-api-profiler", "profiler-started", "profiler-stopped"] });
  Assert.ok(ret.registered.length === 3);

  yield front.startProfiler();
  Assert.ok(events[0] === 0);
  Assert.ok(events[1] === 1);
  Assert.ok(events[2] === 0);
  Assert.ok(events[3] === 1, "compatibility events supported for eventNotifications");

  yield front.stopProfiler();
  Assert.ok(events[0] === 0);
  Assert.ok(events[1] === 1);
  Assert.ok(events[2] === 1);
  Assert.ok(events[3] === 2, "compatibility events supported for eventNotifications");

  ret = yield front.unregisterEventNotifications(
    { events: ["console-api-profiler", "profiler-started", "profiler-stopped"] });
  Assert.ok(ret.registered.length === 3);
});

function getChromeActors() {
  let deferred = defer();
  get_chrome_actors((client, form) => deferred.resolve([client, form]));
  return deferred.promise;
}
