Summary: An extensible window manager for the X Window System.
Name: sawfish
Version: 1.6.1
Release: 1%{?dist}
Requires: librep >= 0.90.5, rep-gtk >= 0.90.2
License: GPL
Group: User Interface/Desktops
Source: http://download.sourceforge.net/sawmill/sawfish-%{version}.tar.bz2
URL: http://sawfish.wikia.com/
Packager: Christopher Bratusek <zanghar@freenet.de>
Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: gmp-devel texinfo
Provides: windowmanager

%define rep_execdir %(pkg-config librep --variable=repcommonexecdir)
%if %{?_kde4_appsdir:1}%{!?_kde4_appsdir:0}
%define kde_apps %{_kde4_appsdir}
%else
%define kde_apps %{_datadir}/kde4/apps
%endif

%description
Sawfish is an extensible window manager which uses a Lisp-based
scripting language.  All window decorations are configurable and the
basic idea is to have as much user-interface policy as possible
controlled through the Lisp language.  Configuration can be
accomplished by writing Lisp code in a personal .sawfishrc file, or
using a GTK+ interface.  Sawfish is mostly GNOME compliant

%prep
%setup -q

%build
%configure
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT

mkdir -p $RPM_BUILD_ROOT%{_datadir}/gnome/wm-properties/
mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications/
mkdir -p $RPM_BUILD_ROOT%{_bindir}

make install DESTDIR=$RPM_BUILD_ROOT
%find_lang %{name}

gzip -9nf $RPM_BUILD_ROOT%{_infodir}/sawfish*
rm -f $RPM_BUILD_ROOT%{_infodir}/dir

%post
/sbin/install-info %{_infodir}/sawfish.info.gz %{_infodir}/dir

%preun
if [ "$1" = 0 ]; then
    /sbin/install-info --delete %{_infodir}/sawfish.info.gz %{_infodir}/dir
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(-,root,root,-)
%doc README NEWS FAQ TODO OPTIONS README.IMPORTANT KEYBINDINGS USERDOC COPYING COPYING.SOUNDS
%{_bindir}/*
%dir %{_datadir}/sawfish
%{_datadir}/sawfish/%{version}
%{_datadir}/gnome/wm-properties/sawfish-wm.desktop
%{_datadir}/applications/sawfish.desktop
%{kde_apps}/ksmserver/windowmanagers/sawfish.desktop
%{_datadir}/xsessions/sawfish.desktop
%{_datadir}/man/man1/sawfish*.gz
%{_datadir}/sawfish/sawfish.png
%{_libdir}/pkgconfig/sawfish.pc
%{_libdir}/sawfish/%{version}/%{_host}
%{rep_execdir}/sawfish
%{_infodir}/sawfish*
%{_includedir}/sawfish/

%changelog
* Sat Sep 05 2009 Kim B. Heino <b@bbbs.net>
- add dist-tag, update files list

* Sun Jan 18 2008 Christopher Bratusek <zanghar@freenet.de>
- several fixups

* Tue Jun 12 2000 John Harper <john@dcs.warwick.ac.uk>
- merged differences from RH spec file

* Mon Apr 24 2000 John Harper <john@dcs.warwick.ac.uk>
- s/sawmill/sawfish/

* Fri Sep 17 1999 John Harper <john@dcs.warwick.ac.uk>
- don't patch the Makefile

* Tue Sep 14 1999 Aron Griffis <agriffis@bigfoot.com>
- 0.6 spec file update: added buildroot
