# Copyright 1999-2008 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/x11-wm/sawfish/sawfish-1.6.1.ebuild,v 1.7 2008/10/06 17:13:50 truedfx Exp $

inherit eutils

DESCRIPTION="Extensible window manager using a Lisp-based scripting language"
HOMEPAGE="http://sawfish.wikia.com/"
SRC_URI="mirror://sourceforge/sawmill/${P}.tar.bz2"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="alpha amd64 ia64 ppc ppc64 sparc x86"
IUSE="gnome nls"

RDEPEND=">=x11-libs/rep-gtk-0.90.2
	>=dev-libs/librep-0.90.5
	>=x11-libs/gtk+-2.12.0
	>=x11-libs/pango-1.8.0
	nls? ( sys-devel/gettext )"
DEPEND="${RDEPEND}
	>=dev-util/pkgconfig-0.12.0"

src_unpack() {
	unpack ${A}
	cd "${S}"
}

src_compile() {
	set -- \
		--with-gdk-pixbuf

	if use gnome; then
		set -- "$@" \
			--with-gnome-prefix=/usr
	fi

	if ! use nls; then
		set -- "$@" \
			--disable-nls

	fi

	econf "$@" || die "configure failed"

	emake || die "make failed"
}

src_install() {
	emake DESTDIR="${D}" install || die "make install failed"
	dodoc AUTHORS ChangeLog FAQ NEWS README TODO OPTIONS README.IMPORTANT KEYBINDINGS USERDOC COPYING COPYING.SOUNDS
}
