# Copyright 2014 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    # This turns on e.g. the filename-based detection of which
    # platforms to include source files on (e.g. files ending in
    # _mac.h or _mac.cc are only compiled on MacOSX).
    'chromium_code': 1,

    # Note: sources list duplicated in GN build. In the GN build,
    # each component has its own unit tests target defined in its
    # directory that are then linked into the final components_unittests.
    'auto_login_parser_unittest_sources': [
      'auto_login_parser/auto_login_parser_unittest.cc',
    ],
    'autofill_unittest_sources': [
      'autofill/content/browser/content_autofill_driver_unittest.cc',
      'autofill/content/browser/payments/payments_client_unittest.cc',
      'autofill/content/public/cpp/autofill_types_struct_traits_unittest.cc',
      'autofill/content/renderer/renderer_save_password_progress_logger_unittest.cc',
      'autofill/core/browser/address_field_unittest.cc',
      'autofill/core/browser/address_i18n_unittest.cc',
      'autofill/core/browser/address_unittest.cc',
      'autofill/core/browser/address_rewriter_unittest.cc',
      'autofill/core/browser/autocomplete_history_manager_unittest.cc',
      'autofill/core/browser/autofill_country_unittest.cc',
      'autofill/core/browser/autofill_data_model_unittest.cc',
      'autofill/core/browser/autofill_data_util_unittest.cc',
      'autofill/core/browser/autofill_download_manager_unittest.cc',
      'autofill/core/browser/autofill_external_delegate_unittest.cc',
      'autofill/core/browser/autofill_field_unittest.cc',
      'autofill/core/browser/autofill_ie_toolbar_import_win_unittest.cc',
      'autofill/core/browser/autofill_manager_unittest.cc',
      'autofill/core/browser/autofill_merge_unittest.cc',
      'autofill/core/browser/autofill_metrics_unittest.cc',
      'autofill/core/browser/autofill_profile_comparator_unittest.cc',
      'autofill/core/browser/autofill_profile_unittest.cc',
      'autofill/core/browser/autofill_type_unittest.cc',
      'autofill/core/browser/contact_info_unittest.cc',
      'autofill/core/browser/country_names_unittest.cc',
      'autofill/core/browser/credit_card_field_unittest.cc',
      'autofill/core/browser/credit_card_unittest.cc',
      'autofill/core/browser/field_candidates_unittest.cc',
      'autofill/core/browser/form_field_unittest.cc',
      'autofill/core/browser/form_structure_unittest.cc',
      'autofill/core/browser/legal_message_line_unittest.cc',
      'autofill/core/browser/name_field_unittest.cc',
      'autofill/core/browser/password_generator_unittest.cc',
      'autofill/core/browser/payments/full_card_request_unittest.cc',
      'autofill/core/browser/payments/payments_service_url_unittest.cc',
      'autofill/core/browser/personal_data_manager_unittest.cc',
      'autofill/core/browser/phone_field_unittest.cc',
      'autofill/core/browser/phone_number_i18n_unittest.cc',
      'autofill/core/browser/phone_number_unittest.cc',
      'autofill/core/browser/ui/card_unmask_prompt_controller_impl_unittest.cc',
      'autofill/core/browser/validation_unittest.cc',
      'autofill/core/browser/webdata/autofill_data_type_controller_unittest.cc',
      'autofill/core/browser/webdata/autofill_profile_syncable_service_unittest.cc',
      'autofill/core/browser/webdata/autofill_table_unittest.cc',
      'autofill/core/browser/webdata/autofill_wallet_metadata_syncable_service_unittest.cc',
      'autofill/core/browser/webdata/web_data_service_unittest.cc',
      'autofill/core/common/autofill_l10n_util_unittest.cc',
      'autofill/core/common/autofill_regexes_unittest.cc',
      'autofill/core/common/autofill_util_unittest.cc',
      'autofill/core/common/form_data_unittest.cc',
      'autofill/core/common/form_field_data_unittest.cc',
      'autofill/core/common/password_form_fill_data_unittest.cc',
      'autofill/core/common/save_password_progress_logger_unittest.cc',
    ],
    'base32_unittest_sources': [
      'base32/base32_unittest.cc',
    ],
    'bookmarks_unittest_sources': [
      'bookmarks/browser/bookmark_codec_unittest.cc',
      'bookmarks/browser/bookmark_expanded_state_tracker_unittest.cc',
      'bookmarks/browser/bookmark_index_unittest.cc',
      'bookmarks/browser/bookmark_model_unittest.cc',
      'bookmarks/browser/bookmark_utils_unittest.cc',
      'bookmarks/managed/managed_bookmarks_tracker_unittest.cc',
    ],
    'browser_sync_unittest_sources': [
      'browser_sync/browser/profile_sync_service_autofill_unittest.cc',
      'browser_sync/browser/profile_sync_service_bookmark_unittest.cc',
      'browser_sync/browser/profile_sync_service_startup_unittest.cc',
      'browser_sync/browser/profile_sync_service_typed_url_unittest.cc',
      'browser_sync/browser/profile_sync_service_unittest.cc',
    ],
    'browser_watcher_unittest_sources': [
      'browser_watcher/endsession_watcher_window_win_unittest.cc',
      'browser_watcher/exit_code_watcher_win_unittest.cc',
      'browser_watcher/exit_funnel_win_unittest.cc',
      'browser_watcher/watcher_client_win_unittest.cc',
      'browser_watcher/watcher_metrics_provider_win_unittest.cc',
      'browser_watcher/window_hang_monitor_win_unittest.cc',
    ],
    'browsing_data_ui_unittest_sources': [
      'browsing_data_ui/history_notice_utils_unittest.cc'
    ],
    'bubble_unittest_sources': [
      'bubble/bubble_manager_mocks.cc',
      'bubble/bubble_manager_mocks.h',
      'bubble/bubble_manager_unittest.cc',
    ],
    'captive_portal_unittest_sources': [
      'captive_portal/captive_portal_detector_unittest.cc',
    ],
    'cast_certificate_unittest_sources': [
      'cast_certificate/cast_cert_validator_test_helpers.cc',
      'cast_certificate/cast_cert_validator_test_helpers.h',
      'cast_certificate/cast_cert_validator_unittest.cc',
    ],
    'certificate_reporting_unittest_sources': [
      'certificate_reporting/error_report_unittest.cc',
      'certificate_reporting/error_reporter_unittest.cc',
    ],
    'certificate_transparency_unittest_sources': [
      'certificate_transparency/ct_policy_manager_unittest.cc',
      'certificate_transparency/log_proof_fetcher_unittest.cc',
      'certificate_transparency/single_tree_tracker_unittest.cc',
    ],
    'child_trace_message_filter_unittest_sources': [
      'tracing/child/child_trace_message_filter_unittest.cc',
    ],
    'client_update_protocol_unittest_sources': [
      'client_update_protocol/ecdsa_unittest.cc',
    ],
    'cloud_devices_unittest_sources': [
      'cloud_devices/common/cloud_devices_urls_unittest.cc',
      'cloud_devices/common/printer_description_unittest.cc',
    ],
    'component_updater_unittest_sources': [
      'component_updater/component_updater_service_unittest.cc',
      'component_updater/default_component_installer_unittest.cc',
      'component_updater/timer_unittest.cc',
    ],
    'content_settings_unittest_sources': [
      'content_settings/core/browser/content_settings_mock_provider.cc',
      'content_settings/core/browser/content_settings_mock_provider.h',
      'content_settings/core/browser/content_settings_registry_unittest.cc',
      'content_settings/core/browser/content_settings_rule_unittest.cc',
      'content_settings/core/browser/content_settings_utils_unittest.cc',
      'content_settings/core/browser/cookie_settings_unittest.cc',
      'content_settings/core/browser/website_settings_registry_unittest.cc',
      'content_settings/core/common/content_settings_pattern_parser_unittest.cc',
      'content_settings/core/common/content_settings_pattern_unittest.cc',
    ],
    'crash_unittest_sources': [
      'crash/content/app/crash_keys_win_unittest.cc',
      'crash/core/common/crash_keys_unittest.cc',
      'crash/core/common/objc_zombie_unittest.mm',
    ],
    'crx_file_unittest_sources': [
      'crx_file/id_util_unittest.cc',
    ],
    'data_reduction_proxy_unittest_sources': [
      'data_reduction_proxy/content/browser/content_lofi_decider_unittest.cc',
      'data_reduction_proxy/content/browser/content_lofi_ui_service_unittest.cc',
      'data_reduction_proxy/content/browser/data_reduction_proxy_message_filter_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_bypass_protocol_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_bypass_stats_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_compression_stats_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_config_service_client_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_config_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_configurator_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_data_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_delegate_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_interceptor_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_io_data_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_metrics_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_mutable_config_values_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_network_delegate_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_pingback_client_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_prefs_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_request_options_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_settings_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_tamper_detection_unittest.cc',
      'data_reduction_proxy/core/browser/data_usage_store_unittest.cc',
      'data_reduction_proxy/core/common/data_reduction_proxy_event_store_unittest.cc',
      'data_reduction_proxy/core/common/data_reduction_proxy_headers_unittest.cc',
      'data_reduction_proxy/core/common/data_reduction_proxy_params_unittest.cc',
      'data_reduction_proxy/core/common/data_reduction_proxy_util_unittest.cc',
    ],
    'data_usage_unittest_sources': [
      'data_usage/core/data_use_aggregator_unittest.cc',
    ],
    'device_event_log_unittest_sources': [
      'device_event_log/device_event_log_impl_unittest.cc',
    ],
    'devtools_http_handler_unittest_sources': [
      'devtools_http_handler/devtools_http_handler_unittest.cc',
    ],
    'display_compositor_unittest_sources': [
      'display_compositor/buffer_queue_unittest.cc',
    ],
    'dom_distiller_unittest_sources': [
      'dom_distiller/content/browser/dom_distiller_viewer_source_unittest.cc',
      'dom_distiller/content/browser/web_contents_main_frame_observer_unittest.cc',
      'dom_distiller/core/article_entry_unittest.cc',
      'dom_distiller/core/distillable_page_detector_unittest.cc',
      'dom_distiller/core/distilled_content_store_unittest.cc',
      'dom_distiller/core/distilled_page_prefs_unittests.cc',
      'dom_distiller/core/distiller_unittest.cc',
      'dom_distiller/core/distiller_url_fetcher_unittest.cc',
      'dom_distiller/core/dom_distiller_model_unittest.cc',
      'dom_distiller/core/dom_distiller_request_view_base_unittest.cc',
      'dom_distiller/core/dom_distiller_service_unittest.cc',
      'dom_distiller/core/dom_distiller_store_unittest.cc',
      'dom_distiller/core/page_features_unittest.cc',
      'dom_distiller/core/task_tracker_unittest.cc',
      'dom_distiller/core/url_utils_unittest.cc',
      'dom_distiller/core/viewer_unittest.cc',
    ],
    'domain_reliability_unittest_sources': [
      'domain_reliability/config_unittest.cc',
      'domain_reliability/context_unittest.cc',
      'domain_reliability/dispatcher_unittest.cc',
      'domain_reliability/google_configs_unittest.cc',
      'domain_reliability/header_unittest.cc',
      'domain_reliability/monitor_unittest.cc',
      'domain_reliability/scheduler_unittest.cc',
      'domain_reliability/test_util.cc',
      'domain_reliability/test_util.h',
      'domain_reliability/uploader_unittest.cc',
      'domain_reliability/util_unittest.cc',
    ],
    'favicon_base_unittest_sources': [
      'favicon_base/fallback_icon_url_parser_unittest.cc',
      'favicon_base/favicon_url_parser_unittest.cc',
      'favicon_base/large_icon_url_parser_unittest.cc',
      'favicon_base/select_favicon_frames_unittest.cc',
    ],
    'favicon_unittest_sources': [
      'favicon/content/content_favicon_driver_unittest.cc',
      'favicon/core/fallback_url_util_unittest.cc',
      'favicon/core/favicon_handler_unittest.cc',
      'favicon/core/large_icon_service_unittest.cc',
    ],
    'flags_ui_unittest_sources': [
      'flags_ui/flags_state_unittest.cc',
    ],
    'undo_unittest_sources': [
      'undo/bookmark_undo_service_test.cc',
      'undo/undo_manager_test.cc',
    ],

    'audio_modem_unittest_sources': [
      'audio_modem/audio_player_unittest.cc',
      'audio_modem/audio_recorder_unittest.cc',
      'audio_modem/modem_unittest.cc',
    ],
    'copresence_unittest_sources': [
      'copresence/copresence_state_unittest.cc',
      'copresence/handlers/audio/audio_directive_handler_unittest.cc',
      'copresence/handlers/audio/audio_directive_list_unittest.cc',
      'copresence/handlers/directive_handler_unittest.cc',
      'copresence/handlers/gcm_handler_unittest.cc',
      'copresence/rpc/http_post_unittest.cc',
      'copresence/rpc/rpc_handler_unittest.cc',
      'copresence/timed_map_unittest.cc',
    ],
    'data_use_measurement_unittest_sources': [
      'data_use_measurement/content/data_use_measurement_unittest.cc',
    ],
    'error_page_unittest_sources': [
      'error_page/renderer/net_error_helper_core_unittest.cc',
    ],
    'feedback_unittest_sources': [
      'feedback/anonymizer_tool_unittest.cc',
      'feedback/feedback_common_unittest.cc',
      'feedback/feedback_data_unittest.cc',
      'feedback/feedback_uploader_chrome_unittest.cc',
      'feedback/feedback_uploader_unittest.cc',
    ],
    'gcm_driver_unittest_sources': [
      'gcm_driver/gcm_account_mapper_unittest.cc',
      'gcm_driver/gcm_account_tracker_unittest.cc',
      'gcm_driver/gcm_channel_status_request_unittest.cc',
      'gcm_driver/gcm_client_impl_unittest.cc',
      'gcm_driver/gcm_delayed_task_controller_unittest.cc',
      'gcm_driver/gcm_driver_desktop_unittest.cc',
      'gcm_driver/gcm_stats_recorder_android_unittest.cc',
      'gcm_driver/gcm_stats_recorder_impl_unittest.cc',
    ],
    'gcm_driver_crypto_unittest_sources': [
      'gcm_driver/crypto/encryption_header_parsers_unittest.cc',
      'gcm_driver/crypto/gcm_encryption_provider_unittest.cc',
      'gcm_driver/crypto/gcm_key_store_unittest.cc',
      'gcm_driver/crypto/gcm_message_cryptographer_unittest.cc',
      'gcm_driver/crypto/p256_key_util_unittest.cc',
    ],
    'google_unittest_sources': [
      'google/core/browser/google_url_tracker_unittest.cc',
      'google/core/browser/google_util_unittest.cc',
    ],
    'guest_view_unittest_sources': [
      'guest_view/browser/guest_view_manager_unittest.cc'
    ],
    'history_unittest_sources': [
      'history/content/browser/content_history_backend_db_unittest.cc',
      'history/core/browser/android/android_history_types_unittest.cc',
      'history/core/browser/expire_history_backend_unittest.cc',
      'history/core/browser/history_backend_db_unittest.cc',
      'history/core/browser/history_backend_unittest.cc',
      'history/core/browser/history_database_unittest.cc',
      'history/core/browser/history_querying_unittest.cc',
      'history/core/browser/history_service_unittest.cc',
      'history/core/browser/history_types_unittest.cc',
      'history/core/browser/thumbnail_database_unittest.cc',
      'history/core/browser/top_sites_cache_unittest.cc',
      'history/core/browser/top_sites_database_unittest.cc',
      'history/core/browser/top_sites_impl_unittest.cc',
      'history/core/browser/typed_url_syncable_service_unittest.cc',
      'history/core/browser/url_database_unittest.cc',
      'history/core/browser/url_utils_unittest.cc',
      'history/core/browser/visit_database_unittest.cc',
      'history/core/browser/visit_tracker_unittest.cc',
      'history/core/browser/web_history_service_unittest.cc',
      'history/core/common/thumbnail_score_unittest.cc',
    ],
    'image_fetcher_unittest_sources': [
      'image_fetcher/image_data_fetcher_unittest.cc',
    ],
    'instance_id_unittest_sources': [
      'gcm_driver/instance_id/instance_id_driver_unittest.cc',
    ],
    'invalidation_unittest_sources': [
      'invalidation/impl/fake_invalidator_unittest.cc',
      'invalidation/impl/gcm_invalidation_bridge_unittest.cc',
      'invalidation/impl/gcm_network_channel_unittest.cc',
      'invalidation/impl/invalidation_logger_unittest.cc',
      'invalidation/impl/invalidation_notifier_unittest.cc',
      'invalidation/impl/invalidator_registrar_unittest.cc',
      'invalidation/impl/invalidator_storage_unittest.cc',
      'invalidation/impl/non_blocking_invalidator_unittest.cc',
      'invalidation/impl/object_id_invalidation_map_unittest.cc',
      'invalidation/impl/p2p_invalidator_unittest.cc',
      'invalidation/impl/push_client_channel_unittest.cc',
      'invalidation/impl/registration_manager_unittest.cc',
      'invalidation/impl/single_object_invalidation_set_unittest.cc',
      'invalidation/impl/sync_invalidation_listener_unittest.cc',
      'invalidation/impl/sync_system_resources_unittest.cc',
      'invalidation/impl/ticl_invalidation_service_unittest.cc',
      'invalidation/impl/ticl_profile_settings_provider_unittest.cc',
      'invalidation/impl/unacked_invalidation_set_unittest.cc',
    ],
    'json_schema_unittest_sources': [
      'json_schema/json_schema_validator_unittest.cc',
      'json_schema/json_schema_validator_unittest_base.cc',
      'json_schema/json_schema_validator_unittest_base.h',
    ],
    'keyed_service_unittest_sources': [
      'keyed_service/content/browser_context_dependency_manager_unittest.cc',
      'keyed_service/core/dependency_graph_unittest.cc',
    ],
    'language_usage_metrics_unittest_sources': [
      'language_usage_metrics/language_usage_metrics_unittest.cc',
    ],
    'leveldb_proto_unittest_sources': [
      'leveldb_proto/proto_database_impl_unittest.cc',
    ],
    'link_header_util_unittest_sources': [
      'link_header_util/link_header_util_unittest.cc',
    ],
    'login_unittest_sources': [
      'login/screens/screen_context_unittest.cc',
    ],
    'memory_coordinator_unittest_sources': [
      'memory_coordinator/child/child_memory_coordinator_impl_unittest.cc',
    ],
    'memory_pressure_unittest_sources': [
      'memory_pressure/direct_memory_pressure_calculator_linux_unittest.cc',
      'memory_pressure/direct_memory_pressure_calculator_win_unittest.cc',
      'memory_pressure/filtered_memory_pressure_calculator_unittest.cc',
      'memory_pressure/memory_pressure_monitor_unittest.cc',
      'memory_pressure/memory_pressure_stats_collector_unittest.cc',
      'memory_pressure/test_memory_pressure_calculator.cc',
      'memory_pressure/test_memory_pressure_calculator.h',
    ],
    'metrics_unittest_sources': [
      'metrics/call_stack_profile_metrics_provider_unittest.cc',
      'metrics/cloned_install_detector_unittest.cc',
      'metrics/daily_event_unittest.cc',
      'metrics/data_use_tracker_unittest.cc',
      'metrics/drive_metrics_provider_unittest.cc',
      'metrics/file_metrics_provider_unittest.cc',
      'metrics/histogram_encoder_unittest.cc',
      'metrics/machine_id_provider_win_unittest.cc',
      'metrics/metrics_log_manager_unittest.cc',
      'metrics/metrics_log_unittest.cc',
      'metrics/metrics_reporting_scheduler_unittest.cc',
      'metrics/metrics_service_unittest.cc',
      'metrics/metrics_state_manager_unittest.cc',
      'metrics/net/net_metrics_log_uploader_unittest.cc',
      'metrics/persisted_logs_unittest.cc',
      'metrics/profiler/profiler_metrics_provider_unittest.cc',
      'metrics/profiler/tracking_synchronizer_unittest.cc',
      'metrics/stability_metrics_helper_unittest.cc',
      'metrics/ui/screen_info_metrics_provider_unittest.cc',
    ],
    'metrics_leak_detector_unittest_sources': [
      'metrics/leak_detector/call_stack_manager_unittest.cc',
      'metrics/leak_detector/call_stack_table_unittest.cc',
      'metrics/leak_detector/leak_analyzer_unittest.cc',
      'metrics/leak_detector/leak_detector_impl_unittest.cc',
      'metrics/leak_detector/leak_detector_unittest.cc',
      'metrics/leak_detector/ranked_set_unittest.cc',
    ],
    'mime_util_unittest_sources': [
      'mime_util/mime_util_unittest.cc',
    ],
    'nacl_unittest_sources': [
      'nacl/browser/nacl_file_host_unittest.cc',
      'nacl/browser/nacl_process_host_unittest.cc',
      'nacl/browser/nacl_validation_cache_unittest.cc',
      'nacl/browser/pnacl_host_unittest.cc',
      'nacl/browser/pnacl_translation_cache_unittest.cc',
      'nacl/browser/test_nacl_browser_delegate.cc',
      'nacl/zygote/nacl_fork_delegate_linux_unittest.cc',
    ],
    'navigation_interception_unittest_sources': [
      'navigation_interception/intercept_navigation_throttle_unittest.cc',
    ],
    'network_hints_unittest_sources': [
      'network_hints/renderer/dns_prefetch_queue_unittest.cc',
      'network_hints/renderer/renderer_dns_prefetch_unittest.cc',
    ],
    'network_session_configurator_unittest_sources': [
      'network_session_configurator/network_session_configurator_unittest.cc',
    ],
    'network_time_unittest_sources': [
      'network_time/network_time_tracker_unittest.cc',
    ],
    'ntp_snippets_unittest_sources': [
      'ntp_snippets/ntp_snippet_unittest.cc',
      'ntp_snippets/ntp_snippets_database_unittest.cc',
      'ntp_snippets/ntp_snippets_fetcher_unittest.cc',
      'ntp_snippets/ntp_snippets_service_unittest.cc',
      'ntp_snippets/ntp_snippets_status_service_unittest.cc',
      'ntp_snippets/ntp_snippets_test_utils.cc',
      'ntp_snippets/ntp_snippets_test_utils.h',
    ],
    'ntp_tiles_unittest_sources': [
      'ntp_tiles/most_visited_sites_unittest.cc',
    ],
    'offline_pages_background_unittest_sources': [
      'offline_pages/background/request_coordinator_event_logger_unittest.cc',
      'offline_pages/background/request_coordinator_unittest.cc',
      'offline_pages/background/request_picker_unittest.cc',
      'offline_pages/background/request_queue_store_unittest.cc',
      'offline_pages/background/request_queue_unittest.cc',
      'offline_pages/background/save_page_request_unittest.cc',
    ],
    'offline_pages_unittest_sources': [
      'offline_pages/archive_manager_unittest.cc',
      'offline_pages/client_policy_controller_unittest.cc',
      'offline_pages/offline_page_metadata_store_impl_unittest.cc',
      'offline_pages/offline_page_model_event_logger_unittest.cc',
      'offline_pages/offline_page_model_impl_unittest.cc',
      'offline_pages/offline_page_storage_manager_unittest.cc',
      'offline_pages/snapshot_controller_unittest.cc',
    ],
    'omnibox_unittest_sources': [
      'omnibox/browser/answers_cache_unittest.cc',
      'omnibox/browser/autocomplete_input_unittest.cc',
      'omnibox/browser/autocomplete_match_unittest.cc',
      'omnibox/browser/autocomplete_provider_unittest.cc',
      'omnibox/browser/autocomplete_result_unittest.cc',
      'omnibox/browser/base_search_provider_unittest.cc',
      'omnibox/browser/bookmark_provider_unittest.cc',
      'omnibox/browser/builtin_provider_unittest.cc',
      'omnibox/browser/clipboard_url_provider_unittest.cc',
      'omnibox/browser/history_quick_provider_unittest.cc',
      'omnibox/browser/history_url_provider_unittest.cc',
      'omnibox/browser/in_memory_url_index_types_unittest.cc',
      'omnibox/browser/in_memory_url_index_unittest.cc',
      'omnibox/browser/keyword_provider_unittest.cc',
      'omnibox/browser/omnibox_edit_unittest.cc',
      'omnibox/browser/omnibox_field_trial_unittest.cc',
      'omnibox/browser/omnibox_popup_model_unittest.cc',
      'omnibox/browser/omnibox_view_unittest.cc',
      'omnibox/browser/scored_history_match_unittest.cc',
      'omnibox/browser/shortcuts_backend_unittest.cc',
      'omnibox/browser/shortcuts_database_unittest.cc',
      'omnibox/browser/shortcuts_provider_unittest.cc',
      'omnibox/browser/suggestion_answer_unittest.cc',
      'omnibox/browser/url_prefix_unittest.cc',
      'omnibox/browser/zero_suggest_provider_unittest.cc',
    ],
    'open_from_clipboard_unittest_sources': [
      'open_from_clipboard/clipboard_recent_content_ios_unittest.mm',
    ],
    'os_crypt_unittest_sources': [
      'os_crypt/ie7_password_win_unittest.cc',
      'os_crypt/keychain_password_mac_unittest.mm',
      'os_crypt/os_crypt_unittest.cc',
    ],
    'ownership_unittest_sources': [
      'ownership/owner_key_util_impl_unittest.cc',
    ],
    'packed_ct_ev_whitelist_unittest_sources': [
      'packed_ct_ev_whitelist/bit_stream_reader_unittest.cc',
      'packed_ct_ev_whitelist/packed_ct_ev_whitelist_unittest.cc',
    ],
    'page_load_metrics_unittest_sources': [
      'page_load_metrics/browser/metrics_web_contents_observer_unittest.cc',
      'page_load_metrics/renderer/fake_page_timing_metrics_ipc_sender.cc',
      'page_load_metrics/renderer/fake_page_timing_metrics_ipc_sender.h',
      'page_load_metrics/renderer/metrics_render_frame_observer_unittest.cc',
      'page_load_metrics/renderer/page_timing_metrics_sender_unittest.cc',
    ],
    'password_manager_unittest_sources': [
      'password_manager/content/browser/content_password_manager_driver_unittest.cc',
      'password_manager/content/browser/credential_manager_impl_unittest.cc',
      'password_manager/core/browser/affiliated_match_helper_unittest.cc',
      'password_manager/core/browser/affiliation_backend_unittest.cc',
      'password_manager/core/browser/affiliation_database_unittest.cc',
      'password_manager/core/browser/affiliation_fetch_throttler_unittest.cc',
      'password_manager/core/browser/affiliation_fetcher_unittest.cc',
      'password_manager/core/browser/affiliation_service_unittest.cc',
      'password_manager/core/browser/affiliation_utils_unittest.cc',
      'password_manager/core/browser/browser_save_password_progress_logger_unittest.cc',
      'password_manager/core/browser/export/csv_writer_unittest.cc',
      'password_manager/core/browser/export/password_csv_writer_unittest.cc',
      'password_manager/core/browser/export/password_exporter_unittest.cc',
      'password_manager/core/browser/facet_manager_unittest.cc',
      'password_manager/core/browser/form_saver_impl_unittest.cc',
      'password_manager/core/browser/import/csv_reader_unittest.cc',
      'password_manager/core/browser/import/password_csv_reader_unittest.cc',
      'password_manager/core/browser/import/password_importer_unittest.cc',
      'password_manager/core/browser/log_manager_unittest.cc',
      'password_manager/core/browser/log_router_unittest.cc',
      'password_manager/core/browser/login_database_ios_unittest.cc',
      'password_manager/core/browser/login_database_unittest.cc',
      'password_manager/core/browser/login_model_unittest.cc',
      'password_manager/core/browser/mock_affiliated_match_helper.cc',
      'password_manager/core/browser/mock_affiliated_match_helper.h',
      'password_manager/core/browser/password_autofill_manager_unittest.cc',
      'password_manager/core/browser/password_bubble_experiment_unittest.cc',
      'password_manager/core/browser/password_form_manager_unittest.cc',
      'password_manager/core/browser/password_generation_manager_unittest.cc',
      'password_manager/core/browser/password_manager_settings_migration_experiment_unittest.cc',
      'password_manager/core/browser/password_manager_unittest.cc',
      'password_manager/core/browser/password_manager_util_unittest.cc',
      'password_manager/core/browser/password_store_default_unittest.cc',
      'password_manager/core/browser/password_store_origin_unittest.h',
      'password_manager/core/browser/password_store_unittest.cc',
      'password_manager/core/browser/password_syncable_service_unittest.cc',
      'password_manager/core/browser/password_ui_utils_unittest.cc',
      'password_manager/core/browser/psl_matching_helper_unittest.cc',
      'password_manager/core/browser/statistics_table_unittest.cc',
      'password_manager/core/common/credential_manager_types_unittest.cc',
      'password_manager/sync/browser/password_manager_setting_migrator_service_unittest.cc',
      'password_manager/sync/browser/password_sync_util_unittest.cc',
      'password_manager/sync/browser/sync_credentials_filter_unittest.cc',
      'password_manager/sync/browser/sync_username_test_base.cc',
      'password_manager/sync/browser/sync_username_test_base.h',
    ],
    'policy_unittest_sources': [
      'policy/core/browser/android/android_combined_policy_provider_unittest.cc',
      'policy/core/browser/android/policy_converter_unittest.cc',
      'policy/core/browser/autofill_policy_handler_unittest.cc',
      'policy/core/browser/browser_policy_connector_unittest.cc',
      'policy/core/browser/configuration_policy_handler_unittest.cc',
      'policy/core/browser/configuration_policy_pref_store_unittest.cc',
      'policy/core/browser/proxy_policy_handler_unittest.cc',
      'policy/core/browser/url_blacklist_manager_unittest.cc',
      'policy/core/browser/url_blacklist_policy_handler_unittest.cc',
      'policy/core/common/async_policy_provider_unittest.cc',
      'policy/core/common/cloud/cloud_policy_client_unittest.cc',
      'policy/core/common/cloud/cloud_policy_constants_unittest.cc',
      'policy/core/common/cloud/cloud_policy_core_unittest.cc',
      'policy/core/common/cloud/cloud_policy_manager_unittest.cc',
      'policy/core/common/cloud/cloud_policy_refresh_scheduler_unittest.cc',
      'policy/core/common/cloud/cloud_policy_service_unittest.cc',
      'policy/core/common/cloud/cloud_policy_validator_unittest.cc',
      'policy/core/common/cloud/component_cloud_policy_service_unittest.cc',
      'policy/core/common/cloud/component_cloud_policy_store_unittest.cc',
      'policy/core/common/cloud/component_cloud_policy_updater_unittest.cc',
      'policy/core/common/cloud/device_management_service_unittest.cc',
      'policy/core/common/cloud/external_policy_data_fetcher_unittest.cc',
      'policy/core/common/cloud/external_policy_data_updater_unittest.cc',
      'policy/core/common/cloud/policy_header_io_helper_unittest.cc',
      'policy/core/common/cloud/policy_header_service_unittest.cc',
      'policy/core/common/cloud/resource_cache_unittest.cc',
      'policy/core/common/cloud/user_cloud_policy_manager_unittest.cc',
      'policy/core/common/cloud/user_cloud_policy_store_unittest.cc',
      'policy/core/common/cloud/user_info_fetcher_unittest.cc',
      'policy/core/common/config_dir_policy_loader_unittest.cc',
      'policy/core/common/generate_policy_source_unittest.cc',
      'policy/core/common/policy_bundle_unittest.cc',
      'policy/core/common/policy_loader_ios_unittest.mm',
      'policy/core/common/policy_loader_mac_unittest.cc',
      'policy/core/common/policy_loader_win_unittest.cc',
      'policy/core/common/policy_map_unittest.cc',
      'policy/core/common/policy_service_impl_unittest.cc',
      'policy/core/common/policy_statistics_collector_unittest.cc',
      'policy/core/common/preg_parser_win_unittest.cc',
      'policy/core/common/registry_dict_win_unittest.cc',
      'policy/core/common/remote_commands/remote_commands_queue_unittest.cc',
      'policy/core/common/remote_commands/remote_commands_service_unittest.cc',
      'policy/core/common/schema_map_unittest.cc',
      'policy/core/common/schema_registry_tracking_policy_provider_unittest.cc',
      'policy/core/common/schema_registry_unittest.cc',
      'policy/core/common/schema_unittest.cc',
    ],
    'power_unittest_sources': [
      'power/origin_power_map_unittest.cc',
    ],
    'precache_unittest_sources': [
      'precache/content/precache_manager_unittest.cc',
      'precache/core/fetcher_pool_unittest.cc',
      'precache/core/precache_database_unittest.cc',
      'precache/core/precache_fetcher_unittest.cc',
      'precache/core/precache_session_table_unittest.cc',
      'precache/core/precache_url_table_unittest.cc',
    ],
    'user_prefs_unittest_sources': [
      'user_prefs/tracked/device_id_unittest.cc',
      'user_prefs/tracked/pref_hash_calculator_unittest.cc',
      'user_prefs/tracked/pref_hash_filter_unittest.cc',
      'user_prefs/tracked/pref_hash_store_impl_unittest.cc',
      'user_prefs/tracked/pref_service_hash_store_contents_unittest.cc',
      'user_prefs/tracked/segregated_pref_store_unittest.cc',
      'user_prefs/tracked/tracked_preferences_migration_unittest.cc',
    ],
    'proximity_auth_unittest_sources': [
      'proximity_auth/ble/bluetooth_low_energy_characteristics_finder_unittest.cc',
      'proximity_auth/ble/bluetooth_low_energy_connection_finder_unittest.cc',
      'proximity_auth/ble/bluetooth_low_energy_connection_unittest.cc',
      'proximity_auth/ble/bluetooth_low_energy_device_whitelist_unittest.cc',
      'proximity_auth/ble/bluetooth_low_energy_weave_packet_generator_unittest.cc',
      'proximity_auth/ble/bluetooth_low_energy_weave_packet_receiver_unittest.cc',
      'proximity_auth/bluetooth_connection_finder_unittest.cc',
      'proximity_auth/bluetooth_connection_unittest.cc',
      'proximity_auth/bluetooth_throttler_impl_unittest.cc',
      'proximity_auth/connection_unittest.cc',
      'proximity_auth/cryptauth/cryptauth_access_token_fetcher_impl_unittest.cc',
      'proximity_auth/cryptauth/cryptauth_api_call_flow_unittest.cc',
      'proximity_auth/cryptauth/cryptauth_client_impl_unittest.cc',
      'proximity_auth/cryptauth/cryptauth_device_manager_unittest.cc',
      'proximity_auth/cryptauth/cryptauth_enroller_impl_unittest.cc',
      'proximity_auth/cryptauth/cryptauth_enrollment_manager_unittest.cc',
      'proximity_auth/cryptauth/cryptauth_gcm_manager_impl_unittest.cc',
      'proximity_auth/cryptauth/fake_secure_message_delegate_unittest.cc',
      'proximity_auth/cryptauth/sync_scheduler_impl_unittest.cc',
      'proximity_auth/device_to_device_authenticator_unittest.cc',
      'proximity_auth/device_to_device_operations_unittest.cc',
      'proximity_auth/device_to_device_operations_unittest.cc',
      'proximity_auth/device_to_device_secure_context_unittest.cc',
      'proximity_auth/logging/logging_unittest.cc',
      'proximity_auth/messenger_impl_unittest.cc',
      'proximity_auth/proximity_auth_pref_manager_unittest.cc',
      'proximity_auth/proximity_auth_system_unittest.cc',
      'proximity_auth/proximity_monitor_impl_unittest.cc',
      'proximity_auth/remote_device_life_cycle_impl_unittest.cc',
      'proximity_auth/remote_device_loader_unittest.cc',
      'proximity_auth/remote_status_update_unittest.cc',
      'proximity_auth/throttled_bluetooth_connection_finder_unittest.cc',
      'proximity_auth/unlock_manager_unittest.cc',
      'proximity_auth/wire_message_unittest.cc',
    ],
    'proxy_config_unittest_sources': [
      'proxy_config/pref_proxy_config_tracker_impl_unittest.cc',
      'proxy_config/proxy_config_dictionary_unittest.cc',
      'proxy_config/proxy_prefs_unittest.cc',
    ],
    'prefs_unittest_sources': [
      'prefs/default_pref_store_unittest.cc',
      'prefs/in_memory_pref_store_unittest.cc',
      'prefs/json_pref_store_unittest.cc',
      'prefs/overlay_user_pref_store_unittest.cc',
      'prefs/pref_change_registrar_unittest.cc',
      'prefs/pref_member_unittest.cc',
      'prefs/pref_notifier_impl_unittest.cc',
      'prefs/pref_service_unittest.cc',
      'prefs/pref_value_map_unittest.cc',
      'prefs/pref_value_store_unittest.cc',
      'prefs/scoped_user_pref_update_unittest.cc',
    ],
    'query_parser_unittest_sources': [
      'query_parser/query_parser_unittest.cc',
      'query_parser/snippet_unittest.cc',
    ],
    'rappor_unittest_sources': [
      'rappor/bloom_filter_unittest.cc',
      'rappor/byte_vector_utils_unittest.cc',
      'rappor/log_uploader_unittest.cc',
      'rappor/rappor_metric_unittest.cc',
      'rappor/rappor_prefs_unittest.cc',
      'rappor/rappor_service_unittest.cc',
      'rappor/rappor_utils_unittest.cc',
      'rappor/reports_unittest.cc',
      'rappor/sampler_unittest.cc',
    ],
    'rlz_unittest_sources': [
      'rlz/rlz_tracker_unittest.cc',
    ],
    'safe_browsing_db_mobile_unittest_sources': [
      'safe_browsing_db/remote_database_manager_unittest.cc',
      'safe_browsing_db/safe_browsing_api_handler_unittest.cc',
    ],
    'safe_browsing_db_unittest_sources': [
      'safe_browsing_db/database_manager_unittest.cc',
      'safe_browsing_db/prefix_set_unittest.cc',
      'safe_browsing_db/testing_util.h',
      'safe_browsing_db/util_unittest.cc',
      'safe_browsing_db/v4_database_unittest.cc',
      'safe_browsing_db/v4_get_hash_protocol_manager_unittest.cc',
      'safe_browsing_db/v4_protocol_manager_util_unittest.cc',
      'safe_browsing_db/v4_store_unittest.cc',
      'safe_browsing_db/v4_update_protocol_manager_unittest.cc',
    ],
    'safe_json_unittest_sources': [
      'safe_json/json_sanitizer_unittest.cc',
      'safe_json/testing_json_parser_unittest.cc',
    ],
    'scheduler_unittest_sources': [
      'scheduler/base/task_queue_manager_delegate_for_test.cc',
      'scheduler/base/task_queue_manager_delegate_for_test.h',
      'scheduler/base/task_queue_manager_unittest.cc',
      'scheduler/base/task_queue_selector_unittest.cc',
      'scheduler/base/test_always_fail_time_source.cc',
      'scheduler/base/test_always_fail_time_source.h',
      'scheduler/base/test_time_source.cc',
      'scheduler/base/test_time_source.h',
      'scheduler/base/time_domain_unittest.cc',
      'scheduler/base/work_queue_sets_unittest.cc',
      'scheduler/child/idle_helper_unittest.cc',
      'scheduler/child/scheduler_helper_unittest.cc',
      'scheduler/child/scheduler_tqm_delegate_for_test.cc',
      'scheduler/child/scheduler_tqm_delegate_for_test.h',
      'scheduler/child/scheduler_tqm_delegate_impl_unittest.cc',
      'scheduler/child/webthread_impl_for_worker_scheduler_unittest.cc',
      'scheduler/child/worker_scheduler_impl_unittest.cc',
      'scheduler/renderer/auto_advancing_virtual_time_domain_unittest.cc',
      'scheduler/renderer/deadline_task_runner_unittest.cc',
      'scheduler/renderer/idle_time_estimator_unittest.cc',
      'scheduler/renderer/render_widget_signals_unittest.cpp',
      'scheduler/renderer/renderer_scheduler_impl_unittest.cc',
      'scheduler/renderer/task_cost_estimator_unittest.cc',
      'scheduler/renderer/throttling_helper_unittest.cc',
      'scheduler/renderer/user_model_unittest.cc',
      'scheduler/renderer/web_view_scheduler_impl_unittest.cc',
      'scheduler/renderer/webthread_impl_for_renderer_scheduler_unittest.cc',
    ],
    'search_unittest_sources': [
      'search/search_android_unittest.cc',
      'search/search_unittest.cc',
    ],
    'search_engines_unittest_sources': [
      'search_engines/default_search_manager_unittest.cc',
      'search_engines/default_search_policy_handler_unittest.cc',
      'search_engines/default_search_pref_migration_unittest.cc',
      'search_engines/keyword_table_unittest.cc',
      'search_engines/search_engine_data_type_controller_unittest.cc',
      'search_engines/search_host_to_urls_map_unittest.cc',
      'search_engines/template_url_prepopulate_data_unittest.cc',
      'search_engines/template_url_service_util_unittest.cc',
      'search_engines/template_url_unittest.cc',
    ],
    'search_provider_logos_unittest_sources': [
      'search_provider_logos/logo_cache_unittest.cc',
      'search_provider_logos/logo_tracker_unittest.cc',
    ],
    'security_state_unittest_sources': [
      'security_state/security_state_model_unittest.cc',
    ],
    'sessions_unittest_sources': [
      'sessions/content/content_serialized_navigation_builder_unittest.cc',
      'sessions/content/content_serialized_navigation_driver_unittest.cc',
      'sessions/core/serialized_navigation_entry_unittest.cc',
      'sessions/core/session_backend_unittest.cc',
      'sessions/core/session_types_unittest.cc',
      'sessions/ios/ios_serialized_navigation_builder_unittest.mm',
      'sessions/ios/ios_serialized_navigation_driver_unittest.cc',
    ],
    'signin_unittest_sources': [
      'signin/core/browser/account_info_unittest.cc',
      'signin/core/browser/account_investigator_unittest.cc',
      'signin/core/browser/account_tracker_service_unittest.cc',
      'signin/core/browser/gaia_cookie_manager_service_unittest.cc',
      'signin/core/browser/refresh_token_annotation_request_unittest.cc',
      'signin/core/browser/signin_error_controller_unittest.cc',
      'signin/core/browser/signin_investigator_unittest.cc',
      'signin/core/browser/signin_status_metrics_provider_unittest.cc',
      'signin/core/browser/webdata/token_service_table_unittest.cc',
      'signin/ios/browser/account_consistency_service_unittest.mm',
      'signin/ios/browser/profile_oauth2_token_service_ios_delegate_unittest.mm',
    ],
    'ssl_config_unittest_sources': [
      'ssl_config/ssl_config_service_manager_pref_unittest.cc',
    ],
    'ssl_errors_unittest_sources': [
      'ssl_errors/error_classification_unittest.cc'
    ],
    'storage_monitor_unittest_sources': [
      'storage_monitor/image_capture_device_manager_unittest.mm',
      'storage_monitor/media_storage_util_unittest.cc',
      'storage_monitor/media_transfer_protocol_device_observer_linux_unittest.cc',
      'storage_monitor/storage_info_unittest.cc',
      'storage_monitor/storage_monitor_chromeos_unittest.cc',
      'storage_monitor/storage_monitor_linux_unittest.cc',
      'storage_monitor/storage_monitor_mac_unittest.mm',
      'storage_monitor/storage_monitor_unittest.cc',
      'storage_monitor/storage_monitor_win_unittest.cc',
    ],
    'subresource_filter_content_browser_unittest_sources': [
      'subresource_filter/content/browser/content_ruleset_distributor_unittest.cc',
      'subresource_filter/content/browser/content_subresource_filter_driver_factory_unittest.cc',
    ],
    'subresource_filter_core_browser_unittest_sources': [
      'subresource_filter/core/browser/ruleset_service_unittest.cc',
      'subresource_filter/core/browser/subresource_filter_features_unittest.cc',
    ],
    'subresource_filter_core_common_unittest_sources': [
      'subresource_filter/core/common/closed_hash_map_unittest.cc',
      'subresource_filter/core/common/fuzzy_pattern_matching_unittest.cc',
      'subresource_filter/core/common/knuth_morris_pratt_unittest.cc',
      'subresource_filter/core/common/ngram_extractor_unittest.cc',
      'subresource_filter/core/common/string_splitter_unittest.cc',
    ],
    'suggestions_unittest_sources': [
      'suggestions/blacklist_store_unittest.cc',
      'suggestions/image_manager_unittest.cc',
      'suggestions/suggestions_service_unittest.cc',
      'suggestions/suggestions_store_unittest.cc',
    ],
    'supervised_user_error_page_unittest_sources': [
      'supervised_user_error_page/supervised_user_error_page_unittest.cc',
    ],
    'sync_bookmarks_unittest_sources': [
      'sync_bookmarks/bookmark_data_type_controller_unittest.cc',
    ],
    'sync_driver_unittest_sources': [
      'sync_driver/about_sync_util_unittest.cc',
      'sync_driver/backend_migrator_unittest.cc',
      'sync_driver/data_type_manager_impl_unittest.cc',
      'sync_driver/device_count_metrics_provider_unittest.cc',
      'sync_driver/device_info_data_type_controller_unittest.cc',
      'sync_driver/device_info_service_unittest.cc',
      'sync_driver/device_info_sync_service_unittest.cc',
      'sync_driver/device_info_util_unittest.cc',
      'sync_driver/frontend_data_type_controller_unittest.cc',
      'sync_driver/generic_change_processor_unittest.cc',
      'sync_driver/glue/browser_thread_model_worker_unittest.cc',
      'sync_driver/glue/sync_backend_host_impl_unittest.cc',
      'sync_driver/glue/sync_backend_registrar_unittest.cc',
      'sync_driver/glue/ui_model_worker_unittest.cc',
      'sync_driver/local_device_info_provider_unittest.cc',
      'sync_driver/model_association_manager_unittest.cc',
      'sync_driver/non_blocking_data_type_controller_unittest.cc',
      'sync_driver/non_ui_data_type_controller_unittest.cc',
      'sync_driver/non_ui_model_type_controller_unittest.cc',
      'sync_driver/profile_sync_auth_provider_unittest.cc',
      'sync_driver/shared_change_processor_unittest.cc',
      'sync_driver/startup_controller_unittest.cc',
      'sync_driver/sync_prefs_unittest.cc',
      'sync_driver/sync_stopped_reporter_unittest.cc',
      'sync_driver/sync_util_unittest.cc',
      'sync_driver/system_encryptor_unittest.cc',
      'sync_driver/ui_data_type_controller_unittest.cc',
      'sync_driver/ui_model_type_controller_unittest.cc',
    ],
    'sync_sessions_unittest_sources': [
      'sync_sessions/favicon_cache_unittest.cc',
      'sync_sessions/revisit/bookmarks_page_revisit_observer_unittest.cc',
      'sync_sessions/revisit/current_tab_matcher_unittest.cc',
      'sync_sessions/revisit/offset_tab_matcher_unittest.cc',
      'sync_sessions/revisit/page_revisit_broadcaster_unittest.cc',
      'sync_sessions/revisit/sessions_page_revisit_observer_unittest.cc',
      'sync_sessions/revisit/typed_url_page_revisit_task_unittest.cc',
      'sync_sessions/session_data_type_controller_unittest.cc',
      'sync_sessions/sync_sessions_metrics_unittest.cc',
      'sync_sessions/synced_session_tracker_unittest.cc',
      'sync_sessions/tab_node_pool_unittest.cc',
    ],
    'syncable_prefs_unittest_sources': [
      'syncable_prefs/pref_model_associator_unittest.cc',
      'syncable_prefs/pref_service_syncable_unittest.cc',
    ],
    'tracing_unittest_sources': [
      'tracing/browser/trace_config_file_unittest.cc',
      'tracing/common/graphics_memory_dump_provider_android_unittest.cc',
      'tracing/common/process_metrics_memory_dump_provider_unittest.cc',
      'tracing/core/trace_ring_buffer_unittest.cc',
      'tracing/core/scattered_stream_writer_unittest.cc',
    ],
    'translate_unittest_sources': [
      'translate/core/browser/language_state_unittest.cc',
      'translate/core/browser/mock_translate_driver.cc',
      'translate/core/browser/translate_browser_metrics_unittest.cc',
      'translate/core/browser/translate_language_list_unittest.cc',
      'translate/core/browser/translate_manager_unittest.cc',
      'translate/core/browser/translate_prefs_unittest.cc',
      'translate/core/browser/translate_script_unittest.cc',
      'translate/core/browser/translate_ui_delegate_unittest.cc',
      'translate/core/common/translate_metrics_unittest.cc',
      'translate/core/common/translate_util_unittest.cc',
      'translate/core/language_detection/language_detection_util_unittest.cc',
      'translate/ios/browser/js_translate_manager_unittest.mm',
      'translate/ios/browser/language_detection_controller_unittest.mm',
      'translate/ios/browser/translate_controller_unittest.mm',
    ],
    'zoom_unittest_sources': [
      'zoom/page_zoom_unittests.cc',
    ],
    'update_client_unittest_sources': [
      'update_client/component_patcher_unittest.cc',
      'update_client/crx_downloader_unittest.cc',
      'update_client/persisted_data_unittest.cc',
      'update_client/ping_manager_unittest.cc',
      'update_client/request_sender_unittest.cc',
      'update_client/update_checker_unittest.cc',
      'update_client/update_client_unittest.cc',
      'update_client/update_query_params_unittest.cc',
      'update_client/update_response_unittest.cc',
      'update_client/utils_unittest.cc',
    ],
    'upload_list_unittest_sources': [
      'upload_list/upload_list_unittest.cc',
    ],
    'url_formatter_unittest_sources': [
      'url_formatter/elide_url_unittest.cc',
      'url_formatter/url_fixer_unittest.cc',
      'url_formatter/url_formatter_unittest.cc',
    ],
    'url_matcher_unittest_sources': [
      'url_matcher/regex_set_matcher_unittest.cc',
      'url_matcher/string_pattern_unittest.cc',
      'url_matcher/substring_set_matcher_unittest.cc',
      'url_matcher/url_matcher_factory_unittest.cc',
      'url_matcher/url_matcher_unittest.cc',
    ],
    'user_manager_unittest_sources': [
      'user_manager/user_unittest.cc',
    ],
    'variations_unittest_sources': [
      'variations/active_field_trials_unittest.cc',
      'variations/caching_permuted_entropy_provider_unittest.cc',
      'variations/entropy_provider_unittest.cc',
      'variations/experiment_labels_unittest.cc',
      'variations/metrics_util_unittest.cc',
      'variations/net/variations_http_headers_unittest.cc',
      'variations/service/ui_string_overrider_unittest.cc',
      'variations/service/variations_service_unittest.cc',
      'variations/study_filtering_unittest.cc',
      'variations/variations_associated_data_unittest.cc',
      'variations/variations_http_header_provider_unittest.cc',
      'variations/variations_request_scheduler_mobile_unittest.cc',
      'variations/variations_request_scheduler_unittest.cc',
      'variations/variations_seed_processor_unittest.cc',
      'variations/variations_seed_simulator_unittest.cc',
      'variations/variations_seed_store_unittest.cc',
    ],
    'visitedlink_unittest_sources': [
      'visitedlink/test/visitedlink_unittest.cc',
    ],
    'wallpaper_unittest_sources': [
      'wallpaper/wallpaper_resizer_unittest.cc',
    ],
    'web_cache_unittest_sources': [
      'web_cache/browser/web_cache_manager_unittest.cc',
    ],
    'web_modal_unittest_sources': [
      'web_modal/web_contents_modal_dialog_manager_unittest.cc',
    ],
    'web_resource_unittest_sources': [
      'web_resource/eula_accepted_notifier_unittest.cc',
      'web_resource/resource_request_allowed_notifier_unittest.cc',
    ],
    'web_restrictions_unittest_sources' : [
      'web_restrictions/browser/web_restrictions_client_unittest.cc',
      'web_restrictions/browser/web_restrictions_resource_throttle_unittest.cc',
    ],
    'webcrypto_unittest_sources': [
      'webcrypto/algorithms/aes_cbc_unittest.cc',
      'webcrypto/algorithms/aes_ctr_unittest.cc',
      'webcrypto/algorithms/aes_gcm_unittest.cc',
      'webcrypto/algorithms/aes_kw_unittest.cc',
      'webcrypto/algorithms/ecdh_unittest.cc',
      'webcrypto/algorithms/ecdsa_unittest.cc',
      'webcrypto/algorithms/hmac_unittest.cc',
      'webcrypto/algorithms/rsa_oaep_unittest.cc',
      'webcrypto/algorithms/rsa_pss_unittest.cc',
      'webcrypto/algorithms/rsa_ssa_unittest.cc',
      'webcrypto/algorithms/sha_unittest.cc',
      'webcrypto/algorithms/test_helpers.cc',
      'webcrypto/algorithms/test_helpers.h',
      'webcrypto/status_unittest.cc',
    ],
    'webdata_unittest_sources': [
      'webdata/common/web_database_migration_unittest.cc',
    ],
    'webusb_detector_unittest_sources': [
      'webusb/webusb_detector_unittest.cc',
    ],
  },
  'targets': [
    {
      # GN version: //components:components_tests_pak
      'target_name': 'components_tests_pak',
      'type': 'none',
      'dependencies': [
        'components_resources.gyp:components_resources',
        'components_strings.gyp:components_strings',
      ],
      'actions': [
        {
          'action_name': 'repack_components_tests_pak',
          'variables': {
            'pak_inputs': [
              '<(SHARED_INTERMEDIATE_DIR)/components/components_resources.pak',
              '<(SHARED_INTERMEDIATE_DIR)/components/strings/components_strings_en-US.pak',
            ],
            'pak_output': '<(PRODUCT_DIR)/components_tests_resources.pak',
          },
          'includes': [ '../build/repack_action.gypi' ],
        },
      ],
      'direct_dependent_settings': {
        'mac_bundle_resources': [
          '<(PRODUCT_DIR)/components_tests_resources.pak',
        ],
      },
    },
    {
      # GN version: //components:components_unittests
      'target_name': 'components_unittests',
      'type': '<(gtest_target_type)',
      'sources': [
        'test/run_all_unittests.cc',

        '<@(auto_login_parser_unittest_sources)',
        '<@(autofill_unittest_sources)',
        '<@(base32_unittest_sources)',
        '<@(bookmarks_unittest_sources)',
        '<@(browser_sync_unittest_sources)',
        '<@(browser_watcher_unittest_sources)',
        '<@(browsing_data_ui_unittest_sources)',
        '<@(bubble_unittest_sources)',
        '<@(captive_portal_unittest_sources)',
        '<@(cast_certificate_unittest_sources)',
        '<@(certificate_reporting_unittest_sources)',
        '<@(client_update_protocol_unittest_sources)',
        '<@(cloud_devices_unittest_sources)',
        '<@(component_updater_unittest_sources)',
        '<@(content_settings_unittest_sources)',
        '<@(crash_unittest_sources)',
        '<@(crx_file_unittest_sources)',
        '<@(data_reduction_proxy_unittest_sources)',
        '<@(data_usage_unittest_sources)',
        '<@(data_use_measurement_unittest_sources)',
        '<@(device_event_log_unittest_sources)',
        '<@(dom_distiller_unittest_sources)',
        '<@(favicon_base_unittest_sources)',
        '<@(favicon_unittest_sources)',
        '<@(flags_ui_unittest_sources)',
        '<@(gcm_driver_crypto_unittest_sources)',
        '<@(gcm_driver_unittest_sources)',
        '<@(google_unittest_sources)',
        '<@(history_unittest_sources)',
	'<@(image_fetcher_unittest_sources)',
        '<@(instance_id_unittest_sources)',
        '<@(json_schema_unittest_sources)',
        '<@(keyed_service_unittest_sources)',
        '<@(language_usage_metrics_unittest_sources)',
        '<@(leveldb_proto_unittest_sources)',
        '<@(link_header_util_unittest_sources)',
        '<@(login_unittest_sources)',
        '<@(memory_pressure_unittest_sources)',
        '<@(metrics_unittest_sources)',
        '<@(mime_util_unittest_sources)',
        '<@(network_session_configurator_unittest_sources)',
        '<@(network_time_unittest_sources)',
        '<@(ntp_snippets_unittest_sources)',
        '<@(offline_pages_background_unittest_sources)',
        '<@(offline_pages_unittest_sources)',
        '<@(omnibox_unittest_sources)',
        '<@(open_from_clipboard_unittest_sources)',
        '<@(os_crypt_unittest_sources)',
        '<@(password_manager_unittest_sources)',
        '<@(precache_unittest_sources)',
        '<@(proxy_config_unittest_sources)',
        '<@(prefs_unittest_sources)',
        '<@(query_parser_unittest_sources)',
        '<@(rappor_unittest_sources)',
        '<@(search_engines_unittest_sources)',
        '<@(search_provider_logos_unittest_sources)',
        '<@(search_unittest_sources)',
        '<@(security_state_unittest_sources)',
        '<@(sessions_unittest_sources)',
        '<@(signin_unittest_sources)',
        '<@(ssl_config_unittest_sources)',
        '<@(ssl_errors_unittest_sources)',
        '<@(subresource_filter_core_browser_unittest_sources)',
        '<@(subresource_filter_core_common_unittest_sources)',
        '<@(suggestions_unittest_sources)',
        '<@(supervised_user_error_page_unittest_sources)',
        '<@(sync_bookmarks_unittest_sources)',
        '<@(sync_driver_unittest_sources)',
        '<@(sync_sessions_unittest_sources)',
        '<@(syncable_prefs_unittest_sources)',
        '<@(translate_unittest_sources)',
        '<@(undo_unittest_sources)',
        '<@(update_client_unittest_sources)',
        '<@(upload_list_unittest_sources)',
        '<@(url_formatter_unittest_sources)',
        '<@(url_matcher_unittest_sources)',
        '<@(user_prefs_unittest_sources)',
        '<@(variations_unittest_sources)',
        '<@(web_resource_unittest_sources)',
        '<@(webdata_unittest_sources)',
        'net_log/net_log_temp_file_unittest.cc',
      ],
      'include_dirs': [
        '..',
      ],
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:test_support_base',
        '../google_apis/google_apis.gyp:google_apis_test_support',
        '../jingle/jingle.gyp:notifier_test_util',
        '../net/net.gyp:net_test_support',
        '../sql/sql.gyp:test_support_sql',
        '../sync/sync.gyp:sync',
        '../sync/sync.gyp:test_support_sync_api',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
        '../third_party/libaddressinput/libaddressinput.gyp:libaddressinput_util',
        '../third_party/libjingle/libjingle.gyp:libjingle',
        '../third_party/libphonenumber/libphonenumber.gyp:libphonenumber',
        '../third_party/protobuf/protobuf.gyp:protobuf_lite',
        '../third_party/re2/re2.gyp:re2',
        '../ui/base/ui_base.gyp:ui_base',
        '../ui/gfx/gfx.gyp:gfx',
        '../ui/gfx/gfx.gyp:gfx_test_support',
        '../ui/resources/ui_resources.gyp:ui_resources',
        '../ui/resources/ui_resources.gyp:ui_test_pak',
        '../ui/strings/ui_strings.gyp:ui_strings',
        '../url/url.gyp:url_lib',
        'components.gyp:auto_login_parser',
        'components.gyp:autofill_core_browser',
        'components.gyp:autofill_core_common',
        'components.gyp:autofill_core_test_support',
        'components.gyp:base32',
        'components.gyp:bookmarks_browser',
        'components.gyp:bookmarks_managed',
        'components.gyp:bookmarks_test_support',
        'components.gyp:browser_sync_browser',
        'components.gyp:browser_sync_browser_test_support',
        'components.gyp:browsing_data_ui',
        'components.gyp:bubble',
        'components.gyp:captive_portal_test_support',
        'components.gyp:cast_certificate',
        'components.gyp:certificate_reporting',
        'components.gyp:cloud_devices_common',
        'components.gyp:component_updater',
        'components.gyp:component_updater_test_support',
        'components.gyp:content_settings_core_browser',
        'components.gyp:content_settings_core_common',
        'components.gyp:content_settings_core_test_support',
        'components.gyp:crash_core_common',
        'components.gyp:crx_file',
        'components.gyp:data_reduction_proxy_core_browser',
        'components.gyp:data_reduction_proxy_core_common',
        'components.gyp:data_reduction_proxy_test_support',
        'components.gyp:data_usage_core',
        'components.gyp:data_use_measurement_core',
        'components.gyp:device_event_log_component',
        'components.gyp:dom_distiller_core',
        'components.gyp:dom_distiller_protos',
        'components.gyp:dom_distiller_test_support',
        'components.gyp:favicon_base',
        'components.gyp:favicon_core',
        'components.gyp:flags_ui',
        'components.gyp:gcm_driver',
        'components.gyp:gcm_driver_test_support',
        'components.gyp:google_core_browser',
        'components.gyp:history_core_browser',
        'components.gyp:history_core_common',
        'components.gyp:history_core_test_support',
        'components.gyp:image_fetcher',
        'components.gyp:instance_id_test_support',
        'components.gyp:invalidation_impl',
        'components.gyp:invalidation_test_support',
        'components.gyp:json_schema',
        'components.gyp:keyed_service_core',
        'components.gyp:language_usage_metrics',
        'components.gyp:leveldb_proto',
        'components.gyp:leveldb_proto_test_support',
        'components.gyp:login',
        'components.gyp:memory_pressure',
        'components.gyp:metrics',
        'components.gyp:metrics_net',
        'components.gyp:metrics_profiler',
        'components.gyp:metrics_test_support',
        'components.gyp:metrics_ui',
        'components.gyp:net_log',
        'components.gyp:network_session_configurator',
        'components.gyp:network_time',
        'components.gyp:ntp_snippets',
        'components.gyp:offline_pages',
        'components.gyp:offline_pages_background_offliner',
        'components.gyp:offline_pages_test_support',
        'components.gyp:omnibox_browser',
        'components.gyp:omnibox_test_support',
        'components.gyp:open_from_clipboard',
        'components.gyp:open_from_clipboard_test_support',
        'components.gyp:os_crypt',
        'components.gyp:os_crypt_test_support',
        'components.gyp:password_manager_core_browser',
        'components.gyp:password_manager_core_browser_test_support',
        'components.gyp:password_manager_sync_browser',
        'components.gyp:precache_core',
        'components.gyp:pref_registry_test_support',
        'components.gyp:proxy_config',
        'components.gyp:query_parser',
        'components.gyp:rappor',
        'components.gyp:rappor_test_support',
        'components.gyp:search',
        'components.gyp:search_engines',
        'components.gyp:search_engines_test_support',
        'components.gyp:search_provider_logos',
        'components.gyp:security_state',
        'components.gyp:sessions_test_support',
        'components.gyp:signin_core_browser',
        'components.gyp:signin_core_browser_test_support',
        'components.gyp:ssl_config',
        'components.gyp:ssl_errors',
        'components.gyp:subresource_filter_core_browser_test_support',
        'components.gyp:subresource_filter_core_browser',
        'components.gyp:subresource_filter_core_common',
        'components.gyp:suggestions',
        'components.gyp:supervised_user_error_page',
        'components.gyp:sync_bookmarks',
        'components.gyp:sync_driver',
        'components.gyp:sync_driver_test_support',
        'components.gyp:sync_sessions',
        'components.gyp:sync_sessions_test_support',
        'components.gyp:syncable_prefs_test_support',
        'components.gyp:toolbar_test_support',
        'components.gyp:translate_core_browser',
        'components.gyp:translate_core_common',
        'components.gyp:translate_core_language_detection',
        'components.gyp:undo_component',
        'components.gyp:update_client',
        'components.gyp:update_client_test_support',
        'components.gyp:upload_list',
        'components.gyp:url_matcher',
        'components.gyp:user_prefs_tracked',
        'components.gyp:user_prefs_tracked_test_support',
        'components.gyp:variations',
        'components.gyp:variations_net',
        'components.gyp:variations_service',
        'components.gyp:version_info',
        'components.gyp:webdata_services_test_support',
        'components.gyp:web_resource',
        'components.gyp:web_resource_test_support',
        'components_resources.gyp:components_resources',
        'components_strings.gyp:components_strings',
        'components_tests_pak',
        'link_header_util/link_header_util.gyp:link_header_util',
        'mime_util/mime_util.gyp:mime_util',
        'prefs/prefs.gyp:prefs',
        'prefs/prefs.gyp:prefs_test_support',
        'url_formatter/url_formatter.gyp:url_formatter',
      ],
      'conditions': [
        ['OS!="mac" and OS!="ios"', {
          'sources!': [
            'crash/core/common/objc_zombie_unittest.mm',
          ],
        }],
        ['enable_rlz_support==1', {
          'sources': [
            '<@(rlz_unittest_sources)',
          ],
          'dependencies': [
            '../net/net.gyp:net_test_support',
            '../rlz/rlz.gyp:test_support_rlz',
            'components.gyp:rlz',
          ],
          'conditions': [
            ['OS == "ios"', {
              'dependencies': [
                '../ui/base/ui_base.gyp:ui_base',
              ],
            }],
          ],
        }],
        ['toolkit_views == 1', {
          'sources': [
            'bookmarks/browser/bookmark_node_data_unittest.cc',
            'constrained_window/constrained_window_views_unittest.cc',
          ],
          'dependencies': [
            '<(DEPTH)/ui/views/views.gyp:views',
            '<(DEPTH)/ui/views/views.gyp:views_test_support',
            'components.gyp:constrained_window',
          ]
        }],
        ['OS=="win"', {
          'dependencies': [
            'components.gyp:browser_watcher',
            'components.gyp:browser_watcher_client',
          ]
        }],
        ['OS != "ios"', {
          'sources': [
            '<@(certificate_transparency_unittest_sources)',
            '<@(child_trace_message_filter_unittest_sources)',
            '<@(devtools_http_handler_unittest_sources)',
            '<@(display_compositor_unittest_sources)',
            '<@(domain_reliability_unittest_sources)',
            '<@(error_page_unittest_sources)',
            '<@(guest_view_unittest_sources)',
            '<@(memory_coordinator_unittest_sources)',
            '<@(navigation_interception_unittest_sources)',
            '<@(network_hints_unittest_sources)',
            '<@(ntp_tiles_unittest_sources)',
            '<@(packed_ct_ev_whitelist_unittest_sources)',
            '<@(page_load_metrics_unittest_sources)',
            '<@(power_unittest_sources)',
            '<@(safe_browsing_db_unittest_sources)',
            '<@(safe_json_unittest_sources)',
            '<@(scheduler_unittest_sources)',
            '<@(storage_monitor_unittest_sources)',
            '<@(subresource_filter_content_browser_unittest_sources)',
            '<@(tracing_unittest_sources)',
            '<@(visitedlink_unittest_sources)',
            '<@(wallpaper_unittest_sources)',
            '<@(web_cache_unittest_sources)',
            '<@(webcrypto_unittest_sources)',
            '<@(web_modal_unittest_sources)',
            '<@(zoom_unittest_sources)',
          ],
          'dependencies': [
            '../content/content_shell_and_tests.gyp:test_support_content',
            '../skia/skia.gyp:skia',
            'components.gyp:autofill_content_browser',
            'components.gyp:autofill_content_renderer',
            'components.gyp:autofill_content_test_support',
            'components.gyp:autofill_content_test_types_mojo_bindings',
            'components.gyp:certificate_transparency',
            'components.gyp:crash_test_support',
            'components.gyp:data_reduction_proxy_content_browser',
            'components.gyp:data_use_measurement_content',
            'components.gyp:devtools_http_handler',
            'components.gyp:display_compositor',
            'components.gyp:dom_distiller_content_browser',
            'components.gyp:dom_distiller_content_renderer',
            'components.gyp:domain_reliability',
            'components.gyp:error_page_renderer',
            'components.gyp:favicon_content',
            'components.gyp:guest_view_browser',
            'components.gyp:guest_view_common',
            'components.gyp:guest_view_test_support',
            'components.gyp:history_content_browser',
            'components.gyp:keyed_service_content',
            'components.gyp:memory_coordinator_child',
            'components.gyp:metrics_gpu',
            'components.gyp:navigation_interception',
            'components.gyp:network_hints_renderer',
            'components.gyp:ntp_tiles',
            'components.gyp:packed_ct_ev_whitelist',
            'components.gyp:page_load_metrics_browser',
            'components.gyp:page_load_metrics_renderer',
            'components.gyp:password_manager_content_browser',
            'components.gyp:power',
            'components.gyp:precache_content',
            'components.gyp:safe_browsing_db',
            'components.gyp:safe_json',
            'components.gyp:safe_json_test_support',
            'components.gyp:sessions_content',
            'components.gyp:storage_monitor',
            'components.gyp:storage_monitor_test_support',
            'components.gyp:subresource_filter_content_browser',
            'components.gyp:subresource_filter_content_common',
            'components.gyp:test_database_manager',
            'components.gyp:url_matcher',
            'components.gyp:visitedlink_browser',
            'components.gyp:visitedlink_renderer',
            'components.gyp:wallpaper',
            'components.gyp:web_cache_browser',
            'components.gyp:web_modal',
            'components.gyp:web_modal_test_support',
            'components.gyp:zoom',
            'scheduler/scheduler.gyp:scheduler',
            'test_runner/test_runner.gyp:test_runner',
            'tracing.gyp:tracing',
            'webcrypto/webcrypto.gyp:webcrypto',
            '../third_party/boringssl/boringssl.gyp:boringssl',
            '../third_party/re2/re2.gyp:re2',
          ],
          'conditions': [
            ['OS=="android"', {
              'sources' : [
                '<@(web_restrictions_unittest_sources)',
              ],
              'dependencies': [
                'components.gyp:web_restrictions_browser',
                'components.gyp:web_restrictions_test_support',
                '../build/android/ndk.gyp:cpu_features',
              ],
            }],
            ['OS=="android" and configuration_policy == 1', {
              'dependencies': [
                'components.gyp:policy_java',
              ],
            }],
            ['safe_browsing == 2 and OS != "ios"', {
              'dependencies': [
                'components.gyp:safe_browsing_db_mobile',
              ],
              'sources': [
                '<@(safe_browsing_db_mobile_unittest_sources)',
              ],
            }],
            ['OS != "mac" and use_aura == 0', {
              'sources!': [
                'display_compositor/buffer_queue_unittest.cc',
              ],
            }],
          ],
        }, { # 'OS == "ios"'
          'sources': [
            'webp_transcode/webp_decoder_unittest.mm',
          ],
          'sources/': [
            # Exclude all tests that depends on //content (based on layered-
            # component directory structure).
            ['exclude', '^[^/]*/content/'],
          ],
          'mac_bundle_resources': [
            '<(PRODUCT_DIR)/ui_test.pak',
          ],
          'dependencies': [
            '../ios/web/ios_web.gyp:ios_web_test_support',
            '../third_party/ocmock/ocmock.gyp:ocmock',
            'components.gyp:autofill_ios_browser',
            'components.gyp:sessions_ios',
            'components.gyp:signin_ios_browser',
            'components.gyp:signin_ios_browser_test_support',
            'components.gyp:translate_ios_browser',
            'components.gyp:webp_transcode',
          ],
          'actions': [
            {
              'action_name': 'copy_test_data',
              'variables': {
                'test_data_files': [
                  '../net/data/ssl/certificates',
                  'test/data',
                ],
                'test_data_prefix': 'components',
              },
              'includes': [ '../build/copy_test_data_ios.gypi' ],
            },
          ],
          'conditions': [
            ['configuration_policy==1', {
              'sources/': [
                ['include', '^policy/'],
              ],
            }],
          ],
        }],
        ['disable_nacl==0', {
          'sources': [
            '<@(nacl_unittest_sources)',
          ],
          'dependencies': [
            'nacl.gyp:nacl_browser',
            'nacl.gyp:nacl_common',
          ],
        }],
        ['OS == "mac"', {
          'link_settings': {
            'libraries': [
              '$(SDKROOT)/System/Library/Frameworks/AddressBook.framework',
              '$(SDKROOT)/System/Library/Frameworks/Foundation.framework',
              '$(SDKROOT)/System/Library/Frameworks/ImageCaptureCore.framework',
            ],
          },
          'sources!': [
            'password_manager/core/browser/password_store_default_unittest.cc',
          ],
        }],
        ['OS == "android"', {
          'sources': [
            'data_usage/android/traffic_stats_amortizer_unittest.cc',
            'invalidation/impl/invalidation_logger_unittest.cc',
            'invalidation/impl/invalidation_service_android_unittest.cc',
          ],
          'sources!': [
            'gcm_driver/gcm_account_mapper_unittest.cc',
            'gcm_driver/gcm_channel_status_request_unittest.cc',
            'gcm_driver/gcm_client_impl_unittest.cc',
            'gcm_driver/gcm_driver_desktop_unittest.cc',
            'gcm_driver/gcm_stats_recorder_impl_unittest.cc',
            'sessions/core/session_backend_unittest.cc',
            'storage_monitor/media_storage_util_unittest.cc',
            'storage_monitor/storage_info_unittest.cc',
            'storage_monitor/storage_monitor_unittest.cc',
            'web_modal/web_contents_modal_dialog_manager_unittest.cc',
          ],
          'dependencies': [
            'components.gyp:data_usage_android',
            'components.gyp:safe_json_java',
            'components.gyp:variations_java',
            '../content/content.gyp:content_java',
            '../testing/android/native_test.gyp:native_test_native_code',
          ],
          'dependencies!': [
            'components.gyp:storage_monitor',
            'components.gyp:storage_monitor_test_support',
            'components.gyp:web_modal',
            'components.gyp:web_modal_test_support',
          ],
        }, {
          'sources': [
            '<@(invalidation_unittest_sources)',
          ],
        }],
        ['OS != "ios" and OS != "android"', {
          'sources': [
            '<@(audio_modem_unittest_sources)',
            '<@(copresence_unittest_sources)',
            '<@(feedback_unittest_sources)',
            '<@(proximity_auth_unittest_sources)',
            '<@(webusb_detector_unittest_sources)',
          ],
          'sources!': [
            'variations/variations_request_scheduler_mobile_unittest.cc',
            'web_resource/promo_resource_service_mobile_ntp_unittest.cc',
          ],
          'dependencies': [
            '../device/bluetooth/bluetooth.gyp:device_bluetooth_mocks',
            '../device/core/core.gyp:device_core',
            '../device/core/core.gyp:device_core_mocks',
            '../device/hid/hid.gyp:device_hid_mocks',
            '../device/usb/usb.gyp:device_usb',
            '../device/usb/usb.gyp:device_usb_mocks',
            '../google_apis/google_apis.gyp:google_apis_test_support',
            '../third_party/protobuf/protobuf.gyp:protobuf_lite',
            'components.gyp:audio_modem',
            'components.gyp:audio_modem_test_support',
            'components.gyp:copresence',
            'components.gyp:copresence_test_support',
            'components.gyp:cryptauth',
            'components.gyp:cryptauth_proto',
            'components.gyp:cryptauth_test_support',
            'components.gyp:feedback_component',
            'components.gyp:pref_registry_test_support',
            'components.gyp:proximity_auth',
            'components.gyp:proximity_auth_test_support',
            'components.gyp:webusb',
          ],
        }],
        ['chromeos==1', {
          'sources': [
            'arc/arc_bridge_service_unittest.cc',
            'arc/ime/arc_ime_service_unittest.cc',
            'arc/intent_helper/activity_icon_loader_unittest.cc',
            'arc/intent_helper/arc_intent_helper_bridge_unittest.cc',
            'arc/intent_helper/font_size_util_unittest.cc',
            'arc/intent_helper/intent_filter_unittest.cc',
            'arc/intent_helper/link_handler_model_impl_unittest.cc',
            'pairing/message_buffer_unittest.cc',
            'timers/alarm_timer_unittest.cc',
            'wifi_sync/wifi_config_delegate_chromeos_unittest.cc',
            'wifi_sync/wifi_credential_syncable_service_unittest.cc',
            'wifi_sync/wifi_credential_unittest.cc',
            'wifi_sync/wifi_security_class_chromeos_unittest.cc',
            'wifi_sync/wifi_security_class_unittest.cc',
            '<@(metrics_leak_detector_unittest_sources)',
            '<@(ownership_unittest_sources)',
            '<@(user_manager_unittest_sources)',
          ],
          'sources!': [
            'signin/core/browser/account_investigator_unittest.cc',
            'signin/core/browser/signin_status_metrics_provider_unittest.cc',
            'storage_monitor/storage_monitor_linux_unittest.cc',
          ],
          'dependencies': [
            '../chromeos/chromeos.gyp:chromeos_test_support',
            'components.gyp:arc',
            'components.gyp:arc_test_support',
            'components.gyp:metrics_leak_detector',
            'components.gyp:ownership',
            'components.gyp:pairing',
            'components.gyp:user_manager_test_support',
            'components.gyp:wifi_sync',
          ],
        }],
        ['OS=="linux"', {
          'sources': [
            'metrics/serialization/serialization_utils_unittest.cc',
          ],
          'dependencies': [
            'components.gyp:metrics_serialization',
            '../dbus/dbus.gyp:dbus',
            '../device/media_transfer_protocol/media_transfer_protocol.gyp:device_media_transfer_protocol',
          ],
        }],
        ['OS=="linux" and chromeos!=1', {
          'sources': [
            'os_crypt/kwallet_dbus_unittest.cc',
            'os_crypt/os_crypt_linux_unittest.cc',
            'os_crypt/os_crypt_util_linux_unittest.cc',
          ],
          'defines': [
            'USE_KWALLET',
            'USE_LIBSECRET',
          ],
          'include_dirs': [
            '../third_party/libsecret'
          ],
          'dependencies' : [
            '../build/linux/system.gyp:dbus',
            '../dbus/dbus.gyp:dbus',
            '../dbus/dbus.gyp:dbus_test_support',
          ]
        }],
        ['OS=="linux" and use_udev==0', {
          'dependencies!': [
            'components.gyp:storage_monitor',
            'components.gyp:storage_monitor_test_support',
          ],
          'sources/': [
            ['exclude', '^storage_monitor/'],
          ],
        }],
        ['configuration_policy==1', {
          'dependencies': [
            'components.gyp:policy_component',
            'components.gyp:policy_component_test_support',
            'components.gyp:policy_test_support',
          ],
          'sources': [
            '<@(policy_unittest_sources)',
            'sync_driver/sync_policy_handler_unittest.cc',
          ],
          'conditions': [
            ['OS=="android"', {
              'sources/': [
                ['exclude', '^policy/core/common/async_policy_provider_unittest\\.cc'],
                ['exclude', '^tracing/browser/trace_config_file_unittest\\.cc'],
              ],
            }],
            ['OS=="android" or OS=="ios"', {
              # Note: 'sources!' is processed before any 'sources/', so the
              # ['include', '^policy/'] on iOS above will include all of the
              # policy source files again. Using 'source/' here too will get
              # these files excluded as expected.
              'sources/': [
                ['exclude', '^policy/core/common/cloud/component_cloud_policy_service_unittest\\.cc'],
                ['exclude', '^policy/core/common/cloud/component_cloud_policy_store_unittest\\.cc'],
                ['exclude', '^policy/core/common/cloud/component_cloud_policy_updater_unittest\\.cc'],
                ['exclude', '^policy/core/common/cloud/external_policy_data_fetcher_unittest\\.cc'],
                ['exclude', '^policy/core/common/cloud/external_policy_data_updater_unittest\\.cc'],
                ['exclude', '^policy/core/common/cloud/resource_cache_unittest\\.cc'],
                ['exclude', '^policy/core/common/config_dir_policy_loader_unittest\\.cc'],
              ],
            }],
            ['chromeos==1', {
              'sources': [
                'policy/core/common/proxy_policy_provider_unittest.cc',
              ],
              'sources!': [
                'policy/core/common/cloud/user_cloud_policy_manager_unittest.cc',
                'policy/core/common/cloud/user_cloud_policy_store_unittest.cc',
              ],
            }],
            ['OS=="ios" or OS=="mac"', {
              'sources': [
                'policy/core/common/mac_util_unittest.cc',
              ],
            }],
          ],
        }, {  # configuration_policy!=1
          'sources!': [
            'search_engines/default_search_policy_handler_unittest.cc',
            'sync_driver/sync_policy_handler_unittest.cc',
          ],
        }],
        ['enable_plugins == 1', {
          'sources': [
            'content_settings/core/browser/content_settings_provider_unittest.cc',
          ],
        }],
      ],
      # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
      'msvs_disabled_warnings': [4267, ],
    },
  ],
  'conditions': [
    ['OS == "android"', {
      'variables': {
        'components_browsertests_pak_input_resources': [
          '<(PRODUCT_DIR)/components_tests_resources.pak',
          '<(PRODUCT_DIR)/content_shell/assets/content_shell.pak',
        ],
        'conditions': [
          ['icu_use_data_file_flag==1', {
            'components_browsertests_pak_input_resources': [
              '<(PRODUCT_DIR)/icudtl.dat',
            ],
          }],
        ],
      },
      'includes': ['../build/android/v8_external_startup_data_arch_suffix.gypi'],
      'targets': [
        {
          'target_name': 'components_browsertests_paks_copy',
          'type': 'none',
          'dependencies': [
            'components_browsertests',
          ],
          'variables': {
            'dest_path': '<(PRODUCT_DIR)/components_browsertests_apk_shell/assets',
            'src_files': [
              '<@(components_browsertests_pak_input_resources)',
            ],
            'clear': 1,
            'conditions': [
              ['v8_use_external_startup_data==1', {
                'renaming_sources': [
                  '<(PRODUCT_DIR)/natives_blob.bin',
                  '<(PRODUCT_DIR)/snapshot_blob.bin',
                ],
                'renaming_destinations': [
                  'natives_blob_<(arch_suffix).bin',
                  'snapshot_blob_<(arch_suffix).bin',
                ],
              }],
            ],
          },
          'includes': ['../build/android/copy_ex.gypi'],
        },
        {
          'target_name': 'components_browsertests_manifest',
          'type': 'none',
          'variables': {
            'jinja_inputs': ['test/android/browsertests_apk/AndroidManifest.xml.jinja2'],
            'jinja_output': '<(SHARED_INTERMEDIATE_DIR)/components_browsertests_manifest/AndroidManifest.xml',
          },
          'includes': [ '../build/android/jinja_template.gypi' ],
        },
        {
          # GN: //components:components_browsertests_apk
          'target_name': 'components_browsertests_apk',
          'type': 'none',
          'dependencies': [
            '../content/content.gyp:content_java',
            '../content/content_shell_and_tests.gyp:content_java_test_support',
            '../content/content_shell_and_tests.gyp:content_shell_browsertests_java',
            '../content/content_shell_and_tests.gyp:content_shell_java',
            'components_browsertests_paks_copy',
            'components_browsertests',
          ],
          'variables': {
            'test_suite_name': 'components_browsertests',
            'isolate_file': 'components_browsertests.isolate',
            'java_in_dir': 'test/android/browsertests_apk',
            'android_manifest_path': '<(SHARED_INTERMEDIATE_DIR)/components_browsertests_manifest/AndroidManifest.xml',
            'resource_dir': 'test/android/browsertests_apk/res',
            'asset_location': '<(PRODUCT_DIR)/components_browsertests_apk_shell/assets',
            'conditions': [
              ['icu_use_data_file_flag==1', {
                'additional_input_paths': [
                  '<(asset_location)/icudtl.dat',
                ],
              }],
              ['v8_use_external_startup_data==1', {
                'additional_input_paths': [
                  '<(asset_location)/natives_blob_<(arch_suffix).bin',
                  '<(asset_location)/snapshot_blob_<(arch_suffix).bin',
                ],
              }],
            ],
          },
          'includes': [ '../build/apk_browsertest.gypi' ],
        },
        {
          'target_name': 'components_unittests_apk',
          'isolate_file': 'components_unittests.isolate',
          'type': 'none',
          'dependencies': [
            'components_unittests',
            'components.gyp:instance_id_driver_java',
            'components.gyp:instance_id_driver_test_support_java',
            'components.gyp:invalidation_java',
            'components.gyp:signin_core_browser_java',
            'components.gyp:web_restrictions_test_support_java',
          ],
          'variables': {
            'test_suite_name': 'components_unittests',
          },
          'includes': [ '../build/apk_test.gypi' ],
        },
        {
          'target_name': 'components_junit_tests',
          'type': 'none',
          'dependencies': [
            'components.gyp:invalidation_java',
            'components.gyp:policy_java',
            'components.gyp:policy_java_test_support',
            'components.gyp:web_restrictions_java',
            '../base/base.gyp:base_java',
            '../base/base.gyp:base_java_test_support',
            '../testing/android/junit/junit_test.gyp:junit_test_support',
          ],
          'variables': {
            'main_class': 'org.chromium.testing.local.JunitTestMain',
            'src_paths': [
              'invalidation/impl/android/junit/',
              'policy/android/junit/',
              'web_restrictions/browser/junit/'
            ],
            'wrapper_script_name': 'helper/<(_target_name)',
          },
          'includes': [ '../build/host_jar.gypi' ],
        },
      ],
      'conditions': [
        ['test_isolation_mode != "noop"',
          {
            'targets': [
              {
                'target_name': 'components_browsertests_apk_run',
                'type': 'none',
                'dependencies': [
                  'components_browsertests_apk',
                ],
                'includes': [
                  '../build/isolate.gypi',
                ],
                'sources': [
                  'components_browsertests_apk.isolate',
                ],
              },
              {
                'target_name': 'components_unittests_apk_run',
                'type': 'none',
                'dependencies': [
                  'components_unittests_apk',
                ],
                'includes': [
                  '../build/isolate.gypi',
                ],
                'sources': [
                  'components_unittests_apk.isolate',
                ],
              },
            ],
          },
        ],
      ],
    }],
    ['OS != "ios"', {
      'targets': [
        {
          # GN: //components:components_perftests
          'target_name': 'components_perftests',
          'type': '<(gtest_target_type)',
          'dependencies': [
            '../base/base.gyp:base',
            '../base/base.gyp:test_support_perf',
            '../content/content_shell_and_tests.gyp:test_support_content',
            '../testing/gtest.gyp:gtest',
            '../testing/perf/perf_test.gyp:perf_test',
            'components.gyp:visitedlink_browser',
            'scheduler/scheduler.gyp:scheduler',
          ],
         'include_dirs': [
           '..',
         ],
         'sources': [
           'scheduler/base/task_queue_manager_delegate_for_test.cc',
           'scheduler/base/task_queue_manager_delegate_for_test.h',
           'scheduler/base/task_queue_manager_perftest.cc',
           'visitedlink/test/visitedlink_perftest.cc',
         ],
         'conditions': [
           ['OS == "android"', {
             'dependencies': [
               '../testing/android/native_test.gyp:native_test_native_code',
             ],
           }],
         ],
         # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
         'msvs_disabled_warnings': [ 4267, ],
        },
        {
          'target_name': 'components_browsertests',
          'type': '<(gtest_target_type)',
          'defines!': ['CONTENT_IMPLEMENTATION'],
          'dependencies': [
            '../content/content.gyp:content_common',
            '../content/content.gyp:content_gpu',
            '../content/content.gyp:content_renderer',
            '../content/content_shell_and_tests.gyp:content_browser_test_base',
            '../content/content_shell_and_tests.gyp:content_browser_test_support',
            '../content/content_shell_and_tests.gyp:content_shell_lib',
            '../content/content_shell_and_tests.gyp:content_shell_pak',
            '../content/content_shell_and_tests.gyp:test_support_content',
            '../skia/skia.gyp:skia',
            '../testing/gmock.gyp:gmock',
            '../testing/gtest.gyp:gtest',
            'components.gyp:autofill_content_browser',
            'components.gyp:autofill_content_renderer',
            'components.gyp:content_settings_core_browser',
            'components.gyp:content_settings_core_common',
            'components.gyp:dom_distiller_content_browser',
            'components.gyp:dom_distiller_content_renderer',
            'components.gyp:dom_distiller_core',
            'components.gyp:password_manager_content_renderer',
            'components.gyp:pref_registry_test_support',
            'components_resources.gyp:components_resources',
            'components_strings.gyp:components_strings',
            'components_tests_pak',
            'tracing.gyp:tracing',
          ],
          'include_dirs': [
            '..',
          ],
          'defines': [
            'HAS_OUT_OF_PROC_TEST_RUNNER',
          ],
          'sources': [
            # Note: test list duplicated in GN build.
            'autofill/content/browser/risk/fingerprint_browsertest.cc',
            'autofill/content/renderer/password_form_conversion_utils_browsertest.cc',
            'dom_distiller/content/browser/distillable_page_utils_browsertest.cc',
            'dom_distiller/content/browser/distiller_page_web_contents_browsertest.cc',
            'dom_distiller/content/browser/test/dom_distiller_js_browsertest.cc',
            'password_manager/content/renderer/credential_manager_client_browsertest.cc',
            'tracing/child/child_trace_message_filter_browsertest.cc',
          ],
          'conditions': [
            ['OS == "android"', {
              'sources' : [
                'test/android/browsertests_apk/components_browser_tests_jni_onload.cc',
              ],
              'sources!': [
                'autofill/content/browser/risk/fingerprint_browsertest.cc',
              ],
              'dependencies': [
                '../testing/android/native_test.gyp:native_test_support',
              ],
            }],
            ['OS == "linux"', {
              'sources': [
                  # content_extractor_browsertest is a standalone content extraction tool built as
                  # a MANUAL component_browsertest.
                  'dom_distiller/standalone/content_extractor_browsertest.cc',
                ],
            }],
            ['OS=="win"', {
              'resource_include_dirs': [
                '<(SHARED_INTERMEDIATE_DIR)/content/app/resources',
              ],
              'sources': [
                '../content/shell/app/resource.h',
                '../content/shell/app/shell.rc',
              ],
              'dependencies': [
                '<(DEPTH)/content/app/resources/content_resources.gyp:content_resources',
                '<(DEPTH)/content/app/strings/content_strings.gyp:content_strings',
                '<(DEPTH)/net/net.gyp:net_resources',
                '<(DEPTH)/third_party/WebKit/public/blink_resources.gyp:blink_resources',
                '<(DEPTH)/third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
                '<(DEPTH)/third_party/isimpledom/isimpledom.gyp:isimpledom',
              ],
              'configurations': {
                'Debug_Base': {
                  'msvs_settings': {
                    'VCLinkerTool': {
                      'LinkIncremental': '<(msvs_large_module_debug_link_mode)',
                    },
                  },
                },
              },
              # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
              'msvs_disabled_warnings': [ 4267, ],
            }],
            ['OS=="mac"', {
              'dependencies': [
                '../content/content_shell_and_tests.gyp:content_shell',  # Needed for Content Shell.app's Helper.
              ],
            }],
            ['enable_basic_printing==1 or enable_print_preview==1', {
              'dependencies': [
                'components.gyp:printing_test_support',
              ],
              'sources' : [
                'printing/test/print_web_view_helper_browsertest.cc',
              ],
            }]
          ],
        },
      ],
      'conditions': [
        ['test_isolation_mode != "noop"', {
          'targets': [
            {
              'target_name': 'components_browsertests_run',
              'type': 'none',
              'dependencies': [ 'components_browsertests' ],
              'includes': [
                '../build/isolate.gypi',
              ],
              'sources': [
                'components_browsertests.isolate',
              ],
              'conditions': [
                ['use_x11==1', {
                  'dependencies': [
                    '../tools/xdisplaycheck/xdisplaycheck.gyp:xdisplaycheck',
                  ],
                }],
              ],
            },
          ],
        }],
      ],
    }],
    ['test_isolation_mode != "noop"', {
      'targets': [
        {
          'target_name': 'components_unittests_run',
          'type': 'none',
          'dependencies': [
            'components_unittests',
          ],
          'includes': [
            '../build/isolate.gypi',
          ],
          'sources': [
            'components_unittests.isolate',
          ],
          'conditions': [
            ['use_x11==1', {
              'dependencies': [
                '../tools/xdisplaycheck/xdisplaycheck.gyp:xdisplaycheck',
              ],
            }],
          ],
        },
      ],
    }],
  ],
}
