// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_VIZ_SERVICE_FRAME_SINKS_PRIMARY_BEGIN_FRAME_SOURCE_H_
#define COMPONENTS_VIZ_SERVICE_FRAME_SINKS_PRIMARY_BEGIN_FRAME_SOURCE_H_

#include "base/containers/flat_set.h"
#include "components/viz/common/frame_sinks/begin_frame_source.h"
#include "components/viz/service/viz_service_export.h"

namespace viz {

// PrimaryBeginFrameSource echos the first BeginFrameSource in the system.
// If the first source goes away then it will echo the new first
// BeginFrameSource.
class VIZ_SERVICE_EXPORT PrimaryBeginFrameSource
    : public BeginFrameSource,
      public BeginFrameObserver,
      public ExternalBeginFrameSourceClient {
 public:
  PrimaryBeginFrameSource();
  ~PrimaryBeginFrameSource() override;

  void OnBeginFrameSourceAdded(BeginFrameSource* begin_frame_source);
  void OnBeginFrameSourceRemoved(BeginFrameSource* begin_frame_source);

  // BeginFrameObserver implementation.
  void OnBeginFrame(const BeginFrameArgs& args) override;
  const BeginFrameArgs& LastUsedBeginFrameArgs() const override;
  void OnBeginFrameSourcePausedChanged(bool paused) override;
  bool WantsAnimateOnlyBeginFrames() const override;

  // BeginFrameSource implementation.
  void DidFinishFrame(BeginFrameObserver* obs) override;
  void AddObserver(BeginFrameObserver* obs) override;
  void RemoveObserver(BeginFrameObserver* obs) override;
  bool IsThrottled() const override;
  void OnGpuNoLongerBusy() override;

  // ExternalBeginFrameSourceClient implementation.
  void OnNeedsBeginFrames(bool needs_begin_frames) override;

 private:
  ExternalBeginFrameSource begin_frame_source_;
  BeginFrameSource* current_begin_frame_source_ = nullptr;

  // The last begin frame args generated by the begin frame source.
  BeginFrameArgs last_begin_frame_args_;

  bool needs_begin_frames_ = false;

  base::flat_set<BeginFrameSource*> sources_;

  DISALLOW_COPY_AND_ASSIGN(PrimaryBeginFrameSource);
};

}  // namespace viz

#endif  // COMPONENTS_VIZ_SERVICE_FRAME_SINKS_PRIMARY_BEGIN_FRAME_SOURCE_H_
