/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*******************************************************************************
 * AUTOGENERATED - DO NOT EDIT
 *******************************************************************************
 * This file has been generated from the protobuf message
 * perfetto/config/sys_stats/sys_stats_config.proto
 * by
 * ../../tools/proto_to_cpp/proto_to_cpp.cc.
 * If you need to make changes here, change the .proto file and then run
 * ./tools/gen_tracing_cpp_headers_from_protos
 */

#include "perfetto/tracing/core/sys_stats_config.h"

#include "perfetto/common/sys_stats_counters.pb.h"
#include "perfetto/config/sys_stats/sys_stats_config.pb.h"

namespace perfetto {

SysStatsConfig::SysStatsConfig() = default;
SysStatsConfig::~SysStatsConfig() = default;
SysStatsConfig::SysStatsConfig(const SysStatsConfig&) = default;
SysStatsConfig& SysStatsConfig::operator=(const SysStatsConfig&) = default;
SysStatsConfig::SysStatsConfig(SysStatsConfig&&) noexcept = default;
SysStatsConfig& SysStatsConfig::operator=(SysStatsConfig&&) = default;

void SysStatsConfig::FromProto(const perfetto::protos::SysStatsConfig& proto) {
  static_assert(sizeof(meminfo_period_ms_) == sizeof(proto.meminfo_period_ms()),
                "size mismatch");
  meminfo_period_ms_ =
      static_cast<decltype(meminfo_period_ms_)>(proto.meminfo_period_ms());

  meminfo_counters_.clear();
  for (const auto& field : proto.meminfo_counters()) {
    meminfo_counters_.emplace_back();
    static_assert(
        sizeof(meminfo_counters_.back()) == sizeof(proto.meminfo_counters(0)),
        "size mismatch");
    meminfo_counters_.back() =
        static_cast<decltype(meminfo_counters_)::value_type>(field);
  }

  static_assert(sizeof(vmstat_period_ms_) == sizeof(proto.vmstat_period_ms()),
                "size mismatch");
  vmstat_period_ms_ =
      static_cast<decltype(vmstat_period_ms_)>(proto.vmstat_period_ms());

  vmstat_counters_.clear();
  for (const auto& field : proto.vmstat_counters()) {
    vmstat_counters_.emplace_back();
    static_assert(
        sizeof(vmstat_counters_.back()) == sizeof(proto.vmstat_counters(0)),
        "size mismatch");
    vmstat_counters_.back() =
        static_cast<decltype(vmstat_counters_)::value_type>(field);
  }

  static_assert(sizeof(stat_period_ms_) == sizeof(proto.stat_period_ms()),
                "size mismatch");
  stat_period_ms_ =
      static_cast<decltype(stat_period_ms_)>(proto.stat_period_ms());

  stat_counters_.clear();
  for (const auto& field : proto.stat_counters()) {
    stat_counters_.emplace_back();
    static_assert(
        sizeof(stat_counters_.back()) == sizeof(proto.stat_counters(0)),
        "size mismatch");
    stat_counters_.back() =
        static_cast<decltype(stat_counters_)::value_type>(field);
  }
  unknown_fields_ = proto.unknown_fields();
}

void SysStatsConfig::ToProto(perfetto::protos::SysStatsConfig* proto) const {
  proto->Clear();

  static_assert(
      sizeof(meminfo_period_ms_) == sizeof(proto->meminfo_period_ms()),
      "size mismatch");
  proto->set_meminfo_period_ms(
      static_cast<decltype(proto->meminfo_period_ms())>(meminfo_period_ms_));

  for (const auto& it : meminfo_counters_) {
    proto->add_meminfo_counters(
        static_cast<decltype(proto->meminfo_counters(0))>(it));
    static_assert(sizeof(it) == sizeof(proto->meminfo_counters(0)),
                  "size mismatch");
  }

  static_assert(sizeof(vmstat_period_ms_) == sizeof(proto->vmstat_period_ms()),
                "size mismatch");
  proto->set_vmstat_period_ms(
      static_cast<decltype(proto->vmstat_period_ms())>(vmstat_period_ms_));

  for (const auto& it : vmstat_counters_) {
    proto->add_vmstat_counters(
        static_cast<decltype(proto->vmstat_counters(0))>(it));
    static_assert(sizeof(it) == sizeof(proto->vmstat_counters(0)),
                  "size mismatch");
  }

  static_assert(sizeof(stat_period_ms_) == sizeof(proto->stat_period_ms()),
                "size mismatch");
  proto->set_stat_period_ms(
      static_cast<decltype(proto->stat_period_ms())>(stat_period_ms_));

  for (const auto& it : stat_counters_) {
    proto->add_stat_counters(
        static_cast<decltype(proto->stat_counters(0))>(it));
    static_assert(sizeof(it) == sizeof(proto->stat_counters(0)),
                  "size mismatch");
  }
  *(proto->mutable_unknown_fields()) = unknown_fields_;
}

}  // namespace perfetto
