/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*******************************************************************************
 * AUTOGENERATED - DO NOT EDIT
 *******************************************************************************
 * This file has been generated from the protobuf message
 * perfetto/config/test_config.proto
 * by
 * ../../tools/proto_to_cpp/proto_to_cpp.cc.
 * If you need to make changes here, change the .proto file and then run
 * ./tools/gen_tracing_cpp_headers_from_protos.py
 */

#include "perfetto/tracing/core/test_config.h"

#include "perfetto/config/test_config.pb.h"

namespace perfetto {

TestConfig::TestConfig() = default;
TestConfig::~TestConfig() = default;
TestConfig::TestConfig(const TestConfig&) = default;
TestConfig& TestConfig::operator=(const TestConfig&) = default;
TestConfig::TestConfig(TestConfig&&) noexcept = default;
TestConfig& TestConfig::operator=(TestConfig&&) = default;

void TestConfig::FromProto(const perfetto::protos::TestConfig& proto) {
  static_assert(sizeof(message_count_) == sizeof(proto.message_count()),
                "size mismatch");
  message_count_ = static_cast<decltype(message_count_)>(proto.message_count());

  static_assert(sizeof(max_messages_per_second_) ==
                    sizeof(proto.max_messages_per_second()),
                "size mismatch");
  max_messages_per_second_ = static_cast<decltype(max_messages_per_second_)>(
      proto.max_messages_per_second());

  static_assert(sizeof(seed_) == sizeof(proto.seed()), "size mismatch");
  seed_ = static_cast<decltype(seed_)>(proto.seed());

  static_assert(sizeof(message_size_) == sizeof(proto.message_size()),
                "size mismatch");
  message_size_ = static_cast<decltype(message_size_)>(proto.message_size());

  static_assert(
      sizeof(send_batch_on_register_) == sizeof(proto.send_batch_on_register()),
      "size mismatch");
  send_batch_on_register_ = static_cast<decltype(send_batch_on_register_)>(
      proto.send_batch_on_register());
  unknown_fields_ = proto.unknown_fields();
}

void TestConfig::ToProto(perfetto::protos::TestConfig* proto) const {
  proto->Clear();

  static_assert(sizeof(message_count_) == sizeof(proto->message_count()),
                "size mismatch");
  proto->set_message_count(
      static_cast<decltype(proto->message_count())>(message_count_));

  static_assert(sizeof(max_messages_per_second_) ==
                    sizeof(proto->max_messages_per_second()),
                "size mismatch");
  proto->set_max_messages_per_second(
      static_cast<decltype(proto->max_messages_per_second())>(
          max_messages_per_second_));

  static_assert(sizeof(seed_) == sizeof(proto->seed()), "size mismatch");
  proto->set_seed(static_cast<decltype(proto->seed())>(seed_));

  static_assert(sizeof(message_size_) == sizeof(proto->message_size()),
                "size mismatch");
  proto->set_message_size(
      static_cast<decltype(proto->message_size())>(message_size_));

  static_assert(sizeof(send_batch_on_register_) ==
                    sizeof(proto->send_batch_on_register()),
                "size mismatch");
  proto->set_send_batch_on_register(
      static_cast<decltype(proto->send_batch_on_register())>(
          send_batch_on_register_));
  *(proto->mutable_unknown_fields()) = unknown_fields_;
}

}  // namespace perfetto
