/****************************************************************************
** $Id$
**
** Implementation of QNoneInputContextPlugin class
**
** Copyright (C) 2004 immodule for Qt Project.  All rights reserved.
**
** This file is written to contribute to Trolltech AS under their own
** licence. You may use this file under your Qt license. Following
** description is copied from their original file headers. Contact
** immodule-qt@freedesktop.org if any conditions of this licensing are
** not clear to you.
**
**
** This file is part of the input method module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef QT_NO_IM
#include "qnoneinputcontextplugin.h"
#include <qinputcontextfactory.h>
#include <qsettings.h>
#include <cstdlib>


QNoneInputContextPlugin::QNoneInputContextPlugin()
{
}

QNoneInputContextPlugin::~QNoneInputContextPlugin()
{
}

QStringList QNoneInputContextPlugin::keys() const
{
    // input method switcher should named with "imsw-" prefix to
    // prevent to be listed in ordinary input method list.
    return QStringList( "imsw-none" );
}

QInputContext *QNoneInputContextPlugin::create( const QString &key )
{
    QString actuallySpecifiedKey;

    bool isIMSwitcher = key.startsWith( "imsw-" );
    if ( ! isIMSwitcher )
	return 0;

    if ( getenv( "QT_IM_MODULE" ) ) {
        actuallySpecifiedKey = getenv( "QT_IM_MODULE" );
    } else {
	QSettings settings;
        actuallySpecifiedKey = settings.readEntry( "/qt/DefaultInputMethod", "xim" );
    }

    return QInputContextFactory::create( actuallySpecifiedKey, 0 );
}

QStringList QNoneInputContextPlugin::languages( const QString &key )
{
    return QStringList( "" );
}

QString QNoneInputContextPlugin::displayName( const QString &key )
{
    return tr( "Dummy Input Method Switcher" );
}

QString QNoneInputContextPlugin::description( const QString &key )
{
    return tr( "Dummy input method switcher that uses the context menu of the text widgets" );
}


Q_EXPORT_PLUGIN( QNoneInputContextPlugin )

#endif
