/*
 * QEMU model of the Clock-Reset-LPD (CRL).
 *
 * Copyright (c) 2022 Xilinx Inc.
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Written by Edgar E. Iglesias <edgar.iglesias@xilinx.com>
 */
#ifndef HW_MISC_XLNX_VERSAL_CRL_H
#define HW_MISC_XLNX_VERSAL_CRL_H

#include "hw/sysbus.h"
#include "hw/register.h"
#include "target/arm/cpu.h"

#define TYPE_XLNX_VERSAL_CRL "xlnx,versal-crl"
OBJECT_DECLARE_SIMPLE_TYPE(XlnxVersalCRL, XLNX_VERSAL_CRL)

REG32(ERR_CTRL, 0x0)
    FIELD(ERR_CTRL, SLVERR_ENABLE, 0, 1)
REG32(IR_STATUS, 0x4)
    FIELD(IR_STATUS, ADDR_DECODE_ERR, 0, 1)
REG32(IR_MASK, 0x8)
    FIELD(IR_MASK, ADDR_DECODE_ERR, 0, 1)
REG32(IR_ENABLE, 0xc)
    FIELD(IR_ENABLE, ADDR_DECODE_ERR, 0, 1)
REG32(IR_DISABLE, 0x10)
    FIELD(IR_DISABLE, ADDR_DECODE_ERR, 0, 1)
REG32(WPROT, 0x1c)
    FIELD(WPROT, ACTIVE, 0, 1)
REG32(PLL_CLK_OTHER_DMN, 0x20)
    FIELD(PLL_CLK_OTHER_DMN, APLL_BYPASS, 0, 1)
REG32(RPLL_CTRL, 0x40)
    FIELD(RPLL_CTRL, POST_SRC, 24, 3)
    FIELD(RPLL_CTRL, PRE_SRC, 20, 3)
    FIELD(RPLL_CTRL, CLKOUTDIV, 16, 2)
    FIELD(RPLL_CTRL, FBDIV, 8, 8)
    FIELD(RPLL_CTRL, BYPASS, 3, 1)
    FIELD(RPLL_CTRL, RESET, 0, 1)
REG32(RPLL_CFG, 0x44)
    FIELD(RPLL_CFG, LOCK_DLY, 25, 7)
    FIELD(RPLL_CFG, LOCK_CNT, 13, 10)
    FIELD(RPLL_CFG, LFHF, 10, 2)
    FIELD(RPLL_CFG, CP, 5, 4)
    FIELD(RPLL_CFG, RES, 0, 4)
REG32(RPLL_FRAC_CFG, 0x48)
    FIELD(RPLL_FRAC_CFG, ENABLED, 31, 1)
    FIELD(RPLL_FRAC_CFG, SEED, 22, 3)
    FIELD(RPLL_FRAC_CFG, ALGRTHM, 19, 1)
    FIELD(RPLL_FRAC_CFG, ORDER, 18, 1)
    FIELD(RPLL_FRAC_CFG, DATA, 0, 16)
REG32(PLL_STATUS, 0x50)
    FIELD(PLL_STATUS, RPLL_STABLE, 2, 1)
    FIELD(PLL_STATUS, RPLL_LOCK, 0, 1)
REG32(RPLL_TO_XPD_CTRL, 0x100)
    FIELD(RPLL_TO_XPD_CTRL, CLKACT, 25, 1)
    FIELD(RPLL_TO_XPD_CTRL, DIVISOR0, 8, 10)
REG32(LPD_TOP_SWITCH_CTRL, 0x104)
    FIELD(LPD_TOP_SWITCH_CTRL, CLKACT_ADMA, 26, 1)
    FIELD(LPD_TOP_SWITCH_CTRL, CLKACT, 25, 1)
    FIELD(LPD_TOP_SWITCH_CTRL, DIVISOR0, 8, 10)
    FIELD(LPD_TOP_SWITCH_CTRL, SRCSEL, 0, 3)
REG32(LPD_LSBUS_CTRL, 0x108)
    FIELD(LPD_LSBUS_CTRL, CLKACT, 25, 1)
    FIELD(LPD_LSBUS_CTRL, DIVISOR0, 8, 10)
    FIELD(LPD_LSBUS_CTRL, SRCSEL, 0, 3)
REG32(CPU_R5_CTRL, 0x10c)
    FIELD(CPU_R5_CTRL, CLKACT_OCM2, 28, 1)
    FIELD(CPU_R5_CTRL, CLKACT_OCM, 27, 1)
    FIELD(CPU_R5_CTRL, CLKACT_CORE, 26, 1)
    FIELD(CPU_R5_CTRL, CLKACT, 25, 1)
    FIELD(CPU_R5_CTRL, DIVISOR0, 8, 10)
    FIELD(CPU_R5_CTRL, SRCSEL, 0, 3)
REG32(IOU_SWITCH_CTRL, 0x114)
    FIELD(IOU_SWITCH_CTRL, CLKACT, 25, 1)
    FIELD(IOU_SWITCH_CTRL, DIVISOR0, 8, 10)
    FIELD(IOU_SWITCH_CTRL, SRCSEL, 0, 3)
REG32(GEM0_REF_CTRL, 0x118)
    FIELD(GEM0_REF_CTRL, CLKACT_RX, 27, 1)
    FIELD(GEM0_REF_CTRL, CLKACT_TX, 26, 1)
    FIELD(GEM0_REF_CTRL, CLKACT, 25, 1)
    FIELD(GEM0_REF_CTRL, DIVISOR0, 8, 10)
    FIELD(GEM0_REF_CTRL, SRCSEL, 0, 3)
REG32(GEM1_REF_CTRL, 0x11c)
    FIELD(GEM1_REF_CTRL, CLKACT_RX, 27, 1)
    FIELD(GEM1_REF_CTRL, CLKACT_TX, 26, 1)
    FIELD(GEM1_REF_CTRL, CLKACT, 25, 1)
    FIELD(GEM1_REF_CTRL, DIVISOR0, 8, 10)
    FIELD(GEM1_REF_CTRL, SRCSEL, 0, 3)
REG32(GEM_TSU_REF_CTRL, 0x120)
    FIELD(GEM_TSU_REF_CTRL, CLKACT, 25, 1)
    FIELD(GEM_TSU_REF_CTRL, DIVISOR0, 8, 10)
    FIELD(GEM_TSU_REF_CTRL, SRCSEL, 0, 3)
REG32(USB0_BUS_REF_CTRL, 0x124)
    FIELD(USB0_BUS_REF_CTRL, CLKACT, 25, 1)
    FIELD(USB0_BUS_REF_CTRL, DIVISOR0, 8, 10)
    FIELD(USB0_BUS_REF_CTRL, SRCSEL, 0, 3)
REG32(UART0_REF_CTRL, 0x128)
    FIELD(UART0_REF_CTRL, CLKACT, 25, 1)
    FIELD(UART0_REF_CTRL, DIVISOR0, 8, 10)
    FIELD(UART0_REF_CTRL, SRCSEL, 0, 3)
REG32(UART1_REF_CTRL, 0x12c)
    FIELD(UART1_REF_CTRL, CLKACT, 25, 1)
    FIELD(UART1_REF_CTRL, DIVISOR0, 8, 10)
    FIELD(UART1_REF_CTRL, SRCSEL, 0, 3)
REG32(SPI0_REF_CTRL, 0x130)
    FIELD(SPI0_REF_CTRL, CLKACT, 25, 1)
    FIELD(SPI0_REF_CTRL, DIVISOR0, 8, 10)
    FIELD(SPI0_REF_CTRL, SRCSEL, 0, 3)
REG32(SPI1_REF_CTRL, 0x134)
    FIELD(SPI1_REF_CTRL, CLKACT, 25, 1)
    FIELD(SPI1_REF_CTRL, DIVISOR0, 8, 10)
    FIELD(SPI1_REF_CTRL, SRCSEL, 0, 3)
REG32(CAN0_REF_CTRL, 0x138)
    FIELD(CAN0_REF_CTRL, CLKACT, 25, 1)
    FIELD(CAN0_REF_CTRL, DIVISOR0, 8, 10)
    FIELD(CAN0_REF_CTRL, SRCSEL, 0, 3)
REG32(CAN1_REF_CTRL, 0x13c)
    FIELD(CAN1_REF_CTRL, CLKACT, 25, 1)
    FIELD(CAN1_REF_CTRL, DIVISOR0, 8, 10)
    FIELD(CAN1_REF_CTRL, SRCSEL, 0, 3)
REG32(I2C0_REF_CTRL, 0x140)
    FIELD(I2C0_REF_CTRL, CLKACT, 25, 1)
    FIELD(I2C0_REF_CTRL, DIVISOR0, 8, 10)
    FIELD(I2C0_REF_CTRL, SRCSEL, 0, 3)
REG32(I2C1_REF_CTRL, 0x144)
    FIELD(I2C1_REF_CTRL, CLKACT, 25, 1)
    FIELD(I2C1_REF_CTRL, DIVISOR0, 8, 10)
    FIELD(I2C1_REF_CTRL, SRCSEL, 0, 3)
REG32(DBG_LPD_CTRL, 0x148)
    FIELD(DBG_LPD_CTRL, CLKACT, 25, 1)
    FIELD(DBG_LPD_CTRL, DIVISOR0, 8, 10)
    FIELD(DBG_LPD_CTRL, SRCSEL, 0, 3)
REG32(TIMESTAMP_REF_CTRL, 0x14c)
    FIELD(TIMESTAMP_REF_CTRL, CLKACT, 25, 1)
    FIELD(TIMESTAMP_REF_CTRL, DIVISOR0, 8, 10)
    FIELD(TIMESTAMP_REF_CTRL, SRCSEL, 0, 3)
REG32(CRL_SAFETY_CHK, 0x150)
REG32(PSM_REF_CTRL, 0x154)
    FIELD(PSM_REF_CTRL, DIVISOR0, 8, 10)
    FIELD(PSM_REF_CTRL, SRCSEL, 0, 3)
REG32(DBG_TSTMP_CTRL, 0x158)
    FIELD(DBG_TSTMP_CTRL, CLKACT, 25, 1)
    FIELD(DBG_TSTMP_CTRL, DIVISOR0, 8, 10)
    FIELD(DBG_TSTMP_CTRL, SRCSEL, 0, 3)
REG32(CPM_TOPSW_REF_CTRL, 0x15c)
    FIELD(CPM_TOPSW_REF_CTRL, CLKACT, 25, 1)
    FIELD(CPM_TOPSW_REF_CTRL, DIVISOR0, 8, 10)
    FIELD(CPM_TOPSW_REF_CTRL, SRCSEL, 0, 3)
REG32(USB3_DUAL_REF_CTRL, 0x160)
    FIELD(USB3_DUAL_REF_CTRL, CLKACT, 25, 1)
    FIELD(USB3_DUAL_REF_CTRL, DIVISOR0, 8, 10)
    FIELD(USB3_DUAL_REF_CTRL, SRCSEL, 0, 3)
REG32(RST_CPU_R5, 0x300)
    FIELD(RST_CPU_R5, RESET_PGE, 4, 1)
    FIELD(RST_CPU_R5, RESET_AMBA, 2, 1)
    FIELD(RST_CPU_R5, RESET_CPU1, 1, 1)
    FIELD(RST_CPU_R5, RESET_CPU0, 0, 1)
REG32(RST_ADMA, 0x304)
    FIELD(RST_ADMA, RESET, 0, 1)
REG32(RST_GEM0, 0x308)
    FIELD(RST_GEM0, RESET, 0, 1)
REG32(RST_GEM1, 0x30c)
    FIELD(RST_GEM1, RESET, 0, 1)
REG32(RST_SPARE, 0x310)
    FIELD(RST_SPARE, RESET, 0, 1)
REG32(RST_USB0, 0x314)
    FIELD(RST_USB0, RESET, 0, 1)
REG32(RST_UART0, 0x318)
    FIELD(RST_UART0, RESET, 0, 1)
REG32(RST_UART1, 0x31c)
    FIELD(RST_UART1, RESET, 0, 1)
REG32(RST_SPI0, 0x320)
    FIELD(RST_SPI0, RESET, 0, 1)
REG32(RST_SPI1, 0x324)
    FIELD(RST_SPI1, RESET, 0, 1)
REG32(RST_CAN0, 0x328)
    FIELD(RST_CAN0, RESET, 0, 1)
REG32(RST_CAN1, 0x32c)
    FIELD(RST_CAN1, RESET, 0, 1)
REG32(RST_I2C0, 0x330)
    FIELD(RST_I2C0, RESET, 0, 1)
REG32(RST_I2C1, 0x334)
    FIELD(RST_I2C1, RESET, 0, 1)
REG32(RST_DBG_LPD, 0x338)
    FIELD(RST_DBG_LPD, RPU_DBG1_RESET, 5, 1)
    FIELD(RST_DBG_LPD, RPU_DBG0_RESET, 4, 1)
    FIELD(RST_DBG_LPD, RESET_HSDP, 1, 1)
    FIELD(RST_DBG_LPD, RESET, 0, 1)
REG32(RST_GPIO, 0x33c)
    FIELD(RST_GPIO, RESET, 0, 1)
REG32(RST_TTC, 0x344)
    FIELD(RST_TTC, TTC3_RESET, 3, 1)
    FIELD(RST_TTC, TTC2_RESET, 2, 1)
    FIELD(RST_TTC, TTC1_RESET, 1, 1)
    FIELD(RST_TTC, TTC0_RESET, 0, 1)
REG32(RST_TIMESTAMP, 0x348)
    FIELD(RST_TIMESTAMP, RESET, 0, 1)
REG32(RST_SWDT, 0x34c)
    FIELD(RST_SWDT, RESET, 0, 1)
REG32(RST_OCM, 0x350)
    FIELD(RST_OCM, RESET, 0, 1)
REG32(RST_IPI, 0x354)
    FIELD(RST_IPI, RESET, 0, 1)
REG32(RST_SYSMON, 0x358)
    FIELD(RST_SYSMON, SEQ_RST, 1, 1)
    FIELD(RST_SYSMON, CFG_RST, 0, 1)
REG32(RST_FPD, 0x360)
    FIELD(RST_FPD, SRST, 1, 1)
    FIELD(RST_FPD, POR, 0, 1)
REG32(PSM_RST_MODE, 0x370)
    FIELD(PSM_RST_MODE, WAKEUP, 2, 1)
    FIELD(PSM_RST_MODE, RST_MODE, 0, 2)

#define CRL_R_MAX (R_PSM_RST_MODE + 1)

#define RPU_MAX_CPU 2

struct XlnxVersalCRL {
    SysBusDevice parent_obj;
    qemu_irq irq;

    struct {
        ARMCPU *cpu_r5[RPU_MAX_CPU];
        DeviceState *adma[8];
        DeviceState *uart[2];
        DeviceState *gem[2];
        DeviceState *usb;
    } cfg;

    RegisterInfoArray *reg_array;
    uint32_t regs[CRL_R_MAX];
    RegisterInfo regs_info[CRL_R_MAX];
};
#endif
