/* Copyright 2013-2014 IBM Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __P7IOC_REGS_H
#define __P7IOC_REGS_H

/*
 * Register definitions
 *
 * We only define some registers here. Ideally we should auto-generate
 * the full list from the spec. For now I add them as I need them
 */

/* RGC GEM registers */
#define P7IOC_GEM_XFIR		0x3E0008
#define P7IOC_GEM_RFIR		0x3E0010
#define P7IOC_GEM_RIRQFIR	0x3E0018
#define P7IOC_GEM_MASK		0x3E0020
#define P7IOC_GEM_RWOF		0x3E0028

/* LEM register base */
#define P7IOC_RGC_LEM_BASE		0x3E1E00
#define P7IOC_BI_UP_LEM_BASE		0x3C0000
#define P7IOC_BI_DOWN_LEM_BASE		0x3C0050
#define P7IOC_CI_PORTn_LEM_BASE(n)	(0x3d0200 | ((n) * 0x1000))
#define P7IOC_PHBn_LEM_BASE(n)		(0x000C00 | ((n) * 0x10000))
#define P7IOC_MISC_LEM_BASE		0x3EA000
#define P7IOC_I2C_LEM_BASE		0x3EB000

/* LEM register offset */
#define P7IOC_LEM_FIR_OFFSET		0x00
#define P7IOC_LEM_FIR_AND_OFFSET	0x08
#define P7IOC_LEM_FIR_OR_OFFSET		0x10
#define P7IOC_LEM_ERR_MASK_OFFSET	0x18
#define P7IOC_LEM_ERR_MASK_AND_OFFSET	0x20
#define P7IOC_LEM_ERR_MASK_OR_OFFSET	0x28
#define P7IOC_LEM_ACTION_0_OFFSET	0x30
#define P7IOC_LEM_ACTION_1_OFFSET	0x38
#define P7IOC_LEM_WOF_OFFSET		0x40

/* HSS registers */
#define P7IOC_HSS_BASE          0x3E8000
#define P7IOC_HSS_STRIDE        0x200
#define P7IOC_HSSn_CTL2_OFFSET  0x10
#define P7IOC_HSSn_CTL3_OFFSET  0x18
#define P7IOC_HSSn_CTL8_OFFSET  0x40
#define P7IOC_HSSn_CTL9_OFFSET  0x48
#define P7IOC_HSSn_CTL10_OFFSET 0x50
#define P7IOC_HSSn_CTL11_OFFSET 0x58
#define P7IOC_HSSn_CTL12_OFFSET 0x60
#define P7IOC_HSSn_CTL13_OFFSET 0x68
#define P7IOC_HSSn_CTL14_OFFSET 0x70
#define P7IOC_HSSn_CTL15_OFFSET 0x78
#define P7IOC_HSSn_CTL16_OFFSET 0x80
#define P7IOC_HSSn_CTL17_OFFSET 0x88
#define P7IOC_HSSn_CTL18_OFFSET 0x90
#define P7IOC_HSSn_CTL19_OFFSET 0x98
#define P7IOC_HSSn_CTL20_OFFSET 0xa0
#define P7IOC_HSSn_CTL21_OFFSET 0xa8
#define P7IOC_HSSn_CTL22_OFFSET 0xb0
#define P7IOC_HSSn_CTL23_OFFSET 0xb8

/* CI Routing registers & helper macros */
#define P7IOC_CI_RMATC_REG(i)		(0x3D0400ul + ((i) << 4))
#define P7IOC_CI_RMASK_REG(i)		(0x3D0408ul + ((i) << 4))

#define P7IOC_CI_RMATC_PORT(n)		PPC_BIT(n)
#define P7IOC_CI_RMATC_ADDR_VALID	PPC_BIT(16)
#define P7IOC_CI_RMATC_BUID_VALID	PPC_BIT(17)
#define P7IOC_CI_RMATC_TYPE_VALID	PPC_BIT(18)

/* AIB Addresses are 48-bit, the top 32 are used in
 * the routing tables, we thus shift by 16
 */
#define P7IOC_CI_RMATC_ENCODE_ADDR(addr)	((uint32_t)((addr) >> 16))
#define P7IOC_CI_RMATC_ENCODE_BUID(buid)	((uint32_t)((buid) << 20))
#define P7IOC_CI_RMATC_ENCODE_TYPE(type)	((uint32_t)(type))

/* CI port numbers */
#define P7IOC_CI_PHB_PORT(pnum)		((pnum) + 2)
#define P7IOC_CI_UPSTREAM_PORT		0
#define P7IOC_CI_RGC_PORT		1

/* Other random chip registers */
#define P7IOC_CHIP_FENCE_SHADOW		0x3ec010
#define P7IOC_CHIP_FENCE_WOF		0x3ec018
#define P7IOC_CCRR			0x3e1c00

/* CI registers */
#define P7IOC_CIn_BASE(n)		(0x3d0000 | ((n) * 0x1000))
#define P7IOC_CIn_LEM_FIR(n)		(P7IOC_CIn_BASE(n) + 0x200)
#define P7IOC_CIn_LEM_FIR_AND(n)	(P7IOC_CIn_BASE(n) + 0x208)
#define P7IOC_CIn_LEM_FIR_OR(n)		(P7IOC_CIn_BASE(n) + 0x210)
#define P7IOC_CIn_LEM_ERR_MASK(n)	(P7IOC_CIn_BASE(n) + 0x218)
#define P7IOC_CIn_LEM_ERR_MASK_AND(n)	(P7IOC_CIn_BASE(n) + 0x220)
#define P7IOC_CIn_LEM_ERR_MASK_OR(n)	(P7IOC_CIn_BASE(n) + 0x228)

/*
 * PHB registers
 */

/* PHB Fundamental register set A */
#define PHB_BUID			0x100
#define   PHB_BUID_LSI			PPC_BITMASK(7,15)
#define   PHB_BUID_MSI			PPC_BITMASK(23,31)
#define PHB_DMA_CHAN_STATUS		0x110
#define PHB_CPU_LOADSTORE_STATUS	0x120
#define PHB_CONFIG_DATA			0x130
#define PHB_LOCK0			0x138
#define PHB_CONFIG_ADDRESS		0x140
#define   PHB_CA_ENABLE			PPC_BIT(0)
#define	  PHB_CA_BUS			PPC_BITMASK(4,11)
#define   PHB_CA_DEV			PPC_BITMASK(12,16)
#define   PHB_CA_FUNC			PPC_BITMASK(17,19)
#define   PHB_CA_BDFN			PPC_BITMASK(4,19) /* bus,dev,func */
#define   PHB_CA_REG			PPC_BITMASK(20,31)
#define PHB_LOCK1			0x148
#define PHB_PHB2_CONFIG			0x160
#define   PHB_PHB2C_64B_TCE_EN		PPC_BIT(2)
#define   PHB_PHB2C_32BIT_MSI_EN	PPC_BIT(8)
#define   PHB_PHB2C_IO_EN		PPC_BIT(12)
#define   PHB_PHB2C_64BIT_MSI_EN	PPC_BIT(14)
#define   PHB_PHB2C_M32_EN		PPC_BIT(16)
#define PHB_IO_BASE_ADDR		0x170
#define PHB_IO_BASE_MASK		0x178
#define PHB_IO_START_ADDR		0x180
#define PHB_M32_BASE_ADDR		0x190
#define PHB_M32_BASE_MASK		0x198
#define PHB_M32_START_ADDR		0x1a0
#define PHB_M64_UPPER_BITS		0x1f0
#define PHB_TCE_KILL			0x210
#define   PHB_TCEKILL_PAIR		PPC_BIT(0)
#define   PHB_TCEKILL_ADDR		PPC_BITMASK(16,59)
#define PHB_TCE_PREFETCH		0x218
#define PHB_IODA_ADDR			0x220
#define   PHB_IODA_AD_AUTOINC		PPC_BIT(0)
#define	  PHB_IODA_AD_TSEL		PPC_BITMASK(11,15)
#define	  PHB_IODA_AD_TADR		PPC_BITMASK(48,63)
#define PHB_IODA_DATA0			0x228
#define PHB_IODA_DATA1			0x230
#define PHB_LOCK2			0x240
#define PHB_XIVE_UPDATE			0x248
#define PHB_PHB2_GEN_CAP		0x250
#define PHB_PHB2_TCE_CAP		0x258
#define PHB_PHB2_IRQ_CAP		0x260
#define PHB_PHB2_EEH_CAP		0x268
#define PHB_PAPR_ERR_INJ_CTL		0x2b0
#define   PHB_PAPR_ERR_INJ_CTL_INB	PPC_BIT(0)
#define   PHB_PAPR_ERR_INJ_CTL_OUTB	PPC_BIT(1)
#define   PHB_PAPR_ERR_INJ_CTL_STICKY	PPC_BIT(2)
#define   PHB_PAPR_ERR_INJ_CTL_CFG	PPC_BIT(3)
#define   PHB_PAPR_ERR_INJ_CTL_RD	PPC_BIT(4)
#define   PHB_PAPR_ERR_INJ_CTL_WR	PPC_BIT(5)
#define   PHB_PAPR_ERR_INJ_CTL_FREEZE	PPC_BIT(6)
#define PHB_PAPR_ERR_INJ_ADDR		0x2b8
#define PHB_PAPR_ERR_INJ_MASK		0x2c0
#define   PHB_PAPR_ERR_INJ_MASK_CFG		PPC_BITMASK(4,11)
#define   PHB_PAPR_ERR_INJ_MASK_MMIO		PPC_BITMASK(16,39)	/* 16M aligned */
#define   PHB_PAPR_ERR_INJ_MASK_IO		PPC_BITMASK(16,47)	/* 64K aligned */
#define   PHB_PAPR_ERR_INJ_MASK_DMA		PPC_BITMASK(60,63)	/* 16 window */
#define PHB_ETU_ERR_SUMMARY		0x2c8

/*  UTL registers */
#define UTL_SYS_BUS_CONTROL		0x400
#define UTL_STATUS			0x408
#define UTL_SYS_BUS_AGENT_STATUS	0x410
#define UTL_SYS_BUS_AGENT_ERR_SEVERITY	0x418
#define UTL_SYS_BUS_AGENT_IRQ_EN	0x420
#define UTL_SYS_BUS_BURST_SZ_CONF	0x440
#define UTL_REVISION_ID			0x448
#define UTL_OUT_POST_HDR_BUF_ALLOC	0x4c0
#define UTL_OUT_POST_DAT_BUF_ALLOC	0x4d0
#define UTL_IN_POST_HDR_BUF_ALLOC	0x4e0
#define UTL_IN_POST_DAT_BUF_ALLOC	0x4f0
#define UTL_OUT_NP_BUF_ALLOC		0x500
#define UTL_IN_NP_BUF_ALLOC		0x510
#define UTL_PCIE_TAGS_ALLOC		0x520
#define UTL_GBIF_READ_TAGS_ALLOC	0x530
#define UTL_PCIE_PORT_CONTROL		0x540
#define UTL_PCIE_PORT_STATUS		0x548
#define UTL_PCIE_PORT_ERROR_SEV		0x550
#define UTL_PCIE_PORT_IRQ_EN		0x558
#define UTL_RC_STATUS			0x560
#define UTL_RC_ERR_SEVERITY		0x568
#define UTL_RC_IRQ_EN			0x570
#define UTL_EP_STATUS			0x578
#define UTL_EP_ERR_SEVERITY		0x580
#define UTL_EP_ERR_IRQ_EN		0x588
#define UTL_PCI_PM_CTRL1		0x590
#define UTL_PCI_PM_CTRL2		0x598
#define UTL_GP_CTL1			0x5a0
#define UTL_GP_CTL2			0x5a8

/* PCI-E Stack registers */
#define PHB_PCIE_SYSTEM_CONFIG		0x600
#define PHB_PCIE_BUS_NUMBER		0x608
#define PHB_PCIE_SYSTEM_TEST		0x618
#define PHB_PCIE_LINK_MANAGEMENT	0x630
#define PHB_PCIE_DLP_TRAIN_CTL		0x640
#define   PHB_PCIE_DLP_TCTX_DISABLE	PPC_BIT(1)
#define   PHB_PCIE_DLP_TCRX_DISABLED	PPC_BIT(16)
#define   PHB_PCIE_DLP_TC_DL_LINKUP	PPC_BIT(21)
#define   PHB_PCIE_DLP_TC_DL_PGRESET	PPC_BIT(22)
#define   PHB_PCIE_DLP_TC_DL_LINKACT	PPC_BIT(23)
#define PHB_PCIE_SLOP_LOOPBACK_STATUS	0x648
#define PHB_PCIE_AER_CONTROL		0x650
#define PHB_PCIE_AUX_POWER_CONTROL	0x658
#define PHB_PCIE_SLOTCTL1		0x660
#define PHB_PCIE_SLOTCTL2		0x668
#define   PHB_PCIE_SLOTCTL2_SLOTWAKE	PPC_BIT(16)
#define   PHB_PCIE_SLOTCTL2_PWR_EN_STAT	PPC_BIT(17)
#define   PHB_PCIE_SLOTCTL2_RCK_EN_STAT	PPC_BIT(18)
#define   PHB_PCIE_SLOTCTL2_PERST_STAT	PPC_BIT(19)
#define   PHB_PCIE_SLOTCTL2_PLED_S	PPC_BITMASK(20,21) /* use PCIE_INDIC_* */
#define   PHB_PCIE_SLOTCTL2_ALED_S	PPC_BITMASK(22,23)
#define   PHB_PCIE_SLOTCTL2_PRSTN_STAT	PPC_BIT(24)
#define   PHB_PCIE_SLOTCTL2_PWRFLT_STAT	PPC_BIT(25)
#define PHB_PCIE_UTL_CONFIG		0x670
#define PHB_PCIE_DLP_CONTROL		0x678
#define PHB_PCIE_UTL_ERRLOG1		0x680
#define PHB_PCIE_UTL_ERRLOG2		0x688
#define PHB_PCIE_UTL_ERRLOG3		0x690
#define PHB_PCIE_UTL_ERRLOG4		0x698
#define PHB_PCIE_DLP_ERRLOG1		0x6a0
#define PHB_PCIE_DLP_ERRLOG2		0x6a8
#define PHB_PCIE_UTL_ERR_INJECT		0x6c0
#define PHB_PCIE_TLDLP_ERR_INJECT	0x6c8
#define PHB_PCIE_STRAPPING		0x700

/* Fundamental register set B */
#define PHB_VERSION			0x800
#define PHB_RESET			0x808
#define PHB_CONTROL			0x810
#define PHB_AIB_RX_CRED_INIT_TIMER	0x818
#define PHB_AIB_RX_CMD_CRED		0x820
#define PHB_AIB_RX_DATA_CRED		0x828
#define PHB_AIB_TX_CMD_CRED		0x830
#define PHB_AIB_TX_DATA_CRED		0x838
#define PHB_AIB_TX_CHAN_MAPPING		0x840
#define PHB_AIB_TX_CRED_SYNC_CTRL	0x848
#define PHB_LEGACY_CTRL			0x850
#define PHB_AIB_TAG_ENABLE		0x858
#define PHB_AIB_FENCE_CTRL		0x860
#define PHB_TCE_TAG_ENABLE		0x868
#define PHB_TCE_WATERMARK		0x870
#define PHB_TIMEOUT_CTRL1		0x878
#define PHB_TIMEOUT_CTRL2		0x880
#define PHB_QUIESCE_DMA_G		0x888
#define PHB_AIB_TAG_STATUS		0x900
#define PHB_TCE_TAG_STATUS		0x908

/* FIR & Error registers */
#define PHB_LEM_FIR_ACCUM		0xc00
#define PHB_LEM_FIR_AND_MASK		0xc08
#define PHB_LEM_FIR_OR_MASK		0xc10
#define PHB_LEM_ERROR_MASK		0xc18
#define PHB_LEM_ERROR_AND_MASK		0xc20
#define PHB_LEM_ERROR_OR_MASK		0xc28
#define PHB_LEM_ACTION0			0xc30
#define PHB_LEM_ACTION1			0xc38
#define PHB_LEM_WOF			0xc40
#define PHB_ERR_STATUS			0xc80
#define PHB_ERR1_STATUS			0xc88
#define PHB_ERR_INJECT			0xc90
#define PHB_ERR_LEM_ENABLE		0xc98
#define PHB_ERR_IRQ_ENABLE		0xca0
#define PHB_ERR_FREEZE_ENABLE		0xca8
#define PHB_ERR_AIB_FENCE_ENABLE	0xcb0
#define PHB_ERR_LOG_0			0xcc0
#define PHB_ERR_LOG_1			0xcc8
#define PHB_ERR_STATUS_MASK		0xcd0
#define PHB_ERR1_STATUS_MASK		0xcd8

#define PHB_OUT_ERR_STATUS		0xd00
#define PHB_OUT_ERR1_STATUS		0xd08
#define PHB_OUT_ERR_INJECT		0xd10
#define PHB_OUT_ERR_LEM_ENABLE		0xd18
#define PHB_OUT_ERR_IRQ_ENABLE		0xd20
#define PHB_OUT_ERR_FREEZE_ENABLE	0xd28
#define PHB_OUT_ERR_AIB_FENCE_ENABLE	0xd30
#define PHB_OUT_ERR_LOG_0		0xd40
#define PHB_OUT_ERR_LOG_1		0xd48
#define PHB_OUT_ERR_STATUS_MASK		0xd50
#define PHB_OUT_ERR1_STATUS_MASK	0xd58

#define PHB_INA_ERR_STATUS		0xd80
#define PHB_INA_ERR1_STATUS		0xd88
#define PHB_INA_ERR_INJECT		0xd90
#define PHB_INA_ERR_LEM_ENABLE		0xd98
#define PHB_INA_ERR_IRQ_ENABLE		0xda0
#define PHB_INA_ERR_FREEZE_ENABLE	0xda8
#define PHB_INA_ERR_AIB_FENCE_ENABLE	0xdb0
#define PHB_INA_ERR_LOG_0		0xdc0
#define PHB_INA_ERR_LOG_1		0xdc8
#define PHB_INA_ERR_STATUS_MASK		0xdd0
#define PHB_INA_ERR1_STATUS_MASK	0xdd8

#define PHB_INB_ERR_STATUS		0xe00
#define PHB_INB_ERR1_STATUS		0xe08
#define PHB_INB_ERR_INJECT		0xe10
#define PHB_INB_ERR_LEM_ENABLE		0xe18
#define PHB_INB_ERR_IRQ_ENABLE		0xe20
#define PHB_INB_ERR_FREEZE_ENABLE	0xe28
#define PHB_INB_ERR_AIB_FENCE_ENABLE	0xe30
#define PHB_INB_ERR_LOG_0		0xe40
#define PHB_INB_ERR_LOG_1		0xe48
#define PHB_INB_ERR_STATUS_MASK		0xe50
#define PHB_INB_ERR1_STATUS_MASK	0xe58

/* Performance monitor & Debug registers */
#define PHB_TRACE_CONTROL		0xf80
#define PHB_PERFMON_CONFIG		0xf88
#define PHB_PERFMON_CTR0		0xf90
#define PHB_PERFMON_CTR1		0xf98
#define PHB_PERFMON_CTR2		0xfa0
#define PHB_PERFMON_CTR3		0xfa8
#define PHB_HOTPLUG_OVERRIDE		0xfb0

/*
 * IODA tables
 */

#define IODA_TBL_HRT		0
#define IODA_TBL_LIST		1
#define IODA_TBL_LXIVT		2
#define IODA_TBL_MIST		3
#define IODA_TBL_MXIVT		4
#define IODA_TBL_MVT		5
#define IODA_TBL_PELTM		6
#define IODA_TBL_PESTA		7
#define IODA_TBL_PESTB		8
#define IODA_TBL_TVT		9
#define IODA_TBL_TCAM		10
#define IODA_TBL_TDR		11
#define IODA_TBL_PELTV		12
#define IODA_TBL_M64BT		16
#define IODA_TBL_IODT		17
#define IODA_TBL_M32DT		18
#define IODA_TBL_M64DT		19
#define IODA_TBL_PEEV		20

/* L/M XIVT */
#define IODA_XIVT_SERVER		PPC_BITMASK(8,23)
#define IODA_XIVT_PRIORITY		PPC_BITMASK(24,31)
#define IODA_XIVT_PENUM			PPC_BITMASK(41,47)
#define IODA_XIVT_HUBNUM		PPC_BITMASK(58,59)

/* M64BT */
#define IODA_M64BT_ENABLE		PPC_BIT(0)
#define IODA_M64BT_BASE			PPC_BITMASK(8,31)
#define IODA_M64BT_MASK			PPC_BITMASK(40,63)

/* IODT/M32DT/M64DX */
#define IODA_XXDT_PE			PPC_BITMASK(0,6)

/* PELTM */
#define IODA_PELTM_BUS			PPC_BITMASK(0,7)
#define IODA_PELTM_DEV			PPC_BITMASK(8,12)
#define IODA_PELTM_FUNC			PPC_BITMASK(13,15)
#define IODA_PELTM_BUS_VALID		PPC_BITMASK(16,18)
#define  IODA_BUS_VALID_ANY		0
#define  IODA_BUS_VALID_3_BITS		2
#define  IODA_BUS_VALID_4_BITS		3
#define  IODA_BUS_VALID_5_BITS		4
#define  IODA_BUS_VALID_6_BITS		5
#define  IODA_BUS_VALID_7_BITS		6
#define  IODA_BUS_VALID_ALL		7
#define IODA_PELTM_DEV_VALID		PPC_BIT(19)
#define IODA_PELTM_FUNC_VALID		PPC_BIT(20)

/* TVT */
#define IODA_TVT0_TABLE_ADDR		PPC_BITMASK(0,47)
#define IODA_TVT0_BUS_VALID		PPC_BITMASK(48,50)
#define IODA_TVT0_TCE_TABLE_SIZE	PPC_BITMASK(51,55)
#define IODA_TVT0_BUS_NUM		PPC_BITMASK(56,63)
#define IODA_TVT1_DEV_VALID		PPC_BIT(2)
#define IODA_TVT1_DEV_NUM		PPC_BITMASK(3,7)
#define IODA_TVT1_HUB_NUM		PPC_BITMASK(10,11)
#define IODA_TVT1_FUNC_VALID		PPC_BIT(12)
#define IODA_TVT1_FUNC_NUM		PPC_BITMASK(13,15)
#define IODA_TVT1_IO_PSIZE		PPC_BITMASK(19,23)
#define IODA_TVT1_PE_NUM		PPC_BITMASK(57,63)

/* MVT */
#define IODA_MVT_VALID			PPC_BIT(0)
#define IODA_MVT_BUS_VALID		PPC_BITMASK(21,23)
#define IODA_MVT_BUS_NUM		PPC_BITMASK(24,31)
#define IODA_MVT_PE_NUM			PPC_BITMASK(41,47)
#define IODA_MVT_DEV_VALID		PPC_BIT(50)
#define IODA_MVT_DEV_NUM		PPC_BITMASK(51,55)
#define IODA_MVT_FUNC_VALID		PPC_BIT(60)
#define IODA_MVT_FUNC_NUM		PPC_BITMASK(61,63)

/* PESTA */
#define IODA_PESTA_MMIO_FROZEN		PPC_BIT(0)
#define IODA_PESTA_MMIO_CAUSE		PPC_BIT(2)
#define IODA_PESTA_CFG_READ		PPC_BIT(3)
#define IODA_PESTA_CFG_WRITE		PPC_BIT(4)
#define IODA_PESTA_TTYPE		PPC_BITMASK(5,7)
#define   PESTA_TTYPE_DMA_WRITE		0
#define   PESTA_TTYPE_MSI		1
#define   PESTA_TTYPE_DMA_READ		2
#define   PESTA_TTYPE_DMA_READ_RESP	3
#define   PESTA_TTYPE_MMIO_LOAD		4
#define   PESTA_TTYPE_MMIO_STORE	5
#define   PESTA_TTYPE_OTHER		7
#define IODA_PESTA_CA_RETURN		PPC_BIT(8)
#define IODA_PESTA_UTL_RTOS_TIMEOUT	PPC_BIT(8) /* Same bit as CA return */
#define IODA_PESTA_UR_RETURN		PPC_BIT(9)
#define IODA_PESTA_UTL_NONFATAL		PPC_BIT(10)
#define IODA_PESTA_UTL_FATAL		PPC_BIT(11)
#define IODA_PESTA_TAG_REUSE_ERROR	PPC_BIT(12)
#define IODA_PESTA_PARITY_UE		PPC_BIT(13)
#define IODA_PESTA_UTL_CORRECTABLE	PPC_BIT(14)
#define IODA_PESTA_UTL_INTERRUPT	PPC_BIT(15)
#define IODA_PESTA_MMIO_XLATE		PPC_BIT(16)
#define IODA_PESTA_IODA_ERROR		PPC_BIT(16) /* Same bit as MMIO xlate */
#define IODA_PESTA_TVT_EXT_ERROR	PPC_BIT(17)
#define IODA_PESTA_TCE_PAGE_FAULT	PPC_BIT(18)
#define IODA_PESTA_TCE_ACCESS_FAULT	PPC_BIT(19)
#define IODA_PESTA_DMA_RESP_TIMEOUT	PPC_BIT(20)
#define IODA_PESTA_AIB_SIZE_INVALID	PPC_BIT(21)
#define IODA_PESTA_LEM_BIT		PPC_BITMASK(26,31)
#define IODA_PESTA_RID			PPC_BITMASK(32,47)
#define IODA_PESTA_MSI_DATA		PPC_BITMASK(48,63)

/* PESTB */
#define IODA_PESTB_DMA_STOPPED		PPC_BIT(0)
#define IODA_PESTB_FAIL_ADDR		PPC_BITMASK(3,63)

#endif /* __P7IOC_REGS_H */
