/*
 * "streamable kanji code filter and converter"
 * Copyright (c) 1998-2002 HappySize, Inc. All rights reserved.
 *
 * LICENSE NOTICES
 *
 * This file is part of "streamable kanji code filter and converter",
 * which is distributed under the terms of GNU Lesser General Public
 * License (version 2) as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with "streamable kanji code filter and converter";
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place,
 * Suite 330, Boston, MA  02111-1307  USA
 *
 * The author of this file: Rui Hirokawa <hirokawa@php.net>
 *
 */

#ifndef UNICODE_TABLE_CNS11643_H
#define UNICODE_TABLE_CNS11643_H

/*
 * Unicode table
 */

/* CNS11643 -> UCS */
static const unsigned short cns11643_1_ucs_table[] = {
0x3000,0xff0c,0x3001,0x3002,0xff0e,0x30fb,0xff1b,0xff1a,
0xff1f,0xff01,0xfe30,0x2026,0x2025,0xfe50,0xfe51,0xfe52,
0x00b7,0xfe54,0xfe55,0xfe56,0xfe57,0xfe31,0x2014,0xfe32,
0x2013,0x0000,0x0000,0x0000,0x0000,0xff08,0xff09,0xfe35,
0xfe36,0xff5b,0xff5d,0xfe37,0xfe38,0x3014,0x3015,0xfe39,
0xfe3a,0x3010,0x3011,0xfe3b,0xfe3c,0x300a,0x300b,0xfe3d,
0xfe3e,0x3008,0x3009,0xfe3f,0xfe40,0x300c,0x300d,0xfe41,
0xfe42,0x300e,0x300f,0xfe43,0xfe44,0xfe59,0xfe5a,0xfe5b,
0xfe5c,0xfe5d,0xfe5e,0x2018,0x2019,0x201c,0x201d,0x301d,
0x301e,0x2032,0x2035,0xff03,0xff06,0xff0a,0x203b,0x00a7,
0x3003,0x25cb,0x25cf,0x25b3,0x25b2,0x25ce,0x2606,0x2605,
0x25c7,0x25c6,0x25a1,0x25a0,0x25bd,0x25bc,0x32a3,0x2105,
0x203e,0x0000,0xff3f,0x0000,0xfe49,0xfe4a,0xfe4d,0xfe4e,
0xfe4b,0xfe4c,0xfe5f,0xfe60,0xfe61,0xff0b,0xff0d,0x00d7,
0x00f7,0x00b1,0x221a,0xff1c,0xff1e,0xff1d,0x2266,0x2267,
0x2260,0x221e,0x2252,0x2261,0xfe62,0xfe63,0xfe64,0xfe66,
0xfe65,0x223c,0x2229,0x222a,0x22a5,0x2220,0x221f,0x22bf,
0x33d2,0x33d1,0x222b,0x222e,0x2235,0x2234,0x2640,0x2642,
0x2641,0x2609,0x2191,0x2193,0x2192,0x2190,0x2196,0x2197,
0x2199,0x2198,0x2016,0xff5c,0xff0f,0xff3c,0x2215,0xfe68,
0xff04,0xffe5,0x3012,0xffe0,0xffe1,0xff05,0xff20,0x2103,
0x2109,0xfe69,0xfe6a,0xfe6b,0x33d5,0x339c,0x339d,0x339e,
0x33ce,0x33a1,0x338e,0x338f,0x33c4,0x00b0,0x5159,0x515b,
0x515e,0x515d,0x5161,0x5163,0x55e7,0x74e9,0x7cce,0x2581,
0x2582,0x2583,0x2584,0x2585,0x2586,0x2587,0x2588,0x258f,
0x258e,0x258d,0x258c,0x258b,0x258a,0x2589,0x253c,0x2534,
0x252c,0x2524,0x251c,0x2594,0x2500,0x2502,0x2595,0x250c,
0x2510,0x2514,0x2518,0x256d,0x256e,0x2570,0x256f,0x2550,
0x255e,0x256a,0x2561,0x25e2,0x25e3,0x25e5,0x25e4,0x2571,
0x2572,0x2573,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0xff10,0xff11,0xff12,0xff13,0xff14,0xff15,
0xff16,0xff17,0xff18,0xff19,0x2160,0x2161,0x2162,0x2163,
0x2164,0x2165,0x2166,0x2167,0x2168,0x2169,0x3021,0x3022,
0x3023,0x3024,0x3025,0x3026,0x3027,0x3028,0x3029,0x0000,
0x5344,0x0000,0xff21,0xff22,0xff23,0xff24,0xff25,0xff26,
0xff27,0xff28,0xff29,0xff2a,0xff2b,0xff2c,0xff2d,0xff2e,
0xff2f,0xff30,0xff31,0xff32,0xff33,0xff34,0xff35,0xff36,
0xff37,0xff38,0xff39,0xff3a,0xff41,0xff42,0xff43,0xff44,
0xff45,0xff46,0xff47,0xff48,0xff49,0xff4a,0xff4b,0xff4c,
0xff4d,0xff4e,0xff4f,0xff50,0xff51,0xff52,0xff53,0xff54,
0xff55,0xff56,0xff57,0xff58,0xff59,0xff5a,0x0391,0x0392,
0x0393,0x0394,0x0395,0x0396,0x0397,0x0398,0x0399,0x039a,
0x039b,0x039c,0x039d,0x039e,0x039f,0x03a0,0x03a1,0x03a3,
0x03a4,0x03a5,0x03a6,0x03a7,0x03a8,0x03a9,0x03b1,0x03b2,
0x03b3,0x03b4,0x03b5,0x03b6,0x03b7,0x03b8,0x03b9,0x03ba,
0x03bb,0x03bc,0x03bd,0x03be,0x03bf,0x03c0,0x03c1,0x03c3,
0x03c4,0x03c5,0x03c6,0x03c7,0x03c8,0x03c9,0x3105,0x3106,
0x3107,0x3108,0x3109,0x310a,0x310b,0x310c,0x310d,0x310e,
0x310f,0x3110,0x3111,0x3112,0x3113,0x3114,0x3115,0x3116,
0x3117,0x3118,0x3119,0x311a,0x311b,0x311c,0x311d,0x311e,
0x311f,0x3120,0x3121,0x3122,0x3123,0x3124,0x3125,0x3126,
0x3127,0x3128,0x3129,0x02d9,0x02c9,0x02ca,0x02c7,0x02cb,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2460,0x2461,
0x2462,0x2463,0x2464,0x2465,0x2466,0x2467,0x2468,0x2469,
0x2474,0x2475,0x2476,0x2477,0x2478,0x2479,0x247a,0x247b,
0x247c,0x247d,0x2170,0x2171,0x2172,0x2173,0x2174,0x2175,
0x2176,0x2177,0x2178,0x2179,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2400,0x2401,
0x2402,0x2403,0x2404,0x2405,0x2406,0x2407,0x2408,0x2409,
0x240a,0x240b,0x240c,0x240d,0x240e,0x240f,0x2410,0x2411,
0x2412,0x2413,0x2414,0x2415,0x2416,0x2417,0x2418,0x2419,
0x241a,0x241b,0x241c,0x241d,0x241e,0x241f,0x2421,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x4e00,0x4e59,0x4e01,0x4e03,0x4e43,0x4e5d,
0x4e86,0x4e8c,0x4eba,0x513f,0x5165,0x516b,0x51e0,0x5200,
0x5201,0x529b,0x5315,0x5341,0x535c,0x53c8,0x4e09,0x4e0b,
0x4e08,0x4e0a,0x4e2b,0x4e38,0x51e1,0x4e45,0x4e48,0x4e5f,
0x4e5e,0x4e8e,0x4ea1,0x5140,0x5203,0x52fa,0x5343,0x53c9,
0x53e3,0x571f,0x58eb,0x5915,0x5927,0x5973,0x5b50,0x5b51,
0x5b53,0x5bf8,0x5c0f,0x5c22,0x5c38,0x5c71,0x5ddd,0x5de5,
0x5df1,0x5df2,0x5df3,0x5dfe,0x5e72,0x5efe,0x5f0b,0x5f13,
0x624d,0x4e11,0x4e10,0x4e0d,0x4e2d,0x4e30,0x4e39,0x4e4b,
0x5c39,0x4e88,0x4e91,0x4e95,0x4e92,0x4e94,0x4ea2,0x4ec1,
0x4ec0,0x4ec3,0x4ec6,0x4ec7,0x4ecd,0x4eca,0x4ecb,0x4ec4,
0x5143,0x5141,0x5167,0x516d,0x516e,0x516c,0x5197,0x51f6,
0x5206,0x5207,0x5208,0x52fb,0x52fe,0x52ff,0x5316,0x5339,
0x5348,0x5347,0x5345,0x535e,0x5384,0x53cb,0x53ca,0x53cd,
0x58ec,0x5929,0x592b,0x592a,0x592d,0x5b54,0x5c11,0x5c24,
0x5c3a,0x5c6f,0x5df4,0x5e7b,0x5eff,0x5f14,0x5f15,0x5fc3,
0x6208,0x6236,0x624b,0x624e,0x652f,0x6587,0x6597,0x65a4,
0x65b9,0x65e5,0x66f0,0x6708,0x6728,0x6b20,0x6b62,0x6b79,
0x6bcb,0x6bd4,0x6bdb,0x6c0f,0x6c34,0x706b,0x722a,0x7236,
0x723b,0x7247,0x7259,0x725b,0x72ac,0x738b,0x4e19,0x4e16,
0x4e15,0x4e14,0x4e18,0x4e3b,0x4e4d,0x4e4f,0x4e4e,0x4ee5,
0x4ed8,0x4ed4,0x4ed5,0x4ed6,0x4ed7,0x4ee3,0x4ee4,0x4ed9,
0x4ede,0x5145,0x5144,0x5189,0x518a,0x51ac,0x51f9,0x51fa,
0x51f8,0x520a,0x52a0,0x529f,0x5305,0x5306,0x5317,0x531d,
0x4edf,0x534a,0x5349,0x5361,0x5360,0x536f,0x536e,0x53bb,
0x53ef,0x53e4,0x53f3,0x53ec,0x53ee,0x53e9,0x53e8,0x53fc,
0x53f8,0x53f5,0x53eb,0x53e6,0x53ea,0x53f2,0x53f1,0x53f0,
0x53e5,0x53ed,0x53fb,0x56db,0x56da,0x5916,0x592e,0x5931,
0x5974,0x5976,0x5b55,0x5b83,0x5c3c,0x5de8,0x5de7,0x5de6,
0x5e02,0x5e03,0x5e73,0x5e7c,0x5f01,0x5f18,0x5f17,0x5fc5,
0x620a,0x6253,0x6254,0x6252,0x6251,0x65a5,0x65e6,0x672e,
0x672c,0x672a,0x672b,0x672d,0x6b63,0x6bcd,0x6c11,0x6c10,
0x6c38,0x6c41,0x6c40,0x6c3e,0x72af,0x7384,0x7389,0x74dc,
0x74e6,0x7518,0x751f,0x7528,0x7529,0x7530,0x7531,0x7532,
0x7533,0x758b,0x767d,0x76ae,0x76bf,0x76ee,0x77db,0x77e2,
0x77f3,0x793a,0x79be,0x7a74,0x7acb,0x4e1e,0x4e1f,0x4e52,
0x4e53,0x4e69,0x4e99,0x4ea4,0x4ea6,0x4ea5,0x4eff,0x4f09,
0x4f19,0x4f0a,0x4f15,0x4f0d,0x4f10,0x4f11,0x4f0f,0x4ef2,
0x4ef6,0x4efb,0x4ef0,0x4ef3,0x4efd,0x4f01,0x4f0b,0x5149,
0x5147,0x5146,0x5148,0x5168,0x5171,0x518d,0x51b0,0x5217,
0x5211,0x5212,0x520e,0x5216,0x52a3,0x5308,0x5321,0x5320,
0x5370,0x5371,0x5409,0x540f,0x540c,0x540a,0x5410,0x5401,
0x540b,0x5404,0x5411,0x540d,0x5408,0x5403,0x540e,0x5406,
0x5412,0x56e0,0x56de,0x56dd,0x5733,0x5730,0x5728,0x572d,
0x572c,0x572f,0x5729,0x5919,0x591a,0x5937,0x5938,0x5984,
0x5978,0x5983,0x597d,0x5979,0x5982,0x5981,0x5b57,0x5b58,
0x5b87,0x5b88,0x5b85,0x5b89,0x5bfa,0x5c16,0x5c79,0x5dde,
0x5e06,0x5e76,0x5e74,0x5f0f,0x5f1b,0x5fd9,0x5fd6,0x620e,
0x620c,0x620d,0x6210,0x6263,0x625b,0x6258,0x6536,0x65e9,
0x65e8,0x65ec,0x65ed,0x66f2,0x66f3,0x6709,0x673d,0x6734,
0x6731,0x6735,0x6b21,0x6b64,0x6b7b,0x6c16,0x6c5d,0x6c57,
0x6c59,0x6c5f,0x6c60,0x6c50,0x6c55,0x6c61,0x6c5b,0x6c4d,
0x6c4e,0x7070,0x725f,0x725d,0x767e,0x7af9,0x7c73,0x7cf8,
0x7f36,0x7f8a,0x7fbd,0x8001,0x8003,0x800c,0x8012,0x8033,
0x807f,0x8089,0x808b,0x808c,0x81e3,0x81ea,0x81f3,0x81fc,
0x820c,0x821b,0x821f,0x826e,0x8272,0x827e,0x866b,0x8840,
0x884c,0x8863,0x897f,0x9621,0x4e32,0x4ea8,0x4f4d,0x4f4f,
0x4f47,0x4f57,0x4f5e,0x4f34,0x4f5b,0x4f55,0x4f30,0x4f50,
0x4f51,0x4f3d,0x4f3a,0x4f38,0x4f43,0x4f54,0x4f3c,0x4f46,
0x4f63,0x4f5c,0x4f60,0x4f2f,0x4f4e,0x4f36,0x4f59,0x4f5d,
0x4f48,0x4f5a,0x514c,0x514b,0x514d,0x5175,0x51b6,0x51b7,
0x5225,0x5224,0x5229,0x522a,0x5228,0x52ab,0x52a9,0x52aa,
0x52ac,0x5323,0x5373,0x5375,0x541d,0x542d,0x541e,0x543e,
0x5426,0x544e,0x5427,0x5446,0x5443,0x5433,0x5448,0x5442,
0x541b,0x5429,0x544a,0x5439,0x543b,0x5438,0x542e,0x5435,
0x5436,0x5420,0x543c,0x5440,0x5431,0x542b,0x541f,0x542c,
0x56ea,0x56f0,0x56e4,0x56eb,0x574a,0x5751,0x5740,0x574d,
0x5747,0x574e,0x573e,0x5750,0x574f,0x573b,0x58ef,0x593e,
0x599d,0x5992,0x59a8,0x599e,0x59a3,0x5999,0x5996,0x598d,
0x59a4,0x5993,0x598a,0x59a5,0x5b5d,0x5b5c,0x5b5a,0x5b5b,
0x5b8c,0x5b8b,0x5b8f,0x5c2c,0x5c40,0x5c41,0x5c3f,0x5c3e,
0x5c90,0x5c91,0x5c94,0x5c8c,0x5deb,0x5e0c,0x5e8f,0x5e87,
0x5e8a,0x5ef7,0x5f04,0x5f1f,0x5f64,0x5f62,0x5f77,0x5f79,
0x5fd8,0x5fcc,0x5fd7,0x5fcd,0x5ff1,0x5feb,0x5ff8,0x5fea,
0x6212,0x6211,0x6284,0x6297,0x6296,0x6280,0x6276,0x6289,
0x626d,0x628a,0x627c,0x627e,0x6279,0x6273,0x6292,0x626f,
0x6298,0x626e,0x6295,0x6293,0x6291,0x6286,0x6539,0x653b,
0x6538,0x65f1,0x66f4,0x675f,0x674e,0x674f,0x6750,0x6751,
0x675c,0x6756,0x675e,0x6749,0x6746,0x6760,0x6753,0x6757,
0x6b65,0x6bcf,0x6c42,0x6c5e,0x6c99,0x6c81,0x6c88,0x6c89,
0x6c85,0x6c9b,0x6c6a,0x6c7a,0x6c90,0x6c70,0x6c8c,0x6c68,
0x6c96,0x6c92,0x6c7d,0x6c83,0x6c72,0x6c7e,0x6c74,0x6c86,
0x6c76,0x6c8d,0x6c94,0x6c98,0x6c82,0x7076,0x707c,0x707d,
0x7078,0x7262,0x7261,0x7260,0x72c4,0x72c2,0x7396,0x752c,
0x752b,0x7537,0x7538,0x7682,0x76ef,0x77e3,0x79c1,0x79c0,
0x79bf,0x7a76,0x7cfb,0x7f55,0x8096,0x8093,0x809d,0x8098,
0x809b,0x809a,0x80b2,0x826f,0x8292,0x828b,0x828d,0x898b,
0x89d2,0x8a00,0x8c37,0x8c46,0x8c55,0x8c9d,0x8d64,0x8d70,
0x8db3,0x8eab,0x8eca,0x8f9b,0x8fb0,0x8fc2,0x8fc6,0x8fc5,
0x8fc4,0x5de1,0x9091,0x90a2,0x90aa,0x90a6,0x90a3,0x9149,
0x91c6,0x91cc,0x9632,0x962e,0x9631,0x962a,0x962c,0x4e26,
0x4e56,0x4e73,0x4e8b,0x4e9b,0x4e9e,0x4eab,0x4eac,0x4f6f,
0x4f9d,0x4f8d,0x4f73,0x4f7f,0x4f6c,0x4f9b,0x4f8b,0x4f86,
0x4f83,0x4f70,0x4f75,0x4f88,0x4f69,0x4f7b,0x4f96,0x4f7e,
0x4f8f,0x4f91,0x4f7a,0x5154,0x5152,0x5155,0x5169,0x5177,
0x5176,0x5178,0x51bd,0x51fd,0x523b,0x5238,0x5237,0x523a,
0x5230,0x522e,0x5236,0x5241,0x52be,0x52bb,0x5352,0x5354,
0x5353,0x5351,0x5366,0x5377,0x5378,0x5379,0x53d6,0x53d4,
0x53d7,0x5473,0x5475,0x5496,0x5478,0x5495,0x5480,0x547b,
0x5477,0x5484,0x5492,0x5486,0x547c,0x5490,0x5471,0x5476,
0x548c,0x549a,0x5462,0x5468,0x548b,0x547d,0x548e,0x56fa,
0x5783,0x5777,0x576a,0x5769,0x5761,0x5766,0x5764,0x577c,
0x591c,0x5949,0x5947,0x5948,0x5944,0x5954,0x59be,0x59bb,
0x59d4,0x59b9,0x59ae,0x59d1,0x59c6,0x59d0,0x59cd,0x59cb,
0x59d3,0x59ca,0x59af,0x59b3,0x59d2,0x59c5,0x5b5f,0x5b64,
0x5b63,0x5b97,0x5b9a,0x5b98,0x5b9c,0x5b99,0x5b9b,0x5c1a,
0x5c48,0x5c45,0x5c46,0x5cb7,0x5ca1,0x5cb8,0x5ca9,0x5cab,
0x5cb1,0x5cb3,0x5e18,0x5e1a,0x5e16,0x5e15,0x5e1b,0x5e11,
0x5e78,0x5e9a,0x5e97,0x5e9c,0x5e95,0x5e96,0x5ef6,0x5f26,
0x5f27,0x5f29,0x5f80,0x5f81,0x5f7f,0x5f7c,0x5fdd,0x5fe0,
0x5ffd,0x5ff5,0x5fff,0x600f,0x6014,0x602f,0x6035,0x6016,
0x602a,0x6015,0x6021,0x6027,0x6029,0x602b,0x601b,0x6216,
0x6215,0x623f,0x623e,0x6240,0x627f,0x62c9,0x62cc,0x62c4,
0x62bf,0x62c2,0x62b9,0x62d2,0x62db,0x62ab,0x62d3,0x62d4,
0x62cb,0x62c8,0x62a8,0x62bd,0x62bc,0x62d0,0x62d9,0x62c7,
0x62cd,0x62b5,0x62da,0x62b1,0x62d8,0x62d6,0x62d7,0x62c6,
0x62ac,0x62ce,0x653e,0x65a7,0x65bc,0x65fa,0x6614,0x6613,
0x660c,0x6606,0x6602,0x660e,0x6600,0x660f,0x6615,0x660a,
0x6607,0x670d,0x670b,0x676d,0x678b,0x6795,0x6771,0x679c,
0x6773,0x6777,0x6787,0x679d,0x6797,0x676f,0x6770,0x677f,
0x6789,0x677e,0x6790,0x6775,0x679a,0x6793,0x677c,0x676a,
0x6772,0x6b23,0x6b66,0x6b67,0x6b7f,0x6c13,0x6c1b,0x6ce3,
0x6ce8,0x6cf3,0x6cb1,0x6ccc,0x6ce5,0x6cb3,0x6cbd,0x6cbe,
0x6cbc,0x6ce2,0x6cab,0x6cd5,0x6cd3,0x6cb8,0x6cc4,0x6cb9,
0x6cc1,0x6cae,0x6cd7,0x6cc5,0x6cf1,0x6cbf,0x6cbb,0x6ce1,
0x6cdb,0x6cca,0x6cac,0x6cef,0x6cdc,0x6cd6,0x6ce0,0x7095,
0x708e,0x7092,0x708a,0x7099,0x722c,0x722d,0x7238,0x7248,
0x7267,0x7269,0x72c0,0x72ce,0x72d9,0x72d7,0x72d0,0x73a9,
0x73a8,0x739f,0x73ab,0x73a5,0x753d,0x759d,0x7599,0x759a,
0x7684,0x76c2,0x76f2,0x76f4,0x77e5,0x77fd,0x793e,0x7940,
0x7941,0x79c9,0x79c8,0x7a7a,0x7a79,0x7afa,0x7cfe,0x7f54,
0x7f8c,0x7f8b,0x8005,0x80ba,0x80a5,0x80a2,0x80b1,0x80a1,
0x80ab,0x80a9,0x80b4,0x80aa,0x80af,0x81e5,0x81fe,0x820d,
0x82b3,0x829d,0x8299,0x82ad,0x82bd,0x829f,0x82b9,0x82b1,
0x82ac,0x82a5,0x82af,0x82b8,0x82a3,0x82b0,0x82be,0x82b7,
0x864e,0x8671,0x521d,0x8868,0x8ecb,0x8fce,0x8fd4,0x8fd1,
0x90b5,0x90b8,0x90b1,0x90b6,0x91c7,0x91d1,0x9577,0x9580,
0x961c,0x9640,0x963f,0x963b,0x9644,0x9642,0x96b9,0x96e8,
0x9752,0x975e,0x4e9f,0x4ead,0x4eae,0x4fe1,0x4fb5,0x4faf,
0x4fbf,0x4fe0,0x4fd1,0x4fcf,0x4fdd,0x4fc3,0x4fb6,0x4fd8,
0x4fdf,0x4fca,0x4fd7,0x4fae,0x4fd0,0x4fc4,0x4fc2,0x4fda,
0x4fce,0x4fde,0x4fb7,0x5157,0x5192,0x5191,0x51a0,0x524e,
0x5243,0x524a,0x524d,0x524c,0x524b,0x5247,0x52c7,0x52c9,
0x52c3,0x52c1,0x530d,0x5357,0x537b,0x539a,0x53db,0x54ac,
0x54c0,0x54a8,0x54ce,0x54c9,0x54b8,0x54a6,0x54b3,0x54c7,
0x54c2,0x54bd,0x54aa,0x54c1,0x54c4,0x54c8,0x54af,0x54ab,
0x54b1,0x54bb,0x54a9,0x54a7,0x54bf,0x56ff,0x5782,0x578b,
0x57a0,0x57a3,0x57a2,0x57ce,0x57ae,0x5793,0x5955,0x5951,
0x594f,0x594e,0x5950,0x59dc,0x59d8,0x59ff,0x59e3,0x59e8,
0x5a03,0x59e5,0x59ea,0x59da,0x59e6,0x5a01,0x59fb,0x5b69,
0x5ba3,0x5ba6,0x5ba4,0x5ba2,0x5ba5,0x5c01,0x5c4e,0x5c4f,
0x5c4d,0x5c4b,0x5cd9,0x5cd2,0x5df7,0x5e1d,0x5e25,0x5e1f,
0x5e7d,0x5ea0,0x5ea6,0x5efa,0x5f08,0x5f2d,0x5f65,0x5f88,
0x5f85,0x5f8a,0x5f8b,0x5f87,0x5f8c,0x5f89,0x6012,0x601d,
0x6020,0x6025,0x600e,0x6028,0x604d,0x6070,0x6068,0x6062,
0x6046,0x6043,0x606c,0x606b,0x606a,0x6064,0x6241,0x62dc,
0x6316,0x6309,0x62fc,0x62ed,0x6301,0x62ee,0x62fd,0x6307,
0x62f1,0x62f7,0x62ef,0x62ec,0x62fe,0x62f4,0x6311,0x6302,
0x653f,0x6545,0x65ab,0x65bd,0x65e2,0x6625,0x662d,0x6620,
0x6627,0x662f,0x661f,0x6628,0x6631,0x6624,0x66f7,0x67ff,
0x67d3,0x67f1,0x67d4,0x67d0,0x67ec,0x67b6,0x67af,0x67f5,
0x67e9,0x67ef,0x67c4,0x67d1,0x67b4,0x67da,0x67e5,0x67b8,
0x67cf,0x67de,0x67f3,0x67b0,0x67d9,0x67e2,0x67dd,0x67d2,
0x6b6a,0x6b83,0x6b86,0x6bb5,0x6bd2,0x6bd7,0x6c1f,0x6cc9,
0x6d0b,0x6d32,0x6d2a,0x6d41,0x6d25,0x6d0c,0x6d31,0x6d1e,
0x6d17,0x6d3b,0x6d3d,0x6d3e,0x6d36,0x6d1b,0x6cf5,0x6d39,
0x6d27,0x6d38,0x6d29,0x6d2e,0x6d35,0x6d0e,0x6d2b,0x70ab,
0x70ba,0x70b3,0x70ac,0x70af,0x70ad,0x70b8,0x70ae,0x70a4,
0x7230,0x7272,0x726f,0x7274,0x72e9,0x72e0,0x72e1,0x73b7,
0x73ca,0x73bb,0x73b2,0x73cd,0x73c0,0x73b3,0x751a,0x752d,
0x754f,0x754c,0x754e,0x754b,0x75ab,0x75a4,0x75a5,0x75a2,
0x75a3,0x7678,0x7686,0x7687,0x7688,0x76c8,0x76c6,0x76c3,
0x76c5,0x7701,0x76f9,0x76f8,0x7709,0x770b,0x76fe,0x76fc,
0x7707,0x77dc,0x7802,0x7814,0x780c,0x780d,0x7946,0x7949,
0x7948,0x7947,0x79b9,0x79ba,0x79d1,0x79d2,0x79cb,0x7a7f,
0x7a81,0x7aff,0x7afd,0x7c7d,0x7d02,0x7d05,0x7d00,0x7d09,
0x7d07,0x7d04,0x7d06,0x7f38,0x7f8e,0x7fbf,0x8010,0x800d,
0x8011,0x8036,0x80d6,0x80e5,0x80da,0x80c3,0x80c4,0x80cc,
0x80e1,0x80db,0x80ce,0x80de,0x80e4,0x80dd,0x81f4,0x8222,
0x82e7,0x8303,0x8305,0x82e3,0x82db,0x82e6,0x8304,0x82e5,
0x8302,0x8309,0x82d2,0x82d7,0x82f1,0x8301,0x82dc,0x82d4,
0x82d1,0x82de,0x82d3,0x82df,0x82ef,0x8306,0x8650,0x8679,
0x867b,0x867a,0x884d,0x886b,0x8981,0x89d4,0x8a08,0x8a02,
0x8a03,0x8c9e,0x8ca0,0x8d74,0x8d73,0x8db4,0x8ecd,0x8ecc,
0x8ff0,0x8fe6,0x8fe2,0x8fea,0x8fe5,0x8fed,0x8feb,0x8fe4,
0x8fe8,0x90ca,0x90ce,0x90c1,0x90c3,0x914b,0x914a,0x91cd,
0x9582,0x9650,0x964b,0x964c,0x964d,0x9762,0x9769,0x97cb,
0x97ed,0x97f3,0x9801,0x98a8,0x98db,0x98df,0x9996,0x9999,
0x4e58,0x4eb3,0x500c,0x500d,0x5023,0x4fef,0x5026,0x5025,
0x4ff8,0x5029,0x5016,0x5006,0x503c,0x501f,0x501a,0x5012,
0x5011,0x4ffa,0x5000,0x5014,0x5028,0x4ff1,0x5021,0x500b,
0x5019,0x5018,0x4ff3,0x4fee,0x502d,0x502a,0x4ffe,0x502b,
0x5009,0x517c,0x51a4,0x51a5,0x51a2,0x51cd,0x51cc,0x51c6,
0x51cb,0x5256,0x525c,0x5254,0x525b,0x525d,0x532a,0x537f,
0x539f,0x539d,0x53df,0x54e8,0x5510,0x5501,0x5537,0x54fc,
0x54e5,0x54f2,0x5506,0x54fa,0x5514,0x54e9,0x54ed,0x54e1,
0x5509,0x54ee,0x54ea,0x54e6,0x5527,0x5507,0x54fd,0x550f,
0x5703,0x5704,0x57c2,0x57d4,0x57cb,0x57c3,0x5809,0x590f,
0x5957,0x5958,0x595a,0x5a11,0x5a18,0x5a1c,0x5a1f,0x5a1b,
0x5a13,0x59ec,0x5a20,0x5a23,0x5a29,0x5a25,0x5a0c,0x5a09,
0x5b6b,0x5c58,0x5bb0,0x5bb3,0x5bb6,0x5bb4,0x5bae,0x5bb5,
0x5bb9,0x5bb8,0x5c04,0x5c51,0x5c55,0x5c50,0x5ced,0x5cfd,
0x5cfb,0x5cea,0x5ce8,0x5cf0,0x5cf6,0x5d01,0x5cf4,0x5dee,
0x5e2d,0x5e2b,0x5eab,0x5ead,0x5ea7,0x5f31,0x5f92,0x5f91,
0x5f90,0x6059,0x6063,0x6065,0x6050,0x6055,0x606d,0x6069,
0x606f,0x6084,0x609f,0x609a,0x608d,0x6094,0x608c,0x6085,
0x6096,0x6247,0x62f3,0x6308,0x62ff,0x634e,0x633e,0x632f,
0x6355,0x6342,0x6346,0x634f,0x6349,0x633a,0x6350,0x633d,
0x632a,0x632b,0x6328,0x634d,0x634c,0x6548,0x6549,0x6599,
0x65c1,0x65c5,0x6642,0x6649,0x664f,0x6643,0x6652,0x664c,
0x6645,0x6641,0x66f8,0x6714,0x6715,0x6717,0x6821,0x6838,
0x6848,0x6846,0x6853,0x6839,0x6842,0x6854,0x6829,0x68b3,
0x6817,0x684c,0x6851,0x683d,0x67f4,0x6850,0x6840,0x683c,
0x6843,0x682a,0x6845,0x6813,0x6818,0x6841,0x6b8a,0x6b89,
0x6bb7,0x6c23,0x6c27,0x6c28,0x6c26,0x6c24,0x6cf0,0x6d6a,
0x6d95,0x6d88,0x6d87,0x6d66,0x6d78,0x6d77,0x6d59,0x6d93,
0x6d6c,0x6d89,0x6d6e,0x6d5a,0x6d74,0x6d69,0x6d8c,0x6d8a,
0x6d79,0x6d85,0x6d65,0x6d94,0x70ca,0x70d8,0x70e4,0x70d9,
0x70c8,0x70cf,0x7239,0x7279,0x72fc,0x72f9,0x72fd,0x72f8,
0x72f7,0x7386,0x73ed,0x7409,0x73ee,0x73e0,0x73ea,0x73de,
0x7554,0x755d,0x755c,0x755a,0x7559,0x75be,0x75c5,0x75c7,
0x75b2,0x75b3,0x75bd,0x75bc,0x75b9,0x75c2,0x75b8,0x768b,
0x76b0,0x76ca,0x76cd,0x76ce,0x7729,0x771f,0x7720,0x7728,
0x77e9,0x7830,0x7827,0x7838,0x781d,0x7834,0x7837,0x7825,
0x782d,0x7820,0x781f,0x7832,0x7955,0x7950,0x7960,0x795f,
0x7956,0x795e,0x795d,0x7957,0x795a,0x79e4,0x79e3,0x79e7,
0x79df,0x79e6,0x79e9,0x79d8,0x7a84,0x7a88,0x7ad9,0x7b06,
0x7b11,0x7c89,0x7d21,0x7d17,0x7d0b,0x7d0a,0x7d20,0x7d22,
0x7d14,0x7d10,0x7d15,0x7d1a,0x7d1c,0x7d0d,0x7d19,0x7d1b,
0x7f3a,0x7f5f,0x7f94,0x7fc5,0x7fc1,0x8006,0x8004,0x8018,
0x8015,0x8019,0x8017,0x803d,0x803f,0x80f1,0x8102,0x80f0,
0x8105,0x80ed,0x80f4,0x8106,0x80f8,0x80f3,0x8108,0x80fd,
0x810a,0x80fc,0x80ef,0x81ed,0x81ec,0x8200,0x8210,0x822a,
0x822b,0x8228,0x822c,0x82bb,0x832b,0x8352,0x8354,0x834a,
0x8338,0x8350,0x8349,0x8335,0x8334,0x834f,0x8332,0x8339,
0x8336,0x8317,0x8340,0x8331,0x8328,0x8343,0x8654,0x868a,
0x86aa,0x8693,0x86a4,0x86a9,0x868c,0x86a3,0x869c,0x8870,
0x8877,0x8881,0x8882,0x887d,0x8879,0x8a18,0x8a10,0x8a0e,
0x8a0c,0x8a15,0x8a0a,0x8a17,0x8a13,0x8a16,0x8a0f,0x8a11,
0x8c48,0x8c7a,0x8c79,0x8ca1,0x8ca2,0x8d77,0x8eac,0x8ed2,
0x8ed4,0x8ecf,0x8fb1,0x9001,0x9006,0x8ff7,0x9000,0x8ffa,
0x8ff4,0x9003,0x8ffd,0x9005,0x8ff8,0x9095,0x90e1,0x90dd,
0x90e2,0x9152,0x914d,0x914c,0x91d8,0x91dd,0x91d7,0x91dc,
0x91d9,0x9583,0x9662,0x9663,0x9661,0x965b,0x965d,0x9664,
0x9658,0x965e,0x96bb,0x98e2,0x99ac,0x9aa8,0x9ad8,0x9b25,
0x9b32,0x9b3c,0x4e7e,0x507a,0x507d,0x505c,0x5047,0x5043,
0x504c,0x505a,0x5049,0x5065,0x5076,0x504e,0x5055,0x5075,
0x5074,0x5077,0x504f,0x500f,0x506f,0x506d,0x515c,0x5195,
0x51f0,0x526a,0x526f,0x52d2,0x52d9,0x52d8,0x52d5,0x5310,
0x530f,0x5319,0x533f,0x5340,0x533e,0x53c3,0x66fc,0x5546,
0x556a,0x5566,0x5544,0x555e,0x5561,0x5543,0x554a,0x5531,
0x5556,0x554f,0x5555,0x552f,0x5564,0x5538,0x552e,0x555c,
0x552c,0x5563,0x5533,0x5541,0x5557,0x5708,0x570b,0x5709,
0x57df,0x5805,0x580a,0x5806,0x57e0,0x57e4,0x57fa,0x5802,
0x5835,0x57f7,0x57f9,0x5920,0x5962,0x5a36,0x5a41,0x5a49,
0x5a66,0x5a6a,0x5a40,0x5a3c,0x5a62,0x5a5a,0x5a46,0x5a4a,
0x5b70,0x5bc7,0x5bc5,0x5bc4,0x5bc2,0x5bbf,0x5bc6,0x5c09,
0x5c08,0x5c07,0x5c60,0x5c5c,0x5c5d,0x5d07,0x5d06,0x5d0e,
0x5d1b,0x5d16,0x5d22,0x5d11,0x5d29,0x5d14,0x5d19,0x5d24,
0x5d27,0x5d17,0x5de2,0x5e38,0x5e36,0x5e33,0x5e37,0x5eb7,
0x5eb8,0x5eb6,0x5eb5,0x5ebe,0x5f35,0x5f37,0x5f57,0x5f6c,
0x5f69,0x5f6b,0x5f97,0x5f99,0x5f9e,0x5f98,0x5fa1,0x5fa0,
0x5f9c,0x607f,0x60a3,0x6089,0x60a0,0x60a8,0x60cb,0x60b4,
0x60e6,0x60bd,0x60c5,0x60bb,0x60b5,0x60dc,0x60bc,0x60d8,
0x60d5,0x60c6,0x60df,0x60b8,0x60da,0x60c7,0x621a,0x621b,
0x6248,0x63a0,0x63a7,0x6372,0x6396,0x63a2,0x63a5,0x6377,
0x6367,0x6398,0x63aa,0x6371,0x63a9,0x6389,0x6383,0x639b,
0x636b,0x63a8,0x6384,0x6388,0x6399,0x63a1,0x63ac,0x6392,
0x638f,0x6380,0x637b,0x6369,0x6368,0x637a,0x655d,0x6556,
0x6551,0x6559,0x6557,0x555f,0x654f,0x6558,0x6555,0x6554,
0x659c,0x659b,0x65ac,0x65cf,0x65cb,0x65cc,0x65ce,0x665d,
0x665a,0x6664,0x6668,0x6666,0x665e,0x66f9,0x52d7,0x671b,
0x6881,0x68af,0x68a2,0x6893,0x68b5,0x687f,0x6876,0x68b1,
0x68a7,0x6897,0x68b0,0x6883,0x68c4,0x68ad,0x6886,0x6885,
0x6894,0x689d,0x68a8,0x689f,0x68a1,0x6882,0x6b32,0x6bba,
0x6beb,0x6bec,0x6c2b,0x6d8e,0x6dbc,0x6df3,0x6dd9,0x6db2,
0x6de1,0x6dcc,0x6de4,0x6dfb,0x6dfa,0x6e05,0x6dc7,0x6dcb,
0x6daf,0x6dd1,0x6dae,0x6dde,0x6df9,0x6db8,0x6df7,0x6df5,
0x6dc5,0x6dd2,0x6e1a,0x6db5,0x6dda,0x6deb,0x6dd8,0x6dea,
0x6df1,0x6dee,0x6de8,0x6dc6,0x6dc4,0x6daa,0x6dec,0x6dbf,
0x6de6,0x70f9,0x7109,0x710a,0x70fd,0x70ef,0x723d,0x727d,
0x7281,0x731c,0x731b,0x7316,0x7313,0x7319,0x7387,0x7405,
0x740a,0x7403,0x7406,0x73fe,0x740d,0x74e0,0x74f6,0x74f7,
0x751c,0x7522,0x7565,0x7566,0x7562,0x7570,0x758f,0x75d4,
0x75d5,0x75b5,0x75ca,0x75cd,0x768e,0x76d4,0x76d2,0x76db,
0x7737,0x773e,0x773c,0x7736,0x7738,0x773a,0x786b,0x7843,
0x784e,0x7965,0x7968,0x796d,0x79fb,0x7a92,0x7a95,0x7b20,
0x7b28,0x7b1b,0x7b2c,0x7b26,0x7b19,0x7b1e,0x7b2e,0x7c92,
0x7c97,0x7c95,0x7d46,0x7d43,0x7d71,0x7d2e,0x7d39,0x7d3c,
0x7d40,0x7d30,0x7d33,0x7d44,0x7d2f,0x7d42,0x7d32,0x7d31,
0x7f3d,0x7f9e,0x7f9a,0x7fcc,0x7fce,0x7fd2,0x801c,0x804a,
0x8046,0x812f,0x8116,0x8123,0x812b,0x8129,0x8130,0x8124,
0x8202,0x8235,0x8237,0x8236,0x8239,0x838e,0x839e,0x8398,
0x8378,0x83a2,0x8396,0x83bd,0x83ab,0x8392,0x838a,0x8393,
0x8389,0x83a0,0x8377,0x837b,0x837c,0x8386,0x83a7,0x8655,
0x5f6a,0x86c7,0x86c0,0x86b6,0x86c4,0x86b5,0x86c6,0x86cb,
0x86b1,0x86af,0x86c9,0x8853,0x889e,0x8888,0x88ab,0x8892,
0x8896,0x888d,0x888b,0x8993,0x898f,0x8a2a,0x8a1d,0x8a23,
0x8a25,0x8a31,0x8a2d,0x8a1f,0x8a1b,0x8a22,0x8c49,0x8c5a,
0x8ca9,0x8cac,0x8cab,0x8ca8,0x8caa,0x8ca7,0x8d67,0x8d66,
0x8dbe,0x8dba,0x8edb,0x8edf,0x9019,0x900d,0x901a,0x9017,
0x9023,0x901f,0x901d,0x9010,0x9015,0x901e,0x9020,0x900f,
0x9022,0x9016,0x901b,0x9014,0x90e8,0x90ed,0x90fd,0x9157,
0x91ce,0x91f5,0x91e6,0x91e3,0x91e7,0x91ed,0x91e9,0x9589,
0x966a,0x9675,0x9673,0x9678,0x9670,0x9674,0x9676,0x9677,
0x966c,0x96c0,0x96ea,0x96e9,0x7ae0,0x7adf,0x9802,0x9803,
0x9b5a,0x9ce5,0x9e75,0x9e7f,0x9ea5,0x9ebb,0x50a2,0x508d,
0x5085,0x5099,0x5091,0x5080,0x5096,0x5098,0x509a,0x6700,
0x51f1,0x5272,0x5274,0x5275,0x5269,0x52de,0x52dd,0x52db,
0x535a,0x53a5,0x557b,0x5580,0x55a7,0x557c,0x558a,0x559d,
0x5598,0x5582,0x559c,0x55aa,0x5594,0x5587,0x558b,0x5583,
0x55b3,0x55ae,0x559f,0x553e,0x55b2,0x559a,0x55bb,0x55ac,
0x55b1,0x557e,0x5589,0x55ab,0x5599,0x570d,0x582f,0x582a,
0x5834,0x5824,0x5830,0x5831,0x5821,0x581d,0x5820,0x58f9,
0x58fa,0x5960,0x5a77,0x5a9a,0x5a7f,0x5a92,0x5a9b,0x5aa7,
0x5b73,0x5b71,0x5bd2,0x5bcc,0x5bd3,0x5bd0,0x5c0a,0x5c0b,
0x5c31,0x5d4c,0x5d50,0x5d34,0x5d47,0x5dfd,0x5e45,0x5e3d,
0x5e40,0x5e43,0x5e7e,0x5eca,0x5ec1,0x5ec2,0x5ec4,0x5f3c,
0x5f6d,0x5fa9,0x5faa,0x5fa8,0x60d1,0x60e1,0x60b2,0x60b6,
0x60e0,0x611c,0x6123,0x60fa,0x6115,0x60f0,0x60fb,0x60f4,
0x6168,0x60f1,0x610e,0x60f6,0x6109,0x6100,0x6112,0x621f,
0x6249,0x63a3,0x638c,0x63cf,0x63c0,0x63e9,0x63c9,0x63c6,
0x63cd,0x63d2,0x63e3,0x63d0,0x63e1,0x63d6,0x63ed,0x63ee,
0x6376,0x63f4,0x63ea,0x63db,0x6452,0x63da,0x63f9,0x655e,
0x6566,0x6562,0x6563,0x6591,0x6590,0x65af,0x666e,0x6670,
0x6674,0x6676,0x666f,0x6691,0x667a,0x667e,0x6677,0x66fe,
0x66ff,0x671f,0x671d,0x68fa,0x68d5,0x68e0,0x68d8,0x68d7,
0x6905,0x68df,0x68f5,0x68ee,0x68e7,0x68f9,0x68d2,0x68f2,
0x68e3,0x68cb,0x68cd,0x690d,0x6912,0x690e,0x68c9,0x68da,
0x696e,0x68fb,0x6b3e,0x6b3a,0x6b3d,0x6b98,0x6b96,0x6bbc,
0x6bef,0x6c2e,0x6c2f,0x6c2c,0x6e2f,0x6e38,0x6e54,0x6e21,
0x6e32,0x6e67,0x6e4a,0x6e20,0x6e25,0x6e23,0x6e1b,0x6e5b,
0x6e58,0x6e24,0x6e56,0x6e6e,0x6e2d,0x6e26,0x6e6f,0x6e34,
0x6e4d,0x6e3a,0x6e2c,0x6e43,0x6e1d,0x6e3e,0x6ecb,0x6e89,
0x6e19,0x6e4e,0x6e63,0x6e44,0x6e72,0x6e69,0x6e5f,0x7119,
0x711a,0x7126,0x7130,0x7121,0x7136,0x716e,0x711c,0x724c,
0x7284,0x7280,0x7336,0x7325,0x7334,0x7329,0x743a,0x742a,
0x7433,0x7422,0x7425,0x7435,0x7436,0x7434,0x742f,0x741b,
0x7426,0x7428,0x7525,0x7526,0x756b,0x756a,0x75e2,0x75db,
0x75e3,0x75d9,0x75d8,0x75de,0x75e0,0x767b,0x767c,0x7696,
0x7693,0x76b4,0x76dc,0x774f,0x77ed,0x785d,0x786c,0x786f,
0x7a0d,0x7a08,0x7a0b,0x7a05,0x7a00,0x7a98,0x7a97,0x7a96,
0x7ae5,0x7ae3,0x7b49,0x7b56,0x7b46,0x7b50,0x7b52,0x7b54,
0x7b4d,0x7b4b,0x7b4f,0x7b51,0x7c9f,0x7ca5,0x7d5e,0x7d50,
0x7d68,0x7d55,0x7d2b,0x7d6e,0x7d72,0x7d61,0x7d66,0x7d62,
0x7d70,0x7d73,0x5584,0x7fd4,0x7fd5,0x800b,0x8052,0x8085,
0x8155,0x8154,0x814b,0x8151,0x814e,0x8139,0x8146,0x813e,
0x814c,0x8153,0x8174,0x8212,0x821c,0x83e9,0x8403,0x83f8,
0x840d,0x83e0,0x83c5,0x840b,0x83c1,0x83ef,0x83f1,0x83f4,
0x8457,0x840a,0x83f0,0x840c,0x83cc,0x83fd,0x83f2,0x83ca,
0x8438,0x840e,0x8404,0x83dc,0x8407,0x83d4,0x83df,0x865b,
0x86df,0x86d9,0x86ed,0x86d4,0x86db,0x86e4,0x86d0,0x86de,
0x8857,0x88c1,0x88c2,0x88b1,0x8983,0x8996,0x8a3b,0x8a60,
0x8a55,0x8a5e,0x8a3c,0x8a41,0x8a54,0x8a5b,0x8a50,0x8a46,
0x8a34,0x8a3a,0x8a36,0x8a56,0x8c61,0x8c82,0x8caf,0x8cbc,
0x8cb3,0x8cbd,0x8cc1,0x8cbb,0x8cc0,0x8cb4,0x8cb7,0x8cb6,
0x8cbf,0x8cb8,0x8d8a,0x8d85,0x8d81,0x8dce,0x8ddd,0x8dcb,
0x8dda,0x8dd1,0x8dcc,0x8ddb,0x8dc6,0x8efb,0x8ef8,0x8efc,
0x8f9c,0x902e,0x9035,0x9031,0x9038,0x9032,0x9036,0x9102,
0x90f5,0x9109,0x90fe,0x9163,0x9165,0x91cf,0x9214,0x9215,
0x9223,0x9209,0x921e,0x920d,0x9210,0x9207,0x9211,0x9594,
0x958f,0x958b,0x9591,0x9593,0x9592,0x958e,0x968a,0x968e,
0x968b,0x967d,0x9685,0x9686,0x968d,0x9672,0x9684,0x96c1,
0x96c5,0x96c4,0x96c6,0x96c7,0x96ef,0x96f2,0x97cc,0x9805,
0x9806,0x9808,0x98e7,0x98ea,0x98ef,0x98e9,0x98f2,0x98ed,
0x99ae,0x99ad,0x9ec3,0x9ecd,0x9ed1,0x4e82,0x50ad,0x50b5,
0x50b2,0x50b3,0x50c5,0x50be,0x50ac,0x50b7,0x50bb,0x50af,
0x50c7,0x527f,0x5277,0x527d,0x52df,0x52e6,0x52e4,0x52e2,
0x52e3,0x532f,0x55df,0x55e8,0x55d3,0x55e6,0x55ce,0x55dc,
0x55c7,0x55d1,0x55e3,0x55e4,0x55ef,0x55da,0x55e1,0x55c5,
0x55c6,0x55e5,0x55c9,0x5712,0x5713,0x585e,0x5851,0x5858,
0x5857,0x585a,0x5854,0x586b,0x584c,0x586d,0x584a,0x5862,
0x5852,0x584b,0x5967,0x5ac1,0x5ac9,0x5acc,0x5abe,0x5abd,
0x5abc,0x5ab3,0x5ac2,0x5ab2,0x5d69,0x5d6f,0x5e4c,0x5e79,
0x5ec9,0x5ec8,0x5f12,0x5f59,0x5fac,0x5fae,0x611a,0x610f,
0x6148,0x611f,0x60f3,0x611b,0x60f9,0x6101,0x6108,0x614e,
0x614c,0x6144,0x614d,0x613e,0x6134,0x6127,0x610d,0x6106,
0x6137,0x6221,0x6222,0x6413,0x643e,0x641e,0x642a,0x642d,
0x643d,0x642c,0x640f,0x641c,0x6414,0x640d,0x6436,0x6416,
0x6417,0x6406,0x656c,0x659f,0x65b0,0x6697,0x6689,0x6687,
0x6688,0x6696,0x6684,0x6698,0x668d,0x6703,0x6994,0x696d,
0x695a,0x6977,0x6960,0x6954,0x6975,0x6930,0x6982,0x694a,
0x6968,0x696b,0x695e,0x6953,0x6979,0x6986,0x695d,0x6963,
0x695b,0x6b47,0x6b72,0x6bc0,0x6bbf,0x6bd3,0x6bfd,0x6ea2,
0x6eaf,0x6ed3,0x6eb6,0x6ec2,0x6e90,0x6e9d,0x6ec7,0x6ec5,
0x6ea5,0x6e98,0x6ebc,0x6eba,0x6eab,0x6ed1,0x6e96,0x6e9c,
0x6ec4,0x6ed4,0x6eaa,0x6ea7,0x6eb4,0x714e,0x7159,0x7169,
0x7164,0x7149,0x7167,0x715c,0x716c,0x7166,0x714c,0x7165,
0x715e,0x7146,0x7168,0x7156,0x723a,0x7252,0x7337,0x7345,
0x733f,0x733e,0x746f,0x745a,0x7455,0x745f,0x745e,0x7441,
0x743f,0x7459,0x745b,0x745c,0x7576,0x7578,0x7600,0x75f0,
0x7601,0x75f2,0x75f1,0x75fa,0x75ff,0x75f4,0x75f3,0x76de,
0x76df,0x775b,0x776b,0x7766,0x775e,0x7763,0x7779,0x776a,
0x776c,0x775c,0x7765,0x7768,0x7762,0x77ee,0x788e,0x78b0,
0x7897,0x7898,0x788c,0x7889,0x787c,0x7891,0x7893,0x787f,
0x797a,0x797f,0x7981,0x842c,0x79bd,0x7a1c,0x7a1a,0x7a20,
0x7a14,0x7a1f,0x7a1e,0x7a9f,0x7aa0,0x7b77,0x7bc0,0x7b60,
0x7b6e,0x7b67,0x7cb1,0x7cb3,0x7cb5,0x7d93,0x7d79,0x7d91,
0x7d81,0x7d8f,0x7d5b,0x7f6e,0x7f69,0x7f6a,0x7f72,0x7fa9,
0x7fa8,0x7fa4,0x8056,0x8058,0x8086,0x8084,0x8171,0x8170,
0x8178,0x8165,0x816e,0x8173,0x816b,0x8179,0x817a,0x8166,
0x8205,0x8247,0x8482,0x8477,0x843d,0x8431,0x8475,0x8466,
0x846b,0x8449,0x846c,0x845b,0x843c,0x8435,0x8461,0x8463,
0x8469,0x846d,0x8446,0x865e,0x865c,0x865f,0x86f9,0x8713,
0x8708,0x8707,0x8700,0x86fe,0x86fb,0x8702,0x8703,0x8706,
0x870a,0x8859,0x88df,0x88d4,0x88d9,0x88dc,0x88d8,0x88dd,
0x88e1,0x88ca,0x88d5,0x88d2,0x899c,0x89e3,0x8a6b,0x8a72,
0x8a73,0x8a66,0x8a69,0x8a70,0x8a87,0x8a7c,0x8a63,0x8aa0,
0x8a71,0x8a85,0x8a6d,0x8a62,0x8a6e,0x8a6c,0x8a79,0x8a7b,
0x8a3e,0x8a68,0x8c62,0x8c8a,0x8c89,0x8cca,0x8cc7,0x8cc8,
0x8cc4,0x8cb2,0x8cc3,0x8cc2,0x8cc5,0x8de1,0x8ddf,0x8de8,
0x8def,0x8df3,0x8dfa,0x8dea,0x8de4,0x8de6,0x8eb2,0x8f03,
0x8f09,0x8efe,0x8f0a,0x8f9f,0x8fb2,0x904b,0x904a,0x9053,
0x9042,0x9054,0x903c,0x9055,0x9050,0x9047,0x904f,0x904e,
0x904d,0x9051,0x903e,0x9041,0x9112,0x9117,0x916c,0x916a,
0x9169,0x91c9,0x9237,0x9257,0x9238,0x923d,0x9240,0x923e,
0x925b,0x924b,0x9264,0x9251,0x9234,0x9249,0x924d,0x9245,
0x9239,0x923f,0x925a,0x9598,0x9698,0x9694,0x9695,0x96cd,
0x96cb,0x96c9,0x96ca,0x96f7,0x96fb,0x96f9,0x96f6,0x9756,
0x9774,0x9776,0x9810,0x9811,0x9813,0x980a,0x9812,0x980c,
0x98fc,0x98f4,0x98fd,0x98fe,0x99b3,0x99b1,0x99b4,0x9ae1,
0x9ce9,0x9e82,0x9f0e,0x9f13,0x9f20,0x50e7,0x50ee,0x50e5,
0x50d6,0x50ed,0x50da,0x50d5,0x50cf,0x50d1,0x50f1,0x50ce,
0x50e9,0x5162,0x51f3,0x5283,0x5282,0x5331,0x53ad,0x55fe,
0x5600,0x561b,0x5617,0x55fd,0x5614,0x5606,0x5609,0x560d,
0x560e,0x55f7,0x5616,0x561f,0x5608,0x5610,0x55f6,0x5718,
0x5716,0x5875,0x587e,0x5883,0x5893,0x588a,0x5879,0x5885,
0x587d,0x58fd,0x5925,0x5922,0x5924,0x596a,0x5969,0x5ae1,
0x5ae6,0x5ae9,0x5ad7,0x5ad6,0x5ad8,0x5ae3,0x5b75,0x5bde,
0x5be7,0x5be1,0x5be5,0x5be6,0x5be8,0x5be2,0x5be4,0x5bdf,
0x5c0d,0x5c62,0x5d84,0x5d87,0x5e5b,0x5e63,0x5e55,0x5e57,
0x5e54,0x5ed3,0x5ed6,0x5f0a,0x5f46,0x5f70,0x5fb9,0x6147,
0x613f,0x614b,0x6177,0x6162,0x6163,0x615f,0x615a,0x6158,
0x6175,0x622a,0x6487,0x6458,0x6454,0x64a4,0x6478,0x645f,
0x647a,0x6451,0x6467,0x6434,0x646d,0x647b,0x6572,0x65a1,
0x65d7,0x65d6,0x66a2,0x66a8,0x669d,0x699c,0x69a8,0x6995,
0x69c1,0x69ae,0x69d3,0x69cb,0x699b,0x69b7,0x69bb,0x69ab,
0x69b4,0x69d0,0x69cd,0x69ad,0x69cc,0x69a6,0x69c3,0x69a3,
0x6b49,0x6b4c,0x6c33,0x6f33,0x6f14,0x6efe,0x6f13,0x6ef4,
0x6f29,0x6f3e,0x6f20,0x6f2c,0x6f0f,0x6f02,0x6f22,0x6eff,
0x6eef,0x6f06,0x6f31,0x6f38,0x6f32,0x6f23,0x6f15,0x6f2b,
0x6f2f,0x6f88,0x6f2a,0x6eec,0x6f01,0x6ef2,0x6ecc,0x6ef7,
0x7194,0x7199,0x717d,0x718a,0x7184,0x7192,0x723e,0x7292,
0x7296,0x7344,0x7350,0x7464,0x7463,0x746a,0x7470,0x746d,
0x7504,0x7591,0x7627,0x760d,0x760b,0x7609,0x7613,0x76e1,
0x76e3,0x7784,0x777d,0x777f,0x7761,0x78c1,0x789f,0x78a7,
0x78b3,0x78a9,0x78a3,0x798e,0x798f,0x798d,0x7a2e,0x7a31,
0x7aaa,0x7aa9,0x7aed,0x7aef,0x7ba1,0x7b95,0x7b8b,0x7b75,
0x7b97,0x7b9d,0x7b94,0x7b8f,0x7bb8,0x7b87,0x7b84,0x7cb9,
0x7cbd,0x7cbe,0x7dbb,0x7db0,0x7d9c,0x7dbd,0x7dbe,0x7da0,
0x7dca,0x7db4,0x7db2,0x7db1,0x7dba,0x7da2,0x7dbf,0x7db5,
0x7db8,0x7dad,0x7dd2,0x7dc7,0x7dac,0x7f70,0x7fe0,0x7fe1,
0x7fdf,0x805e,0x805a,0x8087,0x8150,0x8180,0x818f,0x8188,
0x818a,0x817f,0x8182,0x81e7,0x81fa,0x8207,0x8214,0x821e,
0x824b,0x84c9,0x84bf,0x84c6,0x84c4,0x8499,0x849e,0x84b2,
0x849c,0x84cb,0x84b8,0x84c0,0x84d3,0x8490,0x84bc,0x84d1,
0x84ca,0x873f,0x871c,0x873b,0x8722,0x8725,0x8734,0x8718,
0x8755,0x8737,0x8729,0x88f3,0x8902,0x88f4,0x88f9,0x88f8,
0x88fd,0x88e8,0x891a,0x88ef,0x8aa6,0x8a8c,0x8a9e,0x8aa3,
0x8a8d,0x8aa1,0x8a93,0x8aa4,0x8aaa,0x8aa5,0x8aa8,0x8a98,
0x8a91,0x8a9a,0x8aa7,0x8c6a,0x8c8d,0x8c8c,0x8cd3,0x8cd1,
0x8cd2,0x8d6b,0x8d99,0x8d95,0x8dfc,0x8f14,0x8f12,0x8f15,
0x8f13,0x8fa3,0x9060,0x9058,0x905c,0x9063,0x9059,0x905e,
0x9062,0x905d,0x905b,0x9119,0x9118,0x911e,0x9175,0x9178,
0x9177,0x9174,0x9278,0x92ac,0x9280,0x9285,0x9298,0x9296,
0x927b,0x9293,0x929c,0x92a8,0x927c,0x9291,0x95a1,0x95a8,
0x95a9,0x95a3,0x95a5,0x95a4,0x9699,0x969c,0x969b,0x96cc,
0x96d2,0x9700,0x977c,0x9785,0x97f6,0x9817,0x9818,0x98af,
0x98b1,0x9903,0x9905,0x990c,0x9909,0x99c1,0x9aaf,0x9ab0,
0x9ae6,0x9b41,0x9b42,0x9cf4,0x9cf6,0x9cf3,0x9ebc,0x9f3b,
0x9f4a,0x5104,0x5100,0x50fb,0x50f5,0x50f9,0x5102,0x5108,
0x5109,0x5105,0x51dc,0x5287,0x5288,0x5289,0x528d,0x528a,
0x52f0,0x53b2,0x562e,0x563b,0x5639,0x5632,0x563f,0x5634,
0x5629,0x5653,0x564e,0x5657,0x5674,0x5636,0x562f,0x5630,
0x5880,0x589f,0x589e,0x58b3,0x589c,0x58ae,0x58a9,0x58a6,
0x596d,0x5b09,0x5afb,0x5b0b,0x5af5,0x5b0c,0x5b08,0x5bee,
0x5bec,0x5be9,0x5beb,0x5c64,0x5c65,0x5d9d,0x5d94,0x5e62,
0x5e5f,0x5e61,0x5ee2,0x5eda,0x5edf,0x5edd,0x5ee3,0x5ee0,
0x5f48,0x5f71,0x5fb7,0x5fb5,0x6176,0x6167,0x616e,0x615d,
0x6155,0x6182,0x617c,0x6170,0x616b,0x617e,0x61a7,0x6190,
0x61ab,0x618e,0x61ac,0x619a,0x61a4,0x6194,0x61ae,0x622e,
0x6469,0x646f,0x6479,0x649e,0x64b2,0x6488,0x6490,0x64b0,
0x64a5,0x6493,0x6495,0x64a9,0x6492,0x64ae,0x64ad,0x64ab,
0x649a,0x64ac,0x6499,0x64a2,0x64b3,0x6575,0x6577,0x6578,
0x66ae,0x66ab,0x66b4,0x66b1,0x6a23,0x6a1f,0x69e8,0x6a01,
0x6a1e,0x6a19,0x69fd,0x6a21,0x6a13,0x6a0a,0x69f3,0x6a02,
0x6a05,0x69ed,0x6a11,0x6b50,0x6b4e,0x6ba4,0x6bc5,0x6bc6,
0x6f3f,0x6f7c,0x6f84,0x6f51,0x6f66,0x6f54,0x6f86,0x6f6d,
0x6f5b,0x6f78,0x6f6e,0x6f8e,0x6f7a,0x6f70,0x6f64,0x6f97,
0x6f58,0x6ed5,0x6f6f,0x6f60,0x6f5f,0x719f,0x71ac,0x71b1,
0x71a8,0x7256,0x729b,0x734e,0x7357,0x7469,0x748b,0x7483,
0x747e,0x7480,0x757f,0x7620,0x7629,0x761f,0x7624,0x7626,
0x7621,0x7622,0x769a,0x76ba,0x76e4,0x778e,0x7787,0x778c,
0x7791,0x778b,0x78cb,0x78c5,0x78ba,0x78ca,0x78be,0x78d5,
0x78bc,0x78d0,0x7a3f,0x7a3c,0x7a40,0x7a3d,0x7a37,0x7a3b,
0x7aaf,0x7aae,0x7bad,0x7bb1,0x7bc4,0x7bb4,0x7bc6,0x7bc7,
0x7bc1,0x7ba0,0x7bcc,0x7cca,0x7de0,0x7df4,0x7def,0x7dfb,
0x7dd8,0x7dec,0x7ddd,0x7de8,0x7de3,0x7dda,0x7dde,0x7de9,
0x7d9e,0x7dd9,0x7df2,0x7df9,0x7f75,0x7f77,0x7faf,0x7fe9,
0x8026,0x819b,0x819c,0x819d,0x81a0,0x819a,0x8198,0x8517,
0x853d,0x851a,0x84ee,0x852c,0x852d,0x8513,0x8511,0x8523,
0x8521,0x8514,0x84ec,0x8525,0x84ff,0x8506,0x8782,0x8774,
0x8776,0x8760,0x8766,0x8778,0x8768,0x8759,0x8757,0x874c,
0x8753,0x885b,0x885d,0x8910,0x8907,0x8912,0x8913,0x8915,
0x890a,0x8abc,0x8ad2,0x8ac7,0x8ac4,0x8a95,0x8acb,0x8af8,
0x8ab2,0x8ac9,0x8ac2,0x8abf,0x8ab0,0x8ad6,0x8acd,0x8ab6,
0x8ab9,0x8adb,0x8c4c,0x8c4e,0x8c6c,0x8ce0,0x8cde,0x8ce6,
0x8ce4,0x8cec,0x8ced,0x8ce2,0x8ce3,0x8cdc,0x8cea,0x8ce1,
0x8d6d,0x8d9f,0x8da3,0x8e2b,0x8e10,0x8e1d,0x8e22,0x8e0f,
0x8e29,0x8e1f,0x8e21,0x8e1e,0x8eba,0x8f1d,0x8f1b,0x8f1f,
0x8f29,0x8f26,0x8f2a,0x8f1c,0x8f1e,0x8f25,0x9069,0x906e,
0x9068,0x906d,0x9077,0x9130,0x912d,0x9127,0x9131,0x9187,
0x9189,0x918b,0x9183,0x92c5,0x92bb,0x92b7,0x92ea,0x92e4,
0x92c1,0x92b3,0x92bc,0x92d2,0x92c7,0x92f0,0x92b2,0x95ad,
0x95b1,0x9704,0x9706,0x9707,0x9709,0x9760,0x978d,0x978b,
0x978f,0x9821,0x982b,0x981c,0x98b3,0x990a,0x9913,0x9912,
0x9918,0x99dd,0x99d0,0x99df,0x99db,0x99d1,0x99d5,0x99d2,
0x99d9,0x9ab7,0x9aee,0x9aef,0x9b27,0x9b45,0x9b44,0x9b77,
0x9b6f,0x9d06,0x9d09,0x9d03,0x9ea9,0x9ebe,0x9ece,0x58a8,
0x9f52,0x5112,0x5118,0x5114,0x5110,0x5115,0x5180,0x51aa,
0x51dd,0x5291,0x5293,0x52f3,0x5659,0x566b,0x5679,0x5669,
0x5664,0x5678,0x566a,0x5668,0x5665,0x5671,0x566f,0x566c,
0x5662,0x5676,0x58c1,0x58be,0x58c7,0x58c5,0x596e,0x5b1d,
0x5b34,0x5b78,0x5bf0,0x5c0e,0x5f4a,0x61b2,0x6191,0x61a9,
0x618a,0x61cd,0x61b6,0x61be,0x61ca,0x61c8,0x6230,0x64c5,
0x64c1,0x64cb,0x64bb,0x64bc,0x64da,0x64c4,0x64c7,0x64c2,
0x64cd,0x64bf,0x64d2,0x64d4,0x64be,0x6574,0x66c6,0x66c9,
0x66b9,0x66c4,0x66c7,0x66b8,0x6a3d,0x6a38,0x6a3a,0x6a59,
0x6a6b,0x6a58,0x6a39,0x6a44,0x6a62,0x6a61,0x6a4b,0x6a47,
0x6a35,0x6a5f,0x6a48,0x6b59,0x6b77,0x6c05,0x6fc2,0x6fb1,
0x6fa1,0x6fc3,0x6fa4,0x6fc1,0x6fa7,0x6fb3,0x6fc0,0x6fb9,
0x6fb6,0x6fa6,0x6fa0,0x6fb4,0x71be,0x71c9,0x71d0,0x71d2,
0x71c8,0x71d5,0x71b9,0x71ce,0x71d9,0x71dc,0x71c3,0x71c4,
0x7368,0x749c,0x74a3,0x7498,0x749f,0x749e,0x74e2,0x750c,
0x750d,0x7634,0x7638,0x763a,0x76e7,0x76e5,0x77a0,0x779e,
0x779f,0x77a5,0x78e8,0x78da,0x78ec,0x78e7,0x79a6,0x7a4d,
0x7a4e,0x7a46,0x7a4c,0x7a4b,0x7aba,0x7bd9,0x7c11,0x7bc9,
0x7be4,0x7bdb,0x7be1,0x7be9,0x7be6,0x7cd5,0x7cd6,0x7e0a,
0x7e11,0x7e08,0x7e1b,0x7e23,0x7e1e,0x7e1d,0x7e09,0x7e10,
0x7f79,0x7fb2,0x7ff0,0x7ff1,0x7fee,0x8028,0x81b3,0x81a9,
0x81a8,0x81fb,0x8208,0x8258,0x8259,0x854a,0x8559,0x8548,
0x8568,0x8569,0x8543,0x8549,0x856d,0x856a,0x855e,0x8783,
0x879f,0x879e,0x87a2,0x878d,0x8861,0x892a,0x8932,0x8925,
0x892b,0x8921,0x89aa,0x89a6,0x8ae6,0x8afa,0x8aeb,0x8af1,
0x8b00,0x8adc,0x8ae7,0x8aee,0x8afe,0x8b01,0x8b02,0x8af7,
0x8aed,0x8af3,0x8af6,0x8afc,0x8c6b,0x8c6d,0x8c93,0x8cf4,
0x8e44,0x8e31,0x8e34,0x8e42,0x8e39,0x8e35,0x8f3b,0x8f2f,
0x8f38,0x8f33,0x8fa8,0x8fa6,0x9075,0x9074,0x9078,0x9072,
0x907c,0x907a,0x9134,0x9192,0x9320,0x9336,0x92f8,0x9333,
0x932f,0x9322,0x92fc,0x932b,0x9304,0x931a,0x9310,0x9326,
0x9321,0x9315,0x932e,0x9319,0x95bb,0x96a7,0x96a8,0x96aa,
0x96d5,0x970e,0x9711,0x9716,0x970d,0x9713,0x970f,0x975b,
0x975c,0x9766,0x9798,0x9830,0x9838,0x983b,0x9837,0x982d,
0x9839,0x9824,0x9910,0x9928,0x991e,0x991b,0x9921,0x991a,
0x99ed,0x99e2,0x99f1,0x9ab8,0x9abc,0x9afb,0x9aed,0x9b28,
0x9b91,0x9d15,0x9d23,0x9d26,0x9d28,0x9d12,0x9d1b,0x9ed8,
0x9ed4,0x9f8d,0x9f9c,0x512a,0x511f,0x5121,0x5132,0x52f5,
0x568e,0x5680,0x5690,0x5685,0x5687,0x568f,0x58d5,0x58d3,
0x58d1,0x58ce,0x5b30,0x5b2a,0x5b24,0x5b7a,0x5c37,0x5c68,
0x5dbc,0x5dba,0x5dbd,0x5db8,0x5e6b,0x5f4c,0x5fbd,0x61c9,
0x61c2,0x61c7,0x61e6,0x61cb,0x6232,0x6234,0x64ce,0x64ca,
0x64d8,0x64e0,0x64f0,0x64e6,0x64ec,0x64f1,0x64e2,0x64ed,
0x6582,0x6583,0x66d9,0x66d6,0x6a80,0x6a94,0x6a84,0x6aa2,
0x6a9c,0x6adb,0x6aa3,0x6a7e,0x6a97,0x6a90,0x6aa0,0x6b5c,
0x6bae,0x6bda,0x6c08,0x6fd8,0x6ff1,0x6fdf,0x6fe0,0x6fdb,
0x6fe4,0x6feb,0x6fef,0x6f80,0x6fec,0x6fe1,0x6fe9,0x6fd5,
0x6fee,0x6ff0,0x71e7,0x71df,0x71ee,0x71e6,0x71e5,0x71ed,
0x71ec,0x71f4,0x71e0,0x7235,0x7246,0x7370,0x7372,0x74a9,
0x74b0,0x74a6,0x74a8,0x7646,0x7642,0x764c,0x76ea,0x77b3,
0x77aa,0x77b0,0x77ac,0x77a7,0x77ad,0x77ef,0x78f7,0x78fa,
0x78f4,0x78ef,0x7901,0x79a7,0x79aa,0x7a57,0x7abf,0x7c07,
0x7c0d,0x7bfe,0x7bf7,0x7c0c,0x7be0,0x7ce0,0x7cdc,0x7cde,
0x7ce2,0x7cdf,0x7cd9,0x7cdd,0x7e2e,0x7e3e,0x7e46,0x7e37,
0x7e32,0x7e43,0x7e2b,0x7e3d,0x7e31,0x7e45,0x7e41,0x7e34,
0x7e39,0x7e48,0x7e35,0x7e3f,0x7e2f,0x7f44,0x7ff3,0x7ffc,
0x8071,0x8072,0x8070,0x806f,0x8073,0x81c6,0x81c3,0x81ba,
0x81c2,0x81c0,0x81bf,0x81bd,0x81c9,0x81be,0x81e8,0x8209,
0x8271,0x85aa,0x8584,0x857e,0x859c,0x8591,0x8594,0x85af,
0x859b,0x8587,0x85a8,0x858a,0x85a6,0x8667,0x87c0,0x87d1,
0x87b3,0x87d2,0x87c6,0x87ab,0x87bb,0x87ba,0x87c8,0x87cb,
0x893b,0x8936,0x8944,0x8938,0x893d,0x89ac,0x8b0e,0x8b17,
0x8b19,0x8b1b,0x8b0a,0x8b20,0x8b1d,0x8b04,0x8b10,0x8c41,
0x8c3f,0x8c73,0x8cfa,0x8cfd,0x8cfc,0x8cf8,0x8cfb,0x8da8,
0x8e49,0x8e4b,0x8e48,0x8e4a,0x8f44,0x8f3e,0x8f42,0x8f45,
0x8f3f,0x907f,0x907d,0x9084,0x9081,0x9082,0x9080,0x9139,
0x91a3,0x919e,0x919c,0x934d,0x9382,0x9328,0x9375,0x934a,
0x9365,0x934b,0x9318,0x937e,0x936c,0x935b,0x9370,0x935a,
0x9354,0x95ca,0x95cb,0x95cc,0x95c8,0x95c6,0x96b1,0x96b8,
0x96d6,0x971c,0x971e,0x97a0,0x97d3,0x9846,0x98b6,0x9935,
0x9a01,0x99ff,0x9bae,0x9bab,0x9baa,0x9bad,0x9d3b,0x9d3f,
0x9e8b,0x9ecf,0x9ede,0x9edc,0x9edd,0x9edb,0x9f3e,0x9f4b,
0x53e2,0x5695,0x56ae,0x58d9,0x58d8,0x5b38,0x5f5e,0x61e3,
0x6233,0x64f4,0x64f2,0x64fe,0x6506,0x64fa,0x64fb,0x64f7,
0x65b7,0x66dc,0x6726,0x6ab3,0x6aac,0x6ac3,0x6abb,0x6ab8,
0x6ac2,0x6aae,0x6aaf,0x6b5f,0x6b78,0x6baf,0x7009,0x700b,
0x6ffe,0x7006,0x6ffa,0x7011,0x700f,0x71fb,0x71fc,0x71fe,
0x71f8,0x7377,0x7375,0x74a7,0x74bf,0x7515,0x7656,0x7658,
0x7652,0x77bd,0x77bf,0x77bb,0x77bc,0x790e,0x79ae,0x7a61,
0x7a62,0x7a60,0x7ac4,0x7ac5,0x7c2b,0x7c27,0x7c2a,0x7c1e,
0x7c23,0x7c21,0x7ce7,0x7e54,0x7e55,0x7e5e,0x7e5a,0x7e61,
0x7e52,0x7e59,0x7f48,0x7ff9,0x7ffb,0x8077,0x8076,0x81cd,
0x81cf,0x820a,0x85cf,0x85a9,0x85cd,0x85d0,0x85c9,0x85b0,
0x85ba,0x85b9,0x87ef,0x87ec,0x87f2,0x87e0,0x8986,0x89b2,
0x89f4,0x8b28,0x8b39,0x8b2c,0x8b2b,0x8c50,0x8d05,0x8e59,
0x8e63,0x8e66,0x8e64,0x8e5f,0x8e55,0x8ec0,0x8f49,0x8f4d,
0x9087,0x9083,0x9088,0x91ab,0x91ac,0x91d0,0x9394,0x938a,
0x9396,0x93a2,0x93b3,0x93ae,0x93ac,0x93b0,0x9398,0x939a,
0x9397,0x95d4,0x95d6,0x95d0,0x95d5,0x96e2,0x96dc,0x96d9,
0x96db,0x96de,0x9724,0x97a3,0x97a6,0x97ad,0x97f9,0x984d,
0x984f,0x984c,0x984e,0x9853,0x98ba,0x993e,0x993f,0x993d,
0x992e,0x99a5,0x9a0e,0x9ac1,0x9b03,0x9b06,0x9b4f,0x9b4e,
0x9b4d,0x9bca,0x9bc9,0x9bfd,0x9bc8,0x9bc0,0x9d51,0x9d5d,
0x9d60,0x9ee0,0x9f15,0x9f2c,0x5133,0x56a5,0x56a8,0x58de,
0x58df,0x58e2,0x5bf5,0x9f90,0x5eec,0x61f2,0x61f7,0x61f6,
0x61f5,0x6500,0x650f,0x66e0,0x66dd,0x6ae5,0x6add,0x6ada,
0x6ad3,0x701b,0x701f,0x7028,0x701a,0x701d,0x7015,0x7018,
0x7206,0x720d,0x7258,0x72a2,0x7378,0x737a,0x74bd,0x74ca,
0x74e3,0x7587,0x7586,0x765f,0x7661,0x77c7,0x7919,0x79b1,
0x7a6b,0x7a69,0x7c3e,0x7c3f,0x7c38,0x7c3d,0x7c37,0x7c40,
0x7e6b,0x7e6d,0x7e79,0x7e69,0x7e6a,0x7e73,0x7f85,0x7fb6,
0x7fb9,0x7fb8,0x81d8,0x85e9,0x85dd,0x85ea,0x85d5,0x85e4,
0x85e5,0x85f7,0x87fb,0x8805,0x880d,0x87f9,0x87fe,0x8960,
0x895f,0x8956,0x895e,0x8b41,0x8b5c,0x8b58,0x8b49,0x8b5a,
0x8b4e,0x8b4f,0x8b46,0x8b59,0x8d08,0x8d0a,0x8e7c,0x8e72,
0x8e87,0x8e76,0x8e6c,0x8e7a,0x8e74,0x8f54,0x8f4e,0x8fad,
0x908a,0x908b,0x91b1,0x91ae,0x93e1,0x93d1,0x93df,0x93c3,
0x93c8,0x93dc,0x93dd,0x93d6,0x93e2,0x93cd,0x93d8,0x93e4,
0x93d7,0x93e8,0x95dc,0x96b4,0x96e3,0x972a,0x9727,0x9761,
0x97dc,0x97fb,0x985e,0x9858,0x985b,0x98bc,0x9945,0x9949,
0x9a16,0x9a19,0x9b0d,0x9be8,0x9be7,0x9bd6,0x9bdb,0x9d89,
0x9d61,0x9d72,0x9d6a,0x9d6c,0x9e92,0x9e97,0x9e93,0x9eb4,
0x52f8,0x56b7,0x56b6,0x56b4,0x56bc,0x58e4,0x5b40,0x5b43,
0x5b7d,0x5bf6,0x5dc9,0x61f8,0x61fa,0x6518,0x6514,0x6519,
0x66e6,0x6727,0x6aec,0x703e,0x7030,0x7032,0x7210,0x737b,
0x74cf,0x7662,0x7665,0x7926,0x792a,0x792c,0x792b,0x7ac7,
0x7af6,0x7c4c,0x7c43,0x7c4d,0x7cef,0x7cf0,0x8fae,0x7e7d,
0x7e7c,0x7e82,0x7f4c,0x8000,0x81da,0x8266,0x85fb,0x85f9,
0x8611,0x85fa,0x8606,0x860b,0x8607,0x860a,0x8814,0x8815,
0x8964,0x89ba,0x89f8,0x8b70,0x8b6c,0x8b66,0x8b6f,0x8b5f,
0x8b6b,0x8d0f,0x8d0d,0x8e89,0x8e81,0x8e85,0x8e82,0x91b4,
0x91cb,0x9418,0x9403,0x93fd,0x95e1,0x9730,0x98c4,0x9952,
0x9951,0x99a8,0x9a2b,0x9a30,0x9a37,0x9a35,0x9c13,0x9c0d,
0x9e79,0x9eb5,0x9ee8,0x9f2f,0x9f5f,0x9f63,0x9f61,0x5137,
0x5138,0x56c1,0x56c0,0x56c2,0x5914,0x5c6c,0x5dcd,0x61fc,
0x61fe,0x651d,0x651c,0x6595,0x66e9,0x6afb,0x6b04,0x6afa,
0x6bb2,0x704c,0x721b,0x72a7,0x74d6,0x74d4,0x7669,0x77d3,
0x7c50,0x7e8f,0x7e8c,0x7fbc,0x8617,0x862d,0x861a,0x8823,
0x8822,0x8821,0x881f,0x896a,0x896c,0x89bd,0x8b74,0x8b77,
0x8b7d,0x8d13,0x8e8a,0x8e8d,0x8e8b,0x8f5f,0x8faf,0x91ba,
0x942e,0x9433,0x9435,0x943a,0x9438,0x9432,0x942b,0x95e2,
0x9738,0x9739,0x9732,0x97ff,0x9867,0x9865,0x9957,0x9a45,
0x9a43,0x9a40,0x9a3e,0x9acf,0x9b54,0x9b51,0x9c2d,0x9c25,
0x9daf,0x9db4,0x9dc2,0x9db8,0x9e9d,0x9eef,0x9f19,0x9f5c,
0x9f66,0x9f67,0x513c,0x513b,0x56c8,0x56ca,0x56c9,0x5b7f,
0x5dd4,0x5dd2,0x5f4e,0x61ff,0x6524,0x6b0a,0x6b61,0x7051,
0x7058,0x7380,0x74e4,0x758a,0x766e,0x766c,0x79b3,0x7c60,
0x7c5f,0x807e,0x807d,0x81df,0x8972,0x896f,0x89fc,0x8b80,
0x8d16,0x8d17,0x8e91,0x8e93,0x8f61,0x9148,0x9444,0x9451,
0x9452,0x973d,0x973e,0x97c3,0x97c1,0x986b,0x9955,0x9a55,
0x9a4d,0x9ad2,0x9b1a,0x9c49,0x9c31,0x9c3e,0x9c3b,0x9dd3,
0x9dd7,0x9f34,0x9f6c,0x9f6a,0x9f94,0x56cc,0x5dd6,0x6200,
0x6523,0x652b,0x652a,0x66ec,0x6b10,0x74da,0x7aca,0x7c64,
0x7c63,0x7c65,0x7e93,0x7e96,0x7e94,0x81e2,0x8638,0x863f,
0x8831,0x8b8a,0x9090,0x908f,0x9463,0x9460,0x9464,0x9768,
0x986f,0x995c,0x9a5a,0x9a5b,0x9a57,0x9ad3,0x9ad4,0x9ad1,
0x9c54,0x9c57,0x9c56,0x9de5,0x9e9f,0x9ef4,0x56d1,0x58e9,
0x652c,0x705e,0x7671,0x7672,0x77d7,0x7f50,0x7f88,0x8836,
0x8839,0x8862,0x8b93,0x8b92,0x8b96,0x8277,0x8d1b,0x91c0,
0x946a,0x9742,0x9748,0x9744,0x97c6,0x9870,0x9a5f,0x9b22,
0x9b58,0x9c5f,0x9df9,0x9dfa,0x9e7c,0x9e7d,0x9f07,0x9f77,
0x9f72,0x5ef3,0x6b16,0x7063,0x7c6c,0x7c6e,0x883b,0x89c0,
0x8ea1,0x91c1,0x9472,0x9470,0x9871,0x995e,0x9ad6,0x9b23,
0x9ecc,0x7064,0x77da,0x8b9a,0x9477,0x97c9,0x9a62,0x9a65,
0x7e9c,0x8b9c,0x8eaa,0x91c5,0x947d,0x947e,0x947c,0x9c77,
0x9c78,0x9ef7,0x8c54,0x947f,0x9e1a,0x7228,0x9a6a,0x9b31,
0x9e1b,0x9e1e,0x7c72};

static const int cns11643_1_ucs_table_size = (sizeof(cns11643_1_ucs_table)/sizeof(unsigned short));

static const unsigned short cns11643_2_ucs_table[] = {
0x4e42,0x4e5c,0x51f5,0x531a,0x5382,0x4e07,0x4e0c,0x4e47,
0x4e8d,0x56d7,0x5c6e,0x5f73,0x4e0f,0x5187,0x4e0e,0x4e2e,
0x4e93,0x4ec2,0x4ec9,0x4ec8,0x5198,0x52fc,0x536c,0x53b9,
0x5720,0x5903,0x592c,0x5c10,0x5dff,0x65e1,0x6bb3,0x6bcc,
0x6c14,0x723f,0x4e31,0x4e3c,0x4ee8,0x4edc,0x4ee9,0x4ee1,
0x4edd,0x4eda,0x520c,0x5209,0x531c,0x534c,0x5722,0x5723,
0x5917,0x592f,0x5b81,0x5b84,0x5c12,0x5c3b,0x5c74,0x5c73,
0x5e04,0x5e80,0x5e82,0x5fc9,0x6209,0x6250,0x6c15,0x6c36,
0x6c43,0x6c3f,0x6c3b,0x72ae,0x72b0,0x738a,0x79b8,0x808a,
0x961e,0x4f0e,0x4f18,0x4f2c,0x4ef5,0x4f14,0x4ef1,0x4f00,
0x4ef7,0x4f08,0x4f1d,0x4f02,0x4f05,0x4f22,0x4f13,0x4f04,
0x4ef4,0x4f12,0x51b1,0x5213,0x5210,0x52a6,0x5322,0x531f,
0x534d,0x538a,0x5407,0x56e1,0x56df,0x572e,0x572a,0x5734,
0x593c,0x5980,0x597c,0x5985,0x597b,0x597e,0x5977,0x597f,
0x5b56,0x5c15,0x5c25,0x5c7c,0x5c7a,0x5c7b,0x5c7e,0x5ddf,
0x5e75,0x5e84,0x5f02,0x5f1a,0x5f74,0x5fd5,0x5fd4,0x5fcf,
0x625c,0x625e,0x6264,0x6261,0x6266,0x6262,0x6259,0x6260,
0x625a,0x6265,0x6537,0x65ef,0x65ee,0x673e,0x6739,0x6738,
0x673b,0x673a,0x673f,0x673c,0x6733,0x6c18,0x6c46,0x6c52,
0x6c5c,0x6c4f,0x6c4a,0x6c54,0x6c4b,0x6c4c,0x7071,0x725e,
0x72b4,0x72b5,0x738e,0x752a,0x767f,0x7a75,0x7f51,0x8278,
0x827c,0x8280,0x827d,0x827f,0x864d,0x897e,0x9099,0x9097,
0x9098,0x909b,0x9094,0x9622,0x9624,0x9620,0x9623,0x4f56,
0x4f3b,0x4f62,0x4f49,0x4f53,0x4f64,0x4f3e,0x4f67,0x4f52,
0x4f5f,0x4f41,0x4f58,0x4f2d,0x4f33,0x4f3f,0x4f61,0x518f,
0x51b9,0x521c,0x521e,0x5221,0x52ad,0x52ae,0x5309,0x5363,
0x5372,0x538e,0x538f,0x5430,0x5437,0x542a,0x5454,0x5445,
0x5419,0x541c,0x5425,0x5418,0x543d,0x544f,0x5441,0x5428,
0x5424,0x5447,0x56ee,0x56e7,0x56e5,0x5741,0x5745,0x574c,
0x5749,0x574b,0x5752,0x5906,0x5940,0x59a6,0x5998,0x59a0,
0x5997,0x598e,0x59a2,0x5990,0x598f,0x59a7,0x59a1,0x5b8e,
0x5b92,0x5c28,0x5c2a,0x5c8d,0x5c8f,0x5c88,0x5c8b,0x5c89,
0x5c92,0x5c8a,0x5c86,0x5c93,0x5c95,0x5de0,0x5e0a,0x5e0e,
0x5e8b,0x5e89,0x5e8c,0x5e88,0x5e8d,0x5f05,0x5f1d,0x5f78,
0x5f76,0x5fd2,0x5fd1,0x5fd0,0x5fed,0x5fe8,0x5fee,0x5ff3,
0x5fe1,0x5fe4,0x5fe3,0x5ffa,0x5fef,0x5ff7,0x5ffb,0x6000,
0x5ff4,0x623a,0x6283,0x628c,0x628e,0x628f,0x6294,0x6287,
0x6271,0x627b,0x627a,0x6270,0x6281,0x6288,0x6277,0x627d,
0x6272,0x6274,0x65f0,0x65f4,0x65f3,0x65f2,0x65f5,0x6745,
0x6747,0x6759,0x6755,0x674c,0x6748,0x675d,0x674d,0x675a,
0x674b,0x6bd0,0x6c19,0x6c1a,0x6c78,0x6c67,0x6c6b,0x6c84,
0x6c8b,0x6c8f,0x6c71,0x6c6f,0x6c69,0x6c9a,0x6c6d,0x6c87,
0x6c95,0x6c9c,0x6c66,0x6c73,0x6c65,0x6c7b,0x6c8e,0x7074,
0x707a,0x7263,0x72bf,0x72bd,0x72c3,0x72c6,0x72c1,0x72ba,
0x72c5,0x7395,0x7397,0x7393,0x7394,0x7392,0x753a,0x7539,
0x7594,0x7595,0x7681,0x793d,0x8034,0x8095,0x8099,0x8090,
0x8092,0x809c,0x8290,0x828f,0x8285,0x828e,0x8291,0x8293,
0x828a,0x8283,0x8284,0x8c78,0x8fc9,0x8fbf,0x909f,0x90a1,
0x90a5,0x909e,0x90a7,0x90a0,0x9630,0x9628,0x962f,0x962d,
0x4e33,0x4f98,0x4f7c,0x4f85,0x4f7d,0x4f80,0x4f87,0x4f76,
0x4f74,0x4f89,0x4f84,0x4f77,0x4f4c,0x4f97,0x4f6a,0x4f9a,
0x4f79,0x4f81,0x4f78,0x4f90,0x4f9c,0x4f94,0x4f9e,0x4f92,
0x4f82,0x4f95,0x4f6b,0x4f6e,0x519e,0x51bc,0x51be,0x5235,
0x5232,0x5233,0x5246,0x5231,0x52bc,0x530a,0x530b,0x533c,
0x5392,0x5394,0x5487,0x547f,0x5481,0x5491,0x5482,0x5488,
0x546b,0x547a,0x547e,0x5465,0x546c,0x5474,0x5466,0x548d,
0x546f,0x5461,0x5460,0x5498,0x5463,0x5467,0x5464,0x56f7,
0x56f9,0x576f,0x5772,0x576d,0x576b,0x5771,0x5770,0x5776,
0x5780,0x5775,0x577b,0x5773,0x5774,0x5762,0x5768,0x577d,
0x590c,0x5945,0x59b5,0x59ba,0x59cf,0x59ce,0x59b2,0x59cc,
0x59c1,0x59b6,0x59bc,0x59c3,0x59d6,0x59b1,0x59bd,0x59c0,
0x59c8,0x59b4,0x59c7,0x5b62,0x5b65,0x5b93,0x5b95,0x5c44,
0x5c47,0x5cae,0x5ca4,0x5ca0,0x5cb5,0x5caf,0x5ca8,0x5cac,
0x5c9f,0x5ca3,0x5cad,0x5ca2,0x5caa,0x5ca7,0x5c9d,0x5ca5,
0x5cb6,0x5cb0,0x5ca6,0x5e17,0x5e14,0x5e19,0x5f28,0x5f22,
0x5f23,0x5f24,0x5f54,0x5f82,0x5f7e,0x5f7d,0x5fde,0x5fe5,
0x602d,0x6026,0x6019,0x6032,0x600b,0x6034,0x600a,0x6017,
0x6033,0x601a,0x601e,0x602c,0x6022,0x600d,0x6010,0x602e,
0x6013,0x6011,0x600c,0x6009,0x601c,0x6214,0x623d,0x62ad,
0x62b4,0x62d1,0x62be,0x62aa,0x62b6,0x62ca,0x62ae,0x62b3,
0x62af,0x62bb,0x62a9,0x62b0,0x62b8,0x653d,0x65a8,0x65bb,
0x6609,0x65fc,0x6604,0x6612,0x6608,0x65fb,0x6603,0x660b,
0x660d,0x6605,0x65fd,0x6611,0x6610,0x66f6,0x670a,0x6785,
0x676c,0x678e,0x6792,0x6776,0x677b,0x6798,0x6786,0x6784,
0x6774,0x678d,0x678c,0x677a,0x679f,0x6791,0x6799,0x6783,
0x677d,0x6781,0x6778,0x6779,0x6794,0x6b25,0x6b80,0x6b7e,
0x6bde,0x6c1d,0x6c93,0x6cec,0x6ceb,0x6cee,0x6cd9,0x6cb6,
0x6cd4,0x6cad,0x6ce7,0x6cb7,0x6cd0,0x6cc2,0x6cba,0x6cc3,
0x6cc6,0x6ced,0x6cf2,0x6cd2,0x6cdd,0x6cb4,0x6c8a,0x6c9d,
0x6c80,0x6cde,0x6cc0,0x6d30,0x6ccd,0x6cc7,0x6cb0,0x6cf9,
0x6ccf,0x6ce9,0x6cd1,0x7094,0x7098,0x7085,0x7093,0x7086,
0x7084,0x7091,0x7096,0x7082,0x709a,0x7083,0x726a,0x72d6,
0x72cb,0x72d8,0x72c9,0x72dc,0x72d2,0x72d4,0x72da,0x72cc,
0x72d1,0x73a4,0x73a1,0x73ad,0x73a6,0x73a2,0x73a0,0x73ac,
0x739d,0x74dd,0x74e8,0x753f,0x7540,0x753e,0x758c,0x7598,
0x76af,0x76f3,0x76f1,0x76f0,0x76f5,0x77f8,0x77fc,0x77f9,
0x77fb,0x77fa,0x77f7,0x7942,0x793f,0x79c5,0x7a78,0x7a7b,
0x7afb,0x7c75,0x7cfd,0x8035,0x808f,0x80ae,0x80a3,0x80b8,
0x80b5,0x80ad,0x8220,0x82a0,0x82c0,0x82ab,0x829a,0x8298,
0x829b,0x82b5,0x82a7,0x82ae,0x82bc,0x829e,0x82ba,0x82b4,
0x82a8,0x82a1,0x82a9,0x82c2,0x82a4,0x82c3,0x82b6,0x82a2,
0x8670,0x866f,0x866d,0x866e,0x8c56,0x8fd2,0x8fcb,0x8fd3,
0x8fcd,0x8fd6,0x8fd5,0x8fd7,0x90b2,0x90b4,0x90af,0x90b3,
0x90b0,0x9639,0x963d,0x963c,0x963a,0x9643,0x4fcd,0x4fc5,
0x4fd3,0x4fb2,0x4fc9,0x4fcb,0x4fc1,0x4fd4,0x4fdc,0x4fd9,
0x4fbb,0x4fb3,0x4fdb,0x4fc7,0x4fd6,0x4fba,0x4fc0,0x4fb9,
0x4fec,0x5244,0x5249,0x52c0,0x52c2,0x533d,0x537c,0x5397,
0x5396,0x5399,0x5398,0x54ba,0x54a1,0x54ad,0x54a5,0x54cf,
0x54c3,0x830d,0x54b7,0x54ae,0x54d6,0x54b6,0x54c5,0x54c6,
0x54a0,0x5470,0x54bc,0x54a2,0x54be,0x5472,0x54de,0x54b0,
0x57b5,0x579e,0x579f,0x57a4,0x578c,0x5797,0x579d,0x579b,
0x5794,0x5798,0x578f,0x5799,0x57a5,0x579a,0x5795,0x58f4,
0x590d,0x5953,0x59e1,0x59de,0x59ee,0x5a00,0x59f1,0x59dd,
0x59fa,0x59fd,0x59fc,0x59f6,0x59e4,0x59f2,0x59f7,0x59db,
0x59e9,0x59f3,0x59f5,0x59e0,0x59fe,0x59f4,0x59ed,0x5ba8,
0x5c4c,0x5cd0,0x5cd8,0x5ccc,0x5cd7,0x5ccb,0x5cdb,0x5cde,
0x5cda,0x5cc9,0x5cc7,0x5cca,0x5cd6,0x5cd3,0x5cd4,0x5ccf,
0x5cc8,0x5cc6,0x5cce,0x5cdf,0x5cf8,0x5df9,0x5e21,0x5e22,
0x5e23,0x5e20,0x5e24,0x5eb0,0x5ea4,0x5ea2,0x5e9b,0x5ea3,
0x5ea5,0x5f07,0x5f2e,0x5f56,0x5f86,0x6037,0x6039,0x6054,
0x6072,0x605e,0x6045,0x6053,0x6047,0x6049,0x605b,0x604c,
0x6040,0x6042,0x605f,0x6024,0x6044,0x6058,0x6066,0x606e,
0x6242,0x6243,0x62cf,0x630d,0x630b,0x62f5,0x630e,0x6303,
0x62eb,0x62f9,0x630f,0x630c,0x62f8,0x62f6,0x6300,0x6313,
0x6314,0x62fa,0x6315,0x62fb,0x62f0,0x6541,0x6543,0x65aa,
0x65bf,0x6636,0x6621,0x6632,0x6635,0x661c,0x6626,0x6622,
0x6633,0x662b,0x663a,0x661d,0x6634,0x6639,0x662e,0x670f,
0x6710,0x67c1,0x67f2,0x67c8,0x67ba,0x67dc,0x67bb,0x67f8,
0x67d8,0x67c0,0x67b7,0x67c5,0x67eb,0x67e4,0x67df,0x67b5,
0x67cd,0x67b3,0x67f7,0x67f6,0x67ee,0x67e3,0x67c2,0x67b9,
0x67ce,0x67e7,0x67f0,0x67b2,0x67fc,0x67c6,0x67ed,0x67cc,
0x67ae,0x67e6,0x67db,0x67fa,0x67c9,0x67ca,0x67c3,0x67ea,
0x67cb,0x6b28,0x6b82,0x6b84,0x6bb6,0x6bd6,0x6bd8,0x6be0,
0x6c20,0x6c21,0x6d28,0x6d34,0x6d2d,0x6d1f,0x6d3c,0x6d3f,
0x6d12,0x6d0a,0x6cda,0x6d33,0x6d04,0x6d19,0x6d3a,0x6d1a,
0x6d11,0x6d00,0x6d1d,0x6d42,0x6d01,0x6d18,0x6d37,0x6d03,
0x6d0f,0x6d40,0x6d07,0x6d20,0x6d2c,0x6d08,0x6d22,0x6d09,
0x6d10,0x70b7,0x709f,0x70be,0x70b1,0x70b0,0x70a1,0x70b4,
0x70b5,0x70a9,0x7241,0x7249,0x724a,0x726c,0x7270,0x7273,
0x726e,0x72ca,0x72e4,0x72e8,0x72eb,0x72df,0x72ea,0x72e6,
0x72e3,0x7385,0x73cc,0x73c2,0x73c8,0x73c5,0x73b9,0x73b6,
0x73b5,0x73b4,0x73eb,0x73bf,0x73c7,0x73be,0x73c3,0x73c6,
0x73b8,0x73cb,0x74ec,0x74ee,0x752e,0x7547,0x7548,0x75a7,
0x75aa,0x7679,0x76c4,0x7708,0x7703,0x7704,0x7705,0x770a,
0x76f7,0x76fb,0x76fa,0x77e7,0x77e8,0x7806,0x7811,0x7812,
0x7805,0x7810,0x780f,0x780e,0x7809,0x7803,0x7813,0x794a,
0x794c,0x794b,0x7945,0x7944,0x79d5,0x79cd,0x79cf,0x79d6,
0x79ce,0x7a80,0x7a7e,0x7ad1,0x7b00,0x7b01,0x7c7a,0x7c78,
0x7c79,0x7c7f,0x7c80,0x7c81,0x7d03,0x7d08,0x7d01,0x7f58,
0x7f91,0x7f8d,0x7fbe,0x8007,0x800e,0x800f,0x8014,0x8037,
0x80d8,0x80c7,0x80e0,0x80d1,0x80c8,0x80c2,0x80d0,0x80c5,
0x80e3,0x80d9,0x80dc,0x80ca,0x80d5,0x80c9,0x80cf,0x80d7,
0x80e6,0x80cd,0x81ff,0x8221,0x8294,0x82d9,0x82fe,0x82f9,
0x8307,0x82e8,0x8300,0x82d5,0x833a,0x82eb,0x82d6,0x82f4,
0x82ec,0x82e1,0x82f2,0x82f5,0x830c,0x82fb,0x82f6,0x82f0,
0x82ea,0x82e4,0x82e0,0x82fa,0x82f3,0x82ed,0x8677,0x8674,
0x867c,0x8673,0x8841,0x884e,0x8867,0x886a,0x8869,0x89d3,
0x8a04,0x8a07,0x8d72,0x8fe3,0x8fe1,0x8fee,0x8fe0,0x90f1,
0x90bd,0x90bf,0x90d5,0x90c5,0x90be,0x90c7,0x90cb,0x90c8,
0x91d4,0x91d3,0x9654,0x964f,0x9651,0x9653,0x964a,0x964e,
0x501e,0x5005,0x5007,0x5013,0x5022,0x5030,0x501b,0x4ff5,
0x4ff4,0x5033,0x5037,0x502c,0x4ff6,0x4ff7,0x5017,0x501c,
0x5020,0x5027,0x5035,0x502f,0x5031,0x500e,0x515a,0x5194,
0x5193,0x51ca,0x51c4,0x51c5,0x51c8,0x51ce,0x5261,0x525a,
0x5252,0x525e,0x525f,0x5255,0x5262,0x52cd,0x530e,0x539e,
0x5526,0x54e2,0x5517,0x5512,0x54e7,0x54f3,0x54e4,0x551a,
0x54ff,0x5504,0x5508,0x54eb,0x5511,0x5505,0x54f1,0x550a,
0x54fb,0x54f7,0x54f8,0x54e0,0x550e,0x5503,0x550b,0x5701,
0x5702,0x57cc,0x5832,0x57d5,0x57d2,0x57ba,0x57c6,0x57bd,
0x57bc,0x57b8,0x57b6,0x57bf,0x57c7,0x57d0,0x57b9,0x57c1,
0x590e,0x594a,0x5a19,0x5a16,0x5a2d,0x5a2e,0x5a15,0x5a0f,
0x5a17,0x5a0a,0x5a1e,0x5a33,0x5b6c,0x5ba7,0x5bad,0x5bac,
0x5c03,0x5c56,0x5c54,0x5cec,0x5cff,0x5cee,0x5cf1,0x5cf7,
0x5d00,0x5cf9,0x5e29,0x5e28,0x5ea8,0x5eae,0x5eaa,0x5eac,
0x5f33,0x5f30,0x5f67,0x605d,0x605a,0x6067,0x6041,0x60a2,
0x6088,0x6080,0x6092,0x6081,0x609d,0x6083,0x6095,0x609b,
0x6097,0x6087,0x609c,0x608e,0x6219,0x6246,0x62f2,0x6310,
0x6356,0x632c,0x6344,0x6345,0x6336,0x6343,0x63e4,0x6339,
0x634b,0x634a,0x633c,0x6329,0x6341,0x6334,0x6358,0x6354,
0x6359,0x632d,0x6347,0x6333,0x635a,0x6351,0x6338,0x6357,
0x6340,0x6348,0x654a,0x6546,0x65c6,0x65c3,0x65c4,0x65c2,
0x664a,0x665f,0x6647,0x6651,0x6712,0x6713,0x681f,0x681a,
0x6849,0x6832,0x6833,0x683b,0x684b,0x684f,0x6816,0x6831,
0x681c,0x6835,0x682b,0x682d,0x682f,0x684e,0x6844,0x6834,
0x681d,0x6812,0x6814,0x6826,0x6828,0x682e,0x684d,0x683a,
0x6825,0x6820,0x6b2c,0x6b2f,0x6b2d,0x6b31,0x6b34,0x6b6d,
0x8082,0x6b88,0x6be6,0x6be4,0x6be8,0x6be3,0x6be2,0x6be7,
0x6c25,0x6d7a,0x6d63,0x6d64,0x6d76,0x6d0d,0x6d61,0x6d92,
0x6d58,0x6d62,0x6d6d,0x6d6f,0x6d91,0x6d8d,0x6def,0x6d7f,
0x6d86,0x6d5e,0x6d67,0x6d60,0x6d97,0x6d70,0x6d7c,0x6d5f,
0x6d82,0x6d98,0x6d2f,0x6d68,0x6d8b,0x6d7e,0x6d80,0x6d84,
0x6d16,0x6d83,0x6d7b,0x6d7d,0x6d75,0x6d90,0x70dc,0x70d3,
0x70d1,0x70dd,0x70cb,0x7f39,0x70e2,0x70d7,0x70d2,0x70de,
0x70e0,0x70d4,0x70cd,0x70c5,0x70c6,0x70c7,0x70da,0x70ce,
0x70e1,0x7242,0x7278,0x7277,0x7276,0x7300,0x72fa,0x72f4,
0x72fe,0x72f6,0x72f3,0x72fb,0x7301,0x73d3,0x73d9,0x73e5,
0x73d6,0x73bc,0x73e7,0x73e3,0x73e9,0x73dc,0x73d2,0x73db,
0x73d4,0x73dd,0x73da,0x73d7,0x73d8,0x73e8,0x74de,0x74df,
0x74f4,0x74f5,0x7521,0x755b,0x755f,0x75b0,0x75c1,0x75bb,
0x75c4,0x75c0,0x75bf,0x75b6,0x75ba,0x768a,0x76c9,0x771d,
0x771b,0x7710,0x7713,0x7712,0x7723,0x7711,0x7715,0x7719,
0x771a,0x7722,0x7727,0x7823,0x782c,0x7822,0x7835,0x782f,
0x7828,0x782e,0x782b,0x7821,0x7829,0x7833,0x782a,0x7831,
0x7954,0x795b,0x794f,0x795c,0x7953,0x7952,0x7951,0x79eb,
0x79ec,0x79e0,0x79ee,0x79ed,0x79ea,0x79dc,0x79de,0x79dd,
0x7a86,0x7a89,0x7a85,0x7a8b,0x7a8c,0x7a8a,0x7a87,0x7ad8,
0x7b10,0x7b04,0x7b13,0x7b05,0x7b0f,0x7b08,0x7b0a,0x7b0e,
0x7b09,0x7b12,0x7c84,0x7c91,0x7c8a,0x7c8c,0x7c88,0x7c8d,
0x7c85,0x7d1e,0x7d1d,0x7d11,0x7d0e,0x7d18,0x7d16,0x7d13,
0x7d1f,0x7d12,0x7d0f,0x7d0c,0x7f5c,0x7f61,0x7f5e,0x7f60,
0x7f5d,0x7f5b,0x7f96,0x7f92,0x7fc3,0x7fc2,0x7fc0,0x8016,
0x803e,0x8039,0x80fa,0x80f2,0x80f9,0x80f5,0x8101,0x80fb,
0x8100,0x8201,0x822f,0x8225,0x8333,0x832d,0x8344,0x8319,
0x8351,0x8325,0x8356,0x833f,0x8341,0x8326,0x831c,0x8322,
0x8342,0x834e,0x831b,0x832a,0x8308,0x833c,0x834d,0x8316,
0x8324,0x8320,0x8337,0x832f,0x8329,0x8347,0x8345,0x834c,
0x8353,0x831e,0x832c,0x834b,0x8327,0x8348,0x8653,0x8652,
0x86a2,0x86a8,0x8696,0x868d,0x8691,0x869e,0x8687,0x8697,
0x8686,0x868b,0x869a,0x8685,0x86a5,0x8699,0x86a1,0x86a7,
0x8695,0x8698,0x868e,0x869d,0x8690,0x8694,0x8843,0x8844,
0x886d,0x8875,0x8876,0x8872,0x8880,0x8871,0x887f,0x886f,
0x8883,0x887e,0x8874,0x887c,0x8a12,0x8c47,0x8c57,0x8c7b,
0x8ca4,0x8ca3,0x8d76,0x8d78,0x8db5,0x8db7,0x8db6,0x8ed1,
0x8ed3,0x8ffe,0x8ff5,0x9002,0x8fff,0x8ffb,0x9004,0x8ffc,
0x8ff6,0x90d6,0x90e0,0x90d9,0x90da,0x90e3,0x90df,0x90e5,
0x90d8,0x90db,0x90d7,0x90dc,0x90e4,0x9150,0x914e,0x914f,
0x91d5,0x91e2,0x91da,0x965c,0x965f,0x96bc,0x98e3,0x9adf,
0x9b2f,0x4e7f,0x5070,0x506a,0x5061,0x505e,0x5060,0x5053,
0x504b,0x505d,0x5072,0x5048,0x504d,0x5041,0x505b,0x504a,
0x5062,0x5015,0x5045,0x505f,0x5069,0x506b,0x5063,0x5064,
0x5046,0x5040,0x506e,0x5073,0x5057,0x5051,0x51d0,0x526b,
0x526d,0x526c,0x526e,0x52d6,0x52d3,0x532d,0x539c,0x5575,
0x5576,0x553c,0x554d,0x5550,0x5534,0x552a,0x5551,0x5562,
0x5536,0x5535,0x5530,0x5552,0x5545,0x550c,0x5532,0x5565,
0x554e,0x5539,0x5548,0x552d,0x553b,0x5540,0x554b,0x570a,
0x5707,0x57fb,0x5814,0x57e2,0x57f6,0x57dc,0x57f4,0x5800,
0x57ed,0x57fd,0x5808,0x57f8,0x580b,0x57f3,0x57cf,0x5807,
0x57ee,0x57e3,0x57f2,0x57e5,0x57ec,0x57e1,0x580e,0x57fc,
0x5810,0x57e7,0x5801,0x580c,0x57f1,0x57e9,0x57f0,0x580d,
0x5804,0x595c,0x5a60,0x5a58,0x5a55,0x5a67,0x5a5e,0x5a38,
0x5a35,0x5a6d,0x5a50,0x5a5f,0x5a65,0x5a6c,0x5a53,0x5a64,
0x5a57,0x5a43,0x5a5d,0x5a52,0x5a44,0x5a5b,0x5a48,0x5a8e,
0x5a3e,0x5a4d,0x5a39,0x5a4c,0x5a70,0x5a69,0x5a47,0x5a51,
0x5a56,0x5a42,0x5a5c,0x5b72,0x5b6e,0x5bc1,0x5bc0,0x5c59,
0x5d1e,0x5d0b,0x5d1d,0x5d1a,0x5d20,0x5d0c,0x5d28,0x5d0d,
0x5d26,0x5d25,0x5d0f,0x5d30,0x5d12,0x5d23,0x5d1f,0x5d2e,
0x5e3e,0x5e34,0x5eb1,0x5eb4,0x5eb9,0x5eb2,0x5eb3,0x5f36,
0x5f38,0x5f9b,0x5f96,0x5f9f,0x608a,0x6090,0x6086,0x60be,
0x60b0,0x60ba,0x60d3,0x60d4,0x60cf,0x60e4,0x60d9,0x60dd,
0x60c8,0x60b1,0x60db,0x60b7,0x60ca,0x60bf,0x60c3,0x60cd,
0x60c0,0x6332,0x6365,0x638a,0x6382,0x637d,0x63bd,0x639e,
0x63ad,0x639d,0x6397,0x63ab,0x638e,0x636f,0x6387,0x6390,
0x636e,0x63af,0x6375,0x639c,0x636d,0x63ae,0x637c,0x63a4,
0x633b,0x639f,0x6378,0x6385,0x6381,0x6391,0x638d,0x6370,
0x6553,0x65cd,0x6665,0x6661,0x665b,0x6659,0x665c,0x6662,
0x6718,0x6879,0x6887,0x6890,0x689c,0x686d,0x686e,0x68ae,
0x68ab,0x6956,0x686f,0x68a3,0x68ac,0x68a9,0x6875,0x6874,
0x68b2,0x688f,0x6877,0x6892,0x687c,0x686b,0x6872,0x68aa,
0x6880,0x6871,0x687e,0x689b,0x6896,0x688b,0x68a0,0x6889,
0x68a4,0x6878,0x687b,0x6891,0x688c,0x688a,0x687d,0x6b36,
0x6b33,0x6b37,0x6b38,0x6b91,0x6b8f,0x6b8d,0x6b8e,0x6b8c,
0x6c2a,0x6dc0,0x6dab,0x6db4,0x6db3,0x6e74,0x6dac,0x6de9,
0x6de2,0x6db7,0x6df6,0x6dd4,0x6e00,0x6dc8,0x6de0,0x6ddf,
0x6dd6,0x6dbe,0x6de5,0x6ddc,0x6ddd,0x6ddb,0x6df4,0x6dca,
0x6dbd,0x6ded,0x6df0,0x6dba,0x6dd5,0x6dc2,0x6dcf,0x6dc9,
0x6dd0,0x6df2,0x6dd3,0x6dfd,0x6dd7,0x6dcd,0x6de3,0x6dbb,
0x70fa,0x710d,0x70f7,0x7117,0x70f4,0x710c,0x70f0,0x7104,
0x70f3,0x7110,0x70fc,0x70ff,0x7106,0x7113,0x7100,0x70f8,
0x70f6,0x710b,0x7102,0x710e,0x727e,0x727b,0x727c,0x727f,
0x731d,0x7317,0x7307,0x7311,0x7318,0x730a,0x7308,0x72ff,
0x730f,0x731e,0x7388,0x73f6,0x73f8,0x73f5,0x7404,0x7401,
0x73fd,0x7407,0x7400,0x73fa,0x73fc,0x73ff,0x740c,0x740b,
0x73f4,0x7408,0x7564,0x7563,0x75ce,0x75d2,0x75cf,0x75cb,
0x75cc,0x75d1,0x75d0,0x768f,0x7689,0x76d3,0x7739,0x772f,
0x772d,0x7731,0x7732,0x7734,0x7733,0x773d,0x7725,0x773b,
0x7735,0x7848,0x7852,0x7849,0x784d,0x784a,0x784c,0x7826,
0x7845,0x7850,0x7964,0x7967,0x7969,0x796a,0x7963,0x796b,
0x7961,0x79bb,0x79fa,0x79f8,0x79f6,0x79f7,0x7a8f,0x7a94,
0x7a90,0x7b35,0x7b3b,0x7b34,0x7b25,0x7b30,0x7b22,0x7b24,
0x7b33,0x7b18,0x7b2a,0x7b1d,0x7b31,0x7b2b,0x7b2d,0x7b2f,
0x7b32,0x7b38,0x7b1a,0x7b23,0x7c94,0x7c98,0x7c96,0x7ca3,
0x7d35,0x7d3d,0x7d38,0x7d36,0x7d3a,0x7d45,0x7d2c,0x7d29,
0x7d41,0x7d47,0x7d3e,0x7d3f,0x7d4a,0x7d3b,0x7d28,0x7f63,
0x7f95,0x7f9c,0x7f9d,0x7f9b,0x7fca,0x7fcb,0x7fcd,0x7fd0,
0x7fd1,0x7fc7,0x7fcf,0x7fc9,0x801f,0x801e,0x801b,0x8047,
0x8043,0x8048,0x8118,0x8125,0x8119,0x811b,0x812d,0x811f,
0x812c,0x811e,0x8121,0x8115,0x8127,0x811d,0x8122,0x8211,
0x8238,0x8233,0x823a,0x8234,0x8232,0x8274,0x8390,0x83a3,
0x83a8,0x838d,0x837a,0x8373,0x83a4,0x8374,0x838f,0x8381,
0x8395,0x8399,0x8375,0x8394,0x83a9,0x837d,0x8383,0x838c,
0x839d,0x839b,0x83aa,0x838b,0x837e,0x83a5,0x83af,0x8388,
0x8397,0x83b0,0x837f,0x83a6,0x8387,0x83ae,0x8376,0x8659,
0x8656,0x86bf,0x86b7,0x86c2,0x86c1,0x86c5,0x86ba,0x86b0,
0x86c8,0x86b9,0x86b3,0x86b8,0x86cc,0x86b4,0x86bb,0x86bc,
0x86c3,0x86bd,0x86be,0x8852,0x8889,0x8895,0x88a8,0x88a2,
0x88aa,0x889a,0x8891,0x88a1,0x889f,0x8898,0x88a7,0x8899,
0x889b,0x8897,0x88a4,0x88ac,0x888c,0x8893,0x888e,0x8982,
0x89d6,0x89d9,0x89d5,0x8a30,0x8a27,0x8a2c,0x8a1e,0x8c39,
0x8c3b,0x8c5c,0x8c5d,0x8c7d,0x8ca5,0x8d7d,0x8d7b,0x8d79,
0x8dbc,0x8dc2,0x8db9,0x8dbf,0x8dc1,0x8ed8,0x8ede,0x8edd,
0x8edc,0x8ed7,0x8ee0,0x8ee1,0x9024,0x900b,0x9011,0x901c,
0x900c,0x9021,0x90ef,0x90ea,0x90f0,0x90f4,0x90f2,0x90f3,
0x90d4,0x90eb,0x90ec,0x90e9,0x9156,0x9158,0x915a,0x9153,
0x9155,0x91ec,0x91f4,0x91f1,0x91f3,0x91f8,0x91e4,0x91f9,
0x91ea,0x91eb,0x91f7,0x91e8,0x91ee,0x957a,0x9586,0x9588,
0x967c,0x966d,0x966b,0x9671,0x966f,0x96bf,0x976a,0x9804,
0x98e5,0x9997,0x509b,0x5095,0x5094,0x509e,0x508b,0x50a3,
0x5083,0x508c,0x508e,0x509d,0x5068,0x509c,0x5092,0x5082,
0x5087,0x515f,0x51d4,0x5312,0x5311,0x53a4,0x53a7,0x5591,
0x55a8,0x55a5,0x55ad,0x5577,0x5645,0x55a2,0x5593,0x5588,
0x558f,0x55b5,0x5581,0x55a3,0x5592,0x55a4,0x557d,0x558c,
0x55a6,0x557f,0x5595,0x55a1,0x558e,0x570c,0x5829,0x5837,
0x5819,0x581e,0x5827,0x5823,0x5828,0x57f5,0x5848,0x5825,
0x581c,0x581b,0x5833,0x583f,0x5836,0x582e,0x5839,0x5838,
0x582d,0x582c,0x583b,0x5961,0x5aaf,0x5a94,0x5a9f,0x5a7a,
0x5aa2,0x5a9e,0x5a78,0x5aa6,0x5a7c,0x5aa5,0x5aac,0x5a95,
0x5aae,0x5a37,0x5a84,0x5a8a,0x5a97,0x5a83,0x5a8b,0x5aa9,
0x5a7b,0x5a7d,0x5a8c,0x5a9c,0x5a8f,0x5a93,0x5a9d,0x5bea,
0x5bcd,0x5bcb,0x5bd4,0x5bd1,0x5bca,0x5bce,0x5c0c,0x5c30,
0x5d37,0x5d43,0x5d6b,0x5d41,0x5d4b,0x5d3f,0x5d35,0x5d51,
0x5d4e,0x5d55,0x5d33,0x5d3a,0x5d52,0x5d3d,0x5d31,0x5d59,
0x5d42,0x5d39,0x5d49,0x5d38,0x5d3c,0x5d32,0x5d36,0x5d40,
0x5d45,0x5e44,0x5e41,0x5f58,0x5fa6,0x5fa5,0x5fab,0x60c9,
0x60b9,0x60cc,0x60e2,0x60ce,0x60c4,0x6114,0x60f2,0x610a,
0x6116,0x6105,0x60f5,0x6113,0x60f8,0x60fc,0x60fe,0x60c1,
0x6103,0x6118,0x611d,0x6110,0x60ff,0x6104,0x610b,0x624a,
0x6394,0x63b1,0x63b0,0x63ce,0x63e5,0x63e8,0x63ef,0x63c3,
0x649d,0x63f3,0x63ca,0x63e0,0x63f6,0x63d5,0x63f2,0x63f5,
0x6461,0x63df,0x63be,0x63dd,0x63dc,0x63c4,0x63d8,0x63d3,
0x63c2,0x63c7,0x63cc,0x63cb,0x63c8,0x63f0,0x63d7,0x63d9,
0x6532,0x6567,0x656a,0x6564,0x655c,0x6568,0x6565,0x658c,
0x659d,0x659e,0x65ae,0x65d0,0x65d2,0x667c,0x666c,0x667b,
0x6680,0x6671,0x6679,0x666a,0x6672,0x6701,0x690c,0x68d3,
0x6904,0x68dc,0x692a,0x68ec,0x68ea,0x68f1,0x690f,0x68d6,
0x68f7,0x68eb,0x68e4,0x68f6,0x6913,0x6910,0x68f3,0x68e1,
0x6907,0x68cc,0x6908,0x6970,0x68b4,0x6911,0x68ef,0x68c6,
0x6914,0x68f8,0x68d0,0x68fd,0x68fc,0x68e8,0x690b,0x690a,
0x6917,0x68ce,0x68c8,0x68dd,0x68de,0x68e6,0x68f4,0x68d1,
0x6906,0x68d4,0x68e9,0x6915,0x6925,0x68c7,0x6b39,0x6b3b,
0x6b3f,0x6b3c,0x6b94,0x6b97,0x6b99,0x6b95,0x6bbd,0x6bf0,
0x6bf2,0x6bf3,0x6c30,0x6dfc,0x6e46,0x6e47,0x6e1f,0x6e49,
0x6e88,0x6e3c,0x6e3d,0x6e45,0x6e62,0x6e2b,0x6e3f,0x6e41,
0x6e5d,0x6e73,0x6e1c,0x6e33,0x6e4b,0x6e40,0x6e51,0x6e3b,
0x6e03,0x6e2e,0x6e5e,0x6e68,0x6e5c,0x6e61,0x6e31,0x6e28,
0x6e60,0x6e71,0x6e6b,0x6e39,0x6e22,0x6e30,0x6e53,0x6e65,
0x6e27,0x6e78,0x6e64,0x6e77,0x6e55,0x6e79,0x6e52,0x6e66,
0x6e35,0x6e36,0x6e5a,0x7120,0x711e,0x712f,0x70fb,0x712e,
0x7131,0x7123,0x7125,0x7122,0x7132,0x711f,0x7128,0x713a,
0x711b,0x724b,0x725a,0x7288,0x7289,0x7286,0x7285,0x728b,
0x7312,0x730b,0x7330,0x7322,0x7331,0x7333,0x7327,0x7332,
0x732d,0x7326,0x7323,0x7335,0x730c,0x742e,0x742c,0x7430,
0x742b,0x7416,0x741a,0x7421,0x742d,0x7431,0x7424,0x7423,
0x741d,0x7429,0x7420,0x7432,0x74fb,0x752f,0x756f,0x756c,
0x75e7,0x75da,0x75e1,0x75e6,0x75dd,0x75df,0x75e4,0x75d7,
0x7695,0x7692,0x76da,0x7746,0x7747,0x7744,0x774d,0x7745,
0x774a,0x774e,0x774b,0x774c,0x77de,0x77ec,0x7860,0x7864,
0x7865,0x785c,0x786d,0x7871,0x786a,0x786e,0x7870,0x7869,
0x7868,0x785e,0x7862,0x7974,0x7973,0x7972,0x7970,0x7a02,
0x7a0a,0x7a03,0x7a0c,0x7a04,0x7a99,0x7ae6,0x7ae4,0x7b4a,
0x7b47,0x7b44,0x7b48,0x7b4c,0x7b4e,0x7b40,0x7b58,0x7b45,
0x7ca2,0x7c9e,0x7ca8,0x7ca1,0x7d58,0x7d6f,0x7d63,0x7d53,
0x7d56,0x7d67,0x7d6a,0x7d4f,0x7d6d,0x7d5c,0x7d6b,0x7d52,
0x7d54,0x7d69,0x7d51,0x7d5f,0x7d4e,0x7f3e,0x7f3f,0x7f65,
0x7f66,0x7fa2,0x7fa0,0x7fa1,0x7fd7,0x8051,0x804f,0x8050,
0x80fe,0x80d4,0x8143,0x814a,0x8152,0x814f,0x8147,0x813d,
0x814d,0x813a,0x81e6,0x81ee,0x81f7,0x81f8,0x81f9,0x8204,
0x823c,0x823d,0x823f,0x8275,0x833b,0x83cf,0x83f9,0x8423,
0x83c0,0x83e8,0x8412,0x83e7,0x83e4,0x83fc,0x83f6,0x8410,
0x83c6,0x83c8,0x83eb,0x83e3,0x83bf,0x8401,0x83dd,0x83e5,
0x83d8,0x83ff,0x83e1,0x83cb,0x83ce,0x83d6,0x83f5,0x83c9,
0x8409,0x840f,0x83de,0x8411,0x8406,0x83c2,0x83f3,0x83d5,
0x83fa,0x83c7,0x83d1,0x83ea,0x8413,0x839a,0x83c3,0x83ec,
0x83ee,0x83c4,0x83fb,0x83d7,0x83e2,0x841b,0x83db,0x83fe,
0x86d8,0x86e2,0x86e6,0x86d3,0x86e3,0x86da,0x86ea,0x86dd,
0x86eb,0x86dc,0x86ec,0x86e9,0x86d7,0x86e8,0x86d1,0x8848,
0x8856,0x8855,0x88ba,0x88d7,0x88b9,0x88b8,0x88c0,0x88be,
0x88b6,0x88bc,0x88b7,0x88bd,0x88b2,0x8901,0x88c9,0x8995,
0x8998,0x8997,0x89dd,0x89da,0x89db,0x8a4e,0x8a4d,0x8a39,
0x8a59,0x8a40,0x8a57,0x8a58,0x8a44,0x8a45,0x8a52,0x8a48,
0x8a51,0x8a4a,0x8a4c,0x8a4f,0x8c5f,0x8c81,0x8c80,0x8cba,
0x8cbe,0x8cb0,0x8cb9,0x8cb5,0x8d84,0x8d80,0x8d89,0x8dd8,
0x8dd3,0x8dcd,0x8dc7,0x8dd6,0x8ddc,0x8dcf,0x8dd5,0x8dd9,
0x8dc8,0x8dd7,0x8dc5,0x8eef,0x8ef7,0x8efa,0x8ef9,0x8ee6,
0x8eee,0x8ee5,0x8ef5,0x8ee7,0x8ee8,0x8ef6,0x8eeb,0x8ef1,
0x8eec,0x8ef4,0x8ee9,0x902d,0x9034,0x902f,0x9106,0x912c,
0x9104,0x90ff,0x90fc,0x9108,0x90f9,0x90fb,0x9101,0x9100,
0x9107,0x9105,0x9103,0x9161,0x9164,0x915f,0x9162,0x9160,
0x9201,0x920a,0x9225,0x9203,0x921a,0x9226,0x920f,0x920c,
0x9200,0x9212,0x91ff,0x91fd,0x9206,0x9204,0x9227,0x9202,
0x921c,0x9224,0x9219,0x9217,0x9205,0x9216,0x957b,0x958d,
0x958c,0x9590,0x9687,0x967e,0x9688,0x9689,0x9683,0x9680,
0x96c2,0x96c8,0x96c3,0x96f1,0x96f0,0x976c,0x9770,0x976e,
0x9807,0x98a9,0x98eb,0x9ce6,0x9ef9,0x4e83,0x4e84,0x4eb6,
0x50bd,0x50bf,0x50c6,0x50ae,0x50c4,0x50ca,0x50b4,0x50c8,
0x50c2,0x50b0,0x50c1,0x50ba,0x50b1,0x50cb,0x50c9,0x50b6,
0x50b8,0x51d7,0x527a,0x5278,0x527b,0x527c,0x55c3,0x55db,
0x55cc,0x55d0,0x55cb,0x55ca,0x55dd,0x55c0,0x55d4,0x55c4,
0x55e9,0x55bf,0x55d2,0x558d,0x55cf,0x55d5,0x55e2,0x55d6,
0x55c8,0x55f2,0x55cd,0x55d9,0x55c2,0x5714,0x5853,0x5868,
0x5864,0x584f,0x584d,0x5849,0x586f,0x5855,0x584e,0x585d,
0x5859,0x5865,0x585b,0x583d,0x5863,0x5871,0x58fc,0x5ac7,
0x5ac4,0x5acb,0x5aba,0x5ab8,0x5ab1,0x5ab5,0x5ab0,0x5abf,
0x5ac8,0x5abb,0x5ac6,0x5ab7,0x5ac0,0x5aca,0x5ab4,0x5ab6,
0x5acd,0x5ab9,0x5a90,0x5bd6,0x5bd8,0x5bd9,0x5c1f,0x5c33,
0x5d71,0x5d63,0x5d4a,0x5d65,0x5d72,0x5d6c,0x5d5e,0x5d68,
0x5d67,0x5d62,0x5df0,0x5e4f,0x5e4e,0x5e4a,0x5e4d,0x5e4b,
0x5ec5,0x5ecc,0x5ec6,0x5ecb,0x5ec7,0x5f40,0x5faf,0x5fad,
0x60f7,0x6149,0x614a,0x612b,0x6145,0x6136,0x6132,0x612e,
0x6146,0x612f,0x614f,0x6129,0x6140,0x6220,0x9168,0x6223,
0x6225,0x6224,0x63c5,0x63f1,0x63eb,0x6410,0x6412,0x6409,
0x6420,0x6424,0x6433,0x6443,0x641f,0x6415,0x6418,0x6439,
0x6437,0x6422,0x6423,0x640c,0x6426,0x6430,0x6428,0x6441,
0x6435,0x642f,0x640a,0x641a,0x6440,0x6425,0x6427,0x640b,
0x63e7,0x641b,0x642e,0x6421,0x640e,0x656f,0x6592,0x65d3,
0x6686,0x668c,0x6695,0x6690,0x668b,0x668a,0x6699,0x6694,
0x6678,0x6720,0x6966,0x695f,0x6938,0x694e,0x6962,0x6971,
0x693f,0x6945,0x696a,0x6939,0x6942,0x6957,0x6959,0x697a,
0x6948,0x6949,0x6935,0x696c,0x6933,0x693d,0x6965,0x68f0,
0x6978,0x6934,0x6969,0x6940,0x696f,0x6944,0x6976,0x6958,
0x6941,0x6974,0x694c,0x693b,0x694b,0x6937,0x695c,0x694f,
0x6951,0x6932,0x6952,0x692f,0x697b,0x693c,0x6b46,0x6b45,
0x6b43,0x6b42,0x6b48,0x6b41,0x6b9b,0x6bfb,0x6bfc,0x6bf9,
0x6bf7,0x6bf8,0x6e9b,0x6ed6,0x6ec8,0x6e8f,0x6ec0,0x6e9f,
0x6e93,0x6e94,0x6ea0,0x6eb1,0x6eb9,0x6ec6,0x6ed2,0x6ebd,
0x6ec1,0x6e9e,0x6ec9,0x6eb7,0x6eb0,0x6ecd,0x6ea6,0x6ecf,
0x6eb2,0x6ebe,0x6ec3,0x6edc,0x6ed8,0x6e99,0x6e92,0x6e8e,
0x6e8d,0x6ea4,0x6ea1,0x6ebf,0x6eb3,0x6ed0,0x6eca,0x6e97,
0x6eae,0x6ea3,0x7147,0x7154,0x7152,0x7163,0x7160,0x7141,
0x715d,0x7162,0x7172,0x7178,0x716a,0x7161,0x7142,0x7158,
0x7143,0x714b,0x7170,0x715f,0x7150,0x7153,0x7144,0x714d,
0x715a,0x724f,0x728d,0x728c,0x7291,0x7290,0x728e,0x733c,
0x7342,0x733b,0x733a,0x7340,0x734a,0x7349,0x7444,0x744a,
0x744b,0x7452,0x7451,0x7457,0x7440,0x744f,0x7450,0x744e,
0x7442,0x7446,0x744d,0x7454,0x74e1,0x74ff,0x74fe,0x74fd,
0x751d,0x7579,0x7577,0x6983,0x75ef,0x760f,0x7603,0x75f7,
0x75fe,0x75fc,0x75f9,0x75f8,0x7610,0x75fb,0x75f6,0x75ed,
0x75f5,0x75fd,0x7699,0x76b5,0x76dd,0x7755,0x775f,0x7760,
0x7752,0x7756,0x775a,0x7769,0x7767,0x7754,0x7759,0x776d,
0x77e0,0x7887,0x789a,0x7894,0x788f,0x7884,0x7895,0x7885,
0x7886,0x78a1,0x7883,0x7879,0x7899,0x7880,0x7896,0x787b,
0x797c,0x7982,0x797d,0x7979,0x7a11,0x7a18,0x7a19,0x7a12,
0x7a17,0x7a15,0x7a22,0x7a13,0x7a1b,0x7a10,0x7aa3,0x7aa2,
0x7a9e,0x7aeb,0x7b66,0x7b64,0x7b6d,0x7b74,0x7b69,0x7b72,
0x7b65,0x7b73,0x7b71,0x7b70,0x7b61,0x7b78,0x7b76,0x7b63,
0x7cb2,0x7cb4,0x7caf,0x7d88,0x7d86,0x7d80,0x7d8d,0x7d7f,
0x7d85,0x7d7a,0x7d8e,0x7d7b,0x7d83,0x7d7c,0x7d8c,0x7d94,
0x7d84,0x7d7d,0x7d92,0x7f6d,0x7f6b,0x7f67,0x7f68,0x7f6c,
0x7fa6,0x7fa5,0x7fa7,0x7fdb,0x7fdc,0x8021,0x8164,0x8160,
0x8177,0x815c,0x8169,0x815b,0x8162,0x8172,0x6721,0x815e,
0x8176,0x8167,0x816f,0x8144,0x8161,0x821d,0x8249,0x8244,
0x8240,0x8242,0x8245,0x84f1,0x843f,0x8456,0x8476,0x8479,
0x848f,0x848d,0x8465,0x8451,0x8440,0x8486,0x8467,0x8430,
0x844d,0x847d,0x845a,0x8459,0x8474,0x8473,0x845d,0x8507,
0x845e,0x8437,0x843a,0x8434,0x847a,0x8443,0x8478,0x8432,
0x8445,0x8429,0x83d9,0x844b,0x842f,0x8442,0x842d,0x845f,
0x8470,0x8439,0x844e,0x844c,0x8452,0x846f,0x84c5,0x848e,
0x843b,0x8447,0x8436,0x8433,0x8468,0x847e,0x8444,0x842b,
0x8460,0x8454,0x846e,0x8450,0x870b,0x8704,0x86f7,0x870c,
0x86fa,0x86d6,0x86f5,0x874d,0x86f8,0x870e,0x8709,0x8701,
0x86f6,0x870d,0x8705,0x88d6,0x88cb,0x88cd,0x88ce,0x88de,
0x88db,0x88da,0x88cc,0x88d0,0x8985,0x899b,0x89df,0x89e5,
0x89e4,0x89e1,0x89e0,0x89e2,0x89dc,0x89e6,0x8a76,0x8a86,
0x8a7f,0x8a61,0x8a3f,0x8a77,0x8a82,0x8a84,0x8a75,0x8a83,
0x8a81,0x8a74,0x8a7a,0x8c3c,0x8c4b,0x8c4a,0x8c65,0x8c64,
0x8c66,0x8c86,0x8c84,0x8c85,0x8ccc,0x8d68,0x8d69,0x8d91,
0x8d8c,0x8d8e,0x8d8f,0x8d8d,0x8d93,0x8d94,0x8d90,0x8d92,
0x8df0,0x8de0,0x8dec,0x8df1,0x8dee,0x8dd0,0x8de9,0x8de3,
0x8de2,0x8de7,0x8df2,0x8deb,0x8df4,0x8f06,0x8eff,0x8f01,
0x8f00,0x8f05,0x8f07,0x8f08,0x8f02,0x8f0b,0x9052,0x903f,
0x9044,0x9049,0x903d,0x9110,0x910d,0x910f,0x9111,0x9116,
0x9114,0x910b,0x910e,0x916e,0x916f,0x9248,0x9252,0x9230,
0x923a,0x9266,0x9233,0x9265,0x925e,0x9283,0x922e,0x924a,
0x9246,0x926d,0x926c,0x924f,0x9260,0x9267,0x926f,0x9236,
0x9261,0x9270,0x9231,0x9254,0x9263,0x9250,0x9272,0x924e,
0x9253,0x924c,0x9256,0x9232,0x959f,0x959c,0x959e,0x959b,
0x9692,0x9693,0x9691,0x9697,0x96ce,0x96fa,0x96fd,0x96f8,
0x96f5,0x9773,0x9777,0x9778,0x9772,0x980f,0x980d,0x980e,
0x98ac,0x98f6,0x98f9,0x99af,0x99b2,0x99b0,0x99b5,0x9aad,
0x9aab,0x9b5b,0x9cea,0x9ced,0x9ce7,0x9e80,0x9efd,0x50e6,
0x50d4,0x50d7,0x50e8,0x50f3,0x50db,0x50ea,0x50dd,0x50e4,
0x50d3,0x50ec,0x50f0,0x50ef,0x50e3,0x50e0,0x51d8,0x5280,
0x5281,0x52e9,0x52eb,0x5330,0x53ac,0x5627,0x5615,0x560c,
0x5612,0x55fc,0x560f,0x561c,0x5601,0x5613,0x5602,0x55fa,
0x561d,0x5604,0x55ff,0x55f9,0x5889,0x587c,0x5890,0x5898,
0x5886,0x5881,0x587f,0x5874,0x588b,0x587a,0x5887,0x5891,
0x588e,0x5876,0x5882,0x5888,0x587b,0x5894,0x588f,0x58fe,
0x596b,0x5adc,0x5aee,0x5ae5,0x5ad5,0x5aea,0x5ada,0x5aed,
0x5aeb,0x5af3,0x5ae2,0x5ae0,0x5adb,0x5aec,0x5ade,0x5add,
0x5ad9,0x5ae8,0x5adf,0x5b77,0x5be0,0x5be3,0x5c63,0x5d82,
0x5d80,0x5d7d,0x5d86,0x5d7a,0x5d81,0x5d77,0x5d8a,0x5d89,
0x5d88,0x5d7e,0x5d7c,0x5d8d,0x5d79,0x5d7f,0x5e58,0x5e59,
0x5e53,0x5ed8,0x5ed1,0x5ed7,0x5ece,0x5edc,0x5ed5,0x5ed9,
0x5ed2,0x5ed4,0x5f44,0x5f43,0x5f6f,0x5fb6,0x612c,0x6128,
0x6141,0x615e,0x6171,0x6173,0x6152,0x6153,0x6172,0x616c,
0x6180,0x6174,0x6154,0x617a,0x615b,0x6165,0x613b,0x616a,
0x6161,0x6156,0x6229,0x6227,0x622b,0x642b,0x644d,0x645b,
0x645d,0x6474,0x6476,0x6472,0x6473,0x647d,0x6475,0x6466,
0x64a6,0x644e,0x6482,0x645e,0x645c,0x644b,0x6453,0x6460,
0x6450,0x647f,0x643f,0x646c,0x646b,0x6459,0x6465,0x6477,
0x6573,0x65a0,0x66a1,0x66a0,0x669f,0x6705,0x6704,0x6722,
0x69b1,0x69b6,0x69c9,0x69a0,0x69ce,0x6996,0x69b0,0x69ac,
0x69bc,0x6991,0x6999,0x698e,0x69a7,0x698d,0x69a9,0x69be,
0x69af,0x69bf,0x69c4,0x69bd,0x69a4,0x69d4,0x69b9,0x69ca,
0x699a,0x69cf,0x69b3,0x6993,0x69aa,0x69a1,0x699e,0x69d9,
0x6997,0x6990,0x69c2,0x69b5,0x69a5,0x69c6,0x6b4a,0x6b4d,
0x6b4b,0x6b9e,0x6b9f,0x6ba0,0x6bc3,0x6bc4,0x6bfe,0x6ece,
0x6ef5,0x6ef1,0x6f03,0x6f25,0x6ef8,0x6f37,0x6efb,0x6f2e,
0x6f09,0x6f4e,0x6f19,0x6f1a,0x6f27,0x6f18,0x6f3b,0x6f12,
0x6eed,0x6f0a,0x6f36,0x6f73,0x6ef9,0x6eee,0x6f2d,0x6f40,
0x6f30,0x6f3c,0x6f35,0x6eeb,0x6f07,0x6f0e,0x6f43,0x6f05,
0x6efd,0x6ef6,0x6f39,0x6f1c,0x6efc,0x6f3a,0x6f1f,0x6f0d,
0x6f1e,0x6f08,0x6f21,0x7187,0x7190,0x7189,0x7180,0x7185,
0x7182,0x718f,0x717b,0x7186,0x7181,0x7197,0x7244,0x7253,
0x7297,0x7295,0x7293,0x7343,0x734d,0x7351,0x734c,0x7462,
0x7473,0x7471,0x7475,0x7472,0x7467,0x746e,0x7500,0x7502,
0x7503,0x757d,0x7590,0x7616,0x7608,0x760c,0x7615,0x7611,
0x760a,0x7614,0x76b8,0x7781,0x777c,0x7785,0x7782,0x776e,
0x7780,0x776f,0x777e,0x7783,0x78b2,0x78aa,0x78b4,0x78ad,
0x78a8,0x787e,0x78ab,0x789e,0x78a5,0x78a0,0x78ac,0x78a2,
0x78a4,0x7998,0x798a,0x798b,0x7996,0x7995,0x7994,0x7993,
0x7997,0x7988,0x7992,0x7990,0x7a2b,0x7a4a,0x7a30,0x7a2f,
0x7a28,0x7a26,0x7aa8,0x7aab,0x7aac,0x7aee,0x7b88,0x7b9c,
0x7b8a,0x7b91,0x7b90,0x7b96,0x7b8d,0x7b8c,0x7b9b,0x7b8e,
0x7b85,0x7b98,0x5284,0x7b99,0x7ba4,0x7b82,0x7cbb,0x7cbf,
0x7cbc,0x7cba,0x7da7,0x7db7,0x7dc2,0x7da3,0x7daa,0x7dc1,
0x7dc0,0x7dc5,0x7d9d,0x7dce,0x7dc4,0x7dc6,0x7dcb,0x7dcc,
0x7daf,0x7db9,0x7d96,0x7dbc,0x7d9f,0x7da6,0x7dae,0x7da9,
0x7da1,0x7dc9,0x7f73,0x7fe2,0x7fe3,0x7fe5,0x7fde,0x8024,
0x805d,0x805c,0x8189,0x8186,0x8183,0x8187,0x818d,0x818c,
0x818b,0x8215,0x8497,0x84a4,0x84a1,0x849f,0x84ba,0x84ce,
0x84c2,0x84ac,0x84ae,0x84ab,0x84b9,0x84b4,0x84c1,0x84cd,
0x84aa,0x849a,0x84b1,0x84d0,0x849d,0x84a7,0x84bb,0x84a2,
0x8494,0x84c7,0x84cc,0x849b,0x84a9,0x84af,0x84a8,0x84d6,
0x8498,0x84b6,0x84cf,0x84a0,0x84d7,0x84d4,0x84d2,0x84db,
0x84b0,0x8491,0x8661,0x8733,0x8723,0x8728,0x876b,0x8740,
0x872e,0x871e,0x8721,0x8719,0x871b,0x8743,0x872c,0x8741,
0x873e,0x8746,0x8720,0x8732,0x872a,0x872d,0x873c,0x8712,
0x873a,0x8731,0x8735,0x8742,0x8726,0x8727,0x8738,0x8724,
0x871a,0x8730,0x8711,0x88f7,0x88e7,0x88f1,0x88f2,0x88fa,
0x88fe,0x88ee,0x88fc,0x88f6,0x88fb,0x88f0,0x88ec,0x88eb,
0x899d,0x89a1,0x899f,0x899e,0x89e9,0x89eb,0x89e8,0x8aab,
0x8a99,0x8a8b,0x8a92,0x8a8f,0x8a96,0x8c3d,0x8c68,0x8c69,
0x8cd5,0x8ccf,0x8cd7,0x8d96,0x8e09,0x8e02,0x8dff,0x8e0d,
0x8dfd,0x8e0a,0x8e03,0x8e07,0x8e06,0x8e05,0x8dfe,0x8e00,
0x8e04,0x8f10,0x8f11,0x8f0e,0x8f0d,0x9123,0x911c,0x9120,
0x9122,0x911f,0x911d,0x911a,0x9124,0x9121,0x911b,0x917a,
0x9172,0x9179,0x9173,0x92a5,0x92a4,0x9276,0x929b,0x927a,
0x92a0,0x9294,0x92aa,0x928d,0x92a6,0x929a,0x92ab,0x9279,
0x9297,0x927f,0x92a3,0x92ee,0x928e,0x9282,0x9295,0x92a2,
0x927d,0x9288,0x92a1,0x928a,0x9286,0x928c,0x9299,0x92a7,
0x927e,0x9287,0x92a9,0x929d,0x928b,0x922d,0x969e,0x96a1,
0x96ff,0x9758,0x977d,0x977a,0x977e,0x9783,0x9780,0x9782,
0x977b,0x9784,0x9781,0x977f,0x97ce,0x97cd,0x9816,0x98ad,
0x98ae,0x9902,0x9900,0x9907,0x999d,0x999c,0x99c3,0x99b9,
0x99bb,0x99ba,0x99c2,0x99bd,0x99c7,0x9ab1,0x9ae3,0x9ae7,
0x9b3e,0x9b3f,0x9b60,0x9b61,0x9b5f,0x9cf1,0x9cf2,0x9cf5,
0x9ea7,0x50ff,0x5103,0x5130,0x50f8,0x5106,0x5107,0x50f6,
0x50fe,0x510b,0x510c,0x50fd,0x510a,0x528b,0x528c,0x52f1,
0x52ef,0x5648,0x5642,0x564c,0x5635,0x5641,0x564a,0x5649,
0x5646,0x5658,0x565a,0x5640,0x5633,0x563d,0x562c,0x563e,
0x5638,0x562a,0x563a,0x571a,0x58ab,0x589d,0x58b1,0x58a0,
0x58a3,0x58af,0x58ac,0x58a5,0x58a1,0x58ff,0x5aff,0x5af4,
0x5afd,0x5af7,0x5af6,0x5b03,0x5af8,0x5b02,0x5af9,0x5b01,
0x5b07,0x5b05,0x5b0f,0x5c67,0x5d99,0x5d97,0x5d9f,0x5d92,
0x5da2,0x5d93,0x5d95,0x5da0,0x5d9c,0x5da1,0x5d9a,0x5d9e,
0x5e69,0x5e5d,0x5e60,0x5e5c,0x7df3,0x5edb,0x5ede,0x5ee1,
0x5f49,0x5fb2,0x618b,0x6183,0x6179,0x61b1,0x61b0,0x61a2,
0x6189,0x619b,0x6193,0x61af,0x61ad,0x619f,0x6192,0x61aa,
0x61a1,0x618d,0x6166,0x61b3,0x622d,0x646e,0x6470,0x6496,
0x64a0,0x6485,0x6497,0x649c,0x648f,0x648b,0x648a,0x648c,
0x64a3,0x649f,0x6468,0x64b1,0x6498,0x6576,0x657a,0x6579,
0x657b,0x65b2,0x65b3,0x66b5,0x66b0,0x66a9,0x66b2,0x66b7,
0x66aa,0x66af,0x6a00,0x6a06,0x6a17,0x69e5,0x69f8,0x6a15,
0x69f1,0x69e4,0x6a20,0x69ff,0x69ec,0x69e2,0x6a1b,0x6a1d,
0x69fe,0x6a27,0x69f2,0x69ee,0x6a14,0x69f7,0x69e7,0x6a40,
0x6a08,0x69e6,0x69fb,0x6a0d,0x69fc,0x69eb,0x6a09,0x6a04,
0x6a18,0x6a25,0x6a0f,0x69f6,0x6a26,0x6a07,0x69f4,0x6a16,
0x6b51,0x6ba5,0x6ba3,0x6ba2,0x6ba6,0x6c01,0x6c00,0x6bff,
0x6c02,0x6f41,0x6f26,0x6f7e,0x6f87,0x6fc6,0x6f92,0x6f8d,
0x6f89,0x6f8c,0x6f62,0x6f4f,0x6f85,0x6f5a,0x6f96,0x6f76,
0x6f6c,0x6f82,0x6f55,0x6f72,0x6f52,0x6f50,0x6f57,0x6f94,
0x6f93,0x6f5d,0x6f00,0x6f61,0x6f6b,0x6f7d,0x6f67,0x6f90,
0x6f53,0x6f8b,0x6f69,0x6f7f,0x6f95,0x6f63,0x6f77,0x6f6a,
0x6f7b,0x71b2,0x71af,0x719b,0x71b0,0x71a0,0x719a,0x71a9,
0x71b5,0x719d,0x71a5,0x719e,0x71a4,0x71a1,0x71aa,0x719c,
0x71a7,0x71b3,0x7298,0x729a,0x7358,0x7352,0x735e,0x735f,
0x7360,0x735d,0x735b,0x7361,0x735a,0x7359,0x7362,0x7487,
0x7489,0x748a,0x7486,0x7481,0x747d,0x7485,0x7488,0x747c,
0x7479,0x7508,0x7507,0x757e,0x7625,0x761e,0x7619,0x761d,
0x761c,0x7623,0x761a,0x7628,0x761b,0x769c,0x769d,0x769e,
0x769b,0x778d,0x778f,0x7789,0x7788,0x78cd,0x78bb,0x78cf,
0x78cc,0x78d1,0x78ce,0x78d4,0x78c8,0x78c3,0x78c4,0x78c9,
0x799a,0x79a1,0x79a0,0x799c,0x79a2,0x799b,0x6b76,0x7a39,
0x7ab2,0x7ab4,0x7ab3,0x7bb7,0x7bcb,0x7bbe,0x7bac,0x7bce,
0x7baf,0x7bb9,0x7bca,0x7bb5,0x7cc5,0x7cc8,0x7ccc,0x7ccb,
0x7df7,0x7ddb,0x7dea,0x7de7,0x7dd7,0x7de1,0x7e03,0x7dfa,
0x7de6,0x7df6,0x7df1,0x7df0,0x7dee,0x7ddf,0x7f76,0x7fac,
0x7fb0,0x7fad,0x7fed,0x7feb,0x7fea,0x7fec,0x7fe6,0x7fe8,
0x8064,0x8067,0x81a3,0x819f,0x819e,0x8195,0x81a2,0x8199,
0x8197,0x8216,0x824f,0x8253,0x8252,0x8250,0x824e,0x8251,
0x8524,0x853b,0x850f,0x8500,0x8529,0x850e,0x8509,0x850d,
0x851f,0x850a,0x8527,0x851c,0x84fb,0x852b,0x84fa,0x8508,
0x850c,0x84f4,0x852a,0x84f2,0x8515,0x84f7,0x84eb,0x84f3,
0x84fc,0x8512,0x84ea,0x84e9,0x8516,0x84fe,0x8528,0x851d,
0x852e,0x8502,0x84fd,0x851e,0x84f6,0x8531,0x8526,0x84e7,
0x84e8,0x84f0,0x84ef,0x84f9,0x8518,0x8520,0x8530,0x850b,
0x8519,0x852f,0x8662,0x8756,0x8763,0x8764,0x8777,0x87e1,
0x8773,0x8758,0x8754,0x875b,0x8752,0x8761,0x875a,0x8751,
0x875e,0x876d,0x876a,0x8750,0x874e,0x875f,0x875d,0x876f,
0x876c,0x877a,0x876e,0x875c,0x8765,0x874f,0x877b,0x8775,
0x8762,0x8767,0x8769,0x885a,0x8905,0x890c,0x8914,0x890b,
0x8917,0x8918,0x8919,0x8906,0x8916,0x8911,0x890e,0x8909,
0x89a2,0x89a4,0x89a3,0x89ed,0x89f0,0x89ec,0x8acf,0x8ac6,
0x8ab8,0x8ad3,0x8ad1,0x8ad4,0x8ad5,0x8abb,0x8ad7,0x8abe,
0x8ac0,0x8ac5,0x8ad8,0x8ac3,0x8aba,0x8abd,0x8ad9,0x8c3e,
0x8c4d,0x8c8f,0x8ce5,0x8cdf,0x8cd9,0x8ce8,0x8cda,0x8cdd,
0x8ce7,0x8da0,0x8d9c,0x8da1,0x8d9b,0x8e20,0x8e23,0x8e25,
0x8e24,0x8e2e,0x8e15,0x8e1b,0x8e16,0x8e11,0x8e19,0x8e26,
0x8e27,0x8e14,0x8e12,0x8e18,0x8e13,0x8e1c,0x8e17,0x8e1a,
0x8f2c,0x8f24,0x8f18,0x8f1a,0x8f20,0x8f23,0x8f16,0x8f17,
0x9073,0x9070,0x906f,0x9067,0x906b,0x912f,0x912b,0x9129,
0x912a,0x9132,0x9126,0x912e,0x9185,0x9186,0x918a,0x9181,
0x9182,0x9184,0x9180,0x92d0,0x92c3,0x92c4,0x92c0,0x92d9,
0x92b6,0x92cf,0x92f1,0x92df,0x92d8,0x92e9,0x92d7,0x92dd,
0x92cc,0x92ef,0x92c2,0x92e8,0x92ca,0x92c8,0x92ce,0x92e6,
0x92cd,0x92d5,0x92c9,0x92e0,0x92de,0x92e7,0x92d1,0x92d3,
0x92b5,0x92e1,0x9325,0x92c6,0x92b4,0x957c,0x95ac,0x95ab,
0x95ae,0x95b0,0x96a4,0x96a2,0x96d3,0x9705,0x9708,0x9702,
0x975a,0x978a,0x978e,0x9788,0x97d0,0x97cf,0x981e,0x981d,
0x9826,0x9829,0x9828,0x9820,0x981b,0x9827,0x98b2,0x9908,
0x98fa,0x9911,0x9914,0x9916,0x9917,0x9915,0x99dc,0x99cd,
0x99cf,0x99d3,0x99d4,0x99ce,0x99c9,0x99d6,0x99d8,0x99cb,
0x99d7,0x99cc,0x9ab3,0x9aec,0x9aeb,0x9af3,0x9af2,0x9af1,
0x9b46,0x9b43,0x9b67,0x9b74,0x9b71,0x9b66,0x9b76,0x9b75,
0x9b70,0x9b68,0x9b64,0x9b6c,0x9cfc,0x9cfa,0x9cfd,0x9cff,
0x9cf7,0x9d07,0x9d00,0x9cf9,0x9cfb,0x9d08,0x9d05,0x9d04,
0x9e83,0x9ed3,0x9f0f,0x9f10,0x511c,0x5113,0x5117,0x511a,
0x5111,0x51de,0x5334,0x53e1,0x5670,0x5660,0x566e,0x5673,
0x5666,0x5663,0x566d,0x5672,0x565e,0x5677,0x571c,0x571b,
0x58c8,0x58bd,0x58c9,0x58bf,0x58ba,0x58c2,0x58bc,0x58c6,
0x5b17,0x5b19,0x5b1b,0x5b21,0x5b14,0x5b13,0x5b10,0x5b16,
0x5b28,0x5b1a,0x5b20,0x5b1e,0x5bef,0x5dac,0x5db1,0x5da9,
0x5da7,0x5db5,0x5db0,0x5dae,0x5daa,0x5da8,0x5db2,0x5dad,
0x5daf,0x5db4,0x5e67,0x5e68,0x5e66,0x5e6f,0x5ee9,0x5ee7,
0x5ee6,0x5ee8,0x5ee5,0x5f4b,0x5fbc,0x5fbb,0x619d,0x61a8,
0x6196,0x61c5,0x61b4,0x61c6,0x61c1,0x61cc,0x61ba,0x61bf,
0x61b8,0x618c,0x64d7,0x64d6,0x64d0,0x64cf,0x64c9,0x64bd,
0x6489,0x64c3,0x64db,0x64f3,0x64d9,0x6533,0x657f,0x657c,
0x65a2,0x66c8,0x66be,0x66c0,0x66ca,0x66cb,0x66cf,0x66bd,
0x66bb,0x66ba,0x66cc,0x6723,0x6a34,0x6a66,0x6a49,0x6a67,
0x6a32,0x6a68,0x6a3e,0x6a5d,0x6a6d,0x6a76,0x6a5b,0x6a51,
0x6a28,0x6a5a,0x6a3b,0x6a3f,0x6a41,0x6a6a,0x6a64,0x6a50,
0x6a4f,0x6a54,0x6a6f,0x6a69,0x6a60,0x6a3c,0x6a5e,0x6a56,
0x6a55,0x6a4d,0x6a4e,0x6a46,0x6b55,0x6b54,0x6b56,0x6ba7,
0x6baa,0x6bab,0x6bc8,0x6bc7,0x6c04,0x6c03,0x6c06,0x6fad,
0x6fcb,0x6fa3,0x6fc7,0x6fbc,0x6fce,0x6fc8,0x6f5e,0x6fc4,
0x6fbd,0x6f9e,0x6fca,0x6fa8,0x7004,0x6fa5,0x6fae,0x6fba,
0x6fac,0x6faa,0x6fcf,0x6fbf,0x6fb8,0x6fa2,0x6fc9,0x6fab,
0x6fcd,0x6faf,0x6fb2,0x6fb0,0x71c5,0x71c2,0x71bf,0x71b8,
0x71d6,0x71c0,0x71c1,0x71cb,0x71d4,0x71ca,0x71c7,0x71cf,
0x71bd,0x71d8,0x71bc,0x71c6,0x71da,0x71db,0x729d,0x729e,
0x7369,0x7366,0x7367,0x736c,0x7365,0x736b,0x736a,0x747f,
0x749a,0x74a0,0x7494,0x7492,0x7495,0x74a1,0x750b,0x7580,
0x762f,0x762d,0x7631,0x763d,0x7633,0x763c,0x7635,0x7632,
0x7630,0x76bb,0x76e6,0x779a,0x779d,0x77a1,0x779c,0x779b,
0x77a2,0x77a3,0x7795,0x7799,0x7797,0x78dd,0x78e9,0x78e5,
0x78ea,0x78de,0x78e3,0x78db,0x78e1,0x78e2,0x78ed,0x78df,
0x78e0,0x79a4,0x7a44,0x7a48,0x7a47,0x7ab6,0x7ab8,0x7ab5,
0x7ab1,0x7ab7,0x7bde,0x7be3,0x7be7,0x7bdd,0x7bd5,0x7be5,
0x7bda,0x7be8,0x7bf9,0x7bd4,0x7bea,0x7be2,0x7bdc,0x7beb,
0x7bd8,0x7bdf,0x7cd2,0x7cd4,0x7cd7,0x7cd0,0x7cd1,0x7e12,
0x7e21,0x7e17,0x7e0c,0x7e1f,0x7e20,0x7e13,0x7e0e,0x7e1c,
0x7e15,0x7e1a,0x7e22,0x7e0b,0x7e0f,0x7e16,0x7e0d,0x7e14,
0x7e25,0x7e24,0x7f43,0x7f7b,0x7f7c,0x7f7a,0x7fb1,0x7fef,
0x802a,0x8029,0x806c,0x81b1,0x81a6,0x81ae,0x81b9,0x81b5,
0x81ab,0x81b0,0x81ac,0x81b4,0x81b2,0x81b7,0x81a7,0x81f2,
0x8255,0x8256,0x8257,0x8556,0x8545,0x856b,0x854d,0x8553,
0x8561,0x8558,0x8540,0x8546,0x8564,0x8541,0x8562,0x8544,
0x8551,0x8547,0x8563,0x853e,0x855b,0x8571,0x854e,0x856e,
0x8575,0x8555,0x8567,0x8560,0x858c,0x8566,0x855d,0x8554,
0x8565,0x856c,0x8663,0x8665,0x8664,0x87a4,0x879b,0x878f,
0x8797,0x8793,0x8792,0x8788,0x8781,0x8796,0x8798,0x8779,
0x8787,0x87a3,0x8785,0x8790,0x8791,0x879d,0x8784,0x8794,
0x879c,0x879a,0x8789,0x891e,0x8926,0x8930,0x892d,0x892e,
0x8927,0x8931,0x8922,0x8929,0x8923,0x892f,0x892c,0x891f,
0x89f1,0x8ae0,0x8ae2,0x8af2,0x8af4,0x8af5,0x8add,0x8b14,
0x8ae4,0x8adf,0x8af0,0x8ac8,0x8ade,0x8ae1,0x8ae8,0x8aff,
0x8aef,0x8afb,0x8c91,0x8c92,0x8c90,0x8cf5,0x8cee,0x8cf1,
0x8cf0,0x8cf3,0x8d6c,0x8d6e,0x8da5,0x8da7,0x8e33,0x8e3e,
0x8e38,0x8e40,0x8e45,0x8e36,0x8e3c,0x8e3d,0x8e41,0x8e30,
0x8e3f,0x8ebd,0x8f36,0x8f2e,0x8f35,0x8f32,0x8f39,0x8f37,
0x8f34,0x9076,0x9079,0x907b,0x9086,0x90fa,0x9133,0x9135,
0x9136,0x9193,0x9190,0x9191,0x918d,0x918f,0x9327,0x931e,
0x9308,0x931f,0x9306,0x930f,0x937a,0x9338,0x933c,0x931b,
0x9323,0x9312,0x9301,0x9346,0x932d,0x930e,0x930d,0x92cb,
0x931d,0x92fa,0x9313,0x92f9,0x92f7,0x9334,0x9302,0x9324,
0x92ff,0x9329,0x9339,0x9335,0x932a,0x9314,0x930c,0x930b,
0x92fe,0x9309,0x9300,0x92fb,0x9316,0x95bc,0x95cd,0x95be,
0x95b9,0x95ba,0x95b6,0x95bf,0x95b5,0x95bd,0x96a9,0x96d4,
0x970b,0x9712,0x9710,0x9799,0x9797,0x9794,0x97f0,0x97f8,
0x9835,0x982f,0x9832,0x9924,0x991f,0x9927,0x9929,0x999e,
0x99ee,0x99ec,0x99e5,0x99e4,0x99f0,0x99e3,0x99ea,0x99e9,
0x99e7,0x9ab9,0x9abf,0x9ab4,0x9abb,0x9af6,0x9afa,0x9af9,
0x9af7,0x9b33,0x9b80,0x9b85,0x9b87,0x9b7c,0x9b7e,0x9b7b,
0x9b82,0x9b93,0x9b92,0x9b90,0x9b7a,0x9b95,0x9b7d,0x9b88,
0x9d25,0x9d17,0x9d20,0x9d1e,0x9d14,0x9d29,0x9d1d,0x9d18,
0x9d22,0x9d10,0x9d19,0x9d1f,0x9e88,0x9e86,0x9e87,0x9eae,
0x9ead,0x9ed5,0x9ed6,0x9efa,0x9f12,0x9f3d,0x5126,0x5125,
0x5122,0x5124,0x5120,0x5129,0x52f4,0x5693,0x568c,0x568d,
0x5686,0x5684,0x5683,0x567e,0x5682,0x567f,0x5681,0x58d6,
0x58d4,0x58cf,0x58d2,0x5b2d,0x5b25,0x5b32,0x5b23,0x5b2c,
0x5b27,0x5b26,0x5b2f,0x5b2e,0x5b7b,0x5bf1,0x5bf2,0x5db7,
0x5e6c,0x5e6a,0x5fbe,0x61c3,0x61b5,0x61bc,0x61e7,0x61e0,
0x61e5,0x61e4,0x61e8,0x61de,0x64ef,0x64e9,0x64e3,0x64eb,
0x64e4,0x64e8,0x6581,0x6580,0x65b6,0x65da,0x66d2,0x6a8d,
0x6a96,0x6a81,0x6aa5,0x6a89,0x6a9f,0x6a9b,0x6aa1,0x6a9e,
0x6a87,0x6a93,0x6a8e,0x6a95,0x6a83,0x6aa8,0x6aa4,0x6a91,
0x6a7f,0x6aa6,0x6a9a,0x6a85,0x6a8c,0x6a92,0x6b5b,0x6bad,
0x6c09,0x6fcc,0x6fa9,0x6ff4,0x6fd4,0x6fe3,0x6fdc,0x6fed,
0x6fe7,0x6fe6,0x6fde,0x6ff2,0x6fdd,0x6fe2,0x6fe8,0x71e1,
0x71f1,0x71e8,0x71f2,0x71e4,0x71f0,0x71e2,0x7373,0x736e,
0x736f,0x7497,0x74b2,0x74ab,0x7490,0x74aa,0x74ad,0x74b1,
0x74a5,0x74af,0x7510,0x7511,0x7512,0x750f,0x7584,0x7643,
0x7648,0x7649,0x7647,0x76a4,0x76e9,0x77b5,0x77ab,0x77b2,
0x77b7,0x77b6,0x77b4,0x77b1,0x77a8,0x77f0,0x78f3,0x78fd,
0x7902,0x78fb,0x78fc,0x78ff,0x78f2,0x7905,0x78f9,0x78fe,
0x7904,0x79ab,0x79a8,0x7a5c,0x7a5b,0x7a56,0x7a58,0x7a54,
0x7a5a,0x7abe,0x7ac0,0x7ac1,0x7c05,0x7c0f,0x7bf2,0x7c00,
0x7bff,0x7bfb,0x7c0e,0x7bf4,0x7c0b,0x7bf3,0x7c02,0x7c09,
0x7c03,0x7c01,0x7bf8,0x7bfd,0x7c06,0x7bf0,0x7bf1,0x7c10,
0x7c0a,0x7ce8,0x7e2d,0x7e3c,0x7e42,0x7e33,0x9848,0x7e38,
0x7e2a,0x7e49,0x7e40,0x7e47,0x7e29,0x7e4c,0x7e30,0x7e3b,
0x7e36,0x7e44,0x7e3a,0x7f45,0x7f7f,0x7f7e,0x7f7d,0x7ff4,
0x7ff2,0x802c,0x81bb,0x81c4,0x81cc,0x81ca,0x81c5,0x81c7,
0x81bc,0x81e9,0x825b,0x825a,0x825c,0x8583,0x8580,0x858f,
0x85a7,0x8595,0x85a0,0x858b,0x85a3,0x857b,0x85a4,0x859a,
0x859e,0x8577,0x857c,0x8589,0x85a1,0x857a,0x8578,0x8557,
0x858e,0x8596,0x8586,0x858d,0x8599,0x859d,0x8581,0x85a2,
0x8582,0x8588,0x8585,0x8579,0x8576,0x8598,0x8590,0x859f,
0x8668,0x87be,0x87aa,0x87ad,0x87c5,0x87b0,0x87ac,0x87b9,
0x87b5,0x87bc,0x87ae,0x87c9,0x87c3,0x87c2,0x87cc,0x87b7,
0x87af,0x87c4,0x87ca,0x87b4,0x87b6,0x87bf,0x87b8,0x87bd,
0x87de,0x87b2,0x8935,0x8933,0x893c,0x893e,0x8941,0x8952,
0x8937,0x8942,0x89ad,0x89af,0x89ae,0x89f2,0x89f3,0x8b1e,
0x8b18,0x8b16,0x8b11,0x8b05,0x8b0b,0x8b22,0x8b0f,0x8b12,
0x8b15,0x8b07,0x8b0d,0x8b08,0x8b06,0x8b1c,0x8b13,0x8b1a,
0x8c4f,0x8c70,0x8c72,0x8c71,0x8c6f,0x8c95,0x8c94,0x8cf9,
0x8d6f,0x8e4e,0x8e4d,0x8e53,0x8e50,0x8e4c,0x8e47,0x8f43,
0x8f40,0x9085,0x907e,0x9138,0x919a,0x91a2,0x919b,0x9199,
0x919f,0x91a1,0x919d,0x91a0,0x93a1,0x9383,0x93af,0x9364,
0x9356,0x9347,0x937c,0x9358,0x935c,0x9376,0x9349,0x9350,
0x9351,0x9360,0x936d,0x938f,0x934c,0x936a,0x9379,0x9357,
0x9355,0x9352,0x934f,0x9371,0x9377,0x937b,0x9361,0x935e,
0x9363,0x9367,0x934e,0x9359,0x95c7,0x95c0,0x95c9,0x95c3,
0x95c5,0x95b7,0x96ae,0x96b0,0x96ac,0x9720,0x971f,0x9718,
0x971d,0x9719,0x979a,0x97a1,0x979c,0x979e,0x979d,0x97d5,
0x97d4,0x97f1,0x9841,0x9844,0x984a,0x9849,0x9845,0x9843,
0x9925,0x992b,0x992c,0x992a,0x9933,0x9932,0x992f,0x992d,
0x9931,0x9930,0x9998,0x99a3,0x99a1,0x9a02,0x99fa,0x99f4,
0x99f7,0x99f9,0x99f8,0x99f6,0x99fb,0x99fd,0x99fe,0x99fc,
0x9a03,0x9abe,0x9afe,0x9afd,0x9b01,0x9afc,0x9b48,0x9b9a,
0x9ba8,0x9b9e,0x9b9b,0x9ba6,0x9ba1,0x9ba5,0x9ba4,0x9b86,
0x9ba2,0x9ba0,0x9baf,0x9d33,0x9d41,0x9d67,0x9d36,0x9d2e,
0x9d2f,0x9d31,0x9d38,0x9d30,0x9d45,0x9d42,0x9d43,0x9d3e,
0x9d37,0x9d40,0x9d3d,0x7ff5,0x9d2d,0x9e8a,0x9e89,0x9e8d,
0x9eb0,0x9ec8,0x9eda,0x9efb,0x9eff,0x9f24,0x9f23,0x9f22,
0x9f54,0x9fa0,0x5131,0x512d,0x512e,0x5698,0x569c,0x5697,
0x569a,0x569d,0x5699,0x5970,0x5b3c,0x5c69,0x5c6a,0x5dc0,
0x5e6d,0x5e6e,0x61d8,0x61df,0x61ed,0x61ee,0x61f1,0x61ea,
0x61f0,0x61eb,0x61d6,0x61e9,0x64ff,0x6504,0x64fd,0x64f8,
0x6501,0x6503,0x64fc,0x6594,0x65db,0x66da,0x66db,0x66d8,
0x6ac5,0x6ab9,0x6abd,0x6ae1,0x6ac6,0x6aba,0x6ab6,0x6ab7,
0x6ac7,0x6ab4,0x6aad,0x6b5e,0x6bc9,0x6c0b,0x7007,0x700c,
0x700d,0x7001,0x7005,0x7014,0x700e,0x6fff,0x7000,0x6ffb,
0x7026,0x6ffc,0x6ff7,0x700a,0x7201,0x71ff,0x71f9,0x7203,
0x71fd,0x7376,0x74b8,0x74c0,0x74b5,0x74c1,0x74be,0x74b6,
0x74bb,0x74c2,0x7514,0x7513,0x765c,0x7664,0x7659,0x7650,
0x7653,0x7657,0x765a,0x76a6,0x76bd,0x76ec,0x77c2,0x77ba,
0x790c,0x7913,0x7914,0x7909,0x7910,0x7912,0x7911,0x79ad,
0x79ac,0x7a5f,0x7c1c,0x7c29,0x7c19,0x7c20,0x7c1f,0x7c2d,
0x7c1d,0x7c26,0x7c28,0x7c22,0x7c25,0x7c30,0x7e5c,0x7e50,
0x7e56,0x7e63,0x7e58,0x7e62,0x7e5f,0x7e51,0x7e60,0x7e57,
0x7e53,0x7fb5,0x7fb3,0x7ff7,0x7ff8,0x8075,0x81d1,0x81d2,
0x81d0,0x825f,0x825e,0x85b4,0x85c6,0x85c0,0x85c3,0x85c2,
0x85b3,0x85b5,0x85bd,0x85c7,0x85c4,0x85bf,0x85cb,0x85ce,
0x85c8,0x85c5,0x85b1,0x85b6,0x85d2,0x8624,0x85b8,0x85b7,
0x85be,0x8669,0x87e7,0x87e6,0x87e2,0x87db,0x87eb,0x87ea,
0x87e5,0x87df,0x87f3,0x87e4,0x87d4,0x87dc,0x87d3,0x87ed,
0x87d8,0x87e3,0x87d7,0x87d9,0x8801,0x87f4,0x87e8,0x87dd,
0x8953,0x894b,0x894f,0x894c,0x8946,0x8950,0x8951,0x8949,
0x8b2a,0x8b27,0x8b23,0x8b33,0x8b30,0x8b35,0x8b47,0x8b2f,
0x8b3c,0x8b3e,0x8b31,0x8b25,0x8b37,0x8b26,0x8b36,0x8b2e,
0x8b24,0x8b3b,0x8b3d,0x8b3a,0x8c42,0x8c75,0x8c99,0x8c98,
0x8c97,0x8cfe,0x8d04,0x8d02,0x8d00,0x8e5c,0x8e62,0x8e60,
0x8e57,0x8e56,0x8e5e,0x8e65,0x8e67,0x8e5b,0x8e5a,0x8e61,
0x8e5d,0x8e69,0x8e54,0x8f46,0x8f47,0x8f48,0x8f4b,0x9128,
0x913a,0x913b,0x913e,0x91a8,0x91a5,0x91a7,0x91af,0x91aa,
0x93b5,0x938c,0x9392,0x93b7,0x939b,0x939d,0x9389,0x93a7,
0x938e,0x93aa,0x939e,0x93a6,0x9395,0x9388,0x9399,0x939f,
0x9380,0x938d,0x93b1,0x9391,0x93b2,0x93a4,0x93a8,0x93b4,
0x93a3,0x95d2,0x95d3,0x95d1,0x96b3,0x96d7,0x96da,0x5dc2,
0x96df,0x96d8,0x96dd,0x9723,0x9722,0x9725,0x97ac,0x97ae,
0x97a8,0x97ab,0x97a4,0x97aa,0x97a2,0x97a5,0x97d7,0x97d9,
0x97d6,0x97d8,0x97fa,0x9850,0x9851,0x9852,0x98b8,0x9941,
0x993c,0x993a,0x9a0f,0x9a0b,0x9a09,0x9a0d,0x9a04,0x9a11,
0x9a0a,0x9a05,0x9a07,0x9a06,0x9ac0,0x9adc,0x9b08,0x9b04,
0x9b05,0x9b29,0x9b35,0x9b4a,0x9b4c,0x9b4b,0x9bc7,0x9bc6,
0x9bc3,0x9bbf,0x9bc1,0x9bb5,0x9bb8,0x9bd3,0x9bb6,0x9bc4,
0x9bb9,0x9bbd,0x9d5c,0x9d53,0x9d4f,0x9d4a,0x9d5b,0x9d4b,
0x9d59,0x9d56,0x9d4c,0x9d57,0x9d52,0x9d54,0x9d5f,0x9d58,
0x9d5a,0x9e8e,0x9e8c,0x9edf,0x9f01,0x9f00,0x9f16,0x9f25,
0x9f2b,0x9f2a,0x9f29,0x9f28,0x9f4c,0x9f55,0x5134,0x5135,
0x5296,0x52f7,0x53b4,0x56ab,0x56ad,0x56a6,0x56a7,0x56aa,
0x56ac,0x58da,0x58dd,0x58db,0x5912,0x5b3d,0x5b3e,0x5b3f,
0x5dc3,0x5e70,0x5fbf,0x61fb,0x6507,0x6510,0x650d,0x6509,
0x650c,0x650e,0x6584,0x65de,0x65dd,0x66de,0x6ae7,0x6ae0,
0x6acc,0x6ad1,0x6ad9,0x6acb,0x6adf,0x6adc,0x6ad0,0x6aeb,
0x6acf,0x6acd,0x6ade,0x6b60,0x6bb0,0x6c0c,0x7019,0x7027,
0x7020,0x7016,0x702b,0x7021,0x7022,0x7023,0x7029,0x7017,
0x7024,0x701c,0x720c,0x720a,0x7207,0x7202,0x7205,0x72a5,
0x72a6,0x72a4,0x72a3,0x72a1,0x74cb,0x74c5,0x74b7,0x74c3,
0x7516,0x7660,0x77c9,0x77ca,0x77c4,0x77f1,0x791d,0x791b,
0x7921,0x791c,0x7917,0x791e,0x79b0,0x7a67,0x7a68,0x7c33,
0x7c3c,0x7c39,0x7c2c,0x7c3b,0x7cec,0x7cea,0x7e76,0x7e75,
0x7e78,0x7e70,0x7e77,0x7e6f,0x7e7a,0x7e72,0x7e74,0x7e68,
0x7f4b,0x7f4a,0x7f83,0x7f86,0x7fb7,0x7ffd,0x7ffe,0x8078,
0x81d7,0x81d5,0x820b,0x8264,0x8261,0x8263,0x85eb,0x85f1,
0x85ed,0x85d9,0x85e1,0x85e8,0x85da,0x85d7,0x85ec,0x85f2,
0x85f8,0x85d8,0x85df,0x85e3,0x85dc,0x85d1,0x85f0,0x85e6,
0x85ef,0x85de,0x85e2,0x8800,0x87fa,0x8803,0x87f6,0x87f7,
0x8809,0x880c,0x880b,0x8806,0x87fc,0x8808,0x87ff,0x880a,
0x8802,0x8962,0x895a,0x895b,0x8957,0x8961,0x895c,0x8958,
0x895d,0x8959,0x8988,0x89b7,0x89b6,0x89f6,0x8b50,0x8b48,
0x8b4a,0x8b40,0x8b53,0x8b56,0x8b54,0x8b4b,0x8b55,0x8b51,
0x8b42,0x8b52,0x8b57,0x8c43,0x8c77,0x8c76,0x8c9a,0x8d06,
0x8d07,0x8d09,0x8dac,0x8daa,0x8dad,0x8dab,0x8e6d,0x8e78,
0x8e73,0x8e6a,0x8e6f,0x8e7b,0x8ec2,0x8f52,0x8f51,0x8f4f,
0x8f50,0x8f53,0x8fb4,0x9140,0x913f,0x91b0,0x91ad,0x93de,
0x93c7,0x93cf,0x93c2,0x93da,0x93d0,0x93f9,0x93ec,0x93cc,
0x93d9,0x93a9,0x93e6,0x93ca,0x93d4,0x93ee,0x93e3,0x93d5,
0x93c4,0x93ce,0x93c0,0x93d2,0x93a5,0x93e7,0x957d,0x95da,
0x95db,0x96e1,0x9729,0x972b,0x972c,0x9728,0x9726,0x97b3,
0x97b7,0x97b6,0x97dd,0x97de,0x97df,0x985c,0x9859,0x985d,
0x9857,0x98bf,0x98bd,0x98bb,0x98be,0x9948,0x9947,0x9943,
0x99a6,0x99a7,0x9a1a,0x9a15,0x9a25,0x9a1d,0x9a24,0x9a1b,
0x9a22,0x9a20,0x9a27,0x9a23,0x9a1e,0x9a1c,0x9a14,0x9ac2,
0x9b0b,0x9b0a,0x9b0e,0x9b0c,0x9b37,0x9bea,0x9beb,0x9be0,
0x9bde,0x9be4,0x9be6,0x9be2,0x9bf0,0x9bd4,0x9bd7,0x9bec,
0x9bdc,0x9bd9,0x9be5,0x9bd5,0x9be1,0x9bda,0x9d77,0x9d81,
0x9d8a,0x9d84,0x9d88,0x9d71,0x9d80,0x9d78,0x9d86,0x9d8b,
0x9d8c,0x9d7d,0x9d6b,0x9d74,0x9d75,0x9d70,0x9d69,0x9d85,
0x9d73,0x9d7b,0x9d82,0x9d6f,0x9d79,0x9d7f,0x9d87,0x9d68,
0x9e94,0x9e91,0x9ec0,0x9efc,0x9f2d,0x9f40,0x9f41,0x9f4d,
0x9f56,0x9f57,0x9f58,0x5337,0x56b2,0x56b5,0x56b3,0x58e3,
0x5b45,0x5dc6,0x5dc7,0x5eee,0x5eef,0x5fc0,0x5fc1,0x61f9,
0x6517,0x6516,0x6515,0x6513,0x65df,0x66e8,0x66e3,0x66e4,
0x6af3,0x6af0,0x6aea,0x6ae8,0x6af9,0x6af1,0x6aee,0x6aef,
0x703c,0x7035,0x702f,0x7037,0x7034,0x7031,0x7042,0x7038,
0x703f,0x703a,0x7039,0x702a,0x7040,0x703b,0x7033,0x7041,
0x7213,0x7214,0x72a8,0x737d,0x737c,0x74ba,0x76ab,0x76aa,
0x76be,0x76ed,0x77cc,0x77ce,0x77cf,0x77cd,0x77f2,0x7925,
0x7923,0x7927,0x7928,0x7924,0x7929,0x79b2,0x7a6e,0x7a6c,
0x7a6d,0x7af7,0x7c49,0x7c48,0x7c4a,0x7c47,0x7c45,0x7cee,
0x7e7b,0x7e7e,0x7e81,0x7e80,0x7fba,0x7fff,0x8079,0x81db,
0x81d9,0x8268,0x8269,0x8622,0x85ff,0x8601,0x85fe,0x861b,
0x8600,0x85f6,0x8604,0x8609,0x8605,0x860c,0x85fd,0x8819,
0x8810,0x8811,0x8817,0x8813,0x8816,0x8963,0x8966,0x89b9,
0x89f7,0x8b60,0x8b6a,0x8b5d,0x8b68,0x8b63,0x8b65,0x8b67,
0x8b6d,0x8dae,0x8e86,0x8e88,0x8e84,0x8f59,0x8f56,0x8f57,
0x8f55,0x8f58,0x8f5a,0x908d,0x9143,0x9141,0x91b7,0x91b5,
0x91b2,0x91b3,0x940b,0x9413,0x93fb,0x9420,0x940f,0x9414,
0x93fe,0x9415,0x9410,0x9428,0x9419,0x940d,0x93f5,0x9400,
0x93f7,0x9407,0x940e,0x9416,0x9412,0x93fa,0x9409,0x93f8,
0x943c,0x940a,0x93ff,0x93fc,0x940c,0x93f6,0x9411,0x9406,
0x95de,0x95e0,0x95df,0x972e,0x972f,0x97b9,0x97bb,0x97fd,
0x97fe,0x9860,0x9862,0x9863,0x985f,0x98c1,0x98c2,0x9950,
0x994e,0x9959,0x994c,0x994b,0x9953,0x9a32,0x9a34,0x9a31,
0x9a2c,0x9a2a,0x9a36,0x9a29,0x9a2e,0x9a38,0x9a2d,0x9ac7,
0x9aca,0x9ac6,0x9b10,0x9b12,0x9b11,0x9c0b,0x9c08,0x9bf7,
0x9c05,0x9c12,0x9bf8,0x9c40,0x9c07,0x9c0e,0x9c06,0x9c17,
0x9c14,0x9c09,0x9d9f,0x9d99,0x9da4,0x9d9d,0x9d92,0x9d98,
0x9d90,0x9d9b,0x9da0,0x9d94,0x9d9c,0x9daa,0x9d97,0x9da1,
0x9d9a,0x9da2,0x9da8,0x9d9e,0x9da3,0x9dbf,0x9da9,0x9d96,
0x9da6,0x9da7,0x9e99,0x9e9b,0x9e9a,0x9ee5,0x9ee4,0x9ee7,
0x9ee6,0x9f30,0x9f2e,0x9f5b,0x9f60,0x9f5e,0x9f5d,0x9f59,
0x9f91,0x513a,0x5139,0x5298,0x5297,0x56c3,0x56bd,0x56be,
0x5b48,0x5b47,0x5dcb,0x5dcf,0x5ef1,0x61fd,0x651b,0x6b02,
0x6afc,0x6b03,0x6af8,0x6b00,0x7043,0x7044,0x704a,0x7048,
0x7049,0x7045,0x7046,0x721d,0x721a,0x7219,0x737e,0x7517,
0x766a,0x77d0,0x792d,0x7931,0x792f,0x7c54,0x7c53,0x7cf2,
0x7e8a,0x7e87,0x7e88,0x7e8b,0x7e86,0x7e8d,0x7f4d,0x7fbb,
0x8030,0x81dd,0x8618,0x862a,0x8626,0x861f,0x8623,0x861c,
0x8619,0x8627,0x862e,0x8621,0x8620,0x8629,0x861e,0x8625,
0x8829,0x881d,0x881b,0x8820,0x8824,0x881c,0x882b,0x884a,
0x896d,0x8969,0x896e,0x896b,0x89fa,0x8b79,0x8b78,0x8b45,
0x8b7a,0x8b7b,0x8d10,0x8d14,0x8daf,0x8e8e,0x8e8c,0x8f5e,
0x8f5b,0x8f5d,0x9146,0x9144,0x9145,0x91b9,0x943f,0x943b,
0x9436,0x9429,0x943d,0x9430,0x9439,0x942a,0x9437,0x942c,
0x9440,0x9431,0x95e5,0x95e4,0x95e3,0x9735,0x973a,0x97bf,
0x97e1,0x9864,0x98c9,0x98c6,0x98c0,0x9958,0x9956,0x9a39,
0x9a3d,0x9a46,0x9a44,0x9a42,0x9a41,0x9a3a,0x9a3f,0x9acd,
0x9b15,0x9b17,0x9b18,0x9b16,0x9b3a,0x9b52,0x9c2b,0x9c1d,
0x9c1c,0x9c2c,0x9c23,0x9c28,0x9c29,0x9c24,0x9c21,0x9db7,
0x9db6,0x9dbc,0x9dc1,0x9dc7,0x9dca,0x9dcf,0x9dbe,0x9dc5,
0x9dc3,0x9dbb,0x9db5,0x9dce,0x9db9,0x9dba,0x9dac,0x9dc8,
0x9db1,0x9dad,0x9dcc,0x9db3,0x9dcd,0x9db2,0x9e7a,0x9e9c,
0x9eeb,0x9eee,0x9eed,0x9f1b,0x9f18,0x9f1a,0x9f31,0x9f4e,
0x9f65,0x9f64,0x9f92,0x4eb9,0x56c6,0x56c5,0x56cb,0x5971,
0x5b4b,0x5b4c,0x5dd5,0x5dd1,0x5ef2,0x6521,0x6520,0x6526,
0x6522,0x6b0b,0x6b08,0x6b09,0x6c0d,0x7055,0x7056,0x7057,
0x7052,0x721e,0x721f,0x72a9,0x737f,0x74d8,0x74d5,0x74d9,
0x74d7,0x766d,0x76ad,0x7935,0x79b4,0x7a70,0x7a71,0x7c57,
0x7c5c,0x7c59,0x7c5b,0x7c5a,0x7cf4,0x7cf1,0x7e91,0x7f4f,
0x7f87,0x81de,0x826b,0x8634,0x8635,0x8633,0x862c,0x8632,
0x8636,0x882c,0x8828,0x8826,0x882a,0x8825,0x8971,0x89bf,
0x89be,0x89fb,0x8b7e,0x8b84,0x8b82,0x8b86,0x8b85,0x8b7f,
0x8d15,0x8e95,0x8e94,0x8e9a,0x8e92,0x8e90,0x8e96,0x8e97,
0x8f60,0x8f62,0x9147,0x944c,0x9450,0x944a,0x944b,0x944f,
0x9447,0x9445,0x9448,0x9449,0x9446,0x973f,0x97e3,0x986a,
0x9869,0x98cb,0x9954,0x995b,0x9a4e,0x9a53,0x9a54,0x9a4c,
0x9a4f,0x9a48,0x9a4a,0x9a49,0x9a52,0x9a50,0x9ad0,0x9b19,
0x9b2b,0x9b3b,0x9b56,0x9b55,0x9c46,0x9c48,0x9c3f,0x9c44,
0x9c39,0x9c33,0x9c41,0x9c3c,0x9c37,0x9c34,0x9c32,0x9c3d,
0x9c36,0x9ddb,0x9dd2,0x9dde,0x9dda,0x9dcb,0x9dd0,0x9ddc,
0x9dd1,0x9ddf,0x9de9,0x9dd9,0x9dd8,0x9dd6,0x9df5,0x9dd5,
0x9ddd,0x9eb6,0x9ef0,0x9f35,0x9f33,0x9f32,0x9f42,0x9f6b,
0x9f95,0x9fa2,0x513d,0x5299,0x58e8,0x58e7,0x5972,0x5b4d,
0x5dd8,0x882f,0x5f4f,0x6201,0x6203,0x6204,0x6529,0x6525,
0x6596,0x66eb,0x6b11,0x6b12,0x6b0f,0x6bca,0x705b,0x705a,
0x7222,0x7382,0x7381,0x7383,0x7670,0x77d4,0x7c67,0x7c66,
0x7e95,0x826c,0x863a,0x8640,0x8639,0x863c,0x8631,0x863b,
0x863e,0x8830,0x8832,0x882e,0x8833,0x8976,0x8974,0x8973,
0x89fe,0x8b8c,0x8b8e,0x8b8b,0x8b88,0x8c45,0x8d19,0x8e98,
0x8f64,0x8f63,0x91bc,0x9462,0x9455,0x945d,0x9457,0x945e,
0x97c4,0x97c5,0x9800,0x9a56,0x9a59,0x9b1e,0x9b1f,0x9b20,
0x9c52,0x9c58,0x9c50,0x9c4a,0x9c4d,0x9c4b,0x9c55,0x9c59,
0x9c4c,0x9c4e,0x9dfb,0x9df7,0x9def,0x9de3,0x9deb,0x9df8,
0x9de4,0x9df6,0x9de1,0x9dee,0x9de6,0x9df2,0x9df0,0x9de2,
0x9dec,0x9df4,0x9df3,0x9de8,0x9ded,0x9ec2,0x9ed0,0x9ef2,
0x9ef3,0x9f06,0x9f1c,0x9f38,0x9f37,0x9f36,0x9f43,0x9f4f,
0x9f71,0x9f70,0x9f6e,0x9f6f,0x56d3,0x56cd,0x5b4e,0x5c6d,
0x652d,0x66ed,0x66ee,0x6b13,0x705f,0x7061,0x705d,0x7060,
0x7223,0x74db,0x74e5,0x77d5,0x7938,0x79b7,0x79b6,0x7c6a,
0x7e97,0x7f89,0x826d,0x8643,0x8838,0x8837,0x8835,0x884b,
0x8b94,0x8b95,0x8e9e,0x8e9f,0x8ea0,0x8e9d,0x91be,0x91bd,
0x91c2,0x946b,0x9468,0x9469,0x96e5,0x9746,0x9743,0x9747,
0x97c7,0x97e5,0x9a5e,0x9ad5,0x9b59,0x9c63,0x9c67,0x9c66,
0x9c62,0x9c5e,0x9c60,0x9e02,0x9dfe,0x9e07,0x9e03,0x9e06,
0x9e05,0x9e00,0x9e01,0x9e09,0x9dff,0x9dfd,0x9e04,0x9ea0,
0x9f1e,0x9f46,0x9f74,0x9f75,0x9f76,0x56d4,0x652e,0x65b8,
0x6b18,0x6b19,0x6b17,0x6b1a,0x7062,0x7226,0x72aa,0x77d8,
0x77d9,0x7939,0x7c69,0x7c6b,0x7cf6,0x7e9a,0x7e98,0x7e9b,
0x7e99,0x81e0,0x81e1,0x8646,0x8647,0x8648,0x8979,0x897a,
0x897c,0x897b,0x89ff,0x8b98,0x8b99,0x8ea5,0x8ea4,0x8ea3,
0x946e,0x946d,0x946f,0x9471,0x9473,0x9749,0x9872,0x995f,
0x9c68,0x9c6e,0x9c6d,0x9e0b,0x9e0d,0x9e10,0x9e0f,0x9e12,
0x9e11,0x9ea1,0x9ef5,0x9f09,0x9f47,0x9f78,0x9f7b,0x9f7a,
0x9f79,0x571e,0x7066,0x7c6f,0x883c,0x8db2,0x8ea6,0x91c3,
0x9474,0x9478,0x9476,0x9475,0x9a60,0x9b2e,0x9c74,0x9c73,
0x9c71,0x9c75,0x9e14,0x9e13,0x9ef6,0x9f0a,0x9fa4,0x7068,
0x7065,0x7cf7,0x866a,0x883e,0x883d,0x883f,0x8b9e,0x8c9c,
0x8ea9,0x8ec9,0x974b,0x9873,0x9874,0x98cc,0x9961,0x99ab,
0x9a64,0x9a66,0x9a67,0x9b24,0x9e15,0x9e17,0x9f48,0x6207,
0x6b1e,0x7227,0x864c,0x8ea8,0x9482,0x9480,0x9481,0x9a69,
0x9a68,0x9e19,0x864b,0x8b9f,0x9483,0x9c79,0x9eb7,0x7675,
0x9a6b,0x9c7a,0x9e1d,0x7069,0x706a,0x7229,0x9ea4,0x9f7e,
0x9f49,0x9f98};

static const int cns11643_2_ucs_table_size = (sizeof (cns11643_2_ucs_table) / sizeof (unsigned short));

static const unsigned short cns11643_14_ucs_table[] = {
0x4e28,0x4e36,0x4e3f,0x4e85,0x4e05,0x4e04,0x5182,0x5196,
0x5338,0x5369,0x53b6,0x4e2a,0x4e87,0x4e49,0x51e2,0x4e46,
0x4e8f,0x4ebc,0x4ebe,0x5166,0x51e3,0x5204,0x529c,0x0000,
0x5902,0x590a,0x5b80,0x5ddb,0x5e7a,0x5e7f,0x5ef4,0x5f50,
0x5f51,0x5f61,0x961d,0x0000,0x4e63,0x4e62,0x4ea3,0x5185,
0x4ec5,0x4ecf,0x4ece,0x4ecc,0x5184,0x5186,0x0000,0x0000,
0x51e4,0x5205,0x529e,0x529d,0x52fd,0x5300,0x533a,0x0000,
0x5346,0x535d,0x5386,0x53b7,0x0000,0x53cc,0x0000,0x53ce,
0x5721,0x0000,0x5e00,0x5f0c,0x6237,0x6238,0x6534,0x6535,
0x65e0,0x0000,0x738d,0x4e97,0x4ee0,0x0000,0x0000,0x4ee7,
0x0000,0x4ee6,0x0000,0x0000,0x0000,0x0000,0x56d8,0x518b,
0x518c,0x5199,0x51e5,0x0000,0x520b,0x0000,0x0000,0x5304,
0x5303,0x5307,0x0000,0x531e,0x535f,0x536d,0x5389,0x53ba,
0x53d0,0x0000,0x53f6,0x53f7,0x53f9,0x0000,0x53f4,0x0000,
0x0000,0x5724,0x5904,0x5918,0x5932,0x5930,0x5934,0x0000,
0x5975,0x0000,0x5b82,0x5bf9,0x5c14,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x5e81,0x5e83,0x5f0d,0x5f52,
0x0000,0x5fca,0x5fc7,0x6239,0x0000,0x624f,0x65e7,0x672f,
0x6b7a,0x6c39,0x0000,0x0000,0x6c37,0x6c44,0x6c45,0x738c,
0x7592,0x7676,0x9093,0x9092,0x0000,0x0000,0x4e21,0x4e20,
0x4e22,0x4e68,0x4e89,0x4e98,0x4ef9,0x4eef,0x0000,0x0000,
0x4ef8,0x4f06,0x4f03,0x4efc,0x4eee,0x4f16,0x0000,0x4f28,
0x4f1c,0x4f07,0x4f1a,0x4efa,0x4f17,0x514a,0x0000,0x5172,
0x0000,0x51b4,0x51b3,0x51b2,0x0000,0x51e8,0x0000,0x5214,
0x520f,0x5215,0x5218,0x52a8,0x0000,0x534b,0x534f,0x0000,
0x5350,0x0000,0x538b,0x0000,0x53be,0x0000,0x53d2,0x5416,
0x53ff,0x0000,0x5400,0x0000,0x5405,0x5413,0x5415,0x0000,
0x0000,0x56e3,0x5735,0x5736,0x5731,0x5732,0x58ee,0x5905,
0x4e54,0x0000,0x5936,0x0000,0x0000,0x0000,0x597a,0x0000,
0x5986,0x0000,0x0000,0x5b86,0x5f53,0x5c18,0x0000,0x5c3d,
0x5c78,0x0000,0x0000,0x0000,0x0000,0x5c80,0x0000,0x5e08,
0x0000,0x0000,0x0000,0x0000,0x5ef5,0x5f0e,0x0000,0x0000,
0x0000,0x5fd3,0x5fda,0x0000,0x5fdb,0x0000,0x620f,0x625d,
0x625f,0x6267,0x6257,0x9f50,0x0000,0x65eb,0x65ea,0x0000,
0x6737,0x0000,0x6732,0x6736,0x6b22,0x6bce,0x0000,0x6c58,
0x6c51,0x6c77,0x6c3c,0x0000,0x6c5a,0x0000,0x6c53,0x706f,
0x7072,0x706e,0x0000,0x0000,0x7073,0x72b1,0x72b2,0x0000,
0x738f,0x0000,0x0000,0x0000,0x793c,0x0000,0x808d,0x808e,
0x0000,0x827b,0x0000,0x8d71,0x8fb9,0x9096,0x909a,0x0000,
0x4e24,0x4e71,0x0000,0x4e9c,0x4f45,0x4f4a,0x4f39,0x4f37,
0x0000,0x4f32,0x4f42,0x0000,0x4f44,0x4f4b,0x0000,0x4f40,
0x4f35,0x4f31,0x5151,0x0000,0x5150,0x514e,0x0000,0x0000,
0x519d,0x0000,0x51b5,0x51b8,0x51ec,0x5223,0x5227,0x5226,
0x521f,0x522b,0x5220,0x52b4,0x52b3,0x0000,0x5325,0x533b,
0x5374,0x0000,0x0000,0x0000,0x0000,0x0000,0x544d,0x0000,
0x0000,0x543a,0x0000,0x0000,0x5444,0x544c,0x5423,0x541a,
0x5432,0x544b,0x5421,0x0000,0x5434,0x5449,0x5450,0x5422,
0x543f,0x5451,0x545a,0x542f,0x0000,0x56e9,0x56f2,0x56f3,
0x56ef,0x56ed,0x56ec,0x56e6,0x5748,0x0000,0x5744,0x573f,
0x573c,0x5753,0x5756,0x0000,0x575f,0x5743,0x5758,0x5757,
0x0000,0x0000,0x0000,0x5746,0x0000,0x573d,0x0000,0x5742,
0x5754,0x5755,0x58f1,0x58f2,0x58f0,0x590b,0x9ea6,0x56f1,
0x593d,0x0000,0x5994,0x598c,0x0000,0x599c,0x0000,0x0000,
0x599f,0x0000,0x599b,0x0000,0x5989,0x599a,0x0000,0x6588,
0x0000,0x5b8d,0x0000,0x5bfe,0x5bff,0x5bfd,0x5c2b,0x0000,
0x5c84,0x5c8e,0x5c9c,0x0000,0x0000,0x5c85,0x5df5,0x5e09,
0x0000,0x0000,0x5e0b,0x0000,0x5e92,0x5e90,0x5f03,0x0000,
0x5f1e,0x5f63,0x0000,0x5fe7,0x5ffe,0x5fe6,0x5fdc,0x5fce,
0x0000,0x5ffc,0x5fdf,0x5fec,0x5ff6,0x0000,0x5ff2,0x5ff0,
0x5ff9,0x0000,0x6213,0x0000,0x0000,0x623b,0x623c,0x6282,
0x0000,0x0000,0x0000,0x6278,0x628b,0x0000,0x629e,0x62a5,
0x629b,0x629c,0x6299,0x628d,0x6285,0x629d,0x6275,0x0000,
0x0000,0x0000,0x65f6,0x0000,0x0000,0x0000,0x66f5,0x675b,
0x0000,0x6754,0x6752,0x0000,0x6758,0x6744,0x674a,0x6761,
0x0000,0x6c7f,0x6c91,0x6c9e,0x0000,0x6c6e,0x6c7c,0x6c9f,
0x6c75,0x0000,0x6c56,0x6ca2,0x6c79,0x0000,0x6ca1,0x0000,
0x6caa,0x6ca0,0x0000,0x7079,0x7077,0x707e,0x0000,0x7075,
0x707b,0x7264,0x0000,0x72bb,0x72bc,0x72c7,0x72b9,0x72be,
0x72b6,0x0000,0x0000,0x7398,0x0000,0x0000,0x0000,0x0000,
0x7593,0x7680,0x0000,0x7683,0x76c0,0x76c1,0x0000,0x0000,
0x77f4,0x77f5,0x0000,0x7acc,0x7acd,0x7cfa,0x809f,0x8091,
0x8097,0x8094,0x0000,0x8286,0x828c,0x0000,0x8295,0x0000,
0x866c,0x0000,0x8fb5,0x8fbe,0x8fc7,0x0000,0x8fc1,0x90a9,
0x90a4,0x0000,0x0000,0x0000,0x90a8,0x9627,0x9626,0x962b,
0x9633,0x9634,0x9629,0x4e3d,0x0000,0x4e9d,0x4f93,0x4f8a,
0x0000,0x0000,0x4f6d,0x4f8e,0x4fa0,0x4fa2,0x4fa1,0x4f9f,
0x4fa3,0x0000,0x4f72,0x0000,0x4f8c,0x5156,0x0000,0x0000,
0x5190,0x0000,0x0000,0x0000,0x51ed,0x51fe,0x522f,0x0000,
0x523c,0x5234,0x5239,0x52b9,0x52b5,0x52bf,0x5355,0x0000,
0x5376,0x537a,0x5393,0x0000,0x53c1,0x53c2,0x53d5,0x5485,
0x0000,0x545f,0x5493,0x5489,0x5479,0x9efe,0x548f,0x5469,
0x546d,0x0000,0x5494,0x546a,0x548a,0x0000,0x56fd,0x56fb,
0x56f8,0x0000,0x56fc,0x56f6,0x5765,0x5781,0x5763,0x5767,
0x0000,0x576e,0x5778,0x577f,0x0000,0x0000,0x58f3,0x594b,
0x594c,0x0000,0x0000,0x0000,0x59ad,0x0000,0x59c4,0x0000,
0x59c2,0x59b0,0x0000,0x0000,0x0000,0x0000,0x59bf,0x0000,
0x59c9,0x59b8,0x59ac,0x0000,0x0000,0x0000,0x59b7,0x59d7,
0x0000,0x5b60,0x0000,0x5b96,0x5b9e,0x5b94,0x5b9f,0x5b9d,
0x0000,0x5c00,0x5c19,0x0000,0x0000,0x5c49,0x5c4a,0x0000,
0x5cbb,0x5cc1,0x0000,0x0000,0x0000,0x5cb9,0x5c9e,0x5cb4,
0x5cba,0x5df6,0x5e13,0x5e12,0x5e77,0x0000,0x5e98,0x0000,
0x5e99,0x5e9d,0x5ef8,0x0000,0x5ef9,0x0000,0x5f06,0x5f21,
0x0000,0x5f25,0x5f55,0x0000,0x0000,0x0000,0x5f84,0x5f83,
0x6030,0x6007,0x0000,0x6036,0x0000,0x0000,0x0000,0x5fe9,
0x603d,0x6008,0x0000,0x0000,0x62ba,0x62b2,0x0000,0x62b7,
0x62e4,0x62a7,0x0000,0x0000,0x0000,0x62d5,0x62e1,0x62dd,
0x62a6,0x62c1,0x62c5,0x62c0,0x62df,0x62e0,0x62de,0x0000,
0x6589,0x0000,0x65a6,0x65ba,0x0000,0x65ff,0x0000,0x6617,
0x6618,0x6601,0x65fe,0x0000,0x670c,0x0000,0x676b,0x6796,
0x6782,0x678a,0x0000,0x67a3,0x0000,0x67a2,0x678f,0x0000,
0x67f9,0x6780,0x6b26,0x6b27,0x6b68,0x6b69,0x0000,0x6b81,
0x6bb4,0x6bd1,0x0000,0x0000,0x6c1c,0x0000,0x0000,0x0000,
0x0000,0x0000,0x6c97,0x6c6c,0x6cdf,0x0000,0x6cea,0x0000,
0x6ce4,0x6cd8,0x6cb2,0x6cce,0x6cc8,0x0000,0x708b,0x7088,
0x7090,0x708f,0x0000,0x7087,0x7089,0x708d,0x7081,0x0000,
0x708c,0x0000,0x0000,0x7240,0x0000,0x0000,0x7265,0x7266,
0x7268,0x0000,0x0000,0x72cd,0x72d3,0x72db,0x0000,0x72cf,
0x73a7,0x73a3,0x739e,0x0000,0x73af,0x0000,0x0000,0x73aa,
0x739c,0x0000,0x7542,0x7544,0x753b,0x7541,0x0000,0x759b,
0x759e,0x0000,0x79c4,0x79c3,0x79c6,0x0000,0x0000,0x79c7,
0x0000,0x79ca,0x0000,0x0000,0x7acf,0x7c76,0x7c74,0x7cff,
0x7cfc,0x0000,0x0000,0x7f59,0x80a8,0x0000,0x0000,0x80b0,
0x0000,0x80b3,0x0000,0x80a4,0x80b6,0x80a7,0x80ac,0x0000,
0x80a6,0x5367,0x820e,0x82c4,0x833e,0x829c,0x0000,0x0000,
0x0000,0x0000,0x0000,0x82aa,0x0000,0x82c9,0x0000,0x0000,
0x82a6,0x82b2,0x0000,0x0000,0x0000,0x8fcc,0x8fd9,0x8fca,
0x8fd8,0x8fcf,0x90b7,0x0000,0x90ad,0x90b9,0x9637,0x0000,
0x9641,0x963e,0x96b6,0x9751,0x9763,0x4e57,0x4e79,0x4eb2,
0x4eb0,0x4eaf,0x4eb1,0x4fd2,0x4fd5,0x0000,0x4fbe,0x4fb8,
0x4fb0,0x4fb1,0x4fc8,0x0000,0x0000,0x4fc6,0x4fcc,0x4fe5,
0x4fe3,0x4fb4,0x516a,0x0000,0x519f,0x0000,0x51c1,0x0000,
0x51c2,0x51c3,0x5245,0x5248,0x0000,0x0000,0x524f,0x0000,
0x0000,0x52c5,0x52ca,0x52c4,0x5327,0x5358,0x537d,0x0000,
0x53dd,0x53dc,0x53da,0x53d9,0x54b9,0x0000,0x54d0,0x54b4,
0x54ca,0x0000,0x54a3,0x54da,0x54a4,0x0000,0x54b2,0x549e,
0x549f,0x54b5,0x0000,0x0000,0x54cd,0x0000,0x54cc,0x0000,
0x5700,0x57ac,0x5791,0x578e,0x578d,0x5792,0x57a1,0x5790,
0x57a6,0x57a8,0x0000,0x579c,0x5796,0x57a7,0x0000,0x0000,
0x0000,0x0000,0x58f5,0x0000,0x5909,0x5908,0x0000,0x5952,
0x0000,0x0000,0x59df,0x0000,0x59eb,0x59ef,0x59f0,0x59d5,
0x5a0d,0x5a04,0x59f9,0x5a02,0x59f8,0x59e2,0x59d9,0x59e7,
0x5b6a,0x0000,0x0000,0x5bab,0x0000,0x5c1b,0x5c2f,0x0000,
0x663c,0x0000,0x0000,0x0000,0x5cd1,0x5cdc,0x5ce6,0x5ce1,
0x5ccd,0x0000,0x5ce2,0x5cdd,0x5ce5,0x5dfb,0x5dfa,0x5e1e,
0x0000,0x5ea1,0x0000,0x0000,0x5efc,0x5efb,0x5f2f,0x0000,
0x0000,0x5f66,0x0000,0x0000,0x0000,0x605c,0x0000,0x604e,
0x6051,0x0000,0x0000,0x6023,0x6031,0x607c,0x6052,0x0000,
0x6060,0x604a,0x6061,0x0000,0x6218,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x631f,0x6317,0x62ea,0x6321,
0x6304,0x6305,0x0000,0x6531,0x6544,0x6540,0x0000,0x6542,
0x65be,0x0000,0x6629,0x661b,0x0000,0x6623,0x662c,0x661a,
0x6630,0x663b,0x661e,0x6637,0x6638,0x0000,0x670e,0x0000,
0x0000,0x67e8,0x67d6,0x0000,0x67c7,0x67bc,0x6852,0x67bf,
0x67d5,0x67fe,0x8363,0x67fb,0x0000,0x67b1,0x6801,0x6805,
0x6800,0x67d7,0x0000,0x6b2a,0x6b6b,0x0000,0x0000,0x0000,
0x0000,0x6be1,0x0000,0x0000,0x6d23,0x6cff,0x6d14,0x6d05,
0x6d13,0x6d06,0x6d21,0x0000,0x6d15,0x6caf,0x6cf4,0x6d02,
0x6d45,0x0000,0x6d26,0x0000,0x6d44,0x0000,0x6d24,0x70a5,
0x0000,0x70a3,0x0000,0x70a2,0x70bb,0x70a0,0x70aa,0x0000,
0x0000,0x70a8,0x70b6,0x70b2,0x70a7,0x0000,0x0000,0x70b9,
0x722e,0x0000,0x723c,0x0000,0x726d,0x0000,0x0000,0x72e7,
0x72ed,0x0000,0x72ec,0x72e5,0x72e2,0x0000,0x73c4,0x73bd,
0x73cf,0x73c9,0x73c1,0x73d0,0x0000,0x73ce,0x74ed,0x74eb,
0x0000,0x74ef,0x7549,0x7550,0x7546,0x754a,0x0000,0x754d,
0x75a6,0x0000,0x0000,0x0000,0x75a8,0x0000,0x0000,0x76c7,
0x76ff,0x0000,0x76fd,0x77e6,0x780a,0x0000,0x7804,0x780b,
0x7807,0x0000,0x7815,0x7808,0x0000,0x79d3,0x79d4,0x79d0,
0x79d7,0x7a7c,0x0000,0x0000,0x7a7d,0x7a83,0x7a82,0x0000,
0x7ad4,0x7ad5,0x7ad3,0x7ad0,0x7ad2,0x7afe,0x7afc,0x7c77,
0x7c7c,0x7c7b,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x7f8f,0x80d3,0x0000,0x80cb,0x80d2,0x0000,
0x8109,0x80e2,0x80df,0x80c6,0x0000,0x8224,0x82f7,0x82d8,
0x82dd,0x0000,0x0000,0x82f8,0x82fc,0x0000,0x0000,0x82e9,
0x0000,0x82ee,0x0000,0x82d0,0x830e,0x82e2,0x830b,0x82fd,
0x5179,0x8676,0x0000,0x8678,0x0000,0x0000,0x8675,0x867d,
0x0000,0x8842,0x8866,0x0000,0x898c,0x8a05,0x0000,0x8a06,
0x0000,0x8c9f,0x0000,0x8ff1,0x8fe7,0x8fe9,0x8fef,0x90c2,
0x90bc,0x0000,0x90c6,0x90c0,0x0000,0x0000,0x90cd,0x90c9,
0x0000,0x90c4,0x0000,0x9581,0x0000,0x9cec,0x5032,0x4ff9,
0x501d,0x4fff,0x5004,0x4ff0,0x5003,0x0000,0x5002,0x4ffc,
0x4ff2,0x5024,0x5008,0x5036,0x502e,0x0000,0x5010,0x5038,
0x5039,0x4ffd,0x5056,0x4ffb,0x51a3,0x51a6,0x51a1,0x0000,
0x0000,0x51c7,0x51c9,0x5260,0x5264,0x5259,0x5265,0x5267,
0x5257,0x5263,0x0000,0x5253,0x0000,0x52cf,0x0000,0x52ce,
0x52d0,0x52d1,0x52cc,0x0000,0x0000,0x0000,0x550d,0x54f4,
0x0000,0x5513,0x54ef,0x54f5,0x54f9,0x5502,0x5500,0x0000,
0x0000,0x5518,0x54f0,0x54f6,0x0000,0x0000,0x5519,0x0000,
0x5705,0x57c9,0x0000,0x57b7,0x57cd,0x0000,0x0000,0x0000,
0x57be,0x57bb,0x0000,0x57db,0x57c8,0x57c4,0x57c5,0x57d1,
0x57ca,0x57c0,0x0000,0x0000,0x5a21,0x5a2a,0x0000,0x5a1d,
0x0000,0x5a0b,0x0000,0x0000,0x0000,0x0000,0x5a22,0x0000,
0x0000,0x5a24,0x0000,0x5a14,0x5a31,0x0000,0x5a2f,0x5a1a,
0x5a12,0x0000,0x0000,0x5a26,0x0000,0x0000,0x5bbc,0x5bbb,
0x5bb7,0x5c05,0x5c06,0x5c52,0x5c53,0x0000,0x0000,0x5cfa,
0x5ceb,0x0000,0x5cf3,0x5cf5,0x5ce9,0x5cef,0x0000,0x5e2a,
0x5e30,0x5e2e,0x5e2c,0x5e2f,0x5eaf,0x5ea9,0x0000,0x5efd,
0x5f32,0x5f8e,0x5f93,0x5f8f,0x604f,0x6099,0x0000,0x607e,
0x0000,0x6074,0x604b,0x6073,0x6075,0x0000,0x0000,0x6056,
0x60a9,0x608b,0x60a6,0x0000,0x6093,0x60ae,0x609e,0x60a7,
0x6245,0x0000,0x0000,0x632e,0x0000,0x6352,0x6330,0x635b,
0x0000,0x6319,0x631b,0x0000,0x6331,0x635d,0x6337,0x6335,
0x6353,0x0000,0x635c,0x633f,0x654b,0x0000,0x0000,0x658b,
0x0000,0x659a,0x6650,0x6646,0x664e,0x6640,0x0000,0x664b,
0x6648,0x0000,0x6660,0x6644,0x664d,0x0000,0x6837,0x6824,
0x0000,0x0000,0x681b,0x6836,0x0000,0x682c,0x6819,0x6856,
0x6847,0x683e,0x681e,0x0000,0x6815,0x6822,0x6827,0x6859,
0x6858,0x6855,0x6830,0x6823,0x6b2e,0x6b2b,0x6b30,0x6b6c,
0x0000,0x6b8b,0x0000,0x6be9,0x6bea,0x6be5,0x6d6b,0x0000,
0x0000,0x6d73,0x6d57,0x0000,0x0000,0x6d5d,0x6d56,0x6d8f,
0x6d5b,0x6d1c,0x6d9a,0x6d9b,0x6d99,0x0000,0x6d81,0x6d71,
0x0000,0x0000,0x6d72,0x6d5c,0x6d96,0x70c4,0x70db,0x70cc,
0x70d0,0x70e3,0x70df,0x0000,0x70d6,0x70ee,0x70d5,0x0000,
0x0000,0x0000,0x0000,0x727a,0x0000,0x72f5,0x7302,0x0000,
0x0000,0x73e2,0x73ec,0x73d5,0x73f9,0x73df,0x73e6,0x0000,
0x0000,0x0000,0x0000,0x73e4,0x73e1,0x74f3,0x0000,0x0000,
0x0000,0x0000,0x7556,0x7555,0x7558,0x7557,0x755e,0x75c3,
0x0000,0x0000,0x75b4,0x0000,0x75b1,0x0000,0x0000,0x76cb,
0x76cc,0x772a,0x0000,0x7716,0x770f,0x0000,0x0000,0x773f,
0x772b,0x770e,0x7724,0x0000,0x7721,0x7718,0x77dd,0x0000,
0x0000,0x7824,0x7836,0x0000,0x7958,0x7959,0x0000,0x7962,
0x79da,0x79d9,0x0000,0x79e1,0x79e5,0x79e8,0x79db,0x0000,
0x79e2,0x79f0,0x0000,0x0000,0x0000,0x0000,0x7ada,0x7add,
0x0000,0x7adb,0x7adc,0x0000,0x0000,0x7b0d,0x7b0b,0x7b14,
0x7c8e,0x7c86,0x0000,0x7c87,0x7c83,0x7c8b,0x0000,0x0000,
0x0000,0x0000,0x7d24,0x0000,0x0000,0x0000,0x7d25,0x7f62,
0x7f93,0x7f99,0x7f97,0x0000,0x0000,0x7fc4,0x7fc6,0x800a,
0x0000,0x0000,0x8040,0x803c,0x803b,0x80f6,0x80ff,0x80ee,
0x8104,0x8103,0x8107,0x0000,0x0000,0x80f7,0x0000,0x0000,
0x822d,0x0000,0x8227,0x8229,0x831f,0x8357,0x0000,0x0000,
0x0000,0x0000,0x8321,0x0000,0x0000,0x8318,0x8358,0x0000,
0x0000,0x0000,0x0000,0x0000,0x8684,0x869f,0x869b,0x8689,
0x86a6,0x8692,0x868f,0x86a0,0x884f,0x8878,0x887a,0x886e,
0x887b,0x8884,0x8873,0x0000,0x0000,0x8a0d,0x8a0b,0x8a19,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8ff9,0x9009,
0x9008,0x0000,0x90de,0x9151,0x0000,0x0000,0x91db,0x91df,
0x91de,0x91d6,0x91e0,0x9585,0x9660,0x9659,0x0000,0x9656,
0x0000,0x0000,0x96bd,0x0000,0x0000,0x5042,0x5059,0x0000,
0x5044,0x5066,0x5052,0x5054,0x5071,0x5050,0x507b,0x507c,
0x5058,0x0000,0x0000,0x5079,0x506c,0x5078,0x51a8,0x51d1,
0x51cf,0x5268,0x5276,0x52d4,0x0000,0x53a0,0x53c4,0x0000,
0x5558,0x554c,0x5568,0x0000,0x5549,0x0000,0x0000,0x555d,
0x5529,0x0000,0x5554,0x5553,0x0000,0x555a,0x0000,0x553a,
0x553f,0x552b,0x57ea,0x0000,0x57ef,0x0000,0x0000,0x57dd,
0x57fe,0x0000,0x57de,0x57e6,0x0000,0x57e8,0x57ff,0x5803,
0x58f7,0x68a6,0x591f,0x0000,0x595b,0x595d,0x595e,0x0000,
0x0000,0x5a2b,0x0000,0x5a3b,0x0000,0x0000,0x5a61,0x5a3a,
0x5a6e,0x5a4b,0x5a6b,0x0000,0x0000,0x5a45,0x5a4e,0x5a68,
0x5a3d,0x5a71,0x5a3f,0x5a6f,0x5a75,0x0000,0x5a73,0x5a2c,
0x5a59,0x5a54,0x5a4f,0x5a63,0x0000,0x0000,0x5bc8,0x0000,
0x5bc3,0x0000,0x5c5b,0x5c61,0x0000,0x5d21,0x5d0a,0x5d09,
0x0000,0x5d2c,0x5d08,0x0000,0x0000,0x5d2a,0x5d15,0x0000,
0x5d10,0x5d13,0x0000,0x5d2f,0x5d18,0x0000,0x5de3,0x5e39,
0x5e35,0x5e3a,0x5e32,0x0000,0x0000,0x0000,0x0000,0x5ebb,
0x5eba,0x5f34,0x5f39,0x0000,0x0000,0x0000,0x0000,0x6098,
0x0000,0x60d0,0x0000,0x0000,0x0000,0x60d7,0x60aa,0x0000,
0x60a1,0x60a4,0x0000,0x60ee,0x0000,0x60e7,0x0000,0x0000,
0x60de,0x0000,0x0000,0x637e,0x638b,0x0000,0x0000,0x6379,
0x6386,0x6393,0x0000,0x6373,0x636a,0x0000,0x636c,0x0000,
0x637f,0x0000,0x63b2,0x63ba,0x0000,0x0000,0x6366,0x6374,
0x0000,0x655a,0x0000,0x654e,0x654d,0x658d,0x658e,0x65ad,
0x0000,0x65c7,0x65ca,0x0000,0x65c9,0x0000,0x65e3,0x6657,
0x0000,0x6663,0x6667,0x671a,0x6719,0x6716,0x0000,0x0000,
0x689e,0x68b6,0x6898,0x6873,0x0000,0x689a,0x688e,0x68b7,
0x68db,0x68a5,0x686c,0x68c1,0x6884,0x0000,0x0000,0x6895,
0x687a,0x6899,0x0000,0x68b8,0x68b9,0x6870,0x0000,0x6b35,
0x0000,0x6b90,0x6bbb,0x6bed,0x0000,0x0000,0x0000,0x6dc1,
0x6dc3,0x6dce,0x0000,0x0000,0x6dad,0x6e04,0x0000,0x6db9,
0x0000,0x6de7,0x0000,0x6e08,0x6e06,0x0000,0x6e0a,0x6db0,
0x0000,0x6df8,0x6e0c,0x0000,0x6db1,0x0000,0x6e02,0x6e07,
0x6e09,0x6e01,0x6e17,0x6dff,0x6e12,0x0000,0x0000,0x7103,
0x7107,0x7101,0x70f5,0x70f1,0x7108,0x70f2,0x710f,0x0000,
0x70fe,0x0000,0x0000,0x0000,0x731a,0x7310,0x730e,0x7402,
0x73f3,0x0000,0x0000,0x73fb,0x0000,0x0000,0x0000,0x751b,
0x7523,0x7561,0x7568,0x0000,0x7567,0x75d3,0x0000,0x0000,
0x7690,0x0000,0x0000,0x76d5,0x76d7,0x76d6,0x7730,0x0000,
0x7726,0x0000,0x7740,0x0000,0x771e,0x0000,0x0000,0x0000,
0x7847,0x0000,0x784b,0x7851,0x784f,0x7842,0x7846,0x0000,
0x796e,0x796c,0x79f2,0x0000,0x79f1,0x79f5,0x79f3,0x79f9,
0x0000,0x0000,0x0000,0x7a9a,0x7a93,0x7a91,0x7ae1,0x0000,
0x0000,0x7b21,0x7b1c,0x7b16,0x7b17,0x7b36,0x7b1f,0x0000,
0x7c93,0x7c99,0x7c9a,0x7c9c,0x0000,0x7d49,0x0000,0x7d34,
0x7d37,0x0000,0x7d2d,0x0000,0x7d4c,0x0000,0x0000,0x7d48,
0x0000,0x0000,0x7f3b,0x0000,0x0000,0x0000,0x0000,0x8008,
0x801a,0x0000,0x801d,0x0000,0x8049,0x8045,0x8044,0x7c9b,
0x0000,0x0000,0x812a,0x812e,0x0000,0x0000,0x8131,0x0000,
0x811a,0x8134,0x8117,0x0000,0x0000,0x0000,0x831d,0x8371,
0x8384,0x8380,0x8372,0x83a1,0x0000,0x8379,0x8391,0x0000,
0x839f,0x83ad,0x0000,0x0000,0x8323,0x0000,0x8385,0x839c,
0x83b7,0x8658,0x865a,0x0000,0x8657,0x86b2,0x0000,0x86ae,
0x0000,0x0000,0x0000,0x8845,0x889c,0x8894,0x88a3,0x888f,
0x88a5,0x88a9,0x88a6,0x888a,0x88a0,0x8890,0x8992,0x8991,
0x8994,0x0000,0x8a26,0x8a32,0x8a28,0x0000,0x0000,0x8a1c,
0x0000,0x8a2b,0x8a20,0x0000,0x8a29,0x0000,0x0000,0x0000,
0x8a21,0x8c3a,0x0000,0x8c5b,0x8c58,0x8c7c,0x0000,0x8ca6,
0x8cae,0x8cad,0x8d65,0x0000,0x8d7e,0x0000,0x8d7c,0x8d7f,
0x8d7a,0x8dbd,0x0000,0x0000,0x8dc0,0x8dbb,0x8ead,0x8eaf,
0x8ed6,0x0000,0x0000,0x0000,0x0000,0x0000,0x8ed9,0x0000,
0x0000,0x9012,0x900e,0x9025,0x0000,0x9013,0x90ee,0x0000,
0x90ab,0x90f7,0x0000,0x9159,0x9154,0x91f2,0x91f0,0x91e5,
0x91f6,0x0000,0x0000,0x9587,0x0000,0x965a,0x0000,0x0000,
0x966e,0x0000,0x0000,0x0000,0x9679,0x0000,0x98e1,0x98e6,
0x0000,0x9ec4,0x9ed2,0x4e80,0x0000,0x4e81,0x508f,0x5097,
0x5088,0x5089,0x0000,0x0000,0x5081,0x5160,0x0000,0x0000,
0x5e42,0x51d3,0x0000,0x0000,0x51d2,0x51d6,0x5273,0x0000,
0x5270,0x0000,0x0000,0x0000,0x53a8,0x53a6,0x53c5,0x5597,
0x55de,0x0000,0x0000,0x5596,0x55b4,0x0000,0x5585,0x0000,
0x559b,0x55a0,0x0000,0x5559,0x0000,0x5586,0x0000,0x0000,
0x55af,0x557a,0x0000,0x0000,0x0000,0x559e,0x0000,0x55a9,
0x570f,0x570e,0x581a,0x0000,0x581f,0x0000,0x583c,0x5818,
0x583e,0x5826,0x0000,0x583a,0x0000,0x5822,0x0000,0x58fb,
0x5963,0x5964,0x0000,0x5aa8,0x5aa3,0x5a82,0x5a88,0x5aa1,
0x5a85,0x5a98,0x0000,0x5a99,0x0000,0x5a89,0x5a81,0x5a96,
0x5a80,0x0000,0x0000,0x5a91,0x0000,0x0000,0x0000,0x0000,
0x5acf,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x5a87,
0x5aa0,0x0000,0x5a79,0x0000,0x5a86,0x5aab,0x5aaa,0x5aa4,
0x5a8d,0x5a7e,0x0000,0x5bd5,0x0000,0x0000,0x0000,0x5c1e,
0x5c5f,0x5c5e,0x5d44,0x5d3e,0x0000,0x5d48,0x5d1c,0x0000,
0x5d5b,0x5d4d,0x0000,0x0000,0x5d57,0x0000,0x5d53,0x5d4f,
0x0000,0x5d3b,0x5d46,0x0000,0x0000,0x5e46,0x5e47,0x0000,
0x5e48,0x5ec0,0x5ebd,0x5ebf,0x0000,0x5f11,0x0000,0x5f3e,
0x5f3b,0x0000,0x5f3a,0x0000,0x0000,0x0000,0x5fa7,0x0000,
0x60ea,0x0000,0x6107,0x6122,0x610c,0x0000,0x0000,0x60b3,
0x60d6,0x60d2,0x0000,0x60e3,0x60e5,0x60e9,0x0000,0x0000,
0x6111,0x60fd,0x0000,0x0000,0x611e,0x6120,0x6121,0x621e,
0x0000,0x63e2,0x63de,0x63e6,0x0000,0x0000,0x0000,0x0000,
0x63f8,0x0000,0x63fe,0x63c1,0x63bf,0x63f7,0x63d1,0x655f,
0x6560,0x6561,0x0000,0x0000,0x65d1,0x0000,0x0000,0x667d,
0x666b,0x667f,0x0000,0x0000,0x6673,0x6681,0x666d,0x6669,
0x0000,0x0000,0x671e,0x68ed,0x0000,0x0000,0x0000,0x0000,
0x6903,0x0000,0x68fe,0x68e5,0x691e,0x6902,0x0000,0x0000,
0x6909,0x68ca,0x6900,0x0000,0x6901,0x6918,0x68e2,0x68cf,
0x0000,0x692e,0x68c5,0x68ff,0x0000,0x691c,0x68c3,0x0000,
0x6b6f,0x0000,0x6b6e,0x0000,0x6bbe,0x0000,0x6bf4,0x6c2d,
0x0000,0x6db6,0x6e75,0x6e1e,0x0000,0x6e18,0x0000,0x6e48,
0x0000,0x6e4f,0x0000,0x6e42,0x6e6a,0x6e70,0x6dfe,0x0000,
0x0000,0x6e6d,0x0000,0x6e7b,0x6e7e,0x6e59,0x0000,0x6e57,
0x0000,0x6e80,0x6e50,0x0000,0x6e29,0x6e76,0x6e2a,0x6e4c,
0x712a,0x0000,0x7135,0x712c,0x7137,0x711d,0x0000,0x0000,
0x7138,0x0000,0x7134,0x712b,0x7133,0x7127,0x7124,0x0000,
0x712d,0x7232,0x7283,0x7282,0x7287,0x7306,0x7324,0x7338,
0x732a,0x732c,0x732b,0x0000,0x732f,0x7328,0x7417,0x0000,
0x0000,0x7419,0x7438,0x0000,0x741f,0x7414,0x743c,0x73f7,
0x741c,0x7415,0x7418,0x7439,0x74f9,0x7524,0x0000,0x0000,
0x0000,0x756e,0x756d,0x7571,0x758e,0x0000,0x75e5,0x0000,
0x0000,0x0000,0x0000,0x7694,0x76b3,0x0000,0x76d9,0x0000,
0x7748,0x7749,0x7743,0x0000,0x0000,0x7742,0x77df,0x0000,
0x7863,0x7876,0x0000,0x785f,0x7866,0x7966,0x7971,0x0000,
0x0000,0x7976,0x7984,0x7975,0x79ff,0x7a07,0x0000,0x7a0e,
0x7a09,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7ae7,
0x7ae2,0x7b55,0x0000,0x0000,0x7b43,0x7b57,0x7b6c,0x7b42,
0x7b53,0x0000,0x7b41,0x0000,0x0000,0x7ca7,0x7ca0,0x7ca6,
0x7ca4,0x7d74,0x0000,0x7d59,0x0000,0x7d60,0x7d57,0x7d6c,
0x7d7e,0x7d64,0x0000,0x7d5a,0x7d5d,0x0000,0x0000,0x0000,
0x7d76,0x7d4d,0x7d75,0x0000,0x7fd3,0x7fd6,0x0000,0x0000,
0x8060,0x804e,0x8145,0x813b,0x0000,0x8148,0x8142,0x8149,
0x8140,0x8114,0x8141,0x0000,0x81ef,0x81f6,0x8203,0x0000,
0x83ed,0x0000,0x83da,0x8418,0x83d2,0x8408,0x0000,0x8400,
0x0000,0x0000,0x0000,0x8417,0x8346,0x8414,0x83d3,0x8405,
0x841f,0x8402,0x8416,0x83cd,0x83e6,0x0000,0x865d,0x86d5,
0x86e1,0x0000,0x0000,0x0000,0x0000,0x86ee,0x8847,0x8846,
0x0000,0x0000,0x88bb,0x0000,0x88bf,0x88b4,0x0000,0x88b5,
0x0000,0x899a,0x8a43,0x0000,0x0000,0x8a5a,0x0000,0x0000,
0x0000,0x8a35,0x8a38,0x8a42,0x8a49,0x8a5d,0x8a4b,0x8a3d,
0x0000,0x0000,0x0000,0x0000,0x8c60,0x8c5e,0x8c7f,0x8c7e,
0x8c83,0x0000,0x8cb1,0x8d87,0x0000,0x0000,0x8d88,0x8d83,
0x0000,0x0000,0x8d86,0x8d8b,0x8d82,0x8dca,0x8dd2,0x0000,
0x0000,0x8dd4,0x8dc9,0x8eb0,0x0000,0x0000,0x0000,0x8ef2,
0x8ee4,0x8ef3,0x8eea,0x0000,0x8efd,0x0000,0x8f9d,0x902b,
0x902a,0x0000,0x9028,0x9029,0x902c,0x0000,0x0000,0x903a,
0x9030,0x9037,0x903b,0x0000,0x910a,0x0000,0x0000,0x0000,
0x91fe,0x9220,0x0000,0x920b,0x0000,0x9218,0x9222,0x0000,
0x921b,0x9208,0x0000,0x920e,0x9213,0x0000,0x0000,0x9595,
0x0000,0x0000,0x0000,0x968c,0x967b,0x967f,0x9681,0x0000,
0x9682,0x0000,0x0000,0x0000,0x0000,0x0000,0x96ee,0x96ed,
0x0000,0x96ec,0x975f,0x976f,0x0000,0x976d,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x98f0,0x0000,0x0000,0x0000,
0x9aa9,0x0000,0x0000,0x9ae0,0x4eb7,0x0000,0x0000,0x50cc,
0x50bc,0x0000,0x50aa,0x50b9,0x0000,0x50ab,0x50c3,0x50cd,
0x517e,0x527e,0x5279,0x0000,0x0000,0x52e1,0x52e0,0x52e7,
0x5380,0x53ab,0x53aa,0x53a9,0x53e0,0x55ea,0x0000,0x55d7,
0x0000,0x0000,0x55c1,0x5715,0x0000,0x586c,0x0000,0x585c,
0x5850,0x5861,0x586a,0x5869,0x5856,0x5860,0x5866,0x585f,
0x5923,0x5966,0x5968,0x0000,0x0000,0x5ace,0x0000,0x5ac5,
0x5ac3,0x0000,0x0000,0x5ad0,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x5b74,0x5b76,0x5bdc,0x5bd7,0x5bda,0x5bdb,
0x0000,0x5c20,0x5d6d,0x5d66,0x0000,0x5d64,0x5d6e,0x0000,
0x5d60,0x5f42,0x5f5a,0x5f6e,0x0000,0x0000,0x6130,0x613a,
0x612a,0x6143,0x6119,0x6131,0x0000,0x613d,0x0000,0x0000,
0x0000,0x6408,0x6432,0x6438,0x0000,0x6431,0x0000,0x6419,
0x0000,0x6411,0x0000,0x0000,0x6429,0x641d,0x0000,0x0000,
0x0000,0x643c,0x0000,0x6446,0x6447,0x0000,0x0000,0x643a,
0x6407,0x0000,0x656b,0x0000,0x6570,0x656d,0x0000,0x65e4,
0x6693,0x0000,0x0000,0x0000,0x0000,0x668f,0x0000,0x0000,
0x6692,0x0000,0x668e,0x0000,0x6946,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x6931,0x0000,0x0000,0x693e,
0x0000,0x697c,0x6943,0x0000,0x6973,0x0000,0x6955,0x0000,
0x0000,0x6985,0x694d,0x6950,0x6947,0x6967,0x6936,0x6964,
0x6961,0x0000,0x697d,0x6b44,0x6b40,0x6b71,0x6b73,0x6b9c,
0x0000,0x0000,0x0000,0x6bc1,0x0000,0x6bfa,0x6c31,0x6c32,
0x0000,0x0000,0x6eb8,0x6ea8,0x0000,0x6e91,0x6ebb,0x0000,
0x6e9a,0x0000,0x0000,0x6ea9,0x0000,0x0000,0x6eb5,0x6e6c,
0x6ee8,0x0000,0x6edd,0x6eda,0x6ee6,0x6eac,0x0000,0x0000,
0x0000,0x6ed9,0x6ee3,0x6ee9,0x6edb,0x0000,0x716f,0x0000,
0x0000,0x7148,0x0000,0x714a,0x716b,0x0000,0x714f,0x7157,
0x7174,0x0000,0x0000,0x0000,0x7145,0x7151,0x716d,0x0000,
0x7251,0x7250,0x724e,0x0000,0x7341,0x0000,0x732e,0x7346,
0x0000,0x7427,0x0000,0x7448,0x7453,0x743d,0x0000,0x745d,
0x7456,0x0000,0x741e,0x7447,0x7443,0x7458,0x7449,0x0000,
0x744c,0x7445,0x743e,0x0000,0x7501,0x751e,0x0000,0x0000,
0x757a,0x75ee,0x7602,0x7697,0x7698,0x0000,0x0000,0x0000,
0x775d,0x7764,0x7753,0x7758,0x7882,0x7890,0x788a,0x0000,
0x787a,0x787d,0x0000,0x788b,0x7878,0x0000,0x0000,0x788d,
0x7888,0x7892,0x7881,0x797e,0x7983,0x0000,0x0000,0x0000,
0x7980,0x0000,0x0000,0x0000,0x7a0f,0x0000,0x0000,0x7a1d,
0x0000,0x7aa1,0x7aa4,0x0000,0x7ae9,0x7aea,0x0000,0x7b62,
0x7b6b,0x0000,0x7b5e,0x0000,0x7b79,0x0000,0x0000,0x7b6f,
0x7b68,0x0000,0x0000,0x7cae,0x0000,0x0000,0x0000,0x7cb0,
0x0000,0x7d90,0x0000,0x7d8a,0x0000,0x7d8b,0x7d99,0x7d95,
0x0000,0x7d87,0x7d78,0x7d97,0x7d89,0x7d98,0x0000,0x0000,
0x0000,0x7fa3,0x0000,0x0000,0x0000,0x7fdd,0x8057,0x0000,
0x8163,0x816a,0x816c,0x0000,0x0000,0x0000,0x815d,0x8175,
0x0000,0x815f,0x0000,0x817d,0x816d,0x0000,0x0000,0x8241,
0x844f,0x8484,0x0000,0x847f,0x0000,0x8448,0x842a,0x847b,
0x8472,0x8464,0x842e,0x845c,0x8453,0x0000,0x8441,0x84c8,
0x0000,0x8462,0x8480,0x843e,0x8483,0x8471,0x0000,0x844a,
0x8455,0x8458,0x0000,0x0000,0x0000,0x86fc,0x86fd,0x8715,
0x0000,0x8716,0x86ff,0x0000,0x0000,0x0000,0x8858,0x88cf,
0x88e0,0x0000,0x0000,0x0000,0x0000,0x89e7,0x8a6a,0x8a80,
0x0000,0x8a6f,0x8a65,0x0000,0x8a78,0x8a7d,0x8a88,0x0000,
0x0000,0x8a64,0x8a7e,0x0000,0x8a67,0x8c63,0x8c88,0x0000,
0x8ccd,0x0000,0x8cc9,0x0000,0x8ded,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x8eb1,0x0000,0x0000,0x8f04,
0x8f9e,0x8fa0,0x9043,0x9046,0x9048,0x9045,0x9040,0x904c,
0x0000,0x0000,0x910c,0x9113,0x9115,0x0000,0x916b,0x9167,
0x925d,0x9255,0x9235,0x0000,0x9259,0x922f,0x923c,0x928f,
0x925c,0x926a,0x9262,0x925f,0x926b,0x926e,0x923b,0x9244,
0x9241,0x959a,0x0000,0x9599,0x0000,0x0000,0x0000,0x968f,
0x0000,0x9696,0x0000,0x0000,0x0000,0x96f4,0x96fc,0x0000,
0x9755,0x0000,0x9779,0x0000,0x0000,0x0000,0x97ee,0x97f5,
0x0000,0x980b,0x0000,0x98f3,0x0000,0x0000,0x98f7,0x98ff,
0x98f5,0x0000,0x98ec,0x98f1,0x0000,0x0000,0x999a,0x0000,
0x9ae2,0x9b3d,0x9b5d,0x9ce8,0x0000,0x9ceb,0x9cef,0x9cee,
0x9e81,0x9f14,0x50d0,0x50d9,0x50dc,0x50d8,0x0000,0x50e1,
0x50eb,0x0000,0x0000,0x50f4,0x50e2,0x50de,0x0000,0x0000,
0x0000,0x51f4,0x0000,0x0000,0x0000,0x52ed,0x52ea,0x0000,
0x5332,0x0000,0x53ae,0x53b0,0x0000,0x55fb,0x5603,0x560b,
0x0000,0x5607,0x0000,0x55f8,0x0000,0x5628,0x561e,0x0000,
0x5618,0x5611,0x5651,0x5605,0x5717,0x5892,0x0000,0x588c,
0x0000,0x5878,0x5884,0x5873,0x58ad,0x5897,0x5895,0x5877,
0x5872,0x5896,0x588d,0x5910,0x0000,0x596c,0x0000,0x5ae7,
0x0000,0x5ae4,0x0000,0x0000,0x5aef,0x5626,0x0000,0x0000,
0x5af0,0x5d7b,0x0000,0x5d83,0x0000,0x0000,0x5d8b,0x5d8c,
0x0000,0x5d78,0x5e52,0x0000,0x0000,0x5ed0,0x5ecf,0x0000,
0x5fb3,0x5fb4,0x0000,0x0000,0x0000,0x617b,0x0000,0x616f,
0x6181,0x613c,0x6142,0x6138,0x6133,0x0000,0x6160,0x6169,
0x617d,0x6186,0x622c,0x6228,0x0000,0x644c,0x0000,0x6457,
0x647c,0x0000,0x0000,0x6455,0x6462,0x6471,0x646a,0x6456,
0x643b,0x6481,0x0000,0x644f,0x647e,0x6464,0x0000,0x0000,
0x0000,0x0000,0x0000,0x6571,0x0000,0x0000,0x66a5,0x669a,
0x669c,0x0000,0x66a6,0x0000,0x66a4,0x698f,0x69c5,0x69c8,
0x6992,0x69b2,0x0000,0x0000,0x0000,0x69e3,0x69c0,0x69d6,
0x69d1,0x699f,0x69a2,0x69d2,0x0000,0x0000,0x0000,0x69e1,
0x69d5,0x699d,0x0000,0x0000,0x6998,0x0000,0x6b74,0x6ba1,
0x0000,0x6ef0,0x6ef3,0x0000,0x0000,0x6f1b,0x6f0c,0x6f1d,
0x6f34,0x6f28,0x6f17,0x0000,0x6f44,0x6f42,0x6f04,0x6f11,
0x6efa,0x6f4a,0x7191,0x718e,0x0000,0x718b,0x718d,0x717f,
0x718c,0x717e,0x717c,0x7183,0x0000,0x7188,0x0000,0x0000,
0x7294,0x0000,0x7355,0x7353,0x734f,0x7354,0x746c,0x7465,
0x7466,0x7461,0x746b,0x7468,0x7476,0x0000,0x7460,0x0000,
0x7474,0x7506,0x760e,0x0000,0x7607,0x0000,0x0000,0x76b9,
0x0000,0x76b7,0x76e2,0x0000,0x7774,0x7777,0x7776,0x7775,
0x0000,0x7778,0x7771,0x0000,0x777a,0x715b,0x777b,0x78a6,
0x78ae,0x78b8,0x0000,0x0000,0x0000,0x78b1,0x78af,0x0000,
0x7989,0x7987,0x0000,0x0000,0x7a29,0x0000,0x7a2a,0x0000,
0x7a2d,0x7a2c,0x0000,0x7a32,0x0000,0x7aec,0x7af0,0x7b81,
0x7b9e,0x7b83,0x0000,0x7b92,0x0000,0x7ba3,0x7b9f,0x7b93,
0x0000,0x7b86,0x7cb8,0x7cb7,0x0000,0x0000,0x0000,0x0000,
0x0000,0x7dc8,0x7db6,0x0000,0x7dd1,0x0000,0x7da8,0x7dab,
0x0000,0x7db3,0x7dcd,0x0000,0x7dcf,0x7da4,0x0000,0x0000,
0x7f41,0x7f6f,0x7f71,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x8023,0x805b,0x0000,0x8061,0x805f,0x8181,0x0000,
0x0000,0x8184,0x8213,0x0000,0x824a,0x824c,0x0000,0x0000,
0x0000,0x84bd,0x8495,0x0000,0x8492,0x84c3,0x0000,0x8496,
0x84a5,0x84b5,0x84b3,0x84a3,0x84e4,0x84d8,0x84d5,0x0000,
0x84b7,0x84ad,0x84da,0x8493,0x8736,0x0000,0x0000,0x0000,
0x873d,0x872b,0x8747,0x8739,0x0000,0x8745,0x871d,0x0000,
0x88ff,0x88ea,0x0000,0x88f5,0x0000,0x8900,0x88ed,0x8903,
0x88e9,0x0000,0x0000,0x89ea,0x0000,0x8a9b,0x8a8e,0x8aa2,
0x0000,0x8a9c,0x8a94,0x8a90,0x8aa9,0x8aac,0x0000,0x8a9f,
0x0000,0x0000,0x8a9d,0x0000,0x8c67,0x0000,0x0000,0x8cd0,
0x8cd6,0x8cd4,0x8d98,0x8d9a,0x8d97,0x0000,0x0000,0x0000,
0x8e0b,0x8e08,0x8e01,0x8eb4,0x8eb3,0x0000,0x8fa1,0x8fa2,
0x0000,0x905a,0x0000,0x9061,0x905f,0x0000,0x0000,0x9125,
0x917b,0x9176,0x917c,0x0000,0x9289,0x92f6,0x92b1,0x92ad,
0x9292,0x9281,0x9284,0x0000,0x92ae,0x9290,0x929e,0x0000,
0x0000,0x0000,0x95a2,0x95a7,0x0000,0x0000,0x0000,0x0000,
0x0000,0x96a0,0x969d,0x969f,0x96d0,0x0000,0x96d1,0x0000,
0x0000,0x9759,0x0000,0x9764,0x0000,0x0000,0x0000,0x9819,
0x0000,0x9814,0x9815,0x981a,0x0000,0x0000,0x0000,0x0000,
0x9906,0x0000,0x98f8,0x9901,0x0000,0x99be,0x99bc,0x99b7,
0x99b6,0x99c0,0x0000,0x99b8,0x0000,0x0000,0x0000,0x99c4,
0x0000,0x99bf,0x0000,0x9ada,0x9ae4,0x9ae9,0x9ae8,0x9aea,
0x9ae5,0x0000,0x9b26,0x0000,0x0000,0x9b40,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x9ebd,0x0000,0x0000,
0x0000,0x0000,0x510e,0x0000,0x50f7,0x0000,0x50fc,0x510d,
0x5101,0x51da,0x51d9,0x51db,0x5286,0x528e,0x52ee,0x5333,
0x53b1,0x0000,0x5647,0x562d,0x5654,0x0000,0x564b,0x5652,
0x5631,0x5644,0x5656,0x5650,0x562b,0x0000,0x564d,0x5637,
0x564f,0x58a2,0x58b7,0x0000,0x58b2,0x0000,0x58aa,0x58b5,
0x58b0,0x0000,0x58b4,0x58a4,0x58a7,0x0000,0x5926,0x5afe,
0x0000,0x5b04,0x0000,0x5afc,0x0000,0x5b06,0x5b0a,0x5afa,
0x5b0d,0x5b00,0x5b0e,0x0000,0x0000,0x0000,0x5d91,0x0000,
0x5d8f,0x5d90,0x5d98,0x5da4,0x5d9b,0x5da3,0x5d96,0x5de4,
0x5e5a,0x0000,0x0000,0x5e5e,0x0000,0x5fb8,0x6157,0x615c,
0x61a6,0x6195,0x6188,0x0000,0x61a3,0x618f,0x0000,0x6164,
0x0000,0x6159,0x6178,0x0000,0x6185,0x6187,0x619e,0x0000,
0x0000,0x6198,0x619c,0x0000,0x0000,0x622f,0x6480,0x649b,
0x648e,0x648d,0x6494,0x64c6,0x0000,0x64a8,0x6483,0x0000,
0x64b9,0x6486,0x64b4,0x64af,0x6491,0x0000,0x64aa,0x64a1,
0x64a7,0x66b6,0x66b3,0x0000,0x66bc,0x66ac,0x0000,0x66ad,
0x6a0e,0x0000,0x6a1c,0x6a1a,0x0000,0x0000,0x6a0b,0x0000,
0x69ef,0x6a0c,0x69f0,0x6a22,0x0000,0x69d8,0x0000,0x6a12,
0x69fa,0x0000,0x6a2a,0x0000,0x6a10,0x0000,0x0000,0x6a29,
0x69f9,0x69ea,0x6a2c,0x6a24,0x0000,0x69e9,0x6b52,0x6b4f,
0x6b53,0x0000,0x0000,0x6f10,0x6f65,0x6f75,0x0000,0x0000,
0x0000,0x0000,0x6fd0,0x0000,0x6f5c,0x6f3d,0x6f71,0x0000,
0x6f91,0x6f0b,0x6f79,0x6f81,0x6f8f,0x0000,0x6f59,0x6f74,
0x0000,0x71ae,0x0000,0x71a3,0x71ad,0x0000,0x0000,0x71ab,
0x71a6,0x71a2,0x0000,0x52f2,0x7257,0x7255,0x7299,0x734b,
0x747a,0x0000,0x0000,0x0000,0x748c,0x7484,0x0000,0x0000,
0x7482,0x7493,0x747b,0x0000,0x7509,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x778a,0x0000,0x7790,0x0000,0x78c6,
0x78d3,0x78c0,0x78d2,0x78c7,0x78c2,0x0000,0x799f,0x799d,
0x799e,0x0000,0x7a41,0x0000,0x7a38,0x7a3a,0x7a42,0x0000,
0x0000,0x7a3e,0x7ab0,0x7bae,0x7bb3,0x0000,0x0000,0x7bbf,
0x0000,0x0000,0x7bcd,0x0000,0x7bb2,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x7cc4,0x7ccd,0x7cc2,0x7cc6,
0x7cc3,0x7cc9,0x7cc7,0x0000,0x7df8,0x0000,0x7ded,0x7de2,
0x0000,0x0000,0x0000,0x7ddc,0x7e02,0x7e01,0x0000,0x7dd6,
0x0000,0x7de4,0x7dfe,0x0000,0x7e00,0x7dfc,0x7dfd,0x0000,
0x7df5,0x7dff,0x0000,0x7deb,0x7de5,0x7f78,0x7fae,0x7fe7,
0x0000,0x8065,0x806a,0x8066,0x8068,0x806b,0x8194,0x81a1,
0x8192,0x8196,0x8193,0x0000,0x0000,0x8501,0x0000,0x84f8,
0x0000,0x84f5,0x0000,0x8504,0x0000,0x0000,0x0000,0x0000,
0x851b,0x8503,0x8533,0x8534,0x84ed,0x0000,0x0000,0x8535,
0x0000,0x8505,0x0000,0x0000,0x0000,0x0000,0x877d,0x0000,
0x0000,0x0000,0x8771,0x0000,0x885c,0x88e6,0x890f,0x891b,
0x0000,0x89a9,0x89a5,0x89ee,0x8ab1,0x0000,0x8acc,0x8ace,
0x0000,0x8ab7,0x0000,0x8ab5,0x8ae9,0x8ab4,0x0000,0x8ab3,
0x8ac1,0x8aaf,0x8aca,0x8ad0,0x0000,0x0000,0x0000,0x8c8e,
0x0000,0x0000,0x8ce9,0x8cdb,0x0000,0x8ceb,0x8da4,0x0000,
0x8da2,0x8d9d,0x0000,0x0000,0x0000,0x0000,0x8e2a,0x8e28,
0x0000,0x0000,0x8eb8,0x8eb6,0x8eb9,0x8eb7,0x8f22,0x8f2b,
0x8f27,0x8f19,0x8fa4,0x0000,0x8fb3,0x0000,0x9071,0x906a,
0x0000,0x0000,0x9188,0x918c,0x92bf,0x92b8,0x92be,0x92dc,
0x92e5,0x0000,0x0000,0x92d4,0x92d6,0x0000,0x92da,0x92ed,
0x92f3,0x92db,0x0000,0x92b9,0x92e2,0x92eb,0x95af,0x0000,
0x95b2,0x95b3,0x0000,0x0000,0x0000,0x96a3,0x96a5,0x0000,
0x0000,0x0000,0x0000,0x970a,0x0000,0x9787,0x9789,0x978c,
0x97ef,0x982a,0x9822,0x0000,0x981f,0x0000,0x9919,0x0000,
0x99ca,0x99da,0x0000,0x0000,0x0000,0x99de,0x99c8,0x99e0,
0x0000,0x9ab6,0x9ab5,0x0000,0x9af4,0x0000,0x9b6b,0x9b69,
0x9b72,0x9b63,0x0000,0x9d0d,0x0000,0x9d01,0x9d0c,0x0000,
0x9cf8,0x0000,0x0000,0x9cfe,0x9d02,0x9e84,0x0000,0x9eab,
0x9eaa,0x511d,0x5116,0x0000,0x512b,0x511e,0x511b,0x5290,
0x5294,0x5314,0x0000,0x0000,0x5667,0x0000,0x567b,0x0000,
0x565f,0x5661,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x58c3,0x58ca,0x58bb,0x58c0,0x58c4,0x5901,0x5b1f,
0x5b18,0x5b11,0x5b15,0x0000,0x5b12,0x5b1c,0x0000,0x5b22,
0x5b79,0x5da6,0x0000,0x5db3,0x5dab,0x5eea,0x0000,0x5f5b,
0x0000,0x0000,0x61b7,0x61ce,0x61b9,0x61bd,0x61cf,0x61c0,
0x6199,0x6197,0x0000,0x61bb,0x61d0,0x61c4,0x6231,0x0000,
0x64d3,0x64c0,0x0000,0x0000,0x0000,0x0000,0x64dc,0x64d1,
0x64c8,0x0000,0x64d5,0x66c3,0x0000,0x0000,0x66bf,0x66c5,
0x0000,0x66cd,0x66c1,0x6706,0x0000,0x6724,0x6a63,0x6a42,
0x6a52,0x0000,0x6a43,0x6a33,0x0000,0x6a6c,0x6a57,0x0000,
0x6a4c,0x6a6e,0x0000,0x0000,0x0000,0x0000,0x0000,0x6a37,
0x0000,0x6a71,0x6a4a,0x6a36,0x0000,0x6a53,0x0000,0x6a45,
0x6a70,0x0000,0x0000,0x6a5c,0x6b58,0x6b57,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x6fbb,0x0000,0x0000,0x6fbe,
0x0000,0x0000,0x0000,0x6fb5,0x6fd3,0x6f9f,0x0000,0x6fb7,
0x6ff5,0x71b7,0x0000,0x71bb,0x0000,0x71d1,0x0000,0x71ba,
0x0000,0x71b6,0x71cc,0x0000,0x0000,0x71d3,0x749b,0x0000,
0x0000,0x7496,0x74a2,0x749d,0x750a,0x750e,0x0000,0x7581,
0x762c,0x7637,0x7636,0x763b,0x0000,0x76a1,0x0000,0x0000,
0x7798,0x0000,0x7796,0x0000,0x0000,0x0000,0x78d6,0x78eb,
0x0000,0x78dc,0x0000,0x79a5,0x79a9,0x9834,0x7a53,0x7a45,
0x0000,0x7a4f,0x0000,0x7abd,0x7abb,0x7af1,0x0000,0x0000,
0x7bec,0x7bed,0x0000,0x0000,0x7cd3,0x0000,0x7ce1,0x0000,
0x7e19,0x0000,0x0000,0x0000,0x7e27,0x7e26,0x0000,0x0000,
0x806e,0x81af,0x0000,0x0000,0x81ad,0x0000,0x81aa,0x8218,
0x0000,0x0000,0x0000,0x0000,0x856f,0x854c,0x0000,0x8542,
0x0000,0x855c,0x8570,0x855f,0x0000,0x855a,0x854b,0x853f,
0x878a,0x0000,0x878b,0x87a1,0x878e,0x0000,0x0000,0x8799,
0x885e,0x885f,0x8924,0x89a7,0x8aea,0x8afd,0x8af9,0x8ae3,
0x8ae5,0x0000,0x0000,0x8aec,0x0000,0x0000,0x0000,0x0000,
0x8cf2,0x0000,0x8cef,0x0000,0x8da6,0x0000,0x0000,0x0000,
0x8e3b,0x8e43,0x0000,0x8e32,0x8f31,0x8f30,0x0000,0x8f2d,
0x8f3c,0x8fa7,0x8fa5,0x0000,0x0000,0x0000,0x9137,0x9195,
0x918e,0x0000,0x9196,0x0000,0x9345,0x930a,0x0000,0x0000,
0x92fd,0x9317,0x931c,0x9307,0x9331,0x9332,0x932c,0x9330,
0x9303,0x9305,0x0000,0x95c2,0x0000,0x95b8,0x0000,0x95c1,
0x0000,0x0000,0x0000,0x96ab,0x96b7,0x0000,0x0000,0x9715,
0x9714,0x0000,0x0000,0x970c,0x9717,0x0000,0x9793,0x0000,
0x97d2,0x0000,0x0000,0x9836,0x9831,0x9833,0x983c,0x982e,
0x983a,0x0000,0x983d,0x0000,0x98b5,0x9922,0x9923,0x9920,
0x991c,0x991d,0x0000,0x99a0,0x0000,0x99ef,0x99e8,0x99eb,
0x0000,0x0000,0x0000,0x99e1,0x99e6,0x0000,0x0000,0x9af8,
0x9af5,0x0000,0x0000,0x9b83,0x9b94,0x9b84,0x0000,0x9b8b,
0x9b8f,0x0000,0x9b8c,0x0000,0x9b89,0x0000,0x9b8e,0x0000,
0x0000,0x0000,0x9d24,0x9d0f,0x0000,0x9d13,0x9d0a,0x0000,
0x0000,0x0000,0x0000,0x9d2a,0x9d1a,0x0000,0x9d27,0x9d16,
0x9d21,0x0000,0x9e85,0x9eac,0x9ec6,0x9ec5,0x9ed7,0x9f53,
0x0000,0x5128,0x5127,0x51df,0x0000,0x5335,0x53b3,0x0000,
0x568a,0x567d,0x5689,0x0000,0x58cd,0x58d0,0x0000,0x5b2b,
0x5b33,0x5b29,0x5b35,0x5b31,0x5b37,0x5c36,0x5dbe,0x0000,
0x5db9,0x0000,0x5dbb,0x0000,0x61e2,0x61db,0x61dd,0x61dc,
0x61da,0x0000,0x61d9,0x0000,0x0000,0x64df,0x0000,0x0000,
0x64e1,0x0000,0x64ee,0x0000,0x65b5,0x66d4,0x66d5,0x0000,
0x66d0,0x66d1,0x66ce,0x66d7,0x0000,0x0000,0x6a7d,0x6a8a,
0x0000,0x6aa7,0x0000,0x6a99,0x6a82,0x6a88,0x0000,0x0000,
0x6a86,0x0000,0x6a98,0x6a9d,0x0000,0x0000,0x6a8f,0x0000,
0x6aaa,0x0000,0x6b5d,0x0000,0x6c0a,0x0000,0x6fd7,0x6fd6,
0x6fe5,0x0000,0x0000,0x0000,0x6fd9,0x6fda,0x6fea,0x0000,
0x6ff6,0x0000,0x0000,0x71e3,0x0000,0x71e9,0x0000,0x71eb,
0x71ef,0x71f3,0x71ea,0x0000,0x0000,0x0000,0x0000,0x0000,
0x7371,0x0000,0x74ae,0x0000,0x74b3,0x0000,0x74ac,0x0000,
0x0000,0x7583,0x7645,0x764e,0x7644,0x76a3,0x76a5,0x77a6,
0x77a4,0x0000,0x77a9,0x77af,0x0000,0x0000,0x0000,0x78f0,
0x78f8,0x78f1,0x0000,0x7a49,0x0000,0x0000,0x0000,0x7ac2,
0x7af2,0x7af3,0x7bfa,0x0000,0x7bf6,0x7bfc,0x7c18,0x7c08,
0x7c12,0x0000,0x0000,0x7cdb,0x7cda,0x0000,0x0000,0x0000,
0x7e2c,0x7e4d,0x0000,0x0000,0x7f46,0x7ff6,0x802b,0x8074,
0x81b8,0x81c8,0x0000,0x0000,0x0000,0x8592,0x8593,0x0000,
0x857f,0x85ab,0x8597,0x0000,0x0000,0x85ac,0x0000,0x0000,
0x0000,0x87ce,0x0000,0x87cd,0x0000,0x0000,0x87c1,0x87b1,
0x87c7,0x0000,0x8940,0x0000,0x893f,0x8939,0x0000,0x8943,
0x0000,0x0000,0x0000,0x89ab,0x0000,0x8b1f,0x8b09,0x8b0c,
0x0000,0x0000,0x8c40,0x0000,0x8c96,0x0000,0x8cf6,0x8cf7,
0x0000,0x8e46,0x8e4f,0x0000,0x0000,0x0000,0x8f3d,0x8f41,
0x9366,0x9378,0x935d,0x9369,0x9374,0x937d,0x936e,0x9372,
0x9373,0x9362,0x9348,0x9353,0x935f,0x9368,0x0000,0x937f,
0x936b,0x0000,0x95c4,0x0000,0x96af,0x96ad,0x96b2,0x0000,
0x0000,0x971a,0x971b,0x0000,0x0000,0x0000,0x0000,0x979b,
0x979f,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x9840,0x0000,0x9847,0x0000,0x98b7,0x0000,0x0000,
0x0000,0x0000,0x0000,0x99a2,0x0000,0x0000,0x9a00,0x99f3,
0x0000,0x0000,0x99f5,0x0000,0x0000,0x9abd,0x9b00,0x9b02,
0x0000,0x9b34,0x9b49,0x9b9f,0x0000,0x9ba3,0x9bcd,0x9b99,
0x9b9d,0x0000,0x0000,0x9d39,0x0000,0x9d44,0x0000,0x0000,
0x9d35,0x0000,0x0000,0x9eaf,0x0000,0x512f,0x0000,0x0000,
0x9f8e,0x0000,0x569f,0x569b,0x569e,0x5696,0x5694,0x56a0,
0x0000,0x5b3b,0x0000,0x0000,0x5b3a,0x5dc1,0x5f4d,0x5f5d,
0x61f3,0x0000,0x0000,0x0000,0x0000,0x64f6,0x64e5,0x64ea,
0x64e7,0x6505,0x0000,0x64f9,0x0000,0x0000,0x0000,0x6aab,
0x6aed,0x6ab2,0x6ab0,0x6ab5,0x6abe,0x6ac1,0x6ac8,0x0000,
0x6ac0,0x6abc,0x6ab1,0x6ac4,0x6abf,0x0000,0x0000,0x7008,
0x7003,0x6ffd,0x7010,0x7002,0x7013,0x0000,0x71fa,0x7200,
0x74b9,0x74bc,0x0000,0x765b,0x7651,0x764f,0x76eb,0x77b8,
0x0000,0x77b9,0x77c1,0x77c0,0x77be,0x790b,0x0000,0x7907,
0x790a,0x7908,0x0000,0x790d,0x7906,0x7915,0x79af,0x0000,
0x0000,0x0000,0x7af5,0x0000,0x0000,0x7c2e,0x0000,0x7c1b,
0x0000,0x7c1a,0x7c24,0x0000,0x0000,0x7ce6,0x7ce3,0x0000,
0x0000,0x7e5d,0x7e4f,0x7e66,0x7e5b,0x7f47,0x7fb4,0x0000,
0x0000,0x0000,0x7ffa,0x802e,0x0000,0x0000,0x81ce,0x0000,
0x0000,0x8219,0x0000,0x0000,0x85cc,0x85b2,0x0000,0x85bb,
0x85c1,0x0000,0x0000,0x0000,0x87e9,0x87ee,0x87f0,0x87d6,
0x880e,0x87da,0x8948,0x894a,0x894e,0x894d,0x89b1,0x89b0,
0x89b3,0x0000,0x8b38,0x8b32,0x0000,0x8b2d,0x0000,0x8b34,
0x0000,0x8b29,0x8c74,0x0000,0x0000,0x8d03,0x0000,0x0000,
0x8da9,0x8e58,0x0000,0x0000,0x8ebf,0x8ec1,0x8f4a,0x8fac,
0x0000,0x9089,0x913d,0x913c,0x91a9,0x93a0,0x0000,0x9390,
0x0000,0x9393,0x938b,0x93ad,0x93bb,0x93b8,0x0000,0x0000,
0x939c,0x95d8,0x95d7,0x0000,0x0000,0x0000,0x975d,0x97a9,
0x97da,0x0000,0x0000,0x0000,0x0000,0x9854,0x0000,0x9855,
0x984b,0x0000,0x983f,0x98b9,0x0000,0x0000,0x0000,0x0000,
0x9938,0x9936,0x9940,0x0000,0x993b,0x9939,0x99a4,0x0000,
0x0000,0x9a08,0x9a0c,0x0000,0x9a10,0x0000,0x9b07,0x0000,
0x9bd2,0x0000,0x9bc2,0x9bbb,0x9bcc,0x9bcb,0x0000,0x0000,
0x9d4d,0x9d63,0x9d4e,0x0000,0x9d50,0x9d55,0x0000,0x9d5e,
0x0000,0x9e90,0x9eb2,0x9eb1,0x0000,0x9eca,0x9f02,0x9f27,
0x9f26,0x0000,0x56af,0x58e0,0x58dc,0x0000,0x5b39,0x0000,
0x0000,0x5b7c,0x5bf3,0x0000,0x0000,0x5c6b,0x5dc4,0x650b,
0x6508,0x650a,0x0000,0x0000,0x65dc,0x0000,0x0000,0x66e1,
0x66df,0x6ace,0x6ad4,0x6ae3,0x6ad7,0x6ae2,0x0000,0x0000,
0x0000,0x0000,0x6ad8,0x6ad5,0x6ad2,0x0000,0x0000,0x701e,
0x702c,0x7025,0x6ff3,0x7204,0x7208,0x7215,0x0000,0x74c4,
0x74c9,0x74c7,0x74c8,0x76a9,0x77c6,0x77c5,0x7918,0x791a,
0x7920,0x0000,0x7a66,0x7a64,0x7a6a,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x7c35,0x7c34,0x0000,0x0000,0x7e6c,
0x0000,0x7e6e,0x7e71,0x0000,0x81d4,0x81d6,0x821a,0x8262,
0x8265,0x8276,0x85db,0x85d6,0x0000,0x85e7,0x0000,0x0000,
0x85f4,0x0000,0x87fd,0x87d5,0x8807,0x0000,0x880f,0x87f8,
0x0000,0x0000,0x8987,0x0000,0x89b5,0x89f5,0x0000,0x8b3f,
0x8b43,0x8b4c,0x0000,0x8d0b,0x8e6b,0x8e68,0x8e70,0x8e75,
0x8e77,0x0000,0x8ec3,0x0000,0x93e9,0x93ea,0x93cb,0x93c5,
0x93c6,0x0000,0x93ed,0x93d3,0x0000,0x93e5,0x0000,0x0000,
0x93db,0x93eb,0x93e0,0x93c1,0x0000,0x0000,0x95dd,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x97b2,0x97b4,0x97b1,0x97b5,0x97f2,0x0000,0x0000,0x0000,
0x9856,0x0000,0x0000,0x0000,0x9944,0x0000,0x9a26,0x9a1f,
0x9a18,0x9a21,0x9a17,0x0000,0x9b09,0x0000,0x0000,0x9bc5,
0x9bdf,0x0000,0x9be3,0x0000,0x9be9,0x9bee,0x0000,0x0000,
0x9d66,0x9d7a,0x0000,0x9d6e,0x9d91,0x9d83,0x9d76,0x9d7e,
0x9d6d,0x0000,0x9e95,0x9ee3,0x0000,0x0000,0x9f03,0x9f04,
0x0000,0x9f17,0x0000,0x5136,0x0000,0x5336,0x0000,0x5b42,
0x0000,0x0000,0x5b44,0x5b46,0x5b7e,0x5dca,0x5dc8,0x5dcc,
0x5ef0,0x0000,0x6585,0x66e5,0x66e7,0x0000,0x0000,0x0000,
0x6af4,0x0000,0x6ae9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x703d,0x0000,0x7036,0x0000,0x7216,0x0000,0x7212,0x720f,
0x7217,0x7211,0x720b,0x0000,0x0000,0x74cd,0x74d0,0x74cc,
0x74ce,0x74d1,0x0000,0x7589,0x0000,0x7a6f,0x7c4b,0x7c44,
0x0000,0x0000,0x0000,0x0000,0x0000,0x7e7f,0x8b71,0x0000,
0x802f,0x807a,0x807b,0x807c,0x0000,0x0000,0x0000,0x85fc,
0x8610,0x8602,0x0000,0x0000,0x85ee,0x8603,0x0000,0x860d,
0x8613,0x8608,0x860f,0x8818,0x8812,0x0000,0x0000,0x8967,
0x8965,0x89bb,0x8b69,0x8b62,0x0000,0x8b6e,0x0000,0x8b61,
0x0000,0x8b64,0x8b4d,0x8c51,0x0000,0x0000,0x8e83,0x8ec6,
0x0000,0x941f,0x0000,0x9404,0x9417,0x9408,0x9405,0x0000,
0x93f3,0x941e,0x9402,0x941a,0x941b,0x9427,0x941c,0x0000,
0x96b5,0x0000,0x0000,0x9733,0x0000,0x9734,0x9731,0x97b8,
0x97ba,0x0000,0x97fc,0x0000,0x0000,0x98c3,0x0000,0x994d,
0x0000,0x9a2f,0x0000,0x0000,0x0000,0x9ac9,0x0000,0x9ac8,
0x9ac4,0x9b2a,0x9b38,0x9b50,0x0000,0x9c0a,0x9bfb,0x9c04,
0x9bfc,0x9bfe,0x0000,0x0000,0x0000,0x9c02,0x9bf6,0x9c1b,
0x9bf9,0x9c15,0x9c10,0x9bff,0x9c00,0x9c0c,0x0000,0x0000,
0x9d95,0x9da5,0x0000,0x0000,0x0000,0x0000,0x9e98,0x9ec1,
0x0000,0x9f5a,0x5164,0x56bb,0x0000,0x58e6,0x5b49,0x5bf7,
0x0000,0x0000,0x5dd0,0x0000,0x5fc2,0x0000,0x6511,0x0000,
0x6aff,0x6afe,0x6afd,0x0000,0x6b01,0x0000,0x0000,0x704b,
0x704d,0x7047,0x74d3,0x7668,0x7667,0x0000,0x0000,0x77d1,
0x7930,0x7932,0x792e,0x0000,0x9f9d,0x7ac9,0x7ac8,0x0000,
0x7c56,0x7c51,0x0000,0x0000,0x0000,0x7e85,0x7e89,0x7e8e,
0x7e84,0x0000,0x826a,0x862b,0x862f,0x8628,0x0000,0x8616,
0x8615,0x861d,0x881a,0x0000,0x0000,0x0000,0x89bc,0x8b75,
0x8b7c,0x0000,0x8d11,0x8d12,0x8f5c,0x91bb,0x0000,0x93f4,
0x0000,0x0000,0x942d,0x0000,0x0000,0x96e4,0x9737,0x9736,
0x9767,0x97be,0x97bd,0x97e2,0x9868,0x9866,0x98c8,0x98ca,
0x98c7,0x98dc,0x0000,0x994f,0x99a9,0x9a3c,0x0000,0x9a3b,
0x9ace,0x0000,0x9b14,0x9b53,0x0000,0x9c2e,0x0000,0x9c1f,
0x0000,0x0000,0x0000,0x0000,0x9db0,0x9dbd,0x0000,0x0000,
0x9dae,0x9dc4,0x9e7b,0x0000,0x0000,0x9e9e,0x0000,0x9f05,
0x0000,0x9f69,0x9fa1,0x56c7,0x571d,0x5b4a,0x5dd3,0x0000,
0x5f72,0x6202,0x0000,0x6235,0x6527,0x651e,0x651f,0x0000,
0x0000,0x6b07,0x6b06,0x0000,0x0000,0x7054,0x721c,0x7220,
0x7af8,0x0000,0x7c5d,0x7c58,0x0000,0x7e92,0x7f4e,0x0000,
0x0000,0x0000,0x8827,0x0000,0x8b81,0x8b83,0x0000,0x8c44,
0x0000,0x0000,0x0000,0x0000,0x9442,0x944d,0x9454,0x944e,
0x0000,0x9443,0x0000,0x0000,0x973c,0x9740,0x97c0,0x0000,
0x0000,0x0000,0x0000,0x995a,0x9a51,0x0000,0x9add,0x0000,
0x0000,0x9c38,0x0000,0x9c45,0x9c3a,0x0000,0x9c35,0x0000,
0x0000,0x0000,0x9ef1,0x0000,0x9f93,0x529a,0x0000,0x0000,
0x8641,0x5dd7,0x0000,0x6528,0x0000,0x0000,0x0000,0x7053,
0x7059,0x0000,0x7221,0x0000,0x766f,0x7937,0x79b5,0x7c62,
0x7c5e,0x7cf5,0x0000,0x0000,0x863d,0x0000,0x882d,0x8989,
0x8b8d,0x8b87,0x8b90,0x8d1a,0x8e99,0x0000,0x0000,0x0000,
0x945f,0x0000,0x0000,0x9456,0x9461,0x945b,0x945a,0x945c,
0x9465,0x0000,0x9741,0x0000,0x0000,0x986e,0x986c,0x986d,
0x0000,0x99aa,0x9a5c,0x9a58,0x9ade,0x0000,0x9c4f,0x9c51,
0x0000,0x9c53,0x0000,0x0000,0x0000,0x9dfc,0x9f39,0x0000,
0x513e,0x0000,0x56d2,0x0000,0x5b4f,0x6b14,0x0000,0x7a72,
0x7a73,0x0000,0x0000,0x0000,0x8b91,0x0000,0x0000,0x91bf,
0x0000,0x946c,0x0000,0x0000,0x96e6,0x9745,0x0000,0x97c8,
0x97e4,0x995d,0x0000,0x9b21,0x0000,0x9b2c,0x9b57,0x0000,
0x0000,0x9c5d,0x9c61,0x9c65,0x9e08,0x0000,0x0000,0x0000,
0x0000,0x0000,0x9f45,0x0000,0x0000,0x6205,0x66ef,0x6b1b,
0x6b1d,0x7225,0x7224,0x7c6d,0x0000,0x8642,0x8649,0x0000,
0x8978,0x898a,0x8b97,0x0000,0x8c9b,0x8d1c,0x0000,0x8ea2,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x9c6c,0x0000,0x9c6f,0x0000,0x9e0e,0x0000,0x9f08,0x9f1d,
0x9fa3,0x0000,0x0000,0x5f60,0x6b1c,0x0000,0x0000,0x0000,
0x7cf3,0x0000,0x8b9b,0x8ea7,0x91c4,0x0000,0x947a,0x0000,
0x0000,0x9a61,0x9a63,0x9ad7,0x9c76,0x0000,0x9fa5,0x0000,
0x7067,0x0000,0x72ab,0x864a,0x897d,0x8b9d,0x8c53,0x8f65,
0x947b,0x0000,0x98cd,0x98dd,0x0000,0x9b30,0x9e16,0x0000,
0x0000,0x0000,0x0000,0x0000,0x96e7,0x9e18,0x9ea2,0x0000,
0x9f7c,0x0000,0x7e9e,0x9484,0x0000,0x9e1c,0x0000,0x7c71,
0x97ca,0x0000,0x0000,0x0000,0x9ea3,0x0000,0x9c7b,0x9f97,
0x0000,0x0000,0x9750,0x0000,0x0000,0x0000,0x5727,0x5c13,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x5fc8,0x0000,
0x0000,0x0000,0x0000,0x0000,0x6765,0x0000,0x0000,0x52bd,
0x0000,0x5b66,0x0000,0x65f9,0x6788,0x6ce6,0x6ccb,0x0000,
0x4fbd,0x5f8d,0x0000,0x6018,0x6048,0x0000,0x6b29,0x70a6,
0x0000,0x7706,0x0000,0x0000,0x0000,0x5a10,0x5cfc,0x5cfe,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x70c9,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9579,0x0000,
0x96ba,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x7b29,0x8128,0x0000,0x8a2e,0x0000,0x0000,0x0000,0x9ad9,
0x0000,0x582b,0x5845,0x0000,0x63fa,0x0000,0x0000,0x0000,
0x6e86,0x0000,0x0000,0x0000,0x0000,0x0000,0x5867,0x0000,
0x5bdd,0x656e,0x0000,0x0000,0x0000,0x8c87,0x0000,0x50d2,
0x50df,0x0000,0x0000,0x0000,0x0000,0x69ba,0x0000,0x6b9d,
0x0000,0x8059,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x6f8a,0x0000,
0x0000,0x7bc3,0x7bc2,0x0000,0x0000,0x0000,0x0000,0x90f6,
0x0000,0x9823,0x0000,0x0000,0x0000,0x0000,0x0000,0x71cd,
0x7499,0x0000,0x0000,0x0000,0x0000,0x0000,0x9842,0x0000,
0x0000,0x0000,0x0000,0x7f84,0x0000,0x0000,0x0000,0x0000,
0x0000,0x8d0e,0x0000,0x9861,0x0000,0x0000,0x8b73,0x0000,
0x9c27,0x0000,0x9458,0x77d6,0x9b2d,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x4f66,0x4f68,0x4fe7,0x503f,0x0000,0x50a6,0x510f,
0x523e,0x5324,0x5365,0x539b,0x517f,0x54cb,0x5573,0x5571,
0x556b,0x55f4,0x5622,0x5620,0x5692,0x56ba,0x5691,0x56b0,
0x5759,0x578a,0x580f,0x5812,0x5813,0x5847,0x589b,0x5900,
0x594d,0x5ad1,0x5ad3,0x5b67,0x5c57,0x5c77,0x5cd5,0x5d75,
0x5d8e,0x5da5,0x5db6,0x5dbf,0x5e65,0x5ecd,0x5eed,0x5f94,
0x5f9a,0x5fba,0x6125,0x6150,0x62a3,0x6360,0x6364,0x63b6,
0x6403,0x64b6,0x651a,0x7a25,0x5c21,0x66e2,0x6702,0x67a4,
0x67ac,0x6810,0x6806,0x685e,0x685a,0x692c,0x6929,0x6a2d,
0x6a77,0x6a7a,0x6aca,0x6ae6,0x6af5,0x6b0d,0x6b0e,0x6bdc,
0x6bdd,0x6bf6,0x6c1e,0x6c63,0x6da5,0x6e0f,0x6e8a,0x6e84,
0x6e8b,0x6e7c,0x6f4c,0x6f48,0x6f49,0x6f9d,0x6f99,0x6ff8,
0x702e,0x702d,0x705c,0x79cc,0x70bf,0x70ea,0x70e5,0x7111,
0x7112,0x713f,0x7139,0x713b,0x713d,0x7177,0x7175,0x7176,
0x7171,0x7196,0x7193,0x71b4,0x71dd,0x71de,0x720e,0x5911,
0x7218,0x7347,0x7348,0x73ef,0x7412,0x743b,0x74a4,0x748d,
0x74b4,0x7673,0x7677,0x76bc,0x7819,0x781b,0x783d,0x7853,
0x7854,0x7858,0x78b7,0x78d8,0x78ee,0x7922,0x794d,0x7986,
0x7999,0x79a3,0x79bc,0x7aa7,0x7b37,0x7b59,0x7bd0,0x7c2f,
0x7c32,0x7c42,0x7c4e,0x7c68,0x7ca9,0x7ced,0x7dd0,0x7e07,
0x7dd3,0x7e64,0x7f40,0x0000,0x8041,0x8063,0x80bb,0x6711,
0x6725,0x8248,0x8310,0x8362,0x8312,0x8421,0x841e,0x84e2,
0x84de,0x84e1,0x8573,0x85d4,0x85f5,0x8637,0x8645,0x8672,
0x874a,0x87a9,0x87a5,0x87f5,0x8834,0x8850,0x8887,0x8954,
0x8984,0x8b03,0x8c52,0x8cd8,0x8d0c,0x8d18,0x8db0,0x8ebc,
0x8ed5,0x8faa,0x909c,0x0000,0x915c,0x922b,0x9221,0x9273,
0x92f4,0x92f5,0x933f,0x9342,0x9386,0x93be,0x93bc,0x93bd,
0x93f1,0x93f2,0x93ef,0x9422,0x9423,0x9424,0x9467,0x9466,
0x9597,0x95ce,0x95e7,0x973b,0x974d,0x98e4,0x9942,0x9b1d,
0x9b98,0x0000,0x9d49,0x6449,0x5e71,0x5e85,0x61d3,0x990e,
0x8002,0x781e,0x0000,0x0000,0x5528,0x5572,0x55ba,0x55f0,
0x55ee,0x56b8,0x56b9,0x56c4,0x8053,0x92b0};

static const int cns11643_14_ucs_table_size = (sizeof(cns11643_14_ucs_table)/sizeof(unsigned short));

/* UCS -> CNS11643 */
static const unsigned int ucs_a1_cns11643_table[] = {
/* 0x0000 */
0x00000,0x00001,0x00002,0x00003,0x00004,0x00005,0x00006,0x00007,
0x00008,0x00009,0x0000a,0x0000b,0x0000c,0x0000d,0x0000e,0x0000f,
0x00010,0x00011,0x00012,0x00013,0x00014,0x00015,0x00016,0x00017,
0x00018,0x00019,0x0001a,0x0001b,0x0001c,0x0001d,0x0001e,0x0001f,
0x00020,0x00021,0x00022,0x00023,0x00024,0x00025,0x00026,0x00027,
0x00028,0x00029,0x0002a,0x0002b,0x0002c,0x0002d,0x0002e,0x0002f,
0x00030,0x00031,0x00032,0x00033,0x00034,0x00035,0x00036,0x00037,
0x00038,0x00039,0x0003a,0x0003b,0x0003c,0x0003d,0x0003e,0x0003f,
0x00040,0x00041,0x00042,0x00043,0x00044,0x00045,0x00046,0x00047,
0x00048,0x00049,0x0004a,0x0004b,0x0004c,0x0004d,0x0004e,0x0004f,
0x00050,0x00051,0x00052,0x00053,0x00054,0x00055,0x00056,0x00057,
0x00058,0x00059,0x0005a,0x0005b,0x0005c,0x0005d,0x0005e,0x0005f,
0x00060,0x00061,0x00062,0x00063,0x00064,0x00065,0x00066,0x00067,
0x00068,0x00069,0x0006a,0x0006b,0x0006c,0x0006d,0x0006e,0x0006f,
0x00070,0x00071,0x00072,0x00073,0x00074,0x00075,0x00076,0x00077,
0x00078,0x00079,0x0007a,0x0007b,0x0007c,0x0007d,0x0007e,0x0007f,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x12170,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x12278,0x12234,0x00000,0x00000,0x00000,0x00000,0x00000,0x12131,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x12232,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x12233,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
/* 0x0100 */
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
/* 0x0200 */
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x1256f,
0x00000,0x1256d,0x1256e,0x12570,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x1256c,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
/* 0x0300 */
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x12475,0x12476,0x12477,0x12478,0x12479,0x1247a,0x1247b,
0x1247c,0x1247d,0x1247e,0x12521,0x12522,0x12523,0x12524,0x12525,
0x12526,0x12527,0x00000,0x12528,0x12529,0x1252a,0x1252b,0x1252c,
0x1252d,0x1252e,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x1252f,0x12530,0x12531,0x12532,0x12533,0x12534,0x12535,
0x12536,0x12537,0x12538,0x12539,0x1253a,0x1253b,0x1253c,0x1253d,
0x1253e,0x1253f,0x00000,0x12540,0x12541,0x12542,0x12543,0x12544,
0x12545,0x12546};

static const int ucs_a1_cns11643_table_min = 0x0000;
static const int ucs_a1_cns11643_table_max = 0x0000 + (sizeof (ucs_a1_cns11643_table) / sizeof (unsigned int));

static const unsigned int ucs_a2_cns11643_table[] = {
/* 0x2000 */
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x12139,0x12137,0x00000,0x1225d,0x00000,
0x12164,0x12165,0x00000,0x00000,0x12166,0x12167,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x1212d,0x1212c,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x1216a,0x00000,0x00000,0x1216b,0x00000,0x00000,
0x00000,0x00000,0x00000,0x1216f,0x00000,0x00000,0x12223,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
/* 0x2100 */
0x00000,0x00000,0x00000,0x1226a,0x00000,0x12222,0x00000,0x00000,
0x00000,0x1226b,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x1242b,0x1242c,0x1242d,0x1242e,0x1242f,0x12430,0x12431,0x12432,
0x12433,0x12434,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x12635,0x12636,0x12637,0x12638,0x12639,0x1263a,0x1263b,0x1263c,
0x1263d,0x1263e,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x12258,0x12255,0x12257,0x12256,0x00000,0x00000,0x12259,0x1225a,
0x1225c,0x1225b,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
/* 0x2200 */
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x12261,0x00000,0x00000,
0x00000,0x00000,0x12235,0x00000,0x00000,0x00000,0x1223c,0x12249,
0x12248,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x12245,0x12246,0x1224d,0x00000,0x00000,0x1224e,0x00000,
0x00000,0x00000,0x00000,0x00000,0x12250,0x1224f,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x12244,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x1223d,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x1223b,0x1223e,0x00000,0x00000,0x00000,0x00000,0x12239,0x1223a,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x12247,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x1224a,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
/* 0x2300 */
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x14221,0x14222,0x14223,0x14224,0x14225,0x14226,0x14227,0x14228,
0x14229,0x1422a,0x1422b,0x1422c,0x1422d,0x1422e,0x1422f,0x14230,
0x14231,0x14232,0x14233,0x14234,0x14235,0x14236,0x14237,0x14238,
0x14239,0x1423a,0x1423b,0x1423c,0x1423d,0x1423e,0x1423f,0x14240,
0x00000,0x14241,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x12621,0x12622,0x12623,0x12624,0x12625,0x12626,0x12627,0x12628,
0x12629,0x1262a,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x1262b,0x1262c,0x1262d,0x1262e,
0x1262f,0x12630,0x12631,0x12632,0x12633,0x12634,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x12339,0x00000,0x1233a,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x1233c,0x00000,0x00000,0x00000,
0x1233d,0x00000,0x00000,0x00000,0x1233e,0x00000,0x00000,0x00000,
0x1233f,0x00000,0x00000,0x00000,0x12337,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x12336,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x12335,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x12334,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x12333,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x12344,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x12345,0x00000,
0x00000,0x12347,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x12346,0x00000,0x00000,0x12340,0x12341,0x12343,
0x12342,0x1234c,0x1234d,0x1234e,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x12324,0x12325,0x12326,0x12327,0x12328,0x12329,0x1232a,
0x1232b,0x12332,0x12331,0x12330,0x1232f,0x1232e,0x1232d,0x1232c,
0x00000,0x00000,0x00000,0x00000,0x12338,0x1233b,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x1217c,0x1217b,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x12175,0x12174,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x1217e,0x1217d,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x1217a,0x12179,
0x00000,0x00000,0x00000,0x12172,0x00000,0x00000,0x12176,0x12173,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x12348,0x12349,0x1234b,0x1234a,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
/* 0x2600 */
0x00000,0x00000,0x00000,0x00000,0x00000,0x12178,0x12177,0x00000,
0x00000,0x12254,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x12251,0x12253,0x12252};

static const int ucs_a2_cns11643_table_min = 0x2000;
static const int ucs_a2_cns11643_table_max = 0x2000 + (sizeof (ucs_a1_cns11643_table) / sizeof (unsigned int));

static const unsigned int ucs_a3_cns11643_table[] = {
/* 0x2f00 */
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x12121,0x12123,0x12124,0x12171,0x00000,0x00000,0x00000,0x00000,
0x12152,0x12153,0x1214e,0x1214f,0x12156,0x12157,0x1215a,0x1215b,
0x1214a,0x1214b,0x12265,0x00000,0x12146,0x12147,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x12168,0x12169,0x00000,
0x00000,0x12435,0x12436,0x12437,0x12438,0x12439,0x1243a,0x1243b,
0x1243c,0x1243d,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x12126,0x00000,0x00000,0x00000,0x00000,
/* 0x3100 */
0x00000,0x00000,0x00000,0x00000,0x00000,0x12547,0x12548,0x12549,
0x1254a,0x1254b,0x1254c,0x1254d,0x1254e,0x1254f,0x12550,0x12551,
0x12552,0x12553,0x12554,0x12555,0x12556,0x12557,0x12558,0x12559,
0x1255a,0x1255b,0x1255c,0x1255d,0x1255e,0x1255f,0x12560,0x12561,
0x12562,0x12563,0x12564,0x12565,0x12566,0x12567,0x12568,0x12569,
0x1256a,0x1256b,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
/* 0x3200 */
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x12221,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
/* 0x3300 */
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x12275,0x12276,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x12270,0x12271,0x12272,0x00000,
0x00000,0x12274,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x12277,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x12273,0x00000,
0x00000,0x1224c,0x1224b,0x00000,0x00000,0x1226f};

static const int ucs_a3_cns11643_table_min = 0x2f00;
static const int ucs_a3_cns11643_table_max = 0x2f00 + (sizeof (ucs_a3_cns11643_table) / sizeof (unsigned int));

static const unsigned int ucs_i_cns11643_table[] = {
/* 0x4d00 */
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x14421,0x14423,0x00000,0x14424,0xe2126,0xe2125,0x00000,0x22126,
0x14437,0x14435,0x14438,0x14436,0x22127,0x14462,0x2212f,0x2212d,
0x14461,0x14460,0x00000,0x00000,0x14562,0x14561,0x14560,0x00000,
0x14563,0x1455f,0x00000,0x00000,0x00000,0x00000,0x14722,0x14723,
0xe2262,0xe2261,0xe2263,0x00000,0xe243f,0x00000,0x14b64,0x00000,
0xe2121,0x00000,0xe212c,0x14439,0x00000,0x14463,0x22130,0x00000,
0x14464,0x22143,0x1486b,0x22531,0x00000,0x00000,0xe2122,0x00000,
0x1443a,0x14465,0x00000,0x14564,0x22144,0xe2740,0x00000,0xe2123,
0x00000,0x00000,0x22121,0x14425,0x00000,0x1443c,0xe2130,0x22128,
0x1443d,0xe212e,0x00000,0x14466,0x00000,0x14565,0x14567,0x14566,
0x00000,0x00000,0x14724,0x14725,0xe2345,0x00000,0x14b65,0xe2b22,
0x1537d,0x14422,0x00000,0x00000,0x22122,0x14426,0x1443f,0x1443e,
0x00000,0x00000,0xe2146,0xe2145,0x00000,0x00000,0x00000,0x00000,
0xe2264,0x14726,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0xe2440,0x00000,0x14b66,0x00000,0x00000,0x00000,0x00000,
0x00000,0xe2b23,0x00000,0x00000,0x00000,0x00000,0x15871,0x2334e,
0xe396c,0xe396e,0x1632a,0x24156,0x24157,0xe2124,0x14427,0xe212d,
0x14468,0xe2265,0x00000,0x14b67,0x14428,0x22129,0x14440,0xe2131,
0x00000,0x14469,0x1446b,0x22131,0x1446c,0x1446a,0x00000,0xe216c,
0xe2266,0x14727,0x00000,0x14b68,0xe2442,0xe2742,0x14b69,0x14f67,
0x00000,0x14441,0x1446d,0xe2147,0x14728,0x1472a,0x14729,0x00000,
0x1486c,0x00000,0x00000,0x14b6a,0x14b6b,0x14f68,0x14f69,0xe2b26,
0xe2b25,0xe2b27,0xe2b24,0x1537e,0x00000,0x00000,0x24158,0xe4033,
0x00000,0x26d44,0x14429,0x00000,0xe2132,0x00000,0xe2133,0x00000,
0x1446f,0x1446e,0x22132,0x14470,0x14476,0xe2149,0x14471,0x14472,
0x22134,0x22133,0x14474,0x14475,0xe214c,0x14473,0xe214b,0xe214a,
0x00000,0x00000,0x00000,0x00000,0x1456a,0x1456b,0x1456c,0x1456d,
0x14569,0x14570,0x2214a,0x00000,0x22146,0x22149,0x14571,0x14623,
0xe216d,0x22148,0x00000,0x1456e,0x1456f,0x14568,0xe2172,0xe2170,
0x22145,0x22147,0x00000,0x00000,0x00000,0x00000,0xe226f,0xe2268,
0x14737,0x2216f,0x14734,0x14738,0x22179,0x2216d,0x14735,0x22171,
0xe226b,0xe2267,0xe2276,0x14736,0xe226e,0x14739,0x00000,0x1472b,
0x22170,0x1473a,0x22174,0xe226d,0x22178,0x22175,0xe226c,0xe2274,
0x22172,0x1472c,0x1472e,0x1473b,0x00000,0x14730,0x2216a,0x14733,
0x14731,0x14732,0x2217a,0x22177,0x2216e,0x1472f,0xe2270,0xe2277,
0x2216b,0x1472d,0xe2275,0x00000,0xe2273,0x22173,0x00000,0x00000,
0x00000,0x00000,0x22176,0x00000,0x00000,0x00000,0x00000,0x00000,
0xe2272,0x00000,0x00000,0x00000,0x2216c,0x22328,0x00000,0x14924,
0x14875,0xe2450,0xe2448,0x22329,0x14872,0xe244f,0x14926,0xe2446,
0x1487a,0xe2445,0x14879,0x2227b,0x1487d,0x14878,0x22322,0x2232a,
0xe244e,0x22326,0xe2449,0x1487b,0xe244b,0xe2443,0x1487e,0x1486f,
0x14929,0x2227d,0xe2444,0xe244c,0x2253d,0x1486d,0x14925,0x1486e,
0x14876,0x14877,0x22324,0x2227e,0x1487c,0x14874,0x2227a,0x14870,
0x22327,0x14927,0x1492a,0x14873,0x14922,0x14928,0x14871,0x22325,
0x14923,0x2232b,0x2227c,0x14921,0x22321,0x00000,0xe6448,0x22323,
0xe6449,0x14b79,0x2253f,0x2254b,0x14b71,0xe2747,0x2254c,0x14b6c,
0x14b76,0x00000,0xe274f,0x14b6f,0x22539,0x14b77,0x22538,0x2253c,
0x22543,0x22541,0x14c21,0x14b7a,0x22533,0x22535,0x14b7c,0x14b70,
0x22536,0x22542,0x22549,0x14b75,0x2253b,0x22534,0x14b74,0x22537,
0x14b78,0x2253a,0xe2744,0x14b73,0xe2751,0x14b6e,0xe2748,0x14b7d,
0x22544,0x14b7e,0x22548,0xe2743,0x22546,0x2254a,0x14b7b,0x2253e,
0x22532,0x00000,0x22540,0x14b72,0x22545,0x14b6d,0x22547,0xe274c,
0xe2749,0xe274b,0xe274a,0xe274d,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x14f78,0x14f6c,
0xe2b2d,0xe2b2e,0x22922,0x2292a,0xe2b36,0x14f6b,0x14f73,0x15021,
0xe2b2c,0x22930,0x2292e,0x22929,0x00000,0xe6263,0xe2b2b,0x14f6d,
0x2292f,0x22925,0x14f7b,0x14f72,0x14f7a,0x2287e,0xe2b32,0x2292c,
0xe2b2f,0x22923,0x14f76,0x22924,0xe2b33,0x2287d,0x14f7d,0x14f70,
0x14f79,0x14f6f,0xe2b28,0x22921,0x22926,0xe2b29,0x2292d,0x14f77,
0x14f74,0x22928,0x14f7c,0x2292b,0x22927,0x14f71,0x14f7e,0x14f75,
0x14f6e,0x14f6a,0x00000,0xe2b35,0x00000,0xe2b34,0x00000,0xe644a,
0x00000,0x00000,0x00000,0x00000,0x22931,0x00000,0x1543a,0x15424,
0xe2f48,0x15434,0xe2f4d,0x15439,0x22d71,0x22d70,0x22d75,0x22d76,
0x15427,0xe2f44,0x15430,0xe2f58,0xe2f4c,0xe2f56,0x1543d,0xe2f46,
0x15431,0x00000,0xe2f4b,0xe2f49,0xe2f47,0x22d6a,0x1542a,0x22d6b,
0xe2f4f,0x1543f,0x00000,0x15436,0x15421,0x15422,0x22d7e,0x15924,
0xe2f53,0x1542f,0x1542e,0x22d6c,0x15432,0x2335e,0x15429,0x22d77,
0x15438,0x15437,0x1542d,0x22d6f,0x22d78,0xe2f45,0x22d69,0x1542c,
0x22d79,0x15435,0x22d6d,0x15423,0xe2f4e,0x15426,0x15425,0x22d7a,
0x15433,0x15428,0x1543c,0x1543e,0x22d74,0x1543b,0xe2f51,0x22d7c,
0x22d6e,0x22d7d,0xe2f43,0x22d72,0x00000,0x22d7b,0xe2f50,0x22d73,
0xe2f54,0xe2f55,0x00000,0x00000,0x1542b,0x00000,0x00000,0xe644b,
0x23366,0x2335a,0xe343c,0x15876,0xe343f,0x2335f,0x23365,0x15875,
0x23358,0x15879,0x2335c,0x23355,0x15877,0x23359,0x1587c,0x15923,
0xe3444,0x2336a,0xe3441,0x23354,0xe3442,0x1587d,0xe2f57,0x23369,
0xe3447,0xe343d,0x15878,0x2335b,0x15874,0x23356,0x23352,0x23360,
0x23353,0x23351,0x2335d,0x23363,0x23364,0x1587a,0xe3440,0x00000,
0x23a3f,0x23361,0x23350,0x23362,0xe344b,0x15926,0x23367,0x15925,
0x2334f,0xe3443,0x23357,0x23368,0x15921,0x1587e,0x1587b,0x15922,
0xe344c,0xe344a,0x15872,0xe3445,0xe3446,0x15873,0x00000,0x00000,
0x15e2e,0xe3975,0x23a42,0x23a3b,0x00000,0x15e2b,0x00000,0x23a43,
0xe3971,0xe3972,0x00000,0x23a39,0x23a3c,0x15e2a,0x23a3d,0xe396f,
0x00000,0x15e2d,0x23a41,0x00000,0x23a37,0x23a36,0x15e2f,0xe3970,
0x15e30,0x15e2c,0x15e31,0x23a35,0x23a40,0x23a3e,0x23a38,0x00000,
0x00000,0x00000,0x15e29,0x23a3a,0x00000,0x00000,0xe644d,0x00000,
0x00000,0x00000,0xe4039,0xe403c,0x16331,0x1632b,0x2415c,0x16334,
0x24162,0x24165,0x1632d,0x1632e,0x2415f,0x1632c,0x24168,0x16332,
0x24169,0xe403a,0x24164,0x16333,0xe4037,0x24159,0x16330,0x2415a,
0x00000,0x24163,0x24161,0xe403d,0x2415d,0x1632f,0x2415b,0x16335,
0x24160,0x24167,0x2415e,0x24166,0xe4036,0xe403e,0x1677c,0x16779,
0xe456b,0x1677a,0xe634c,0x24921,0x24877,0x16778,0x16775,0x24878,
0xe456e,0xe456c,0x16777,0x2487b,0xe456d,0x2487d,0xe4576,0xe634d,
0x24926,0xe4570,0xe4575,0x24925,0x2487e,0x16774,0x24876,0x16772,
0x24879,0x1677d,0x2487c,0xe4571,0x24922,0x16776,0x16773,0x24924,
0x24923,0x1677b,0x00000,0x2487a,0xe4574,0x16c23,0x24f54,0xe4b29,
0x24f51,0x16c24,0x00000,0x16c22,0xe4b2b,0x24f58,0x24f55,0x24f4e,
0x16c21,0xe4b2d,0x16c25,0x24f4f,0x16b7e,0x16c28,0x24f52,0x24f53,
0x16c26,0x16c27,0x24f59,0x24f56,0x24f57,0xe4b2c,0xe4b27,0xe644e,
0x17033,0x25643,0x17030,0x25640,0x17032,0x17034,0xe5031,0x25641,
0x17031,0x00000,0x25642,0xe5035,0x2563f,0xe5030,0xe5034,0x17341,
0x25c49,0x17342,0x25c47,0x00000,0x25c48,0x25c46,0x25c45,0xe5441,
0xe5440,0x25c4a,0x17340,0xe5033,0x00000,0x26144,0x26145,0xe5752,
0x24f50,0x26143,0x17343,0x1782b,0x26537,0x26538,0xe5c32,0x17a62,
0x17a63,0x26b4f,0x26b4e,0x17b58,0x17b57,0x26e7d,0xe606f,0x1442a,
0x14442,0x14478,0x00000,0x14477,0x14573,0x14572,0x1473e,0x1473d,
0x1473f,0x1473c,0xe2278,0x1492c,0x1492b,0x1492d,0xe2454,0x00000,
0xe2453,0xe2451,0x14c23,0x00000,0x14c22,0x14c24,0xe2752,0x15022,
0x00000,0x12279,0x22e21,0x1227a,0x15927,0x1227c,0x1227b,0x23a44,
0xe3976,0x1227d,0x1677e,0x1227e,0xe5e25,0x1442b,0xe2134,0x14479,
0x14740,0x14c25,0xe2b37,0x1442c,0x1447c,0x1447a,0x1447b,0x00000,
0x00000,0x14741,0xe227a,0x00000,0x00000,0x1492e,0x14c27,0x14c26,
0x14c28,0xe2e7b,0x00000,0x00000,0x15440,0x00000,0xe403f,0xe6453,
0x17035,0x00000,0xe2127,0x00000,0xe214d,0xe2148,0xe214e,0x2212e,
0x00000,0x14574,0x14575,0xe2178,0xe2179,0x14742,0x00000,0x2232c,
0xe2755,0x15024,0x15023,0x22e23,0x22e22,0x15928,0xe2128,0x1447d,
0x22135,0xe217a,0x00000,0x00000,0x00000,0xe2457,0x2254d,0xe2b39,
0x15025,0xe2f5b,0x15443,0xe2f59,0x15441,0x15442,0xe2f5a,0x00000,
0xe344d,0x00000,0x17036,0x00000,0x14576,0x00000,0x00000,0x00000,
0x14743,0x2217b,0xe227e,0xe227d,0xe227c,0xe2459,0x1492f,0x14930,
0xe245a,0x2232d,0x00000,0x00000,0x2254e,0x14c29,0x2254f,0x00000,
0x00000,0xe2b3b,0xe2b3d,0xe2b3e,0x22e25,0x22e26,0x15446,0xe2f5e,
0x22e27,0xe2f5f,0x22e24,0x15447,0x15445,0x15444,0x22e28,0xe344f,
0x2336b,0xe344e,0xe397d,0xe397a,0x23a45,0x00000,0xe397e,0x2416a,
0x24927,0xe4b2f,0xe4b2e,0xe4b30,0x16c29,0x17037,0x25644,0xe5442,
0x1442d,0x1443b,0xe212f,0xe2135,0xe2151,0xe217b,0x00000,0x00000,
0xe2322,0x00000,0x00000,0x00000,0xe245b,0xe2759,0x00000,0x00000,
0x15929,0x15e33,0x00000,0x16821,0xe457a,0x22123,0x1447e,0x00000,
0x14579,0x14577,0x14578,0x00000,0x00000,0x14c2a,0xe275a,0x00000,
0x1442e,0x1442f,0x00000,0x14443,0xe2136,0xe2152,0x14521,0x14522,
0x14523,0x2214c,0x1457a,0xe217d,0x2214b,0x00000,0x14747,0xe2325,
0x2217d,0x14745,0x14746,0x2217c,0xe2324,0xe2326,0x14748,0x14744,
0xe2327,0x00000,0x00000,0x00000,0x2232e,0x14f4f,0x2232f,0xe245f,
0xe2461,0x22330,0x00000,0xe245c,0x14932,0x14931,0xe245e,0xe245d,
0x14935,0x14933,0x14934,0xe2460,0x00000,0x00000,0x14c30,0xe275b,
0x14c2f,0x22554,0x22551,0x22552,0xe275e,0x22550,0x14c31,0x14c2d,
0x14c2c,0xe275f,0x14c2e,0x14c2b,0xe275d,0x00000,0xe644f,0x00000,
0x00000,0x14c32,0x00000,0x15027,0x22932,0xe2b3f,0x22553,0x1502c,
0xe2b40,0x22933,0x15028,0x1502b,0x1502a,0x15029,0x15026,0xe2b43,
0x00000,0x00000,0x22e2b,0xe2f68,0x1544a,0x22e2e,0x15448,0xe2f65,
0x00000,0xe2f62,0x22e2a,0x1544b,0x15449,0x1544c,0x22e2c,0x22e2d,
0xe2f60,0x22e29,0x22e2f,0xe2f66,0xe2f61,0xe2f63,0x00000,0xe2f64,
0xe3450,0x15e37,0x1592a,0x2336c,0x2336e,0x2336d,0x2336f,0x1592b,
0xe3a23,0x00000,0x15e34,0xe3a21,0x15e35,0x15e36,0xe3451,0x16337,
0x2416c,0xe4041,0x2416b,0x2416d,0x2416e,0x16338,0xe4040,0x16336,
0x24928,0x24929,0x16823,0x16822,0x24c61,0x00000,0xe4b31,0x16c2a,
0x16c2b,0x16c2c,0x16c2e,0x24f5a,0x24f5b,0x16c2d,0xe4b32,0x00000,
0xe5036,0x17038,0x00000,0x17039,0xe5037,0x00000,0x26539,0x26b51,
0x26b50,0x26e7e,0xe602c,0x14430,0xe2137,0xe2154,0xe2153,0x1457c,
0x1457b,0x00000,0x00000,0x14749,0x00000,0x00000,0x2217e,0x00000,
0xe2328,0x14937,0x14938,0x14936,0x14939,0x22331,0x22332,0x00000,
0x00000,0x00000,0x00000,0xe2463,0xe2462,0xe2761,0x00000,0x00000,
0x00000,0xe2760,0x00000,0x14c34,0x22555,0xe625a,0x14c33,0xe2762,
0x22934,0x15030,0x22935,0x1502f,0xe2b48,0xe2b46,0x00000,0x1502d,
0x00000,0x1502e,0xe2b47,0x00000,0xe2f6f,0x22e30,0xe2f6c,0xe2f6a,
0xe2f6d,0xe2f6e,0x1592c,0x23371,0xe3452,0x1592f,0x23370,0x15b2b,
0x1592e,0x1592d,0x00000,0x15e3a,0x00000,0x15e39,0x15e38,0x16339,
0xe4045,0xe4044,0x1633c,0x1633d,0x1633b,0x00000,0x1633a,0xe4046,
0x00000,0x2492a,0xe4621,0x2492b,0x00000,0xe457e,0xe4b33,0x24f5d,
0x16c2f,0x24f5c,0xe4d2c,0x1703a,0x25c4b,0x17344,0x00000,0x2653a,
0x17961,0x00000,0x14444,0x14524,0x22136,0xe2155,0x14525,0x14526,
0xe2156,0x00000,0x00000,0xe2223,0xe2222,0x1457d,0x1457e,0xe2224,
0x1474a,0x22333,0x22556,0x22557,0x00000,0x15031,0x22e31,0x15931,
0x15930,0x23a47,0x23a46,0x00000,0xe5038,0x14431,0x14527,0x14621,
0x00000,0x15932,0x22124,0x00000,0x2214d,0x14622,0xe2226,0x22222,
0x1474c,0x1474b,0x22221,0x1493a,0xe6450,0xe2465,0x00000,0xe2b49,
0x00000,0x00000,0x1544d,0x00000,0x00000,0x23372,0x00000,0x1633e,
0x2492c,0x16824,0xe4623,0xe4b34,0x25645,0xe5444,0xe5c34,0x2686a,
0xe2129,0x14528,0xe2157,0xe2466,0x22558,0x22936,0x15935,0x15933,
0x15934,0x14432,0x00000,0x14445,0x1243f,0x1452b,0xe2159,0x1452a,
0x14529,0x14625,0x14624,0xe232a,0x2214e,0x22223,0x00000,0xe232b,
0xe232d,0x14c38,0x14c35,0x14c37,0x14c36,0xe2763,0x00000,0x15032,
0xe2b4a,0x00000,0x15e3b,0x00000,0x14433,0xe215a,0x1452c,0xe2227,
0x14627,0x14626,0x00000,0x22334,0x00000,0xe6451,0x14c39,0xe2a5c,
0x00000,0xe212a,0x00000,0x00000,0x22137,0xe2228,0x14629,0x14628,
0x1474d,0x1474e,0x22335,0x1493b,0xe2467,0x1493c,0xe2765,0x14c3a,
0x14c3b,0x14c3c,0xe2766,0x15033,0x22937,0xe2b4b,0x00000,0x1544e,
0xe4047,0x00000,0x22125,0x00000,0x1452d,0x00000,0xe215b,0x00000,
0x00000,0xe2229,0x22224,0xe232f,0x00000,0x00000,0x22336,0x22337,
0x00000,0x00000,0x22559,0xe2767,0x2255a,0x00000,0x22939,0x22938,
0x2293b,0x2293a,0x15034,0xe6452,0x23373,0x15450,0x22e32,0x1544f,
0xe3454,0x00000,0x00000,0x00000,0x23a48,0x15e3c,0xe3a28,0x23a49,
0xe3a27,0xe404a,0xe4049,0xe4048,0x2492d,0x16825,0xe4625,0x00000,
0xe4626,0xe4b35,0x16c30,0xe5445,0x2653b,0x00000,0xe212b,0xe215c,
0x00000,0x22138,0xe222a,0x1462a,0x00000,0x00000,0xe2331,0x00000,
0x00000,0xe2769,0xe276a,0x15936,0xe3455,0xe3a29,0x00000,0x00000,
0x14434,0x14446,0x1452f,0x1452e,0xe215e,0x14530,0xe2160,0x00000,
0xe222b,0x00000,0xe2333,0x00000,0x14c3e,0xe276b,0x14c3d,0x14c3f,
0x00000,0xe2b50,0xe2b4f,0x15035,0xe2b4e,0xe2b4d,0x00000,0x15451,
0xe404b,0x25646,0x1763b,0x14447,0x1462c,0x1463b,0x14636,0x00000,
0x14631,0x14630,0x14637,0x14635,0x1462e,0x1463c,0x1462f,0x1462b,
0x1463a,0x14639,0x14638,0x1462d,0xe2231,0x14634,0xe222d,0xe222e,
0x14633,0xe222f,0x00000,0x1463d,0x14632,0x00000,0x00000,0xe2335,
0xe2337,0x14754,0x00000,0x1475a,0x14756,0xe2339,0x1475c,0x22225,
0x14759,0x1474f,0x14752,0x14755,0x14751,0x14758,0x1475b,0x14750,
0x14753,0x14757,0x1475d,0xe233a,0x00000,0xe233b,0xe2334,0x00000,
0x22340,0x2233d,0xe2476,0x14949,0x2233e,0x1493d,0x1493f,0x14957,
0x14952,0xe2479,0xe247e,0xe2475,0x22345,0x2233f,0x14941,0x14943,
0x22344,0x1494a,0x2233a,0x14956,0x14958,0x1493e,0x1494f,0xe2524,
0x22338,0x14955,0xe2477,0x14946,0xe247b,0x14950,0x14951,0x22339,
0x1494e,0x1494c,0xe2470,0x1494d,0x14953,0x22341,0x14940,0xe2521,
0x14954,0x22343,0x14948,0x14945,0xe2473,0x2233c,0x14944,0x22346,
0x14947,0xe247c,0x1494b,0xe2478,0xe2474,0xe246d,0x14942,0x22342,
0xe247d,0xe2522,0x00000,0x00000,0x2233b,0x00000,0x00000,0x00000,
0x00000,0x00000,0xe2523,0x00000,0x00000,0x00000,0x00000,0xe276e,
0x2256b,0x2256a,0x14c51,0x2256d,0x2256f,0x22564,0x22567,0x2256e,
0x14c52,0xe2774,0xe2778,0x22561,0x22565,0xe2775,0x00000,0x22569,
0x2294a,0x14c4d,0x2294e,0x14c40,0x22566,0x14c41,0x14c4e,0x14c47,
0x14c43,0xe2771,0x22562,0x14c46,0x14c4b,0x14c54,0x22563,0x2255c,
0x14c45,0x2255d,0x2255f,0x00000,0x14c48,0xe276c,0x14c4a,0x2255b,
0x22560,0xe2770,0xe2779,0x14c53,0x14c4f,0x22568,0x14c55,0xe2773,
0x14c4c,0x2255e,0x14c49,0xe276f,0xe2777,0x14c44,0x14c42,0x00000,
0x2256c,0x00000,0x14c50,0x00000,0x00000,0x00000,0xe2b5c,0xe2b5d,
0x22949,0x2293d,0x2294c,0xe2b57,0xe2b59,0x2293f,0x1503c,0x1504a,
0x15038,0x15049,0x15041,0x15046,0x15036,0x2293e,0x22944,0x15045,
0x22950,0x15047,0xe2b5b,0x1503d,0xe2b54,0xe2b5e,0x22946,0x22943,
0x1503b,0xe2b51,0x2293c,0x15048,0x2294b,0x15040,0x2294d,0x1504b,
0x15037,0x15042,0x1503f,0x22941,0x15043,0x22947,0x22948,0x1503e,
0x15044,0x1503a,0xe2b55,0xe6454,0xe2b63,0xe2b61,0x15039,0x22940,
0xe2b53,0x00000,0x00000,0x00000,0x00000,0x00000,0x22945,0x00000,
0x00000,0x00000,0xe2b58,0x00000,0x00000,0x00000,0x2294f,0x00000,
0x22e46,0x1545e,0x22e34,0x00000,0x22e39,0x15457,0x15462,0x22e37,
0x15452,0x1545c,0x15461,0x22e3e,0x00000,0x1545d,0x15460,0xe2f77,
0xe3021,0x22e41,0x15458,0x22e38,0xe2f74,0xe2f78,0xe3022,0x22e44,
0x22e45,0xe2f79,0x1545a,0x22e43,0x15456,0x15465,0x00000,0x22e3b,
0xe2f7b,0x15454,0xe2f7a,0x22e48,0x22e3c,0x22e40,0x15459,0x15464,
0x22e3d,0x1545f,0x22e42,0x22e49,0x23424,0xe2f73,0x22e47,0x15466,
0x15453,0x22e3f,0x22e36,0xe2f76,0x1545b,0x00000,0x00000,0x22e35,
0xe2f7e,0xe3025,0x22e3a,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x22e33,0x15463,
0xe6721,0xe345f,0x2337a,0xe3468,0x15949,0x2342a,0x15947,0x15944,
0x23421,0x15940,0x23425,0x1594b,0x23379,0x2337e,0x2337d,0x15455,
0x15946,0x23428,0xe3466,0x2342b,0x23376,0x00000,0x15e4e,0xe3467,
0x2342c,0x1594c,0x00000,0x1593e,0x1593b,0x23423,0x15938,0x00000,
0x23429,0xe345b,0x1593f,0x2342d,0xe3458,0x23377,0x23427,0x15942,
0x23378,0x2337b,0x23422,0xe3462,0xe3461,0x15943,0x15941,0x1594d,
0xe3457,0xe3a36,0xe3464,0x00000,0x15948,0xe345e,0x1593c,0x15a76,
0x00000,0x1593d,0x2337c,0x1594a,0x15945,0x23426,0x1593a,0x00000,
0xe3459,0x00000,0x15939,0xe6457,0x00000,0x00000,0x00000,0x00000,
0x00000,0xe6456,0xe6722,0xe6455,0x00000,0x23374,0x23375,0x23a4e,
0x00000,0x00000,0xe3a3c,0x15e3d,0x15e40,0x23a59,0x15e54,0x23a5c,
0x15e3e,0x23a55,0x15e44,0x15e4a,0x16143,0xe3a31,0xe3a38,0x15e48,
0x23a52,0x15e55,0x15e41,0x15e49,0x23a5a,0x2417c,0x23a5f,0x23a53,
0x00000,0x23a4a,0x23a57,0x23a51,0x15e47,0x23a5d,0xe3a2e,0xe3a2a,
0x15e43,0x15e57,0x15e50,0xe3a33,0x15e45,0x15e42,0xe3a40,0x15e4d,
0xe3a34,0x23a5e,0x23a50,0x23a56,0x23a58,0x23a4c,0x23a5b,0x15e3f,
0x23a4b,0xe3a42,0x15e46,0x15e56,0x15e52,0x23a4d,0x15e4c,0xe3a3b,
0x00000,0x15e53,0x15e4f,0x15e4b,0xe3a2f,0x23a54,0x00000,0x00000,
0x00000,0x00000,0xe6723,0x15e51,0x00000,0x00000,0x00000,0x2417a,
0x24176,0xe4051,0x24227,0x2416f,0x24178,0x1634c,0x1634d,0x16345,
0x24223,0x1634f,0x24174,0x24173,0x24171,0x24225,0x16343,0x2417d,
0x24172,0x16346,0x2417b,0x16341,0x24177,0x2417e,0x24222,0xe404e,
0x00000,0x24226,0x1634a,0x24170,0x16344,0x24175,0xe3a2b,0x1633f,
0x00000,0x1634b,0x24221,0x16347,0x16348,0x1634e,0x16342,0x12321,
0x16340,0x24179,0xe404c,0x00000,0x00000,0x00000,0xe6725,0x16349,
0xe6724,0x00000,0x24224,0x00000,0xe6458,0x00000,0x16835,0x16830,
0xe462e,0x2493c,0x24938,0xe4628,0x24932,0x1682a,0x16826,0x2493b,
0x16827,0x24935,0x24937,0xe4629,0x2493a,0xe4636,0x1682c,0xe462c,
0x16833,0x1682d,0x00000,0xe462a,0x24930,0x1682e,0x1682f,0x24933,
0x16834,0xe4634,0x24931,0x24936,0x1682b,0x2492f,0x16831,0x16829,
0xe4633,0x00000,0x00000,0x16828,0x24934,0x24939,0xe4631,0x16832,
0xe645a,0x00000,0xe6459,0x00000,0x00000,0x00000,0xe4650,0x2492e,
0xe4630,0x16c37,0x24f6e,0xe4b41,0x24f6b,0xe4b38,0x16c31,0x16c3d,
0x16c3e,0xe4b3d,0x16c34,0x24f69,0x16c36,0x24f61,0x16c3c,0xe4b44,
0x24f6d,0x16c33,0x24f6f,0x16c32,0x00000,0x24f6a,0x24f6c,0x16c35,
0x24f68,0x24f62,0x24f5f,0x00000,0xe4b3e,0x23a4f,0x24f65,0xe4b37,
0x24f5e,0x24f64,0x24f63,0xe4b3b,0x24f60,0xe4b43,0x16c39,0xe4b45,
0xe4b40,0xe4635,0xe4b3c,0x16c38,0xe4b39,0x00000,0xe4b3f,0x16c3a,
0x24f66,0x1703b,0x24f67,0x00000,0x00000,0x00000,0x2564f,0xe503f,
0x25648,0xe5040,0x17047,0x2564c,0x1703f,0x17043,0x2564b,0xe503b,
0x17042,0x1703e,0x17041,0x1703c,0x17046,0x2564d,0x25649,0x17045,
0x25647,0x17044,0x2564e,0x2564a,0x16c3b,0x00000,0x17048,0x25650,
0x17040,0x1703d,0x00000,0xe503d,0x00000,0xe5448,0x25c52,0x25c54,
0x17346,0x25c55,0x25c53,0x25c51,0x25c50,0x17348,0x25c4f,0x17349,
0x00000,0xe5449,0xe5447,0x00000,0x25c4d,0x25c4e,0x17345,0x1734a,
0x17347,0xe645d,0xe645b,0x25c4c,0xe575b,0x1763c,0xe575a,0x26148,
0x26146,0x2614b,0x26149,0xe5758,0x26147,0x2614a,0xe5759,0xe5757,
0xe575c,0x00000,0x00000,0x00000,0x00000,0x1782c,0x2653e,0x2653f,
0x1782d,0x00000,0x26540,0x2653c,0x26541,0x2653d,0x1763d,0xe5a2d,
0xe645e,0x00000,0x2686b,0x2686d,0x17964,0x2686c,0x17963,0x17962,
0xe6726,0xe6727,0xe645c,0xe5e26,0x17965,0x26b53,0x26b54,0x00000,
0x17a65,0x17a64,0x17a66,0x26b52,0xe6728,0x26d46,0x26d45,0xe5f40,
0x17b59,0x17b5b,0x17b5a,0x26d47,0x17c34,0x27034,0x00000,0x00000,
0x00000,0x17c5d,0xe6071,0x27033,0x2707c,0x00000,0x00000,0x2212a,
0xe2177,0x00000,0x1463f,0x1463e,0x00000,0x14760,0x1475f,0x22227,
0x1475e,0x22226,0x00000,0xe233e,0x1495b,0x22349,0xe252c,0x22348,
0x00000,0xe2526,0x14959,0x1495c,0xe252b,0xe252a,0x22347,0xe2529,
0x1495a,0xe2548,0xe2527,0xe2528,0x00000,0x00000,0xe2822,0x22570,
0xe277d,0x22571,0x14c56,0xe277c,0xe2821,0xe277b,0x00000,0x1504c,
0xe2b65,0x22e4a,0x22e4b,0x15467,0x15468,0xe3027,0x00000,0x2342f,
0x1594e,0x15950,0x2342e,0x1594f,0x23a60,0x15e58,0xe3a44,0xe3a43,
0x00000,0x00000,0x16350,0x16351,0x24228,0xe4052,0x16837,0xe4637,
0x16836,0x00000,0x24f70,0x25652,0x25651,0xe5f41,0x2715a,0x14448,
0x22139,0xe2161,0x2214f,0x22150,0xe2234,0x00000,0x00000,0xe6249,
0x14763,0x14767,0x22229,0x00000,0x14765,0x14764,0x22228,0x14766,
0x14762,0xe2341,0xe2342,0x14761,0x2222a,0xe233f,0xe2340,0x00000,
0x00000,0x00000,0x00000,0x14966,0xe2531,0xe253e,0x14963,0xe2530,
0x1495f,0x2234a,0xe2540,0xe2536,0xe252f,0x2234b,0xe253c,0x14961,
0xe252d,0x2234d,0x1495d,0x2234e,0x2234c,0x14960,0x14962,0x14965,
0x14964,0x1495e,0x2234f,0xe2532,0xe2541,0xe2542,0xe2533,0xe2538,
0xe2537,0xe645f,0x00000,0x00000,0x00000,0x00000,0x00000,0xe2535,
0x00000,0x14c5b,0x2257e,0xe2825,0x14c5d,0xe2823,0x14c5c,0xe2826,
0x22621,0x14c5a,0x14c59,0x22575,0x00000,0x22574,0xe2828,0x22572,
0x22577,0x22576,0x22573,0x2257c,0x2257d,0x2257a,0x22578,0x14c58,
0xe2829,0x00000,0x00000,0x2257b,0x14c5e,0x22622,0x00000,0xe282a,
0x22579,0xe2824,0x1504d,0x14c57,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0xe6460,0x1504e,0x22955,0xe2b69,0xe2b68,0x2295b,
0xe2b6c,0xe2b67,0xe2b6a,0x15054,0x22959,0x2295f,0xe2b71,0x22956,
0x2295a,0x2295c,0x2295e,0x22958,0xe2b70,0x22957,0x22952,0x22953,
0x1504f,0xe2b6b,0x15051,0x15050,0x22954,0x2295d,0xe2b6d,0xe2b72,
0xe2b6e,0x00000,0x00000,0x00000,0xe2b66,0x00000,0x15053,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x22951,0x22e55,0xe302a,
0x22e54,0x22e59,0x22e50,0xe3030,0x22e53,0x22e52,0xe302f,0x22e56,
0xe3038,0x22e5a,0x15469,0x1546c,0xe3034,0xe3035,0x22e51,0x22e57,
0xe3033,0xe3028,0xe3037,0x1546b,0x22e4c,0xe302b,0x15052,0x2343d,
0x22e58,0xe3036,0x22e4f,0x00000,0x1546a,0x22e4e,0x00000,0x00000,
0x00000,0x00000,0x00000,0xe3032,0x23434,0xe346e,0xe3471,0x15951,
0x15955,0x23444,0x23432,0x23440,0x15956,0x23442,0xe3472,0x23448,
0xe3474,0x2344c,0xe3469,0x00000,0x23443,0x23437,0x2343f,0xe346b,
0x2344d,0x2344b,0x23441,0x2343c,0x23435,0x23a68,0x23433,0x1595a,
0x2343a,0x1595b,0x15957,0x23430,0x23446,0x23438,0xe346f,0xe3475,
0x23436,0x23449,0x15958,0xe3476,0x2344f,0x15952,0x15954,0x2343e,
0x23439,0x1546d,0x15953,0x2343b,0x2344a,0x2344e,0x23445,0xe6461,
0x23447,0x00000,0xe6462,0xe6463,0x23431,0x00000,0x00000,0x00000,
0xe3a4a,0x23a63,0xe3a45,0x23a6c,0x23a6b,0x15e60,0x23a64,0xe3a47,
0x15e61,0x15e5f,0xe3a50,0x23a66,0x15e5c,0x23a6a,0xe3a4c,0x23a65,
0x23a67,0x23a61,0x15e5a,0xe6336,0x23a74,0x23a73,0x23a70,0x15e59,
0x15e5d,0x15e5e,0x22e4d,0x23a6d,0x15e5b,0x15959,0x23a6f,0x23a62,
0x23a72,0x23a71,0xe3a4e,0x23a75,0xe3a49,0x24236,0xe3a4b,0x23a6e,
0x00000,0x00000,0x00000,0x00000,0x00000,0xe6337,0x00000,0xe6464,
0x23a69,0x2422e,0x1635b,0x1635e,0x16359,0x2422d,0x24231,0x2422c,
0xe4057,0x16353,0x1635d,0x24229,0x16357,0x24230,0xe405b,0x16355,
0x16354,0x24233,0x16356,0x24235,0xe4056,0x24232,0x16352,0xe405e,
0xe405c,0xe4058,0x1635c,0x24237,0x2422b,0x24234,0xe405d,0xe6343,
0x2422a,0xe405a,0xe4059,0x16358,0xe4054,0x1635a,0x00000,0x2422f,
0x00000,0x24238,0xe4643,0xe463e,0x24944,0x16838,0x2494a,0xe4642,
0xe463c,0x1683d,0x24946,0x2494d,0x2493e,0x1683f,0x16839,0x24943,
0x16c3f,0x24942,0x2494b,0x1683a,0xe463d,0x1683e,0x24941,0x24947,
0x2494c,0x2493d,0x1683c,0x24945,0xe463a,0xe4645,0x24949,0x2494f,
0x2493f,0x24948,0xe4638,0x1683b,0x2494e,0xe4641,0xe4644,0xe4640,
0x24940,0x00000,0x00000,0xe6465,0x16c43,0x24f72,0x16c41,0x16c40,
0x24f74,0x24f79,0xe4b46,0x24f75,0xe4b50,0x24f78,0x16c46,0xe4b51,
0x1702e,0x16c45,0xe4b4b,0x24f71,0x24f77,0xe463f,0x16c44,0x24f76,
0xe4b4d,0x24f73,0xe4b49,0x16c42,0xe4b4f,0xe4b4c,0x00000,0xe4b47,
0x00000,0x00000,0x25657,0xe504a,0x25659,0x25654,0x1704a,0x25656,
0xe504b,0x17049,0x25658,0xe5048,0xe504c,0x1704c,0x2565a,0x1704b,
0x25653,0x25655,0xe5049,0x00000,0x00000,0xe544b,0x1734e,0x25c58,
0xe544c,0x1734d,0x25c59,0x1734c,0x25c57,0x1734b,0x25c56,0x00000,
0x1763f,0x1763e,0x26542,0x26544,0xe5a2f,0x26543,0x1782e,0x1782f,
0xe5a2e,0x00000,0x17830,0x2686e,0x17966,0x00000,0xe5e28,0x26f22,
0x26f21,0x17c5e,0x00000,0x14449,0x14531,0x00000,0xe2343,0x14967,
0xe2545,0xe2543,0xe2544,0xe282d,0x22960,0xe2b77,0x00000,0xe3477,
0x00000,0x15e62,0x15e63,0xe3a52,0x24239,0x16840,0x24950,0x24f7a,
0xe6466,0xe504d,0xe2139,0x2213a,0xe2235,0xe2344,0x22350,0x00000,
0xe2b7a,0xe2b79,0xe213a,0xe2546,0x22623,0x22961,0x22e5b,0x1546e,
0xe4646,0xe6560,0x26545,0x00000,0x17a67,0x1444a,0x14640,0x22151,
0xe2236,0x14768,0x14769,0x00000,0x14c5f,0x00000,0x00000,0xe3479,
0x1595c,0x00000,0x16842,0xe405f,0x16843,0x16841,0xe4b53,0x1444b,
0x00000,0x14532,0x14534,0x14533,0x2213b,0x14535,0x14641,0x22152,
0xe2238,0x14642,0xe2237,0x00000,0xe2239,0x00000,0xe2347,0x1476a,
0x1476b,0x00000,0x00000,0x00000,0x2222b,0xe2549,0x14968,0x00000,
0x22351,0x00000,0x00000,0x00000,0x14c63,0x22624,0x00000,0x14c61,
0x14c62,0x14c60,0x22e5c,0xe282e,0xe282f,0xe6467,0x15058,0x15057,
0x15059,0x15056,0xe2b7c,0x22962,0x14c64,0x15055,0x00000,0x1546f,
0x15470,0x00000,0x15471,0xe347b,0x23450,0xe347c,0xe347d,0x00000,
0x15e64,0x23a76,0x1595d,0xe3a53,0xe3a54,0x00000,0xe4060,0x1635f,
0xe4061,0x16845,0x16844,0x24951,0xe4648,0x16c47,0x1704d,0x00000,
0x2614c,0x26d48,0x26f23,0x1444c,0x14643,0xe223b,0x14644,0x22231,
0x1476d,0x14770,0xe234b,0x2222f,0x2222d,0x1476f,0x22230,0x22232,
0x2222c,0x14772,0x14771,0x1476e,0x1476c,0x2222e,0xe234d,0x00000,
0x00000,0xe2555,0x14973,0x00000,0xe254c,0x14970,0x22356,0x22359,
0x22358,0x00000,0x1496a,0x14972,0xe254b,0x00000,0x1496f,0x22355,
0x22353,0x1496e,0xe2556,0xe2553,0xe254e,0x14969,0x1496c,0xe2551,
0x22354,0x2235b,0x22357,0x1496d,0x14971,0x14974,0x22352,0x2235a,
0x1496b,0x00000,0x00000,0x00000,0xe2841,0xe2833,0x14c69,0x14c71,
0xe2838,0x22630,0x22629,0x14c72,0x22634,0x22625,0x2262c,0xe2845,
0xe2840,0x14c68,0x22626,0x14c66,0x2262d,0x22631,0x14c65,0xe283d,
0x22632,0x2262b,0xe2837,0x2262e,0xe2835,0x14c74,0x14c6b,0x22635,
0x22633,0xe283f,0x14c70,0x14c6e,0x2262a,0x14c6d,0x22628,0x22627,
0x14c6c,0x14c6a,0x14c73,0x14c6f,0x14c67,0xe2c26,0x2262f,0xe2846,
0x1505b,0xe2c2d,0x15062,0x22970,0x1505a,0x22968,0x22964,0xe2c21,
0x22974,0x22963,0xe2c2c,0x1505d,0x2296d,0x15060,0x15063,0xe2c2e,
0x1505e,0x22971,0x15061,0xe2c23,0x15478,0x22977,0x22965,0xe2c24,
0xe2c25,0x22967,0x2296e,0x22972,0x22976,0x22973,0x2296c,0x2296f,
0xe2c2b,0xe2c29,0x22969,0x15065,0x2296b,0x2296a,0x22975,0x1505c,
0x22966,0x15064,0xe2c2a,0x1505f,0xe2c28,0x00000,0x00000,0x00000,
0x00000,0x1547e,0x22e64,0xe3040,0x1547d,0xe2c27,0x00000,0x22e62,
0xe6270,0x15472,0xe304f,0x15477,0xe304a,0x22e61,0x22e5e,0x22e63,
0x15473,0x22e5d,0xe304e,0x15476,0x15474,0xe303e,0x22e65,0x15475,
0x15479,0xe303b,0xe3045,0x1547a,0xe3048,0x1547c,0xe3052,0x00000,
0x00000,0x1547b,0xe303c,0xe3522,0xe3538,0x22e5f,0x22e60,0xe304d,
0x00000,0xe304b,0x00000,0x22e66,0x00000,0x23457,0x1595e,0x23b26,
0x23456,0x23469,0xe3528,0xe3524,0x15964,0xe3531,0x23467,0xe3533,
0x15963,0x1595f,0x23470,0x23460,0x23463,0xe352e,0x15967,0x2346d,
0x23465,0x15960,0x15968,0xe352a,0x2346a,0x23468,0xe352f,0xe353b,
0x23459,0x2346e,0x23462,0x2345d,0xe353a,0x23453,0x2346f,0x2345f,
0x23452,0xe3539,0x15966,0x23464,0x23471,0x23461,0x23455,0x2345a,
0x23451,0xe3527,0x15965,0xe353c,0x2345e,0x2345b,0x15961,0x23454,
0xe3530,0x2346c,0x15962,0xe352b,0x2345c,0x23458,0xe3529,0xe3534,
0x2346b,0xe3532,0x00000,0xe3537,0x00000,0xe3535,0x00000,0x15e65,
0x23a7d,0xe3a75,0x23a7a,0x23b2d,0x23b21,0x23b2e,0xe3a7c,0x15e67,
0xe3a63,0xe3a61,0xe3a58,0x23b2a,0x23b27,0xe3a5b,0xe3a77,0xe3a72,
0xe3a59,0xe3a60,0x23b28,0x23b2b,0x23b2f,0xe3a7b,0x23466,0x23b31,
0x2424d,0xe3a66,0x15e68,0x23b32,0x23a78,0x23b24,0xe3a62,0x23b29,
0xe3a5c,0xe3a5e,0x15e66,0x15e69,0x23b30,0x23b33,0x23a7c,0x23a79,
0xe3a73,0xe3a5a,0x23a7b,0xe3a57,0xe3a7a,0x23b22,0x23a7e,0x15e6a,
0xe3a56,0x23b2c,0xe3a79,0xe3a78,0x23b23,0x00000,0x23b25,0x23a77,
0x24241,0x2423f,0x16368,0x16366,0x24249,0x24240,0x2424a,0x24246,
0x2423e,0x2424c,0x2423d,0x24244,0x16365,0x16364,0x16363,0x24242,
0x24247,0x16360,0x16367,0xe4067,0x2423b,0xe4066,0x24245,0x2423a,
0x24243,0x16361,0x24248,0x2423c,0x16362,0x2424b,0xe4064,0xe3a6b,
0xe406a,0xe6468,0x00000,0xe6469,0x00000,0x24955,0x1684a,0x16849,
0x1684b,0x24961,0x24957,0x2495d,0x24952,0x24960,0x2495f,0x24963,
0x2495c,0x16846,0x2495b,0x1684c,0xe464c,0x24954,0x16847,0xe464a,
0x24962,0x16848,0x24956,0x24959,0x2495e,0x24958,0x24953,0xe464f,
0xe4653,0x00000,0x00000,0x2495a,0x24f7c,0x16c4b,0x25021,0x24f7e,
0x25023,0x25025,0xe4b5c,0x16c49,0xe4b58,0x24f7d,0xe4b54,0x24f7b,
0xe4b5e,0x25026,0x25024,0x25022,0xe4b56,0x25028,0xe4b5a,0x25027,
0x16c4d,0x16c48,0xe4b5b,0x16c4a,0x16c4c,0xe4b5d,0xe4b5f,0x25029,
0x25661,0xe5050,0xe5053,0x25660,0x2565f,0xe5051,0x25662,0x2565b,
0xe504f,0x2565c,0x25664,0x2565d,0xe5054,0x1704e,0x25666,0xe504e,
0x25665,0x2565e,0xe5056,0x25c5d,0x17351,0x25c5b,0x25c60,0x25c5f,
0x25663,0xe5450,0x17350,0xe544e,0x25c5e,0x25c5a,0x25c62,0x25c61,
0x1734f,0xe5452,0x25c5c,0xe544f,0x1704f,0xe5451,0x00000,0xe5453,
0x17640,0xe5a31,0xe5761,0xe575e,0x2614d,0x26546,0x26547,0x26548,
0x17967,0x00000,0xe5c36,0x17968,0xe5c39,0x2686f,0xe5c3a,0x26b56,
0x26b55,0xe5e29,0xe5f42,0x26d49,0x26d4a,0x26f24,0x27035,0xe6073,
0x1444d,0x1444e,0x00000,0x1444f,0x14536,0x14645,0x22233,0x14773,
0x14774,0x00000,0x14977,0x14978,0x14976,0x14975,0x00000,0x14c75,
0xe2848,0x00000,0x22636,0x14c77,0x14c76,0x22637,0xe625c,0xe646a,
0x00000,0x15066,0xe2c2f,0x15521,0x22e67,0x00000,0x23473,0x00000,
0x15969,0x15e6c,0x23472,0x15e6b,0xe4071,0x1684d,0xe4072,0x24964,
0x17050,0xe5057,0x17352,0x25c63,0xe5a34,0x17969,0xe5c3b,0x17b5c,
0xe213b,0x22153,0xe223d,0x14646,0x22154,0x14777,0xe2350,0x14775,
0x14776,0x14778,0x00000,0x1497a,0x14979,0xe255a,0x2235c,0x1497b,
0x00000,0x00000,0x2235d,0x22638,0xe284c,0x22639,0xe284a,0x14c78,
0x14c7a,0x14c7c,0x14c79,0x14c7d,0x14c7b,0xe284e,0xe284b,0xe284d,
0x00000,0x00000,0x1506a,0x15067,0x15069,0x1506b,0x15068,0x22e68,
0x22978,0x00000,0x00000,0xe2c32,0x22e6a,0x22e69,0x15527,0x00000,
0x15523,0x00000,0x00000,0x15524,0x15526,0x15528,0x15525,0xe3057,
0x1552a,0x15529,0x00000,0xe3056,0xe3055,0x00000,0x00000,0x1596e,
0x23475,0x23474,0x1596d,0xe3541,0x1596c,0x1596b,0x1596f,0x1596a,
0xe353f,0x00000,0x23b39,0x23b36,0x15e6e,0x23b35,0x23b3a,0x00000,
0x15e70,0x23b38,0x15e6d,0x15e6f,0x23b37,0xe3a7e,0x2424e,0xe4074,
0x2424f,0x24250,0xe4075,0xe4076,0xe4073,0xe6345,0x1684e,0x16856,
0x24965,0x16850,0x16854,0x24966,0x16855,0x16851,0x16852,0x1684f,
0x16853,0x16c50,0x23b34,0x16c51,0x16c4f,0x00000,0x16c4e,0x25667,
0x17051,0x25c64,0x25c65,0xe5a35,0x00000,0x17831,0x1796a,0xe5e2a,
0x14450,0xe223e,0x14779,0x00000,0x00000,0xe255e,0xe255c,0xe255d,
0xe2850,0x1506c,0x00000,0x22e6b,0x1552b,0xe3058,0xe3059,0x15972,
0x15971,0x15970,0x15e71,0x15e72,0x23b3b,0x16857,0x17052,0x14451,
0x2213c,0x14537,0x22155,0xe624a,0xe223f,0x22234,0x1477a,0x00000,
0xe2352,0xe2851,0x14c7e,0xe2c34,0x00000,0x00000,0xe3b24,0x24251,
0xe4078,0xe6525,0x14452,0x00000,0x14538,0x22235,0x00000,0x00000,
0x2235e,0x00000,0x2235f,0xe255f,0x1497c,0x00000,0x00000,0xe2c35,
0x23b3c,0x15e73,0x00000,0x24252,0x00000,0x00000,0xe5454,0x17353,
0x14453,0x14467,0x14539,0x22156,0x14647,0xe2354,0x14a22,0x14a21,
0x1497d,0x1497e,0x00000,0x00000,0x2263a,0x14d22,0x14d23,0x2263b,
0x14d21,0xe2854,0xe2855,0x15070,0x22979,0x1506f,0x1506d,0x1506e,
0x1552e,0x1552c,0xe305a,0xe305b,0x22e6d,0x1552d,0x22e6c,0xe646b,
0x15522,0x23476,0x00000,0xe3543,0x15974,0x15975,0xe3b26,0xe3b25,
0x15973,0xe3544,0x16858,0x24967,0x16c52,0x16c53,0x00000,0x2502a,
0x17354,0x2614e,0x2614f,0xe5a38,0x17a68,0x27036,0x2212b,0x1453a,
0x00000,0x14454,0x00000,0x22158,0x22157,0x00000,0x00000,0xe646c,
0xe2355,0x1477b,0x22237,0x22238,0x22236,0x00000,0x22239,0x00000,
0xe235a,0x00000,0x00000,0x00000,0xe2561,0xe2566,0x22367,0x00000,
0x22362,0x22364,0x22366,0x22363,0x14a26,0x22360,0xe2562,0x22361,
0x14a23,0x14a24,0x22365,0x22368,0x14a25,0x22369,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0xe2563,0x22649,0xe285d,0x22643,
0x2263e,0x14d25,0x22646,0x22644,0x2263d,0x2264a,0x2264d,0x22648,
0x22641,0x14d27,0x22647,0x14d28,0x22642,0x22645,0x2263c,0x22640,
0x2264c,0x14d29,0x00000,0x14d2a,0xe285e,0x2263f,0x2264b,0x14d24,
0x14d26,0xe285c,0xe285f,0xe2857,0x00000,0x00000,0x00000,0x00000,
0x00000,0xe2858,0x00000,0x00000,0x00000,0x00000,0x22a2c,0x22a25,
0x22a2b,0x22a24,0x22a26,0x2297e,0x2297c,0xe2c3f,0x22a2d,0x22a2a,
0x2297a,0xe2c3b,0x15072,0x22a28,0x22a29,0xe646d,0x22a27,0x2297d,
0x2297b,0x15071,0x22a23,0x22a21,0xe2c3c,0xe2c42,0x22a22,0x22a2e,
0x00000,0xe2c3e,0xe2c41,0x00000,0x00000,0xe2c43,0xe2c3d,0x00000,
0x15533,0xe3063,0x15532,0xe305f,0x22e6e,0x1552f,0x22e70,0xe3064,
0x15534,0x22e71,0x00000,0xe3061,0x15537,0xe3062,0x15535,0x22e72,
0x22a2f,0x22e74,0xe305e,0x15531,0xe6271,0x15530,0xe6272,0x22e6f,
0x22e73,0x15536,0x00000,0x00000,0x00000,0x00000,0x15977,0x15976,
0xe354b,0xe3548,0xe3547,0x23478,0x2347c,0x2347e,0x15978,0x23523,
0xe3551,0x1597c,0x23525,0xe3552,0x1597e,0xe354f,0x1597a,0x15a24,
0xe3555,0x15a21,0x2347a,0x15979,0xe3b2b,0x23479,0x23477,0x23527,
0x2347b,0xe3546,0x1597b,0x23526,0x15a22,0x23522,0x23521,0x15a23,
0x2347d,0x1597d,0xe354e,0x00000,0xe354a,0x00000,0x23528,0xe3554,
0x23524,0x23b4b,0x23b52,0x23b47,0x15e76,0x23b43,0x23b53,0x23b3d,
0x23b50,0x23b4e,0x23b48,0xe3b36,0x23b51,0x23b4a,0xe3b28,0x23b42,
0x23b54,0x23b40,0x23b4d,0x23b3e,0xe3b27,0x23b55,0xe3b37,0x15e77,
0xe3b2a,0x23b4f,0x24255,0x23b41,0x15e74,0xe3b2e,0x23b45,0xe3b34,
0x15e75,0x23b44,0x23b49,0xe3b33,0x00000,0x23b46,0x00000,0xe3b31,
0x00000,0x23b4c,0x00000,0xe3b2d,0x00000,0x00000,0x24259,0x00000,
0xe4121,0x00000,0x2425c,0x24254,0xe407c,0x24256,0xe407a,0x2425b,
0x2425a,0x16369,0x00000,0x23b3f,0x24258,0xe4079,0xe407d,0x1636a,
0x00000,0x24253,0x24257,0x00000,0x00000,0xe646e,0x00000,0x2496e,
0xe465c,0x24975,0x2496c,0xe4654,0x24973,0x2496a,0x24972,0x24976,
0x24969,0x2496d,0x24968,0xe4656,0x16859,0x00000,0x2496b,0x1685a,
0x24971,0x24970,0x2496f,0xe4659,0xe465a,0x24974,0xe646f,0xe4b65,
0xe4b66,0xe4b63,0x2502e,0x25030,0x16c55,0x25031,0xe4b6b,0x2502c,
0xe4b67,0x2502b,0x25035,0xe4b69,0x25033,0x16c54,0x25036,0x2502d,
0x25032,0x25034,0x2502f,0xe4b6a,0xe4b68,0xe6470,0xe5058,0x2566b,
0x25670,0x2566a,0x2566f,0xe505b,0x25668,0x25672,0x2566e,0x25673,
0x2566d,0x25669,0x25671,0xe505a,0x25674,0x2566c,0xe6471,0x25c66,
0x17358,0xe5457,0x17356,0xe5459,0x17355,0x17357,0xe5455,0xe6472,
0x26150,0xe5762,0x2643e,0x26549,0xe5a39,0x00000,0x26870,0x26871,
0xe5c3d,0x1796b,0xe5c3c,0x26b57,0xe5c3e,0x17a69,0x00000,0x26b58,
0xe5e2d,0x26d4c,0x17b5e,0xe5f43,0x17b5d,0x26d4b,0x17c35,0xe6030,
0x26f25,0x00000,0x00000,0xe213c,0x00000,0x14455,0x1477c,0x2223a,
0x2236a,0x14b56,0x15a25,0xe3557,0xe4b6c,0x14456,0x1464a,0x14649,
0x14648,0x00000,0x00000,0x14a27,0x00000,0x00000,0x15538,0x00000,
0x2425d,0x14457,0x14458,0x14459,0x1453b,0xe2567,0xe2860,0x15073,
0x00000,0x22a30,0xe2c45,0xe2c44,0x00000,0x15e78,0x1445a,0x2213d,
0xe2163,0x00000,0x1464b,0x1464c,0x22159,0x00000,0x1477d,0x00000,
0xe235c,0xe2568,0x2236b,0xe256b,0x14a28,0x00000,0x2236c,0x00000,
0x00000,0x14d30,0xe2862,0xe2861,0x2264f,0x14d2e,0x14d2d,0x2264e,
0x14d2b,0x22650,0x14d2c,0x14d2f,0x00000,0x15074,0xe2c46,0x15076,
0x22a34,0x22a31,0x22a32,0x22a33,0x22a35,0x15075,0x00000,0x00000,
0x22e76,0x22e75,0xe3066,0x1553a,0xe3069,0x15539,0xe3068,0xe306a,
0xe3067,0x00000,0xe355b,0x15a28,0x2352a,0xe3559,0x15a27,0x15a29,
0x15a26,0xe3558,0xe355a,0x00000,0x00000,0x15e7a,0x23529,0x00000,
0x15e7b,0x23b57,0xe3979,0x15e7c,0x23b56,0x15e79,0xe3b3a,0xe3b3b,
0xe3b3d,0x00000,0x24260,0x24262,0x1636b,0x24261,0x2425f,0x2425e,
0x00000,0x00000,0xe465d,0x24979,0x1685f,0x1685d,0x00000,0x1685e,
0x24977,0x24978,0xe4b6d,0x1685b,0x2503a,0x25038,0xe4b70,0x16c57,
0x25039,0x16c58,0x16c56,0x1685c,0x00000,0xe6473,0x25677,0x25675,
0x25676,0x25037,0x25c68,0x17359,0x25c67,0x26151,0x26152,0x25678,
0x2654a,0xe6677,0x1445b,0x1464d,0x14821,0x2223b,0x1477e,0xe2863,
0x14d31,0x1636c,0xe213d,0x1453c,0x1464e,0x15077,0x15e7d,0xe213e,
0x2215a,0xe2247,0x2215b,0xe2248,0x2223c,0xe6678,0x00000,0x14a2a,
0x22370,0x2236e,0x14a2b,0x2236d,0x2236f,0x22371,0x00000,0x14a29,
0xe256e,0x00000,0xe256d,0x00000,0x00000,0x14d35,0x14d36,0x14d33,
0xe2865,0xe2867,0x14d32,0x22a39,0x14d34,0xe2868,0x00000,0x00000,
0x15078,0xe2c48,0x22a38,0x22a3a,0x22a37,0x22a3b,0x15079,0x1553d,
0x22e77,0xe306c,0x22e79,0x1553b,0x22e7a,0x1553c,0x22e78,0xe306b,
0x22a36,0x2352b,0x2352e,0x2352f,0x2352c,0x15a2d,0x15a2c,0x15a2a,
0x15a2b,0x2352d,0xe3561,0xe3560,0x00000,0xe3b3f,0x15a2e,0xe3b40,
0xe3b3e,0x15f21,0x15f22,0x00000,0x15f23,0x24263,0x24265,0x24267,
0x1636e,0x1636d,0x15e7e,0x24266,0x24264,0xe6474,0x2497d,0xe4661,
0xe4660,0x2497b,0x24a23,0x16860,0x24a24,0x24a21,0x16861,0x2497c,
0x2497a,0x24a22,0x16c5a,0x2503c,0x2497e,0x16c5c,0x2503d,0x16c5b,
0x16c5e,0x2503e,0x16c59,0x16c5d,0x00000,0x2567d,0x2567b,0x2567a,
0x2567c,0x25679,0xe505c,0x00000,0x17833,0xe6475,0x26872,0x26873,
0xe5c3f,0x26b59,0x26d4d,0x17d22,0xe213f,0xe2361,0x14d37,0x14a2c,
0xe2869,0xe286b,0x1507a,0xe2c4c,0xe2c4b,0xe306e,0x1445c,0x1453d,
/* 0x5f00 */
0x00000,0x1464f,0x2223d,0xe256f,0x14a2d,0x22372,0xe286d,0x22a3c,
0x1507b,0x00000,0x16862,0x1445d,0xe2164,0xe2249,0xe2362,0x14822,
0x00000,0xe3b42,0x1636f,0x1445e,0x1453e,0x1453f,0x00000,0x14651,
0x14650,0x00000,0x2223e,0x14823,0x00000,0x22373,0xe2571,0x14a2e,
0x00000,0xe286e,0x22652,0x22653,0x22654,0xe2870,0x14d38,0x14d39,
0x22651,0x14d3a,0x00000,0x00000,0x00000,0x1507c,0x22a3d,0xe2c4d,
0x22e7c,0x1553e,0xe306f,0x22e7b,0xe3562,0x15a2f,0x23530,0x15a30,
0x23531,0xe3563,0xe3b47,0xe3b45,0x15f24,0x00000,0xe3b44,0x00000,
0x24268,0x00000,0xe4122,0x24a26,0x24a25,0x00000,0x16863,0x00000,
0x16c5f,0x2503f,0x17053,0x2567e,0x1735a,0xe5763,0x17b5f,0x26f27,
0xe2140,0xe2141,0xe224a,0xe2351,0x22655,0xe2871,0x22a3e,0x15a31,
0x23b58,0x16370,0xe4123,0xe505e,0x00000,0xe5764,0x17641,0x00000,
0xe6164,0xe2142,0x14a30,0xe2572,0x14a2f,0x1507d,0xe2c50,0x22e7d,
0x00000,0x15a33,0x15d29,0x15a34,0x15a32,0x15f25,0xe4124,0x24a27,
0x16864,0x16c60,0xe5f45,0x2212c,0x2223f,0x00000,0x22375,0x14a31,
0x22374,0x14a32,0x00000,0x00000,0x14d3e,0x22658,0x22657,0x14d3d,
0x14d3b,0x14d3c,0x22656,0xe2876,0xe2875,0x15121,0x22a3f,0x15124,
0x1507e,0x15126,0x15122,0x15123,0x15125,0xe6264,0xe3070,0xe3072,
0x15541,0x15540,0x1553f,0xe3071,0xe6476,0x00000,0x23533,0x15a35,
0x15a38,0x15a36,0xe6477,0x23532,0x15a3b,0x00000,0x15a37,0x23534,
0x15a3a,0x15a39,0x00000,0x00000,0x00000,0x23b5a,0x23b59,0xe3b4b,
0x15f28,0x15f26,0x15f27,0x23b5b,0x16371,0x2426a,0x16372,0x24269,
0x00000,0x00000,0x25040,0xe4663,0xe4664,0x16c62,0x24a28,0x16c61,
0xe4b72,0x16865,0xe6478,0x25722,0x25721,0x1735b,0x25c69,0x2654b,
0x26874,0x26875,0xe5e2f,0x14540,0x00000,0x14652,0x00000,0xe224d,
0xe6251,0x2215c,0xe224c,0x00000,0x14a34,0x14a36,0xe2578,0x22242,
0x22378,0x22377,0x22376,0xe2366,0x22241,0x22240,0x14825,0x14a35,
0x14a33,0x14824,0xe2367,0xe2369,0xe2577,0x14d3f,0x22659,0xe257b,
0x14d40,0x2237d,0x00000,0x22421,0x2237e,0x2265a,0xe2576,0xe2574,
0x2237a,0xe287e,0x14a3a,0x14a38,0xe257c,0x22379,0x2237b,0x22423,
0xe2622,0x14a37,0xe2621,0x2237c,0x22427,0x14d42,0xe257d,0x22424,
0x14a39,0xe2623,0x22422,0x22425,0xe257a,0x14d41,0xe2575,0x14d43,
0x22426,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0xe2878,
0xe2922,0x2266e,0x22661,0x2265f,0x2266d,0x22668,0x1512b,0x14d44,
0x22669,0x2266c,0x15127,0x2266b,0x14d45,0x14d4a,0x14d48,0x22662,
0xe6266,0x2265d,0x22664,0x14d4f,0x2266f,0x15128,0x22665,0x00000,
0x15129,0x14d4b,0x22667,0xe2c5a,0x22a4e,0x1512a,0x2265c,0x14d4c,
0x1512c,0x14d4d,0x14d49,0x14d4e,0x22666,0x2265b,0x2266a,0x14d46,
0xe2877,0xe2c5b,0x2265e,0x22663,0x22660,0x14d47,0xe287a,0x22a40,
0x00000,0x22a41,0x00000,0x00000,0x00000,0xe2921,0x00000,0x00000,
0x22a4b,0x22f23,0x22a4c,0x15132,0x22a4f,0x22a45,0x15131,0x22a47,
0xe6267,0x22a48,0xe2c60,0xe3079,0x22a4a,0x1512d,0xe2c56,0xe3073,
0x15545,0xe2c57,0xe2c5d,0x22a46,0x22a42,0x15546,0xe307e,0x00000,
0x22a50,0x15542,0x22f21,0x22a49,0xe2c54,0x22e7e,0x22a44,0x22a4d,
0xe2c5f,0xe2c61,0x15130,0x15543,0x15136,0x15544,0x22a51,0x22f22,
0x1512f,0x15548,0x15135,0x15134,0x15133,0x15547,0x22a52,0x15549,
0x1512e,0x00000,0x22a43,0xe307a,0xe3078,0xe307b,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0xe2c5c,0x00000,0xe3076,0x15a3c,
0x22f26,0x22f28,0x00000,0x22f2a,0x1554a,0x15550,0x23537,0x22f2e,
0x22f25,0x15a3e,0x23535,0xe3122,0x1554f,0x1554d,0x22f30,0x00000,
0x23536,0x00000,0x22f27,0xe3125,0x1554e,0x22f2b,0x15551,0x22f2d,
0xe3568,0xe3074,0x1554c,0x22f2c,0x22f2f,0x22f29,0xe3127,0x1554b,
0x15a3f,0xe3571,0x22f24,0x15a3d,0xe3572,0x00000,0xe3123,0xe3128,
0x15a40,0xe3121,0xe356f,0x00000,0x00000,0x00000,0xe3126,0x00000,
0x23539,0x23542,0x15f2b,0xe3b54,0x15a42,0x15a47,0x15f2c,0x23544,
0x15a4e,0x23b5d,0x2353a,0x15a46,0x15a49,0x15a44,0x23538,0x23546,
0x23549,0x23b6c,0x00000,0x23547,0x23b61,0x15a45,0x15a4c,0x15a50,
0x23541,0x23b5c,0x23545,0x15a41,0x23b5e,0x23548,0x23b60,0x2353d,
0xe356a,0x15f29,0xe3b56,0x2353b,0x2353c,0x15a4b,0xe3b55,0xe356e,
0x15a4a,0x2353f,0x15a4f,0x23543,0x15a48,0x23540,0xe3579,0x15a4d,
0x15f2d,0x15f2a,0x23b5f,0xe3b58,0x2353e,0xe3b59,0x15a43,0xe3576,
0x00000,0xe3b5a,0xe3b4d,0x00000,0x00000,0x00000,0xe3574,0x00000,
0x15f32,0x15f36,0x23b63,0x16377,0x15f34,0x23b67,0x15f38,0x2426b,
0x23b69,0x16379,0x15f30,0x15f33,0x23b6a,0xe3b5e,0x23b6b,0x23b71,
0x15f3a,0x1637a,0x00000,0x23b6d,0x23b72,0x23b66,0x16426,0xe3b4f,
0x1637b,0x15f39,0x23b64,0x23b73,0xe3b51,0x16425,0x15f37,0x16374,
0x23b70,0xe3b5d,0x15f3b,0x23b68,0x23b62,0x15f31,0x23b65,0x00000,
0x23b6e,0xe412b,0x16373,0x16378,0x15f2e,0x23b6f,0xe3b61,0x16376,
0xe3b62,0xe3b63,0xe3b50,0x15f2f,0x00000,0xe6479,0x00000,0x16424,
0x24a2a,0x24276,0xe4129,0x2426e,0x24a29,0x00000,0x24272,0x24274,
0xe4127,0xe412c,0x24271,0xe466f,0x16423,0x00000,0x24270,0x16427,
0xe466e,0x00000,0xe4128,0x24a39,0xe466c,0xe412e,0x16422,0x16867,
0x24277,0x24a2b,0xe466d,0xe412a,0x1637e,0x2426f,0x24273,0x16866,
0x16375,0x2426c,0x2426d,0x16868,0x1637d,0x16421,0x1637c,0x24275,
0xe647a,0x00000,0x24a2f,0x24a30,0x24a35,0x16c67,0x24a3c,0xe4b73,
0x1686e,0xe4b7e,0x1686d,0x24a37,0xe4b74,0x16c66,0x24a2c,0x1686c,
0xe4671,0x24a3b,0x1686a,0x1686b,0xe4b7c,0x24a38,0x25051,0x16c64,
0x15f35,0xe4672,0x24a3a,0x16c6b,0x24a32,0x00000,0x16c65,0xe466a,
0x16c6a,0x24a2d,0x24a31,0x24a2e,0x24a34,0x1686f,0x16c63,0x16869,
0xe4c21,0x25043,0x24a36,0xe4668,0x16c69,0xe4673,0x16c6c,0x00000,
0x24a33,0xe466b,0x16c68,0x25042,0x00000,0xe4c23,0xe4674,0xe4c24,
0xe4b77,0x25047,0x17057,0x25041,0x2572e,0x25050,0x16c70,0xe4b7a,
0x16c6e,0x17055,0x2504d,0x25049,0x16c74,0xe4b76,0x25725,0xe5068,
0xe4c28,0xe5067,0x16c72,0x25048,0xe4c29,0x25723,0xe4c25,0x2504c,
0x00000,0x2504f,0x25046,0xe4b79,0x16c73,0x00000,0xe4b75,0x16c6d,
0x25724,0x17056,0x2504e,0x16c6f,0x16c71,0x2504b,0x16c75,0x2504a,
0x25045,0x25044,0x17054,0x25052,0x25727,0x25c6b,0x17059,0xe5061,
0x2572d,0xe5063,0x2572b,0xe506a,0x25c6c,0xe5064,0x1705a,0x2572c,
0xe5066,0x25729,0x1735d,0x25c6a,0xe506c,0x25726,0x25728,0x1735e,
0x1705c,0x1735c,0x1705b,0x17360,0x2572a,0x17058,0xe5062,0xe5065,
0xe506b,0x00000,0x00000,0xe6679,0x00000,0x00000,0x2615b,0x00000,
0x26153,0xe5461,0xe545f,0xe545c,0xe545e,0xe545d,0x25c72,0x26154,
0x25c6e,0x00000,0xe545b,0x17642,0x25c70,0x25c6f,0x1735f,0x25c6d,
0x25c71,0x2615c,0x26158,0x2615a,0x00000,0x26155,0x26156,0x00000,
0x26159,0x26157,0x17834,0xe5765,0x00000,0x17837,0x17836,0x17835,
0x1796c,0x26876,0x1796d,0x2654c,0x17a6a,0x26b5a,0x17a6b,0x17b60,
0x17c36,0x26f28,0xe5f46,0x26f29,0x26f2a,0xe613e,0x00000,0x2722a,
0x14541,0x2215d,0x14653,0x00000,0x14827,0x14828,0x14826,0xe236b,
0x14829,0x14a3c,0x14a3b,0xe2625,0x22670,0x14d51,0x14d50,0x00000,
0xe2c63,0x22f31,0x15a51,0x15a52,0x00000,0x00000,0xe3b64,0x15f3c,
0x24278,0x16428,0x16429,0x2427a,0x2427c,0x2427b,0x00000,0x24a3e,
0xe4676,0x24a3d,0x16870,0x24a3f,0xe4675,0x25053,0x16c76,0xe4c2c,
0x1705d,0xe506d,0x17361,0x17643,0x17362,0xe5f48,0x14542,0xe2165,
0xe2166,0xe224e,0x22428,0xe2628,0xe2629,0x22671,0x14d53,0x14d52,
0x14d54,0x15137,0x22a53,0x22a54,0x00000,0xe3129,0x22f32,0x15552,
0x15a53,0x15f3d,0x23b74,0x14543,0x00000,0x1445f,0x14544,0xe2250,
0x2215e,0x14657,0x14656,0x14654,0x14655,0x00000,0x00000,0xe236f,
0x1482c,0x22249,0x2224b,0x1482b,0x22243,0xe236c,0x22244,0xe236d,
0x2224a,0x22246,0x22248,0x1482a,0x22245,0x2224c,0x22247,0xe236e,
0x00000,0x00000,0x00000,0x00000,0x00000,0x14a43,0x14a4c,0x14a4a,
0x22432,0x2242f,0x22437,0x14a48,0x22438,0xe2639,0x14a41,0x22435,
0xe262e,0x14a47,0x22431,0x22430,0x14a45,0x22436,0x14a46,0x14d55,
0x14a40,0x22433,0xe262a,0x22429,0x14a3d,0xe2637,0x14a50,0x2242e,
0x22434,0x14a42,0x14a44,0xe262f,0x2242a,0xe2636,0x2242b,0x2242c,
0x00000,0x14a4f,0x14a49,0x14a4e,0x2242d,0x14a4d,0x14a3f,0x14a3e,
0x14a4b,0xe2635,0x00000,0xe2633,0xe2634,0xe2638,0xe2631,0x00000,
0x00000,0x00000,0x00000,0xe647b,0x00000,0xe2632,0xe2931,0xe292a,
0x14d63,0x2267d,0x22676,0x14d5e,0x14d71,0x22672,0x22679,0x2267b,
0x2267e,0x14d6c,0xe2926,0x2267a,0x22673,0x14d6a,0x22677,0xe2928,
0x22721,0x14d5b,0xe2925,0x2267c,0x14d65,0x14d64,0x22675,0x14d59,
0xe2934,0xe2932,0x14d5a,0x00000,0x14d58,0xe2933,0x14d70,0x14d68,
0x14d62,0x14d56,0x22678,0x14d61,0x14d57,0x14d69,0x14d72,0x22a55,
0x14d66,0x22674,0x14d5c,0x14d5f,0x14d60,0xe292e,0x14d6e,0x14d6f,
0x14d6d,0x14d67,0x14d6b,0x14d5d,0x15138,0xe2930,0xe2937,0xe2935,
0xe2936,0xe292f,0x00000,0x00000,0xe2929,0x00000,0x00000,0x00000,
0x00000,0x00000,0xe2c6d,0x22a5b,0x15144,0x1513c,0x1513e,0x15143,
0x22a67,0x15141,0x22f33,0x15553,0x15146,0x22a58,0x22a60,0x15142,
0x22a5f,0x22a5c,0x22a64,0x22a66,0x1513b,0x1513f,0x15145,0x15555,
0x22a61,0x1513d,0x15148,0x22a5a,0xe2c6f,0xe2c70,0x00000,0x15140,
0x15554,0x1513a,0x00000,0x22a57,0x22a5e,0x22a56,0x22a59,0x22a5d,
0x22f34,0x15147,0x00000,0x22a62,0x22a63,0x22a65,0x15139,0xe2c6c,
0x00000,0xe3132,0x00000,0xe3133,0x00000,0x00000,0x00000,0xe2c6b,
0x00000,0xe2c6e,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x15563,0x22f40,0x15561,0x15562,0x22f36,0x22f46,0xe312c,0x15558,
0xe312f,0xe3135,0x2354a,0x22f48,0x22f42,0xe3138,0x22f39,0xe3137,
0x22f4b,0x22f3c,0x1555e,0x23561,0x22f3f,0x15560,0x15557,0xe313c,
0x22f4d,0x22f41,0x1555a,0x22f3a,0x22f37,0x22f38,0x1555b,0x22f47,
0x22f4e,0x1555d,0x22f3e,0x22f3d,0x15565,0x15564,0x15556,0x1555c,
0x1555f,0x22f4a,0xe312e,0xe3139,0x22f44,0x15559,0x22f35,0x22f4c,
0x22f43,0x22f45,0x22f49,0xe3130,0xe313b,0xe3136,0x00000,0x00000,
0xe647c,0x00000,0x00000,0x00000,0xe647d,0x2354b,0xe3631,0x15a5b,
0x15a6f,0x15a6e,0xe3627,0x15a63,0xe3629,0x2355d,0x23559,0x23556,
0x23568,0x15a5e,0x15a56,0xe3626,0xe3632,0x2355b,0x15f4d,0x15a5a,
0x23563,0xe3622,0x15a70,0x15a6d,0x2355f,0x2354e,0xe357c,0xe362b,
0x15a6c,0x23565,0x2354d,0x15a61,0x15a65,0x23564,0xe3623,0x23557,
0x15a66,0x15a60,0x2354c,0xe357d,0x15f3f,0x23567,0x23555,0x15a6b,
0x23558,0x23566,0x15a6a,0xe3624,0x23b75,0x00000,0x15a57,0x23553,
0x15a5c,0x15a67,0x00000,0x15a62,0x2355c,0x23552,0x23550,0x23562,
0x15a54,0x15a68,0x15a58,0x15f3e,0x23560,0x15a59,0x00000,0x15a55,
0x15a64,0x15a5f,0x15a5d,0x23554,0x15a69,0x23551,0x2355e,0x2355a,
0x23b77,0x23b76,0xe362d,0x00000,0x00000,0x00000,0xe647e,0x00000,
0x00000,0x00000,0xe362e,0x00000,0x00000,0x2354f,0x23c29,0xe3b71,
0x15f41,0xe3b70,0x23c2f,0x23b7c,0x23c2c,0x2427d,0x15f44,0x23c30,
0x23c33,0x15f43,0x23c21,0x23c32,0x23c31,0x15f45,0x23b78,0x15f40,
0x15f48,0xe3b73,0x15f46,0x23c2e,0x00000,0x23c24,0x15f4a,0x23c35,
0x23c2d,0x23c36,0x15f52,0x15f50,0x23c2b,0x23c2a,0xe3b67,0x23c28,
0x23c22,0x15f49,0xe3b66,0x15f47,0x22f3b,0x23b79,0xe3b68,0x2433d,
0x23b7a,0x15f42,0x15f4f,0x24321,0x00000,0x15f4b,0x15f4c,0x23b7b,
0x23c34,0x2427e,0x23c25,0x23b7e,0x15f4e,0x23c26,0x23c23,0xe3b72,
0xe3b6d,0x15f53,0xe6339,0x00000,0x00000,0x00000,0xe3b6f,0x00000,
/* 0x6400 */
0x00000,0x00000,0x00000,0xe6521,0x00000,0x00000,0x16438,0xe4149,
0xe4132,0x24324,0x24337,0x2433c,0x24330,0x16434,0x24341,0x16431,
0x24322,0xe413a,0x24323,0x1642a,0x16433,0x2432a,0x16436,0x16437,
0x2432b,0xe4138,0x24338,0x2433e,0x16432,0xe413e,0x1642c,0x24329,
0x24325,0x24340,0x2432e,0x2432f,0x24326,0x2433a,0x24331,0x2433b,
0x24333,0xe413d,0x1642d,0x24a40,0x16430,0x1642e,0x2433f,0x24336,
0x24332,0xe4136,0xe4133,0x24327,0x1687a,0x24335,0x16435,0x2432d,
0xe4134,0x2432c,0xe4148,0xe4725,0xe4142,0x1642f,0x1642b,0x24a55,
0x24339,0x24334,0x00000,0x24328,0x00000,0x00000,0xe4144,0xe4145,
0x00000,0xe6676,0x00000,0x24a50,0xe4678,0x24a41,0x24a4c,0xe4728,
0x24a53,0x16878,0x15f51,0x24a51,0x16873,0xe467e,0xe4724,0xe467a,
0x16872,0x24a58,0x00000,0x24a42,0x24a4f,0x24a43,0x24a4e,0x16876,
0x24a52,0x23c27,0xe4721,0x00000,0xe472a,0x24a59,0x24a4a,0x16879,
0x25061,0x16c77,0xe4723,0x24a57,0x24a56,0x1687b,0x25054,0x16c78,
0x25055,0xe4722,0x24a46,0x24a47,0x24a44,0x24a49,0x24a45,0x24a5a,
0x16875,0x16c79,0x16877,0x1687c,0xe467b,0x24a48,0xe4729,0x24a54,
0xe4c2d,0xe4726,0x24a4d,0xe4c35,0x00000,0x25058,0xe4c38,0x16871,
0x16c7c,0x25735,0x2505d,0x2505c,0x2505e,0xe4c30,0xe4c2f,0x2505b,
0x16c7d,0xe4c3b,0x16d25,0x16d22,0xe4c31,0x16d23,0x25056,0x25059,
0x25063,0x16d2b,0x16d29,0xe4c2e,0x2505a,0x23b7d,0x16c7a,0x25060,
0x25057,0xe4c3e,0x16d2c,0x2505f,0x16874,0x16d21,0x24a4b,0xe4c3f,
0xe4c34,0x16d24,0xe4c3d,0x16d28,0x16d2a,0x16d27,0x16d26,0xe4c3a,
0x16c7e,0x25062,0x16c7b,0x16d2d,0xe4c39,0x00000,0xe6522,0x00000,
0x00000,0xe4c37,0x00000,0x17061,0x17062,0x25734,0x1706b,0x17068,
0xe5070,0x1705f,0x17066,0x25736,0x17064,0x1705e,0xe4c32,0x17065,
0xe5077,0x25733,0x17364,0x17060,0x00000,0x17067,0x17363,0x25732,
0x25731,0xe5076,0x17069,0xe506f,0x1706a,0xe5079,0x25730,0x2572f,
0x17365,0x25739,0x17063,0x25737,0xe5075,0x00000,0x00000,0xe5464,
0x17366,0xe5467,0x1736b,0x25c75,0x25c77,0xe576b,0x17368,0xe576d,
0x25c78,0x25c74,0xe576c,0x25c76,0x17369,0x1736c,0xe5469,0x25c73,
0x17367,0x1736a,0x17645,0x25738,0x17644,0x00000,0xe576a,0x1764a,
0x26160,0xe5770,0x17648,0x17649,0x26163,0x2615f,0x17646,0x2615d,
0x17838,0x26161,0x00000,0x26162,0x2615e,0xe576e,0x17647,0x2654d,
0xe5a3b,0x26550,0xe5a3c,0xe5a3a,0x26551,0x2654f,0x26552,0x17839,
0x2654e,0xe5e31,0x00000,0x2687a,0x1796f,0x26879,0x26878,0x26877,
0x1796e,0x17970,0xe6523,0x26b5b,0x17a6d,0x17a6c,0xe5f4a,0xe5f4b,
0x26d4f,0x26d4e,0x26d51,0x17c37,0x17b61,0x26f2c,0x26d50,0xe5f49,
0xe6032,0x26f2b,0x17c39,0x17c38,0x17c5f,0x27037,0x2707d,0x14545,
0x00000,0xe2c72,0x23c37,0x2573a,0xe2167,0xe2168,0x1482d,0x2224d,
0x14a53,0x14a51,0x00000,0x14a52,0x00000,0x22722,0x14d73,0x15149,
0xe2c74,0x22a68,0xe2c76,0x22a69,0xe2c73,0x1514a,0x22f50,0x00000,
0x15566,0x15567,0x22f4f,0xe313d,0x00000,0xe3637,0xe3636,0x15a77,
0x00000,0x15a73,0x00000,0x23569,0x15a7a,0x15a79,0x15a72,0x15a75,
0x15a78,0x15a74,0xe3634,0x00000,0x23c3b,0x15a71,0x15f54,0xe3b74,
0xe3b75,0xe3b76,0x15f56,0x15f57,0x23c3a,0x23c3d,0x15f55,0x23c38,
0x23c3c,0x00000,0x23c39,0xe414b,0x16439,0xe414e,0xe6346,0x24342,
0xe414d,0xe4730,0x1687d,0x24a5b,0x1706c,0x16d2e,0x25064,0x16d2f,
0x16d30,0x25066,0x25065,0x25067,0x2573c,0x00000,0x00000,0x2573b,
0x25c7a,0x25c79,0x1736d,0x1736e,0x26553,0xe5c41,0x00000,0x14546,
0xe2558,0xe2939,0x00000,0xe3140,0x23c3e,0xe3638,0xe3639,0x00000,
0x15f59,0x15f58,0x24343,0x00000,0x26164,0x17a6e,0x26f2d,0x14547,
0x00000,0x15568,0xe3142,0x15a7c,0x15a7b,0x23c3f,0x23c40,0x1643a,
0x24a5c,0x1687e,0x2573d,0x00000,0x14548,0x14658,0xe293b,0x14d74,
0x22723,0x00000,0x22a6a,0x1514b,0x15a7d,0xe363a,0x23c41,0x15f5a,
0x1643b,0x00000,0x25068,0x25069,0x00000,0xe546b,0x25c7b,0x1764b,
0x2707e,0x14549,0xe293c,0x22724,0x14d75,0x1514c,0xe2c77,0x22a6b,
0x00000,0x15569,0x22f54,0x22f52,0x22f53,0x1556a,0x22f51,0xe363c,
0x00000,0xe363f,0xe363d,0x15b21,0x15b22,0x2356a,0x15b23,0x15a7e,
0x23c42,0xe3b79,0x23c43,0x24344,0x00000,0x00000,0x16922,0x16921,
0x00000,0x00000,0x25c7c,0x26165,0xe5a3f,0x26555,0x26554,0x2687b,
0xe2169,0x2213e,0x1514d,0xe3641,0xe4150,0x1454a,0x14659,0xe2251,
0x1482f,0x1482e,0xe2373,0xe2372,0x14830,0x14831,0x2224f,0x2224e,
0x22439,0x14a54,0x2243c,0x2243b,0x2243a,0x2243d,0xe263d,0x00000,
0x00000,0xe625e,0x14d76,0x2272a,0x22726,0x2272f,0xe2943,0xe293e,
0x14d7d,0xe2942,0x14d7b,0x2272b,0x22727,0x2272e,0x14d7a,0x14e23,
0x22729,0x22725,0x14e22,0x2272c,0x14d79,0x2272d,0x14d7c,0x14d7e,
0x22731,0x22730,0x22728,0x14d78,0x14d77,0x14e21,0x00000,0xe2940,
0xe2941,0x00000,0xe2c7e,0xe2c7a,0x22a70,0x22a76,0xe2d23,0x15153,
0x15150,0x22a6d,0x22a72,0xe2c7c,0x15156,0x1514e,0x22a71,0x15151,
0x15154,0xe2c79,0x00000,0x22a74,0xe2c7d,0x1514f,0x22a79,0x15152,
0xe2d21,0x15155,0x22a6e,0x22a73,0x22a77,0x22a6f,0x22a6c,0xe2d24,
0xe2d25,0x22a78,0x22a75,0xe2d22,0xe2c37,0x00000,0x00000,0x00000,
0xe3146,0x15572,0x1556b,0x1556e,0xe314c,0x15571,0xe3144,0x22f57,
0xe3149,0x1556c,0x22f55,0xe3148,0x15570,0xe314d,0xe3145,0x1556d,
0xe3143,0x22f58,0x1556f,0x00000,0x00000,0x00000,0x00000,0xe3642,
0x00000,0x2356e,0x15b25,0x2356d,0x2356f,0x15b24,0x15b29,0x22f56,
0xe314b,0x2356c,0x23570,0xe3644,0x15b26,0x2356b,0x15b28,0xe3645,
0x15b27,0xe3c26,0x23c4a,0xe3b7d,0x23c45,0xe3c25,0x15f5b,0x15f5f,
0x15f5c,0x23c48,0x23c4b,0xe3c23,0x15f5d,0x00000,0x15f5e,0x15f63,
0x2434d,0x23c49,0x15f61,0x23c46,0x23c44,0xe3b7c,0x15f62,0xe3b7e,
0x23c47,0xe3c24,0x00000,0x00000,0x16441,0x00000,0x24345,0x1643e,
0x1643f,0x1643d,0x2434a,0x24349,0x24346,0x16443,0xe415b,0xe4156,
0x24348,0x15f60,0xe4159,0xe4151,0x2434c,0x24347,0x16440,0x1643c,
0x16442,0x2434b,0xe4734,0x00000,0xe4735,0x16925,0x00000,0x24a5f,
0x24a5e,0x24a5d,0x16923,0x00000,0xe4739,0xe4733,0xe4737,0x00000,
0x16924,0x2506c,0x2506f,0x16d32,0xe4c44,0xe4c46,0x16d31,0x25070,
0x2506b,0x16d34,0x2506d,0xe4c41,0x16d33,0x2506a,0xe4c40,0x2506e,
0x17072,0x1706f,0x25746,0x25745,0xe4c43,0x25744,0x2573f,0xe507d,
0x25740,0xe5123,0x00000,0xe507a,0x17070,0xe507e,0x1706d,0x17071,
0x2573e,0x1706e,0x25741,0x25742,0x25747,0xe5122,0xe5471,0x25743,
0xe546f,0xe5470,0x25c7d,0x00000,0xe546c,0xe546d,0x17370,0xe5472,
0x26168,0x1736f,0x26166,0x26167,0x1764c,0x1783b,0x26556,0xe5a43,
0x1783a,0xe5a42,0xe6526,0x2687d,0x2687e,0xe5c42,0x17971,0xe5c43,
0x2687c,0x17a6f,0x00000,0x26f2e,0x17c3a,0x27038,0x27039,0xe613f,
0x1454b,0x00000,0x14832,0x14833,0x14a55,0xe2641,0x22732,0x15157,
0x15573,0x15b2a,0x00000,0x00000,0x15937,0x00000,0x15f64,0x15f65,
0x15e32,0x23c4c,0xe6527,0x16444,0x24a61,0x24a60,0xe5124,0x00000,
0x1454c,0x14834,0x22733,0x14e25,0xe2945,0x14e24,0xe2d27,0x22a7a,
0x22a7b,0xe6632,0x22f59,0x22f5a,0x15574,0x15575,0xe3648,0x15576,
0x23571,0xe3647,0xe3646,0x15b2c,0x00000,0x15f67,0xe3c29,0x15f66,
0x2434e,0x24641,0x24a62,0x25748,0xe5126,0xe6633,0x1764d,0x17972,
0x1454d,0x00000,0x1465c,0x1465d,0x1465b,0x1465e,0x1465a,0xe2252,
0x00000,0x14837,0xe2377,0x22257,0x14836,0x14838,0xe2378,0xe2375,
0x22252,0x22251,0x22254,0x22253,0x22256,0x14835,0x22250,0x22255,
0x00000,0x00000,0x00000,0x00000,0xe2648,0x2243e,0x14a5f,0x2243f,
0x22443,0x14a5e,0xe2649,0x22447,0x22442,0x22445,0x14a57,0x14a58,
0x14a59,0x14a5a,0xe2645,0x14a61,0xe2644,0x22441,0x14a5c,0x14a62,
0xe2647,0x22440,0x22446,0xe2642,0x14a5b,0x22444,0x14a5d,0x14a56,
0x14a60,0xe264a,0x00000,0x00000,0x00000,0xe6257,0x00000,0x00000,
0x00000,0x00000,0x14e3a,0xe2947,0x22735,0x14e26,0x00000,0x14e30,
0x14e31,0x14e29,0x14e3b,0x14e2b,0x2273d,0x14e36,0x22738,0x14e2c,
0x22747,0x22748,0x22740,0x22739,0x14e39,0x22745,0x14e34,0x14e32,
0xe2952,0x22746,0xe2949,0x22744,0x2273c,0x22734,0x2273b,0x14e2d,
0xe625f,0x14e33,0xe294a,0x14e27,0x2273f,0x2273e,0x22736,0xe294f,
0x14e35,0x22742,0x22737,0x14e38,0x22749,0x14e28,0xe2948,0x14e2f,
0x2273a,0x22743,0x14e37,0x00000,0x14e2a,0x14e2e,0x00000,0x22741,
0x00000,0x00000,0xe294e,0xe294c,0xe6528,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0xe6529,0x00000,0x22b3d,0x1515f,
0x1516c,0xe2d36,0x22b38,0x22b2e,0x15165,0x22b2c,0x1515e,0x22b27,
0x15168,0x22b34,0x22b21,0x22b23,0xe2d2e,0x00000,0x00000,0xe2d30,
0x22b26,0x22a7c,0x22b33,0x22b43,0x15163,0x22b28,0x22b3a,0xe2d2d,
0x22a7e,0x22b41,0x22b42,0x22b45,0x22b3c,0x22b2d,0x22b35,0x15169,
0x1515c,0x15164,0x15170,0x15159,0x1515b,0xe2d31,0xe2d2b,0xe2d3a,
0x22b25,0x1516d,0x15166,0x22b3f,0x22b22,0x1516f,0x1516a,0x22b2b,
0x00000,0x00000,0x1516e,0x22b32,0x22b2a,0x15167,0x22b3e,0x22b36,
0xe2d2a,0x15161,0x22b44,0x22b29,0x1515d,0x22b3b,0x22b31,0x15162,
0x22b37,0x1515a,0x22a7d,0x1516b,0x15627,0x15160,0x22b30,0x22b2f,
0x22b24,0xe2951,0x22b40,0xe2d34,0x22b39,0x00000,0xe2d32,0x15158,
0xe2d39,0xe2d37,0x00000,0x00000,0x00000,0xe2d38,0xe652b,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0xe652a,0x00000,0x22f6e,0x1562e,0x22f6f,0xe315d,0x22f63,0x15623,
0x1562f,0xe3157,0x22f5c,0xe3153,0x22f65,0x22f6d,0xe315b,0x22f5b,
0x22f76,0x15577,0xe315e,0xe3164,0xe3150,0x22f75,0x22f70,0xe315f,
0x22f71,0x15621,0x1562c,0x22f67,0xe3156,0x22f68,0x22f72,0x22f69,
0xe3163,0x22f64,0x22f5e,0x22f5f,0x22f6c,0x22f66,0xe3154,0xe314f,
0x15578,0x1557c,0x22f74,0x22f60,0x1562a,0x15626,0xe315a,0x00000,
0x15629,0x15630,0x1557d,0x1562b,0x22f6b,0x1562d,0x1557a,0xe3159,
0x15579,0x22f5d,0x00000,0x22f61,0x15624,0x22f73,0x22f6a,0x22f62,
0x15628,0x15625,0xe2d2f,0x1557b,0x1557e,0xe3162,0xe3158,0x00000,
0xe3161,0xe3160,0xe652d,0x00000,0x00000,0x00000,0xe652c,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x23628,0xe3655,0x23576,0x23577,0x2357b,
0xe3660,0x2362c,0x23629,0xe364e,0x23622,0x23621,0x15b33,0x23625,
0x23634,0x23572,0xe365b,0x23635,0x23627,0x23639,0x2362d,0x15b32,
0x2362b,0x15b2d,0x15b42,0x15b38,0xe3657,0x15b3c,0x15b3b,0x23573,
0x00000,0x23632,0x23638,0x23630,0x23637,0x00000,0xe3651,0x23624,
0x23574,0x23636,0x23626,0x15b30,0x15b3d,0xe365a,0x2362f,0x15b36,
0xe364d,0xe365c,0xe3650,0x2362e,0x23575,0x15b3e,0xe364b,0x15b40,
0x23631,0x15b41,0x15b2f,0x2357c,0x23633,0xe3654,0xe3478,0x15b35,
0x15b3f,0x2357e,0x2362a,0x23579,0x2357d,0x15b3a,0x23578,0x15b2e,
0x15b37,0x15b34,0x23623,0x15622,0x23c63,0x15b31,0xe364c,0xe3652,
0xe365e,0xe365f,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0xe3656,0x00000,0xe3c45,0x15b39,0xe3c41,0x23c66,0x23c7c,
0x23c71,0x15f7b,0xe3c38,0x15f76,0x23c60,0x15f77,0x23c70,0xe3c3e,
0x23c69,0x23c76,0x15f73,0x23c4e,0x23c78,0x15f69,0x23c56,0x15f6c,
0x15f6b,0x00000,0x15f7c,0xe3653,0x23c50,0x23c72,0x23c73,0x15f6e,
0x15f6a,0x23c5e,0xe3c3d,0x15f75,0x23c59,0xe3c32,0x23c74,0x15f71,
0x23c6c,0x23c79,0x23c53,0x23c58,0x23c52,0xe3c2a,0x15f70,0x23c65,
0x24364,0x23c54,0x15f74,0x23c5d,0x23c75,0x15f6f,0x23c5a,0x23c57,
0x23c68,0x15f72,0x15f68,0x15f7e,0x23c6b,0x23c6a,0xe3c31,0xe3c42,
0xe3c39,0xe3c3b,0xe3c34,0xe3c2f,0x23c4f,0x15f6d,0x23c77,0x23c5f,
0x23c61,0xe3c37,0x23c6e,0x23c6d,0x23c4d,0x15f78,0x15f7a,0x23c55,
0x23c5c,0x23c64,0x15f79,0x23c5b,0x23c67,0x23c7a,0x00000,0x23c6f,
0xe3c3c,0x00000,0x00000,0x00000,0xe3c44,0x00000,0xe3c33,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x23c7b,0x00000,0x00000,
0x00000,0xe652f,0x23c51,0x00000,0xe652e,0x00000,0xe3c40,0x24378,
0x1644c,0xe4165,0x24376,0x24361,0x24366,0x2435f,0xe4177,0x24372,
0x24351,0x24358,0x00000,0x24370,0x2437a,0x24362,0xe4168,0x24355,
0x24368,0x2436d,0x24359,0xe416b,0x2436a,0x24356,0xe415d,0xe4175,
0x2435d,0x2435e,0x1644e,0x24371,0x2436f,0xe4173,0x24352,0x24374,
0xe4174,0x24375,0x24377,0x16452,0x1644a,0xe416f,0x2357a,0x2435a,
0x2436c,0x2435b,0x16447,0x16457,0x24373,0x16455,0x16451,0x24350,
0x16449,0xe4179,0x24353,0x16456,0xe4178,0x24363,0x2434f,0xe4176,
0x1644f,0x24367,0x24357,0x16450,0x24360,0x16446,0x15f7d,0x24369,
0x23c62,0x24354,0x00000,0xe416d,0x2436e,0x1644b,0x2436b,0x16448,
0x24365,0x16453,0x2435c,0x24379,0xe416a,0xe417b,0x00000,0x00000,
0x00000,0x00000,0x1644d,0x2452c,0x00000,0xe4172,0x16454,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x24a70,0x24a6e,0xe473a,
0x24b26,0x24a6c,0xe473d,0x24a7e,0x16445,0x16928,0x24a68,0x24b25,
0xe4751,0x24a6d,0x24a7b,0x1692d,0x16926,0xe474e,0x24b23,0xe4746,
0x24a66,0x24b22,0xe4747,0x16938,0x24a77,0x24b29,0x16936,0x24a6f,
0x16927,0x24a71,0x24b21,0x16930,0x24a6a,0x16934,0x1692a,0x24a73,
0x24a69,0x24a63,0xe473e,0x24a7d,0x16931,0x24b28,0x24a64,0x1692e,
0x00000,0x24a79,0xe6352,0x1692f,0x24a6b,0x24a76,0x24a72,0x24a74,
0xe4743,0x16929,0x24b27,0x16937,0x24a75,0xe473b,0x24b2a,0x00000,
0xe473c,0x24a65,0x24a7a,0x1692c,0x16935,0x16933,0x24a67,0x24a7c,
0x16932,0xe4745,0xe4748,0x1692b,0x24a78,0xe474d,0xe4744,0x00000,
0xe4c54,0x24b24,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0xe474c,0x2507c,0xe4742,0x25078,0x25074,0x2512a,0x25127,
0x16d37,0xe4c64,0xe4c60,0x2512e,0x2507b,0x16d42,0x25124,0xe4c4f,
0xe4c51,0x25077,0x25123,0x16d3f,0x25137,0x00000,0x25134,0x25126,
0x25075,0xe4c5f,0xe4c57,0x2512b,0x2512d,0x16d3b,0x25121,0x2507a,
0x25071,0x16d38,0x16d40,0x00000,0x25130,0x16d41,0x25072,0x25136,
0x25129,0x2512f,0x16d3e,0xe4c4d,0xe4c50,0x2512c,0xe4c47,0x25133,
0xe4c5b,0x16d43,0xe4c56,0x16d3d,0x25125,0x25076,0x25138,0x25073,
0x25131,0x16d3a,0xe4c4a,0x2507d,0xe4c49,0x2507e,0x16d39,0x16d36,
0x25079,0x16d3c,0xe4c52,0x16d35,0xe4c62,0x25132,0x25135,0x25122,
0x25755,0xe4c5e,0xe4c59,0x00000,0xe4c61,0xe6530,0x00000,0x00000,
0x00000,0x00000,0x2574d,0xe512c,0x25749,0x17121,0xe513c,0xe5138,
0x17074,0x17079,0x17075,0x25757,0x25762,0x17073,0x2574f,0x25758,
0x25128,0x25759,0xe5128,0xe512b,0x1707a,0xe5140,0x25768,0x1707e,
0x17123,0x2574b,0xe513b,0x1707d,0xe5131,0x25766,0x25767,0x2575d,
0x2575c,0x25754,0xe5129,0xe513e,0x2575e,0x25765,0x25764,0xe512f,
0x17078,0x17076,0x25756,0x25753,0xe5144,0x25750,0x25763,0x17122,
0x25761,0x1707c,0x1707b,0xe5127,0x2575b,0x00000,0x2574a,0x2574c,
0x2574e,0x25760,0x2575a,0x17077,0xe512e,0x25751,0xe5132,0x2575f,
0xe5141,0xe513a,0x00000,0x00000,0x00000,0x00000,0x25752,0xe6531,
0x00000,0x00000,0xe6532,0x00000,0x00000,0xe5475,0x17378,0x25d31,
0x17371,0x25d22,0xe547b,0x25d2d,0x17373,0x25d34,0xe5521,0x25d29,
0xe547c,0x25d24,0xe5476,0x00000,0x25d35,0x25c7e,0x25d2b,0xe5527,
0x1737a,0x25d30,0x25d36,0x25d2a,0x17372,0x25d2c,0x25d21,0x17379,
0xe5523,0xe547a,0x25d33,0x25d26,0x17375,0xe5524,0x25d28,0x25d25,
0x1737b,0x25d27,0x17374,0x17377,0x25d2f,0x25d23,0x25d32,0xe5478,
0x25d2e,0x00000,0xe5529,0xe5774,0x1764f,0x26173,0x17654,0x17655,
0xe5777,0xe5821,0xe5776,0x1764e,0x26172,0xe5778,0x2616f,0x26170,
0x17652,0x2616a,0x2616e,0x17651,0xe577e,0x2616b,0xe5779,0xe5823,
0xe577d,0xe577a,0x17653,0x17650,0xe5822,0x26169,0x2616d,0x26171,
0xe577b,0x00000,0xe6533,0x2655c,0x26559,0x26562,0xe5a44,0x26561,
0x2655f,0x2655a,0xe5a4f,0x1783f,0xe5a45,0xe5a4e,0x00000,0xe5a47,
0xe5a4d,0x2655b,0x1783e,0x17376,0x2655e,0x1783d,0x26563,0x2655d,
0x26558,0x2616c,0xe5a48,0xe5a46,0x00000,0x1783c,0xe6534,0x26557,
0x26924,0xe5c49,0x26923,0x26560,0x17973,0xe5775,0x26927,0x26928,
0x26922,0x26926,0x00000,0x26921,0xe5c47,0xe6535,0x00000,0x00000,
0x26b5f,0x26925,0x17a72,0x17a70,0x26b5d,0xe5e35,0xe5e34,0xe5e33,
0x26b60,0xe5e37,0x26b5c,0x26b5e,0x17a71,0x00000,0xe5f4f,0xe5f4e,
0x26d53,0x26d54,0x17b62,0x26d52,0x00000,0xe6536,0xe6537,0x26f31,
0x17c3b,0x26f2f,0x26f30,0x2703a,0xe6074,0x00000,0x17d23,0x27123,
0x27121,0x27122,0x27124,0xe6140,0xe6165,0xe6141,0x2722b,0x00000,
0x1454e,0x14839,0xe2379,0x14e3c,0x00000,0x2274a,0xe2953,0xe2954,
0x22b46,0xe6269,0xe2d3c,0xe3166,0x22f77,0x22f79,0xe3165,0x22f78,
0xe3167,0x22f7a,0x15b43,0x2363b,0x22f7b,0xe3662,0x2363a,0x2363c,
0x2363d,0x23c7d,0x16022,0x23c7e,0x23d22,0x16023,0x16021,0x23d21,
0xe417d,0x24422,0x2437e,0x2437d,0xe417c,0x2437c,0x2437b,0x16458,
0x24421,0x16939,0x24b2b,0x24b2d,0x1693a,0x24b2c,0x16d45,0xe4c66,
0x16d44,0x25139,0xe4c65,0xe4c67,0x2576a,0x25769,0x2576b,0xe5146,
0xe5145,0x17124,0x00000,0x25d37,0x1737c,0xe552b,0x26174,0x17656,
0x26564,0x17b63,0x1454f,0x1465f,0x1483a,0x14a63,0x14e3d,0x14e3e,
0xe2955,0xe2956,0x15171,0xe2d3d,0xe3168,0x22f7c,0xe3c49,0xe3c47,
0x00000,0xe417e,0x16459,0xe4221,0xe4753,0x00000,0x25259,0x17125,
0x17657,0x14550,0xe2253,0x1483b,0x00000,0x00000,0x2274c,0x14e3f,
0x2274b,0xe2958,0x22b47,0x15172,0x22b48,0x00000,0x15173,0x00000,
0x22f7e,0x15632,0x15631,0xe316a,0x23642,0x23640,0x23641,0x2363f,
0xe3664,0x2363e,0x00000,0x00000,0x23d23,0x23d26,0x16025,0x23d24,
0x16024,0x23d25,0x00000,0x24423,0xe4222,0xe6354,0x24b2e,0x24b2f,
0x24b30,0xe4754,0x2513c,0x2513b,0x16d46,0x2513a,0x2513d,0x2576c,
0x00000,0x00000,0x2576d,0x2576e,0x00000,0x25d38,0x1737d,0x17658,
0x26565,0x00000,0x17a73,0x2213f,0xe2959,0x15174,0x22b49,0x15633,
0x00000,0x00000,0x15b44,0xe3665,0x16026,0x23d27,0xe3c4b,0x1645b,
0x1645a,0xe4226,0x00000,0x24b31,0x24b32,0x16d47,0x16d48,0x25770,
0x2576f,0x26175,0x26f32,0x14551,0x22140,0x14660,0xe237a,0x14a64,
0x22448,0xe295a,0x15175,0x1645c,0x14552,0x00000,0x22b4a,0x15176,
0x22b4b,0x00000,0x1737e,0x14553,0xe6538,0xe6539,0x2274d,0x00000,
0x22b4c,0xe2d42,0x23025,0x23024,0x23022,0xe316e,0x23021,0x23026,
0x23023,0xe316c,0xe316d,0x15b45,0x15b46,0xe3666,0x00000,0x16027,
0x23d28,0x00000,0x23d29,0x23d2a,0xe3c4d,0x00000,0xe653a,0x24427,
0x24428,0x24426,0xe4228,0x24424,0x24425,0x1645d,0x24b33,0x25140,
0x2513f,0x2513e,0x25141,0x25772,0x25771,0x17126,0x25773,0x00000,
0x17421,0x25d39,0xe552d,0x26176,0x26566,0x26d55,0x00000,0x14554,
0x14662,0x14661,0x00000,0x14e40,0x22141,0x2215f,0x1483c,0x00000,
0x22258,0x22449,0x2244a,0x14e41,0xe295d,0x2274e,0xe653b,0x15177,
0x22b4d,0x22b4e,0x00000,0x15634,0x15638,0x23027,0x15637,0x15635,
0x15636,0x00000,0x23643,0x15b47,0x1602a,0xe3c4e,0x16028,0x16029,
0x23d2b,0xe4229,0xe422a,0x1693b,0x14555,0x00000,0x22160,0xe2257,
0x14663,0xe2254,0x00000,0x22163,0xe2421,0x00000,0x14666,0x22162,
0x14665,0x14664,0x14a65,0x22161,0xe2258,0xe2259,0x22259,0x00000,
0x00000,0x00000,0x2225d,0x2225f,0x22260,0x14846,0x14847,0x2225c,
0x14842,0xe237d,0x2225a,0xe2425,0x2225e,0x14843,0xe2655,0x1483e,
0xe237c,0x1483f,0xe2423,0x14845,0x2225b,0x1483d,0x14a66,0x14840,
0x14841,0x14844,0x00000,0xe653c,0x00000,0x2245b,0x22459,0x2244c,
0x14a72,0x22453,0x14a6d,0x2244d,0xe2964,0x22455,0xe2650,0x22452,
0x14a70,0x22451,0x14a77,0x2245a,0x14a79,0xe2653,0x14a7b,0xe237e,
0x2244b,0xe2657,0x14a6e,0x2245c,0xe2651,0x14a75,0x14a78,0xe264c,
0x22765,0x14a68,0x14b21,0x14a76,0x2244e,0x14a6b,0x14a7a,0x22456,
0x14a69,0x14a6a,0x22763,0x2244f,0x14a71,0x14a7c,0x2245d,0x22450,
0x14a6f,0xe264d,0x14a74,0x2274f,0x14a7d,0x22457,0x14a73,0xe2963,
0x14a7e,0x14a67,0x22454,0x14a6c,0x22458,0x22764,0xe264e,0xe2652,
0xe265c,0xe2659,0xe2656,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0xe265b,0x14e4d,0x14e5d,0x22756,0x14e54,0xe2d4e,
0x2276b,0x14e45,0xe296b,0x14e48,0x22762,0x00000,0x22754,0x22758,
0x14e50,0x14e52,0x2275b,0x14e59,0x14e4b,0x14e49,0x14e4a,0x14e58,
0x22767,0x14e53,0x2275a,0x2275c,0x14e51,0x14e56,0x2275d,0x2276a,
0xe296d,0x15178,0x14e5c,0xe6261,0x14e46,0x22769,0xe296c,0x2276d,
0x22759,0x2276f,0x22760,0x14e4f,0x22755,0x14e4e,0x14e60,0x14e55,
0xe296a,0x22753,0x22b57,0x14e5b,0x14e5f,0x22761,0x22766,0xe2965,
0x14e61,0x14e5a,0x14e4c,0x14e42,0xe2969,0x14e47,0xe6260,0x22757,
0x14e43,0x2276e,0xe2967,0x22751,0x22750,0x2275e,0x22752,0x14e5e,
0x15639,0x14e57,0x2275f,0x14e44,0xe2d4f,0x15229,0x00000,0x00000,
0x00000,0x2276c,0x00000,0x00000,0x00000,0x00000,0x00000,0xe2d46,
0x22b5e,0x22b61,0xe2d50,0x22b64,0x22b59,0xe2d48,0xe2d4a,0x22b67,
0x22b6a,0x22b6c,0x22b56,0x15179,0x1517e,0x2302c,0x15230,0x22b65,
0x22b6d,0x22b5d,0x22b55,0xe2d49,0xe2d47,0xe2d4d,0x23047,0x15223,
0x22b62,0x22b5a,0x22b5c,0x15228,0xe317a,0x22b5f,0x15222,0x22b52,
0x22b68,0xe2d4b,0x22b6b,0xe2d45,0xe2d57,0x1517d,0xe2d53,0x1522b,
0x22b4f,0x1522d,0x1517b,0x15231,0x22b69,0x22b51,0x1522e,0x23041,
0x22768,0x15221,0x1517a,0x22b58,0x22b50,0x1522f,0x15227,0x22b63,
0x1522c,0x1522a,0x22b5b,0x15224,0x22b53,0x15225,0x15226,0x22b54,
0x22b66,0x1517c,0x22b60,0x00000,0xe2d55,0xe2d51,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0xe3177,0xe3173,
0x2302f,0x15641,0x15646,0xe3179,0xe3226,0xe3176,0x23038,0x2303e,
0x2303a,0x2302d,0x23030,0x23029,0x2302a,0x1564d,0x1563e,0x23039,
0x23042,0x15648,0x1563a,0xe316f,0x15643,0x23031,0x15645,0x23032,
0x2303c,0xe3222,0xe3225,0xe3172,0x15647,0x2304b,0x2302b,0x15640,
0x1563f,0x1564b,0x23028,0x23049,0x2303d,0x2304a,0x23044,0x23036,
0x23045,0xe3221,0x2303f,0x23048,0x23046,0x1564c,0x23037,0x1563d,
0x1563c,0x15644,0x1564a,0x23043,0x15649,0x23034,0x15b48,0xe3178,
0x2304c,0x23033,0x2302e,0x15642,0x1564e,0x1563b,0xe3227,0x2303b,
0x23040,0xe317d,0xe317b,0xe317c,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0xe653d,0x00000,0x00000,
0x00000,0x00000,0x15b6a,0x23645,0x23649,0xe366f,0x15b57,0x15b55,
0xe367a,0xe3721,0x15b4c,0x23647,0x23646,0x15b60,0xe3c50,0x2364c,
0x15b5a,0xe3672,0x2365e,0x2366a,0x15b49,0x2365b,0x23654,0x15b6c,
0x23644,0xe366a,0x23660,0xe366b,0x15b69,0x15b5d,0x15b68,0x15b53,
0x23650,0x23662,0x2365a,0x15b54,0x15b4e,0x23668,0xe366c,0x23661,
0x23663,0x15b56,0x15b5e,0x23665,0x2364e,0x2365f,0x23653,0x23667,
0x15b63,0x15b4b,0x15b61,0x23658,0x23656,0x23657,0x15b58,0x23652,
0x23651,0x15b4d,0x2364b,0x23669,0x15b4f,0x23655,0x15b6d,0xe3674,
0x15b67,0x2364a,0x15b64,0x15b62,0x15b6b,0x2365c,0x15b66,0x23035,
0x2365d,0x15b65,0x23664,0x15b4a,0x23659,0x15b5c,0x2364d,0x15b5b,
0xe367c,0x15b59,0x15b51,0x15b50,0x23d2c,0x23666,0xe3c5d,0xe3728,
0x2364f,0xe3726,0xe3723,0x23d41,0xe3670,0x15b52,0xe3677,0xe3724,
0xe3676,0xe3725,0xe3679,0x00000,0xe367d,0x00000,0x00000,0xe653e,
0x00000,0x00000,0xe3729,0x00000,0x00000,0x00000,0x00000,0xe3727,
0xe3c54,0x16047,0x15b5f,0x16035,0x23d3b,0x16043,0xe3c52,0x23d2f,
0x16032,0x1602e,0x23d4d,0x16034,0x16038,0x16033,0x1603c,0x23d51,
0x23d48,0xe3c6b,0xe3c6d,0x23d36,0x16041,0x1603b,0x23d42,0x1602b,
0x23d4e,0x23d47,0x1602f,0x23d3c,0x1603e,0x23d59,0x23d5a,0x00000,
0x1602c,0x23d4c,0x16040,0x23d40,0x23d32,0x23d33,0x16044,0x23d37,
0x23d3e,0x23d38,0xe3c5a,0x16042,0x1604a,0x23d34,0x23d2d,0x23d2e,
0xe3c56,0x23d30,0x16031,0x23d3d,0xe3c6e,0x1603f,0x16048,0xe3c58,
0xe3c69,0x23d3f,0x23d57,0x23d4f,0x1602d,0x23d55,0x16039,0xe3c66,
0x16037,0xe3c64,0x23d5b,0x16036,0x23d45,0x23d39,0x23d43,0x1604d,
0x23d49,0x23d46,0x23d35,0x16049,0x23d53,0x23d50,0x23d58,0x16030,
0x23d44,0x1604c,0xe3c5b,0x23d4b,0xe423a,0xe3c60,0x1603a,0x1603d,
0xe3c5c,0x23d4a,0x1604b,0x23d3a,0x23648,0xe3c51,0xe3c6c,0x23d54,
0x23d52,0x23d56,0x00000,0xe3c62,0xe6542,0x00000,0xe3c63,0x00000,
0xe3c68,0x00000,0x00000,0x00000,0xe6540,0x00000,0xe633d,0x00000,
0x23d31,0x16046,0xe653f,0xe6541,0x00000,0x24447,0x24446,0x2442c,
0x16463,0xe4230,0x24445,0x2442f,0x24430,0x00000,0x1646d,0x2444e,
0x16468,0x24444,0xe4233,0x24429,0x1646e,0x16464,0x24438,0x2442e,
0x24431,0x24449,0x1645e,0x24450,0x24448,0x16467,0x2443d,0x16472,
0xe422e,0xe4236,0x16471,0x1646b,0xe4240,0x00000,0x2444f,0x1645f,
0x2443b,0x24432,0x2443f,0x2444b,0x16473,0xe4239,0x16461,0x2443a,
0xe422d,0x24433,0x1646a,0xe4231,0x16469,0x24436,0x24440,0x2444a,
0x2442d,0x24437,0x16462,0x24441,0x1646f,0x16466,0x24434,0x16465,
0x2442b,0x24439,0x2444d,0x16045,0x16957,0x2443c,0x24b34,0x2443e,
0x2444c,0x1646c,0x24435,0x16460,0x16470,0x16d5a,0x2442a,0x00000,
0x24443,0xe4244,0xe423e,0xe4247,0x24442,0xe423d,0x00000,0x00000,
0x00000,0x00000,0x00000,0xe4245,0x00000,0x00000,0xe423f,0x00000,
0xe423b,0xe4246,0x00000,0x24b50,0x16954,0x24b45,0x24b4a,0x16949,
0xe4756,0x24b36,0x16956,0xe4757,0x16940,0x24b35,0x24b56,0x16958,
0x24b39,0x24b49,0xe4765,0x24b3b,0x24b59,0x24b55,0x1693e,0x16948,
0x2515b,0x16955,0x16946,0x24b37,0xe4763,0x24b54,0x1694a,0x24b51,
0x24b5e,0x24b3d,0x24b46,0xe4c78,0xe475b,0x24b5c,0x24b52,0x16945,
0xe4c6a,0xe4764,0x24b44,0x1693f,0x1693d,0x1694f,0x00000,0xe475f,
0x24b42,0x24b3f,0x24b40,0xe475a,0x24b58,0xe475c,0x24b5d,0x24b5b,
0x16943,0x24b5f,0x16947,0x1694e,0x00000,0x24b38,0x25143,0x24b41,
0xe475e,0x16941,0x16953,0x16950,0x16944,0x24b4b,0x24b3c,0x16951,
0x24b4d,0x1694b,0x1694d,0x1693c,0xe475d,0x24b4f,0x24b47,0x24b3a,
0x1694c,0x24b57,0x24b5a,0x24b43,0x24b4e,0xe4c74,0x16942,0x16d49,
0x24b4c,0x25142,0xe4762,0x24b53,0xe4761,0x00000,0x00000,0x00000,
0xe6544,0xe6545,0xe4766,0x00000,0xe6543,0x00000,0x24b3e,0x2514c,
0x25156,0x16d4c,0x25155,0x25161,0x16d4e,0x25153,0x00000,0x25157,
0x16d59,0xe4c7d,0x2514e,0x16d51,0xe4c73,0x2515a,0x2577b,0x16d5d,
0x16d5c,0x2515c,0x2514b,0x25166,0x16d57,0xe4c6b,0x16d4d,0x2515f,
0x00000,0x25163,0x25168,0x2515d,0x25151,0x16d50,0x16d53,0x16d5b,
0x16d56,0xe4c75,0x25154,0x24b48,0xe4c7e,0xe4c6c,0x25150,0x25167,
0x16d52,0xe4c79,0x16d55,0x25169,0x16d4a,0x2515e,0x25144,0x25164,
0x1742a,0xe4c7a,0x25152,0x00000,0x16d4b,0x2514d,0x16d4f,0x25145,
0x16952,0x25149,0xe6363,0x25162,0x2514a,0x25148,0x16d54,0xe4c7b,
0x25160,0xe4c77,0x25147,0x25159,0x25158,0x25165,0x2514f,0x16d58,
0x00000,0xe6547,0x00000,0x00000,0x00000,0xe6546,0x2577e,0xe5156,
0x17133,0x17129,0x2582c,0x25776,0x1712b,0x25824,0x17132,0x1712d,
0x25822,0x25d3b,0x25828,0x2582e,0x25827,0x25774,0x25825,0x25830,
0x25832,0x17128,0x25831,0x1712e,0x17134,0xe5154,0x17131,0xe5158,
0x2582b,0x17130,0x25826,0xe514d,0x25778,0x2577d,0xe5150,0x2582a,
0x1712f,0x1712c,0x17127,0x1712a,0x2577c,0x00000,0x25146,0x25777,
0x2577a,0x2582d,0x25821,0x25775,0x25d3a,0x2582f,0x25779,0x25829,
0xe4c71,0x00000,0x00000,0xe5155,0x25d3d,0x1742e,0xe5530,0xe552f,
0x17422,0xe5535,0xe5536,0x17426,0x25d3f,0x25d45,0x25d43,0x17424,
0x17425,0x1742c,0x25d46,0x25d3e,0x17427,0xe5531,0x25d42,0x25d41,
0x25d47,0x1742d,0xe5537,0x17428,0x1742b,0x25d40,0x1742f,0x17429,
0x17430,0x17423,0x25d44,0xe5a55,0x25d3c,0xe5159,0xe5539,0x26225,
0xe6548,0x00000,0x1765d,0x26222,0x26224,0xe5828,0x1765b,0x2617e,
0x26221,0x2617a,0xe582a,0xe5827,0x25823,0x2617b,0x1765c,0x26177,
0xe5826,0x17659,0x26226,0x1765a,0x26178,0x26179,0x2617d,0x1765f,
0xe5829,0x1765e,0x00000,0xe582b,0x2617c,0x17845,0x2656a,0x26570,
0x17846,0x26567,0x17843,0x17840,0x26572,0x17844,0xe5a52,0x17841,
0x26569,0x2656c,0x2656d,0x2656e,0x26571,0xe5a54,0x26223,0x26568,
0x17842,0x2656f,0x26934,0x2656b,0xe5a53,0xe654a,0xe6549,0x2692b,
0x17975,0x2692e,0x17976,0x26937,0x2692d,0x2692a,0xe5c51,0x2692c,
0x26930,0x26933,0x26932,0x26936,0x26929,0xe5c4f,0x17974,0x26931,
0x26935,0x26938,0x2692f,0x26b61,0x26b62,0x26b66,0x26b67,0xe5e3c,
0x26b64,0x26b65,0x26b63,0xe5e3a,0x17a74,0xe5e3b,0x00000,0x00000,
0x00000,0x17b64,0x26d59,0xe6036,0xe5f52,0x26d56,0x26d57,0x26d58,
0x17b65,0xe6037,0x26f34,0x26f33,0xe654b,0x2703d,0x17c60,0x2703b,
0x2703e,0x2703c,0x27125,0x17d24,0x17d32,0x27171,0x2715b,0xe6179,
0x27170,0x2723e,0x2723f,0x14556,0x00000,0x00000,0xe2428,0xe2426,
0x14848,0x22261,0xe2427,0xe242b,0x2245e,0xe2662,0x14b22,0xe265f,
0x14b25,0xe265e,0x2245f,0xe2663,0x14b23,0x14b24,0xe2660,0x00000,
0x00000,0xe2977,0x22778,0x2277a,0x22775,0x22772,0x22774,0xe2974,
0xe2970,0xe2975,0x14e65,0xe296f,0xe2979,0xe2976,0x14e63,0xe2972,
0xe2971,0x22776,0x14e64,0x22773,0x22770,0x14e62,0x22777,0x00000,
0x22771,0x14e66,0x22779,0x00000,0x00000,0x00000,0x00000,0x22b6f,
0xe2d5e,0x22b73,0xe2d5c,0xe2d5a,0x1523a,0xe2d58,0xe626a,0xe2d65,
0xe2d62,0x22b76,0xe2d5f,0x15232,0x15235,0x15237,0x15239,0x15236,
0x22b72,0x22b71,0xe2d64,0x15234,0x22b74,0x22b75,0xe2d63,0x22b6e,
0x15238,0xe2d68,0x15233,0xe2d5d,0x00000,0x00000,0x22b70,0xe654d,
0x00000,0x00000,0x00000,0x00000,0xe3228,0x2305a,0x2305b,0x2305c,
0x15653,0xe6279,0x1564f,0x23051,0xe322a,0x23059,0x2305e,0x15654,
0xe322b,0x2304f,0x23055,0x2304e,0x23058,0xe3231,0xe322f,0x23054,
0x15650,0x15652,0x2305d,0xe3229,0x2304d,0x23050,0x23056,0xe322d,
0x23057,0x2305f,0x23053,0xe322c,0x15651,0xe654f,0x00000,0x00000,
0x00000,0x00000,0xe654e,0x00000,0x00000,0x00000,0xe3230,0x15b72,
0x23671,0xe3730,0xe3732,0x23673,0x2366f,0xe372f,0x2367b,0x2366d,
0x2367a,0x15b6e,0x2366b,0x23d5f,0x23675,0x15b71,0xe3735,0x23676,
0x23679,0xe372e,0x2367d,0xe372c,0x23672,0x00000,0x23677,0xe372d,
0xe3731,0x15b6f,0x15b70,0x2367c,0x23670,0x2366c,0x2367e,0xe3733,
0x23674,0xe6550,0xe6551,0x23678,0x00000,0x00000,0x00000,0x2366e,
0x00000,0x1604e,0x1604f,0x23d69,0x16055,0xe3c74,0x23d5d,0x23d66,
0x23d5c,0x16052,0x23d64,0x23d62,0xe3c7d,0x23d63,0x16050,0xe3c7c,
0x23d67,0x00000,0xe3c6f,0xe3c7a,0xe3c72,0xe3d21,0x23d60,0x23d5e,
0x16051,0x23d61,0x23d65,0xe3c7b,0xe3c79,0xe3c71,0x16053,0xe3c73,
0xe3c77,0xe6553,0x23d68,0xe6554,0x00000,0xe6555,0x00000,0xe6552,
0x00000,0x24456,0x2445d,0x2445f,0x24465,0xe4257,0x16522,0x24451,
0xe424c,0x16478,0xe424e,0x24460,0x1647d,0x24466,0x16474,0xe4251,
0x24463,0xe4258,0x24453,0x24464,0x24452,0x00000,0x16524,0xe4252,
0x2445e,0x16475,0x24467,0xe483c,0x1647a,0x24457,0x16521,0x24462,
0x24455,0x2445c,0x24458,0x24454,0x16477,0x1647e,0x1647c,0x16479,
0x16523,0x16476,0x2445b,0xe424f,0x1647b,0xe4259,0x16054,0xe4249,
0x24461,0xe6559,0x24459,0x00000,0xe4253,0xe6557,0xe6558,0xe6556,
0x2445a,0x00000,0x00000,0x24b67,0xe476f,0x1695b,0xe476e,0xe476c,
0x24b63,0x24b69,0x24b65,0xe4770,0x1695d,0x24b64,0x24b68,0x24b60,
0xe4772,0x24b62,0x1695c,0xe476a,0xe476d,0xe476b,0xe4768,0x24b66,
0x24b61,0xe4767,0x1695e,0xe655b,0x16959,0x00000,0xe655a,0x24b6a,
0x00000,0x1695a,0x2516f,0x2516c,0x25178,0x25172,0x25174,0x16d5e,
0x2516e,0x25176,0xe4d2a,0xe4d24,0x25175,0x25173,0xe4d29,0x25179,
0x16d61,0x25170,0x25177,0xe4d28,0x16d5f,0xe4d25,0xe4d22,0x2516b,
0x2516d,0x16d60,0x2516a,0x2517a,0xe655c,0x25171,0xe5162,0xe515a,
0x25836,0x1713b,0xe5160,0xe515c,0x25841,0x2583f,0x17135,0x25835,
0x25838,0x25839,0x25834,0x1713f,0x17140,0x25833,0x25842,0x2583d,
0x17139,0x17136,0x2583c,0x2583a,0xe5163,0xe6374,0x1713c,0x2583e,
0x17137,0xe515e,0x17138,0xe5166,0x2583b,0x1713a,0x25837,0x00000,
0x25840,0x1713d,0x25843,0x25844,0x1713e,0xe655d,0xe655e,0x17432,
0x17439,0x25d48,0x25d4e,0xe553c,0x25d4c,0x17435,0x17434,0x17431,
0x25d4a,0xe553e,0xe5543,0xe5540,0x17437,0x17436,0x17433,0xe5541,
0x25d4d,0x25d49,0x25d4b,0xe5542,0x17438,0x00000,0x00000,0x00000,
0x17663,0x26229,0xe582d,0x17660,0x17661,0x2622b,0x17662,0x26228,
0xe582e,0x26227,0x26576,0x2622a,0xe5a56,0x26577,0x17847,0x26575,
0xe5a57,0x00000,0x26574,0xe5c59,0x26573,0x17848,0xe655f,0xe5c56,
0x17977,0xe5c58,0xe5c55,0x26939,0x2693a,0xe5a58,0xe5c53,0xe5c57,
0xe6561,0x26b6a,0x26b69,0x17a75,0xe5f53,0x26b68,0x26d5a,0x26d5b,
0xe5f54,0xe6039,0x26f35,0x2703f,0xe6143,0xe6142,0x27126,0x2722c,
0x17d46,0x27240,0x14557,0x00000,0x14e67,0x14e68,0xe2d69,0x00000,
0x1523b,0x00000,0xe3d22,0x00000,0x00000,0x1743a,0x14558,0x00000,
0x14e69,0x15655,0x16525,0x14559,0xe2d6b,0x15b73,0x1695f,0x22142,
0xe297c,0x22b77,0x23060,0x00000,0x24b6b,0x00000,0x1743b,0x1455a,
0x14e6a,0x22b78,0x22b79,0x23d6a,0x16056,0x00000,0xe425d,0x24468,
0xe425c,0xe425b,0x16526,0x24b6c,0x00000,0xe4d2e,0x16d62,0xe4d2d,
0x17849,0x1455b,0x23d6b,0x1455c,0x00000,0x1484a,0x22262,0x14849,
0x14b28,0x14b27,0x14b26,0x22460,0xe2664,0xe2a21,0xe2a22,0x14e6b,
0xe2a23,0x14e6c,0x2277b,0x00000,0x22b7a,0xe2d6d,0x22b7d,0x1523d,
0x22b7b,0x00000,0x1523c,0x22b7c,0x1523e,0x00000,0x23063,0x23062,
0x23061,0x15656,0xe3236,0x23722,0x23723,0x15b74,0x23721,0x23724,
0x16058,0x15b75,0xe3d24,0xe3d23,0x16057,0x23d6f,0x23d6e,0xe3d25,
0x23d6c,0x23d6d,0x00000,0x23d70,0x2446a,0x24469,0x2446d,0x00000,
0x2446c,0x2446b,0x16960,0x24b6f,0xe4775,0x24b6e,0x16961,0x24b6d,
0x2517b,0xe4d2f,0x2517c,0x16d63,0x00000,0x25845,0x25846,0x00000,
0x00000,0x2657c,0x1784a,0x2657b,0x2657a,0x26578,0x26579,0x17a76,
0x2693b,0x26d5c,0x27127,0xe617b,0x1455d,0x00000,0x22164,0x14667,
0x22165,0xe242c,0xe242d,0x00000,0x22263,0x22264,0xe266b,0x00000,
0x00000,0xe2669,0x22466,0xe2666,0xe2667,0x22462,0xe266a,0x22461,
0x14e6d,0x22465,0x14b2a,0x22463,0x14b29,0x22467,0x22464,0xe2668,
0x00000,0x22821,0x22b7e,0x2277d,0x22826,0xe2a26,0x14e6e,0xe2a2a,
0x14e71,0x22827,0x22823,0xe2a27,0x22824,0x00000,0x2277c,0x14e70,
0x2277e,0x14e6f,0x22825,0xe2a28,0x22822,0x00000,0x00000,0x22c24,
0x15240,0x15241,0xe2d75,0x22c27,0x22c21,0xe2d74,0x22c26,0xe2d70,
0x22c22,0x1523f,0x22c25,0x22c23,0xe2d73,0xe2d71,0x00000,0x00000,
0x00000,0x00000,0x00000,0x23069,0x23066,0xe3238,0x23068,0x1565b,
0x1565a,0x15658,0x23065,0x2306a,0x15657,0x15659,0x23067,0x2372c,
0x23064,0x2306b,0xe3239,0x00000,0x00000,0x00000,0xe3d26,0x23727,
0x2372b,0x00000,0x2372a,0x23d72,0x23d7d,0x00000,0xe373b,0x2372d,
0xe373a,0x23728,0x23d71,0x15b79,0x00000,0x00000,0x15b78,0x23726,
0x23729,0x15b7a,0xe3739,0x15b77,0x15b76,0x23725,0x2372e,0x00000,
0x00000,0x00000,0x23d74,0x23d7b,0xe3d27,0x1605a,0x23d7a,0x23d77,
0xe3d2e,0x1605c,0xe3d29,0xe3d2b,0xe3d2a,0x23d79,0xe4261,0xe3d2d,
0x23d73,0x23d75,0x23d78,0x23d76,0x1605b,0x23d7c,0x16059,0x16527,
0xe3d28,0x00000,0x24471,0x24470,0x2446e,0x00000,0x1652a,0x16529,
0x24472,0xe425f,0x2446f,0x24b70,0x16962,0x16528,0xe4262,0xe6562,
0xe6563,0x24474,0x24473,0xe4d30,0x24b73,0x24b71,0x16d64,0xe4779,
0x16963,0x24b72,0x2517e,0xe4778,0xe477a,0xe4777,0x00000,0x16d65,
0x2517d,0x25228,0x25227,0x25225,0x00000,0x25224,0x25221,0x25222,
0x25223,0x25226,0x25229,0x00000,0x00000,0x2584b,0x25848,0x25849,
0x17141,0x25847,0x2584d,0x2584c,0x2584a,0x00000,0x25d50,0x25d51,
0x1743c,0xe5549,0x1743d,0x25d4f,0x00000,0x17665,0x2622c,0x17664,
0x1784b,0x00000,0x1784c,0x17978,0x2693d,0x2693c,0x26b6b,0x26d5d,
0x17b66,0x26f37,0x26f36,0x26f38,0x14668,0x22c28,0x1565c,0x15b7b,
0x2372f,0x14669,0x22166,0x1455e,0xe225a,0xe216b,0x22265,0xe242f,
0x00000,0x00000,0x2246c,0x2246a,0x2246b,0x22468,0x14b2b,0x22469,
0xe266e,0x00000,0x00000,0x00000,0xe2a33,0x2282f,0xe2a2d,0x14e74,
0x2282d,0x22829,0x2282c,0xe2a2c,0x22828,0x14e76,0x2282b,0xe2a2b,
0x14e73,0x14e72,0xe2a32,0x14e75,0x2282e,0x2282a,0x00000,0xe2a2f,
0x00000,0x00000,0x15245,0x15248,0x22c30,0x22c2f,0x22c2e,0x15242,
0x22c37,0x22c2d,0x00000,0x15244,0x23070,0xe2d78,0x22c34,0x22c32,
0x15247,0xe2d7b,0x22c2a,0x22c35,0xe2d77,0x22c2c,0x22c36,0x22c33,
0x22c2b,0xe2d7a,0x15243,0x22c38,0x22c29,0x15246,0xe2d7e,0xe2d79,
0xe2d7c,0x00000,0x23075,0x2306c,0x23077,0xe323e,0x2306f,0x2307a,
0x2307b,0x2306d,0x23079,0x23076,0x23074,0x23078,0x15662,0xe3240,
0x15660,0xe3247,0xe323c,0x23072,0xe3246,0x2306e,0xe3241,0x23071,
0x2307c,0x23073,0x15661,0x22c31,0xe323d,0x1565d,0x1565f,0xe6564,
0x00000,0x00000,0x00000,0xe373d,0x2373d,0x23732,0x23730,0xe3d38,
0x23731,0xe323f,0x23738,0xe3740,0x23739,0x23735,0x15c22,0x2373a,
0x23737,0x23734,0xe373c,0x15b7e,0x23733,0x15b7c,0x15c21,0x23736,
0x2373e,0x1565e,0x15b7d,0x2373c,0x2373b,0x15c23,0x00000,0x00000,
0x00000,0x00000,0xe6565,0x00000,0xe3d36,0xe3d3a,0x23e24,0xe3d2f,
0xe3d3b,0xe3d32,0x23e25,0x16066,0xe3d39,0x23e2b,0xe426d,0xe3d35,
0x23e2d,0x23e26,0x16060,0x23e2a,0x23e29,0x16061,0x16067,0xe4264,
0x16068,0x23e2c,0x1605e,0x23e23,0x23e21,0x23e27,0x23d7e,0x16065,
0x23e22,0x23e28,0x23e2e,0x1605f,0x16064,0x16062,0x16063,0x00000,
0xe3d33,0xe3d3c,0x1605d,0xe6566,0xe3d37,0xe4268,0xe4275,0x16531,
0x2447b,0x16530,0x24521,0xe426f,0x24475,0xe4274,0x24522,0xe426e,
0xe4266,0xe4271,0x24476,0x24477,0xe4273,0x24523,0x2447e,0x2447c,
0x2447d,0x24479,0x24478,0xe4267,0x24524,0x1652d,0xe426b,0x2447a,
0xe4270,0x16532,0x1652c,0x16533,0x16534,0xe426a,0x1652f,0x1652e,
0xe4825,0xe477e,0x24b74,0x16965,0x16964,0xe477c,0xe477d,0x24b79,
0xe4822,0x16d66,0x16966,0xe4821,0xe477b,0x16968,0x24b7a,0x1652b,
0x16967,0x24b76,0x24b78,0x24b75,0xe4827,0x24b77,0xe4823,0x00000,
0x00000,0x25233,0xe4d31,0xe4d3b,0x25232,0x2522f,0x16d69,0x2584e,
0x16d6a,0x2522e,0xe4d39,0x16d68,0xe4d36,0x25230,0x2522d,0x2522a,
0x25231,0x2522b,0x2522c,0x16d67,0xe4d35,0xe6568,0x00000,0x00000,
0x25d55,0x00000,0x25852,0xe4d3a,0x25851,0x25853,0xe516a,0x25d52,
0x17144,0xe6375,0x2584f,0xe5167,0x17142,0xe516c,0x17146,0x17145,
0x25850,0x25854,0xe516b,0x17143,0xe6567,0x25d59,0x17440,0x17666,
0x17441,0x1743e,0x25d56,0x25d54,0xe554f,0x25d57,0xe554b,0x25d5a,
0x1743f,0x25d58,0x25d53,0xe554d,0xe6569,0x2622f,0x26232,0x26621,
0x2622d,0xe582f,0x2693e,0x26233,0xe5830,0x1784d,0x26231,0x17667,
0x2622e,0x26230,0x26234,0x26622,0xe5a5a,0x2657e,0x00000,0xe5a5c,
0xe5a5d,0xe5a5b,0x1784e,0x2657d,0xe5c5e,0xe5c5c,0xe5c5f,0x17979,
0xe5c5d,0xe5c60,0x00000,0xe5e3d,0x17a78,0x26d5f,0x17a77,0x26d61,
0x26d5e,0x26d60,0x17c3c,0x27040,0x1466a,0x22830,0x2307d,0x2307e,
0x15c24,0x24525,0x17147,0x1784f,0x17b67,0x27041,0x1466b,0x00000,
0x22831,0x12322,0x00000,0xe2e22,0x22c39,0xe2e21,0x22c3a,0xe2e24,
0x00000,0x00000,0x00000,0xe3248,0x23121,0x23122,0x15c25,0x15c26,
0x00000,0xe3d3d,0x00000,0x23e2f,0x00000,0x24528,0x24527,0x24526,
0x24b7b,0xe4277,0x24b7c,0x24b7d,0x16969,0x00000,0xe4828,0x25235,
0x25234,0xe4d3d,0xe516d,0x25855,0x17148,0x17149,0xe516e,0x25d5e,
0x25d5b,0x25d5c,0x25d5d,0x26236,0x26235,0x17668,0x26623,0x26b6c,
0x1466c,0x00000,0x15249,0xe3744,0x15c27,0x24529,0xe4278,0x1466d,
0x00000,0x23123,0x15c28,0xe3745,0xe3d3e,0x16069,0x1606a,0x00000,
0x1466e,0x1466f,0x22266,0x14b2d,0x14b2c,0x1524a,0x22c3b,0x23e30,
0x14670,0x14671,0x14672,0x14673,0x00000,0x00000,0x00000,0x14b2e,
0x14b2f,0x2246e,0x2246d,0xe2a37,0x00000,0x14e77,0x22834,0x22832,
0x22833,0xe2a38,0xe2a35,0x00000,0xe2a36,0x00000,0xe2e27,0x22c3c,
0x22c3d,0xe2e25,0xe2e28,0x1524e,0x1524c,0xe2e2a,0x1524d,0x1524b,
0xe2e26,0x00000,0x00000,0x00000,0x15663,0xe324e,0xe324d,0xe3250,
0xe324f,0x15667,0x15666,0x23124,0x15665,0x15664,0xe3251,0x23125,
0x00000,0xe3746,0x15c2b,0x23740,0x2373f,0x15c29,0x15c2a,0xe3749,
0xe3747,0x00000,0x1606c,0x1606b,0x23e32,0xe3d43,0xe3d42,0x23e31,
0x15c2c,0xe3d44,0x00000,0x00000,0x00000,0x00000,0x16535,0x2452b,
0x16536,0x2452a,0xe427b,0x00000,0x00000,0x24b7e,0x25236,0x16d6b,
0x25856,0xe5170,0x00000,0xe5552,0x25d5f,0x00000,0x17851,0x17850,
0x00000,0xe5c62,0x17b68,0x14674,0x22835,0x00000,0xe3d45,0x15c2d,
0x24c21,0x1696a,0xe225b,0xe2673,0x2246f,0x22470,0x00000,0x00000,
0x22836,0x14e79,0x14e7a,0xe2a3a,0x00000,0x14e78,0xe2a3b,0x00000,
0x00000,0x00000,0x15252,0x15253,0x15250,0x15251,0xe2e2b,0x22c3e,
0xe2e2f,0x00000,0x22c3f,0x1524f,0x00000,0x00000,0x00000,0x00000,
0x23126,0xe3257,0x1566b,0x1566c,0xe3255,0x15c30,0x2312c,0x00000,
0x15671,0x1566f,0x2312d,0x23128,0x1566e,0x1566d,0x15668,0x2312b,
0x2312a,0x23127,0x15670,0xe3252,0x23129,0x15669,0x00000,0x1566a,
0x00000,0x00000,0x15c31,0x23744,0x23745,0x15c32,0x23741,0x23743,
0x23747,0x23746,0x23742,0xe374a,0x15c2e,0x15c2f,0x00000,0x23e3a,
0x16071,0x16070,0x23e34,0x1606e,0x00000,0x23e37,0x16072,0x23e38,
0x16073,0x23e35,0x1606d,0x1606f,0x23e39,0xe3d47,0x23e36,0x23e33,
0x00000,0x00000,0x00000,0x00000,0x00000,0x24538,0xe427c,0x2452d,
0x16538,0x1653b,0x1653a,0x1653f,0x1653e,0x24539,0x24537,0x24530,
0x24534,0x24533,0x1653c,0x24536,0x24532,0x2453a,0x24531,0x1653d,
0x16537,0x16539,0xe427d,0x2452f,0x00000,0x00000,0x00000,0xe482b,
0x24c23,0x1696e,0x24c27,0x1696d,0x24c24,0x1696c,0xe4829,0x2452e,
0x24535,0x24c26,0x00000,0x1696f,0x24c28,0x24c25,0x24c22,0x00000,
0x00000,0x25239,0x2523d,0x2523f,0x2523b,0x2523a,0x25238,0x16d6e,
0x16d6c,0x16d71,0x16d72,0x2523c,0x16d6f,0x25237,0x16d70,0x1696b,
0x2523e,0x16d6d,0x00000,0x00000,0xe5171,0x25858,0x00000,0x25857,
0x2585f,0x25859,0x2585e,0x2585b,0x1714a,0x2585d,0xe5173,0xe5172,
0x1714b,0x00000,0x1714c,0xe5174,0x2585c,0x2585a,0x00000,0x00000,
0x00000,0x00000,0x17443,0x25d60,0xe5555,0xe5553,0x17442,0x25d63,
0x25d61,0x25d62,0x00000,0x00000,0x17444,0x00000,0xe5554,0xe5834,
0x2623a,0xe5833,0x1766b,0x2623b,0x00000,0x00000,0x17669,0x2623c,
0x1766a,0x26239,0x2623d,0xe5832,0x26237,0x00000,0x00000,0x17852,
0x26624,0x17853,0x1797a,0x00000,0x26238,0x1797b,0x00000,0xe5e3f,
0xe5e3e,0x17a79,0x26b6d,0x00000,0x17b6a,0x26d62,0x17b69,0xe603b,
0x26f39,0x17c61,0x17c62,0xe656a,0x00000,0x2723a,0xe225c,0xe656b,
0x15254,0x22c40,0x00000,0x16074,0x16075,0x14675,0x1484b,0x22267,
0xe2674,0x22471,0x14b30,0xe2676,0x14e7b,0x00000,0x15255,0x15256,
0x15257,0x23749,0x2312e,0x15672,0x00000,0x00000,0x15c33,0x23748,
0xe374d,0x00000,0x23e3c,0x16077,0xe3d4c,0x23e3b,0x16076,0xe427e,
0xe4321,0x2453b,0x16d73,0x25243,0x25240,0x25241,0x25242,0x00000,
0x00000,0xe5176,0x00000,0xe5556,0x25d64,0xe5557,0x2623e,0x00000,
0x00000,0xe5a5e,0x26940,0x2693f,0x00000,0x26d63,0x14676,0x22837,
0x15673,0x00000,0x00000,0xe3d4d,0x16078,0x2453c,0x00000,0xe4830,
0x24c29,0xe482e,0x16d74,0x25860,0xe656c,0x2623f,0x26941,0x14677,
0xe2677,0xe2678,0x14e7c,0x1525a,0x22c41,0x1525b,0x15259,0xe2e32,
0x15258,0x2312f,0x15674,0xe325a,0xe325b,0x15675,0x15676,0x00000,
0x00000,0x00000,0x15c35,0x2374a,0x15c34,0xe3750,0xe3752,0xe3751,
0x00000,0xe3d4f,0x23e3d,0x15c36,0x16079,0x2453d,0x16540,0x16541,
0x00000,0x16970,0xe4831,0x16971,0x16d75,0x1714e,0x25861,0x1714d,
0x00000,0x25d65,0x17445,0xe5835,0x26240,0x26942,0x14678,0x14b31,
0x2283a,0x22839,0x14e7d,0x22838,0x14e7e,0x2283b,0x00000,0x22c47,
0x1525e,0x1525d,0x22c49,0x22c48,0x15262,0xe2e35,0x15261,0xe2e33,
/* 0x7700 */
0x00000,0x1525c,0x00000,0x22c43,0x22c44,0x22c45,0xe626c,0x15263,
0x22c42,0x1525f,0x22c46,0x15260,0x00000,0x00000,0xe3264,0xe325f,
0x23132,0x23136,0x23134,0x23133,0x00000,0x23137,0xe325e,0x00000,
0xe3268,0x23138,0x23139,0x23131,0x00000,0x23130,0xe3759,0x15678,
0x15679,0xe3267,0x2313a,0x23135,0xe3265,0x23753,0xe3755,0x2313b,
0x1567a,0x15677,0xe325c,0xe3263,0x00000,0x2374d,0x00000,0x2374c,
0xe3753,0x2374e,0x2374f,0x23751,0x23750,0x23755,0x15c3a,0x15c37,
0x15c3b,0x2374b,0x15c3c,0x23754,0x15c39,0x23752,0x15c38,0xe3262,
0xe3757,0x00000,0xe3d56,0xe3d53,0x23e40,0x23e42,0x23e3e,0x23e3f,
0xe3d51,0xe3d52,0x23e43,0x23e45,0x23e46,0x23e41,0x23e44,0x1607a,
0x00000,0x00000,0x24541,0xe4327,0x24546,0x2453e,0x24542,0x00000,
0xe4328,0x24547,0x24543,0x16542,0x1654a,0xe4325,0x16545,0x2453f,
0x24540,0x16975,0x1654d,0x16546,0xe4326,0x1654b,0x16544,0x24545,
0x1654c,0x24544,0x16548,0x16543,0x16549,0x24548,0x24c2e,0x24c30,
0x00000,0xe4839,0x00000,0x00000,0xe4833,0xe4836,0xe4835,0xe4834,
0xe4838,0x16547,0xe483b,0xe483d,0x24c2b,0x16973,0x24c31,0x16974,
0x24c2f,0x24c2a,0x24c2d,0x24c32,0x16972,0x24c2c,0x00000,0x16d77,
0x25247,0x25246,0xe4d44,0x16d7a,0x16d78,0x25244,0x16d76,0x25245,
0xe4d46,0x16d79,0x00000,0x00000,0x00000,0x25869,0xe517b,0x2586b,
0xe5179,0x2586a,0x25862,0x25866,0x25865,0x25863,0x17150,0x17151,
0x1714f,0x25864,0x25867,0x25868,0xe5559,0x17152,0xe5558,0x1744a,
0x25d6d,0xe555b,0x17447,0x25d67,0x17449,0x1744b,0x00000,0xe555c,
0x17448,0x25d6c,0x25d68,0x17446,0x25d6b,0x25d66,0x25d6a,0x25d69,
0xe5836,0xe5838,0x26242,0x1766e,0x1766f,0x1766c,0xe583b,0x1766d,
0xe583a,0xe5839,0x26241,0x00000,0x26627,0xe5a60,0xe5a5f,0x17854,
0x00000,0x26625,0x26626,0x00000,0x26943,0x26946,0x26944,0x26945,
0x26b6e,0xe5e42,0x00000,0x17a7a,0x26f3a,0x27042,0xe6432,0x17c63,
0x27128,0x27129,0x17d33,0x14679,0x15264,0xe3269,0x23e47,0xe3d57,
0x24549,0x00000,0x1467a,0x14b32,0x00000,0x14f21,0xe2e36,0x22c4a,
0x22c4b,0x1567b,0x00000,0x00000,0x23e48,0x1607b,0x1654e,0x1744c,
0x25d6e,0x26628,0x26947,0x1467b,0xe267b,0xe267c,0x00000,0x22841,
0x2283c,0x2283e,0x22840,0x2283f,0x2283d,0x14f22,0x00000,0x00000,
/* 0x7800 */
0x00000,0x00000,0x15265,0x22c54,0xe2e39,0x22c4f,0x22c4c,0xe2e3b,
0xe2e3e,0x22c53,0xe2e37,0xe2e3a,0x15267,0x15268,0x22c52,0x22c51,
0x22c50,0x22c4d,0x22c4e,0x22c55,0x15266,0xe2e3d,0x00000,0x00000,
0x00000,0xe656d,0x00000,0xe656e,0x00000,0x15721,0xe667c,0x15727,
0x15726,0x23144,0x2313e,0x2313c,0xe326c,0x15724,0x2375c,0x1567d,
0x23141,0x23145,0x23147,0x23143,0x2313d,0x15725,0x23142,0x23140,
0x1567c,0x23148,0x15728,0x23146,0x15722,0x2313f,0xe326d,0x15723,
0x1567e,0x00000,0x00000,0x00000,0x00000,0xe656f,0x00000,0x00000,
0x00000,0x00000,0xe3762,0x15c3e,0x00000,0x2375d,0xe3763,0xe375d,
0x23756,0x23758,0x2375a,0xe375f,0x2375b,0x23759,0x15c3f,0xe3761,
0x2375e,0xe3760,0x23757,0xe6570,0xe6571,0x00000,0x00000,0x00000,
0xe6572,0x00000,0x00000,0x00000,0x23e4c,0x1607c,0x23e54,0xe3d5c,
0x23e49,0x00000,0x23e55,0xe3d59,0x23e4a,0x23e4b,0xe3d5d,0x00000,
0x23e53,0x23e52,0x23e4f,0x15c3d,0x1607d,0x23e4d,0x23e50,0x1607e,
0x23e51,0x23e4e,0x00000,0x00000,0x00000,0x00000,0xe3d5a,0x00000,
0xe4331,0x24554,0xe432d,0x24558,0x16555,0xe432e,0x24c38,0x16558,
0x24556,0xe4337,0xe4329,0x24553,0x2454e,0x24550,0x24551,0x2454a,
0xe4335,0x16554,0xe432b,0xe4330,0x16553,0xe4334,0x1654f,0x2454d,
0xe432a,0x16556,0xe4336,0x16557,0x2454c,0x2454f,0x24557,0x16551,
0x16552,0x24555,0x2454b,0x00000,0x00000,0x00000,0x24c3a,0x16977,
0x24c3c,0x24552,0x24c3e,0x1697b,0x24c3f,0x24c3b,0xe483e,0x16978,
0x24c37,0x1697a,0x24c34,0x24c39,0x24c3d,0x24c36,0xe483f,0xe4845,
0x16550,0xe4844,0x24c33,0x16979,0x24c35,0x00000,0x00000,0xe6573,
0xe4840,0x00000,0x16d7d,0x25249,0x16e23,0x00000,0x16e21,0x00000,
0xe4d4a,0x16976,0xe4d4d,0x25250,0x25251,0x16d7c,0xe4d48,0xe4d4c,
0x2524f,0x25252,0x16d7e,0x16d7b,0x2524b,0x25248,0x2524d,0x2524a,
0x16e24,0x2524c,0xe4d4b,0xe4d49,0x2524e,0x16e22,0xe5221,0x00000,
0xe6574,0x00000,0x17154,0x25872,0xe5224,0x2586c,0x25870,0x25876,
0x25877,0x25873,0x25874,0x25871,0x00000,0x2586e,0x00000,0x17156,
0x17153,0x2586d,0x2586f,0xe5222,0x17155,0x25875,0xe6575,0x17450,
0xe5560,0xe5562,0x25d75,0x25d6f,0x1744f,0x00000,0x00000,0x1744d,
0xe5561,0x25d77,0x1744e,0x25d72,0x25d73,0x25d70,0x25d78,0x25d74,
/* 0x7900 */
0x00000,0x17451,0x25d71,0x00000,0x25d79,0x25d76,0xe5843,0xe583e,
0xe5840,0x26246,0xe583f,0xe583c,0x26243,0xe5842,0x17670,0x00000,
0x26247,0x26249,0x26248,0x26244,0x26245,0xe5844,0x00000,0x2662d,
0xe5a61,0x17855,0xe5a62,0x2662a,0x2662c,0x26629,0x2662e,0x00000,
0xe5a63,0x2662b,0xe6576,0x26949,0x2694c,0x26948,0x1797c,0x2694a,
0x2694b,0x2694d,0x1797d,0x17a21,0x1797e,0x26b6f,0xe5e45,0x26b71,
0xe5e43,0x26b70,0xe5e44,0x00000,0x00000,0x26d64,0x00000,0xe603c,
0x27043,0x2712a,0x1467c,0x00000,0xe2433,0x22472,0x14f23,0x22843,
0x14f24,0x14f25,0x22842,0x00000,0x22c5a,0x22c59,0x15269,0x1526c,
0x1526b,0x1526a,0x22c56,0x22c58,0x22c57,0xe6577,0x00000,0x2314b,
0x1572a,0x2314f,0x2314e,0x2314d,0x23149,0x15729,0x1572d,0x15730,
0xe326f,0xe3270,0x15731,0x2314a,0x2314c,0x1572f,0x1572e,0x1572c,
0x1572b,0x23765,0xe3272,0x23763,0x2375f,0x15c40,0xe3d5e,0x23760,
0x15c41,0x23761,0x23762,0x23764,0xe3766,0x15c42,0xe3765,0x00000,
0x23e59,0xe3d5f,0x23e58,0x23e57,0x23e56,0xe3d64,0xe3d62,0x00000,
0x00000,0x2455c,0x16559,0x00000,0x24559,0x2455b,0xe4338,0x1655a,
0xe433d,0x1655b,0x2455a,0xe4339,0xe3d63,0x00000,0xe6578,0xe4848,
0x24c48,0xe4847,0x24c41,0x24c42,0x00000,0x1697e,0x1697c,0x1697d,
0x24c4a,0x00000,0x24c49,0x24c46,0x24c45,0x24c44,0x24c43,0x24c47,
0x24c40,0xe6579,0x25253,0x25258,0x25256,0xe4d50,0xe4d51,0xe4d4f,
0x25255,0x25254,0x25257,0xe657a,0x25878,0xe5226,0x17157,0x17452,
0x25d7b,0xe5227,0x17453,0x25d7a,0x2624b,0x2624a,0x17671,0xe5845,
0x2662f,0x17856,0x2694e,0x17b6b,0x26d65,0xe603d,0x27045,0x27044,
0x22167,0x1526d,0x1526e,0x23766,0xe657b,0x1655d,0x1467d,0x14b35,
0x14b34,0x14b33,0x00000,0xe2a3e,0xe2a3d,0x22844,0xe2a3f,0xe2a42,
0x14f27,0x14f26,0xe2a44,0x15271,0xe654c,0x22c5c,0x22c5f,0x22c5d,
0xe2e42,0x1526f,0x15270,0xe2e40,0xe2e41,0x22c5b,0x22c5e,0xe2e43,
0x15738,0xe3274,0xe3273,0xe3279,0x23156,0x23158,0x23157,0x15735,
0x23152,0xe3276,0xe327b,0x15733,0x15732,0xe3277,0x15736,0x15734,
0xe3278,0x15737,0x23155,0x23150,0x23151,0x23154,0x23153,0x00000,
0xe327c,0xe3769,0xe3767,0xe376b,0x00000,0xe376a,0x23769,0x2376a,
0x23768,0xe376c,0x23767,0x15c43,0x00000,0x00000,0x00000,0xe3d65,
0x16125,0x00000,0x23e5a,0x23e5c,0x23e5e,0x16124,0x00000,0xe3d66,
0x16122,0xe3d69,0x23e5b,0x16123,0x23e5d,0x16121,0xe3d68,0xe4341,
0x24566,0x2455d,0x24560,0x24564,0x16561,0x24562,0x00000,0x24561,
0x2455e,0x2455f,0x1655f,0x24565,0x1655e,0xe4344,0x16563,0x16562,
0x16560,0x00000,0x24563,0x00000,0x00000,0xe6524,0x24c50,0x00000,
0x24c4f,0xe484b,0xe484d,0x24c4b,0xe4850,0xe484f,0x16a21,0x24c4e,
0x24c4d,0x16a22,0xe4852,0x00000,0x00000,0x00000,0x00000,0x16e29,
0xe4d55,0x2525a,0xe4d56,0x16e2a,0x16e26,0x16e28,0xe4d5a,0x16e25,
0x16e27,0xe4d53,0xe4d57,0x00000,0x25879,0xe522a,0x1715a,0x2587b,
0x2587a,0xe5564,0x24c4c,0x1715c,0x1715b,0x17158,0x17159,0xe522c,
0x00000,0x00000,0x00000,0xe5229,0x25e22,0x00000,0x25d7e,0x17454,
0x25e21,0x00000,0x25e23,0x25d7d,0x25d7c,0x00000,0x00000,0x2624c,
0x17674,0x17672,0x17673,0x00000,0xe5a66,0x00000,0xe5a65,0x26630,
0x26631,0x17858,0xe5a67,0x17857,0x26950,0x26951,0x2694f,0xe5c64,
0x26d66,0x26d67,0xe6076,0xe6077,0x1467e,0x22268,0x14b36,0x00000,
0x22845,0x14f29,0x14f28,0x22846,0xe2e44,0xe2e47,0x22c61,0x15272,
0x22c60,0x15273,0xe2e49,0xe2e48,0x15739,0x2315b,0x23159,0x2315f,
0x1573a,0x2315a,0x2315e,0x2315c,0x2315d,0x00000,0x00000,0x2376b,
0x2376d,0xe3772,0x15c44,0xe3771,0x2376c,0x15c45,0x16128,0x16127,
0x16126,0x23e5f,0xe3770,0x00000,0x00000,0x00000,0x24569,0x16564,
0x16565,0xe4346,0x24568,0x24567,0xe4347,0x00000,0x00000,0xe657c,
0x24c51,0x16a24,0x16a23,0x24c52,0x24c53,0x00000,0x16e2c,0x16e2b,
0xe4d5b,0x25921,0x2525b,0x2525d,0x2525c,0x2587e,0x2587c,0x25922,
0x2587d,0x00000,0x1715d,0xe522f,0x00000,0xe522e,0x25e24,0x17455,
0x25e25,0x25e26,0xe5568,0x00000,0x17675,0x17676,0x00000,0x17a22,
0xe5e49,0xe5e48,0x17c3d,0x14721,0xe267e,0xe2721,0x00000,0xe2a47,
0xe2e4e,0x22c62,0xe2e4f,0xe2e4d,0xe2e4b,0xe2e4c,0x00000,0x00000,
0x23160,0x1573b,0xe3323,0xe3326,0xe3327,0xe3324,0x00000,0x15d7e,
0x15d7d,0xe3773,0xe3d71,0x1612a,0x23e61,0x16129,0x23e60,0xe3d70,
0x00000,0xe4349,0xe434a,0x2456a,0xe4854,0x16a25,0x24c54,0x16a26,
0xe4855,0xe5230,0xe5569,0xe556a,0x00000,0xe5849,0x17a23,0x26952,
0xe5f55,0x1484c,0x14f2a,0x22847,0xe2e51,0x15275,0xe2e50,0x15274,
0x22c63,0x22c64,0x00000,0x00000,0x23162,0x23164,0x1573c,0x00000,
0x23166,0x23169,0x23167,0xe332b,0x00000,0xe332a,0x23168,0x23165,
0x23161,0x1573d,0x2316a,0x23163,0xe332c,0x00000,0xe3778,0xe3779,
0x23776,0x15c4b,0x23821,0x15c48,0xe3777,0x23778,0x15c4c,0xe377b,
0x15c46,0xe3776,0x23773,0x23822,0x23774,0x23771,0x15c4a,0x00000,
0x15c47,0xe632d,0x23777,0x2377a,0x15c49,0x2377b,0x15c4d,0x2377c,
0x23772,0x23779,0x2377d,0x23775,0x23770,0x2376e,0xe377a,0xe657d,
0x2377e,0x00000,0x00000,0x2376f,0x00000,0x00000,0x00000,0x00000,
0x23e68,0xe3d7b,0xe3d78,0xe3d75,0x23e64,0x23e6a,0x1612d,0x23e63,
0x23e65,0x1612b,0x23e62,0x16132,0x23e66,0x16131,0x23e67,0x16133,
0x1612e,0x16134,0x1612f,0xe3d79,0x16130,0xe3d72,0x1612c,0xe3d76,
0x23e69,0xe657e,0x00000,0x00000,0x00000,0x00000,0xe434f,0x00000,
0x16568,0x24575,0xe434c,0x24578,0x2456c,0x24571,0x2456b,0x1656a,
0xe4355,0x2456f,0x00000,0xe434d,0xe3d77,0x2456d,0x16569,0xe4354,
0x24574,0x24573,0x24570,0x24572,0x2456e,0x16a2a,0x24577,0x16566,
0x24576,0xe4351,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0xe4856,0x24c64,0xe4858,0x16a31,0x24c5f,0xe4860,0x16a30,
0x24c55,0x00000,0x24c57,0x16a29,0x24c5c,0x24c5b,0x24c5e,0x16a2e,
0x24c59,0x24c58,0xe485a,0xe485e,0x16a2d,0x16a28,0x24c5a,0x16a2b,
0x24c60,0x24c62,0x00000,0x24c5d,0x24c56,0x16a2c,0xe4857,0xe485d,
0x16e34,0x16a27,0x00000,0xe485c,0x24c63,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x25261,0x16e2d,0xe4d5c,0x25263,
0x00000,0x16e2e,0xe4d65,0xe4d5d,0x16e30,0x25266,0x00000,0x2525e,
0x16a2f,0x25264,0x00000,0x00000,0x00000,0x00000,0x25260,0xe4d60,
0x16567,0x16e33,0xe6367,0xe6366,0x16e2f,0x00000,0x16e31,0x16e32,
0x00000,0x17160,0x25265,0x2525f,0x16e35,0xe4d63,0x25262,0x00000,
0xe6621,0x00000,0x00000,0x00000,0x2592c,0x25927,0x00000,0x00000,
0x25931,0x1715e,0x25929,0x17162,0x2592f,0x25926,0x25923,0x25932,
0x1745b,0x17163,0x2592e,0x25924,0x17161,0x25928,0x17165,0x25925,
0x2592a,0x17164,0x2592d,0x25930,0xe5233,0xe5234,0x00000,0x00000,
0x25e38,0x25e39,0x25e29,0x25e30,0x25e2e,0x00000,0xe556d,0x17459,
0x25e35,0x2592b,0xe556b,0x25e2c,0xe556e,0x25e36,0x17458,0x25e2b,
0x25e2a,0x25e34,0x25e31,0x25e33,0x00000,0x25e27,0x25e37,0x17456,
0xe5570,0x25e32,0x25e3b,0x25e2f,0x1745a,0x17457,0x25e2d,0x25e28,
0x25e3a,0x1715f,0xe5571,0x00000,0x00000,0x00000,0x00000,0x00000,
0xe556f,0x2624f,0xe5850,0xe584e,0x2624d,0x26253,0x1767a,0x26251,
0x26250,0x1767c,0x26256,0x1767b,0xe5851,0x26257,0x26254,0x17678,
0x26255,0x2624e,0x17679,0x17677,0x26635,0x26252,0xe584c,0xe6622,
0x26258,0x00000,0xe6623,0x26632,0xe5a6f,0xe5a6e,0x00000,0x1785d,
0x1785b,0x26634,0x00000,0x26636,0x26633,0x1785c,0x17859,0x1785a,
0x1785e,0x00000,0xe6624,0x17a25,0xe5c66,0x26957,0x00000,0x26956,
0x26954,0x26953,0x26955,0xe5c65,0x17a24,0x17a26,0xe6625,0x00000,
0x17a7b,0xe5e4c,0x00000,0x26b73,0x26b72,0x00000,0xe5e4b,0x26d68,
0xe5f58,0x26d6a,0x26d6c,0x26d6b,0x26d69,0xe5f57,0xe603f,0x17b6d,
0x17b6c,0x00000,0xe603e,0x17c3f,0x17c3e,0x17c40,0x26f3c,0x26f3b,
0xe6626,0x2712b,0x27046,0x2712c,0x17d25,0xe6144,0x17d26,0x2715c,
0x00000,0xe623a,0x17d4b,0x1484d,0xe2a49,0x22848,0xe2a48,0xe2e52,
0x22c66,0x22c67,0x22c65,0xe2e54,0xe2e53,0x15276,0x00000,0x22c68,
0x22c69,0x22c6a,0x00000,0xe3331,0x2316b,0x23171,0xe332e,0xe3330,
0x2316f,0x1573e,0x2316d,0xe3332,0x2316e,0x23170,0xe332d,0x00000,
0x00000,0x2316c,0x15c4e,0xe377d,0x23823,0x15c50,0x23825,0x15c4f,
0x23824,0xe377e,0xe3821,0xe383e,0xe3822,0x00000,0x23e6c,0x16135,
0xe3e21,0x23e6e,0x23e6b,0x23826,0xe3e23,0x16136,0xe3e22,0xe3d7e,
0x23e6d,0xe6627,0x00000,0x00000,0x00000,0x00000,0xe4358,0x2457b,
0xe435c,0x1656b,0x24579,0x1656c,0x2457a,0x1656d,0x00000,0xe4862,
0xe4861,0x16a32,0x24c68,0x24c65,0x24c67,0x16a33,0x16a34,0x24c66,
0x00000,0x00000,0xe4d6f,0xe4d71,0xe4d6d,0x25267,0xe4d70,0xe4d73,
0x25268,0xe4d72,0x16e36,0x2526a,0x25269,0xe4d6e,0x12323,0x00000,
0x25936,0x25937,0x25933,0xe5237,0x25934,0x17166,0x17167,0x25935,
0x00000,0x17461,0xe5575,0xe5574,0x1745d,0x17462,0x1745e,0x17460,
0x1745c,0xe5239,0x1745f,0xe5855,0x00000,0x00000,0xe5854,0x1767d,
0x25e3c,0x00000,0x26638,0x00000,0x26637,0xe6628,0x26958,0x17a27,
0x17a28,0x26d6e,0x26b74,0xe6169,0x26d6d,0xe6040,0x2712d,0x27172,
0x1484e,0x00000,0xe2722,0x14b37,0xe2a4b,0x22849,0x14f2b,0xe2a4a,
0x15279,0x22c6d,0x15277,0x22c6b,0x1527c,0x15278,0x1527d,0x1527b,
0x22c6c,0x1527a,0x15742,0x15741,0x2317c,0x1574a,0x23175,0x2317b,
0x15746,0x23174,0x2317a,0x23178,0x15745,0x15747,0x23177,0x15740,
0x23176,0x1574b,0x15748,0x1574c,0x15749,0x23173,0x23172,0x23179,
0x15743,0x1573f,0x15744,0x00000,0xe3337,0xe333b,0x00000,0x00000,
0x23835,0x2382e,0x00000,0x1613b,0x2382d,0xe3829,0x15c54,0x15c5b,
0x15c58,0x15c5e,0x15c5d,0x15c59,0xe3826,0x23827,0x2382a,0xe3827,
0x23829,0x15c55,0x2382b,0x23834,0x15c56,0x23828,0x23831,0x23832,
0x15c57,0x2382f,0x15c5c,0x15c52,0x15c5a,0x2382c,0x15c51,0x23830,
0xe382e,0xe3824,0x23833,0x00000,0xe382b,0xe3e34,0x23f21,0x23e76,
0x16138,0x23e7d,0x23e7a,0x23e72,0x23e7b,0x1613a,0x23e73,0xe3e29,
0x23e6f,0xe3e26,0xe3e2e,0x16573,0x23e78,0xe3e2f,0x16137,0x23e7e,
0xe3e28,0x1613e,0x16140,0x23e71,0xe3e2c,0x00000,0x1613f,0x23e74,
0x16139,0x23e7c,0x23e75,0x23e79,0xe3e2a,0x23e77,0x1613c,0x23e70,
0x16141,0x15c53,0x1613d,0x16142,0xe3e24,0xe3e35,0xe3e33,0x00000,
0xe4367,0x1656f,0x24624,0x24626,0x24628,0x2462c,0xe3e2b,0x24622,
0x2457e,0x16571,0x00000,0x24627,0x2462b,0x24623,0x2457d,0xe4366,
0x2457c,0xe4369,0xe4360,0xe4362,0x24629,0x24621,0x24625,0x16572,
0xe435e,0x16570,0x2462d,0x1656e,0x2462a,0xe4364,0x24c79,0xe4368,
0xe436a,0xe4363,0x00000,0x00000,0x16a37,0x24c71,0x16e43,0x24c7b,
0x16a3a,0x24d21,0x16a40,0x24c6c,0xe4874,0x00000,0x24c7c,0x24c69,
0xe486d,0x24c7e,0x24c6d,0xe486e,0x16a47,0x16a44,0x24c7d,0x24c77,
0x16a36,0x16a3e,0x16a3d,0xe4870,0x16a3c,0x16a42,0xe4869,0x24c6a,
0x16a43,0x24c78,0x16a3f,0x16a35,0x24c7a,0x16a38,0x16a39,0x16a41,
0x24c6f,0x24c6e,0x24c6b,0x00000,0x24c73,0x24c70,0x24c74,0x16a46,
0xe4868,0x24d22,0x16a3b,0x24c75,0x24c76,0xe4871,0x24c72,0xe4873,
0xe6629,0xe486b,0x16a45,0xe662b,0x00000,0x00000,0xe4e22,0x2526f,
0x16e3b,0x16e44,0x16e40,0x2526c,0xe4d7c,0x16e3d,0x16e41,0x25278,
0x16e37,0x25270,0xe4d78,0x16e3f,0xe4e24,0xe4e2f,0x25273,0x2526e,
0x16e3e,0x16e42,0x2526d,0xe4e2e,0x16e3c,0xe4d77,0x25277,0x16e39,
0x25276,0x25275,0x16e45,0x2503b,0x16e38,0xe4e2b,0x25274,0x2526b,
0xe4d75,0x16e46,0x25272,0x16e3a,0xe4e28,0xe4e29,0xe4e25,0xe4e2c,
0xe4e27,0xe4d7e,0xe4d7d,0x25271,0x00000,0x00000,0x00000,0xe662a,
0x1716a,0x1716f,0x17168,0x25944,0x2593b,0x25947,0x2593f,0x25945,
0x17170,0x17169,0x25938,0x2593e,0x25948,0x25941,0x25946,0x2593a,
0x00000,0xe523b,0x25942,0x1716b,0x25940,0x1716e,0x1716d,0x2593c,
0x2593d,0x25939,0x25943,0x1716c,0x2594a,0x25949,0xe5240,0xe523f,
0x00000,0x25e47,0x25e43,0x17469,0xe5579,0x25e3d,0x17463,0x17473,
0x25e49,0x1746b,0x17467,0x25e40,0x1746e,0x17471,0x25e4b,0x17466,
0x25e42,0x1746f,0x25e4d,0x25e4a,0x25e3e,0x1746a,0x17464,0x17472,
0x25e45,0x1746d,0x25e3f,0x17468,0x25e4c,0x1746c,0x17465,0x25e46,
0x17470,0x25e44,0x00000,0x00000,0x25e48,0xe557a,0x00000,0xe5859,
0x2625a,0x26260,0x17725,0x26263,0x1767e,0x17721,0x2625b,0x26262,
0x2625d,0x17726,0x17723,0xe585b,0x26259,0xe5858,0x17722,0x2625f,
0x26261,0x17724,0x2625e,0x2625c,0xe662c,0x00000,0xe585a,0x00000,
0x26642,0x17862,0x17863,0x1785f,0xe5a72,0x17860,0xe5a74,0x2663e,
0x2663c,0xe5a75,0x26640,0x17864,0x26641,0x2663a,0x26639,0x2663d,
0x2663b,0x17861,0x2663f,0x26959,0x17a2b,0x17a2a,0x2695a,0xe5c6c,
0x2695c,0x2695b,0x17a2c,0x00000,0xe5e53,0xe5e50,0x26b79,0x26b76,
0x26b77,0xe5e51,0x26b75,0x26b78,0x17a7d,0x26b7a,0xe5e52,0x17a7c,
0x00000,0x26d6f,0xe5f5a,0x17c41,0x17c43,0x26f3d,0x17c42,0x27047,
0x2712f,0x27131,0x2712e,0x27130,0x17d39,0x00000,0xe6235,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
/* 0x7f00 */
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x1484f,0x00000,
0x1527e,0x23052,0x1574d,0xe3831,0x00000,0x15c5f,0x23f22,0x23f23,
0xe662d,0xe4877,0x00000,0x2594b,0x17474,0x25e4e,0xe557d,0xe585c,
0x17727,0x00000,0x26644,0x26643,0x17a2d,0x26b7b,0xe5f5b,0x26d70,
0x17c64,0x22269,0x00000,0x00000,0x14f2c,0x14b38,0x00000,0x00000,
0x22c6e,0xe2a4e,0x00000,0x23224,0x2317d,0x23223,0x23221,0x1574e,
0x23222,0x2317e,0xe333c,0x23836,0x00000,0x23f24,0x23f25,0x24630,
0x24631,0x16575,0x16576,0x2462f,0x24632,0x2462e,0x16574,0xe4878,
0x16a48,0xe4879,0x16577,0x24d23,0x00000,0x16e47,0x25279,0x16e48,
0xe4e30,0x17171,0x2594e,0x2594c,0x2594d,0x25e51,0x25e50,0x25e4f,
0x00000,0x00000,0x00000,0x26645,0xe6422,0x17865,0x26646,0x26d71,
0x17c65,0x27048,0x14850,0x14f2e,0x14f2d,0x22c70,0x15321,0xe2e5d,
0x00000,0x22c6f,0x23226,0xe333d,0x1574f,0x23837,0x23225,0xe333f,
0x00000,0xe333e,0x15c61,0x2383a,0x23838,0x23839,0x15c60,0x00000,
0x23f27,0x23f28,0x23f26,0xe436e,0x1657a,0x24634,0x24633,0x24635,
0x16579,0x16578,0x00000,0x00000,0x2527a,0x2527c,0xe4e31,0x16e49,
0x2527b,0x2594f,0x17172,0x26265,0xe585d,0x26264,0x17866,0x26647,
0x17868,0x17867,0x2695d,0x26b7c,0x17a7e,0x14851,0x22c71,0x15322,
0x23229,0x15751,0x23228,0x23227,0xe3342,0x15750,0xe3343,0x23840,
0x00000,0x23842,0x2383b,0x2383c,0x15c62,0x2383d,0x15c63,0x23841,
0x2383e,0x2383f,0x15c64,0xe3e37,0x16144,0x16145,0xe3e38,0x23f29,
0x00000,0x00000,0x00000,0x24636,0x24637,0xe4372,0x24d27,0x16a4b,
0x16a49,0x16a4a,0x24d24,0x24d25,0x00000,0x24d26,0x25323,0xe4e32,
0x25324,0x16e4a,0x25321,0x2527e,0x25322,0x2527d,0x17175,0x25950,
0x17173,0x17174,0x25e53,0x17475,0x25e52,0x26134,0xe557e,0x26266,
0x26267,0x17728,0xe5861,0x17729,0x17476,0x26648,0x26649,0x2695e,
0x17a2e,0x14852,0xe667b,0x14853,0x15753,0x14f2f,0x15752,0x22c72,
0xe3836,0x00000,0xe3344,0x16146,0x14854,0x15324,0x22c73,0x22c74,
0x15323,0x15325,0x14855,0x00000,0x22c75,0x15755,0x2322a,0x15757,
0x15754,0x15756,0xe3837,0x23845,0x15c65,0xe3839,0x23844,0x23843,
0x00000,0x24638,0x00000,0xe4922,0x24d28,0x00000,0x16e4b,0x00000,
0x17176,0x25952,0x25951,0xe5621,0x25e54,0x00000,0xe5862,0xe5c6f,
0x26b7d,0x00000,0x00000,0x14856,0x22473,0x2284a,0x15326,0x22c76,
0x00000,0x2322c,0x00000,0xe3349,0xe3348,0x15758,0x2322b,0x15759,
0xe3347,0xe662f,0x00000,0x23847,0xe383d,0xe383c,0x15c67,0x23846,
0x23848,0xe383b,0x15c66,0x00000,0x00000,0x00000,0xe3e3c,0x23f2b,
0x23f2c,0x23f2a,0x16147,0xe6729,0x00000,0x00000,0x1657b,0xe4373,
0x1657c,0xe6356,0x16a4d,0xe4923,0x24d2a,0x24d29,0x16a4c,0xe4926,
0xe3e3b,0xe4925,0x00000,0xe6630,0x25325,0xe4e34,0xe4e36,0x25326,
0xe4e37,0x00000,0xe4e35,0xe4e38,0x25953,0x00000,0xe5243,0x1747a,
0x17479,0x17477,0x17478,0x1747b,0xe5622,0x26268,0x1772b,0x1772a,
0x2664a,0x2695f,0xe5c70,0xe5c71,0xe5c72,0x17b6f,0x17b6e,0x14857,
0x00000,0x00000,0x22f7d,0x00000,0x1657e,0x16148,0x1657d,0x16a4e,
0x00000,0x14858,0x22168,0x14859,0x1485a,0xe2435,0xe2436,0x2284b,
0x22476,0xe2724,0x22477,0x14b3a,0xe2726,0x22474,0x14b39,0xe2725,
0x14b3c,0x22475,0x14b3e,0x14b3d,0x22478,0x14b3b,0x00000,0xe2723,
0x00000,0x14f34,0x14f32,0x2284d,0xe2a56,0x14f31,0xe2a5b,0xe2a58,
0xe2a4f,0x14f36,0x14f38,0x14f35,0xe2a59,0x22850,0x2284c,0x14f39,
0xe2a52,0x14f33,0x14b3f,0xe2a54,0x14f37,0x2284f,0xe2a57,0x00000,
0x2284e,0x00000,0x14f30,0xe6631,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x22c7c,0x1532a,0x1532b,0x22c7e,0xe2e66,0x22c78,
0x22c7b,0x22d26,0x22d24,0xe2e60,0x1532c,0x22d2a,0x1532f,0x22d27,
0x22c7d,0x22c7a,0xe2e61,0xe2e5e,0x23f2e,0x22d25,0x15327,0x22d28,
0x22c77,0x22d22,0x15329,0x1532e,0x22d23,0x15332,0x15330,0xe2e65,
0x22c79,0x1532d,0xe2e64,0x22d21,0x15331,0x15328,0x22d29,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x1575e,0xe334c,0x15767,
0x1575c,0x1575a,0x2322e,0x15762,0x1575f,0x23230,0xe334a,0xe3352,
0x15761,0x2322f,0x2322d,0x23232,0x15766,0x15764,0x23f2d,0xe334b,
0x23233,0x23231,0x1575b,0xe334e,0xe334d,0x1575d,0x15760,0xe334f,
0x15763,0xe2e63,0x15765,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0xe3e44,0x23852,0x15c69,0xe3849,
0x23849,0x2384b,0xe3847,0x2384c,0x00000,0x23854,0x23850,0x2384e,
0x00000,0x23851,0x23855,0x15c6a,0x15c6e,0x2384a,0x00000,0x23853,
0xe632e,0x15c6c,0xe3841,0x15c6b,0x2384f,0x2384d,0xe3842,0x15c68,
0x15c6d,0xe3845,0x00000,0x00000,0xe3848,0x00000,0x00000,0x00000,
0x00000,0x1614e,0x23f36,0xe3e3e,0x00000,0x23f34,0x16150,0x00000,
0xe3e43,0xe3e45,0xe3e41,0x23f2f,0x24646,0xe3e3d,0x1614f,0x23f33,
0xe3e40,0xe3e42,0x23f30,0x1614b,0x16151,0x23f35,0x1614d,0x23f32,
0x16a4f,0x1614c,0x23f31,0x16152,0x1614a,0x16149,0x00000,0x00000,
0x00000,0x00000,0x00000,0x2463e,0x2463c,0xe437b,0x24642,0xe437e,
0x2463a,0x24647,0x2463f,0xe4375,0x24639,0x16624,0x1662a,0x24644,
0x00000,0x2463d,0xe4376,0x16627,0xe4377,0xe4423,0x16625,0x24645,
0x16622,0x16621,0x24640,0x16626,0x16153,0xe437c,0x24643,0x2463b,
0x16623,0x16628,0x16629,0x00000,0x00000,0xe4422,0x00000,0x16a54,
0x16a50,0xe4927,0x16a55,0x24d2d,0xe492a,0x00000,0x24d2c,0x24d2e,
0x16a52,0x24d2b,0x16a53,0x24d31,0x24d30,0x24d2f,0x00000,0x16a51,
0x00000,0x00000,0xe4e3b,0xe4e3d,0xe4e39,0x2532a,0xe4e3c,0x2532d,
0x16e51,0x2532c,0x16e50,0x16e4c,0x16e4d,0x16e4e,0x25329,0x25328,
0x16e4f,0xe4e3a,0x2532b,0x25327,0x00000,0x00000,0x25955,0x2595f,
0x17179,0x17178,0xe5249,0x25959,0x2595b,0xe5247,0x25956,0xe5244,
0x2595a,0x25954,0x2595d,0x17177,0x2595c,0x25958,0x00000,0x2595e,
0xe5623,0x25957,0x1747e,0x25e55,0x25e5b,0x17524,0x17526,0x17523,
0x17522,0x00000,0x17521,0x1747d,0x25e56,0x25e59,0x1747c,0x25e5a,
0xe5624,0x17525,0x25e58,0x00000,0x25e57,0x1772c,0xe5865,0x1772d,
0x2626b,0x26269,0x2626a,0x00000,0xe5a77,0x2664c,0xe5a78,0x2664b,
0x17869,0x26961,0x17a2f,0x26960,0x00000,0x26b7e,0x26d72,0x17b70,
0x27132,0x27133,0x17c44,0x1485b,0x00000,0x14f3a,0x23f37,0x16a56,
0x17527,0x25e5c,0x1485c,0x00000,0x15769,0x15768,0x23f38,0xe3e47,
0x00000,0x00000,0x25960,0x1485d,0x15333,0x00000,0xe3e48,0x23f39,
0x23f3a,0x23f3b,0x16a57,0x1717a,0x1485e,0x00000,0x14f3b,0x22d2b,
0x1576a,0x23234,0x15c6f,0xe3e49,0x23f3c,0x1662b,0x00000,0x16a58,
0x1717b,0x17528,0x1772e,0x2664d,0x1485f,0x14f3c,0xe2a5d,0x00000,
0x1576b,0x23856,0x16154,0xe492b,0x16a59,0x24d32,0x2532e,0x00000,
0xe524a,0xe5868,0xe5a79,0x14860,0x16155,0x24648,0x16a5a,0x14861,
0x22851,0x22d2c,0x15334,0x00000,0xe2e68,0x23236,0x00000,0xe3357,
0x1576e,0xe3358,0x1576c,0x1576d,0x1576f,0xe3355,0x00000,0x23235,
0x00000,0x00000,0x2385b,0x23858,0x2385a,0x15c70,0x15c72,0x15c71,
0x23857,0x15c73,0x23859,0x00000,0x23f3d,0x23f3e,0x00000,0x23f3f,
0x2464b,0xe4426,0x2464c,0x00000,0x2464a,0x2464d,0x00000,0x1662c,
0xe6634,0x24649,0xe492d,0x16a5b,0xe492e,0x00000,0x25333,0x2532f,
0x25332,0x25334,0x25331,0x25330,0x00000,0x25961,0x25962,0x25963,
0x1717c,0x1717d,0x25e5e,0x25e5d,0x25e5f,0x00000,0x2626d,0x2626c,
0x00000,0x2664f,0xe5a7a,0x26650,0x2664e,0xe5a7b,0x17a30,0x00000,
0x26962,0x26963,0xe5e55,0x26d73,0x26f3e,0x27049,0x14862,0x14b40,
0x00000,0x17529,0x14863,0x00000,0x2385c,0x23f40,0xe5a7c,0x17c6c,
0x2226a,0x00000,0x00000,0xe2438,0x2226b,0x2226d,0x14864,0x2226e,
0x2226c,0x00000,0x00000,0x22522,0x22523,0x2247b,0xe2728,0x00000,
0x00000,0x00000,0x22521,0x14b42,0xe2729,0x14b43,0x2247c,0x2247a,
0x22479,0x2247d,0x14b41,0x2247e,0x22d2d,0xe272b,0x00000,0x00000,
0x22856,0x14f3f,0x22855,0x22857,0xe2a60,0x14f3e,0x2285c,0x14f42,
0x22852,0x22860,0x22866,0x14f49,0x22863,0x14f46,0xe2a6b,0x22859,
0x2285f,0x22861,0xe2a66,0x22854,0x14f45,0x14f40,0x2285a,0x14f47,
0x14f4a,0x14f44,0xe2a6c,0x14f3d,0x2285e,0x22858,0x22865,0x14f4c,
0x14f48,0x14f43,0x2285d,0x15770,0x2285b,0x14f41,0x14f4b,0x00000,
0x22853,0x00000,0x22862,0x22864,0xe2a5e,0x00000,0x00000,0x00000,
0x00000,0xe2a68,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0xe2e76,0x15345,0x1533f,0x15347,0x15344,0x22d34,0x22d37,0x15340,
0xe2e6a,0x22d2e,0x00000,0x15339,0x15343,0xe2e6b,0x15346,0x15348,
0x22d43,0x22d3a,0xe2e78,0x15338,0x22d42,0x1533c,0x1533a,0x15335,
0x22d32,0xe2e72,0x22d41,0x22d36,0x22d39,0x22d46,0xe2e74,0x15349,
0x22d40,0x15341,0x22d3b,0x22d45,0x22d38,0x22d3c,0x22d3f,0xe2e69,
0xe2e6e,0x22d30,0x22d44,0x22d3e,0xe2e6f,0xe2e7a,0x22d2f,0x00000,
0x22d33,0x15342,0x1533d,0x15336,0x1533b,0x15337,0x1534a,0x22d31,
0x23247,0x1533e,0x00000,0xe2e79,0x22d3d,0x22942,0xe2e77,0x00000,
0xe6635,0x00000,0xe6637,0x00000,0x00000,0x00000,0x2324a,0x1577e,
0xe3362,0x2323a,0x00000,0x23245,0x23241,0xe384d,0x23254,0xe3359,
0x2324c,0xe335f,0x23242,0xe385b,0x2324b,0x2323c,0x23240,0x23257,
0x15823,0x2324f,0x23246,0x15771,0x23255,0x23238,0x00000,0x2324e,
0x00000,0x15822,0x1577b,0x23237,0x15779,0x15778,0x1577d,0x2324d,
0x15775,0x1577c,0x22d35,0x23f41,0x23248,0x00000,0xe2a5f,0x2323e,
0x15821,0x2323f,0x23243,0x15824,0x23239,0x23251,0xe3e57,0x23250,
0x23258,0x15777,0x15774,0x23256,0x23252,0x23249,0x23244,0x1577a,
0x15776,0x2323b,0x15772,0x23253,0x15773,0x00000,0x2323d,0xe335a,
0xe3363,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0xe6636,0xe2d33,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0xe384e,0xe3851,0x23862,0x23864,0x23869,0x2387d,0x15d23,
0x15c77,0xe3854,0x23861,0x15d24,0x15d25,0x2386c,0x23873,0x23879,
0xe3850,0x23866,0x00000,0x2386d,0xe384f,0xe385d,0x15d26,0x2387b,
0x23876,0x15d21,0x15c7d,0x23872,0x2386e,0x23860,0x15c74,0x23865,
0x2385d,0xe3855,0x15c7c,0x15c7e,0x2386a,0x23867,0x15c79,0x23877,
0x15c76,0x23868,0x23f6a,0x23870,0xe385e,0x2386f,0x15c75,0xe3857,
0x15d22,0xe3852,0x15c78,0x2385e,0x23863,0x23874,0x2387a,0x15d27,
0x2385f,0x2386b,0x23871,0x15c7b,0x00000,0xe3858,0x2387c,0x23875,
0x23878,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0xe385f,
0x00000,0x00000,0x00000,0x00000,0x00000,0x15c7a,0x00000,0x23f51,
0x23f45,0x1615d,0x23f62,0x23f6b,0x23f6e,0x1615b,0x23f4d,0x23f66,
0x23f4e,0x23f5c,0x16168,0x23f58,0x16165,0xe3e5e,0x23f59,0x23f42,
0x00000,0x23f67,0xe3e4f,0xe3e59,0x1616e,0x23f64,0x23f5a,0x23f70,
0x23f55,0x2466d,0xe3e4d,0x23f73,0x1616c,0x23f53,0x23f5f,0x1616f,
0x1615a,0x23f57,0x23f71,0x23f50,0x23f49,0x23f54,0xe3e5f,0x23f48,
0x23f46,0x16156,0x23f68,0x23f4f,0x23f6c,0xe3e4b,0x23f6d,0x1615e,
0x16163,0x1615f,0x16167,0x23f63,0x16160,0x23f5b,0x23f4b,0x00000,
0x16158,0x23f43,0x23f65,0x23f6f,0x23f4a,0x16166,0x23f74,0x23f56,
0xe3e52,0x23f52,0xe3e5c,0x16157,0x1616b,0xe3e5a,0x23f61,0x1616d,
0xe3e50,0x23f5d,0x16162,0x1615c,0x16164,0x16159,0x1616a,0x23f5e,
0x23f4c,0x23f60,0x23f47,0x23f69,0xe3e58,0x00000,0xe3e5d,0xe3e56,
0xe3e4e,0x00000,0x00000,0x23f72,0x00000,0x00000,0xe6639,0xe3e5b,
0x00000,0xe6638,0x00000,0x23f44,0x00000,0x00000,0x00000,0x00000,
0x00000,0x2466c,0xe442d,0x24724,0x1655c,0x24671,0xe4431,0x2466f,
0x2465a,0x16630,0x2466a,0x2467e,0x24666,0x16638,0x2467d,0x24664,
0x16169,0x24674,0x24665,0x2467b,0x16637,0x1662f,0xe443a,0x2464f,
0x24657,0xe4435,0x24670,0x24668,0x24723,0x2466b,0x1663d,0x2467c,
0xe442c,0x16634,0xe443e,0x2466e,0x24676,0x2465b,0x24675,0xe4427,
0x24728,0x24656,0x24677,0xe4433,0x24726,0xe443f,0x24650,0x16161,
0xe4440,0x2465e,0x2465d,0x16636,0xe4432,0x24661,0x24663,0x24672,
0x24725,0x16639,0xe4438,0x1663a,0xe4430,0x24655,0x16632,0x24659,
0x24721,0x1663b,0x00000,0x16633,0x16635,0x1663c,0x24727,0x24678,
0x24673,0xe443c,0xe442f,0x24660,0x2465f,0x16631,0x24651,0x1662e,
0x24669,0x24652,0x24667,0xe442e,0x00000,0x2465c,0x24722,0xe442a,
0xe4439,0x00000,0x1662d,0xe443b,0xe4428,0x00000,0x24658,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x24654,0x2467a,0x24653,
0x16a68,0x24d5a,0xe4935,0xe4944,0x24d49,0xe4933,0xe4938,0x24d33,
0x24d51,0x16a60,0x24d42,0x24d4c,0x16a63,0x24d45,0x16a61,0x24d36,
0x24d54,0x24d35,0x24d48,0xe493c,0x24d34,0xe4939,0x00000,0x24d46,
0x24d4f,0x24d4d,0x24d41,0x24d3c,0x24d3a,0xe4942,0x24d3b,0x24d4e,
0x24d59,0x24d43,0x16a62,0xe493b,0x24d3e,0xe493a,0x24d52,0xe4941,
0x16a65,0x24d3d,0x24d37,0x24d47,0x16a69,0xe4932,0x00000,0x16a5d,
0x16a66,0x24d3f,0x24d39,0xe4936,0x16a5f,0x24679,0x16a5e,0x24d4a,
0xe4436,0x16a5c,0x16a6b,0x16a64,0x24d4b,0x24d40,0x24d38,0x24d53,
0x24d44,0x16a6a,0x24d57,0x16a67,0x24d56,0xe493f,0x24d50,0x24d55,
0xe493e,0x00000,0xe4943,0x24d58,0x00000,0x00000,0xe663b,0x00000,
0x00000,0xe663c,0xe663a,0x00000,0xe493d,0x00000,0x00000,0x2535c,
0x2535d,0x25350,0x2534f,0x2534b,0x16e5d,0xe4e4f,0x16e55,0x2535f,
0x2535e,0x2464e,0x25348,0x2534c,0x25346,0xe4e44,0x25359,0x2534a,
0xe4e42,0x25360,0x25343,0x25341,0x2534d,0x25357,0x25352,0x16e5f,
0x25338,0xe4e40,0x25356,0xe4e4c,0xe4e46,0xe4e54,0x16e60,0x24662,
0x25344,0x2533b,0x2533e,0x25364,0x25345,0x2533c,0x2533a,0x25337,
0x00000,0x16e59,0x2534e,0x16e58,0x16e5c,0x25349,0x25351,0x16e52,
0x25361,0x25365,0x16e54,0xe4e4b,0x25340,0x25354,0x25358,0x2533d,
0x25362,0x16e5b,0x00000,0x16e5a,0x25335,0x16e5e,0x2535b,0x2533f,
0x25353,0x25339,0x25347,0x25342,0x16e56,0x16e57,0x25355,0x25366,
0x25363,0x2535a,0x00000,0xe4e4d,0xe4e4e,0xe4e52,0x00000,0x00000,
0x00000,0x00000,0x00000,0x25336,0x00000,0x16e53,0x25974,0xe525a,
0x2596b,0x2596e,0xe5252,0x17225,0x25970,0x25965,0x2596c,0x25972,
0x17222,0x17226,0x1717e,0xe5259,0xe5250,0x25967,0x25977,0x00000,
0x00000,0x25971,0x00000,0x25968,0x25a22,0x2597a,0x25964,0x25e72,
0x2596a,0x17221,0xe5258,0x25975,0xe5254,0x25a21,0x17229,0xe5256,
0x2597c,0x25969,0x2596f,0x25973,0x2596d,0x25a23,0x2597e,0x2597b,
0x17223,0x17224,0x17228,0x25966,0x25a24,0x17227,0x25978,0xe524f,
0xe5255,0x25976,0x00000,0xe663d,0x00000,0x25979,0x25f21,0x25e6c,
0x25e71,0x25e7e,0x25e70,0x25e68,0x25e6d,0x00000,0x1752c,0xe562b,
0x25e61,0x25e79,0x25e7b,0x25e60,0x1752b,0x25e7d,0x25e75,0x17532,
0x25e7c,0x25e6e,0x17534,0x25e66,0x2597d,0x25e76,0x25e73,0x25e62,
0x25f23,0x1752e,0xe5628,0xe5629,0x1752f,0x25e64,0x25e74,0xe562d,
0x25f22,0x25e77,0x25e6a,0x17531,0x1752d,0x25e78,0x25e6b,0x25f24,
0x25e65,0x25e6f,0x25e7a,0x25e67,0x25e69,0x00000,0x17535,0x25e63,
0x17533,0x17730,0x1752a,0xe562c,0xe5630,0x00000,0x00000,0x17530,
0x17734,0x2627d,0xe586c,0x26273,0x2626e,0x26274,0x2627e,0x26324,
0x26323,0x17736,0x17735,0xe586e,0x00000,0x26275,0x26325,0x26278,
0x26270,0xe586f,0x26272,0x26271,0x26277,0x2627c,0x2626f,0x26276,
0x2627b,0x17733,0x00000,0x26279,0xe586b,0x17731,0x2627a,0x1772f,
0x17732,0x26660,0x26321,0x00000,0xe663e,0x1786d,0xe5a7e,0x26658,
0x2665c,0x26654,0x26657,0xe5a7d,0x2665f,0x1786b,0x26664,0x2665d,
0x00000,0x26655,0x26665,0x2665e,0x1786e,0x1786f,0x26662,0xe5b22,
0x26656,0x1786a,0x1786c,0x26651,0x26659,0x26653,0xe5c7b,0x26663,
0x26661,0x26652,0x2665a,0x00000,0xe5b25,0xe663f,0x2696a,0x17870,
0x2665b,0x17a32,0x17a34,0x17a31,0xe5c76,0x2696f,0x26967,0x26965,
0x26969,0x26966,0xe5c78,0xe5c7c,0x2696b,0x2696d,0x17a35,0x17a37,
0xe5d22,0x2696c,0x17a38,0x17a36,0x2696e,0xe5c7e,0x00000,0xe5d23,
0xe5c77,0x17a33,0x00000,0xe5d21,0x00000,0xe5e5b,0xe5e5a,0x17b21,
0x26c21,0x26c27,0x17b23,0x26968,0x26c26,0xe5e5c,0x26c2d,0x26c24,
0x26c2b,0x26c2a,0x26964,0x26c25,0x26322,0x26c2e,0x26c23,0x26c28,
0xe5e58,0x26c2c,0x26c22,0xe5e56,0x26d77,0x17b22,0x26c29,0xe5e57,
0x00000,0x26f43,0x26d78,0x26d76,0x26d74,0x26d75,0x26d79,0xe6640,
0x17c45,0x26f41,0x26f3f,0x26f44,0x26f42,0xe6043,0x26f45,0x17c46,
0x26f40,0xe602f,0xe6146,0x2704a,0x00000,0xe6641,0x27134,0x27135,
0x27136,0xe6147,0xe617c,0x27235,0x2722d,0x2226f,0x14f4d,0x00000,
0x1534b,0x00000,0x2325a,0x23259,0x15825,0x15d28,0x23921,0xe3863,
0xe3860,0x2387e,0xe3861,0x16170,0x1663f,0xe3e61,0x1663e,0x16640,
0x00000,0x24d5b,0x25367,0x25a25,0x25a27,0x25a26,0x00000,0x17536,
0x25f25,0x26326,0x27173,0x14865,0xe272d,0x22869,0x2286a,0x22868,
0x22867,0x14f4e,0xe6642,0x22d4a,0x22d48,0xe2f23,0xe2e7c,0x22d47,
0xe2e7e,0x1534c,0x1534e,0x1534d,0x22d49,0xe2f24,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0xe3369,0x23266,0x23263,0x23261,
0x00000,0xe336c,0x15826,0x23264,0x1582b,0x2325e,0x2326d,0xe336f,
0x2326f,0x2325f,0xe336e,0x15828,0x23270,0x2326b,0x2325d,0x23262,
0x2326c,0x23268,0x23265,0xe336b,0x1582d,0x2326e,0x23260,0xe336a,
0xe3370,0x23269,0x2325b,0x1582c,0x15829,0x23267,0xe336d,0x2326a,
0x2325c,0x1582a,0x15827,0x00000,0x00000,0x00000,0xe3866,0x15d32,
0x23928,0x15d31,0xe3864,0x2392b,0x2392e,0x15d2e,0x15d2c,0x23923,
0x2392c,0x2392a,0x23927,0x2392f,0x23930,0x23932,0x23933,0x23922,
0x15d2b,0x23925,0x23924,0x23931,0x15d2d,0x23926,0x15d2f,0x15d2a,
0x23929,0x15d33,0x00000,0x15d30,0x2392d,0x00000,0x00000,0x00000,
0x16177,0x24025,0x00000,0x23f78,0x16174,0xe3e62,0x2472e,0x24023,
0x23f75,0x16172,0x23f7a,0x16175,0x23f7e,0x23f7c,0x16178,0x16171,
0x00000,0xe3e63,0x23f76,0x23f79,0x16176,0x00000,0x23f77,0x00000,
0x24024,0x24022,0x23f7b,0x23f7d,0x24021,0x16173,0xe3e68,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x2472f,0x24735,0x2472b,
0x24731,0x16641,0x2472d,0x16647,0xe4444,0xe4445,0x16646,0xe4449,
0x16645,0x24734,0x16648,0x16649,0x2472a,0x24737,0x1664a,0x16644,
0x16643,0x24733,0x1664b,0x24729,0x2472c,0x24736,0x24732,0x00000,
0x00000,0x24d7b,0x24d70,0x16642,0x00000,0xe4446,0xe4448,0x00000,
0x16a72,0x24d64,0x24d79,0x24d65,0x16a6d,0xe494f,0x24d62,0x00000,
0x24d6b,0x24d63,0x16a6f,0x24d5d,0x24d78,0x16a70,0x24d75,0x24d76,
0x24d5e,0x16a75,0x24d6d,0xe494a,0x24d67,0x24d6e,0x24d61,0x00000,
0x24d7a,0x24d72,0x24d6c,0x24d5c,0x16a71,0x24d73,0xe4945,0x16a74,
0x24d77,0xe494c,0x24d71,0x16a6e,0x24d6f,0xe4949,0x24d69,0x16a6c,
0x24d60,0x24d68,0x24d74,0x24d66,0x00000,0xe494e,0x24d6a,0xe494b,
0x00000,0x00000,0xe6643,0x00000,0x16e6a,0x24730,0x25379,0x25424,
0x25378,0x25374,0x25371,0x16e6b,0x2536f,0x16a73,0x25368,0x16e69,
0x2536e,0x16e68,0x25373,0x25370,0x25422,0x2537b,0x25375,0x2537a,
0x16e64,0x25372,0x25427,0x25369,0x2536a,0x25423,0x16e65,0x25428,
0x16e67,0x25429,0x25377,0x24d5f,0x2537d,0x25376,0x25421,0x2537c,
0x00000,0xe4e5d,0x00000,0x2536d,0x16e62,0x25426,0x16e63,0x2536b,
0x16e66,0x25a32,0x2537e,0x25425,0x00000,0xe4e59,0x00000,0x00000,
0x00000,0x25a2f,0x16e61,0x1722a,0x25a39,0x25a35,0x00000,0x25a33,
0x25a2e,0x25a3d,0xe525b,0xe525d,0x00000,0x1722e,0xe525f,0x25a2a,
0x25a36,0x25a37,0x25a2d,0x25a2c,0x25a3a,0x00000,0x25a30,0x25a2b,
0x25a31,0xe5262,0x25a3c,0x25a29,0x25a3b,0x25a38,0x1722c,0x1722b,
0x00000,0xe525e,0x1722d,0x25a34,0x25a28,0xe6645,0x00000,0x00000,
0x00000,0xe6644,0x25f27,0x1753c,0x25f2b,0x25f28,0x25f2f,0x25f35,
0x25f2a,0xe563a,0x25f3e,0x17539,0x25f38,0x25f2d,0x25f39,0x25f34,
0x25f3b,0x25f2c,0x1753e,0x1753d,0x25f2e,0x25f3c,0x25f26,0x25f3a,
0x17537,0xe5639,0x25f32,0x25f31,0x25f36,0x25f29,0x1753b,0xe563b,
0x1753f,0x25f30,0x25f37,0x17540,0x25f33,0xe5636,0xe5634,0x00000,
0x00000,0x17538,0x1753a,0x26333,0x26331,0xe5b28,0xe5876,0x26337,
0x26335,0x26338,0xe5878,0x2632a,0x26332,0x2633c,0x25f3d,0x2632e,
0x1773a,0x2536c,0x26329,0x26336,0x26330,0x2632d,0x26328,0x26327,
0x2633b,0xe5873,0x2632c,0x2632b,0x17738,0x26334,0xe5874,0x17737,
0xe5875,0x00000,0x17739,0x2632f,0x2633a,0xe6646,0x26669,0x2666a,
0xe5b2c,0x17874,0x26667,0x17871,0x2666f,0xe5b27,0x17875,0x26671,
0x26666,0x26339,0x26673,0x26668,0x00000,0x17872,0x2666e,0xe5b29,
0x26670,0x2666b,0x26672,0x2666d,0x2666c,0x17873,0xe5877,0xe5b2b,
0x26971,0x26972,0xe5d25,0x26974,0x17a39,0x17a3a,0x26975,0x26973,
0xe5d24,0x26970,0xe5e5d,0x26c31,0x26c34,0x26c30,0x00000,0x17b27,
0x26c32,0x17b26,0x17b25,0x17b24,0x26c33,0x26d7e,0x26d7c,0xe5f5f,
0x26d7b,0x26c2f,0x26d7d,0x26c35,0x26d7a,0xe6045,0x26f48,0x26f26,
0x26f46,0x17c47,0x26f47,0x26f49,0xe6647,0x2704d,0x17c66,0x2704c,
0x2704b,0x17c67,0x00000,0x17d27,0x2715d,0x27175,0x27174,0x27176,
0x14866,0x22d4b,0xe2f26,0x23271,0x23272,0xe386a,0xe3e6a,0xe3e69,
0x24026,0x00000,0x26c36,0x2704e,0x14867,0x1534f,0x22d4c,0xe3371,
0xe6648,0x00000,0x23934,0x15d34,0x00000,0x24028,0x24027,0x16179,
0xe444d,0x1664c,0x2542a,0x16e6c,0xe4e5f,0x16e6d,0xe5263,0xe5264,
0x00000,0x1722f,0x17c68,0x14868,0x00000,0x00000,0xe2f27,0x22d4d,
0x14f50,0x22d4f,0x22d4e,0x15350,0x00000,0x23273,0xe3374,0x2327a,
0x1582e,0x23278,0x23276,0xe3377,0x2327d,0x23274,0x23275,0x1582f,
0xe3372,0x15833,0xe3373,0xe3375,0x2327e,0x15832,0x2327c,0x23279,
0x23277,0x15830,0x15831,0x2327b,0xe3376,0x00000,0x00000,0xe6649,
0x15d36,0x23935,0xe3872,0x15d3b,0x23945,0x15d3a,0x23947,0xe386e,
0xe3874,0x2393b,0x15d38,0x23946,0xe386c,0x23936,0x15d39,0x23942,
0x2393e,0x23940,0x2393a,0x23941,0xe386b,0x00000,0x15d35,0x2393d,
0xe3873,0x2393c,0x23938,0xe386d,0x23943,0xe386f,0xe3871,0x2393f,
0x23937,0xe3870,0x23939,0x15d37,0x23944,0x00000,0x00000,0x00000,
0x00000,0x1617c,0x24033,0x00000,0xe3e70,0xe3e72,0x2402f,0x24031,
0x2402c,0x2402b,0x24029,0xe3e6d,0x24030,0x24032,0x2402e,0xe3e6f,
0x2402d,0x1617a,0x1617b,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x24035,0x16654,0x24739,0x2473f,0x2473a,0x2473b,0xe444e,
0x24740,0x00000,0x16656,0x00000,0x1664e,0x16655,0x24738,0x2402a,
0x16651,0x1664f,0x2473e,0x2473d,0x16650,0x16652,0x2473c,0x1664d,
0xe444f,0x16653,0x00000,0x00000,0x00000,0x00000,0xe4e60,0x24d7d,
0x16a7c,0xe4959,0xe4952,0x24e2a,0x24e29,0xe4957,0x24e24,0x16a7e,
0x24e28,0x24d7e,0x24e21,0x16a76,0x16a78,0xe4954,0x24e26,0x24d7c,
0x16a7a,0x16a79,0x24e22,0x24e27,0x24e25,0x16a7b,0x24e23,0xe4951,
0xe4956,0x24034,0x16a77,0xe4958,0x00000,0x2542b,0x25432,0x16e6f,
0x00000,0x25436,0x16e73,0x2542e,0x2542c,0x00000,0x25435,0xe4e61,
0x16e6e,0x25434,0x16e70,0x16e71,0x2542d,0x16e72,0x25433,0x2542f,
0x25430,0x25431,0x16a7d,0xe4e62,0x00000,0x00000,0x25a3e,0x25a4a,
0x00000,0x17234,0x25a45,0x25a47,0xe5265,0x17232,0x25a3f,0x25a43,
0x00000,0x25a46,0x17230,0x17233,0x25a49,0x25a41,0x25a42,0x25a48,
0x25a40,0x25a44,0x17231,0x25f40,0x00000,0x25f3f,0x17542,0x25f45,
0x17544,0xe5640,0x00000,0x17541,0x25f41,0x17545,0x25f42,0xe563f,
0xe563d,0x25f43,0x25f46,0xe5642,0x17543,0x00000,0x26341,0x00000,
0xe5879,0x26344,0xe587a,0x2633e,0x26340,0xe587c,0xe587b,0x2633f,
0x26342,0x26343,0x25f44,0x2633d,0xe664a,0x00000,0x17878,0x26677,
0x2667a,0x2667c,0x26675,0x26676,0x26679,0x2667b,0x17879,0x17877,
0x17876,0x26678,0x26674,0x26976,0x17a3b,0xe5d29,0x26977,0xe5d28,
0x00000,0x26c38,0x17b28,0x26c3a,0x17b29,0x26c37,0x26c39,0x17b72,
0x00000,0x26e21,0x17b71,0x26f4c,0x26f4b,0x00000,0x26f4a,0x00000,
0xe6149,0x27137,0x27138,0x2713a,0x27139,0xe617d,0x22270,0x14869,
0x00000,0x15351,0x23948,0x1617d,0xe664b,0x24741,0x1773b,0xe5b2f,
0x2667d,0xe6046,0xe614a,0x14b44,0xe2f29,0x00000,0x00000,0x15d3d,
0x00000,0xe3876,0xe3875,0x15d3c,0xe3877,0x24036,0x1617e,0x24038,
0x24037,0x00000,0xe3e74,0x24742,0x16657,0x24e2b,0x24e2e,0x24e2d,
0x00000,0x24e2c,0x25437,0x25439,0x25438,0xe4e65,0x17236,0xe5266,
0x00000,0xe4e64,0x17235,0xe5646,0x17546,0x25f47,0x25f49,0x25f48,
0xe587e,0xe587d,0x1773c,0xe5921,0x00000,0xe5b31,0x26721,0x2667e,
0x00000,0x26978,0x17a3c,0xe5d2a,0xe5e61,0x17b2a,0x26e23,0x26e22,
0x17d28,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x14b45,0x22d50,0x15352,0x2394b,0x23949,0x00000,
0x00000,0x2394a,0x2403a,0x2403b,0x24749,0x24039,0x00000,0x24743,
0x24747,0x24746,0x24748,0x16658,0x24745,0x24744,0x2474a,0xe4454,
0x24e31,0x24e2f,0xe495c,0x24e30,0x2543c,0x2543a,0xe4e66,0x00000,
0x2543b,0x25a4b,0x25f4a,0x25f4b,0x1773d,0xe5b32,0x26722,0x26979,
0x17a3d,0x00000,0x26c3b,0x26e24,0x17b73,0x00000,0x26f4d,0x2713b,
0x14b46,0x00000,0x15354,0x15355,0x22d51,0xe2f2a,0xe2f2c,0x22d52,
0x15353,0x00000,0x15839,0xe337b,0x15837,0xe337a,0x15836,0x1583d,
0x15835,0x1583e,0x23321,0x1583b,0x00000,0x15838,0x1583c,0x1583a,
0x15834,0xe337c,0x00000,0x15d45,0xe387e,0x15d3f,0x2394f,0x15d44,
0xe3923,0xe3929,0x15d46,0x15d40,0x00000,0x15d41,0xe3879,0x2394d,
0xe387b,0xe3925,0x15d3e,0xe3922,0x2394e,0x15d43,0xe6330,0x00000,
0x2394c,0x15d42,0xe387a,0x00000,0x1622b,0xe3e7c,0x1622d,0x00000,
0xe3e7d,0x2403e,0x1622c,0x16221,0x16225,0xe3f24,0x1666b,0x2474f,
0x24040,0x16226,0xe3e7e,0xe3e75,0x24043,0x24044,0x1622a,0x00000,
0x24046,0xe3f21,0x24048,0xe3f23,0x24049,0x2403d,0x2403c,0x2404a,
0x16229,0x24047,0x24045,0x00000,0x16227,0x16223,0x1622e,0x24041,
0x24042,0x2403f,0xe3e78,0x16228,0x00000,0xe3f22,0x16224,0x00000,
0x16222,0x2474e,0x16666,0x16661,0xe4460,0xe4459,0x1665c,0xe4463,
0x1666c,0x1665d,0xe4455,0x16659,0x16668,0x16665,0x16667,0xe4458,
0x1665e,0x16663,0x1665a,0x1665b,0x24756,0x24753,0x2474b,0x24750,
0xe445b,0x16669,0x24757,0x1666a,0x16660,0xe445c,0xe4461,0x2474d,
0xe4456,0x24755,0x24751,0x24754,0x24752,0x16664,0x2474c,0x1665f,
0xe445d,0x00000,0x00000,0x24e34,0x16b22,0x16b25,0xe495f,0x24e36,
0xe4964,0x16b2d,0x24e35,0x16b27,0xe4963,0x16e78,0x24e37,0x00000,
0x16b2c,0x24e33,0x16b2e,0xe495e,0xe4962,0xe496b,0x16b23,0xe4968,
0x16662,0x16b26,0xe4960,0x16b24,0x16b28,0x16b2a,0x16b21,0x16b2f,
0x16b2b,0xe4965,0x16b29,0x24e32,0xe4966,0x00000,0x00000,0xe4e74,
0x16f21,0xe4e67,0x16e7b,0xe4e72,0xe4e70,0xe4e6e,0x16f24,0xe4e6c,
0x2543f,0x16f25,0x2544b,0x25444,0x16e74,0x2544c,0x25446,0x16e7e,
0x25447,0xe4e73,0x16e7d,0x2544a,0x16e77,0x25448,0x2543e,0x16e76,
0x25a56,0x16e7c,0xe4e75,0x16e79,0xe4e69,0x16f23,0xe4e6a,0x2543d,
0xe4e76,0x25441,0x16e75,0x25440,0x25442,0x25443,0x16f22,0x25445,
0x25449,0x2544d,0x00000,0x16f26,0x1723c,0x25a51,0x25a57,0x25a54,
0x25a4c,0x25a58,0x25a4d,0xe526a,0x25a53,0xe526b,0x17237,0x1723d,
0x25a59,0xe4e6f,0xe5267,0x17239,0xe526e,0x17243,0x1723e,0x25a5b,
0x25a55,0x1723a,0x25a4e,0x17244,0x25a4f,0x25a50,0x17245,0x17242,
0x16e7a,0xe5269,0x17238,0x25a5c,0x17246,0xe5268,0x1723f,0x25a5a,
0x1723b,0x17240,0x17241,0xe664c,0x1754e,0x25f50,0x25f59,0x25f56,
0x25f58,0xe5649,0x1754b,0x25f51,0xe564a,0x25f57,0x17547,0x25f53,
0x1754f,0x25f4f,0x25f54,0x25f5b,0x25a52,0x25f55,0x25f4e,0x17548,
0x25f4d,0x17549,0x25f5c,0x1754a,0x25f5a,0x1754d,0x25f4c,0xe5648,
0x1754c,0x00000,0x25f52,0x26347,0x26355,0x26350,0x26352,0x26346,
0x1773e,0xe592a,0x26345,0x17741,0x17740,0xe5926,0x26354,0x2634c,
0x26349,0x2634f,0xe5924,0x26348,0xe5928,0x2634a,0x26353,0x26351,
0xe5923,0x1773f,0x26358,0x26356,0x2634d,0x26357,0x2634e,0xe5b34,
0x26726,0x1787a,0x2672d,0xe5b35,0x00000,0x26c3e,0x17923,0x2634b,
0x26724,0x1787d,0x26725,0x2672a,0xe5b36,0xe5d33,0x17921,0x17922,
0x26723,0x2672c,0x2672e,0x26727,0x26729,0x2672b,0x26728,0x2672f,
0x1787c,0x17924,0x1787e,0x00000,0x1787b,0x2697c,0x00000,0x17a42,
0x2697a,0xe5d30,0xe5d2c,0x2697e,0xe5d32,0x26a21,0x17a40,0x26a22,
0x2697d,0xe5d2b,0x2697b,0x17a43,0x17a3f,0x26a23,0xe5d2e,0x17a41,
0x17a3e,0xe5c6d,0x00000,0xe642d,0x17b2b,0xe5e62,0x00000,0x17b2c,
0x26c3d,0x26c3c,0x26c3f,0x26c40,0xe5e63,0x17b2d,0x26e25,0x26e2a,
0x17b74,0xe5f61,0x26e27,0xe5f62,0x26e26,0x26e29,0x26e28,0xe6048,
0x26f51,0x00000,0x17c48,0x26f50,0x26f4e,0xe6047,0x26f4f,0x00000,
0xe6049,0xe607b,0x17c6a,0x17c69,0x2704f,0x27050,0x17c6b,0xe614b,
0x2713c,0x2713d,0x17d34,0xe616b,0x17d3a,0xe617e,0x27177,0x27236,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
/* 0x8c00 */
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x14b47,
0x00000,0x23950,0xe392a,0x23951,0x24758,0x24e38,0x2544e,0x17551,
0xe564d,0x17550,0x26359,0x26730,0xe5f64,0x26f52,0x14b48,0x23322,
0x1583f,0x15d47,0x2475a,0x24759,0x16f27,0x2544f,0x16f28,0x25f5d,
0x17742,0xe5d34,0xe664d,0xe6221,0x17d43,0x14b49,0x2286b,0x23323,
0xe392d,0x00000,0x15d48,0xe392c,0x23952,0x23953,0xe3f2a,0x2404b,
0xe3f29,0x1622f,0x1666d,0xe4464,0x2475c,0x2475b,0x2475d,0xe496d,
0x24e39,0x24e3a,0x16b30,0x17247,0x16f29,0x17248,0x00000,0x25f61,
0x25f5e,0x25f60,0x25f5f,0x17552,0xe592b,0x2635a,0x26732,0x26731,
0x22524,0x15841,0x15840,0x23324,0xe392e,0x23954,0xe3f2c,0xe3f2b,
0x2404d,0x2404c,0x16230,0xe3f2d,0x2475f,0x24760,0x2475e,0xe634a,
0xe4465,0x1666f,0x1666e,0x00000,0x16b32,0x16b31,0xe4e7a,0x25450,
0x25a5f,0x25a5d,0x25a5e,0x17249,0x25f63,0x25f62,0xe564f,0x2635d,
0x2635c,0x2635b,0x26733,0xe614d,0x27178,0x14b4a,0x15356,0xe2f2e,
0x15357,0x15842,0x15843,0x23326,0x23325,0x23955,0xe3930,0x15d4e,
0x15d4c,0x15d49,0x15d4d,0x15d4b,0x15d4a,0xe3932,0xe3931,0x16231,
0x24050,0xe3f2f,0x16674,0x16233,0x16238,0x24052,0x1623a,0x16239,
0x1623c,0x24051,0x2404e,0x16236,0x16232,0x16234,0x2404f,0x1623b,
0x16237,0x16235,0x16676,0x16675,0x16673,0x16677,0x00000,0x16671,
0x16672,0xe4469,0x16670,0x00000,0x24761,0xe4467,0x00000,0x24e3c,
0xe4970,0x16b34,0x16b35,0x16b33,0xe4972,0x24e3b,0xe4971,0x24e3d,
0xe664e,0x25453,0x25455,0xe4e7e,0x16f32,0x25456,0x16f2b,0x25452,
0x16f2a,0x16f34,0x16f30,0x16f31,0x16f2d,0x25451,0x16f2c,0x25457,
0x25454,0xe4e7d,0x16f33,0xe4f22,0x16f2e,0x16f2f,0x25a61,0xe5275,
0x25a63,0x25a62,0xe5273,0x25a64,0x1724a,0x25a60,0xe5651,0xe5652,
0x17556,0x25f64,0x17553,0x17557,0x17555,0x17554,0x2635e,0x00000,
0x26361,0x00000,0x26360,0xe592e,0x2635f,0x17743,0x26734,0x26735,
0x17925,0x26736,0x17926,0xe5b38,0xe664f,0x17a45,0xe6428,0x17a44,
0x26c41,0xe5e65,0xe5e66,0x17b2e,0x26c42,0x26e2b,0x17b75,0x17b76,
0xe6650,0x26f53,0xe604a,0x17c6d,0xe614e,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x14b4b,0xe3933,0x15d50,0x15d4f,
0x24762,0x24763,0x00000,0x16b36,0x25a65,0x16f35,0x25a66,0x25f65,
0x14b4c,0xe243a,0x22d53,0x15359,0x15358,0x00000,0x23327,0x15844,
0x23328,0x23958,0xe3939,0x23957,0xe3937,0x23956,0xe3935,0xe3938,
0x24054,0x1623f,0xe3f39,0xe3f34,0x24053,0x1623e,0xe3f37,0xe3f30,
0xe3f33,0x24055,0x1623d,0xe3f38,0x24765,0x24768,0x24766,0x24767,
0x2476b,0x24764,0x2476c,0x24769,0x2476a,0x16b38,0x24e3e,0xe4975,
0xe4973,0x16b37,0xe4974,0x2545b,0x25459,0xe4f26,0x00000,0x16f36,
0x25458,0x2545a,0xe4f25,0x16f37,0xe4f23,0x25a67,0xe5277,0x25a68,
0x17558,0xe5931,0x26738,0x2673a,0x26737,0x26739,0x26a24,0x26c43,
0xe6651,0x00000,0x2715e,0x14b4d,0x1535a,0x23329,0x2332b,0x2332a,
0x00000,0x2395b,0x15d52,0xe393e,0x23959,0xe393a,0x15d51,0x2395c,
0xe393d,0x2395d,0x2395a,0x00000,0x00000,0x24061,0x16247,0x24059,
0x2405f,0xe3f3f,0xe3f3a,0x16242,0x16245,0x24058,0x16240,0x2405c,
0x24772,0x16244,0xe3f3b,0x24057,0xe3f3e,0x2405d,0x2405a,0x24060,
0x24056,0x2405e,0x16243,0x16246,0x2405b,0x16241,0x00000,0x16679,
0x2476e,0x16678,0x24775,0x24774,0x16721,0x00000,0x16722,0x24776,
0x1667a,0x24773,0x1667e,0x24778,0x2476f,0xe446b,0x24771,0x1667b,
0x2476d,0x24770,0x24777,0x1667c,0x24779,0x00000,0x00000,0x00000,
0x00000,0x00000,0x1667d,0x00000,0x16b39,0x24e43,0x24e49,0x24e41,
0x24e4a,0xe497b,0x24e40,0x24e45,0x24e4b,0x24e48,0x24e47,0x24e46,
0xe497a,0x24e3f,0x24e44,0xe4979,0x00000,0x24e42,0x00000,0x16f3c,
0x16f39,0x25464,0x25469,0x2546b,0x25468,0x25461,0x25463,0x2546d,
0x2546a,0x25465,0x2546e,0x25462,0x2546c,0x16f3a,0x16f40,0x16f3e,
0x2545c,0x16f3f,0x16f3b,0x2545d,0x2545f,0x2545e,0x25466,0x25467,
0xe4f2c,0x16f3d,0xe4f2b,0x16f38,0x00000,0x00000,0x25460,0x00000,
0x25a72,0x1724c,0xe527e,0x25a69,0x1724d,0x17250,0x25a6e,0x00000,
0x25a6b,0x1724f,0x00000,0xe527b,0x25a6f,0x25a70,0x25a6a,0x25a73,
0x25a6c,0x25a71,0x1724e,0xe527c,0x1724b,0x25a6d,0xe5654,0x25f6b,
0x1755b,0x17559,0x1755c,0x1755a,0x25f6a,0x25f67,0x25f66,0xe5655,
0x25f69,0x00000,0x00000,0x25f68,0x2636f,0x17749,0x26366,0x26365,
0xe5932,0x17744,0x2636b,0x2636a,0x26362,0x2636d,0x26367,0x17748,
0x26364,0x2636c,0x26363,0x17745,0x17747,0x26368,0x17746,0x26369,
0xe5b3a,0x2636e,0x2673e,0xe5b39,0x1792b,0x2673b,0x00000,0x2673f,
0xe5b3b,0x00000,0x17928,0x2673d,0x1792d,0xe5b3c,0x1792a,0xe5b3d,
0x2673c,0x00000,0x1792c,0x26740,0x17927,0x00000,0x00000,0x00000,
0x00000,0x17a47,0x17a49,0xe5d37,0x26a27,0x17a48,0x26a25,0x17929,
0x26a26,0x17a46,0x17b2f,0x17b31,0x26c45,0x17b30,0x26c44,0x00000,
0x26e30,0x17b77,0x26e2f,0x17b78,0x26e2d,0x26e2c,0x26e31,0x26e32,
0x26f54,0xe604b,0x26e2e,0x00000,0x00000,0x27054,0x27051,0x27052,
0x27053,0x17d29,0xe6150,0x27140,0x2713f,0x2713e,0x2715f,0xe616c,
0x2722e,0x27179,0x17d3b,0x14b4e,0x15845,0xe393f,0x00000,0xe3940,
0xe3f40,0xe4473,0x16723,0xe497d,0xe497c,0x00000,0xe4f30,0xe4f32,
0xe4f2f,0xe4f31,0x16f41,0x00000,0xe6652,0x25a74,0x00000,0xe5935,
0x1774a,0xe5936,0x26741,0xe5b3f,0x00000,0x00000,0xe5d38,0x00000,
0x00000,0x2717a,0x14b4f,0x14f51,0x1535c,0x1535b,0x00000,0x15848,
0x00000,0x2332c,0x15846,0x2332d,0x15847,0xe6653,0xe3941,0x23962,
0x2395e,0xe3947,0x00000,0x15d53,0x23961,0x23960,0x2395f,0x15d54,
0x23963,0x23964,0x00000,0x00000,0xe3f45,0x24068,0x24066,0x2406a,
0x2406b,0x24071,0xe3f47,0x2406d,0x2406f,0x00000,0x24067,0x24062,
0x00000,0x2406e,0xe3f44,0xe3f46,0x24070,0x24069,0x2406c,0x24063,
0x16249,0x24065,0x24064,0x16248,0x1624a,0xe3f49,0x16726,0x2477b,
0x2477d,0x2477c,0x24823,0x16724,0xe4476,0x2477e,0x2477a,0x24821,
0x24822,0x16725,0x16727,0x24824,0x00000,0x24e4f,0x24e4e,0x00000,
0x24e4c,0x24e4d,0x16b3b,0x16b3d,0x16b3a,0x16b3c,0x25475,0x25476,
0x25471,0xe4f36,0x25472,0x16f43,0x16f48,0x16f42,0x16f49,0x16f44,
0x25473,0x00000,0xe4f33,0x25474,0x25470,0x16f4a,0x16f46,0xe4f35,
0x00000,0x16f45,0x16f47,0xe4f34,0x2546f,0xe5324,0x25a76,0x17252,
0xe5322,0xe5321,0x25a78,0x17254,0x25a7b,0x25a77,0x25a75,0x25a7a,
0x17253,0x25a79,0x00000,0x17251,0xe5325,0xe5659,0x1755e,0x17561,
0x25f6d,0xe565a,0x1755f,0x25f6c,0x1755d,0x17560,0x26370,0x26371,
0x26372,0x1774b,0xe5937,0x26373,0x00000,0x1774c,0x1792f,0x26744,
0x26745,0x26743,0x26742,0x26746,0x1792e,0x26a2b,0x26a29,0x26a2a,
0x26a2c,0x26a28,0x26a2d,0x26c47,0xe5e67,0x26c48,0x26c46,0x17b32,
0x26e33,0x17b79,0x26e34,0x26f56,0x26f55,0xe6222,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x14b50,0x1624b,0xe3f4b,0xe4477,0x16728,
0xe4478,0xe4a21,0xe4a22,0x16b3e,0xe4f37,0xe5327,0x17256,0xe5326,
0x17255,0x00000,0xe6654,0x00000,0xe5938,0x17930,0x17a29,0x17b33,
0x14b51,0x15849,0x16729,0xe4f39,0x26747,0xe272f,0x00000,0x00000,
0x00000,0xe243b,0x00000,0x00000,0x00000,0x00000,0xe2730,0x22526,
0x00000,0xe2733,0x14b52,0x00000,0x14b55,0x14b54,0x14b53,0xe2731,
0x00000,0x22525,0xe2a72,0x2286d,0xe2a70,0x2286f,0x14f52,0xe2a74,
0x00000,0x14f54,0x2286c,0x2286e,0x14f53,0x22871,0x22870,0x22872,
0xe2a73,0xe2a71,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x22d57,0x22d55,0x1535f,0x22d54,0x15364,0x15361,0x1535e,0xe2f31,
0x15365,0xe2f32,0x15360,0x15363,0x00000,0x15362,0x22d56,0xe2f33,
0x1535d,0xe2f30,0x00000,0x00000,0x1584f,0x2332f,0x23335,0x1584c,
0x15853,0xe3425,0x1584e,0x23332,0x23334,0x15851,0x2332e,0x23331,
0x1584d,0x1584a,0x23330,0x15850,0x23333,0x15852,0x1584b,0x00000,
0xe3427,0xe3426,0x00000,0x23966,0x23969,0x15d56,0xe394b,0x15d60,
0x15d5c,0x23967,0xe394a,0xe394e,0x15d64,0x15d5d,0x15d62,0x15d58,
0x00000,0x15d55,0x15d57,0x15d63,0x23968,0x15d5b,0x15d5e,0x15d5a,
0x15d5f,0x2396a,0x15d61,0x15d59,0x23965,0xe394c,0x00000,0x00000,
0xe3f4f,0xe3f50,0xe3f4d,0xe3f4c,0xe3f51,0x24072,0x1624c,0x24074,
0xe3f55,0x1624e,0x16250,0x00000,0x24073,0x1624d,0x16251,0xe3f56,
0x1624f,0x00000,0xe3f54,0xe3f57,0x1672f,0x24829,0x16737,0x24826,
0xe447d,0x16738,0x1672d,0xe4479,0x24827,0xe447c,0xe447a,0x16732,
0xe447b,0x24828,0x1672b,0x1672a,0xe447e,0x16735,0x16734,0x16733,
0x16731,0x16736,0x24825,0x1672c,0x1672e,0x16730,0x00000,0x00000,
0x16b40,0x16b43,0xe4a24,0x16b47,0x16b41,0x16b46,0x16b44,0xe4a27,
0x16b3f,0xe4a26,0x16b45,0x16b42,0x00000,0x00000,0x00000,0x2547a,
0x16f4d,0x16f4b,0xe4f3c,0x2547b,0x00000,0x16f4e,0x16f4c,0x25479,
0x25478,0xe4f3b,0x1725a,0x25477,0x17258,0x17257,0x25a7c,0x16f4f,
0x17259,0x25a7d,0x1725c,0x25a7e,0x1725b,0x17563,0x25f6f,0x17562,
0x17567,0x17565,0x17566,0x1774e,0x17564,0x25f6e,0x25b21,0x1774d,
0x1774f,0xe593a,0x17931,0x17932,0x00000,0x26a2e,0x00000,0x17c4a,
0x17c49,0x14b57,0xe225e,0xe225d,0x22275,0x15854,0xe243c,0x22272,
0x22273,0x22271,0xe243d,0x22274,0xe6655,0x00000,0x2252a,0x22527,
0x2252c,0x22528,0x14b58,0x14b5b,0xe2735,0x22529,0x14b5a,0x2252b,
0xe2739,0xe2734,0x14b59,0xe3951,0x00000,0xe2a77,0x00000,0x22875,
0x22877,0x14f57,0x22873,0x22876,0x22874,0x14f55,0x14f58,0xe2a75,
0x14f56,0xe2a78,0x00000,0x00000,0xe2f35,0x22d59,0x22d5d,0x22d5a,
0xe2f38,0x15368,0xe2f34,0x15369,0xe2f3e,0x22d5c,0xe2f37,0x22d5e,
0x22d60,0xe2f3c,0x15366,0x22d5f,0x00000,0xe2f3b,0x15367,0x00000,
0x00000,0x00000,0x00000,0x00000,0x23971,0x22d5b,0x23336,0x2333f,
0x2333d,0x23338,0x23339,0x2333e,0x23340,0x15856,0xe3429,0x2333b,
0x23337,0x15855,0x15857,0x2333a,0x23341,0x2333c,0x00000,0x00000,
0x15d65,0x23974,0x2396c,0x23972,0x23973,0x15d66,0xe394f,0x2396b,
0x2396d,0x22d58,0x2396f,0x23970,0x2396e,0x16253,0xe636c,0xe3952,
0x00000,0x2407b,0x25b22,0x2407c,0x24079,0x15d67,0x16255,0x24078,
0x2407e,0x2407d,0x16252,0x24123,0x24077,0x24122,0x24075,0x24121,
0x2407a,0x16254,0xe3f59,0x24830,0xe4523,0x2482b,0x24831,0x2482c,
0x2482a,0x2482d,0x16739,0xe4524,0x2482f,0xe4525,0x2482e,0x1673a,
0x16b49,0x16b48,0x24e56,0x24e59,0x24e51,0x24e55,0x16b4a,0x24e54,
0x24e52,0x24e58,0x24e53,0x24e50,0x24e57,0xe4a2a,0x25523,0x16f52,
0x26374,0x2547e,0x25521,0x2547d,0x24076,0x16f51,0x25524,0x2547c,
0x16f50,0x16f53,0x25522,0x25b23,0x1725d,0x25b24,0x25b25,0xe532b,
0x25f70,0x17568,0x26375,0x26376,0xe593c,0xe593b,0x26377,0x26749,
0x26748,0x26a30,0x00000,0x26a2f,0x26c4a,0x26c4b,0x26c49,0x26e35,
0x17b7a,0x14b5c,0x1536b,0x1536a,0x1585a,0x15859,0x23343,0x23344,
0x23342,0xe342a,0x15858,0x23978,0xe3955,0x23979,0x23975,0x15d68,
0x23976,0xe3954,0x23977,0x00000,0xe6657,0x00000,0x00000,0x24126,
0x24128,0x24124,0x24127,0x16256,0x24125,0x16257,0x00000,0xe4528,
0x24279,0x1673d,0x1673c,0xe4527,0x1673b,0x00000,0x24832,0x24833,
0x00000,0x00000,0x24e5b,0x24e5d,0x16b4e,0x16b4b,0xe4a2c,0x16b4d,
0x16b4c,0x24e5c,0x24e5a,0xe4a2b,0xe4a2d,0x00000,0x00000,0x00000,
0x2552b,0x25528,0x25529,0x16f57,0x2552a,0x25525,0x25526,0x16f54,
0xe4f3f,0x16f55,0x25527,0x16f56,0xe4f40,0x25b29,0xe532d,0x25b2a,
0x25b27,0x25b28,0x1725e,0x25b26,0x00000,0xe532c,0xe532f,0x00000,
0x00000,0x25f74,0x25f71,0x25f73,0x1756b,0x25f77,0x1756a,0x25f75,
0x25f78,0x25f76,0x25f72,0x17569,0x00000,0x26379,0x00000,0x2637a,
0x26378,0xe593d,0x2637c,0x17750,0x17751,0x2674b,0x17934,0x2637b,
0x2674a,0x17933,0x26a33,0x26a34,0x17a4a,0x26a32,0x00000,0x26a31,
0x00000,0x26c4c,0x17b34,0xe5e68,0x26f57,0x27056,0x27055,0xe607e,
0x17c6e,0x17d2a,0x27057,0x27160,0xe616d,0x17d3c,0x14b5d,0x14f59,
0x00000,0x1673e,0x00000,0x17a4b,0x14b5e,0x1536c,0x15d69,0x16258,
0x17752,0x14f5a,0x00000,0x22d62,0x22d61,0x23345,0xe3430,0x1585d,
0x1585b,0x1585f,0x23347,0xe342d,0x1585e,0x1585c,0xe342f,0xe342e,
0xe3431,0x00000,0x23346,0x15d6c,0x23a21,0xe3958,0x15d6b,0x15d6d,
0x23a26,0x15d6f,0x23a23,0x23a24,0x2397a,0x15d6e,0x23a27,0x00000,
0xe3957,0x2397c,0xe3956,0x2397d,0x2397b,0x15d6a,0xe3959,0x23a25,
0x2397e,0x23a22,0x00000,0x00000,0x00000,0x24134,0xe3f5d,0x24133,
0x24131,0x24129,0x24138,0x2412c,0x24136,0x2413d,0x24135,0x16260,
0xe3f66,0x1625c,0x2412a,0xe3f60,0x24130,0x1625e,0xe3f68,0x2412f,
0x1625f,0x16261,0x24132,0xe3f69,0x16259,0x1625a,0x2413e,0x2413c,
0xe3f62,0x2413b,0x2412d,0xe3f65,0x24139,0x00000,0x1625d,0x00000,
0xe3f5e,0xe6659,0xe3f63,0x1625b,0x2413a,0x2412b,0x2412e,0x24137,
0x00000,0x00000,0x00000,0xe6658,0x00000,0x24f22,0x2483d,0xe452e,
0x24836,0x24849,0x24852,0x24839,0x16749,0xe452b,0x24846,0x1673f,
0x16741,0x1674d,0x24837,0xe4537,0xe452f,0x16742,0x16744,0x1674e,
0x16743,0xe4539,0x00000,0x00000,0xe4538,0x1674c,0x2483f,0x00000,
0x24834,0x1674a,0x2483e,0x16746,0x24850,0x1674b,0x2484e,0x24842,
0x2484c,0x16748,0x24835,0x2484f,0x2484a,0xe452a,0x24851,0x16740,
0x00000,0xe452d,0x1674f,0x16745,0xe4531,0xe4529,0x2483b,0xe4534,
0x24843,0x24847,0xe4533,0x2484b,0x16747,0x2483a,0x24838,0x24844,
0x00000,0x00000,0xe4532,0xe4535,0x24841,0x24840,0xe4536,0x24845,
0x24848,0x00000,0x2484d,0xe665a,0x00000,0x00000,0x24e60,0x00000,
0x16b4f,0x24e6a,0x24e62,0x16b55,0x16b59,0x24e73,0x24e7b,0x24e6c,
0x16b51,0xe4a34,0x24e70,0x2483c,0xe4a35,0x16b52,0x24e77,0x24e7c,
0x24e74,0xe4a2f,0x24e76,0x24f21,0x24e78,0x24e66,0x24e6f,0xe4530,
0xe4a38,0x16b5a,0xe4a33,0x16b56,0x24e64,0x24e71,0x16b54,0x24e6b,
0x16b53,0x24e79,0x24e68,0x24e61,0x16b57,0x24e7e,0xe4a39,0x00000,
0x24e63,0x24e75,0x24e72,0x24e6d,0x24e5f,0x24e5e,0x24e67,0x24e7a,
0x16b58,0x24e7d,0x24e65,0x24e69,0x16b50,0xe4a32,0xe4a37,0x00000,
0xe672a,0xe4a31,0x16f63,0x16f5e,0x2554d,0x25549,0x25531,0x16f5a,
0xe4f42,0xe4f50,0x00000,0x16f59,0x16f5f,0x00000,0xe4f43,0xe4f41,
0x2552f,0x16f5d,0x2553b,0x2552d,0x2552e,0x16f58,0x2554c,0x16f61,
0x2553e,0x25543,0x2553d,0x25b3c,0x25539,0x25541,0x2553f,0x25532,
0x2552c,0x25547,0x16f60,0x25548,0xe4f48,0x25542,0xe4f49,0x25537,
0x25535,0x25530,0xe4f4b,0xe4f4e,0xe4f44,0x25538,0x25545,0x25534,
0x25544,0x2554a,0xe4f51,0x00000,0x16f5c,0xe4f45,0x25540,0x25546,
0x2553c,0x25536,0x16f5b,0xe4f52,0x00000,0xe4f4c,0x24e6e,0x2553a,
0x16f62,0x25533,0x00000,0xe4f4d,0xe665b,0xe665c,0xe4a30,0x25b41,
0x17261,0x25b40,0x25b3e,0x25b50,0x17265,0xe5335,0x25b4d,0x25b45,
0x25b4f,0x25b37,0x25b43,0xe533d,0x17267,0xe533e,0x25b2f,0xe5338,
0x25b2d,0x25b4e,0xe5332,0x25b4c,0x25b4b,0x25b3b,0x25b3a,0x25b30,
0x17269,0x00000,0x25b36,0x25b3f,0x25b4a,0x1726c,0x25b51,0xe5336,
0x17573,0x1726e,0x17268,0x25b34,0xe5337,0x25b3d,0x25b2c,0x25b2e,
0x1725f,0x1726b,0x17264,0x25b35,0x25b44,0x2554b,0x1726a,0x25b2b,
0x1756e,0x25b46,0x25b49,0x17266,0xe533b,0x25b39,0x1726d,0x17263,
0xe533c,0xe5339,0xe533a,0x17262,0x25b42,0x25b48,0x17260,0x00000,
0x25b32,0x25b47,0x00000,0x00000,0x25b33,0x00000,0x00000,0xe665d,
0x00000,0x00000,0xe665e,0x00000,0x00000,0xe5331,0x25b38,0x25f7e,
0xe5665,0x26025,0x17570,0x17572,0x2602b,0x1756c,0x26039,0x26031,
0x26026,0x26027,0x26030,0xe5666,0x17579,0x2602f,0x25f7d,0x2602e,
0x26022,0x2603a,0x17578,0x17576,0x26023,0xe565d,0x26036,0xe5667,
0x26028,0x26035,0xe5664,0x26037,0x25f7c,0x17571,0xe565b,0x26038,
0xe5668,0xe565e,0x2602c,0xe566b,0x17575,0x26029,0xe5661,0x00000,
0x17577,0x26032,0xe5662,0xe5663,0xe565f,0x1756f,0x26024,0x26033,
0xe565c,0x2602d,0x25b31,0x26034,0x26021,0xe5660,0x17574,0xe566a,
0x2642f,0x00000,0x1756d,0x25f7a,0x00000,0x00000,0xe665f,0x00000,
0x2642c,0x26425,0x17754,0xe5943,0x2637e,0x26430,0x26427,0x2602a,
0xe5940,0x26432,0x26421,0xe5942,0x17753,0x2642b,0x17755,0x1775d,
0x1775b,0x2642d,0x1775c,0x26423,0xe5949,0x26424,0x26429,0x2642e,
0xe593e,0x25f79,0x17756,0x26437,0x26434,0x26761,0x2642a,0x26426,
0x26435,0x26756,0x26428,0x00000,0x17759,0xe5944,0x17758,0x25f7b,
0x1775a,0x26431,0x26433,0x17757,0x26436,0x2637d,0x00000,0x26422,
0xe5946,0x00000,0x00000,0xe5945,0xe6661,0xe6662,0xe6660,0x00000,
0x2675f,0xe5b50,0x2674f,0x17938,0x2675d,0xe5b44,0xe5b45,0x2674d,
0x17939,0x00000,0x26758,0xe5b43,0x26754,0x1793e,0x2675e,0x2674e,
0x26751,0x17936,0x26760,0xe5b48,0x26759,0x2675c,0x1793c,0x17941,
0x1793f,0x26755,0x26750,0xe5b4d,0x1793a,0x1793b,0x2674c,0x17937,
0xe5b4f,0x17935,0x1793d,0x2675b,0x17940,0xe5b4a,0x26757,0x26762,
0x17942,0xe5b41,0xe5b42,0xe5b4e,0x26753,0xe5b47,0x2675a,0xe6665,
0x00000,0xe6663,0xe6664,0xe5d41,0xe5e6a,0x26a41,0x26a50,0x26a43,
0x26a4a,0x26752,0x26a48,0x26a37,0x26a4e,0x17a4e,0x26a3b,0x26a4d,
0x26a42,0x00000,0xe5d43,0x17a4d,0xe5d3c,0xe5d3f,0x26a52,0x26a44,
0xe5d3e,0x26a49,0x26a4c,0x26a35,0x26a4f,0x26a40,0x26a45,0x26a39,
0x26a3d,0x26a51,0x26a47,0x26a36,0x26a3a,0x26a3c,0x26a46,0xe5d3d,
0x17a4c,0x26a3f,0xe5d44,0xe5d45,0xe5d47,0x00000,0xe5d42,0xe5d3a,
0x26a38,0x00000,0xe6666,0xe6667,0xe6668,0x00000,0x00000,0xe5d46,
0x26a3e,0x26c50,0x26c54,0x17b3b,0x26c56,0xe5e6d,0x17b35,0x00000,
0x26c52,0x26c58,0x17b3a,0x17b36,0x00000,0x17b37,0x26c4f,0x26c55,
0x17b39,0x26c53,0x17b38,0x26c4e,0x26a4b,0x26c51,0x00000,0x26c4d,
0x26c57,0x00000,0xe5f69,0xe5f6e,0x17b7b,0x26e3c,0x26e3f,0x26e3b,
0x26e3d,0x26e3e,0x26e38,0x26e39,0x26e36,0xe5f6a,0xe5f6c,0x26e3a,
0x26e37,0x17b7c,0x17b7d,0x00000,0xe5f6b,0x26f59,0xe6052,0x26f5b,
0xe6431,0x00000,0xe6055,0xe6054,0xe6056,0x26f5a,0x26f5c,0xe604f,
0x17c4c,0xe6053,0x26f58,0x17c4b,0x17c4d,0xe6057,0xe666a,0xe6669,
0x27059,0x2705a,0x17c6f,0x27058,0xe6122,0x27142,0x27141,0x27143,
0x17d2c,0x27144,0x17d2b,0x27145,0x27161,0x27164,0x27163,0x17d35,
0x27162,0x00000,0xe616f,0xe6223,0x17d3f,0x17d3d,0x17d3e,0x17d44,
0x27230,0x27231,0x2722f,0x27237,0xe6236,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
/* 0x9500 */
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x14f5b,
0x00000,0xe6323,0x23a28,0x2413f,0x2554e,0x26763,0x00000,0x00000,
0x14f5c,0xe2f40,0x1536d,0x15860,0x00000,0xe3432,0x23a29,0xe395c,
0x23a2a,0x15d70,0x00000,0x16264,0x24141,0x24140,0x16268,0x16263,
0x24142,0x16265,0x16267,0x16266,0x16262,0xe3f6c,0x00000,0xe666b,
0x16750,0xe453c,0xe453a,0x24856,0x24854,0x00000,0x24855,0x24853,
0x00000,0x16b5b,0xe4a3d,0x16b5e,0x16b60,0x16b5f,0x00000,0xe4a3e,
0x16b5c,0x16b5d,0x00000,0x25550,0x2554f,0x16f64,0x25551,0xe4f53,
0x25552,0x16f65,0xe4f55,0xe4f56,0x00000,0x25b59,0x25b57,0x26040,
0xe5342,0x25b55,0x25b56,0x1726f,0x25b52,0x25b5a,0x25b54,0x25b58,
0x2603c,0xe5344,0xe5340,0x2603e,0xe566d,0x2603f,0x1757e,0x2603b,
0x1757d,0x2603d,0x1757a,0x1757b,0x1757c,0x25b53,0xe666c,0x00000,
0x17760,0x2643a,0x26438,0x26439,0x1775e,0x17761,0x1775f,0xe594b,
0xe594a,0x00000,0x26764,0x26765,0x17943,0xe5b53,0x26a53,0x26a55,
0x26a54,0x17a4f,0x17b3c,0x26c5b,0x26c5a,0x26c59,0x00000,0xe666d,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
/* 0x9600 */
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x14f5d,0xe2143,0x22169,0x00000,
0x22278,0x1486a,0x22276,0x22279,0x22277,0x00000,0xe273b,0xe273a,
0x2252e,0xe273f,0x14b62,0xe273c,0x14b63,0x22530,0x14b60,0x2252f,
0x2252d,0x14b61,0x14b5f,0xe273d,0xe273e,0x00000,0x00000,0xe2a79,
0x00000,0x22878,0x2287b,0x14f60,0x2287a,0x22879,0xe2a7c,0x14f5f,
0x14f5e,0xe2a7b,0x14f62,0x2287c,0x14f61,0x00000,0x00000,0x00000,
0x00000,0x00000,0x22d67,0x1536f,0x15370,0x15371,0x22d68,0x22d64,
0x1536e,0x22d65,0x00000,0x22d66,0x22d63,0x00000,0xe3436,0x00000,
0x15867,0xe3434,0xe395e,0x15864,0x23348,0x15865,0x15868,0x23349,
0xe3433,0x15863,0x15861,0x15862,0x15866,0x00000,0x00000,0x00000,
0x00000,0x00000,0x15d71,0x23a2d,0x15d79,0x23a2c,0xe3961,0x23a2f,
0x15d75,0x23a2e,0x16270,0x15d73,0x15d76,0x15d72,0x15d77,0x15d78,
0x15d74,0xe3965,0x00000,0xe3f71,0x23a2b,0x1626c,0x24144,0xe3f72,
0x24148,0xe3f73,0xe3f75,0x24147,0x16271,0x1626d,0x1626e,0x24143,
0x24145,0x24146,0x16269,0x1626b,0xe3f70,0x1626f,0x1626a,0xe4540,
0x00000,0x24859,0x24857,0x24858,0x16752,0x16753,0xe4542,0x2485a,
0x16751,0x16b61,0x00000,0x16b63,0x16b62,0xe4a45,0x24f23,0xe4a46,
0xe4a44,0x24f24,0x25554,0xe4f5a,0x25553,0xe4f5b,0x00000,0x17270,
0x17271,0x25b5b,0x17272,0xe5348,0x26043,0xe5670,0x26041,0xe566f,
0x26042,0x17621,0xe5671,0x2643b,0x17944,0xe5d49,0xe2a7d,0xe5349,
0x17622,0x14f63,0xe6325,0x15869,0x2334a,0xe3439,0x00000,0x23a30,
0x15d7a,0x16272,0x24149,0x2414b,0x16274,0x16273,0x16275,0x16276,
0x2414a,0x16756,0x16757,0x16755,0x16b64,0x16754,0x2485b,0x00000,
0xe4a47,0xe4a49,0x16b65,0x25555,0x25b5c,0x17273,0x17623,0x2643c,
0x26440,0x17764,0x2643d,0x17765,0x17763,0x26441,0x17766,0x2643f,
0x00000,0x26766,0x17762,0x17945,0xe5e70,0x2705b,0xe6125,0xe622f,
0x14f64,0x15d7c,0x15d7b,0x00000,0xe3f7e,0xe3f7c,0xe3f7b,0x16277,
0x2414d,0x2414c,0x16278,0x00000,0xe4546,0x2485f,0x1675b,0x16758,
0x2485e,0x1675a,0x2485c,0x16759,0xe4547,0x2485d,0x00000,0x24f25,
0x16b66,0x00000,0x25558,0x00000,0x16f66,0x25556,0x16f67,0x16f68,
0x25557,0x16f69,0xe4f60,0x25b5d,0xe5350,0x17277,0x17274,0x17279,
0x25b5f,0x17275,0x25b5e,0x17278,0xe534d,0xe534c,0x17276,0xe5351,
0x26046,0x26048,0xe5674,0xe5675,0x17624,0x26047,0x17625,0x26045,
0x26044,0x00000,0x26443,0x26442,0x17767,0x26444,0x2676b,0x17947,
0x2676a,0x26767,0x17946,0x26768,0x26769,0x00000,0x26a56,0x26a57,
0x17a50,0xe5d4f,0x17b3f,0xe5d4c,0xe5d4e,0x26c5c,0xe5e72,0xe5e71,
0x17b3d,0x17b3e,0x26c5d,0xe666e,0xe5f71,0x17b7e,0x17c21,0x26e40,
0xe5f72,0xe6059,0x17c70,0x2705d,0x17c72,0xe6126,0x2705c,0x2705e,
0x17c71,0x27146,0x00000,0x2717b,0x00000,0xe666f,0x00000,0x00000,
0xe6245,0xe2a7e,0x14f65,0x00000,0x00000,0xe4549,0x1675c,0x00000,
0x24f26,0xe4a4c,0x25559,0x1727a,0x1727b,0xe594f,0x14f66,0xe4021,
0x16f6a,0x17948,0x15372,0xe2b21,0xe4a4e,0x00000,0x1727c,0xe5e73,
0x17c4e,0x15373,0x23a31,0x00000,0x2414e,0xe4024,0x24150,0xe4022,
0x2414f,0x00000,0x24863,0x24860,0x1675d,0x00000,0x1675e,0x24861,
0x24862,0xe454b,0x24f28,0x24f2d,0x16b67,0x24f27,0x24f29,0x24f30,
0x24f2b,0x24f2f,0x24f2c,0x24f2a,0x24f2e,0x16b68,0x00000,0xe4f62,
0x2555c,0xe4f63,0x2555a,0x16f6c,0xe4f64,0x16f6b,0x2555b,0x16f6d,
0x00000,0x00000,0x00000,0xe5353,0x25b62,0x00000,0x00000,0x25b61,
0x1727d,0x25b60,0x26049,0xe567a,0x2604b,0x2604d,0x2604c,0xe567b,
0x17626,0x2604a,0x2644b,0x17768,0x26449,0x2644c,0x17769,0x00000,
0x26447,0xe5950,0x2644a,0x26448,0x26445,0x1776a,0x26446,0x00000,
0x00000,0xe5b5f,0xe5b5d,0x2676c,0xe5b5e,0xe5b60,0x2676e,0x2676d,
0xe5d50,0x26a58,0xe5d51,0x26a59,0x00000,0xe5e75,0xe5e74,0x26c5e,
0xe5f73,0x17c23,0x00000,0x17c22,0x26f5d,0x26f5e,0x17c73,0x2705f,
0xe6128,0x17d36,0xe623b,0x15374,0x16279,0x24f32,0x24f31,0x2555e,
0x2555d,0x00000,0xe5355,0x17627,0x2604f,0x2604e,0x2644f,0x2644d,
0x26450,0x2644e,0xe5951,0x00000,0x17949,0x2676f,0x26770,0x26771,
0x00000,0x26c5f,0xe5e76,0x26e41,0xe6129,0x27060,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x15375,0xe454f,0xe4f65,
0x25b63,0x26050,0xe5b61,0x15376,0x00000,0xe4550,0x16b69,0x00000,
0x25b64,0x1776b,0x26451,0x1794a,0xe5d53,0x26a5a,0x26a5b,0x17b40,
0x26f5f,0x15377,0x15e21,0x15e22,0x23a32,0x1627a,0x1627b,0x24151,
0x1627c,0x00000,0x16762,0xe4552,0x16764,0x24865,0x24866,0x24864,
0x1675f,0x16760,0x16763,0x16761,0xe4a54,0xe4a55,0x24f33,0x16b6a,
0x16b6b,0xe4a52,0xe4a56,0x25565,0x16f70,0x25560,0x2555f,0xe4f69,
0x25564,0x16f6e,0xe4f67,0xe636e,0x17326,0x00000,0x25561,0x25566,
0x25563,0x25562,0xe4f66,0x16f6f,0x00000,0x17324,0xe535c,0x25b66,
0x1727e,0xe5359,0x25b67,0xe535a,0xe5228,0x25b65,0xe5358,0x17323,
0x17321,0x17325,0xe535d,0x17322,0xe535b,0xe535f,0x00000,0xe595b,
0xe5726,0x26051,0xe637b,0x26056,0x26052,0x26055,0x17628,0xe5728,
0x25e41,0x26054,0x26053,0xe5959,0x1776e,0x1776c,0x1776f,0x1776d,
0x26452,0x26453,0x26454,0x17770,0xe5956,0xe5958,0xe5b65,0x26775,
0x1794c,0x26773,0x00000,0x1794d,0x26772,0x26774,0x1794b,0x26a5f,
0x26a5c,0xe642a,0x26a5d,0x26a5e,0x26c60,0x17b42,0xe5e78,0x17b41,
0xe5e77,0x26e43,0x26e42,0x17c24,0xe605d,0xe605e,0xe605c,0x17c4f,
0x17c74,0x17d2d,0x27147,0x2717c,0x2717d,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x15378,0x24152,0x00000,0x00000,0x24867,0x24f34,0x24f35,0x16b6c,
0x00000,0x16b6d,0x25567,0x16f71,0x00000,0xe5361,0x17629,0xe572a,
0x26455,0xe595c,0x17771,0x26778,0x1794e,0x26777,0x26779,0x26776,
0x26c63,0x26a60,0x26a61,0xe5d56,0x17a51,0x00000,0x26c62,0xe5e7b,
0xe5e79,0x26c61,0xe5e7a,0x26e44,0x2717e,0xe6225,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x15379,0xe5e7c,0xe6226,0x00000,0x1537a,
0x00000,0xe3967,0x1586a,0x2334b,0xe6670,0x23a33,0xe3968,0x1627d,
0x00000,0x16322,0x1627e,0x24153,0xe455b,0x16324,0x00000,0x16321,
0xe402b,0xe455c,0x16323,0xe4554,0x16766,0xe4559,0x24868,0xe4557,
0xe4a5d,0x24869,0x25569,0x00000,0x16765,0x16767,0x16768,0xe4558,
0x24f37,0xe4a5e,0x24f36,0x16b6e,0x00000,0x16b6f,0xe4a5b,0x24f38,
0x25568,0x16b71,0x16f72,0x00000,0x16b70,0x00000,0xe667a,0x00000,
0x17327,0x2556a,0x16f74,0x16f73,0x2556b,0x2556e,0x2556c,0x2556d,
0x16f75,0xe4f6b,0x1732c,0x1732a,0xe5365,0xe5366,0x17329,0x25b69,
0xe5364,0x1732b,0xe5362,0xe5363,0x25b68,0x26057,0x00000,0x25b6a,
0x17328,0x25b6b,0x2605a,0x26058,0x26059,0x2605e,0x17775,0x2605d,
0x26060,0x2605f,0x2605c,0x2605b,0x00000,0x1762a,0xe5962,0x00000,
0xe5961,0xe5966,0x26458,0xe5965,0x26457,0x17774,0x17772,0x17773,
0xe5963,0x26456,0xe6671,0x2677c,0xe5b69,0x1794f,0x00000,0x2677b,
0x2677a,0x17950,0x00000,0x26a66,0x26a65,0xe5d58,0x26a63,0xe5e7e,
0x26a62,0x17a53,0x17a52,0x26a67,0x26e45,0x17c25,0x26c65,0x17b43,
0x26c64,0x26a64,0xe5f78,0x26e46,0x17c50,0xe612a,0x17d2e,0x27148,
0x00000,0x27221,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x1537b,0x23a34,
0x26061,0x1537c,0xe455f,0x00000,0x24f3a,0x24f39,0x25b6c,0x00000,
0xe5368,0x26063,0xe5730,0x26062,0xe5967,0x17776,0x2677d,0x2677e,
0x17a54,0xe5f21,0xe6060,0x27222,0x1586b,0x16326,0x16325,0x2486a,
0x2486c,0x1676a,0x2486b,0x16769,0x1676b,0x2486d,0xe4a63,0xe4a62,
0xe4a66,0x24f3c,0x24f3e,0x24f3d,0xe4a61,0x24f40,0xe4a60,0xe4a6c,
0xe4a64,0x16b72,0x24f3f,0x24f3b,0xe4a6a,0x00000,0x00000,0x24f41,
0xe4f73,0x25575,0xe4f6d,0x25578,0x2557a,0x25570,0x25574,0x25571,
0x16f77,0x16f7a,0x16f7c,0x25572,0x25573,0x16f7b,0x25576,0x25579,
0x25577,0x16f7d,0xe4f6e,0x16f79,0x2556f,0x16f76,0xe4f72,0x16f78,
0xe4f74,0xe5370,0x1732e,0x25b72,0x25b70,0x25b6f,0xe5371,0x25b75,
0xe536b,0x25b74,0x25b73,0xe536c,0x25b6e,0x1732d,0x25b6d,0xe536a,
0x25b71,0x1732f,0x00000,0xe5734,0x26066,0xe5737,0x2606a,0x26067,
0x26069,0x26068,0x26065,0x2606b,0x2606e,0x2606c,0x2606d,0x1762c,
0xe5733,0x1762b,0x26064,0x2606f,0x2645d,0x26460,0x26462,0x26461,
0xe596a,0x2645b,0x2645f,0x2645a,0xe596b,0x2645c,0x17777,0x26459,
0xe596d,0x2645e,0x00000,0x00000,0x2682d,0x26822,0x17951,0xe5b6f,
0xe5b6d,0x17952,0x26821,0x26826,0x2682c,0x26824,0x2682b,0xe5b6c,
0x26828,0xe5b6e,0x26827,0x2682a,0x26825,0x26823,0xe5b6b,0x26829,
0x00000,0x26a6e,0x26a6c,0x17a55,0x26a6b,0x26a71,0x26a6f,0xe5d5a,
0x17a56,0x26a6a,0x26a68,0x00000,0x26a69,0x17a58,0x26a6d,0x17a57,
0x26a70,0x26c66,0x26c6c,0xe5f24,0xe5f22,0x26c67,0x17b47,0x26c6d,
0x17b46,0x26c6b,0x26c6a,0x17b45,0x26c69,0x17b44,0x26c68,0x00000,
0x26e4c,0x26e4e,0x26e4d,0x00000,0x26e4a,0x17c27,0x26e47,0x26e4b,
0x26e50,0xe5f79,0x26e4f,0x26e48,0x26e49,0x17c26,0x26f60,0x17c53,
0xe6062,0x26f61,0x17c51,0x17c52,0xe6061,0x00000,0x27061,0x17c75,
0x27165,0xe6172,0x17d37,0xe6173,0x27223,0x17d38,0x27224,0x27225,
0x27233,0x27232,0x17d47,0x2723b,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x1586c,0xe402f,0x00000,0x2486f,0x00000,0x2486e,0x00000,0x16b73,
0x16b74,0x24f42,0x00000,0x2557b,0x25b78,0xe4f77,0xe4f76,0x16f7e,
0x17330,0x25b76,0x00000,0x25b79,0x17331,0xe573a,0x26070,0x25b77,
0x26463,0x17778,0x2682e,0x00000,0xe5d61,0x00000,0x26a74,0x26a72,
0xe5d60,0xe5d5e,0x26a73,0x00000,0x00000,0x26c6e,0xe5f25,0x17b48,
0x26e51,0x17c56,0x17c28,0x17c54,0x17c55,0x27062,0x17d2f,0xe6174,
0x1586d,0xe6334,0xe4a6e,0x00000,0x26464,0xe5f7b,0xe6063,0x2334c,
0xe4032,0x1676c,0xe4561,0x24f43,0xe4a6f,0xe4a73,0x16b75,0x24f44,
0xe4a71,0xe4a70,0xe4a72,0x2557d,0x2557c,0x17333,0x17021,0x17022,
0x00000,0x25622,0x25621,0x2557e,0xe4f79,0xe5375,0x25b7a,0x25b7d,
0xe5374,0x25b7c,0x25b7b,0x17332,0x26074,0x26072,0x26071,0x00000,
0xe573b,0x26073,0xe573c,0x17779,0x26466,0x26467,0x1777a,0xe596f,
0x26465,0xe5b71,0x26830,0x2682f,0x26832,0x17953,0x26831,0x00000,
0x26a75,0x26a77,0x26a76,0x00000,0xe5f27,0x26c6f,0x26c72,0x26c70,
0x26c71,0x26e52,0x17c29,0x00000,0x00000,0xe6672,0x26f62,0x26f63,
0x26f64,0xe612c,0x17c76,0x17d30,0x27226,0x1586e,0xe4a75,0x17023,
0x17334,0x26468,0xe5d62,0x26e53,0xe612e,0xe6433,0x27166,0x2334d,
0xe6228,0x17d48,0x1586f,0x25b7e,0xe573e,0x26469,0x00000,0x26833,
0xe5d63,0x00000,0x26c73,0x26e54,0x15870,0xe4562,0x24f45,0x24f46,
0xe4a78,0x16b76,0x16b77,0x25624,0x17025,0x17024,0x25623,0x00000,
0x26075,0xe573f,0x2646a,0x2646c,0x2646b,0x1777d,0x1777c,0x1777b,
0xe5d64,0x17b4a,0x26c74,0xe5f28,0x17b49,0x26e56,0x26e55,0xe612f,
0x17c77,0x27063,0x15e23,0x24870,0x00000,0xe4563,0x00000,0x24f49,
0x24f47,0x24f48,0x00000,0xe4f7e,0x2562d,0x00000,0x25628,0x25625,
0x2562c,0xe4f7c,0x00000,0xe4f7b,0x2562e,0x00000,0x00000,0x17027,
0x2562b,0x25627,0xe4f7d,0x00000,0x25626,0x2562a,0x25629,0x17026,
0x00000,0x00000,0x25c2b,0x25c26,0x25c24,0x25c2d,0x25c25,0x00000,
0x25c21,0x00000,0x25c27,0xe5378,0xe537a,0x25c22,0x2607e,0x25c23,
0x25c2e,0xe5423,0x00000,0xe537c,0xe5421,0x00000,0xe5425,0xe537d,
0x25c2a,0x17335,0x25c29,0x25c28,0xe5379,0x25c2c,0x00000,0x00000,
0xe6673,0xe5744,0x26076,0x26079,0x00000,0xe5745,0x26078,0xe5740,
0x26122,0x2607b,0x26121,0xe5742,0x2607d,0x2607c,0x2607a,0x00000,
0x26077,0x00000,0x1762f,0x1762e,0x00000,0x17630,0x1762d,0x26123,
0x00000,0x00000,0x00000,0x00000,0x00000,0x26472,0x26475,0x00000,
0x26473,0x26477,0x00000,0xe5974,0x00000,0x26478,0x00000,0x26470,
0x17824,0x26471,0xe5973,0x2646f,0x26476,0xe5b74,0x2646e,0x2646d,
0x17823,0x17821,0x1777e,0xe5976,0xe5975,0xe5743,0x00000,0x00000,
0x00000,0x00000,0xe5971,0x26474,0x2683c,0x26842,0x17956,0x2683d,
0x00000,0x26840,0x26844,0x17957,0x2683f,0x00000,0x26837,0xe5b75,
0x26836,0x26843,0x2683a,0xe5b77,0x26838,0x26841,0x26839,0x17955,
0x17954,0xe5b79,0x26834,0x26835,0x2683e,0x00000,0xe5b7a,0x00000,
0x2683b,0x00000,0x00000,0x00000,0x00000,0x00000,0xe5d6f,0x26a7a,
0x26a7d,0xe5d71,0x00000,0xe5d67,0xe5d69,0x17822,0xe5d6a,0xe5d74,
0xe5d75,0x00000,0xe5d6e,0x00000,0xe5d68,0x26a7b,0x26b23,0x26b21,
0x26a79,0x26b26,0xe5d66,0x26a78,0xe5d76,0x17a5a,0x26b22,0x00000,
0xe5d73,0x00000,0x26a7c,0x17a59,0x26b25,0xe5d72,0x00000,0x26b24,
0x00000,0x00000,0x00000,0xe5d70,0x26c77,0x26c76,0x00000,0xe5f2c,
0x00000,0x26c7d,0x00000,0x26c79,0x26c7c,0x17b4c,0x00000,0xe642f,
0x26c7a,0x26c7b,0x00000,0x26c75,0x26c78,0x17b4b,0xe5f2a,0x00000,
0x00000,0x17c2b,0x26e61,0x26e5c,0x26e60,0xe6025,0x26e63,0x26e5f,
0xe5f7e,0x26e5b,0xe6023,0x17c2d,0x26e5e,0x26e62,0x17c2c,0x26e59,
0x26a7e,0x26e5d,0x00000,0x00000,0x26e5a,0xe6022,0x26e57,0x00000,
0x26e58,0x17c2a,0x26f68,0x26f6a,0x26f6d,0x26f69,0x26f6e,0xe6065,
0x26f67,0xe6066,0x26f65,0xe6068,0x17c57,0x26f6b,0x17c59,0x17c58,
0x26f66,0x26f6c,0x00000,0x00000,0x00000,0xe6132,0x27068,0x17c78,
0x27069,0xe6133,0x27067,0x27064,0x00000,0xe6134,0x27066,0x27065,
0x27149,0x00000,0x00000,0x00000,0xe6159,0x2714b,0x2714a,0xe615b,
0x00000,0x27169,0x00000,0x27168,0x27167,0x2716a,0xe6175,0x17d40,
0x17d41,0x27238,0x2723c,0xe6241,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x15e24,0x24154,0x24873,
0xe4564,0x1676d,0x24871,0xe4566,0xe2f42,0x24872,0xe4568,0xe4567,
0x00000,0x24f4a,0x24f4b,0x16b7a,0x16b78,0x24f4c,0x16b79,0x25633,
0xe5027,0x25636,0x25630,0x25637,0x2562f,0x25631,0xe502a,0x25632,
0x25635,0xe5024,0xe502b,0x1702a,0x2563a,0x25639,0x17028,0x25634,
0x25638,0x17029,0xe542d,0x00000,0xe5025,0xe5022,0x00000,0xe542a,
0x25c38,0x00000,0x1733a,0xe542c,0x25c33,0x17336,0xe5436,0x25c30,
0x25c36,0x25c39,0xe5433,0x1733b,0x00000,0x25c35,0x25c32,0x25c3a,
0x25c31,0xe5437,0x25c37,0x17337,0xe5429,0x25c2f,0x17338,0xe5435,
0x17339,0x25c34,0xe5432,0x00000,0x00000,0x26135,0x26128,0x26129,
0x2612c,0x2612a,0x00000,0x26124,0x00000,0xe574d,0x26127,0x26131,
0x2612b,0xe5748,0x00000,0x17631,0x00000,0x26133,0x26130,0x17632,
0x26132,0x26125,0x2612e,0x2612f,0xe574a,0x2612d,0x00000,0x00000,
0x00000,0xe6675,0x2647c,0x2647e,0x26523,0xe5979,0xe597b,0x2647b,
0xe597d,0x17825,0x26525,0x2647a,0x26526,0xe597e,0x26522,0x26524,
0x26528,0x26521,0x26529,0x2647d,0x26479,0x17826,0xe5a22,0x26527,
0x17827,0x17959,0x00000,0xe597a,0x00000,0x00000,0xe5b7d,0x26126,
0x2685e,0x26855,0x1795b,0x26851,0x1795c,0xe5c27,0xe5c22,0x2685a,
0x26854,0x2684a,0x1795a,0x26857,0x26852,0x26853,0xe5c25,0x26845,
0x2684c,0x2685b,0xe5b7e,0x26858,0x00000,0x26850,0xe5c26,0x2685c,
0x2684b,0x26846,0x26859,0xe5c24,0x26848,0x26856,0x2684d,0x2685d,
0x26849,0x17958,0x26847,0x2684e,0x2684f,0x00000,0x00000,0x00000,
0x26b2d,0xe5c23,0x26b2b,0x00000,0x26b30,0xe5d79,0x26b3c,0x26b33,
0x26b2c,0x26b28,0x26b35,0x26b2e,0x26b31,0x26b2a,0x26b38,0x26b27,
0x26b2f,0x26b34,0x26b36,0x26b39,0x26b29,0xe5d7a,0x26b3d,0x26b3e,
0x26b37,0x26b3b,0x26b32,0x00000,0x26d2f,0x26d32,0xe5f35,0x17b4d,
0xe5f31,0x26d31,0x26d36,0x26d34,0x17b4e,0x26d2b,0x26d21,0x26c7e,
0x17b50,0x26d2d,0x26d2e,0x26d2a,0x26d22,0xe5f32,0x26d27,0x26b3a,
0x00000,0x26d23,0x17b4f,0x26d29,0xe5f36,0x26d28,0x00000,0x26d24,
0x26d30,0x00000,0x26d25,0x26e68,0x26d33,0x26d35,0x26d2c,0x26d26,
0x26e69,0x26e6b,0x26e65,0x17c2e,0x00000,0x26e72,0x26e70,0x17c2f,
0x26e6f,0x26e6e,0x26e67,0x26e64,0x26e6a,0x26e73,0x26e66,0x26e6c,
0x00000,0x26f77,0x26f7c,0x26f72,0x26f75,0x17c5a,0x26f79,0x00000,
0x27022,0x26e6d,0x00000,0x26f73,0x26f7d,0x27023,0x26f78,0x26f71,
0x26f7b,0x00000,0x26f7a,0x27021,0x26f7e,0x26e71,0x26f76,0x26f70,
0x26f74,0x17c79,0x17c7a,0x26f6f,0xe606c,0x27074,0x2706b,0x27073,
0x27070,0x27071,0x2706a,0x2706d,0x27075,0x2706f,0x2706e,0x2706c,
0xe6135,0x27072,0x00000,0x2714c,0x00000,0x2714d,0xe615d,0x2714f,
0x2714e,0x27151,0x27150,0x2716c,0x2716b,0x27227,0xe6229,0x27228,
0xe6230,0x27234,0x17d45,0x17d49,0xe6238,0x2723d,0x17d4a,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x15e25,0x00000,0x00000,
0x00000,0x17a5b,0x26d37,0xe5f37,0x17c7b,0x17c7c,0x00000,0x15e26,
0x24874,0xe4569,0x1676e,0x2563b,0xe502c,0xe5439,0x25c3c,0x25c3d,
0x25c3b,0x26137,0x26136,0x17633,0x2652b,0x26138,0x2652a,0x00000,
0xe5a24,0x26860,0x1795d,0x1795f,0x2685f,0xe5c29,0x00000,0x1795e,
0xe5e21,0x26b3f,0x26b41,0x26b40,0x26d38,0x17b51,0xe5f3a,0x17c5b,
0x27076,0x27152,0xe6231,0xe623f,0x27241,0x15e27,0xe2547,0x24f4d,
0x00000,0x1702b,0xe502f,0xe502e,0xe543a,0x25c3f,0x25c3e,0xe5750,
0x26139,0xe5a26,0xe5a25,0x00000,0x17960,0x17a5c,0x26e74,0x27239,
0x00000,0x00000,0x00000,0x15e28,0x16b7b,0xe4b22,0x1702c,0x00000,
0x26861,0xe5e22,0x27024,0x16327,0xe396a,0xe543c,0xe543b,0x00000,
0x2613a,0x00000,0xe5a28,0x00000,0x17d31,0x16328,0x1702d,0x17634,
0x27025,0x16329,0xe396b,0x2563c,0x1733d,0x25c40,0x25c41,0xe543d,
0x1733c,0x00000,0x2613b,0x17638,0x17636,0x17637,0x17635,0x2652c,
0x17828,0x00000,0x00000,0xe5c2a,0x26b43,0x26b42,0x26b45,0x26b44,
0x17a5d,0x00000,0x00000,0x26d39,0x00000,0x26d3b,0x26d3a,0x17b52,
0x26e75,0xe6029,0x27026,0x27027,0x17c5c,0x27153,0x2716d,0x17d42,
0x00000,0x24155,0x25c42,0x2613c,0x26862,0x24875,0xe2772,0x2613d,
0x2652e,0x2652d,0xe5a29,0xe5c2d,0xe5c2e,0xe5f3c,0x27028,0x17c7d,
0xe615f,0x27154,0x2716e,0x00000,0x00000,0x00000,0x1676f,0x2563d,
0x2563e,0x00000,0x25c43,0x16770,0xe456a,0x17829,0x2652f,0xe5c30,
0x26d3d,0x17b53,0x26d3e,0x26d3c,0x27029,0xe6160,0x27077,0x00000,
0x16771,0x00000,0x26140,0x2613f,0x2613e,0x26530,0xe5a2b,0xe5a2a,
0x26534,0x26533,0x26532,0x26531,0x1782a,0x26863,0x26b47,0x17a5e,
0x26b46,0x26d3f,0x26e78,0x26e77,0x17c30,0x26e76,0x2702c,0x2702b,
0x2702a,0xe606d,0x00000,0x16b7c,0x00000,0x25c44,0x17639,0x00000,
0x26864,0x26865,0x26e79,0x2702d,0x00000,0xe613b,0x27078,0x27155,
0x27229,0x27243,0x16b7d,0x1763a,0x26535,0x26866,0x26d40,0x2702e,
0xe2370,0x00000,0x1702f,0xe543e,0x26141,0x26536,0x26867,0x26868,
0x26869,0x26b4c,0xe5e24,0x26b48,0x17b54,0x26b4b,0x26b4a,0x17a5f,
0x26b49,0x17a61,0x00000,0x17a60,0x26d42,0x26d41,0x17b55,0x17b56,
0x00000,0xe5f3e,0x17c32,0x26e7a,0x17c31,0x00000,0x27031,0x27032,
0x27030,0x2702f,0x17d21,0x00000,0x27079,0x2707a,0x2707b,0x17c7e,
0x27156,0x27159,0x27158,0x27157,0xe6233,0x00000,0x27242,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x1733e,0xe5755,0x00000,
0x17832,0x26b4d,0x26d43,0xe602b,0x17c33,0x26e7b,0x00000,0xe6242,
0x27244,0x00000,0x00000,0x00000,0x1733f,0xe5e47,0x00000,0x00000,
0x26142,0xe5f3f,0x26e7c,0xe6161,0x2716f,0xe6177};

static const int ucs_i_cns11643_table_min = 0x4d00;
static const int ucs_i_cns11643_table_max = 0x4d00 + (sizeof (ucs_i_cns11643_table) / sizeof (unsigned int));

static const unsigned int ucs_r_cns11643_table[] = {
/* 0xfe00 */
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x1212b,0x12136,0x12138,0x00000,0x00000,0x12140,0x12141,0x12144,
0x12145,0x12148,0x12149,0x1214c,0x1214d,0x12150,0x12151,0x12154,
0x12155,0x12158,0x12159,0x1215c,0x1215d,0x00000,0x00000,0x00000,
0x00000,0x12227,0x12228,0x1222b,0x1222c,0x12229,0x1222a,0x00000,
0x1212e,0x1212f,0x12130,0x00000,0x12132,0x12133,0x12134,0x12135,
0x00000,0x1215e,0x1215f,0x12160,0x12161,0x12162,0x12163,0x1222d,
0x1222e,0x1222f,0x1223f,0x12240,0x12241,0x12243,0x12242,0x00000,
0x12262,0x1226c,0x1226d,0x1226e,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
/* 0xff00 */
0x00000,0x1212a,0x00000,0x1216c,0x12263,0x12268,0x1216d,0x00000,
0x1213e,0x1213f,0x1216e,0x12230,0x12122,0x12231,0x12125,0x1225f,
0x12421,0x12422,0x12423,0x12424,0x12425,0x12426,0x12427,0x12428,
0x12429,0x1242a,0x12128,0x12127,0x12236,0x12238,0x12237,0x12129,
0x12269,0x12441,0x12442,0x12443,0x12444,0x12445,0x12446,0x12447,
0x12448,0x12449,0x1244a,0x1244b,0x1244c,0x1244d,0x1244e,0x1244f,
0x12450,0x12451,0x12452,0x12453,0x12454,0x12455,0x12456,0x12457,
0x12458,0x12459,0x1245a,0x00000,0x12260,0x00000,0x00000,0x12225,
0x00000,0x1245b,0x1245c,0x1245d,0x1245e,0x1245f,0x12460,0x12461,
0x12462,0x12463,0x12464,0x12465,0x12466,0x12467,0x12468,0x12469,
0x1246a,0x1246b,0x1246c,0x1246d,0x1246e,0x1246f,0x12470,0x12471,
0x12472,0x12473,0x12474,0x12142,0x1225e,0x12143,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,0x00000,
0x12266,0x12267,0x00000,0x00000,0x00000,0x12264};

static const int ucs_r_cns11643_table_min = 0xfe00;
static const int ucs_r_cns11643_table_max = 0xfe00 + (sizeof (ucs_r_cns11643_table) / sizeof (unsigned int));


#endif /* UNICODE_TABLE_CNS11643_H */
