/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_am extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "\u1300\u122d\u1218\u1295";
        final String metaValue_GR = "\u130d\u122a\u12ad";
        final String metaValue_NR = "\u1293\u12a1\u1229";
        final String metaValue_ar = "\u12d3\u1228\u1265\u129b";
        final String metaValue_ja = "\u1303\u1353\u1295\u129b";
        final String metaValue_ko = "\u12ae\u122a\u12eb\u129b";
        final Object[][] data = new Object[][] {
            { "sbp", "\u1233\u1295\u1309" },
            { "ksh", "\u12ae\u120e\u129d\u12eb\u1295" },
            { "nyn", "\u1292\u12eb\u1295\u12ae\u120d\u129b" },
            { "luo", "\u1209\u12a6" },
            { "Zsym", "\u121d\u120d\u12ad\u1276\u127d" },
            { "fil", "\u134a\u120a\u1352\u1295\u129b" },
            { "cch", "\u12a0\u1275\u1233\u121d" },
            { "del", "\u12f3\u120b\u12cc\u122d" },
            { "bal", "\u1263\u1209\u127a" },
            { "ban", "\u1263\u120a\u1294\u1235" },
            { "luy", "\u1209\u12ea\u12eb" },
            { "bar", "\u1263\u126b\u122a\u12eb\u1295" },
            { "bas", "\u1263\u1233" },
            { "egy", "\u12e8\u1325\u1295\u1273\u12ca \u130d\u1265\u133d\u129b" },
            { "bax", "\u1263\u1219\u1295" },
            { "es_ES", "\u12e8\u12a0\u12cd\u122e\u1353 \u1235\u1353\u1295\u123d\u129b" },
            { "teo", "\u1274\u1236" },
            { "aa", "\u12a0\u134b\u122d\u129b" },
            { "ab", "\u12a0\u1265\u1210\u12da\u129b" },
            { "AC", "\u12a0\u1234\u1295\u123d\u1295 \u12f0\u1234\u1275" },
            { "bbc", "\u1263\u1273\u12ab \u1276\u1263" },
            { "tet", "\u1274\u1270\u121d" },
            { "AD", "\u12a0\u1295\u12f6\u122b" },
            { "AE", "\u12e8\u1270\u1263\u1260\u1229\u1275 \u12a0\u1228\u1265 \u12a4\u121d\u122c\u1275\u1235" },
            { "ae", "\u12a0\u126c\u1235\u1273\u1295" },
            { "nl_BE", "\u134d\u120c\u121a\u123d" },
            { "AF", "\u12a0\u134d\u130b\u1292\u1235\u1273\u1295" },
            { "af", "\u12a0\u134d\u122a\u12ab\u1295\u129b" },
            { "AG", "\u12a0\u1295\u1272\u1313 \u12a5\u1293 \u1263\u1229\u12f3" },
            { "AI", "\u12a0\u1295\u1309\u12a2\u120b" },
            { "ak", "\u12a0\u12ab\u1295\u129b" },
            { "AL", "\u12a0\u120d\u1263\u1292\u12eb" },
            { "AM", "\u12a0\u122d\u121c\u1292\u12eb" },
            { "am", "\u12a0\u121b\u122d\u129b" },
            { "Arab", metaValue_ar },
            { "an", "\u12a0\u122b\u130e\u1295\u1235" },
            { "AO", "\u12a0\u1295\u1310\u120b" },
            { "Jpan", metaValue_ja },
            { "AQ", "\u12a0\u1295\u1273\u122d\u12ad\u1272\u12ab" },
            { "ar", metaValue_ar },
            { "AR", "\u12a0\u122d\u1300\u1295\u1272\u1293" },
            { "AS", "\u12e8\u12a0\u121c\u122a\u12ab \u1233\u121e\u12a0" },
            { "as", "\u12a0\u1233\u121c\u12db\u12ca" },
            { "AT", "\u12a6\u1235\u1275\u122a\u12eb" },
            { "AU", "\u12a0\u12cd\u1235\u1275\u122b\u120d\u12eb" },
            { "av", "\u12a0\u126b\u122a\u12ad" },
            { "AW", "\u12a0\u1229\u1263" },
            { "sdh", "\u12f0\u1261\u1263\u12ca \u12a9\u12f2\u123d" },
            { "en_US", "\u12e8\u12a0\u121c\u122a\u12ab \u12a5\u1295\u130d\u120a\u12dd\u129b" },
            { "AX", "\u12e8\u12a0\u120b\u1295\u12f5 \u12f0\u1234\u1276\u127d" },
            { "ay", "\u12a0\u12eb\u121b\u122d\u129b" },
            { "AZ", "\u12a0\u12d8\u122d\u1263\u1303\u1295" },
            { "az", "\u12a0\u12d8\u122d\u1263\u1303\u1295\u129b" },
            { "BA", "\u1266\u1235\u1292\u12eb \u12a5\u1293 \u1204\u122d\u12de\u130e\u126a\u1292\u12eb" },
            { "ba", "\u1263\u1235\u12aa\u122d\u129b" },
            { "BB", "\u1263\u122d\u1264\u12f6\u1235" },
            { "ceb", "\u12ab\u1261\u12cb\u1296" },
            { "BD", "\u1263\u1295\u130d\u120b\u12f2\u123d" },
            { "BE", "\u1264\u120d\u1304\u121d" },
            { "be", "\u1264\u120b\u122b\u123b\u129b" },
            { "BF", "\u1261\u122d\u12aa\u1293 \u134b\u1236" },
            { "BG", "\u1261\u120d\u130c\u122a\u12eb" },
            { "bg", "\u1261\u120d\u130b\u122a\u129b" },
            { "BH", "\u1263\u1205\u122c\u1295" },
            { "BI", "\u1265\u1229\u1295\u12f2" },
            { "bi", "\u1262\u1235\u120b\u121d\u129b" },
            { "BJ", "\u1264\u1292\u1295" },
            { "BL", "\u1245\u12f1\u1235 \u1260\u122d\u1274\u120e\u121c" },
            { "BM", "\u1264\u122d\u1219\u12f3" },
            { "bm", "\u1263\u121d\u1263\u122d\u129b" },
            { "BN", "\u1265\u1229\u1292" },
            { "bn", "\u1264\u1295\u130b\u120a\u129b" },
            { "BO", "\u1266\u120a\u126a\u12eb" },
            { "bo", "\u1272\u1264\u1273\u1295\u129b" },
            { "dgr", "\u12f6\u130d\u122a\u1265" },
            { "BQ", "\u12e8\u12ab\u122a\u1262\u12eb\u1295 \u1294\u12d8\u122d\u120b\u1295\u12f5\u1235" },
            { "BR", "\u1265\u122b\u12da\u120d" },
            { "br", "\u1265\u122c\u1276\u1295\u129b" },
            { "BS", "\u1263\u1203\u121b\u1235" },
            { "bs", "\u1266\u1235\u1292\u12eb\u1295\u129b" },
            { "xog", "\u1236\u130b" },
            { "BT", "\u1261\u1205\u1273\u1295" },
            { "BV", "\u1261\u126c\u1275 \u12f0\u1234\u1275" },
            { "BW", "\u1266\u1275\u1235\u12cb\u1293" },
            { "Mymr", "\u121d\u12eb\u1295\u121b\u122d" },
            { "BY", "\u1264\u120b\u1229\u1235" },
            { "seh", "\u1234\u1293" },
            { "BZ", "\u1264\u120a\u12d8" },
            { "CA", "\u12ab\u1293\u12f3" },
            { "ca", "\u12ab\u1273\u120b\u1295\u129b" },
            { "CC", "\u12ae\u12ae\u1235(\u12ac\u120a\u1295\u130d) \u12f0\u1234\u1276\u127d" },
            { "mzn", "\u121b\u12db\u1295\u12f0\u122b\u1292" },
            { "ses", "\u12ae\u12ed\u122b\u1266\u122e \u1234\u1292" },
            { "CD", "\u12ae\u1295\u130e-\u12aa\u1295\u123b\u1233" },
            { "ce", "\u127d\u127d\u1295" },
            { "CF", "\u12e8\u1218\u12ab\u12a8\u1208\u129b\u12cd \u12a0\u134d\u122a\u12ab \u122a\u1350\u1265\u120a\u12ad" },
            { "CG", "\u12ae\u1295\u130e \u1265\u122b\u12db\u126a\u120d" },
            { "CH", "\u1235\u12ca\u12d8\u122d\u120b\u1295\u12f5" },
            { "ch", "\u127b\u121e\u122e" },
            { "CI", "\u12ae\u1275 \u12f2\u126f\u122d" },
            { "CK", "\u12a9\u12ad \u12f0\u1234\u1276\u127d" },
            { "CL", "\u127a\u120a" },
            { "CM", "\u12ab\u121c\u1229\u1295" },
            { "CN", "\u127b\u12ed\u1293" },
            { "CO", "\u12ae\u120e\u121d\u1262\u12eb" },
            { "co", "\u12ae\u122d\u1232\u12ab\u129b" },
            { "CP", "\u12ad\u120a\u1350\u122d\u1276\u1295 \u12f0\u1234\u1275" },
            { "Orya", "\u12a6\u122a\u12eb" },
            { "CR", "\u12ae\u1235\u1273 \u122a\u12ab" },
            { "cr", "\u12ad\u122a" },
            { "cs", "\u127c\u12ad\u129b" },
            { "CU", "\u12a9\u1263" },
            { "cu", "\u1278\u122d\u127d \u1235\u120b\u126a\u12ad" },
            { "CV", "\u12ac\u1355 \u126c\u122d\u12f4" },
            { "cv", "\u1279\u126b\u123d" },
            { "CW", "\u12a9\u122b\u1233\u12ce" },
            { "CX", "\u12e8\u1308\u1293 \u12f0\u1234\u1275" },
            { "CY", "\u1233\u12ed\u1355\u1228\u1235" },
            { "cy", "\u12c8\u120d\u123d" },
            { "CZ", "\u127c\u12ad \u122a\u1351\u1265\u120a\u12ad" },
            { "da", "\u12f4\u1292\u123d" },
            { "pt_PT", "\u12e8\u12a0\u12cd\u122e\u1353 \u1356\u122d\u1279\u130b\u120d\u129b" },
            { "de", metaValue_DE },
            { "DE", metaValue_DE },
            { "ace", "\u12a0\u127b\u12ed\u1295\u129b" },
            { "cgg", "\u127a\u130b\u129b" },
            { "DG", "\u12f2\u12ec\u130e \u130b\u122d\u123a\u12eb" },
            { "DJ", "\u1302\u1261\u1272" },
            { "bej", "\u1264\u1303" },
            { "DK", "\u12f4\u1295\u121b\u122d\u12ad" },
            { "ach", "\u12a0\u12ae\u120a\u129b" },
            { "Brai", "\u1265\u122c\u12ed\u120d" },
            { "din", "\u12f2\u1295\u12ab" },
            { "DM", "\u12f6\u121a\u1292\u12ab" },
            { "DO", "\u12f6\u121a\u1292\u12ad \u122a\u1351\u1265\u120a\u12ad" },
            { "bem", "\u1264\u121d\u1263" },
            { "dv", "\u12f2\u126c\u1205" },
            { "es_419", "\u12e8\u120b\u1272\u1295 \u12a0\u121c\u122a\u12ab \u1235\u1353\u1292\u123d" },
            { "tig", "\u1275\u130d\u1228" },
            { "bew", "\u1264\u1273\u12ca" },
            { "DZ", "\u12a0\u120d\u1304\u122a\u12eb" },
            { "dz", "\u12f5\u12de\u1295\u130d\u12bb\u129b" },
            { "bez", "\u1264\u1293" },
            { "EA", "\u1234\u12a1\u1273\u1293 \u121c\u120a\u120b" },
            { "chb", "\u127a\u1265\u127b" },
            { "EC", "\u12a2\u12b3\u12f6\u122d" },
            { "dje", "\u12db\u122d\u121b\u129b" },
            { "ada", "\u12a0\u12f3\u1295\u130d\u121c" },
            { "EE", "\u12a4\u1235\u1276\u1292\u12eb" },
            { "ee", "\u12a2\u12ca" },
            { "bfd", "\u1263\u1349\u1275" },
            { "EG", "\u130d\u1265\u133d" },
            { "EH", "\u121d\u12d5\u122b\u1263\u12ca \u1233\u1205\u122b" },
            { "chg", "\u127b\u130b\u1273\u12ed" },
            { "ro_MD", "\u121e\u120d\u12f3\u126b\u12ca\u1293" },
            { "el", "\u130d\u122a\u12ad\u129b" },
            { "chk", "\u1279\u12ad\u1235" },
            { "chn", "\u127a\u1291\u12ad \u1303\u122d\u130e\u1295" },
            { "en", "\u12a5\u1295\u130d\u120a\u12dd\u129b" },
            { "eo", "\u12a4\u1235\u1350\u122b\u1295\u1276" },
            { "chp", "\u127a\u1354\u12cd\u12eb\u1295" },
            { "cho", "\u127e\u12ad\u1273\u12cb" },
            { "bfq", "\u1263\u12f3\u130b" },
            { "chr", "\u127c\u122e\u12ac\u129b" },
            { "ER", "\u12a4\u122d\u1275\u122b" },
            { "ES", "\u1235\u1354\u1295" },
            { "es", "\u1235\u1353\u1295\u123d\u129b" },
            { "ET", "\u12a2\u1275\u12ee\u1335\u12eb" },
            { "et", "\u12a2\u1235\u1276\u1292\u12eb\u1295\u129b" },
            { "EU", "\u12e8\u12a0\u12cd\u122e\u1353 \u1205\u1265\u1228\u1275" },
            { "eu", "\u1263\u1235\u12ad\u129b" },
            { "Hang", "\u1210\u1295\u1309\u120d" },
            { "chy", "\u127d\u12ec\u1294" },
            { "shi", "\u1273\u127c\u120d\u1202\u1275" },
            { "hsb", "\u12e8\u120b\u12ed\u129b\u12cd \u1236\u122d\u1262\u12eb\u1295\u129b" },
            { "Hani", "\u1203\u1295" },
            { "ady", "\u12a0\u12f5\u12ed\u130d\u1204" },
            { "fa", "\u1350\u122d\u123a\u12eb\u129b" },
            { "Hans", "\u1240\u1208\u120d \u12eb\u1208" },
            { "Hant", "\u1263\u1205\u120b\u12ca" },
            { "shu", "\u127b\u12f2\u12eb\u1295 \u12d3\u1228\u1265\u129b" },
            { "FI", "\u134a\u1295\u120b\u1295\u12f5" },
            { "fi", "\u134a\u1292\u123d" },
            { "FJ", "\u134a\u1302" },
            { "fj", "\u134a\u1302\u129b" },
            { "FK", "\u12e8\u134e\u12ad\u120b\u1295\u12f5 \u12f0\u1234\u1276\u127d" },
            { "FM", "\u121a\u12ad\u122e\u1294\u12e2\u12eb" },
            { "bgn", "\u12e8\u121d\u12d5\u122b\u1265 \u1263\u120e\u127a" },
            { "yue", "\u12ab\u1295\u1276\u1292\u12dd" },
            { "FO", "\u12e8\u134b\u122e \u12f0\u1234\u1276\u127d" },
            { "fo", "\u134b\u122e\u129b" },
            { "Taml", "\u1273\u121a\u120d" },
            { "FR", "\u1348\u1228\u1295\u1233\u12ed" },
            { "fr", "\u1348\u1228\u1295\u1233\u12ed\u129b" },
            { "sid", "\u1232\u12f3\u121d\u129b" },
            { "fy", "\u12e8\u121d\u12d5\u122b\u1265 \u134d\u122a\u1235\u129b" },
            { "grc", "\u12e8\u1325\u1295\u1273\u12ca \u130d\u122a\u12ad" },
            { "GA", "\u130b\u1266\u1295" },
            { "ga", "\u12a0\u12ed\u122a\u123d" },
            { "GB", "\u12a5\u1295\u130d\u120a\u12dd" },
            { "GD", "\u130d\u122c\u1293\u12f3" },
            { "gd", "\u12a5\u1235\u12ae\u1275\u1235 \u130c\u120d\u12ad\u129b" },
            { "GE", "\u1306\u122d\u1302\u12eb" },
            { "GF", "\u12e8\u1348\u1228\u1295\u1233\u12ed \u1309\u12ca\u12a0\u1293" },
            { "GG", "\u1309\u122d\u1290\u1232" },
            { "GH", "\u130b\u1293" },
            { "GI", "\u1302\u1265\u122b\u120d\u1270\u122d" },
            { "afh", "\u12a0\u134d\u122a\u1202\u120a" },
            { "GL", "\u130d\u122a\u1295\u120b\u1295\u12f5" },
            { "gl", "\u130b\u120a\u123a\u12eb" },
            { "GM", "\u130b\u121d\u1262\u12eb" },
            { "GN", "\u130a\u1292" },
            { "gn", "\u1313\u122b\u1292\u129b" },
            { "bho", "\u1266\u1301\u122a" },
            { "GP", "\u1309\u12cb\u12f0\u1209\u1355" },
            { "GQ", "\u12a2\u12b3\u1276\u122a\u12eb\u120d \u130a\u1292" },
            { "und", "\u12eb\u120d\u1273\u12c8\u1240 \u124b\u1295\u124b" },
            { "GR", metaValue_GR },
            { "GS", "\u12f0\u1261\u1265 \u1306\u122d\u1302\u12eb \u12a5\u1293 \u12e8\u12f0\u1261\u1265 \u1233\u1295\u12f5\u12ca\u127d \u12f0\u1234\u1276\u127d" },
            { "GT", "\u1309\u12cb\u1272\u121b\u120b" },
            { "GU", "\u1309\u12cb\u121d" },
            { "gu", "\u1309\u1303\u122d\u1272\u129b" },
            { "gv", "\u121b\u1295\u12ad\u1235\u129b" },
            { "GW", "\u130a\u1292 \u1262\u1233\u12a6" },
            { "tlh", "\u12ad\u120a\u1295\u130e\u1295\u129b" },
            { "GY", "\u1309\u12eb\u1293" },
            { "ha", "\u1203\u12cd\u1233\u129b" },
            { "ckb", "\u12e8\u1236\u122b\u1292 \u12a9\u122d\u12f5\u129b" },
            { "zxx", "\u124b\u1295\u124b\u12ca \u12ed\u12d8\u1275 \u12a0\u12ed\u12f0\u1208\u121d" },
            { "he", "\u12d5\u1265\u122b\u1235\u1325" },
            { "hi", "\u1212\u1295\u12f1\u129b" },
            { "de_AT", "\u12e8\u12a6\u1235\u1275\u122a\u12eb \u1300\u122d\u1218\u1295" },
            { "HK", "\u1206\u1295\u130d \u12ae\u1295\u130d SAR \u127b\u12ed\u1293" },
            { "HM", "\u12bd\u122d\u12f5 \u12f0\u1234\u1276\u127d\u1293 \u121b\u12ad\u12f6\u1293\u120d\u12f5 \u12f0\u1234\u1276\u127d" },
            { "bik", "\u1262\u12ae\u120d" },
            { "HN", "\u1206\u1295\u12f1\u122b\u1235" },
            { "bin", "\u1262\u1292" },
            { "HR", "\u12ad\u122e\u12a4\u123d\u12eb" },
            { "hr", "\u12ad\u122e\u123d\u12eb\u1295\u129b" },
            { "agq", "\u12a0\u1308\u121d" },
            { "gsw", "\u12e8\u1235\u12ca\u12dd \u1300\u122d\u1218\u1295" },
            { "HT", "\u1200\u12ed\u1272" },
            { "ht", "\u1203\u12ed\u1275\u129b" },
            { "HU", "\u1200\u1295\u130b\u122a" },
            { "hu", "\u1200\u1295\u130b\u122a\u129b" },
            { "hy", "\u12a0\u122d\u1218\u1293\u12ca" },
            { "frc", "\u12ab\u1301\u1295 \u134d\u122c\u1295\u127d" },
            { "ia", "\u12a2\u1295\u1274\u122d\u120a\u1295\u1313" },
            { "IC", "\u12e8\u12ab\u1293\u122a \u12f0\u1234\u1276\u127d" },
            { "ID", "\u12a2\u1295\u12f6\u1294\u12e2\u12eb" },
            { "id", "\u12a2\u1295\u12f6\u1294\u12e5\u129b" },
            { "IE", "\u12a0\u12e8\u122d\u120b\u1295\u12f5" },
            { "ie", "\u12a5\u1295\u1270\u122d\u120a\u1295\u130d\u12c8" },
            { "ig", "\u12a2\u130d\u1266\u129b" },
            { "naq", "\u1293\u121b" },
            { "ii", "\u1232\u1279\u1295\u12ea\u129b" },
            { "ik", "\u12a5\u1291\u1352\u12eb\u1245\u129b" },
            { "IL", "\u12a5\u1235\u122b\u12a4\u120d" },
            { "IM", "\u12a0\u12ed\u120d \u12a6\u134d \u121b\u1295" },
            { "IN", "\u1205\u1295\u12f5" },
            { "frp", "\u12a0\u122d\u1352\u1273\u1295" },
            { "IO", "\u12e8\u1265\u122a\u1273\u1292\u12eb \u1205\u1295\u12f5 \u12cd\u1242\u12eb\u1296\u1235 \u130d\u12db\u1275" },
            { "bjn", "\u1263\u1295\u1303\u122d" },
            { "IQ", "\u12a2\u122b\u1245" },
            { "IR", "\u12a2\u122b\u1295" },
            { "IS", "\u12a0\u12ed\u1235\u120b\u1295\u12f5" },
            { "is", "\u12a0\u12ed\u1235\u120b\u1295\u12f5\u129b" },
            { "IT", "\u1323\u120a\u12eb\u1295" },
            { "it", "\u1323\u120a\u12eb\u1295\u129b" },
            { "iu", "\u12a5\u1291\u12ad\u1272\u1271\u1275\u129b" },
            { "ja", metaValue_ja },
            { "Mlym", "\u121b\u120b\u12eb\u120d\u121d" },
            { "JE", "\u1300\u122d\u1232" },
            { "doi", "\u12f6\u130d\u122a" },
            { "JM", "\u1303\u121b\u12ed\u12ab" },
            { "Beng", "\u1264\u1295\u130b\u120a" },
            { "JO", "\u1306\u122d\u12f3\u1295" },
            { "JP", "\u1303\u1353\u1295" },
            { "sma", "\u12f0\u1261\u1263\u12ca \u1233\u121a" },
            { "ain", "\u12a0\u12ed\u1291" },
            { "jv", "\u1303\u126b\u1295\u129b" },
            { "guz", "\u1309\u1235\u120a\u129b" },
            { "smj", "\u1209\u120c \u1233\u121a" },
            { "de_CH", "\u12e8\u1235\u12ca\u12dd \u12a8\u134d\u1270\u129b \u1300\u122d\u1218\u1295\u129b" },
            { "smn", "\u12a2\u1293\u122a \u1233\u121a" },
            { "ka", "\u1306\u122d\u1302\u12eb\u1295" },
            { "sms", "\u1235\u12ae\u120d\u1275 \u1233\u121a" },
            { "KE", "\u12ac\u1295\u12eb" },
            { "419", "\u120b\u1272\u1295 \u12a0\u121c\u122a\u12ab" },
            { "KG", "\u12aa\u122d\u130a\u1235\u1273\u1295" },
            { "kg", "\u12ae\u1295\u130e\u129b" },
            { "KH", "\u12ab\u121d\u1266\u12f2\u12eb" },
            { "KI", "\u12aa\u122a\u1263\u1272" },
            { "ki", "\u12aa\u12a9\u12e9" },
            { "mas", "\u121b\u1233\u12ed" },
            { "kk", "\u12ab\u12db\u12ad\u129b" },
            { "kl", "\u12ab\u120b\u120a\u1231\u1275\u129b" },
            { "KM", "\u12ae\u121e\u122e\u1235" },
            { "km", "\u12ad\u1218\u122d\u129b \u121b\u12a5\u12a8\u120b\u12ca" },
            { "KN", "\u1245\u12f1\u1235 \u12aa\u1275\u1235 \u12a5\u1293 \u1294\u126a\u1235" },
            { "kn", "\u12ab\u1293\u12f3\u129b" },
            { "Knda", "\u12ab\u1295\u12a0\u12f3" },
            { "fr_CA", "\u12e8\u12ab\u1293\u12f3 \u1348\u1228\u1295\u1233\u12ed\u129b" },
            { "ko", metaValue_ko },
            { "KP", "\u1230\u121c\u1295 \u12ae\u122a\u12eb" },
            { "KR", "\u12f0\u1261\u1265 \u12ae\u122a\u12eb" },
            { "ks", "\u12ab\u123d\u121a\u122d\u129b" },
            { "ku", "\u12a9\u122d\u12f5\u123d\u129b" },
            { "fr_CH", "\u12e8\u1235\u12ca\u12dd \u1348\u1228\u1295\u1233\u12ed\u129b" },
            { "KW", "\u12ad\u12cc\u1275" },
            { "kw", "\u12ae\u122d\u1292\u123d" },
            { "tpi", "\u1276\u12ad \u1352\u1232\u1295" },
            { "KY", "\u12ab\u12ed\u121b\u1295 \u12f0\u1234\u1276\u127d" },
            { "ky", "\u12aa\u122d\u130a\u12dd\u129b" },
            { "KZ", "\u12ab\u12db\u12aa\u1235\u1273\u1295" },
            { "Cyrl", "\u1232\u12ed\u122a\u120d\u12ad" },
            { "LA", "\u120b\u12a6\u1235" },
            { "la", "\u120b\u1272\u1295\u129b" },
            { "LB", "\u120a\u1263\u1296\u1235" },
            { "lb", "\u1209\u12ad\u12d8\u121d\u1260\u122d\u1308\u122d\u129b" },
            { "LC", "\u1234\u1295\u1275 \u1209\u127a\u12eb" },
            { "lg", "\u130b\u1295\u12f3\u129b" },
            { "nds", "\u12e8\u1273\u127d\u129b\u12cd \u1300\u122d\u1218\u1295" },
            { "LI", "\u120a\u127d\u1270\u1295\u1235\u1273\u12ed\u1295" },
            { "LK", "\u1232\u122a\u120b\u1295\u12ab" },
            { "akk", "\u12a0\u12ab\u12f2\u12eb\u1295" },
            { "Tibt", "\u1272\u1264\u1273\u1295" },
            { "ln", "\u120a\u1295\u130b\u120b\u129b" },
            { "lo", "\u120b\u12cd\u1235\u129b" },
            { "cop", "\u12ae\u1355\u1272\u12ad" },
            { "LR", "\u120b\u12ed\u1264\u122a\u12eb" },
            { "esu", "\u1234\u1295\u1270\u122b\u120d \u12e9\u1352\u12ad" },
            { "LS", "\u120c\u1236\u1276" },
            { "LT", "\u120a\u1271\u12cc\u1292\u12eb" },
            { "lt", "\u1209\u1274\u1295\u12eb\u1295\u129b" },
            { "LU", "\u1209\u12ad\u1230\u121d\u1260\u122d\u130d" },
            { "lu", "\u1209\u1263 \u12ab\u1273\u1295\u130b" },
            { "LV", "\u120b\u1275\u126a\u12eb" },
            { "lv", "\u120b\u1275\u126a\u12eb\u1295" },
            { "Kana", "\u12ab\u1273\u12ab\u1293" },
            { "LY", "\u120a\u1262\u12eb" },
            { "vun", "\u1269\u1295\u1306" },
            { "akz", "\u12a0\u120b\u1263\u121b" },
            { "lag", "\u120b\u1295\u130a" },
            { "Thaa", "\u1273\u1293" },
            { "MA", "\u121e\u122e\u12ae" },
            { "MC", "\u121e\u1293\u12ae" },
            { "MD", "\u121e\u120d\u12f6\u126b" },
            { "ME", "\u121e\u1295\u1270\u1294\u130d\u122e" },
            { "MF", "\u1234\u1295\u1275 \u121b\u122d\u1272\u1295" },
            { "MG", "\u121b\u12f3\u130b\u1235\u12ab\u122d" },
            { "mg", "\u121b\u120b\u130b\u1235\u129b" },
            { "MH", "\u121b\u122d\u123b\u120d \u12a0\u12ed\u120b\u1295\u12f5" },
            { "ale", "\u12a0\u120d\u12e9\u1275" },
            { "Thai", "\u1273\u12ed" },
            { "mi", "\u121b\u12ee\u122a\u129b" },
            { "MK", "\u1218\u1244\u12f6\u1295\u12eb" },
            { "mk", "\u121b\u1234\u12f6\u1295\u129b" },
            { "ML", "\u121b\u120a" },
            { "ml", "\u121b\u120b\u12eb\u120b\u121d\u129b" },
            { "MM", "\u121b\u12ed\u1293\u121b\u122d(\u1260\u122d\u121b)" },
            { "MN", "\u121e\u1295\u130e\u120a\u12eb" },
            { "mn", "\u121e\u1295\u130e\u120b\u12ca\u129b" },
            { "MO", "\u121b\u12ab\u12a1 \u120d\u12e9 \u12e8\u12a0\u1235\u1270\u12f3\u12f0\u122d \u12ad\u120d\u120d \u127b\u12ed\u1293" },
            { "MP", "\u12e8\u1230\u121c\u1293\u12ca \u121b\u122a\u12eb\u1293 \u12f0\u1234\u1276\u127d" },
            { "MQ", "\u121b\u122d\u1272\u1292\u12ad" },
            { "MR", "\u121e\u122a\u1274\u1292\u12eb" },
            { "mr", "\u121b\u122b\u1272\u129b" },
            { "MS", "\u121e\u1295\u1275\u1234\u122b\u1275" },
            { "ms", "\u121b\u120b\u12ed\u129b" },
            { "MT", "\u121b\u120d\u1273" },
            { "mt", "\u121b\u120d\u1272\u1235\u129b" },
            { "cps", "\u12ab\u1352\u12dd\u1296\u1295" },
            { "MU", "\u121e\u122a\u1238\u1235" },
            { "MV", "\u121b\u120d\u12f2\u126d\u1235" },
            { "MW", "\u121b\u120b\u12ca" },
            { "MX", "\u121c\u12ad\u1232\u12ae" },
            { "MY", "\u121b\u120c\u12e2\u12eb" },
            { "my", "\u1261\u122d\u121b\u129b" },
            { "MZ", "\u121e\u12db\u121d\u1262\u12ad" },
            { "Armn", "\u12a0\u122d\u121c\u1295\u12eb\u12ca" },
            { "dsb", "\u12e8\u1273\u127d\u129b\u12cd \u1230\u122d\u1262\u12eb\u1295\u129b" },
            { "na", metaValue_NR },
            { "NA", "\u1293\u121a\u1262\u12eb" },
            { "nb", "\u12e8\u1296\u122d\u12cc\u12ed \u1266\u12ad\u121b\u120d" },
            { "NC", "\u1292\u12cd \u12ab\u120c\u12f6\u1292\u12eb" },
            { "nd", "\u1230\u121c\u1295 \u1295\u12f4\u1265\u120c" },
            { "NE", "\u1292\u1300\u122d" },
            { "ne", "\u1294\u1353\u120a\u129b" },
            { "NF", "\u1296\u122d\u134e\u120d\u12ad \u12f0\u1234\u1275" },
            { "NG", "\u1293\u12ed\u1304\u122a\u12eb" },
            { "NI", "\u1292\u12ab\u122b\u1313" },
            { "NL", "\u1294\u12d8\u122d\u120b\u1295\u12f5" },
            { "nl", "\u12f0\u127d" },
            { "nn", "\u12e8\u1296\u122d\u12cc\u12ed \u1293\u12ed\u1296\u122d\u1235\u12ad" },
            { "NO", "\u1296\u122d\u12cc\u12ed" },
            { "no", "\u1296\u122d\u12cc\u1302\u12eb\u1295" },
            { "NP", "\u1294\u1353\u120d" },
            { "NR", metaValue_NR },
            { "NU", "\u1292\u12a1\u12ed" },
            { "rof", "\u122e\u121d\u1266" },
            { "ny", "\u1295\u12eb\u1295\u1303" },
            { "NZ", "\u1292\u12cd \u12da\u120b\u1295\u12f5" },
            { "kab", "\u12ab\u1265\u12ed\u120d" },
            { "oc", "\u12a6\u12aa\u1273\u1295\u129b" },
            { "kam", "\u12ab\u121d\u1263" },
            { "crh", "\u12ad\u122a\u121a\u12eb\u1295 \u1270\u122d\u12aa\u123d" },
            { "mer", "\u121c\u1229" },
            { "OM", "\u12a6\u121b\u1295" },
            { "om", "\u12a6\u122e\u121e\u129b" },
            { "dtp", "\u1234\u1295\u1270\u122b\u120d \u12f1\u1230\u1295" },
            { "anp", "\u12a0\u1295\u130a\u12ab" },
            { "or", "\u12a6\u122a\u12eb\u129b" },
            { "os", "\u12a6\u1234\u1272\u12ad" },
            { "bpy", "\u1262\u1239\u1295\u1351\u122a\u12eb" },
            { "mfe", "\u121e\u122a\u1232\u12e8\u129b" },
            { "PA", "\u1353\u1293\u121b" },
            { "pa", "\u1351\u1295\u1303\u1265\u129b" },
            { "dua", "\u12f1\u12cb\u120b\u129b" },
            { "en_GB", "\u12e8\u1265\u122a\u1272\u123d \u12a5\u1295\u130d\u120a\u12dd\u129b" },
            { "PE", "\u1354\u1229" },
            { "PF", "\u12e8\u1348\u1228\u1295\u1233\u12ed \u1356\u120a\u1294\u12e2\u12eb" },
            { "PG", "\u1353\u1351\u12cb \u1292\u12cd \u130a\u1292" },
            { "PH", "\u134a\u120a\u1352\u1295\u1235" },
            { "PK", "\u1353\u12aa\u1235\u1273\u1295" },
            { "bqi", "\u1263\u12ad\u1205\u1272\u12eb\u122a" },
            { "PL", "\u1356\u120b\u1295\u12f5" },
            { "pl", "\u1356\u120a\u123d\u129b" },
            { "PM", "\u1245\u12f1\u1235 \u1352\u12ec\u122d \u12a5\u1293 \u121a\u12a9\u12a4\u120e\u1295" },
            { "PN", "\u1352\u1275\u12ab\u12a2\u122d\u1295 \u12a0\u12ed\u1235\u120b\u1295\u12f5" },
            { "PR", "\u1356\u122d\u1273 \u122a\u12ae" },
            { "PS", "\u12e8\u134d\u120d\u1235\u1324\u121d \u130d\u12db\u1275" },
            { "ps", "\u1353\u123d\u1276\u129b" },
            { "PT", "\u1356\u122d\u1271\u130b\u120d" },
            { "pt", "\u1356\u122d\u1279\u130b\u120d\u129b" },
            { "PW", "\u1353\u120b\u12cd" },
            { "PY", "\u1353\u122b\u1313\u12ed" },
            { "pt_BR", "\u12e8\u1265\u122b\u12da\u120d \u1356\u122d\u1279\u130b\u120d\u129b" },
            { "tum", "\u1271\u121d\u1261\u12ab" },
            { "mgh", "\u121b\u12a9\u12cb \u121c\u1276" },
            { "Hebr", "\u12a5\u1265\u122b\u12ed\u1235\u1325" },
            { "QA", "\u12b3\u1273\u122d" },
            { "bra", "\u1265\u122b\u1305" },
            { "Laoo", "\u120b\u12a6" },
            { "mgo", "\u121c\u1273" },
            { "brh", "\u1265\u122b\u1201\u12ea" },
            { "QO", "\u12a0\u12cd\u1275\u120b\u12ed\u1295\u130d \u12a6\u123d\u1295\u12eb" },
            { "qu", "\u12b5\u127f\u129b" },
            { "brx", "\u1266\u12f6" },
            { "kde", "\u121b\u12ae\u1295\u12f4" },
            { "001", "\u12d3\u1208\u121d" },
            { "Ethi", "\u12a2\u1275\u12ee\u1352\u12ad" },
            { "002", "\u12a0\u134d\u122a\u12ab" },
            { "njo", "\u12a6 \u1293\u130b" },
            { "003", "\u1230\u121c\u1295 \u12a0\u121c\u122a\u12ab" },
            { "RE", "\u122a\u12e9\u1292\u12e8\u1295" },
            { "005", "\u12f0\u1261\u1265 \u12a0\u121c\u122a\u12ab" },
            { "009", "\u12a6\u123d\u1292\u12a0" },
            { "rm", "\u122e\u121b\u1295\u123d" },
            { "rn", "\u1229\u1295\u12f2\u129b" },
            { "RO", "\u122e\u121c\u1292\u12eb" },
            { "ro", "\u122e\u121b\u1292\u12eb\u1295" },
            { "RS", "\u1230\u122d\u1265\u12eb" },
            { "RU", "\u122b\u123d\u12eb" },
            { "ru", "\u122b\u123d\u12eb\u129b" },
            { "bss", "\u12a0\u12ae\u1235" },
            { "RW", "\u1229\u12cb\u1295\u12f3" },
            { "rw", "\u12aa\u1295\u12eb\u122d\u12cb\u1295\u12f5\u129b" },
            { "zbl", "\u1265\u120a\u1235\u12ed\u121d\u1266\u120d\u1235" },
            { "kea", "\u12ab\u1261\u1268\u122d\u12f2\u12eb\u1291" },
            { "en_AU", "\u12e8\u12a0\u12cd\u1235\u1275\u122b\u120a\u12eb \u12a5\u1295\u130d\u120a\u12dd\u129b" },
            { "SA", "\u1233\u12cd\u12f5\u12a0\u1228\u1262\u12eb" },
            { "sa", "\u1233\u1295\u1235\u12ad\u122a\u1275\u129b" },
            { "SB", "\u1230\u120e\u121e\u1295 \u12f0\u1234\u1275" },
            { "twq", "\u1273\u1233\u12cb\u1245" },
            { "011", "\u121d\u1235\u122b\u1243\u12ca \u12a0\u134d\u122a\u12ab" },
            { "SC", "\u1232\u123c\u120d\u1235" },
            { "SD", "\u1231\u12f3\u1295" },
            { "sd", "\u1232\u1295\u12f5\u1202\u129b" },
            { "013", "\u1218\u12ab\u12a8\u1208\u129b\u12cd \u12a0\u121c\u122a\u12ab" },
            { "SE", "\u1235\u12ca\u12f5\u1295" },
            { "se", "\u1230\u121c\u1293\u12ca \u1233\u121a" },
            { "014", "\u121d\u12d5\u122b\u1263\u12ca \u12a0\u134d\u122a\u12ab" },
            { "arc", "\u12a0\u122b\u121b\u12ed\u12ad" },
            { "015", "\u1230\u121c\u1293\u12ca \u12a0\u134d\u122a\u12ab" },
            { "SG", "\u1232\u1295\u130b\u1356\u122d" },
            { "sg", "\u1233\u1295\u130e\u129b" },
            { "SH", "\u1234\u1295\u1275 \u1204\u1208\u1293" },
            { "017", "\u1218\u12ab\u12a8\u1208\u129b\u12cd \u12a0\u134d\u122a\u12ab" },
            { "SI", "\u1235\u120e\u126c\u1292\u12eb" },
            { "si", "\u1232\u1295\u1203\u120d\u129b" },
            { "018", "\u12f0\u1261\u1263\u12ca \u12a0\u134d\u122a\u12ab" },
            { "SJ", "\u1235\u126b\u120d\u1263\u122d\u12f5 \u12a5\u1293 \u1303\u1295 \u121b\u12e8\u1295" },
            { "019", "\u12a0\u121c\u122a\u12ab" },
            { "SK", "\u1235\u120e\u126b\u12aa\u12eb" },
            { "sk", "\u1235\u120e\u126b\u12ad\u129b" },
            { "SL", "\u1234\u122b\u120a\u12ee\u1295" },
            { "sl", "\u1235\u120e\u126a\u129b" },
            { "SM", "\u1233\u1295 \u121b\u122a\u1296" },
            { "sm", "\u1233\u121e\u12a0\u129b" },
            { "SN", "\u1234\u1294\u130b\u120d" },
            { "sn", "\u123e\u1293\u129b" },
            { "SO", "\u1231\u121b\u120c" },
            { "so", "\u1231\u121b\u120d\u129b" },
            { "arn", "\u121b\u1351\u127c" },
            { "sq", "\u120d\u1264\u1292\u129b" },
            { "arp", "\u12a0\u122b\u1353\u1206" },
            { "SR", "\u1231\u122a\u1293\u121d" },
            { "sr", "\u1230\u122d\u1262\u129b" },
            { "aro", "\u12a0\u122b\u12a6\u1293" },
            { "SS", "\u12f0\u1261\u1265 \u1231\u12f3\u1295" },
            { "ss", "\u1235\u12cb\u1272\u129b" },
            { "ST", "\u1233\u12a6 \u1276\u121c \u12a5\u1293 \u1355\u122a\u1295\u1232\u1354" },
            { "st", "\u1236\u12de\u129b" },
            { "arq", "\u12e8\u12a0\u120d\u1304\u122a\u12eb \u12d3\u1228\u1265\u129b" },
            { "su", "\u1231\u12f3\u1295\u129b" },
            { "SV", "\u12a4\u120d \u1233\u120d\u126b\u12f6\u122d" },
            { "sv", "\u1235\u12ca\u12f5\u1295\u129b" },
            { "sw", "\u1235\u12cb\u1202\u120a\u129b" },
            { "SX", "\u1232\u1295\u1275 \u121b\u122d\u1270\u1295" },
            { "SY", "\u1232\u122a\u12eb" },
            { "SZ", "\u1231\u12cb\u12da\u120b\u1295\u12f5" },
            { "arw", "\u12a0\u122b\u12cb\u12ad" },
            { "TA", "\u1275\u122a\u1235\u1273\u1295 \u12f2 \u12a9\u1295\u1203" },
            { "ta", "\u1273\u121a\u120d\u129b" },
            { "asa", "\u12a0\u1231" },
            { "021", "\u1230\u121c\u1293\u12ca \u12a0\u121c\u122a\u12ab" },
            { "142", "\u12a5\u1232\u12eb" },
            { "TC", "\u12e8\u1271\u122d\u12ae\u127d\u1293 \u12e8\u12ab\u12a2\u12ae\u1235 \u12f0\u1234\u1276\u127d" },
            { "bua", "\u1261\u122a\u12eb\u1275" },
            { "143", "\u1218\u12ab\u12a8\u1208\u129b\u12cd \u12a5\u1232\u12eb" },
            { "TD", "\u127b\u12f5" },
            { "te", "\u1270\u1209\u1309\u129b" },
            { "145", "\u121d\u1235\u122b\u1243\u12ca \u12a5\u1232\u12eb" },
            { "TF", "\u12e8\u1348\u1228\u1295\u1233\u12ed \u12f0\u1261\u1263\u12ca \u130d\u12db\u1276\u127d" },
            { "ase", "\u12e8\u12a0\u121c\u122a\u12ab \u12e8\u121d\u120d\u12ad\u1275 \u124b\u1295\u124b" },
            { "TG", "\u1276\u1310" },
            { "tg", "\u1273\u1302\u12aa\u129b" },
            { "TH", "\u1273\u12ed\u120b\u1295\u12f5" },
            { "th", "\u1273\u12ed\u129b" },
            { "ti", "\u1275\u130d\u122d\u129b" },
            { "bug", "\u1261\u130a\u1294\u12dd" },
            { "TJ", "\u1273\u1303\u12aa\u1235\u1273\u1295" },
            { "en_CA", "\u12e8\u12ab\u1293\u12f3 \u12a5\u1295\u130d\u120a\u12dd\u129b" },
            { "029", "\u12ab\u122a\u1262\u12eb\u1295" },
            { "TK", "\u1276\u12ad\u120b\u12cd" },
            { "tk", "\u1271\u122d\u12ad\u1218\u1295\u129b" },
            { "TL", "\u121d\u1235\u122b\u1245 \u120c\u1235\u1275" },
            { "tl", "\u1273\u130b\u120e\u1308\u129b" },
            { "TM", "\u1271\u122d\u12ad\u121c\u1292\u1235\u1273\u1295" },
            { "TN", "\u1271\u1292\u12da\u12eb" },
            { "tn", "\u133d\u12cb\u1293\u12ca\u129b" },
            { "TO", "\u1276\u1295\u130b" },
            { "to", "\u1276\u1295\u130b\u129b" },
            { "bum", "\u1261\u1209" },
            { "dyo", "\u1306\u120b \u134e\u1295\u12eb\u129b" },
            { "TR", "\u1271\u122d\u12ad" },
            { "tr", "\u1271\u122d\u12ad\u129b" },
            { "ts", "\u133e\u1295\u130b\u129b" },
            { "swb", "\u12ae\u121e\u122a\u12eb\u1295" },
            { "TT", "\u1275\u122a\u1293\u12f3\u12f5 \u12a5\u1293 \u1276\u1264\u130e" },
            { "tt", "\u1273\u1273\u122d\u129b" },
            { "dyu", "\u12f5\u12e9\u120b" },
            { "TV", "\u1271\u126b\u1209" },
            { "TW", "\u1273\u12ed\u12cb\u1295" },
            { "tw", "\u1275\u12ca\u129b" },
            { "ast", "\u12a0\u12cd\u1235\u1275\u122a\u12eb\u1295" },
            { "ty", "\u1273\u1202\u1273\u1295\u129b" },
            { "TZ", "\u1273\u1295\u12db\u1292\u12eb" },
            { "nmg", "\u12ad\u12cb\u1232\u12ee" },
            { "Zzzz", "\u12eb\u120d\u1273\u12c8\u1240 \u1235\u12ad\u122a\u1355\u1275" },
            { "150", "\u12a0\u12cd\u122e\u1353" },
            { "UA", "\u12e9\u12ad\u122c\u1295" },
            { "rup", "\u12a0\u122e\u121b\u1295\u12eb\u1295" },
            { "030", "\u121d\u12d5\u122b\u1263\u12ca \u12a5\u1232\u12eb" },
            { "151", "\u121d\u12d5\u122b\u1263\u12ca \u12a0\u12cd\u122e\u1353" },
            { "154", "\u1230\u121c\u1293\u12ca \u12a0\u12cd\u122e\u1353" },
            { "dzg", "\u12f3\u12db\u130b" },
            { "sw_CD", "\u12ae\u1295\u130e \u1235\u12cb\u1202\u120a" },
            { "034", "\u12f0\u1261\u1263\u12ca \u12a5\u1232\u12eb" },
            { "155", "\u121d\u1235\u122b\u1243\u12ca \u12a0\u12cd\u122e\u1353" },
            { "035", "\u121d\u12d5\u122b\u1263\u12ca \u12f0\u1261\u1265 \u12a5\u1232\u12eb" },
            { "UG", "\u12e9\u130b\u1295\u12f3" },
            { "ug", "\u12a1\u12ca\u130d\u1201\u122d\u129b" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u12e8\u130b\u122b" },
            { "039", "\u12f0\u1261\u1263\u12ca \u12a0\u12cd\u122e\u1353" },
            { "uk", "\u12e9\u12ad\u122c\u1295\u129b" },
            { "Sinh", "\u1232\u1295\u1203\u120b" },
            { "UM", "\u12e8\u12e9 \u12a4\u1235 \u1320\u1228\u134d \u120b\u12ed \u12eb\u1209 \u12f0\u1234\u1276\u127d" },
            { "ur", "\u12a1\u122d\u12f1\u129b" },
            { "US", "\u12e9\u1293\u12ed\u1275\u12f5 \u1235\u1274\u1275\u1235" },
            { "haw", "\u1203\u12ca\u12eb\u129b" },
            { "UY", "\u12a1\u122b\u1313\u12ed" },
            { "UZ", "\u12a1\u12dd\u1264\u12aa\u1235\u1273\u1295" },
            { "uz", "\u12a1\u12dd\u1264\u12ad\u129b" },
            { "tzm", "\u1218\u12ab\u12a8\u1208\u129b \u12a0\u1275\u120b\u1235 \u1273\u121b\u12da\u130d\u1275" },
            { "VA", "\u126b\u1272\u12ab\u1295 \u12a8\u1270\u121b" },
            { "nds_NL", "\u12e8\u1273\u127d\u129b\u12cd \u1233\u12ad\u1230\u1295" },
            { "VC", "\u1245\u12f1\u1235 \u126a\u1295\u1234\u1295\u1275 \u12a5\u1293 \u130d\u122c\u1293\u12f2\u1295\u1235" },
            { "VE", "\u126c\u1295\u12d9\u12cc\u120b" },
            { "ve", "\u126c\u1295\u12f3" },
            { "VG", "\u12e8\u12a5\u1295\u130d\u120a\u12dd \u1268\u122d\u1302\u1295 \u12f0\u1234\u1276\u127d" },
            { "VI", "\u12e8\u12a0\u121c\u122a\u12ab \u1268\u122d\u1302\u1295 \u12f0\u1234\u1276\u127d" },
            { "vi", "\u126a\u1275\u1293\u121d\u129b" },
            { "khq", "\u12ae\u12ed\u122b \u127a\u1292" },
            { "VN", "\u126c\u1275\u1293\u121d" },
            { "vo", "\u126e\u120b\u1351\u12ad\u129b" },
            { "syc", "\u12ad\u120b\u1232\u12ad \u1294\u12ed\u122b" },
            { "quc", "\u12aa\u127c" },
            { "VU", "\u126b\u1291\u12a0\u1271" },
            { "qug", "\u127a\u121d\u1266\u122b\u12de \u1203\u12ed\u120b\u1295\u12f5 \u12a9\u1279\u12cb" },
            { "gaa", "\u130b" },
            { "rwk", "\u122d\u12cb" },
            { "gag", "\u130b\u1309\u12dd\u129b" },
            { "053", "\u12a0\u12cd\u1235\u1275\u122b\u120a\u12eb" },
            { "054", "\u121c\u120b\u1294\u12e5\u12eb" },
            { "WF", "\u12cb\u120a\u1235 \u12a5\u1293 \u1349\u1271\u1293 \u12f0\u1234\u1276\u127d" },
            { "Grek", metaValue_GR },
            { "057", "\u12e8\u121b\u12ed\u12ad\u122e\u1294\u12e5\u12eb\u1295 \u12ad\u120d\u120d" },
            { "jgo", "\u1295\u130e\u1263\u129b" },
            { "lkt", "\u120b\u12ae\u1273" },
            { "wo", "\u12ce\u120e\u134d\u129b" },
            { "zgh", "\u1218\u12f0\u1260\u129b \u12e8\u121e\u122e\u12ae \u1273\u121b\u12da\u130d\u1275" },
            { "ar_001", "\u12d8\u1218\u1293\u12ca \u1218\u12f0\u1260\u129b \u12d3\u1228\u1265\u129b" },
            { "WS", "\u1233\u121e\u12a0" },
            { "Mong", "\u121e\u1295\u130e\u120a\u12eb\u129b" },
            { "awa", "\u12a0\u12cb\u12f5\u1202" },
            { "061", "\u1356\u120a\u1294\u12e5\u12eb" },
            { "Latn", "\u120b\u1272\u1295" },
            { "xh", "\u12de\u1233\u129b" },
            { "XK", "\u12ae\u1236\u126e" },
            { "Gujr", "\u1309\u1303\u122b\u1272" },
            { "Zxxx", "\u12eb\u120d\u1270\u133b\u1348" },
            { "byn", "\u1265\u120a\u1295" },
            { "wbp", "\u12cb\u122d\u120d\u1352\u122a" },
            { "moh", "\u121e\u1203\u12cd\u12ad" },
            { "YE", "\u12e8\u1218\u1295" },
            { "nqo", "\u1295\u12ae" },
            { "yi", "\u12ed\u12f2\u123d\u129b" },
            { "yo", "\u12ee\u1229\u1263\u12ca\u129b" },
            { "es_MX", "\u12e8\u121c\u12ad\u1232\u12ae \u1235\u1353\u1295\u123d\u129b" },
            { "YT", "\u121c\u12ed\u12a6\u1274" },
            { "vai", "\u126b\u12ed" },
            { "ZA", "\u12f0\u1261\u1265 \u12a0\u134d\u122a\u12ab" },
            { "za", "\u12e1\u12cb\u1295\u130d\u129b" },
            { "kln", "\u12ab\u1208\u1295\u1302\u1295" },
            { "Deva", "\u12f0\u126b\u1295\u130b\u122a" },
            { "zh", "\u127b\u12ed\u1295\u129b" },
            { "Hira", "\u1202\u122b\u130b\u1293" },
            { "ZM", "\u12db\u121d\u1262\u12eb" },
            { "Bopo", "\u1266\u1356\u121e\u134e" },
            { "zu", "\u12d9\u1209\u129b" },
            { "ZW", "\u12da\u121d\u1267\u1264" },
            { "ZZ", "\u12eb\u120d\u1273\u12c8\u1240 \u12ad\u120d\u120d" },
            { "Geor", "\u1306\u122d\u1302\u12eb\u12ca" },
            { "nso", "\u1230\u121c\u1293\u12ca \u1236\u1276" },
            { "loz", "\u120e\u12da\u129b" },
            { "gez", "\u130d\u12d5\u12dd\u129b" },
            { "ebu", "\u12a2\u1266\u129b" },
            { "jmc", "\u121b\u127b\u121c\u129b" },
            { "zh_Hans", "\u1240\u1208\u120d \u12eb\u1208 \u127b\u12ed\u1295\u129b" },
            { "koi", "\u12ae\u121a \u1354\u122d\u121d\u12eb\u12ad" },
            { "kok", "\u12ae\u12ab\u1292" },
            { "nus", "\u1291\u12cc\u122d" },
            { "dak", "\u12f3\u12ae\u1273" },
            { "dar", "\u12f3\u122d\u130d\u12cb" },
            { "dav", "\u1273\u12ed\u1273\u129b" },
            { "lrc", "\u1230\u121c\u1293\u12ca \u1209\u122a" },
            { "zh_Hant", "\u1263\u1205\u120b\u12ca \u127b\u12ed\u1295\u129b" },
            { "mua", "\u1219\u1295\u12f3\u1295\u130d" },
            { "nwc", "\u12ad\u120b\u1232\u12ad \u1294\u12cb\u122a" },
            { "Khmr", "\u12ad\u1205\u1218\u122d" },
            { "cad", "\u12ab\u12f6" },
            { "mus", "\u12ad\u122a\u12ad" },
            { "car", "\u12ab\u122a\u1265" },
            { "cay", "\u12ab\u12e9\u130b" },
            { "saq", "\u1233\u121d\u1261\u1229" },
            { "efi", "\u12a4\u134a\u12ad" },
            { "Guru", "\u1309\u122d\u1219\u12aa" },
            { "lua", "\u1209\u1263-\u1209\u120f" },
            { "ksb", "\u123b\u121d\u1263\u120b" },
            { "Telu", "\u1270\u1209\u1309" },
            { "ksf", "\u1263\u134a\u12eb" },
        };
        return data;
    }
}
