/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_af extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "Arabies";
        final String metaValue_bn = "Bengaals";
        final String metaValue_bo = "Tibettaans";
        final String metaValue_el = "Grieks";
        final String metaValue_he = "Hebreeus";
        final String metaValue_hy = "Armeens";
        final String metaValue_ja = "Japannees";
        final String metaValue_ka = "Georgies";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Koreaans";
        final String metaValue_la = "Latyn";
        final String metaValue_lo = "Lao";
        final String metaValue_ml = "Malabaars";
        final String metaValue_mn = "Mongools";
        final String metaValue_or = "Oriya";
        final String metaValue_si = "Sinhala";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Teloegoe";
        final String metaValue_th = "Thai";
        final Object[][] data = new Object[][] {
            { "sbp", "Sangu" },
            { "nyn", "Nyankole" },
            { "luo", "Luo" },
            { "Zsym", "Simbole" },
            { "fil", "Filippyns" },
            { "luy", "Luyia" },
            { "egy", "Antieke Egipties" },
            { "teo", "Teso" },
            { "ab", "Abkasies" },
            { "AC", "Ascensioneiland" },
            { "tet", "Tetum" },
            { "AD", "Andorra" },
            { "AE", "Verenigde Arabiese Emirate" },
            { "nl_BE", "Vlaams" },
            { "AF", "Afganistan" },
            { "af", "Afrikaans" },
            { "AG", "Antigua en Barbuda" },
            { "AI", "Anguilla" },
            { "ak", "Akan" },
            { "AL", "Albani\u00eb" },
            { "AM", "Armeni\u00eb" },
            { "am", "Amharies" },
            { "Arab", metaValue_ar },
            { "AO", "Angola" },
            { "Jpan", metaValue_ja },
            { "AQ", "Antarktika" },
            { "ar", metaValue_ar },
            { "AR", "Argentini\u00eb" },
            { "AS", "Amerikaans-Samoa" },
            { "as", "Assamees" },
            { "AT", "Oostenryk" },
            { "AU", "Australi\u00eb" },
            { "AW", "Aruba" },
            { "sdh", "Suid-Koerdies" },
            { "AX", "\u00c5landeilande" },
            { "ay", "Aymara" },
            { "AZ", "Azerbeidjan" },
            { "az", "Azerbeidjans" },
            { "BA", "Bosni\u00eb en Herzegowina" },
            { "ba", "Baskir" },
            { "BB", "Barbados" },
            { "BD", "Bangladesj" },
            { "BE", "Belgi\u00eb" },
            { "be", "Belo-Russies" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarye" },
            { "bg", "Bulgaars" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "BN", "Broenei" },
            { "bo", metaValue_bo },
            { "BO", "Bolivi\u00eb" },
            { "BQ", "Karibiese Nederland" },
            { "BR", "Brasili\u00eb" },
            { "br", "Bretons" },
            { "BS", "Bahamas" },
            { "bs", "Bosnies" },
            { "xog", "Soga" },
            { "BT", "Bhoetan" },
            { "BV", "Bouvet-eiland" },
            { "BW", "Botswana" },
            { "Mymr", "Mianmar" },
            { "BY", "Belarus" },
            { "seh", "Sena" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "ca", "Katalaans" },
            { "CC", "Kokos-eilande" },
            { "mzn", "Masanderani" },
            { "ses", "Koyraboro Senni" },
            { "CD", "Demokratiese Republiek van die Kongo" },
            { "ce", "Tsjetsjen" },
            { "CF", "Sentraal-Afrikaanse Republiek" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "Switserland" },
            { "CI", "Ivoorkus" },
            { "CK", "Cookeilande" },
            { "CL", "Chili" },
            { "CM", "Kameroen" },
            { "CN", "Sjina" },
            { "CO", "Colombi\u00eb" },
            { "co", "Korsikaans" },
            { "CP", "Clippertoneiland" },
            { "Orya", metaValue_or },
            { "CR", "Costa Rica" },
            { "cs", "Tsjeggies" },
            { "CU", "Kuba" },
            { "CV", "Kaap Verde" },
            { "cv", "Chuvash" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Kerseiland" },
            { "CY", "Siprus" },
            { "cy", "Wallies" },
            { "CZ", "Tjeggiese Republiek" },
            { "da", "Deens" },
            { "DE", "Duitsland" },
            { "de", "Duits" },
            { "cgg", "Sjiga" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djiboeti" },
            { "DK", "Denemarke" },
            { "ach", "Akoli" },
            { "Brai", "Braille" },
            { "DM", "Dominica" },
            { "DO", "Dominikaanse Republiek" },
            { "bem", "Bemba" },
            { "got", "Goties" },
            { "dv", "Divehi" },
            { "DZ", "Algeri\u00eb" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "EA", "Ceuta en Melilla" },
            { "EC", "Ecuador" },
            { "dje", "Zarma" },
            { "EE", "Estland" },
            { "ee", "Ewe" },
            { "EG", "Egipte" },
            { "EH", "Wes-Sahara" },
            { "ro_MD", "Moldawies" },
            { "el", metaValue_el },
            { "en", "Engels" },
            { "eo", "Esperanto" },
            { "chr", "Cherokees" },
            { "ER", "Eritrea" },
            { "ES", "Spanje" },
            { "es", "Spaans" },
            { "ET", "Ethiopi\u00eb" },
            { "et", "Estnies" },
            { "EU", "Europese Unie" },
            { "eu", "Baskies" },
            { "Hang", "Hangul" },
            { "shi", "Tachelhit" },
            { "hsb", "Hoog-Sorbies" },
            { "Hani", "Han" },
            { "fa", "Persies" },
            { "Hans", "Vereenvoudig" },
            { "Hant", "Tradisioneel" },
            { "FI", "Finland" },
            { "fi", "Fins" },
            { "FJ", "Fidji" },
            { "fj", "Fidjiaans" },
            { "FK", "Falklandeilande" },
            { "FM", "Mikronesi\u00eb" },
            { "bgn", "Wes-Balochi" },
            { "FO", "Faro\u00ebreilande" },
            { "fo", "Faroees" },
            { "Taml", metaValue_ta },
            { "FR", "Frankryk" },
            { "fr", "Frans" },
            { "fy", "Wes-Fries" },
            { "grc", "Antieke Grieks" },
            { "GA", "Gaboen" },
            { "ga", "Iers" },
            { "GB", "Verenigde Koninkryk" },
            { "GD", "Grenada" },
            { "gd", "Skotse Gallies" },
            { "GE", "Georgi\u00eb" },
            { "GF", "Frans-Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenland" },
            { "gl", "Galisies" },
            { "GM", "Gambi\u00eb" },
            { "GN", "Guinee" },
            { "gn", "Guarani" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekwatoriaal-Guinee" },
            { "und", "Onbekende of ongeldige taal" },
            { "GR", "Griekeland" },
            { "GS", "Suid-Georgi\u00eb en die Suidelike Sandwicheilande" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "gu", "Goedjarati" },
            { "gv", "Manx" },
            { "GW", "Guinee-Bissau" },
            { "tlh", "Klingon" },
            { "GY", "Guyana" },
            { "ha", "Hausa" },
            { "ckb", "Sorani Koerdies" },
            { "zxx", "Geen linguistiese inhoud" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "HK", "Hongkong SAS Sjina" },
            { "HM", "Heard- en McDonaldeilande" },
            { "HN", "Honduras" },
            { "HR", "Kroasi\u00eb" },
            { "hr", "Kroaties" },
            { "agq", "Aghem" },
            { "gsw", "Switserse Duits" },
            { "HT", "Ha\u00efti" },
            { "ht", "Ha\u00eftiaans" },
            { "HU", "Hongarye" },
            { "hu", "Hongaars" },
            { "hy", metaValue_hy },
            { "ia", "Interlingua" },
            { "IC", "Kanariese Eilande" },
            { "ID", "Indonesi\u00eb" },
            { "id", "Indonesies" },
            { "IE", "Ierland" },
            { "ig", "Igbo" },
            { "naq", "Nama" },
            { "ii", "Sichuan Yi" },
            { "IL", "Israel" },
            { "IM", "Eiland Man" },
            { "IN", "Indi\u00eb" },
            { "IO", "Brits-Indiese Oseaangebied" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Ysland" },
            { "is", "Yslands" },
            { "IT", "Itali\u00eb" },
            { "it", "Italiaans" },
            { "iu", "Innu\u00efties" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "JE", "Jersey" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaika" },
            { "JO", "Jordani\u00eb" },
            { "JP", "Japan" },
            { "sma", "Suid-Sami" },
            { "jv", "Javaans" },
            { "guz", "Gusii" },
            { "smj", "Lule Sami" },
            { "de_CH", "Switserse hoog-Duits" },
            { "smn", "Inari Sami" },
            { "ka", metaValue_ka },
            { "sms", "Skolt Sami" },
            { "KE", "Kenia" },
            { "419", "Latyns-Amerika" },
            { "KG", "Kirgisi\u00eb" },
            { "kg", "Kongolees" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "ki", "Kikuyu" },
            { "mas", "Masai" },
            { "kk", "Kazaks" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "KM", "Comore" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "St. Kitts en Nevis" },
            { "ko", metaValue_ko },
            { "KP", "Noord-Korea" },
            { "KR", "Suid-Korea" },
            { "ks", "Kasjmirs" },
            { "ku", "Koerdies" },
            { "KW", "Koeweit" },
            { "kw", "Kornies" },
            { "tpi", "Tok Pisin" },
            { "KY", "Kaaimanseilande" },
            { "ky", "Kirgisies" },
            { "KZ", "Kazakstan" },
            { "Cyrl", "Sirillies" },
            { "la", metaValue_la },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "lb", "Luxemburgs" },
            { "LC", "St. Lucia" },
            { "lg", "Ganda" },
            { "nds", "Lae Duits" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingaals" },
            { "lo", metaValue_lo },
            { "LR", "Liberi\u00eb" },
            { "LS", "Lesotho" },
            { "LT", "Litaue" },
            { "lt", "Litaus" },
            { "LU", "Luxemburg" },
            { "lu", "Luba-Katanga" },
            { "LV", "Letland" },
            { "lv", "Letties" },
            { "Kana", "Katakana" },
            { "LY", "Libi\u00eb" },
            { "vun", "Vunjo" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldowa" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagaskar" },
            { "mg", "Malgassies" },
            { "Thai", metaValue_th },
            { "MH", "Marshalleilande" },
            { "mi", "Maori" },
            { "MK", "Macedoni\u00eb" },
            { "mk", "Masedonies" },
            { "ml", metaValue_ml },
            { "ML", "Mali" },
            { "MM", "Mianmar (Birma)" },
            { "mn", metaValue_mn },
            { "MN", "Mongoli\u00eb" },
            { "MO", "Macau SAS Sjina" },
            { "MP", "Noord-Mariane-eilande" },
            { "MQ", "Martinique" },
            { "MR", "Mauritani\u00eb" },
            { "mr", "Marathi" },
            { "MS", "Montserrat" },
            { "ms", "Maleis" },
            { "MT", "Malta" },
            { "mt", "Maltees" },
            { "MU", "Mauritius" },
            { "MV", "Maledive" },
            { "MW", "Malawi" },
            { "MX", "Meksiko" },
            { "MY", "Maleisi\u00eb" },
            { "my", "Birmaans" },
            { "Armn", metaValue_hy },
            { "MZ", "Mosambiek" },
            { "dsb", "Lae Sorbies" },
            { "NA", "Namibi\u00eb" },
            { "nb", "Noorse Bokm\u00e5l" },
            { "NC", "Nieu-Kaledoni\u00eb" },
            { "nd", "Noord-Ndebele" },
            { "NE", "Niger" },
            { "ne", "Nepalees" },
            { "NF", "Norfolkeiland" },
            { "NG", "Nigeri\u00eb" },
            { "NI", "Nicaragua" },
            { "NL", "Nederland" },
            { "nl", "Nederlands" },
            { "nn", "Noorweegse Nynorsk" },
            { "NO", "Noorwe\u00eb" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "nr", "Suid-Ndebele" },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "ny", "Nyanja" },
            { "NZ", "Nieu-Seeland" },
            { "kab", "Kabyle" },
            { "oc", "Oksitaans" },
            { "kam", "Kamba" },
            { "mer", "Meru" },
            { "OM", "Oman" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "os", "Osseties" },
            { "mfe", "Morisjen" },
            { "PA", "Panama" },
            { "pa", "Pandjabi" },
            { "dua", "Duala" },
            { "PE", "Peru" },
            { "PF", "Frans-Polinesi\u00eb" },
            { "PG", "Papoea-Nieu-Guinee" },
            { "PH", "Filippyne" },
            { "PK", "Pakistan" },
            { "PL", "Pole" },
            { "pl", "Pools" },
            { "PM", "St. Pierre en Miquelon" },
            { "PN", "Pitcairneilande" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestynse gebiede" },
            { "ps", "Pasjto" },
            { "PT", "Portugal" },
            { "pt", "Portugees" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "tum", "Toemboeka" },
            { "Hebr", metaValue_he },
            { "mgh", "Makhuwa-Meetto" },
            { "QA", "Katar" },
            { "Laoo", metaValue_lo },
            { "mgo", "Meta\u2019" },
            { "QO", "Omliggende Oseani\u00eb" },
            { "qu", "Quechua" },
            { "brx", "Bodo" },
            { "kde", "Makonde" },
            { "001", "W\u00eareld" },
            { "Ethi", "Etiopies" },
            { "002", "Afrika" },
            { "003", "Noord-Amerika" },
            { "RE", "R\u00e9union" },
            { "005", "Suid-Amerika" },
            { "009", "Oseani\u00eb" },
            { "rm", "Reto-Romaans" },
            { "rn", "Rundi" },
            { "RO", "Roemeni\u00eb" },
            { "ro", "Roemeens" },
            { "RS", "Serwi\u00eb" },
            { "RU", "Rusland" },
            { "ru", "Russies" },
            { "RW", "Rwanda" },
            { "rw", "Rwandees" },
            { "kea", "Kabuverdianu" },
            { "SA", "Saoedi-Arabi\u00eb" },
            { "sa", "Sanskrit" },
            { "SB", "Salomonseilande" },
            { "twq", "Tasawaq" },
            { "011", "Wes-Afrika" },
            { "SC", "Seychelle" },
            { "SD", "Soedan" },
            { "sd", "Sindhi" },
            { "013", "Sentraal-Amerika" },
            { "SE", "Swede" },
            { "se", "Noord-Sami" },
            { "014", "Oos-Afrika" },
            { "arc", "Aramees" },
            { "015", "Noord-Afrika" },
            { "SG", "Singapoer" },
            { "sg", "Sango" },
            { "SH", "Sint Helena" },
            { "si", metaValue_si },
            { "017", "Midde-Afrika" },
            { "SI", "Sloweni\u00eb" },
            { "018", "Suider-Afrika" },
            { "SJ", "Svalbard en Jan Mayen" },
            { "019", "Amerikas" },
            { "SK", "Slowakye" },
            { "sk", "Slowaaks" },
            { "SL", "Sierra Leone" },
            { "sl", "Sloweens" },
            { "SM", "San Marino" },
            { "sm", "Samoaans" },
            { "SN", "Senegal" },
            { "sn", "Shona" },
            { "SO", "Somali\u00eb" },
            { "so", "Somalies" },
            { "arn", "Mapuche" },
            { "sq", "Albanees" },
            { "SR", "Suriname" },
            { "sr", "Serwies" },
            { "SS", "Suid-Soedan" },
            { "ss", "Swazi" },
            { "ST", "S\u00e3o Tom\u00e9 en Pr\u00edncipe" },
            { "st", "Suid-Sotho" },
            { "su", "Sundanees" },
            { "SV", "El Salvador" },
            { "sv", "Sweeds" },
            { "sw", "Swahili" },
            { "SX", "Sint Maarten" },
            { "SY", "Siri\u00eb" },
            { "SZ", "Swaziland" },
            { "ta", metaValue_ta },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "021", "Noordelike Amerika" },
            { "142", "Asi\u00eb" },
            { "TC", "Turks- en Caicoseilande" },
            { "143", "Sentraal-Asi\u00eb" },
            { "TD", "Tsjad" },
            { "te", metaValue_te },
            { "145", "Wes-Asi\u00eb" },
            { "TF", "Franse Suidelike Gebiede" },
            { "TG", "Togo" },
            { "tg", "Tadzjieks" },
            { "th", metaValue_th },
            { "TH", "Thailand" },
            { "ti", "Tigrinya" },
            { "TJ", "Tadjikistan" },
            { "029", "Karibies" },
            { "TK", "Tokelau" },
            { "tk", "Turkmeens" },
            { "TL", "Oos-Timor" },
            { "TM", "Turkmeni\u00eb" },
            { "TN", "Tunisi\u00eb" },
            { "tn", "Tswana" },
            { "TO", "Tonga" },
            { "to", "Tongaans" },
            { "dyo", "Jola-Fonyi" },
            { "TR", "Turkye" },
            { "tr", "Turks" },
            { "ts", "Tsonga" },
            { "TT", "Trinidad en Tobago" },
            { "tt", "Tataars" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ty", "Tahities" },
            { "TZ", "Tanzani\u00eb" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Onbekende skryfstelsel" },
            { "150", "Europa" },
            { "UA", "Oekra\u00efne" },
            { "030", "Oos-Asi\u00eb" },
            { "151", "Oos-Europa" },
            { "154", "Noord-Europa" },
            { "sw_CD", "Swahili (Kongo)" },
            { "034", "Suid-Asi\u00eb" },
            { "155", "Wes-Europa" },
            { "035", "Suidoos-Asi\u00eb" },
            { "UG", "Uganda" },
            { "ug", "Uighur" },
            { "Kore", metaValue_ko },
            { "Zyyy", "Algemeen" },
            { "039", "Suid-Europa" },
            { "uk", "Oekra\u00efens" },
            { "Sinh", metaValue_si },
            { "UM", "VS klein omliggende eilande" },
            { "ur", "Oerdoe" },
            { "US", "Verenigde State van Amerika" },
            { "haw", "Hawaiies" },
            { "UY", "Uruguay" },
            { "UZ", "Oesbekistan" },
            { "uz", "Oezbeeks" },
            { "tzm", "Sentraal Atlas Tamazight" },
            { "VA", "Vatikaanstad" },
            { "nds_NL", "Nedersaksies" },
            { "VC", "St. Vincent en die Grenadine" },
            { "VE", "Venezuela" },
            { "ve", "Venda" },
            { "VG", "Britse Maagde-eilande" },
            { "VI", "Amerikaanse Maagde-eilande" },
            { "vi", "Vi\u00ebtnamees" },
            { "khq", "Koyra Chiini" },
            { "VN", "Vi\u00ebtnam" },
            { "quc", "K\u2019iche\u2019" },
            { "VU", "Vanuatu" },
            { "gaa", "Gaa" },
            { "rwk", "Rwa" },
            { "gag", "Gagauz" },
            { "053", "Australasi\u00eb" },
            { "054", "Melanesi\u00eb" },
            { "WF", "Wallis en Futuna" },
            { "Grek", metaValue_el },
            { "057", "Mikronesiese streek" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "wo", "Wolof" },
            { "zgh", "Standaard Marokkaanse Tamazight" },
            { "ar_001", "Moderne Standaard Arabies" },
            { "WS", "Samoa" },
            { "Mong", metaValue_mn },
            { "Latn", metaValue_la },
            { "061", "Polinesi\u00eb" },
            { "xh", "Xhosa" },
            { "XK", "Kosovo" },
            { "Gujr", "Gudjarati" },
            { "Zxxx", "Ongeskrewe" },
            { "wbp", "Warlpiri" },
            { "moh", "Mohawk" },
            { "YE", "Jemen" },
            { "nqo", "N\u2019Ko" },
            { "yi", "Jiddisj" },
            { "yo", "Yoruba" },
            { "YT", "Mayotte" },
            { "vai", "Vai" },
            { "ZA", "Suid-Afrika" },
            { "kln", "Kalenjin" },
            { "Deva", "Devanagari" },
            { "zh", "Sjinees" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambi\u00eb" },
            { "Bopo", "Bopomofo" },
            { "zu", "Zoeloe" },
            { "ZW", "Zimbabwe" },
            { "Geor", metaValue_ka },
            { "ZZ", "Onbekende gebied" },
            { "nso", "Noord-Sotho" },
            { "loz", "Lozi" },
            { "ebu", "Embu" },
            { "jmc", "Machame" },
            { "koi", "Komi-Permyaks" },
            { "kok", "Konkani" },
            { "nus", "Nuer" },
            { "dav", "Taita" },
            { "lrc", "Noord-Luri" },
            { "mua", "Mundang" },
            { "Khmr", metaValue_km },
            { "mul", "Veelvuldige tale" },
            { "saq", "Samburu" },
            { "efi", "Efik" },
            { "Guru", "Gurmukhi" },
            { "lua", "Luba-Lulua" },
            { "ksb", "Shambala" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
