/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.InterruptedByTimeoutException;
import java.nio.channels.ShutdownChannelGroupException;
import java.security.AccessController;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import sun.net.NetHooks;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.AsynchronousSocketChannelImpl;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Invoker;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.Net;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.Port;
import sun.nio.ch.SocketDispatcher;
import sun.security.action.GetPropertyAction;

class UnixAsynchronousSocketChannelImpl
extends AsynchronousSocketChannelImpl
implements Port.PollableChannel {
    private static final NativeDispatcher nd = new SocketDispatcher();
    private static final boolean disableSynchronousRead;
    private final Port port;
    private final int fdVal;
    private final Object updateLock = new Object();
    private boolean connectPending;
    private CompletionHandler<Void, Object> connectHandler;
    private Object connectAttachment;
    private PendingFuture<Void, Object> connectFuture;
    private SocketAddress pendingRemote;
    private boolean readPending;
    private boolean isScatteringRead;
    private ByteBuffer readBuffer;
    private ByteBuffer[] readBuffers;
    private CompletionHandler<Number, Object> readHandler;
    private Object readAttachment;
    private PendingFuture<Number, Object> readFuture;
    private Future<?> readTimer;
    private boolean writePending;
    private boolean isGatheringWrite;
    private ByteBuffer writeBuffer;
    private ByteBuffer[] writeBuffers;
    private CompletionHandler<Number, Object> writeHandler;
    private Object writeAttachment;
    private PendingFuture<Number, Object> writeFuture;
    private Future<?> writeTimer;
    private Runnable readTimeoutTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CompletionHandler completionHandler = null;
            Object object = null;
            PendingFuture pendingFuture = null;
            Object object2 = UnixAsynchronousSocketChannelImpl.this.updateLock;
            synchronized (object2) {
                if (!UnixAsynchronousSocketChannelImpl.this.readPending) {
                    return;
                }
                UnixAsynchronousSocketChannelImpl.this.readPending = false;
                completionHandler = UnixAsynchronousSocketChannelImpl.this.readHandler;
                object = UnixAsynchronousSocketChannelImpl.this.readAttachment;
                pendingFuture = UnixAsynchronousSocketChannelImpl.this.readFuture;
            }
            UnixAsynchronousSocketChannelImpl.this.enableReading(true);
            object2 = new InterruptedByTimeoutException();
            if (completionHandler == null) {
                pendingFuture.setFailure((Throwable)object2);
            } else {
                UnixAsynchronousSocketChannelImpl unixAsynchronousSocketChannelImpl = UnixAsynchronousSocketChannelImpl.this;
                Invoker.invokeIndirectly(unixAsynchronousSocketChannelImpl, completionHandler, object, null, (Throwable)object2);
            }
        }
    };
    private Runnable writeTimeoutTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CompletionHandler completionHandler = null;
            Object object = null;
            PendingFuture pendingFuture = null;
            Object object2 = UnixAsynchronousSocketChannelImpl.this.updateLock;
            synchronized (object2) {
                if (!UnixAsynchronousSocketChannelImpl.this.writePending) {
                    return;
                }
                UnixAsynchronousSocketChannelImpl.this.writePending = false;
                completionHandler = UnixAsynchronousSocketChannelImpl.this.writeHandler;
                object = UnixAsynchronousSocketChannelImpl.this.writeAttachment;
                pendingFuture = UnixAsynchronousSocketChannelImpl.this.writeFuture;
            }
            UnixAsynchronousSocketChannelImpl.this.enableWriting(true);
            object2 = new InterruptedByTimeoutException();
            if (completionHandler != null) {
                Invoker.invokeIndirectly(UnixAsynchronousSocketChannelImpl.this, completionHandler, object, null, (Throwable)object2);
            } else {
                pendingFuture.setFailure((Throwable)object2);
            }
        }
    };

    UnixAsynchronousSocketChannelImpl(Port port) throws IOException {
        super(port);
        try {
            IOUtil.configureBlocking(this.fd, false);
        }
        catch (IOException iOException) {
            nd.close(this.fd);
            throw iOException;
        }
        this.port = port;
        this.fdVal = IOUtil.fdVal(this.fd);
        port.register(this.fdVal, this);
    }

    UnixAsynchronousSocketChannelImpl(Port port, FileDescriptor fileDescriptor, InetSocketAddress inetSocketAddress) throws IOException {
        super(port, fileDescriptor, inetSocketAddress);
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        IOUtil.configureBlocking(fileDescriptor, false);
        try {
            port.register(this.fdVal, this);
        }
        catch (ShutdownChannelGroupException shutdownChannelGroupException) {
            throw new IOException(shutdownChannelGroupException);
        }
        this.port = port;
    }

    @Override
    public AsynchronousChannelGroupImpl group() {
        return this.port;
    }

    private void updateEvents() {
        assert (Thread.holdsLock(this.updateLock));
        int n = 0;
        if (this.readPending) {
            n |= Net.POLLIN;
        }
        if (this.connectPending || this.writePending) {
            n |= Net.POLLOUT;
        }
        if (n != 0) {
            this.port.startPoll(this.fdVal, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockAndUpdateEvents() {
        Object object = this.updateLock;
        synchronized (object) {
            this.updateEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        Object object = this.updateLock;
        synchronized (object) {
            if (bl2 && this.readPending) {
                this.readPending = false;
                bl4 = true;
            }
            if (bl3) {
                if (this.writePending) {
                    this.writePending = false;
                    bl5 = true;
                } else if (this.connectPending) {
                    this.connectPending = false;
                    bl6 = true;
                }
            }
        }
        if (bl4) {
            if (bl5) {
                this.finishWrite(false);
            }
            this.finishRead(bl);
            return;
        }
        if (bl5) {
            this.finishWrite(bl);
        }
        if (bl6) {
            this.finishConnect(bl);
        }
    }

    @Override
    public void onEvent(int n, boolean bl) {
        boolean bl2;
        boolean bl3 = (n & Net.POLLIN) > 0;
        boolean bl4 = bl2 = (n & Net.POLLOUT) > 0;
        if ((n & (Net.POLLERR | Net.POLLHUP)) > 0) {
            bl3 = true;
            bl2 = true;
        }
        this.finish(bl, bl3, bl2);
    }

    @Override
    void implClose() throws IOException {
        this.port.unregister(this.fdVal);
        nd.close(this.fd);
        this.finish(false, true, true);
    }

    @Override
    public void onCancel(PendingFuture<?, ?> pendingFuture) {
        if (pendingFuture.getContext() == OpType.CONNECT) {
            this.killConnect();
        }
        if (pendingFuture.getContext() == OpType.READ) {
            this.killReading();
        }
        if (pendingFuture.getContext() == OpType.WRITE) {
            this.killWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.state = 2;
            this.localAddress = Net.localAddress(this.fd);
            this.remoteAddress = (InetSocketAddress)this.pendingRemote;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishConnect(boolean bl) {
        Object object;
        Throwable throwable = null;
        try {
            this.begin();
            UnixAsynchronousSocketChannelImpl.checkConnect(this.fdVal);
            this.setConnected();
        }
        catch (Throwable throwable2) {
            if (throwable2 instanceof ClosedChannelException) {
                object = new AsynchronousCloseException();
            }
            throwable = object;
        }
        finally {
            this.end();
        }
        if (throwable != null) {
            try {
                this.close();
            }
            catch (Throwable throwable3) {
                throwable.addSuppressed(throwable3);
            }
        }
        object = this.connectHandler;
        Object object2 = this.connectAttachment;
        PendingFuture<Void, Object> pendingFuture = this.connectFuture;
        if (object == null) {
            pendingFuture.setResult(null, throwable);
        } else if (bl) {
            Invoker.invokeUnchecked(object, object2, null, throwable);
        } else {
            Invoker.invokeIndirectly(this, object, object2, null, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <A> Future<Void> implConnect(SocketAddress socketAddress, A a, CompletionHandler<Void, ? super A> completionHandler) {
        boolean bl;
        if (!this.isOpen()) {
            ClosedChannelException closedChannelException = new ClosedChannelException();
            if (completionHandler == null) {
                return CompletedFuture.withFailure(closedChannelException);
            }
            Invoker.invoke(this, completionHandler, a, null, closedChannelException);
            return null;
        }
        InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                throw new AlreadyConnectedException();
            }
            if (this.state == 1) {
                throw new ConnectionPendingException();
            }
            this.state = 1;
            this.pendingRemote = socketAddress;
            bl = this.localAddress == null;
        }
        object = null;
        try {
            int n;
            this.begin();
            if (bl) {
                NetHooks.beforeTcpConnect(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            }
            if ((n = Net.connect(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort())) == -2) {
                PendingFuture pendingFuture = null;
                PendingFuture pendingFuture2 = this.updateLock;
                synchronized (pendingFuture2) {
                    if (completionHandler == null) {
                        pendingFuture = new PendingFuture(this, (Object)OpType.CONNECT);
                        this.connectFuture = pendingFuture;
                    } else {
                        this.connectHandler = completionHandler;
                        this.connectAttachment = a;
                    }
                    this.connectPending = true;
                    this.updateEvents();
                }
                pendingFuture2 = pendingFuture;
                return pendingFuture2;
            }
            this.setConnected();
        }
        catch (Throwable throwable) {
            AsynchronousCloseException asynchronousCloseException;
            if (throwable instanceof ClosedChannelException) {
                asynchronousCloseException = new AsynchronousCloseException();
            }
            object = asynchronousCloseException;
        }
        finally {
            this.end();
        }
        if (object != null) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
        }
        if (completionHandler == null) {
            return CompletedFuture.withResult(null, (Throwable)object);
        }
        Invoker.invoke(this, completionHandler, a, null, (Throwable)object);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRead(boolean bl) {
        AsynchronousCloseException asynchronousCloseException;
        int n = -1;
        Throwable throwable = null;
        boolean bl2 = this.isScatteringRead;
        CompletionHandler<Number, Object> completionHandler = this.readHandler;
        Object object = this.readAttachment;
        PendingFuture<Number, Object> pendingFuture = this.readFuture;
        Future<?> future = this.readTimer;
        try {
            this.begin();
            n = bl2 ? (int)IOUtil.read(this.fd, this.readBuffers, nd) : IOUtil.read(this.fd, this.readBuffer, -1L, nd);
            if (n == -2) {
                Object object2 = this.updateLock;
                synchronized (object2) {
                    this.readPending = true;
                }
                return;
            }
            this.readBuffer = null;
            this.readBuffers = null;
            this.readAttachment = null;
            this.enableReading();
        }
        catch (Throwable throwable2) {
            this.enableReading();
            if (throwable2 instanceof ClosedChannelException) {
                asynchronousCloseException = new AsynchronousCloseException();
            }
            throwable = asynchronousCloseException;
        }
        finally {
            if (!(throwable instanceof AsynchronousCloseException)) {
                this.lockAndUpdateEvents();
            }
            this.end();
        }
        if (future != null) {
            future.cancel(false);
        }
        Serializable serializable = throwable != null ? null : (asynchronousCloseException = bl2 ? (Number)Long.valueOf(n) : (Number)n);
        if (completionHandler == null) {
            pendingFuture.setResult((Number)((Object)asynchronousCloseException), throwable);
        } else if (bl) {
            Invoker.invokeUnchecked(completionHandler, object, asynchronousCloseException, throwable);
        } else {
            Invoker.invokeIndirectly(this, completionHandler, object, asynchronousCloseException, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <V extends Number, A> Future<V> implRead(boolean bl, ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, long l, TimeUnit timeUnit, A a, CompletionHandler<V, ? super A> completionHandler) {
        AsynchronousCloseException asynchronousCloseException;
        Throwable throwable;
        int n;
        boolean bl2;
        Invoker.GroupAndInvokeCount groupAndInvokeCount;
        block18: {
            groupAndInvokeCount = null;
            bl2 = false;
            boolean bl3 = false;
            if (!disableSynchronousRead) {
                bl3 = completionHandler == null ? true : (bl2 = Invoker.mayInvokeDirect(groupAndInvokeCount = Invoker.getGroupAndInvokeCount(), this.port)) || !this.port.isFixedThreadPool();
            }
            n = -2;
            throwable = null;
            boolean bl4 = false;
            try {
                this.begin();
                if (bl3) {
                    n = bl ? (int)IOUtil.read(this.fd, byteBufferArray, nd) : IOUtil.read(this.fd, byteBuffer, -1L, nd);
                }
                if (n != -2) break block18;
                PendingFuture pendingFuture = null;
                PendingFuture pendingFuture2 = this.updateLock;
                synchronized (pendingFuture2) {
                    this.isScatteringRead = bl;
                    this.readBuffer = byteBuffer;
                    this.readBuffers = byteBufferArray;
                    if (completionHandler == null) {
                        this.readHandler = null;
                        pendingFuture = new PendingFuture(this, (Object)OpType.READ);
                        this.readFuture = pendingFuture;
                        this.readAttachment = null;
                    } else {
                        this.readHandler = completionHandler;
                        this.readAttachment = a;
                        this.readFuture = null;
                    }
                    if (l > 0L) {
                        this.readTimer = this.port.schedule(this.readTimeoutTask, l, timeUnit);
                    }
                    this.readPending = true;
                    this.updateEvents();
                }
                bl4 = true;
                pendingFuture2 = pendingFuture;
                return pendingFuture2;
            }
            catch (Throwable throwable2) {
                if (throwable2 instanceof ClosedChannelException) {
                    asynchronousCloseException = new AsynchronousCloseException();
                }
                throwable = asynchronousCloseException;
            }
            finally {
                if (!bl4) {
                    this.enableReading();
                }
                this.end();
            }
        }
        Serializable serializable = throwable != null ? null : (asynchronousCloseException = bl ? (Number)Long.valueOf(n) : (Number)n);
        if (completionHandler != null) {
            if (bl2) {
                Invoker.invokeDirect(groupAndInvokeCount, completionHandler, a, asynchronousCloseException, throwable);
            } else {
                Invoker.invokeIndirectly(this, completionHandler, a, asynchronousCloseException, throwable);
            }
            return null;
        }
        return CompletedFuture.withResult(asynchronousCloseException, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishWrite(boolean bl) {
        AsynchronousCloseException asynchronousCloseException;
        int n = -1;
        Throwable throwable = null;
        boolean bl2 = this.isGatheringWrite;
        CompletionHandler<Number, Object> completionHandler = this.writeHandler;
        Object object = this.writeAttachment;
        PendingFuture<Number, Object> pendingFuture = this.writeFuture;
        Future<?> future = this.writeTimer;
        try {
            this.begin();
            n = bl2 ? (int)IOUtil.write(this.fd, this.writeBuffers, nd) : IOUtil.write(this.fd, this.writeBuffer, -1L, nd);
            if (n == -2) {
                Object object2 = this.updateLock;
                synchronized (object2) {
                    this.writePending = true;
                }
                return;
            }
            this.writeBuffer = null;
            this.writeBuffers = null;
            this.writeAttachment = null;
            this.enableWriting();
        }
        catch (Throwable throwable2) {
            this.enableWriting();
            if (throwable2 instanceof ClosedChannelException) {
                asynchronousCloseException = new AsynchronousCloseException();
            }
            throwable = asynchronousCloseException;
        }
        finally {
            if (!(throwable instanceof AsynchronousCloseException)) {
                this.lockAndUpdateEvents();
            }
            this.end();
        }
        if (future != null) {
            future.cancel(false);
        }
        Serializable serializable = throwable != null ? null : (asynchronousCloseException = bl2 ? (Number)Long.valueOf(n) : (Number)n);
        if (completionHandler == null) {
            pendingFuture.setResult((Number)((Object)asynchronousCloseException), throwable);
        } else if (bl) {
            Invoker.invokeUnchecked(completionHandler, object, asynchronousCloseException, throwable);
        } else {
            Invoker.invokeIndirectly(this, completionHandler, object, asynchronousCloseException, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <V extends Number, A> Future<V> implWrite(boolean bl, ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, long l, TimeUnit timeUnit, A a, CompletionHandler<V, ? super A> completionHandler) {
        AsynchronousCloseException asynchronousCloseException;
        Throwable throwable;
        int n;
        boolean bl2;
        Invoker.GroupAndInvokeCount groupAndInvokeCount;
        block17: {
            groupAndInvokeCount = Invoker.getGroupAndInvokeCount();
            bl2 = Invoker.mayInvokeDirect(groupAndInvokeCount, this.port);
            boolean bl3 = completionHandler == null || bl2 || !this.port.isFixedThreadPool();
            n = -2;
            throwable = null;
            boolean bl4 = false;
            try {
                this.begin();
                if (bl3) {
                    n = bl ? (int)IOUtil.write(this.fd, byteBufferArray, nd) : IOUtil.write(this.fd, byteBuffer, -1L, nd);
                }
                if (n != -2) break block17;
                PendingFuture pendingFuture = null;
                PendingFuture pendingFuture2 = this.updateLock;
                synchronized (pendingFuture2) {
                    this.isGatheringWrite = bl;
                    this.writeBuffer = byteBuffer;
                    this.writeBuffers = byteBufferArray;
                    if (completionHandler == null) {
                        this.writeHandler = null;
                        pendingFuture = new PendingFuture(this, (Object)OpType.WRITE);
                        this.writeFuture = pendingFuture;
                        this.writeAttachment = null;
                    } else {
                        this.writeHandler = completionHandler;
                        this.writeAttachment = a;
                        this.writeFuture = null;
                    }
                    if (l > 0L) {
                        this.writeTimer = this.port.schedule(this.writeTimeoutTask, l, timeUnit);
                    }
                    this.writePending = true;
                    this.updateEvents();
                }
                bl4 = true;
                pendingFuture2 = pendingFuture;
                return pendingFuture2;
            }
            catch (Throwable throwable2) {
                if (throwable2 instanceof ClosedChannelException) {
                    asynchronousCloseException = new AsynchronousCloseException();
                }
                throwable = asynchronousCloseException;
            }
            finally {
                if (!bl4) {
                    this.enableWriting();
                }
                this.end();
            }
        }
        Serializable serializable = throwable != null ? null : (asynchronousCloseException = bl ? (Number)Long.valueOf(n) : (Number)n);
        if (completionHandler != null) {
            if (bl2) {
                Invoker.invokeDirect(groupAndInvokeCount, completionHandler, a, asynchronousCloseException, throwable);
            } else {
                Invoker.invokeIndirectly(this, completionHandler, a, asynchronousCloseException, throwable);
            }
            return null;
        }
        return CompletedFuture.withResult(asynchronousCloseException, throwable);
    }

    private static native void checkConnect(int var0) throws IOException;

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.nio.ch.disableSynchronousRead", "false"));
        disableSynchronousRead = string.length() == 0 ? true : Boolean.valueOf(string);
        IOUtil.load();
    }

    private static enum OpType {
        CONNECT,
        READ,
        WRITE;

    }
}

